import { c as createToastStack, a as createToastNotification } from './toast-util-53cae873.js';
import { c as createProgressLoaderContainer } from './progress-loader-util-2abfc50e.js';
import { f as formatDate } from './format-date-util-cbbbafe3.js';

const library = {
  name: 'crayons',
  resolver: (name) => `${CRAYONS_ICONS_ASSET_PATH}/${name}.svg`,
};

//
// System icons are a separate library to ensure they're always available, regardless of how the default icon library is
// configured or if its icons resolve properly.
//
// All Crayons components must use the system library instead of the default library. For visual consistency, system
// icons are a subset of Crayons Icons.
//
const crayons_system_icons = {
  'check': "<svg viewBox='0 0 8 6'><path d='M3 5.87a.7.7 0 0 1-.5-.2L.21 3.41a.707.707 0 1 1 1-1L3 4.18 6.8.33a.71.71 0 0 1 1 0 .69.69 0 0 1 0 1L3.45 5.67a.7.7 0 0 1-.45.2z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'chevron-down': "<svg viewBox='0 0 8 6'><path d='M4 5.35a.74.74 0 0 1-.5-.2L.21 1.85a.707.707 0 1 1 1-1L4 3.66 6.8.85a.707.707 0 0 1 1 1l-3.3 3.3a.74.74 0 0 1-.5.2z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'chevron-up': "<svg viewBox='0 0 8 6'><path d='M7.3 5.35a.74.74 0 0 1-.5-.2L4 2.34 1.2 5.15a.707.707 0 0 1-1-1L3.5.85a.72.72 0 0 1 1 0l3.29 3.3a.7.7 0 0 1-.49 1.2z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'cross-big': "<svg viewBox='0 0 14 14'><path d='M8 7l5.8-5.8a.707.707 0 0 0-1-1L7 6 1.2.21a.707.707 0 0 0-1 1L6 7 .2 12.8a.69.69 0 0 0 0 1 .67.67 0 0 0 .5.2.7.7 0 0 0 .5-.21L7 8l5.8 5.8a.7.7 0 0 0 .5.21.67.67 0 0 0 .49-.21.69.69 0 0 0 0-1L8 7z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'cross': "<svg viewBox='0 0 6 6'><path d='M2.007 2.985L.18 1.17a.707.707 0 1 1 1-1l1.824 1.824L4.83.18a.707.707 0 1 1 1 1L4.006 2.996 5.83 4.82a.71.71 0 0 1-.49 1.2L5.33 6a.7.7 0 0 1-.5-.21L3.013 3.985 1.17 5.82a.7.7 0 0 1-.5.18.71.71 0 0 1-.49-1.2l1.827-1.815z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'drag': "<svg viewBox='0 0 8 16'><path d='M1.55 3.09a1.55 1.55 0 1 1 1.54-1.54c0 .85-.69 1.54-1.54 1.54zm4.9 0A1.55 1.55 0 1 1 8 1.55a1.54 1.54 0 0 1-1.55 1.54zM1.55 16a1.55 1.55 0 1 1 1.54-1.55A1.54 1.54 0 0 1 1.55 16zm4.9 0A1.55 1.55 0 1 1 8 14.45 1.54 1.54 0 0 1 6.45 16zm-4.9-6.45a1.55 1.55 0 1 1-.02-3.1 1.55 1.55 0 0 1 .02 3.1zm4.9 0a1.55 1.55 0 1 1 0-3.1 1.55 1.55 0 0 1 0 3.1z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'error': "<svg viewBox='0 0 16 16'><path d='M8 0a8 8 0 1 0 5.657 2.343A8 8 0 0 0 8 0zm0 14.6A6.6 6.6 0 1 1 14.6 8 6.6 6.6 0 0 1 8 14.6zm2.82-8.43L9 8l1.83 1.83a.707.707 0 0 1-1 1L8 9l-1.83 1.82a.707.707 0 0 1-1-1L7 8 5.18 6.17a.707.707 0 0 1 1-1L8 7l1.83-1.82a.707.707 0 0 1 1 1z' fill='currentColor'/></svg>",
  'image': "<svg viewBox='0 0 14 14'><path d='M11.6 0A2.41 2.41 0 0 1 14 2.4v9.2a2.39 2.39 0 0 1-.66 1.68l-.32.29h-.05a2.22 2.22 0 0 1-.39.23c-.143.06-.29.11-.44.15a2.73 2.73 0 0 1-.5.05h-9.2A3.27 3.27 0 0 1 2 14l-.34-.16-.17-.05-.28-.13-.1-.06a2.61 2.61 0 0 1-.27-.19A2.41 2.41 0 0 1 0 11.6V2.4A2.41 2.41 0 0 1 2.4 0h9.2zm0 12.6a1.19 1.19 0 0 0 .26-.05L8.7 8.34l-2.65 3.59a.7.7 0 0 1-1.12 0l-1-1.33-1.53 2h9.2zm1-1.4l-.03-8.8a1 1 0 0 0-1-1h-9.2a1 1 0 0 0-1 1v9.24l2-2.64a.73.73 0 0 1 1.12 0l1 1.29 2.65-3.54a.73.73 0 0 1 1.12 0l3.34 4.45zM5 2.55a2.41 2.41 0 1 1-.1 4.819A2.41 2.41 0 0 1 5 2.55zM5 6a1 1 0 1 0 0-2 1 1 0 0 0 0 2z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'info': "<svg viewBox='0 0 16 16'><path d='M8 0a8 8 0 1 1 0 16A8 8 0 0 1 8 0zm0 14.6A6.61 6.61 0 0 0 14.6 8 6.6 6.6 0 1 0 8 14.6zM8 6a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm1 4.69v.05a.7.7 0 1 1 0 1.4H7a.7.7 0 0 1 0-1.4h.3V8.39H7a.7.7 0 0 1 0-1.4h1a.7.7 0 0 1 .7.7v3H9z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'more-horizontal': "<svg viewBox='0 0 16 4'><path d='M12.91 2a1.55 1.55 0 1 1 3.1 0 1.55 1.55 0 0 1-3.1 0zM0 2a1.55 1.55 0 1 1 3.1 0A1.55 1.55 0 0 1 0 2zm6.45 0A1.55 1.55 0 1 1 8 3.55 1.56 1.56 0 0 1 6.45 2z' fill='currentColor' fill-rule='evenodd'/></svg>",
  'search': "<svg fill='currentColor' viewBox='0 0 16 16'><path d='M15.29 14.3L12 11a6.39 6.39 0 0 0 1.43-4 6.45 6.45 0 1 0-6.45 6.44A6.38 6.38 0 0 0 11 12l3.33 3.33a.7.7 0 0 0 .5.21.67.67 0 0 0 .49-.21.69.69 0 0 0-.03-1.03zM1.9 6.94a5 5 0 1 1 5 5 5 5 0 0 1-5-5z'/></svg>",
  'settings': "<svg fill='none' viewBox='0 0 20 20'><path fill-rule='evenodd' clip-rule='evenodd' d='M19.465 12.44l-1.48-1.22c.12-.809.12-1.631 0-2.44l1.48-1.22a.71.71 0 0 0 .16-.89l-1.93-3.34a.7.7 0 0 0-.85-.3l-1.8.67a8 8 0 0 0-2.11-1.22l-.32-1.9a.71.71 0 0 0-.69-.58h-3.85a.71.71 0 0 0-.69.58l-.31 1.9a7.74 7.74 0 0 0-2.12 1.22l-1.8-.7a.7.7 0 0 0-.85.3L.375 6.67a.71.71 0 0 0 .16.89l1.48 1.21a8.45 8.45 0 0 0 0 2.46l-1.47 1.21a.7.7 0 0 0-.17.89l1.91 3.34a.7.7 0 0 0 .85.3l1.8-.67a7.738 7.738 0 0 0 2.12 1.22l.31 1.9a.71.71 0 0 0 .69.58h3.85a.7.7 0 0 0 .69-.58l.32-1.9c.76-.3 1.471-.71 2.11-1.22l1.8.67a.72.72 0 0 0 .86-.3l1.92-3.34a.71.71 0 0 0-.14-.89zm-13.72-2.433a4.27 4.27 0 1 1 8.54-.014 4.27 4.27 0 0 1-8.54.014zm1.601 1.098a2.87 2.87 0 0 0 2.659 1.765 2.88 2.88 0 0 0 2.86-2.87 2.87 2.87 0 1 0-5.519 1.105zm7.809 3.725l1.63.61 1.33-2.29-1.34-1.11a.69.69 0 0 1-.24-.68c.09-.448.138-.903.14-1.36a6.895 6.895 0 0 0-.14-1.32.69.69 0 0 1 .24-.68l1.34-1.17-1.33-2.3-1.63.61a.7.7 0 0 1-.72-.14 6.81 6.81 0 0 0-2.34-1.34.71.71 0 0 1-.48-.55l-.28-1.71h-2.67l-.28 1.71a.7.7 0 0 1-.47.55A6.76 6.76 0 0 0 5.565 5a.69.69 0 0 1-.71.16l-1.64-.61-1.33 2.3L3.225 8c.183.16.273.4.24.64a6.68 6.68 0 0 0 0 2.72.72.72 0 0 1-.24.69l-1.34 1.1 1.34 2.32 1.63-.61a.69.69 0 0 1 .71.14 6.761 6.761 0 0 0 2.35 1.34.7.7 0 0 1 .47.55l.29 1.7h2.66l.29-1.71a.68.68 0 0 1 .47-.55 6.81 6.81 0 0 0 2.34-1.36.7.7 0 0 1 .72-.14z' fill='#264966'/></svg>",
  'success': "<svg viewBox='0 0 16 16'><path d='M8 0a8 8 0 1 0 5.657 2.343A8 8 0 0 0 8 0zm0 14.6A6.6 6.6 0 1 1 14.6 8 6.6 6.6 0 0 1 8 14.6zm3.79-9.27a.69.69 0 0 1 0 1l-4.34 4.34a.71.71 0 0 1-1 0L4.21 8.41a.707.707 0 0 1 1-1L7 9.18l3.8-3.85a.71.71 0 0 1 .99 0z' fill='currentColor'/></svg>",
  'warning': "<svg viewBox='0 0 16 16'><path d='M8 0a8 8 0 1 1-8 8 8 8 0 0 1 8-8zm0 1.4A6.6 6.6 0 1 0 14.6 8 6.6 6.6 0 0 0 8 1.4zm.05 8.66a1 1 0 0 1 1.05 1.05 1.05 1.05 0 1 1-1.05-1.05zm.35-5.966a.7.7 0 0 1 .35.606v3.61a.7.7 0 0 1-1.4 0V4.7a.7.7 0 0 1 1.05-.606z' fill='currentColor'/></svg>",
};
const systemLibrary = {
  name: 'system',
  resolver: (name) => {
    if (crayons_system_icons[name]) {
      return `data:image/svg+xml,${encodeURIComponent(crayons_system_icons[name])}`;
    }
    else {
      return '';
    }
  },
};

// Adding Intersection-Observer : fw-icon
const waitUntilVisible = (intersectionObserver, xRootMargin, el, callback) => {
  intersectionObserver = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        intersectionObserver.disconnect();
        intersectionObserver = undefined;
        callback();
      }
    });
  }, { rootMargin: xRootMargin });
  intersectionObserver.observe(el);
};
// Icon fetch-api with memoization :  fw-icon
const iconCache = {};
const requestCache = {};
async function fetchIcon(fetch_asset_path) {
  if (iconCache[fetch_asset_path]) {
    return iconCache[fetch_asset_path];
  }
  if (!requestCache[fetch_asset_path]) {
    requestCache[fetch_asset_path] = fetch(fetch_asset_path)
      .then((resp) => resp.text())
      .then((text) => {
      return text;
    })
      .catch((err) => {
      console.error(`Some exception occured while loading the Assets.${fetch_asset_path}`, err);
      return '';
    });
  }
  iconCache[fetch_asset_path] = await requestCache[fetch_asset_path];
  return iconCache[fetch_asset_path];
}

const parser = new DOMParser();
let registry = [library, systemLibrary];
let watchedIcons = [];
function watchIcon(icon) {
  watchedIcons.push(icon);
}
function unwatchIcon(icon) {
  watchedIcons = watchedIcons.filter((el) => el !== icon);
}
function getIconLibrary(name) {
  return registry.find((lib) => lib.name === name);
}
async function getSVGElement(url) {
  try {
    const div = document.createElement('div');
    div.innerHTML = await fetchIcon(url);
    if (div.innerHTML.indexOf('</svg>') === -1)
      throw new Error(`Asset not found or Network Issue`);
    const svgEle = div.firstElementChild;
    const svg = svgEle && svgEle.tagName.toLowerCase() === 'svg' ? svgEle.outerHTML : '';
    const doc = parser.parseFromString(svg, 'text/html');
    return doc.body.querySelector('svg');
  }
  catch (e) {
    throw new Error(`Error while creating SVG Element. It can be due to corrupt/missing SVG Source. : ${e.message}`);
  }
}
function registerIconLibrary(name, options) {
  try {
    if (name !== 'crayons' && name !== 'system') {
      unregisterIconLibrary(name);
      registry.push({
        name,
        resolver: options.resolver,
        mutator: options.mutator,
      });
      // Re-render watched icons
      watchedIcons.map((icon) => {
        if (icon.library === name) {
          icon.redrawIcon();
        }
      });
    }
    else {
      throw new Error('You cannot register libraries with name "crayons" | "system". Please register with different name.');
    }
  }
  catch (e) {
    console.error(e.message);
    return;
  }
}
function unregisterIconLibrary(name) {
  registry = registry.filter((lib) => lib.name !== name);
}

/** use this file for exposing global functions and ways to set global config **/
function ToastController(config = { position: 'top-center' }) {
  const toastContainer = createToastStack(config);
  function trigger(opts) {
    createToastNotification(opts, toastContainer, config);
  }
  return { trigger };
}
function ProgressLoaderController(config) {
  return createProgressLoaderContainer(config);
}
function DateFormatController({ date, locale, options, } = {
  date: new Date(),
  locale: [],
  options: {},
}) {
  return formatDate({ date, locale, options });
}
const CRAYONS_ICONS_ASSET_PATH = 'https://cdn.jsdelivr.net/npm/@freshworks/crayons-icon@next/dist/icons';

export { DateFormatController as D, ProgressLoaderController as P, ToastController as T, waitUntilVisible as a, unwatchIcon as b, getIconLibrary as c, fetchIcon as f, getSVGElement as g, registerIconLibrary as r, unregisterIconLibrary as u, watchIcon as w };
