import { E2EElement, newE2EPage } from '@stencil/core/testing';
import presetSchema from './assets/form-builder-preset.json';
import formMapper from './assets/form-mapper.json';

describe('fw-form-builder', () => {
  function getNestedKeyValueFromObject(objSource, strKey) {
    try {
      if (!strKey) {
        return '';
      }
      return strKey?.split('.').reduce((r, val) => {
        return r ? r[val] : undefined;
      }, objSource);
    } catch (error) {
      console.error(`Error occurred in getNestedKeyValueFromObject: ${error}`);
    }
    return '';
  }

  const formValues: any = {
    CUSTOM_OBJECTS: {
      name: 'Company-Association-test',
      prefix: '_29',
      title: null,
      description: 'Company-Association-test',
      version: 4,
      deleted: false,
      id: 5938,
      form_options: {},
      created_time: 1659001461188,
      updated_time: 1659004708385,
      icon_link: 'https://d2lz1e868xzctj.cloudfront.net/icons/Accounts.svg',
      fields: [
        {
          id: '24a9531c-3c71-463e-9c63-8991396fde95',
          name: 'companyassociationtestname',
          label: 'Hotel Name',
          type: 'PRIMARY',
          required: true,
          field_options: {
            _analytic: 'true',
            _primary: 'true',
            unique: 'true',
          },
          filterable: true,
          searchable: true,
        },
        {
          id: 'eea9ed82-af63-43b2-aef0-a7e8de0f8607',
          name: 'companytest',
          label: 'Location',
          type: 'RELATIONSHIP',
          required: false,
          field_options: {
            _analytic: 'true',
            related_object_type: 'NATIVE',
            unique: 'false',
          },
          filterable: true,
          searchable: false,
          related_entity_id: 3,
          relationship_name: 'companytest',
          child_relationship_name: 'companyassociationtest_1659004707038',
        },
        {
          id: '7c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'address',
          label: 'Address',
          type: 'TEXT',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '8c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'summary',
          label: 'Summary',
          type: 'PARAGRAPH',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '9c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'count',
          label: 'Count',
          type: 'NUMBER',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '88c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'price',
          label: 'Price',
          type: 'DECIMAL',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '667ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'date',
          label: 'Date',
          type: 'DATE',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '9d7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'preference',
          label: 'Preference',
          type: 'DROPDOWN',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '127ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'access',
          label: 'Access',
          type: 'CHECKBOX',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '128ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'people',
          label: 'People',
          type: 'MULTI_SELECT',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
      ],
    },
    CONVERSATION_PROPERTIES: {
      name: 'Company-Association-test',
      prefix: '_29',
      title: null,
      description: 'Company-Association-test',
      version: 4,
      deleted: false,
      id: 5938,
      form_options: {},
      created_time: 1659001461188,
      updated_time: 1659004708385,
      icon_link: 'https://d2lz1e868xzctj.cloudfront.net/icons/Accounts.svg',
      fields: [
        {
          id: '7c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'address',
          label: 'Address',
          type: '1',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '8c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'summary',
          label: 'Summary',
          type: '6',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '9c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'count',
          label: 'Count',
          type: '8',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '88c7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'price',
          label: 'Price',
          type: '13',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '667ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'date',
          label: 'Date',
          type: '17',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '9d7ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'preference',
          label: 'Preference',
          type: '2',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: '127ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'access',
          label: 'Access',
          type: '5',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
        {
          id: 'eea9ed82-af63-43b2-aef0-a7e8de0f8607',
          name: 'location',
          label: 'Location',
          type: '16',
          required: false,
          field_options: {
            _analytic: 'true',
            unique: 'false',
          },
          filterable: true,
          searchable: false,
          related_entity_id: 3,
          relationship_name: 'location',
          child_relationship_name: 'location_1659004707038',
        },
        {
          id: '128ce74f-07f9-406a-bd18-bef23a5306a1',
          name: 'people',
          label: 'People',
          type: '18',
          required: false,
          field_options: {},
          filterable: true,
          searchable: false,
        },
      ],
    },
    CONV_MAX: {
      docId: '34812d27-6455-4eb4-8654-cd2c4cd0ed5d',
      form_id: '0',
      bundle_id: ['555741949072343098'],
      coll_id: 'ConversationForm',
      prod_id: 'freshchat',
      organisation_id: '555741948833267800',
      name: 'Conversation Form',
      account_id: '721079537498489',
      title: 'Conversation Form',
      description: 'This is a conversation form',
      deleted: false,
      active: true,
      compressed: false,
      form_options: {
        unique_attributes: 'name, column_name, label',
      },
      version: 46,
      fields: [
        {
          id: '0395c89a-ff56-49a0-a393-79bf48d8b65c',
          name: 'group',
          column_name: 'group',
          label: 'Group',
          type: 2,
          field_options: {
            reference: 'true',
            option_value_path: 'id',
            option_label_path: 'value',
          },
          custom: false,
          editable: true,
          position: 49,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 13:20:09',
          updated_at: '2023-03-14 13:20:09',
        },
        {
          id: '4747b941-a2cf-45ef-9118-d4007826fa92',
          name: 'agent',
          column_name: 'agent',
          label: 'Agent',
          type: 2,
          field_options: {
            reference: 'true',
            option_value_path: 'id',
            option_label_path: 'value',
          },
          custom: false,
          editable: true,
          position: 50,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 13:20:09',
          updated_at: '2023-03-14 13:20:09',
        },
        {
          id: 'e189019d-ac50-4852-a17f-97acf2b05582',
          name: 'status',
          column_name: 'status',
          label: 'Status',
          type: 2,
          field_options: {
            option_value_path: 'id',
            option_label_path: 'value',
          },
          custom: false,
          editable: true,
          position: 51,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [
            {
              id: '0',
              account_id: '0',
              internal_name: 'open',
              value: 'Open',
              choice_options: {},
              field_id: 'e189019d-ac50-4852-a17f-97acf2b05582',
              position: 1,
            },
            {
              id: '5',
              account_id: '0',
              internal_name: 'waiting_on_customer',
              value: 'Waiting on customer',
              choice_options: {
                resolution_timer: true,
                pause_resolution_sla_timer: true,
              },
              field_id: 'e189019d-ac50-4852-a17f-97acf2b05582',
              position: 2,
            },
            {
              id: '6',
              account_id: '0',
              internal_name: 'waiting_on_internal_teams',
              value: 'Waiting on internal teams',
              choice_options: {
                resolution_timer: true,
                pause_resolution_sla_timer: true,
              },
              field_id: 'e189019d-ac50-4852-a17f-97acf2b05582',
              position: 3,
            },
            {
              id: '2',
              account_id: '0',
              internal_name: 'resolved',
              value: 'Resolved',
              choice_options: {},
              field_id: 'e189019d-ac50-4852-a17f-97acf2b05582',
              position: 4,
            },
          ],
          fields: [],
          regex: {},
          default_value: '0',
          created_at: '2023-03-14 13:20:09',
          updated_at: '2023-03-14 13:20:09',
        },
        {
          id: '8df0849d-f09a-448b-b697-b3fc864fb133',
          name: 'priority',
          column_name: 'priority',
          label: 'Priority',
          type: 2,
          field_options: {
            option_value_path: 'id',
            option_label_path: 'value',
          },
          custom: false,
          editable: true,
          position: 52,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [
            {
              id: '1',
              account_id: '0',
              internal_name: 'low',
              value: 'Low',
              field_id: '8df0849d-f09a-448b-b697-b3fc864fb133',
              position: 1,
            },
            {
              id: '2',
              account_id: '0',
              internal_name: 'medium',
              value: 'Medium',
              field_id: '8df0849d-f09a-448b-b697-b3fc864fb133',
              position: 2,
            },
            {
              id: '3',
              account_id: '0',
              internal_name: 'high',
              value: 'High',
              field_id: '8df0849d-f09a-448b-b697-b3fc864fb133',
              position: 3,
            },
            {
              id: '4',
              account_id: '0',
              internal_name: 'urgent',
              value: 'Urgent',
              field_id: '8df0849d-f09a-448b-b697-b3fc864fb133',
              position: 4,
            },
          ],
          fields: [],
          regex: {},
          default_value: '1',
          created_at: '2023-03-14 13:20:09',
          updated_at: '2023-03-14 13:20:09',
        },
        {
          id: 'b6fafdb8-82be-43cd-82de-3b4b7d48df57',
          name: 'cf_type',
          column_name: 'cf_type',
          label: 'Type',
          type: 2,
          field_options: {
            option_value_path: 'id',
            option_label_path: 'value',
          },
          custom: true,
          editable: true,
          position: 53,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [
            {
              id: 'e06ce911-34c5-4643-ae8e-20fa7b12a4b4',
              account_id: '0',
              internal_name: 'general_query',
              value: 'General Query',
              field_id: 'b6fafdb8-82be-43cd-82de-3b4b7d48df57',
              position: 1,
            },
            {
              id: 'e04f8357-081d-4dac-9114-55f167526b8f',
              account_id: '0',
              internal_name: 'technical_query',
              value: 'Technical Query',
              field_id: 'b6fafdb8-82be-43cd-82de-3b4b7d48df57',
              position: 2,
            },
            {
              id: 'f5e48fc2-87b5-4370-b552-ae0329055e9d',
              account_id: '0',
              internal_name: 'feature_request',
              value: 'Feature Request',
              field_id: 'b6fafdb8-82be-43cd-82de-3b4b7d48df57',
              position: 3,
            },
            {
              id: '11ecae26-846f-4428-b67d-354735d3bd22',
              account_id: '0',
              internal_name: 'feedback',
              value: 'Feedback',
              field_id: 'b6fafdb8-82be-43cd-82de-3b4b7d48df57',
              position: 4,
            },
          ],
          fields: [],
          regex: {},
          created_at: '2023-03-14 13:20:09',
          updated_at: '2023-03-14 13:20:09',
        },
        {
          id: '0a3cbca8-6e50-4967-9502-1335ad653f10',
          name: 'cf_Automation_Field_Date20230314200118',
          column_name: 'cf_date001',
          label: 'Automation_Field_Date20230314200118',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 54,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:20',
          updated_at: '2023-03-14 14:31:20',
        },
        {
          id: 'f646f9c0-47db-4213-9fe7-866a0c4edb2a',
          name: 'cf_Automation_Field_Date20230314200119',
          column_name: 'cf_date002',
          label: 'Automation_Field_Date20230314200119',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 55,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:21',
          updated_at: '2023-03-14 14:31:21',
        },
        {
          id: '0eb90202-7900-4bcb-b9e6-c22f000932af',
          name: 'cf_Automation_Field_Date20230314200121',
          column_name: 'cf_date003',
          label: 'Automation_Field_Date20230314200121',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 56,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:22',
          updated_at: '2023-03-14 14:31:22',
        },
        {
          id: 'e2be3db2-9d2b-438f-80e3-2e5ce0b8a1ec',
          name: 'cf_Automation_Field_Date20230314200122',
          column_name: 'cf_date004',
          label: 'Automation_Field_Date20230314200122',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 57,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:24',
          updated_at: '2023-03-14 14:31:24',
        },
        {
          id: '8e16478c-e61b-4d49-a806-d5c87e349370',
          name: 'cf_Automation_Field_Date20230314200123',
          column_name: 'cf_date005',
          label: 'Automation_Field_Date20230314200123',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 58,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:25',
          updated_at: '2023-03-14 14:31:25',
        },
        {
          id: '1a3fbebb-5bf9-4984-bc14-7fe53b1747ad',
          name: 'cf_Automation_Field_Date20230314200125',
          column_name: 'cf_date006',
          label: 'Automation_Field_Date20230314200125',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 59,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:27',
          updated_at: '2023-03-14 14:31:27',
        },
        {
          id: '5b50b59d-fa43-44d8-acf6-5dc7e9da18fa',
          name: 'cf_Automation_Field_Date20230314200126',
          column_name: 'cf_date007',
          label: 'Automation_Field_Date20230314200126',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 60,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:28',
          updated_at: '2023-03-14 14:31:28',
        },
        {
          id: '212166a0-59dc-4b3d-a912-25bac899a084',
          name: 'cf_Automation_Field_Date20230314200128',
          column_name: 'cf_date008',
          label: 'Automation_Field_Date20230314200128',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 61,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:29',
          updated_at: '2023-03-14 14:31:29',
        },
        {
          id: '944e446a-486f-48c3-8f47-cbf280d07abe',
          name: 'cf_Automation_Field_Date20230314200129',
          column_name: 'cf_date009',
          label: 'Automation_Field_Date20230314200129',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 62,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:31',
          updated_at: '2023-03-14 14:31:31',
        },
        {
          id: '7e8860a6-d301-412e-ad53-04e643e874be',
          name: 'cf_Automation_Field_Date20230314200130',
          column_name: 'cf_date010',
          label: 'Automation_Field_Date20230314200130',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 63,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:32',
          updated_at: '2023-03-14 14:31:32',
        },
        {
          id: '286cfb75-ccdb-4102-bd12-2f0306113e2d',
          name: 'cf_Automation_Field_Date20230314200132',
          column_name: 'cf_date011',
          label: 'Automation_Field_Date20230314200132',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 64,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:33',
          updated_at: '2023-03-14 14:31:33',
        },
        {
          id: '75bd36c1-153f-45b9-a733-a805d6942aef',
          name: 'cf_Automation_Field_Date20230314200133',
          column_name: 'cf_date012',
          label: 'Automation_Field_Date20230314200133',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 65,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:35',
          updated_at: '2023-03-14 14:31:35',
        },
        {
          id: '9aa027f3-eb75-42f2-acec-23387943cadb',
          name: 'cf_Automation_Field_Date20230314200134',
          column_name: 'cf_date013',
          label: 'Automation_Field_Date20230314200134',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 66,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:36',
          updated_at: '2023-03-14 14:31:36',
        },
        {
          id: '22ed5103-c3d3-4a4e-ba6d-58a99d1e3df0',
          name: 'cf_Automation_Field_Date20230314200136',
          column_name: 'cf_date014',
          label: 'Automation_Field_Date20230314200136',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 67,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:37',
          updated_at: '2023-03-14 14:31:37',
        },
        {
          id: '0511635c-f396-47fc-97e2-73ec75e44b6a',
          name: 'cf_Automation_Field_Date20230314200137',
          column_name: 'cf_date015',
          label: 'Automation_Field_Date20230314200137',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 68,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:39',
          updated_at: '2023-03-14 14:31:39',
        },
        {
          id: 'cae51f9c-0981-436f-9500-f1d7a257b6c2',
          name: 'cf_Automation_Field_Date20230314200139',
          column_name: 'cf_date016',
          label: 'Automation_Field_Date20230314200139',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 69,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:40',
          updated_at: '2023-03-14 14:31:40',
        },
        {
          id: 'b80747f9-29a0-4a7a-8e1f-714997579508',
          name: 'cf_Automation_Field_Date20230314200140',
          column_name: 'cf_date017',
          label: 'Automation_Field_Date20230314200140',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 70,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:42',
          updated_at: '2023-03-14 14:31:42',
        },
        {
          id: 'b4e90294-00a9-4618-840d-a2bd9e9070cc',
          name: 'cf_Automation_Field_Date20230314200141',
          column_name: 'cf_date018',
          label: 'Automation_Field_Date20230314200141',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 71,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:43',
          updated_at: '2023-03-14 14:31:43',
        },
        {
          id: '91263d14-6b77-4bdd-83c0-9beb9199f37e',
          name: 'cf_Automation_Field_Date20230314200143',
          column_name: 'cf_date019',
          label: 'Automation_Field_Date20230314200143',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 72,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:44',
          updated_at: '2023-03-14 14:31:44',
        },
        {
          id: 'a6b93761-9462-49ba-8fce-4f216f287625',
          name: 'cf_Automation_Field_Date20230314200144',
          column_name: 'cf_date020',
          label: 'Automation_Field_Date20230314200144',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 73,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:46',
          updated_at: '2023-03-14 14:31:46',
        },
        {
          id: '31e45af6-1fa5-4d56-997f-9a9096fa88a2',
          name: 'cf_Automation_Field_Date20230314200145',
          column_name: 'cf_date021',
          label: 'Automation_Field_Date20230314200145',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 74,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:47',
          updated_at: '2023-03-14 14:31:47',
        },
        {
          id: 'f2aea8b6-88c9-49d3-84bd-102b856213fa',
          name: 'cf_Automation_Field_Date20230314200147',
          column_name: 'cf_date022',
          label: 'Automation_Field_Date20230314200147',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 75,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:48',
          updated_at: '2023-03-14 14:31:48',
        },
        {
          id: '7e5a6226-8016-4efe-896d-a86a5ff4a7e6',
          name: 'cf_Automation_Field_Date20230314200148',
          column_name: 'cf_date023',
          label: 'Automation_Field_Date20230314200148',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 76,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:50',
          updated_at: '2023-03-14 14:31:50',
        },
        {
          id: '1f5eba80-55fc-4f0c-b187-a2557a0ec3d5',
          name: 'cf_Automation_Field_Date20230314200149',
          column_name: 'cf_date024',
          label: 'Automation_Field_Date20230314200149',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 77,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:51',
          updated_at: '2023-03-14 14:31:51',
        },
        {
          id: '4688fbec-c8e5-4457-b197-ad5f2fc71275',
          name: 'cf_Automation_Field_Date20230314200151',
          column_name: 'cf_date025',
          label: 'Automation_Field_Date20230314200151',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 78,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:53',
          updated_at: '2023-03-14 14:31:53',
        },
        {
          id: 'e7917da6-9a7c-45de-82a6-cb51c3c6651a',
          name: 'cf_Automation_Field_Date20230314200153',
          column_name: 'cf_date026',
          label: 'Automation_Field_Date20230314200153',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 79,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:54',
          updated_at: '2023-03-14 14:31:54',
        },
        {
          id: '60a94ca8-8660-455f-9732-68cd6df8dc1a',
          name: 'cf_Automation_Field_Date20230314200154',
          column_name: 'cf_date027',
          label: 'Automation_Field_Date20230314200154',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 80,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:56',
          updated_at: '2023-03-14 14:31:56',
        },
        {
          id: 'a6091a0c-260d-4a85-b97e-d05d09af69d6',
          name: 'cf_Automation_Field_Date20230314200155',
          column_name: 'cf_date028',
          label: 'Automation_Field_Date20230314200155',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 81,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:57',
          updated_at: '2023-03-14 14:31:57',
        },
        {
          id: 'b86ee757-5c18-4c6d-a277-6fd20465a266',
          name: 'cf_Automation_Field_Date20230314200157',
          column_name: 'cf_date029',
          label: 'Automation_Field_Date20230314200157',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 82,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:31:58',
          updated_at: '2023-03-14 14:31:58',
        },
        {
          id: 'e93dcead-c8c9-4447-8a66-50f08dc6a234',
          name: 'cf_Automation_Field_Date20230314200158',
          column_name: 'cf_date030',
          label: 'Automation_Field_Date20230314200158',
          type: 17,
          field_options: {},
          custom: true,
          editable: true,
          position: 83,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:00',
          updated_at: '2023-03-14 14:32:00',
        },
        {
          id: 'f4bd6c99-d60a-4f3a-96e6-1323c3bf54ca',
          name: 'cf_Automation_Field_Decimel20230314200236',
          column_name: 'cf_decimal001',
          label: 'Automation_Field_Decimel20230314200236',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 84,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:38',
          updated_at: '2023-03-14 14:32:38',
        },
        {
          id: '19680ca2-69b2-4c59-a56a-4188a15190ea',
          name: 'cf_sdsdds',
          column_name: 'cf_boolean001',
          label: 'sdsdds',
          type: 5,
          field_options: {
            unique: 'false',
            required_on_resolve: 'false',
          },
          custom: true,
          editable: true,
          position: 85,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:57',
          updated_at: '2023-03-14 14:32:57',
        },
        {
          id: '4d804b91-9963-4a30-b5b0-957c52552141',
          name: 'cf_checkboaas',
          column_name: 'cf_boolean004',
          label: 'checkboaas',
          type: 5,
          field_options: {
            unique: 'false',
            required_on_resolve: 'false',
          },
          custom: true,
          editable: true,
          position: 86,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:33:15',
          updated_at: '2023-03-14 14:33:15',
        },
        {
          id: '56689136-1c8e-4915-9f8e-f423b7de4991',
          name: 'cf_heyhasas',
          column_name: 'cf_boolean005',
          label: 'heyhasas',
          type: 5,
          field_options: {
            unique: 'false',
            required_on_resolve: 'false',
          },
          custom: true,
          editable: true,
          position: 87,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:33:21',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '8937a82b-e632-477d-8a7d-17e0d7c8cf17',
          name: 'cf_heye',
          column_name: 'cf_boolean003',
          label: 'heye',
          type: 5,
          field_options: {
            unique: 'false',
            required_on_resolve: 'false',
          },
          custom: true,
          editable: true,
          position: 88,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:33:09',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '3c626a62-31a7-4b12-b8ed-1e8856140b56',
          name: 'cf_sdsdds1',
          column_name: 'cf_boolean002',
          label: 'sdsdds1',
          type: 5,
          field_options: {
            unique: 'false',
            required_on_resolve: 'false',
          },
          custom: true,
          editable: true,
          position: 89,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:33:03',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: 'e730c7d8-3e84-4887-8e8e-c555fc5e8d3a',
          name: 'cf_Automation_Field_Decimel20230314200238',
          column_name: 'cf_decimal002',
          label: 'Automation_Field_Decimel20230314200238',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 90,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:40',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: 'b1bc1bc8-1739-4c3e-bab6-b9430a8c667e',
          name: 'cf_Automation_Field_Decimel20230314200239',
          column_name: 'cf_decimal003',
          label: 'Automation_Field_Decimel20230314200239',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 91,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:41',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '6f5c9731-11a9-4f5c-806b-4f20859fca76',
          name: 'cf_Automation_Field_Decimel20230314200241',
          column_name: 'cf_decimal004',
          label: 'Automation_Field_Decimel20230314200241',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 92,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:42',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '3fa7c883-aeee-415c-bc00-a45d1a7a36aa',
          name: 'cf_Automation_Field_Decimel20230314200242',
          column_name: 'cf_decimal005',
          label: 'Automation_Field_Decimel20230314200242',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 93,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:44',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: 'a2dc05cf-985e-47da-b6d2-8fedb426b8fc',
          name: 'cf_Automation_Field_Decimel20230314200243',
          column_name: 'cf_decimal006',
          label: 'Automation_Field_Decimel20230314200243',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 94,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:45',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '20f19932-0615-406d-9fc2-35d000e8e8d0',
          name: 'cf_Automation_Field_Decimel20230314200245',
          column_name: 'cf_decimal007',
          label: 'Automation_Field_Decimel20230314200245',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 95,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:47',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '91b77f10-39b0-4903-a8f5-384dee4133bf',
          name: 'cf_Automation_Field_Decimel20230314200246',
          column_name: 'cf_decimal008',
          label: 'Automation_Field_Decimel20230314200246',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 96,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:48',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: 'c8bda7a0-319d-49cf-9e91-5f23dac687e4',
          name: 'cf_Automation_Field_Decimel20230314200248',
          column_name: 'cf_decimal009',
          label: 'Automation_Field_Decimel20230314200248',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 97,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:49',
          updated_at: '2023-03-14 14:33:21',
        },
        {
          id: '74998b25-947c-48a2-b4eb-a42c497c599d',
          name: 'cf_Automation_Field_Decimel20230314200249',
          column_name: 'cf_decimal010',
          label: 'Automation_Field_Decimel20230314200249',
          type: 13,
          field_options: {},
          custom: true,
          editable: true,
          position: 98,
          deleted: false,
          required: false,
          visible: true,
          column_type_blob: false,
          nodegroup_skip: false,
          validatable: false,
          builder: false,
          internal: false,
          choices: [],
          fields: [],
          regex: {},
          created_at: '2023-03-14 14:32:51',
          updated_at: '2023-03-14 14:33:21',
        },
      ],
      created_at: '2023-03-14 13:20:09',
      updated_at: '2023-03-14 14:33:21',
    },
  };

  it('renders', async () => {
    const page = await newE2EPage();

    await page.setContent('<fw-form-builder></fw-form-builder>');
    const element = await page.find('fw-form-builder');
    expect(element).toHaveClass('hydrated');
  });

  describe.each(['CUSTOM_OBJECTS', 'CONVERSATION_PROPERTIES'])(
    'test %s fields',
    (productName) => {
      let fieldOrder = [...formMapper[productName].fieldOrder];
      if (productName === 'CUSTOM_OBJECTS') {
        fieldOrder = fieldOrder.slice(1);
      }
      let testIndex = -1;
      it.each(fieldOrder)(
        'clicking on add %s field triggers fwComposeNewField event with the expected detail',
        async (field) => {
          testIndex++;
          const page = await newE2EPage();

          await page.setContent(
            `<fw-form-builder product-name="${productName}"></fw-form-builder>`
          );
          const fwComposeNewField = await page.spyOnEvent('fwComposeNewField');
          const leftPanel = await page.find(
            'fw-form-builder >>> .form-builder-left-panel'
          );
          const fieldItems = await leftPanel.findAll(
            '.form-builder-left-panel-field-types-list > fw-field-type-menu-item >>> .field-type-menu-item-add-button-container'
          );
          expect(fieldItems.length).toBe(fieldOrder.length);
          await fieldItems[testIndex].click();
          await page.waitForChanges();
          expect(fwComposeNewField).toHaveReceivedEventDetail({
            maximumLimits: formMapper[productName].maximumLimits,
            fieldSchema: {
              ...presetSchema.fieldTypes[field],
              checkboxes:
                formMapper[productName].fieldProps[field].checkboxes || null,
              type:
                productName === 'CUSTOM_OBJECTS'
                  ? field
                  : formMapper[productName].mappedFieldTypes[field],
            },
            value: presetSchema.fieldTypes[field],
            index: -1,
          });
        }
      );

      it('opens a modal on click of delete button and on confirmation, emits fwDeleteField event with event details', async () => {
        const page = await newE2EPage();
        await page.setContent(
          `<fw-form-builder product-name="${productName}"></fw-form-builder>`
        );
        const fwDeleteField = await page.spyOnEvent('fwDeleteField');
        await page.waitForChanges();
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues }: any) => {
            elm.formValues = formValues;
          },
          { formValues: formValues.CUSTOM_OBJECTS }
        );
        await page.waitForChanges();

        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );
        const fieldDragDropItem = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );
        const fieldEditor = await fieldDragDropItem[1].find(
          'fw-field-editor >>> .fw-field-editor'
        );
        const deleteBtn = await fieldEditor.find(
          '.fw-field-editor-delete-button'
        );
        await deleteBtn.click();
        await page.waitForChanges();
        const deleteModal = await fieldDragDropItem[1].find(
          'fw-field-editor >>> fw-modal'
        );
        expect(deleteModal).toHaveAttribute('is-open');
        await deleteModal.triggerEvent('fwSubmit');
        await page.waitForChanges();
        expect(fwDeleteField).toHaveReceivedEventDetail({
          index: 1,
        });
      });

      it('renders form values in right panel', async () => {
        const page = await newE2EPage();

        await page.setContent(
          `<fw-form-builder product-name="${productName}"></fw-form-builder>`
        );
        await page.waitForChanges();
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues }: any) => {
            elm.formValues = formValues;
          },
          { formValues: formValues[productName] }
        );
        await page.waitForChanges();
        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );

        const fieldDragDropItem: E2EElement[] = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );

        let fieldItemLabelsCount = 0;

        for (const dragDrop of fieldDragDropItem) {
          const fieldItemLabel = await dragDrop.find(
            'fw-field-editor >>> label'
          );

          expect(fieldItemLabel.innerText).toBe(
            formValues[productName].fields[fieldItemLabelsCount++].label
          );
        }

        expect(fieldItemLabelsCount).toBe(
          formValues[productName].fields.length
        );

        let fieldItemIcons = 0;

        for (const dragDrop of fieldDragDropItem) {
          const fieldItemIcon = await dragDrop.find(
            'fw-field-editor >>> .fw-field-editor-icon-container > fw-icon'
          );
          const fieldType =
            productName === 'CUSTOM_OBJECTS'
              ? formValues[productName].fields[fieldItemIcons].type
              : formMapper[productName].reverseMappedFieldTypes[
                  formValues[productName].fields[fieldItemIcons].type
                ];
          expect(fieldItemIcon.getAttribute('name')).toBe(
            presetSchema.fieldTypes[fieldType].icon.name
          );
          fieldItemIcons++;
        }

        expect(fieldItemIcons).toBe(formValues[productName].fields.length);
      });

      it('searching a value should filter the field elements', async () => {
        const page = await newE2EPage();

        await page.setContent(
          `<fw-form-builder product-name="${productName}"></fw-form-builder>`
        );
        await page.waitForChanges();
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues }: any) => {
            elm.formValues = formValues;
          },
          { formValues: formValues[productName] }
        );
        await page.waitForChanges();
        const search = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-header-search-input'
        );
        await search.click();
        await search.press('a');
        await search.press('d');
        await search.press('d');
        await page.waitForChanges();
        await page.waitForTimeout(2000);
        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );
        const fieldDragDropItem: E2EElement[] = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );
        const fieldItemLabels = await fieldDragDropItem[0].findAll(
          'fw-field-editor >>> label'
        );

        expect(fieldItemLabels.length).toBe(1);
        const addressIndex = productName === 'CUSTOM_OBJECTS' ? 2 : 0;
        expect(fieldItemLabels[0].innerText).toBe(
          formValues[productName].fields[addressIndex].label
        );
      });

      it('triggers fwSaveField event when a field is edited and save is clicked', async () => {
        const page = await newE2EPage();
        await page.setContent(
          `<fw-form-builder product-name="${productName}"></fw-form-builder>`
        );
        const fwSaveField = await page.spyOnEvent('fwSaveField');
        const validateIndex = 2;

        await page.waitForChanges();
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues, currentFieldIndex }: any) => {
            elm.formValues = formValues;
            elm.currentFieldIndex = currentFieldIndex;
          },
          {
            formValues: formValues[productName],
            currentFieldIndex: {
              [formValues[productName].fields[validateIndex].id]: validateIndex,
            },
          }
        );
        await page.waitForChanges();
        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );
        const fieldDragDropItem = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );
        const fieldEditor = await fieldDragDropItem[2].find(
          'fw-field-editor >>> .fw-field-editor'
        );
        const labelInput = await fieldEditor.find(
          '.fw-field-editor-content-required-input'
        );
        await labelInput.click();
        await labelInput.press('a');
        await labelInput.press('d');
        await page.waitForChanges();
        const saveBtn = await fieldEditor.find('#submitFieldBtn');
        await saveBtn.click();
        await page.waitForChanges();
        const expectedType = isNaN(formValues[productName].fields[2].type)
          ? formValues[productName].fields[2].type
          : parseInt(formValues[productName].fields[2].type);
        expect(fwSaveField).toHaveReceivedEventDetail({
          index: 2,
          isNew: false,
          value: {
            ...(productName === 'CUSTOM_OBJECTS'
              ? { filterable: formValues[productName].fields[2].filterable }
              : {}),
            internalName: formValues[productName].fields[2].name,
            isPrimaryField: false,
            name: 'ad' + formValues[productName].fields[2].label,
            required: false,
            type: expectedType,
            newSectionData: {
              field_options: {},
              filterable: true,
              id: formValues[productName].fields[2].id,
              label: formValues[productName].fields[2].label,
              name: formValues[productName].fields[2].name,
              required: false,
              searchable: false,
              type:
                productName === 'CUSTOM_OBJECTS'
                  ? expectedType
                  : formMapper.CONVERSATION_PROPERTIES.reverseMappedFieldTypes[
                      expectedType
                    ],
            },
            sectionDetails: {},
          },
        });
      });

      it('validates choices and label field in field editor', async () => {
        const page = await newE2EPage();
        await page.setContent(
          `<fw-form-builder product-name="${productName}"></fw-form-builder>`
        );
        await page.waitForChanges();
        const validateIndex = formValues[productName].fields.length - 1;
        const id = formValues[productName].fields[validateIndex].id;
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues, currentFieldIndex }: any) => {
            elm.formValues = formValues;
            elm.currentFieldIndex = currentFieldIndex;
          },
          {
            formValues: formValues[productName],
            currentFieldIndex: { [id]: validateIndex },
          }
        );
        await page.waitForChanges();
        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );
        const fieldDragDropItem = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );
        const fieldEditor = await fieldDragDropItem[validateIndex].find(
          'fw-field-editor >>> .fw-field-editor'
        );
        const labelInput = await fieldEditor.find(
          '.fw-field-editor-content-required-input'
        );
        await labelInput.click();
        await labelInput.press('a');
        await page.waitForChanges();
        let saveBtn = await fieldEditor.find('#submitFieldBtn');
        await saveBtn.click();
        await page.waitForChanges();
        const errorValidation = await fieldEditor.find(
          '.fw-field-editor-footer-field-error-msg'
        );
        expect(errorValidation).toBeTruthy();
        await labelInput.setProperty('value', '');
        await page.waitForChanges();
        saveBtn = await fieldEditor.find('#submitFieldBtn');
        await saveBtn.click();
        await page.waitForChanges();
        const errorText = await fieldEditor.find(
          '.fw-field-editor-content-required-input >>> .field-control-error-text'
        );
        expect(errorText).toBeTruthy();
      });
    }
  );

  it('renders customize widget button', async () => {
    const page = await newE2EPage();

    await page.setContent('<fw-form-builder></fw-form-builder>');
    const element = await page.find(
      'fw-form-builder >>> #customizeWidgetFieldsBtn'
    );
    expect(element).toBeTruthy();
  });

  it('does not render customize widget button if productName is CONVERSATION_PROPERTIES', async () => {
    const page = await newE2EPage();

    await page.setContent(
      '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
    );
    const element = await page.find(
      'fw-form-builder >>> #customizeWidgetFieldsBtn'
    );
    expect(element).toBeFalsy();
  });

  it('RELATIONSHIP field should not be shown when showLookupField is false', async () => {
    const page = await newE2EPage();

    await page.setContent(
      `<fw-form-builder show-lookup-field=false product-name="CONVERSATION_PROPERTIES"></fw-form-builder>`
    );

    const leftPanel = await page.find(
      'fw-form-builder >>> .form-builder-left-panel'
    );
    const fieldItems = await leftPanel.findAll(
      '.form-builder-left-panel-field-types-list > fw-field-type-menu-item'
    );
    expect(fieldItems.length).toEqual(
      Object.keys(formMapper.CONVERSATION_PROPERTIES.fieldProps).length - 1
    );
  });

  it('disables left panel and displays message and button when role is trial, clicking on Explore plan button triggers fwExplorePlan event', async () => {
    const page = await newE2EPage();

    await page.setContent(
      '<fw-form-builder role="trial" product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
    );
    const fwExplorePlan = await page.spyOnEvent('fwExplorePlan');
    const disabledPanel = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-list-disabled-div'
    );
    expect(disabledPanel).toBeTruthy();
    const lockIcon = await disabledPanel.find('fw-icon');
    expect(lockIcon.getAttribute('name')).toBe('lock');
    const disabledHeader = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-list-disabled-header'
    );
    expect(disabledHeader).toBeTruthy();
    const disabledMessage = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-list-disabled-message'
    );
    expect(disabledMessage).toBeTruthy();
    const disabledButton = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-list-disabled-button'
    );
    expect(disabledButton).toBeTruthy();
    await disabledButton.triggerEvent('fwClick');
    await page.waitForChanges();
    expect(fwExplorePlan).toHaveReceivedEvent();
  });

  it('emits fwExpandField when clicked on a field in right panel', async () => {
    const page = await newE2EPage();
    await page.setContent('<fw-form-builder></fw-form-builder>');
    const fwExpandField = await page.spyOnEvent('fwExpandField');
    await page.waitForChanges();
    await page.$eval(
      'fw-form-builder',
      (elm: any, { formValues }: any) => {
        elm.formValues = formValues;
      },
      { formValues: formValues.CUSTOM_OBJECTS }
    );
    await page.waitForChanges();
    const rightPanel = await page.find(
      'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
    );
    const fieldDragDropItem = await rightPanel.findAll(
      'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
    );
    const fieldEditor = await fieldDragDropItem[1].find(
      'fw-field-editor >>> .fw-field-editor-header-content'
    );
    await fieldEditor.click();
    expect(fwExpandField).toHaveReceivedEventDetail({
      expanded: true,
      index: 1,
      isNew: false,
      value: formValues.CUSTOM_OBJECTS.fields[1],
    });
  });

  it('emits fwExpandField when clicked on cancel button in an expanded field', async () => {
    const page = await newE2EPage();
    await page.setContent('<fw-form-builder></fw-form-builder>');
    const fwExpandField = await page.spyOnEvent('fwExpandField');
    await page.waitForChanges();
    await page.$eval(
      'fw-form-builder',
      (elm: any, { formValues, currentFieldIndex }: any) => {
        elm.formValues = formValues;
        elm.currentFieldIndex = currentFieldIndex;
      },
      {
        formValues: formValues.CUSTOM_OBJECTS,
        currentFieldIndex: { [formValues.CUSTOM_OBJECTS.fields[1].id]: 1 },
      }
    );
    await page.waitForChanges();
    const rightPanel = await page.find(
      'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
    );
    const fieldDragDropItem = await rightPanel.findAll(
      'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
    );
    const fieldEditor = await fieldDragDropItem[1].find(
      'fw-field-editor >>> .fw-field-editor'
    );
    const cancelBtn = await fieldEditor.find('#clearFieldBtn');
    await cancelBtn.click();
    expect(fwExpandField).toHaveReceivedEventDetail({
      expanded: false,
      index: 1,
      isNew: false,
      value: {
        ...formValues.CUSTOM_OBJECTS.fields[1],
      },
    });
  });

  it('should display the correct headers and description for CUSTOM_OBJECTS', async () => {
    const page = await newE2EPage();
    await page.setContent('<fw-form-builder></fw-form-builder>');
    await page.waitForChanges();
    const headerLabel = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-header-label'
    );
    expect(headerLabel.innerText).toBe('Field types');
    const headerDescription = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-header-desc'
    );
    expect(headerDescription).toBeTruthy();
    const menuDesciption = await page.find(
      'fw-form-builder >>> .field-type-menu-description'
    );
    expect(menuDesciption).toBeTruthy();
    const menuLink = await page.find(
      'fw-form-builder >>> .field-type-menu-description-link-anchor'
    );
    expect(menuLink.getAttribute('href')).toBe(
      'https://support.freshdesk.com/en/support/solutions/articles/50000004226-understanding-associations'
    );
    const rightHeaderLabel = await page.find(
      'fw-form-builder >>> .form-builder-right-panel-header-label'
    );
    expect(rightHeaderLabel).toBeTruthy();
  });

  it('should display the correct headers and description for CONVERSATION_PROPERTIES', async () => {
    const page = await newE2EPage();
    await page.setContent(
      '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
    );
    await page.waitForChanges();
    const headerLabel = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-product-header-label'
    );
    expect(headerLabel.innerText).toBe('Conversation properties');
    const headerDescription = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-sub-header-description-label'
    );
    expect(headerDescription).toBeTruthy();
    const headerLink = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-sub-header-description-link-anchor'
    );
    expect(headerLink.getAttribute('href')).toBe(
      'https://crmsupport.freshworks.com/en/support/solutions/articles/50000005665?cloud=freshchat'
    );
    const menuDesciption = await page.find(
      'fw-form-builder >>> .form-builder-left-panel-header-desc-wo-header'
    );
    expect(menuDesciption).toBeTruthy();
    const rightHeaderLabel = await page.find(
      'fw-form-builder >>> .form-builder-right-panel-header-label'
    );
    expect(rightHeaderLabel).toBeTruthy();
  });

  let fieldIndex = 0;

  it.each(formValues.CONVERSATION_PROPERTIES.fields)(
    'displays all necessary fields in each field editor for CONVERSATION_PROPERTIES',
    async (field) => {
      const page = await newE2EPage();
      await page.setContent(
        '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
      );
      await page.waitForChanges();
      await page.$eval(
        'fw-form-builder',
        (elm: any, { formValues, currentFieldIndex }: any) => {
          elm.formValues = formValues;
          elm.currentFieldIndex = currentFieldIndex;
        },
        {
          formValues: formValues.CONVERSATION_PROPERTIES,
          currentFieldIndex: {
            [formValues.CONVERSATION_PROPERTIES.fields[fieldIndex].id]:
              fieldIndex,
          },
        }
      );
      await page.waitForChanges();
      const rightPanel = await page.find(
        'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
      );

      const fieldDragDropItem = await rightPanel.findAll(
        'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
      );

      const fieldEditor = await fieldDragDropItem[fieldIndex].find(
        'fw-field-editor >>> .fw-field-editor'
      );

      const checkboxLabel = await fieldEditor.find(
        '.fw-field-editor-content-checkboxes-header-label'
      );
      expect(checkboxLabel).toBeTruthy();
      expect(checkboxLabel.innerText).toBe('Behavior for agents');
      const formattedType =
        formMapper.CONVERSATION_PROPERTIES.reverseMappedFieldTypes[field.type];
      const fieldProps =
        formMapper.CONVERSATION_PROPERTIES.fieldProps[formattedType];
      if (fieldProps.checkboxes?.length) {
        const requiredProp = fieldProps.checkboxes.find(
          (checkbox) => checkbox.key === 'required'
        );
        if (requiredProp) {
          const requiredCheckbox = await fieldEditor.find('fw-checkbox');
          expect(requiredCheckbox).toBeTruthy();
        }
      }
      if (field.type === 'RELATIONSHIP') {
        const label = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-header-label'
        );
        expect(label).toBeTruthy();
        const sourceInput = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-input'
        );
        const sourceValue = await sourceInput.getProperty('value');
        expect(sourceValue).toBe(formValues.CONVERSATION_PROPERTIES.name);
        const relationshipType = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-relationship-select'
        );
        expect(relationshipType).toBeFalsy();
        const lookupTarget = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-target-select'
        );
        expect(lookupTarget).toBeTruthy();
      }
      const labelInput = await fieldEditor.find(
        '.fw-field-editor-content-required-input'
      );
      const labelValue = await labelInput.getProperty('value');
      expect(labelValue).toBe(field.label);
      const labelHeader = await fieldEditor.find(
        '.fw-field-editor-content-required-input >>> label'
      );
      expect(labelHeader).toBeTruthy();
      const internalNameLabel = await fieldEditor.find(
        '.fw-field-editor-internal-name-header-label'
      );
      expect(internalNameLabel).toBeTruthy();
      const internalNamePrefix = await fieldEditor.find(
        '.fw-field-editor-internal-name-prefix'
      );
      expect(internalNamePrefix).toBeTruthy();
      const internalNameInput = await fieldEditor.find(
        '.fw-field-editor-content-required-internal-name-input'
      );
      const internalNameValue = await internalNameInput.getProperty('value');
      expect(internalNameValue).toBe(field.name);
      const parsedDropdownFieldWithoutChoicesKey = getNestedKeyValueFromObject(
        field,
        formMapper.CONVERSATION_PROPERTIES.config.dropdownFieldWithoutChoicesKey
      );
      if (
        ['DROPDOWN', 'MULTI_SELECT'].includes(formattedType) &&
        !parsedDropdownFieldWithoutChoicesKey
      ) {
        const fieldDropdown = await fieldEditor.find('fw-fb-field-dropdown');
        expect(fieldDropdown).toBeTruthy();
      }
      if (fieldIndex === fieldDragDropItem.length - 1) {
        fieldIndex = 0;
      } else {
        fieldIndex++;
      }
    }
  );

  it.each(formValues.CUSTOM_OBJECTS.fields)(
    'displays all necessary fields in each field editor for CUSTOM_OBJECTS',
    async (field) => {
      const page = await newE2EPage();
      await page.setContent('<fw-form-builder></fw-form-builder>');
      await page.waitForChanges();
      await page.$eval(
        'fw-form-builder',
        (elm: any, { formValues, currentFieldIndex }: any) => {
          elm.formValues = formValues;
          elm.currentFieldIndex = currentFieldIndex;
        },
        {
          formValues: formValues.CUSTOM_OBJECTS,
          currentFieldIndex: {
            [formValues.CUSTOM_OBJECTS.fields[fieldIndex].id]: fieldIndex,
          },
        }
      );
      await page.waitForChanges();
      const rightPanel = await page.find(
        'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
      );
      const fieldDragDropItem = await rightPanel.findAll(
        'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
      );

      const fieldEditor = await fieldDragDropItem[fieldIndex].find(
        'fw-field-editor >>> .fw-field-editor'
      );

      const checkboxLabel = await fieldEditor.find(
        '.fw-field-editor-content-checkboxes-header-label'
      );

      expect(checkboxLabel).toBeTruthy();
      expect(checkboxLabel.innerText).toBe('Behavior for agents');
      const checkboxes = await fieldEditor.findAll(
        '.fw-field-editor-content-checkbox-container > fw-checkbox'
      );
      expect(checkboxes.length).toBe(
        formMapper.CUSTOM_OBJECTS.fieldProps[field.type].checkboxes.length
      );
      await checkboxes.forEach(async (checkbox, index) => {
        const key = await checkbox.getProperty('value');
        expect(key).toBe(
          formMapper.CUSTOM_OBJECTS.fieldProps[field.type].checkboxes[index].key
        );
      });
      if (field.type === 'PRIMARY') {
        const labelHint = await fieldEditor.find(
          '.fw-field-editor-content-required-input >>> .field-control-hint-text'
        );
        expect(labelHint).toBeTruthy();
      }
      if (field.type === 'RELATIONSHIP') {
        const label = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-header-label'
        );
        expect(label).toBeTruthy();
        const sourceInput = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-input'
        );
        const sourceValue = await sourceInput.getProperty('value');
        expect(sourceValue).toBe(formValues.CUSTOM_OBJECTS.name);
        const relationshipType = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-relationship-select'
        );
        const typeValue = await relationshipType.getProperty('value');
        expect(typeValue).toBe('many_to_one');
        const typeOptions = await relationshipType.getProperty('options');
        expect(typeOptions).toEqual([
          {
            subText:
              'Link many records of the source object with one record of the target object. e.g Many Orders can be placed by a Contact.',
            text: 'Many to one',
            value: 'many_to_one',
          },
          {
            subText:
              'Link one record of the source object with only one record of the target object. e.g A Person can have only one Passport.',
            text: 'One to one',
            value: 'one_to_one',
          },
        ]);
        const lookupTarget = await fieldEditor.find(
          'fw-fb-field-lookup >>> .fb-field-lookup-target-select'
        );
        expect(lookupTarget).toBeTruthy();
      }
      const labelInput = await fieldEditor.find(
        '.fw-field-editor-content-required-input'
      );
      const labelValue = await labelInput.getProperty('value');
      expect(labelValue).toBe(field.label);
      const labelHeader = await fieldEditor.find(
        '.fw-field-editor-content-required-input >>> label'
      );
      expect(labelHeader).toBeTruthy();
      if (['DROPDOWN', 'MULTI_SELECT'].includes(field.type)) {
        const fieldDropdown = await fieldEditor.find('fw-fb-field-dropdown');
        expect(fieldDropdown).toBeTruthy();
      }
      if (fieldIndex === fieldDragDropItem.length - 1) {
        fieldIndex = 0;
      } else {
        fieldIndex++;
      }
    }
  );

  describe('test maximum fields for conversation properties', () => {
    it('should not disable all the field menu items when the total active fields without default tag has not reached the maximum limit and only disable the fields which exceed their max limit', async () => {
      const page = await newE2EPage();

      await page.setContent(
        `<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>`
      );
      await page.waitForChanges();
      await page.$eval(
        'fw-form-builder',
        (elm: any, { formValues }: any) => {
          elm.formValues = formValues;
        },
        { formValues: formValues.CONV_MAX }
      );
      await page.waitForChanges();
      const leftPanel = await page.find(
        'fw-form-builder >>> .form-builder-left-panel'
      );
      const fieldItems = await leftPanel.findAll(
        '.form-builder-left-panel-field-types-list > fw-field-type-menu-item'
      );
      expect(fieldItems.length).toEqual(
        Object.keys(formMapper.CONVERSATION_PROPERTIES.fieldProps).length
      );
      const rightPanel = await page.find(
        'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
      );

      const fieldDragDropItem = await rightPanel.findAll(
        'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
      );

      // total fields
      expect(formValues.CONV_MAX.fields.length).toBe(fieldDragDropItem.length);
      expect(formValues.CONV_MAX.fields.length).toBeGreaterThanOrEqual(
        formMapper.CONVERSATION_PROPERTIES.maximumLimits.fields.count
      );
      // total active fields
      const activeFields = formValues.CONV_MAX.fields.filter(
        (field) => field.custom
      );
      expect(activeFields.length).not.toBeGreaterThanOrEqual(
        formMapper.CONVERSATION_PROPERTIES.maximumLimits.fields.count
      );
      // check if disabled
      await fieldItems.forEach(async (item) => {
        // item should not be disabled as total active fields are 46 excluding the fields with default tag
        // item should be disabled only if it's individual count reaches maximum limit
        const type = await item.getProperty('value');
        const itemMaxLimit =
          formMapper.CONVERSATION_PROPERTIES.maximumLimits[type];
        const filteredFields = activeFields.filter((field) => {
          const formattedType =
            formMapper.CONVERSATION_PROPERTIES.reverseMappedFieldTypes[
              field.type
            ];
          return formattedType === type;
        });
        const isDisabled = item.shadowRoot.querySelector(
          'field-type-menu-item--disabled'
        );
        if (filteredFields.length >= itemMaxLimit) {
          expect(isDisabled).toBeTruthy();
        } else {
          expect(isDisabled).toBeFalsy();
        }
      });
    });

    it('should disable the field menu items when the total active fields without default tag has reached the maximum limit', async () => {
      const page = await newE2EPage();

      await page.setContent(
        `<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>`
      );
      await page.waitForChanges();
      const additionalFields = formValues.CONVERSATION_PROPERTIES.fields
        .slice(0, 4)
        .map((field) => ({ ...field, custom: true }));
      const clonedFormValues = JSON.parse(JSON.stringify(formValues.CONV_MAX));
      const updatedFormValues = {
        ...clonedFormValues,
        fields: [...clonedFormValues.fields, ...additionalFields],
      };
      await page.$eval(
        'fw-form-builder',
        (elm: any, { formValues }: any) => {
          elm.formValues = formValues;
        },
        { formValues: updatedFormValues }
      );
      await page.waitForChanges();
      const leftPanel = await page.find(
        'fw-form-builder >>> .form-builder-left-panel'
      );
      const fieldItems = await leftPanel.findAll(
        '.form-builder-left-panel-field-types-list > fw-field-type-menu-item'
      );
      const rightPanel = await page.find(
        'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
      );
      const fieldDragDropItem = await rightPanel.findAll(
        'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
      );
      // total fields
      expect(updatedFormValues.fields.length).toBe(fieldDragDropItem.length);
      expect(updatedFormValues.fields.length).toBeGreaterThanOrEqual(
        formMapper.CONVERSATION_PROPERTIES.maximumLimits.fields.count
      );
      // total active fields
      const activeFields = updatedFormValues.fields.filter(
        (field) => field.custom
      );
      expect(activeFields.length).toBeGreaterThanOrEqual(
        formMapper.CONVERSATION_PROPERTIES.maximumLimits.fields.count
      );
      // check if disabled
      await fieldItems.forEach(async (item) => {
        // item should be disabled as total active fields are 50 excluding the fields with default tag
        const isDisabled = await item.getProperty('disabled');
        expect(isDisabled).toBeTruthy();
      });
    });
  });

  it('should not display choices if a dropdown field contains dropdownFieldWithoutChoicesKey', async () => {
    const page = await newE2EPage();
    await page.setContent(
      '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
    );
    await page.waitForChanges();
    await page.$eval(
      'fw-form-builder',
      (elm: any, { formValues }: any) => {
        elm.formValues = formValues;
      },
      {
        formValues: formValues.CONV_MAX,
      }
    );
    await page.waitForChanges();
    const dropdownWithoutChoicesIndices = [0, 1];
    const rightPanel = await page.find(
      'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
    );

    const fieldDragDropItem = await rightPanel.findAll(
      'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
    );

    for (let i = 0; i <= 4; i++) {
      await page.$eval(
        'fw-form-builder',
        (elm: any, { currentFieldIndex }: any) => {
          elm.currentFieldIndex = currentFieldIndex;
        },
        {
          currentFieldIndex: { [formValues.CONV_MAX.fields[i].id]: i },
        }
      );
      await page.waitForChanges();
      const field = formValues.CONV_MAX.fields[i];
      const formattedType =
        formMapper.CONVERSATION_PROPERTIES.reverseMappedFieldTypes[field.type];
      const parsedDropdownFieldWithoutChoicesKey = getNestedKeyValueFromObject(
        field,
        formMapper.CONVERSATION_PROPERTIES.config.dropdownFieldWithoutChoicesKey
      );
      if (
        ['DROPDOWN', 'MULTI_SELECT'].includes(formattedType) &&
        !parsedDropdownFieldWithoutChoicesKey
      ) {
        const fieldEditor = await fieldDragDropItem[i].find(
          'fw-field-editor >>> .fw-field-editor'
        );
        const fieldDropdown = await fieldEditor.find('fw-fb-field-dropdown');
        expect(fieldDropdown).toBeTruthy();
        expect(dropdownWithoutChoicesIndices).not.toContain(i);
      }
    }
  });

  describe('test permissions property', () => {
    it.each(['create', 'view'])(
      'should not be able to create when %s permission is false',
      async (key) => {
        const page = await newE2EPage();

        await page.setContent(
          '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
        );
        const permission = {
          view: true,
          create: true,
          edit: true,
          delete: true,
        };
        permission[key] = false;
        await page.$eval(
          'fw-form-builder',
          (elm: any, { permission }: any) => {
            elm.permission = permission;
          },
          {
            permission,
          }
        );
        await page.waitForChanges();
        const disabledPanel = await page.find(
          'fw-form-builder >>> .form-builder-left-panel-list-disabled-div'
        );
        expect(disabledPanel).toBeTruthy();
        const lockIcon = await disabledPanel.find('fw-icon');
        expect(lockIcon.getAttribute('name')).toBe('lock');
        const disabledHeader = await page.find(
          'fw-form-builder >>> .form-builder-left-panel-list-disabled-header'
        );
        expect(disabledHeader).toBeTruthy();
        const disabledMessage = await page.find(
          'fw-form-builder >>> .form-builder-left-panel-list-disabled-message'
        );
        expect(disabledMessage).toBeTruthy();
      }
    );

    describe.each(['edit', 'view'])('if %s permission is true', (key) => {
      it.each(formValues.CONVERSATION_PROPERTIES.fields)(
        'should disable all fields in each field editor for CONVERSATION_PROPERTIES',
        async (field) => {
          const page = await newE2EPage();
          await page.setContent(
            '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
          );
          const permission = {
            view: true,
            create: true,
            edit: true,
            delete: true,
          };
          permission[key] = false;
          await page.waitForChanges();
          await page.$eval(
            'fw-form-builder',
            (elm: any, { formValues, currentFieldIndex, permission }: any) => {
              elm.formValues = formValues;
              elm.currentFieldIndex = currentFieldIndex;
              elm.permission = permission;
            },
            {
              formValues: formValues.CONVERSATION_PROPERTIES,
              currentFieldIndex: {
                [formValues.CONVERSATION_PROPERTIES.fields[fieldIndex].id]:
                  fieldIndex,
              },
              permission,
            }
          );
          await page.waitForChanges();
          const rightPanel = await page.find(
            'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
          );
          const fieldDragDropItem = await rightPanel.findAll(
            'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
          );
          const fieldEditor = await fieldDragDropItem[fieldIndex].find(
            'fw-field-editor >>> .fw-field-editor'
          );

          const formattedType =
            formMapper.CONVERSATION_PROPERTIES.reverseMappedFieldTypes[
              field.type
            ];
          const fieldProps =
            formMapper.CONVERSATION_PROPERTIES.fieldProps[formattedType];
          if (fieldProps.checkboxes?.length) {
            const requiredProp = fieldProps.checkboxes.find(
              (checkbox) => checkbox.key === 'required'
            );
            if (requiredProp) {
              const requiredCheckbox = await fieldEditor.find('fw-checkbox');
              expect(requiredCheckbox).toBeTruthy();
              expect(await requiredCheckbox.getProperty('disabled')).toBe(true);
            }
          }
          if (field.type === 'RELATIONSHIP') {
            const sourceInput = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-input'
            );
            const sourceValue = await sourceInput.getProperty('value');
            expect(sourceValue).toBe(formValues.CONVERSATION_PROPERTIES.name);
            expect(await sourceInput.getProperty('disabled')).toBe(true);
            const relationshipType = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-relationship-select'
            );
            expect(relationshipType).toBeFalsy();
            const lookupTarget = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-target-select'
            );
            expect(lookupTarget).toBeTruthy();
            expect(await lookupTarget.getProperty('disabled')).toBe(true);
          }
          const labelInput = await fieldEditor.find(
            '.fw-field-editor-content-required-input'
          );
          expect(await labelInput.getProperty('disabled')).toBe(true);
          const internalNameInput = await fieldEditor.find(
            '.fw-field-editor-content-required-internal-name-input'
          );
          const internalNameValue = await internalNameInput.getProperty(
            'value'
          );
          expect(internalNameValue).toBe(field.name);
          expect(await internalNameInput.getProperty('disabled')).toBe(true);
          const parsedDropdownFieldWithoutChoicesKey =
            getNestedKeyValueFromObject(
              field,
              formMapper.CONVERSATION_PROPERTIES.config
                .dropdownFieldWithoutChoicesKey
            );
          if (
            ['DROPDOWN', 'MULTI_SELECT'].includes(formattedType) &&
            !parsedDropdownFieldWithoutChoicesKey
          ) {
            const fieldDropdown = await fieldEditor.find(
              'fw-fb-field-dropdown'
            );
            expect(fieldDropdown).toBeTruthy();
            expect(await fieldDropdown.getProperty('disabled')).toBe(true);
          }
          if (fieldIndex === fieldDragDropItem.length - 1) {
            fieldIndex = 0;
          } else {
            fieldIndex++;
          }
        }
      );

      it.each(formValues.CUSTOM_OBJECTS.fields)(
        'should disable all fields in each field editor for CUSTOM_OBJECTS',
        async (field) => {
          const page = await newE2EPage();
          await page.setContent('<fw-form-builder></fw-form-builder>');
          await page.waitForChanges();
          const permission = {
            view: true,
            create: true,
            edit: true,
            delete: true,
          };
          permission[key] = false;
          await page.$eval(
            'fw-form-builder',
            (elm: any, { formValues, currentFieldIndex, permission }: any) => {
              elm.formValues = formValues;
              elm.currentFieldIndex = currentFieldIndex;
              elm.permission = permission;
            },
            {
              formValues: formValues.CUSTOM_OBJECTS,
              currentFieldIndex: {
                [formValues.CUSTOM_OBJECTS.fields[fieldIndex].id]: fieldIndex,
              },
              permission,
            }
          );
          await page.waitForChanges();
          const rightPanel = await page.find(
            'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
          );

          const fieldDragDropItem = await rightPanel.findAll(
            'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
          );
          const fieldEditor = await fieldDragDropItem[fieldIndex].find(
            'fw-field-editor >>> .fw-field-editor'
          );

          const checkboxes = await fieldEditor.findAll(
            '.fw-field-editor-content-checkbox-container > fw-checkbox'
          );
          expect(checkboxes.length).toBe(
            formMapper.CUSTOM_OBJECTS.fieldProps[field.type].checkboxes.length
          );
          await checkboxes.forEach(async (checkbox) => {
            expect(await checkbox.getProperty('disabled')).toBe(true);
          });
          if (field.type === 'RELATIONSHIP') {
            const sourceInput = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-input'
            );
            const sourceValue = await sourceInput.getProperty('value');
            expect(sourceValue).toBe(formValues.CUSTOM_OBJECTS.name);
            expect(await sourceInput.getProperty('disabled')).toBe(true);
            const relationshipType = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-relationship-select'
            );
            const typeValue = await relationshipType.getProperty('value');
            expect(typeValue).toBe('many_to_one');
            expect(await relationshipType.getProperty('disabled')).toBe(true);
            const lookupTarget = await fieldEditor.find(
              'fw-fb-field-lookup >>> .fb-field-lookup-target-select'
            );
            expect(lookupTarget).toBeTruthy();
            expect(await lookupTarget.getProperty('disabled')).toBe(true);
          }
          const labelInput = await fieldEditor.find(
            '.fw-field-editor-content-required-input'
          );
          const labelValue = await labelInput.getProperty('value');
          expect(labelValue).toBe(field.label);
          expect(await labelInput.getProperty('disabled')).toBe(true);
          if (['DROPDOWN', 'MULTI_SELECT'].includes(field.type)) {
            const fieldDropdown = await fieldEditor.find(
              'fw-fb-field-dropdown'
            );
            expect(fieldDropdown).toBeTruthy();
            expect(await fieldDropdown.getProperty('disabled')).toBe(true);
          }
          if (fieldIndex === fieldDragDropItem.length - 1) {
            fieldIndex = 0;
          } else {
            fieldIndex++;
          }
        }
      );
    });

    it.each(['delete', 'view'])(
      'should disable delete button when %s permission is false',
      async (key) => {
        const page = await newE2EPage();
        await page.setContent(
          '<fw-form-builder product-name="CONVERSATION_PROPERTIES"></fw-form-builder>'
        );
        await page.waitForChanges();
        const permission = {
          view: true,
          create: true,
          edit: true,
          delete: true,
        };
        permission[key] = false;
        await page.$eval(
          'fw-form-builder',
          (elm: any, { formValues, currentFieldIndex, permission }: any) => {
            elm.formValues = formValues;
            elm.currentFieldIndex = currentFieldIndex;
            elm.permission = permission;
          },
          {
            formValues: formValues.CONVERSATION_PROPERTIES,
            currentFieldIndex: {
              [formValues.CONVERSATION_PROPERTIES.fields[fieldIndex].id]:
                fieldIndex,
            },
            permission,
          }
        );
        await page.waitForChanges();
        const rightPanel = await page.find(
          'fw-form-builder >>> .form-builder-right-panel-field-editor-list'
        );

        const fieldDragDropItem = await rightPanel.findAll(
          'fb-field-drag-drop-item >>> .fb-field-drag-drop-item'
        );
        const fieldEditor = await fieldDragDropItem[1].find(
          'fw-field-editor >>> .fw-field-editor'
        );
        const deleteBtn = await fieldEditor.find(
          '.fw-field-editor-delete-button'
        );
        expect(await deleteBtn.getProperty('disabled')).toBe(true);
      }
    );
  });
});
