---
Title: Supporting the project
---
The freenode project exists to provide an interactive environment for coordination and support of peer-directed projects, including those of free software and open source. Our network is currently implemented using Internet Relay Chat (IRC). Our aim is to help improve the communicative and collaborative skills of our participants and to maintain a friendly, efficient environment for project coordination and technical support.

The simplest way in which to support the project is to continue supporting the primary projects that have chosen to register as groups with freenode. 

Individuals can also volunteer as network staff and organisations could consider hosting a server.

The freenode project needs solid, well-connected hidden hub and public leaf servers. We look for multi-homed connections with significant bandwidth available &mdash; client servers should expect to sustain around 2-4Mbps of traffic, with much higher peaks. Total usage for client servers is usually around 320 gigabytes per month, while hidden hubs are generally much lower overall. Therefore, we are unable to consider offers of hosting from home cable/DSL connections.

We appreciate your interest in helping the network grow and your willingness to contribute to that process. The freenode network is not a conventional IRC network. Servers are hosted, not linked. They are maintained remotely from central sites. New configuration files are generated via an automated script at a central location, and new servers are either staged as binary files or recompiled on the server account, depending on architecture and other factors.

While we will happily acknowledge your contribution publicly, we do not, as a general rule, provide O-lines or operator privileges to our server hosts. Hosting candidates are reminded that the utility of any given server depends on ping latencies and other factors which may be beyond our control. Servers may need to be delinked or rehubbed at any time and we cannot always provide notice before a server is delinked.

Regardless, hosting a server helps the freenode project and the communities and we are grateful that you are considering it.

### System Specifications

The following table lists minimum system requirements, and, where applicable desired specifications.

| Required | Desired |
| ---- | ---- |
| Pentium 4 or better dedicated server with SSSE3 capability | 64-bit multi-core |
| 2G RAM | 2-3G or more |
| Debian stable |  |


### System Software
We manage and update software using a centralized configuration management, for which we will need root access.  We may create user(s) for the ircd, change core file limits, file descriptor limits, and other modifications as necessary to sustain IRC connections from thousands of users.  We also need servers for non-ircd roles.

### Other Requirements
While the servers are configured and maintained by the freenode infrastructure team and we do not require active involvement from facilities sponsors for the day to day running of the network, we ask that:

* Sponsors ensure that we have up-to-date contact information, on and offline
* Sponsors stay subscribed to the freenode-sponsors mailing list (low traffic, announcements only)
* Sponsors endeavour to, where possible, give us ample advance warning about network, hardware or software upgrades and maintenance which may affect the network.
* Sponsors communicate reasons for unexpected downtime/maintenance ASAP.

### Applying to Host a Server
Before applying to host a server, you may find it helpful to speak with network staff. Feel free to message a freenode staffer with your questions. Regardless, the formal application process begins when you submit an email containing the following information to email address <hosting@freenode.net>:

* <b>Geographical location of the server</b> &mdash; City, principality and country. Include any "local colour" (nearby landmarks and sites) that seem pertinent.
* <b>Hosting Entity</b> &mdash; Who should we credit for the server? Provide the name of organisation and URL as appropriate.
* <b>Contact Information</b> &mdash; Please include names and email addresses of contacts, as well as telephone numbers, snail mail addresses and contact hours (including time zones).
* <b>Hardware, Software, Bandwidth and Hosting</b> &mdash; Please describe the system you are offering for hosting. Please go into as much detail as possible, providing us with details of routing and NOC availability.
* <b>IP address</b> &mdash; this will allow us to perform latency and route checking.
* <b>You and freenode</b> &mdash; please explain what makes you/your company want to provide hosting for freenode, and what, if anything, you wish to get back from sponsorship.
* <b>Server Name Preference</b> &mdash; The server naming motif is "science fiction and fantasy authors". Vanity names may be provided, but canonical server names and standardised geographical names will be used exclusively by freenode. If you have preferred authors, let us know and we will try to honour your preference.

freenode's sponsor liaisons try to respond to all server application requests within two weeks. Please allow this time before chasing your application.

All applications will be given the same considerations and we regret that we may not always be able to accept a server offer for whatever reason.

### Infrastructure
The network infrastructure team can be reached by email at <infra@freenode.net>. Messages can be encrypted to this GPG key:

    8937 A9DD 1321 777B D819  6419 0D52 4809 16EC 8B98
