---
Title: The Philosophy
---
There are several elements to the freenode philosophy. The project was originally founded to provide interactive discussion facilities to **peer-directed project communities**. Peer-directed projects combine open, informal participation with broad licensing and wide dissemination of output.

Our basic principles are:

 - **Community members benefit from better access to each other.** Putting a number of projects in close proximity in an interactive environment creates linkages between developers and projects, and helps community members take better advantage of each other's work.
 - **Communication and coordination skills are important to community projects.** Peer-directed projects work because the paradigm works. Developers and community members are not unusually gifted at project coordination and communication. But improving those skills can make projects work better.
 - **Friendly interaction is more efficient than flaming.** Calm, relaxed discourse without angry contention provides for better exchange of information. Flaming produces situations in which the listener must contend with the state of his or her emotions at least as much as with the comprehension of a speaker's comments.
 - **Project developers are self-driven.** No one guarantees your work will be used, but only you decide whether a project is worth doing. There is no single right approach to any design, implementation or support problem, and friendly competition is a fundamentally good thing.
 - **Peer-directed project communities need to grow.** Many valuable peer-directed projects chronically lack skilled, motivated developers with time to devote to them. The potential base for peer-directed project communities includes anyone with the skills and interest to participate. These communities must continue to grow.
 - **Licensing must be free.** For peer-directed projects to succeed, their creative output must be widely available and usable without significant restriction. For software projects, the [Debian Free Software Guidelines](http://www.debian.org/social_contract#guidelines), the Free Software Foundation's [Free Software Definition](http://www.gnu.org/philosophy/free-sw.html) and the Open Source Initiative's [Open Source Definition](http://www.opensource.org/docs/definition.php) provide guidelines to help ensure that project creative output remains free. For artistic projects and for the printed word, licenses provided by [Creative Commons](http://creativecommons.org/licenses/) and efforts such as the [GNU Free Documentation License](http://www.gnu.org/licenses/fdl.html) and the [FreeBSD Documentation License](http://www.freebsd.org/copyright/freebsd-doc-license.html) help keep creative output free.

Licensing which preserves the ability of newcomers to contribute, and maintains a low barrier to entry for development, is essential to the health and success of peer-directed projects.

