---
Title: Group registration
---

This page describes group registration and the use of the freenode group
contact. Group registration allows your project or organisation to maintain
unambiguous contact with the freenode project volunteers and group registration
represents an official relationship with freenode.

### On-topic groups

Groups considered to be on-topic for freenode are primarily free and open-source
software projects, and other peer-directed projects, for instance Linux User
Groups (LUGs), student societies, and other collaborative efforts, or projects/companies
of general interest to our user base.

### Group registration:

**Represents an official relationship between freenode and your project or
organisation.**

> By registering your group, you are indicating that you are maintaining an
> official presence on the network. If your group is a legal entity, we want to
> make sure that management has approved your registration.

**Requires no special type or level of participation.**

> You may maintain as little or as much control over your channels as desired.
> You may cloak your members, employees or participants, or not, as you decide.
> You may apply to sponsor a server if that is something you wish to do.

**Is accomplished by discussing your registration with the community team.**

> If you think a group registration would benefit your project, let any member
> of staff know over IRC; they'll assess whether your group appears to be
> on-topic and advise you on what kind of information and authorisation you'll
> need.


### Two types of group contacts exist for freenode:

#### The primary contact.

This contact registers to establish that your group intends to create a
relationship with freenode. The primary contact should have the authority to
make the determination that your group intends to register, with the specifics
depending on the type of group:

1. Legal entities. A primary contact should belong to upper management or the
organisation's board. This authority can be delegated further in the case of
larger organisations, but it is not recommended; in cases where such delegation
occurs, contact with the organisation is often lost and the group registration
must subsequently be removed.

2. Informal, project-oriented groups. Informal groups vary considerably in
their internal organisation. If the group is run by a single project leader or
developer, that person should submit a group registration. If it is run by a
larger core group or by voting across the project, the voting group should make
a collective decision to register and should appoint one of their number as
primary contact.

#### The secondary contact.

Secondary (or alternate) contacts are appointed by the primary contact. A
secondary contact may be assigned limited access and/or privileges. They need
no special level of authority; delegate whatever level of authority seems
appropriate. We will not expect them to make policy decisions, just to find out
the answers to any questions that are raised.


### Group registration provides:

1. Additional channel management capabilities. Projects and organisations are
entitled to own channels bearing their names. Your group contact can request
changes in channel ownership in accordance with this policy and can directly
request changes to access lists and configuration for any channels you own.

2. Group hostname cloaks. Cloaks allow your project or organisation to grant
official recognition to project participants. Your group contact maintains this
cloak list.

3. Problem solving. When there is a problem with one of your channels or if
there is a complaint by a user or a question about policy, we will pass it on
to your group contact.

We aim for a reasonable degree of flexibility where we deal with groups. If you
mention any particular needs your project might have, we'll try to accommodate
you.


#### Your group contacts:

**Are designated by your project or organisation.** For example, a group
contact might be your IT manager or someone involved with your project
infrastructure.

**Can be one person or several.** You decide who acts as group contact. Each
contact can be designated to handle issues pertaining to your entire group, or
to a limited set of projects or users. You can designate primary and backup
contacts if you wish.

**Acts as your "goto".** When you need someone to talk to us about a network
issue, your group contact is the person. They are your formal point of contact
with our network staff.

**Acts as our "goto".** We will ask your group contact whenever we have any
question about your project or organisational policies as they pertain to
participation in the network.

## Group Registration and Channel Ownership

Channels on freenode are owned and operated by the groups which register them.
No minimum level of activity or moderation is expected or required of channel owners.
The network exists to further on-topic use, as explained in our [policies](http://freenode.net/policies)
and channels or groups may be removed from freenode for activity which is considered
to be off-topic.

Groups using freenode are strongly encouraged to adopt the [channel guidelines](http://freenode.net/changuide).

Primary channels are reserved based on a formal or informal claim, external to IRC, to a specific project group, or
trademarked name. Topical or reference channels are reserved on a first-come, first-served basis by groups wishing to
discuss a project, group or topic.


### Free and Open Source Software (FOSS).
Project coordination, support, discussion or contact channels associated with software projects which are licensed under terms consistent with the [Debian Free Software Guidelines](http://www.debian.org/social_contract#guidelines), Free Software Foundation's [Free Software Definition](http://www.gnu.org/philosophy/free-sw.html) or the Open Source Initiative's [Open Source Definition](http://www.opensource.org/docs/definition.php) (preferably all three) are considered to be on-topic.


### Non-Software-Related Peer-Directed Project.
Channels which serve projects combining open, informal participation and broadly-licensed, widely-disseminated creative output are considered to be on-topic.  If you believe your non-software project may meet the criteria for a non-software peer-directed project, please consult a staffer or email support at freenode dot net.

### Non-Governmental Organization (NGO).
Coordination, support, discussion or contact channels run by educational institutions, registered not-for-profit entities and other non-governmental organisations (NGOs) and their related consortia are considered to be on-topic.  Be sure to register your group or organisation.

### Governmental Entity.
Coordination, support, discussion or contact channels run by local, national or international governmental entities are considered to be on-topic.  Don't forget to register your group.

### News Media.
Formal news organizations with an interest in our target communities are encouraged to create contact channels on freenode.

### Corporate.
Contact channels for registered corporate or business entities or consortia with an interest in our target communities are considered to be on-topic.

### Standards.
Discussion channels associated with official standards committees or with informal standards groups are considered to be on-topic.

### Geographically-Based Interest Group.
Channels associated with formal or informal geographically-based interest groups are considered to be on-topic.  These include local
Linux and FreeBSD user groups (LUGs and FUGs) and community wireless groups.  If your group doesn't fall into one of those categories, but you think it might meet the criteria, please consult a staffer or email support at freenode dot net.

### Other groups.
Other groups not covered by the above examples may be suitable for the network. Please drop an e-mail to groups@freenode.net if you want to find out if your group/project is a good fit for freenode.


## freenode Group Advisory Board

In order for freenode to provide the best possible service to the communities
we serve, it is important for us to receive feedback from the projects with
which we have relationships.

We invite all current (and future) Group Contacts to join GAB, the freenode
Group Advisory Board. While we hope to see many Group Contacts involved with
GAB in an advisory capacity, GAB membership is of course optional.

freenode will consult the GAB on matters relating to services given to
groups/projects, any addition to, or change of, group specific policy and other
relevant issues.

If you are a current Group Contact and wish to get involved with GAB, please
contact staff on IRC or email groups at freenode dot net for instructions on
how to subscribe to the freenode-groups mailing list. If you're considering
becoming one, just let us know your email address when registering.

We'd love to hear how you feel we could improve the service for your community.
Thanks in advance for any help you can provide!


## Group Management & Community Team

The Group Management & Community Team comprises, among others, the freenode staff; together they will act as your
liaisons during the group registration process and throughout your tenure on the
freenode network. If you wish to discuss the group registration process, find out
if freenode could be a good fit for your project or register your project as
a group, please feel free to drop any of the team members a line on IRC.
If none are online, feel free to reach out to staff in general and they will
forward your request to the team, which will get back to you as soon as possible.

Once you have discussed your project with a staff member, you'll be asked to
email <projects@freenode.net> with the details of your request, including any
formal verification information that might be required. If you're a PGP user,
feel free to encrypt to:

    445B 4A56 5E9D F351 DD80  CE98 FCF3 9BAB 6166 AFB8
