---
Title: Channel Guidelines
---
IRC is a low-bandwidth method of communication, in comparison with physical presence. Many of the cues of physical communication, tone of voice, facial expression, hand movements, etc., are missing in IRC, since only text is transmitted back and forth.
Speakers in physical proximity with each other communicate quite a bit of emotional context via this extra bandwidth. This context enables them to avoid misjudging the intent of their conversational partners. It also functions as an unconscious negative feedback mechanism to reduce the incidence of emotional "firestorms" which tend to disrupt the efficient flow of conversation. Human beings look for this feedback, and indeed they may have evolved to require it. In the low-bandwidth world of IRC, they must instead rely on emotional feedback from the text they receive.

This process is subject to exaggeration. Small amounts of emotion become magnified in the perception of the observer. So, it is very important to keep channels calm. An informal conceptual measurement of the emotional content of a channel is its "channel temperature."

Think of a person's emotional state as kinetic energy. Enthusiasm, happiness, anger, frustration all add to the energy level. The more emotion is experienced, the "hotter" the participant. The average emotional state of a channel is its temperature. Emotions in IRC become exaggerated and conveying them directly increases channel temperature. Pent-up frustration, in particular, is often released as a series of inappropriate, "high energy" outbursts. An important objective of the freenode channel guidelines is to avoid "feedback loops" in channel interactions by reducing channel temperature.

The guidelines which follow are designed with the benefit of years of experience with IRC, beginning during the 1993-1994 period when the design limitations of IRC began to become clear due to the increasing scale of IRC networks. Adopting the guidelines will help improve the overall quality of your channel, and of the discussions that can take place in it.
We intentionally avoid drawing a distinction between channel operators and users. Everyone is a user, regardless of their privilege level, and each user has the ability to influence the usability of the channel.

####Guidelines:
-  **Polish your catalyst skills.** The catalyst role is crucial to keeping channel interactions friendly and efficient.
-  **Look for the best in people.** If you assume people have no self-control, they will confirm your belief. If you look for personal responsibility, and ask for personal responsibility, most people will respond well.
-  **Set a good example.** Be what you want other people to be. If you want them to be calm, be calm. If you want them to be courteous and friendly, be courteous and friendly. The habitual behaviour of people on a channel is the most powerful influence on newbies arriving on the channel.
-  **Be nice if someone messages you.** They have gone to the trouble to seek out someone with the background to help them. You are it! Be flattered they have singled you out. If you think they will get better support by asking their question on channel, just let them know.
-  **Don't display channel operator privileges.** Displaying these privileges on your nick with a "+o" attracts participants who are interested in gaining them and using them actively; it also attracts the attention of participants who react negatively to authority. Have your account added to the channel access list and op yourself only when needed.
-  **Use channel operator privileges sparingly.** Each time you use them you raise the channel temperature. Users will be pleased with you, angry at you, frustrated that you used them inappropriately, envious that you have control over the discussion. None of these reactions may be conscious on the part of other users, but all of them increase the channel temperature.
-  **Avoid highlighting and repetition.** Words and sentences in all-uppercase, heavy use of highlighting, beeping (^G) on public channels, repeating the same lines over and over--all of these behaviours irritate people and raise the channel temperature.
-  **Avoid emotive speech.** Slang pertaining to sex and sexual orientation, excretion and religious oaths are rarely used to discuss the applicability of those topics to your group's activities. In general, language with strong emotional content and only light meaning should be considered "emotive speech". It does not matter whether the language is socially acceptable or unacceptable. For example, use of the word "fsck" which does not refer to a Unix filesystem check is emotive. Similarly, use of the word "gay" which has nothing to do with homosexuality is emotive. Emotive speech raises the channel temperature.
-  **Avoid sensitive material.** Some users on freenode channels, particularly on public channels, are quite young. Others are parents or teachers who might have young children nearby. As you type comments or ASCII art, or post URLs for others to view, please consider the age range of other users on your channel, and respect the right of parents and teachers to decide when and if to expose the children in their charge to material or language which might offend, confuse or raise difficult issues.
  Additionally, some of our users connect to freenode from corporate environments. Employers may be unhappy with the unexpected appearance of sensitive material on workplace computers. Please be considerate and avoid posting such material when you are not completely sure it is safe to do so.
-  **Avoid advocacy debates.** BSD versus GPL, vi versus emacs, centralised versus decentralised, RMS versus ESR: these discussions are frequently religious and may not involve significant new ideas. They can also raise the channel temperature quite a bit. Certain advocacy discussions, such as those revolving around actual religion or politics, are almost guaranteed to raise the channel temperature to levels that make other conversation difficult.
  You might not get too worked up if you are arguing the relative merits of poll() or kqueue(), but if you walk into a discussion with a strong emotional need to "get your way," consider the possibility you are simply arguing preference or personal affiliation. Advocacy discussions are best held quietly, via /msg, or on channels especially created for the purpose.
-  **Take criticism to private message.** Criticising someone's behaviour on channel holds them up to public scrutiny in a negative way. It's usually overkill. In your messages, do not address the subject of whether you have channel operator privileges; just be courteous. Request nicely that they change their behaviour. In many cases you will discover that problem user you are dealing with is merely inexperienced. An aggressive tone makes for a longer and more involved discussion, and pent-up frustration which will raise the channel temperature sooner or later. You can always use channel operator privileges, or have someone else use them, as needed; but with a courteous tone, you will need to do that a lot less.
-  **Don't be elitist.** Today's newbies are tomorrow's experts. A support channel is a place where people with knowledge lead by example. Is the example you want to set that technical knowledge is a hierarchy of control, or that people with knowledge have an inherent social advantage over people who do not? Helping other people takes patience. It is better not to answer a question than to use the opportunity to emphasise the limitations of the person you are trying to help.
-  **Don't be caught by support burnout.** It is nearly impossible to answer every technical question that comes to your channel. In many cases, the problem does not lie in the technical aspects of the question; cultural barriers may get in the way of communication, or it may be difficult to explain to a newbie just where to begin. When you try to answer every question, regardless of difficulty, you set yourself up for **support burnout**.
   Support burnout is nearly always accompanied by the feeling that you are losing control of your time, that the people you have set out to help are making unreasonable demands. The problem is that you are taking on too much responsibility; but it begins to appear instead that the problem is the end user who is asking for help.
   Different people react to support burnout in different ways. Some offer malicious advice ("rm -rf /" etc.) to newbies. Some insist that every question a newbie asks should be answered with a URL or by lists of manual references.
   When the staff of a support channel suffer from support burnout, they are likely to set arbitrary rules for participation; these might include prohibiting the use of certain phrases in channel, or disallowing the use of private messages to contact channel members. Staff might promulgate a lengthy, multi-page rules document ending with a special procedure the user must employ to be voiced in the channel (to make sure they have read the entire document before asking any questions).
   Such arbitrary rule sets tend to grow longer over time, because they do not solve the real problem. **You cannot answer every question, and you should not try.** Be gentle, be courteous, be flexible and be as patient and helpful as you can---but let someone else try to answer questions that you find too frustrating. Do not try to be a superhuman support machine.
-  **If you are considering publishing channel logs**, think it through. The freenode network is an interactive, real-time environment where discussions may be heavily influenced by external context. Even on public channels, most users do not weigh their comments with the idea that they will be enshrined in perpetuity to stand on their own. For that reason, few participants publish logs and we encourage those communities that do to make their participants aware of this fact.
