---
Title: Django and freenode
Author: Tim Graham (timograham)
Date: 2017-02-08T20:00+01:00
Slug: django-and-freenode
---

For nearly twelve years, the [Django Project](https://www.djangoproject.com/)
has endeavoured to improve "the web framework for perfectionists with
deadlines." Django is a high-level Python Web framework that encourage
rapid development and clean, pragmatic design. Built by experienced
developers, it takes care of much of the hassle of Web development,
so you can focus on writing your app without needing to reinvent the
wheel. Of course, it's free and open source.

I’m contracted full-time by the Django Software Foundation
[as a fellow](https://www.djangoproject.com/fundraising/#fellowship-program),
to manage some of the administrative and community management tasks of
the Django project to support rapid development of Django itself. The
fellowship program has a major positive impact on how Django is
developed and maintained, and I’d encourage any large open source
project to consider a similar program.

The Django community is vibrant across the globe, with many annual
conferences and local meetups. Sprints are often held at these events,
but Django’s development is mainly coordinated remotely, so good
communication tools are important to us.

## How Django uses freenode
Our community support channels include #django and the
[django-users mailing list](https://groups.google.com/forum/#!forum/django-users).
Discussions about the development of Django itself are held
in #django-dev and the
[django-developers mailing list](https://groups.google.com/forum/#!forum/django-developers). #django-sprint
provides a chat for sprint participants, including those who want to
join remotely. Finally, private discussions of the Django team are held
in the #django-core channel.

To keep our community safe and welcoming, Django's
[Code of Conduct](https://www.djangoproject.com/conduct/) applies to
all spaces managed by the Django project or Django Software Foundation
(DSF). This includes IRC, the mailing lists, the issue tracker, DSF
events, and any other forums created by the project team which the
community uses for communication.

## What's next for Django?
We're currently working toward releasing Django 1.11, our next
long-term support release, in April. This will be the last version of
Django to support Python 2.7. Meanwhile, Django's master development
branch is targeting Django 2.0 and will support Python 3 only. More
details are available on [our roadmap](https://www.djangoproject.com/download/#supported-versions).

If you’re interested in learning more about Django,
[try our tutorial](https://docs.djangoproject.com/en/stable/intro/tutorial01/).
If you’re already a Django user and want to start contributing, our
documentation is extensive, including
[advice for new contributors](https://docs.djangoproject.com/en/dev/internals/contributing/new-contributors/).
