---
Title: Celebrating Fedora 25 with freenode
Author: Justin W. Flory (jflory7)
Date: 2016-12-21T12:00-05:00
Slug: celebrating-fedora-freenode
---

![Celebrating Fedora 25 with freenode](static/img/celebrating-fedora-freenode.png)

On November 22nd, 2016, the [Fedora
Project](https://fedoraproject.org/wiki/Overview) released Fedora 25,
the latest and greatest version of our
[Linux-based](https://en.wikipedia.org/wiki/Linux_kernel) operating
system. For [over thirteen
years](https://www.redhat.com/archives/fedora-announce-list/2003-November/msg00000.html),
the Fedora community has worked to bring the leading edge of open source
development to the world. Fedora's focus is guided by its [Four
Foundations](https://fedoraproject.org/wiki/Foundations): *Freedom,
Friends, Features, First*. *Freedom* is representative of Fedora's
commitment to championing free and open source software and contributing
back to upstream projects for the benefit of the open source community.
*Features* stands for Fedora's commitment to driving some of the newest
features *First*. Some of these examples include the [Wayland display
server](https://en.wikipedia.org/wiki/Wayland_(display_server_protocol)),
[systemd](https://en.wikipedia.org/wiki/Systemd), and [GNOME
3](https://en.wikipedia.org/wiki/GNOME#GNOME_3). Perhaps most
importantly, *Friends* are for the friendships made by contributors from
around the world who help make every release of Fedora possible. Part of
why *Friends* is an important part of the Four Foundations is
communication. Fedora community members come from all over the planet,
including six out of seven continents. The tools we use to communicate
help us collaborate, solve problems, and build friendships. IRC and
freenode are an important part of how we communicate. Fedora registered
our first channel on freenode on December 29, 2002. As we celebrate
thirteen years of open source collaboration and the newest release of
Fedora 25, the Fedora community wanted to reflect on our longstanding
relationship with freenode.

How Fedora uses freenode
------------------------

As a large open source project, there are many different teams and
sub-projects in Fedora that help move us toward a new release. Just like
there are many parts to a car's engine, there are many parts to Fedora's
engine. Some of these groups are officially recognized sub-projects like
the [Design team](https://fedoraproject.org/wiki/Design), [Community
Operations](https://fedoraproject.org/wiki/CommOps), or [Docs
team](https://fedoraproject.org/wiki/Docs_Project). Other times, they
are informal [Special Interest
Groups](https://fedoraproject.org/wiki/Category:SIGs) (SIGs) that bring
contributors together to focus on specific topics like programming
languages or desktop environments, like the [Python
SIG](https://fedoraproject.org/wiki/SIGs/Python) or [KDE
SIG](https://fedoraproject.org/wiki/SIGs/KDE). Usually, each of these
groups or teams will have their own IRC channel to coordinate in. The
Design team uses `#fedora-design`, the Python SIG uses `#fedora-python`…
and so on. In total, Fedora has over 175 registered channels to its
name. Frequently, teams will hold public meetings in the freenode
channels to work through tickets, plan ahead on upcoming tasks, or
discuss important topics for their team. There are a series of special
meeting channels used for this purpose. Using the
[MeetBot](http://meetbot.debian.net/Manual.html) plugin, Fedora uses our
own [zodbot](https://github.com/fedora-infra/supybot-fedora) to help run
meetings, mark up links or important ideas, and create a pretty HTML
summary at the end of the meeting. All of these summaries and full logs
are found at
[meetbot.fedoraproject.org](https://meetbot.fedoraproject.org/).

Tips to using IRC effectively
-----------------------------

There are countless different workflows, IRC clients, and handy plugins
available to customize the IRC experience. In the spirit of the
*Friends* Foundation and the Code of Conduct, Fedora contributors are
encouraged to [always be excellent to one
another](https://getfedora.org/code-of-conduct). It's important to
follow good manners in any IRC channel, Fedora or any other. Having good
manners in IRC are as important as it is in real life. Be courteous to
others, and if in doubt, it's good to assume the best intentions by
others. IRC is important for Fedora, and many contributors have put
together guides of our own as well. You can read more tips from the
Fedora team in our [IRC Beginner's
Guide](https://fedoramagazine.org/beginners-guide-irc/) on the [Fedora
Magazine](https://fedoramagazine.org/).

What's next for Fedora?
-----------------------

As 2016 comes to an end, we're wrapping up on our own new release of
Fedora 25. The Fedora community is looking forward to helping drive open
source innovation and contributing to the Linux community for many years
to come. Fedora currently has more than 2,000 contributors, and in the
tenth percentile of active contributors, 65% of them are from the
community ([State of Fedora, Flock
2016](https://mattdm.org/fedora/2016flock/StateofFedoraAugust2016-v160731a.pdf)).
The Fedora steam engine is chugging ahead, and we're excited to see
where it takes us next. We're happy to be able to have shared past,
current, and future milestones together with the freenode community.
Keep an eye out for Fedora Ambassadors in Europe during
[DevConf](https://devconf.cz/) and [FOSDEM](https://fosdem.org/2017/).
You can also find us in North America at [BrickHack
2017](https://brickhack.io/). And there will be more events all through
the year you can keep an eye out for us at!
