---
author: SportChick
date: 2007-05-02 17:24:56+00:00
slug: silence-is-golden-handling-trolls-and-spammers
title: Silence is Golden: Handling trolls and spammers
category: community
category: freenode
category: philosophy
category: social
category: technical
imported: yes
robots: noindex
---
**The Issue **

Over the last few months, it's occurred to me that many people aren't quite sure how to react when a spammer or troll joins their channel.  There is always a tendency to react, to do whatever is necessary to get someone's attention to kick the spammer or troll.  As a channel op, many of us face challenges in that even if we know how best to react, our peers on the channel tend to get riled up anyway.  The result?  The troll or spammer has done significant damage to the channel - disrupting "business" or conversations, changing the focus of discussions, etc.

First it's important to understand what motivates most trolls/spammers.  Simple: attention.  They want your attention - whether it's "good" or "bad" attention is unimportant.  They simply want to change your focus from your customary topics to one thing: the spammer/troll.  Consequently, reactions to trolls and spammers (other than a simple kick/ban, as may be necessary) tend to do one thing - encourage the troll/spammer to continue his/her behavior.

So what is to be done?  There are really two groups of people to address at this point - channel operators (people who have the ability to kick/ban someone from the channel) and channel users.  Since users vastly outnumber operators, I'll address them first.

** Channel Users**

As a user of freenode, let me first say thanks!  freenode is unique because of its users!  We appreciate all of you and rarely get a chance to say so.  So how can you help freenode and your favorite channels deal with the issue of spammers and trolls?  The key is your reaction (or better, lack of a reaction).  Since trolls and spammers are seeking to disrupt business and get your focus on them, the best thing you can do is NOT respond to them.  Do not respond to their spam.  Simple?  It seems to be so - and in theory it is.  In practice, it can be a bit harder - especially when a spamming or trolling attack is going on.  Think "[Catalyst](http://freenode.net/catalysts.shtml)".

Here are a few ideas of how you might be able to express your frustration or communicate necessary information without encouraging the trolling or spamming behavior:



	
  * Take conversations to a private forum, channel or a private query message. This is true even if you're trying to get the attention of someone who might be able to kick/ban the troll/spammer. Your lack of reaction on the channel is quite boring to the troll or spammer and will only make them lose interest more quickly.

	
  * Don't discuss the situation for hours after the situation occurred. Many trolls have "legitimate" or alternate identities and will sit on a channel, not disrupting things, but watching the carnage they caused.

	
  * There are many ways for channel operators to address the issue of a troll or spammer, including changing the channel modes. If your favorite channel has suddenly gone +m (moderated) or to some other mode you're not familiar with, don't make a big deal of it. Ask one of the operators in a private message if you simply can't stand to not know what happened. But again, keep it off the channel.


**Channel Operators **

As a channel operator, you have a tougher job when your channel is attacked by trolls or spammers.  You have  a responsibility to the channel to block/stop/end the attack, as well as keeping everyone else calm!  Remember to [catalyse](http://blog.freenode.net/?p=21#comments) throughout the process.  Take heart - a little forward thinking will help a lot!

_Dealing with the Troll or Spammer _

There are a number of ways to deal with trolls and spammers.  Of course, you have kick, ban and remove available to you.  But you also have the ability to set some channel modes:



	
  * +r requires people to be identified with NickServ to join

	
  * +R requires people to be identified with NickServ to talk

	
  * +m moderates a channel, requiring +v to talk

	
  * +q is similar to a ban in that it won't allow you to talk or to change nicks, but you are free to join the channel

	
  * +z will make ops (+o) able to see what a person that is neither +v nor +o says in a channel that is +m


_Dealing with the Channel's Reactions_

First, remain calm.  You set the tone for your users.  If you get upset or excited, they will too.  Secondly, you can help a lot by educating your users before any attacks occur.  Let them know how trolls/spammers work and what they are seeking.  Provide them with a clear understanding of what they should do and who they should contact in the event of an attack. Inevitably, people will react to some degree.  Use the attack as an opportunity to educate - but do it in private; you want to keep reactions off channel and you also are more likely to be successful, avoiding embarassment by discussing the issue privately.
