#include "MainWindow.h"
#include "UrhoDevice.h"

#include <QApplication>
#include <QFile>
#include <QStyleFactory>

int main(int argc, char **argv)
{
    UrhoDevice::createContext();

    QApplication app(argc, argv);
    QCoreApplication::setOrganizationName("fredakilla");
    QCoreApplication::setApplicationName("Spkgen");
    QCoreApplication::setApplicationVersion(QT_VERSION_STR);

    qApp->setStyle(QStyleFactory::create("Fusion"));

    QPalette darkPalette;
    darkPalette.setColor(QPalette::Window, QColor(53,53,53));
    darkPalette.setColor(QPalette::WindowText, Qt::white);
    darkPalette.setColor(QPalette::Base, QColor(25,25,25));
    darkPalette.setColor(QPalette::AlternateBase, QColor(53,53,53));
    darkPalette.setColor(QPalette::ToolTipBase, Qt::white);
    darkPalette.setColor(QPalette::ToolTipText, Qt::white);
    darkPalette.setColor(QPalette::Text, Qt::white);
    darkPalette.setColor(QPalette::Button, QColor(53,53,53));
    darkPalette.setColor(QPalette::ButtonText, Qt::white);
    darkPalette.setColor(QPalette::BrightText, Qt::red);
    darkPalette.setColor(QPalette::Link, QColor(42, 130, 218));
    darkPalette.setColor(QPalette::Highlight, QColor(42, 130, 218));
    darkPalette.setColor(QPalette::HighlightedText, Qt::black);
    qApp->setPalette(darkPalette);

    MainWindow* mainWindow = new MainWindow();
    mainWindow->showMaximized();

    int ret = app.exec();

    delete mainWindow;
    UrhoDevice::freeContext();

    return ret;
}
