# CIGRE TB 880 - 2022
## Power cable rating examples for calculation tool verification

Reference IEC standards:
- "IEC 60287-1-1, Electric Cables - Calculation of the Current Rating - Part 1-1: Current Rating Equations (100 % load factor) and Calculation of Losses – General", IEC,  2014-11.  
- "IEC 60287-2-1, Electric Cables – Calculation of the Current Rating – Part 2-1: Thermal Resistance – Calculation of Thermal Resistance, Edition 2.0", IEC, 2015-2.

Jupyter Notebooks inspired in the [CIGRE Technical Brochure 880 Power cable rating examples for calculation tool verification](https://e-cigre.org/publication/880-power-cable-rating-examples-for-calculation-tool-verification) (2022).

List:
- __cigreTB880_case01.ipynb__: 4.1 - 4.5 CASE #0-1 Introductory Case Study 0 (no variations)
- __cigreTB880_case01spb.ipynb__: 4.6 CASE #0-1 Possible variations: 4.6.3 Variant with single point bonding
- __cigreTB880_case01ecl.ipynb__: 4.6 CASE #0-1 Possible variations: 4.6.4 Variant with non-neglected eddy-current losses
- __cigreTB880_case02_trefoil_touching HDPE ducts.ipynb__: 4.7 CASE #0-2 Sub-case study with touching HDPE ducts (Contribution by Adam Kierad)
- __cigreTB880_case02_trefoil_touching HDPE ducts eddycurrents.ipynb__: 4.7 CASE #0-2 Sub-case study with touching HDPE ducts: 4.7.7 Variant with non-neglected eddy-current losses (Contribution by Adam Kierad)
- __cigreTB880_case05.ipynb__: 4.10 CASE #0-5 Sub-case study with cables in an unfilled trough
- __cigreTB880_case05ecl.ipynb__: 4.10 CASE #0-5 Sub-case study with cables in an unfilled trough: 4.10.7 Variant with non-neglected eddy-current losses

