/*
 * NAppGUI Cross-platform C SDK
 * 2015-2024 Francisco Garcia Collado
 * MIT Licence
 * https://nappgui.com/en/legal/license.html
 *
 * File: res_gui.c
 *
 */

/* Gui library resources */

#include "res_gui.h"
#include <core/respackh.h>
#include <core/strings.h>
#include <sewer/cassert.h>

/*---------------------------------------------------------------------------*/

ResId ASSERT_CRASH = "N23R3C75::res_gui::0";
ResId ASSERT_INFO = "N23R3C75::res_gui::1";
ResId CONTACT_INFO = "N23R3C75::res_gui::2";
ResId FILE_TEXT = "N23R3C75::res_gui::3";
ResId LINE_TEXT = "N23R3C75::res_gui::4";
ResId SHOW_ASSERT = "N23R3C75::res_gui::5";
ResId ASSERT_LOG = "N23R3C75::res_gui::6";
ResId ASSERT_TITLE = "N23R3C75::res_gui::7";
ResId DEBUG_TEXT = "N23R3C75::res_gui::8";
ResId CONTINUE_TEXT = "N23R3C75::res_gui::9";
ResId EXIT_TEXT = "N23R3C75::res_gui::10";
ResId BOMB_PNG = "N23R3C75::res_gui::11";
ResId BOMB_DARK_PNG = "N23R3C75::res_gui::12";
ResId CONFUSED_PNG = "N23R3C75::res_gui::13";
ResId CONFUSED_DARK_PNG = "N23R3C75::res_gui::14";
ResId LOGO_PNG = "N23R3C75::res_gui::15";
ResId LOGO_DARK_PNG = "N23R3C75::res_gui::16";
static const char_t *ASSERT_CRASH_TEXT = "You can't continue with the program running.";
static const char_t *ASSERT_INFO_TEXT = "The program can continue in UNSECURED WAY. It's possible that the results now will be incorrect or data loss occurs.";
static const char_t *CONTACT_INFO_TEXT = "For more information about this incident, please contact with:";
static const char_t *FILE_TEXT_TEXT = "File";
static const char_t *LINE_TEXT_TEXT = "Line";
static const char_t *SHOW_ASSERT_TEXT = "Show this window in next assert.";
static const char_t *ASSERT_LOG_TEXT = "Write assert info in log.";
static const char_t *ASSERT_TITLE_TEXT = "%s ran into a problem";
static const char_t *DEBUG_TEXT_TEXT = "Debug";
static const char_t *CONTINUE_TEXT_TEXT = "Continue";
static const char_t *EXIT_TEXT_TEXT = "Exit";

/*---------------------------------------------------------------------------*/

static const uint32_t BOMB_PNG_SIZE = 1597;

static const byte_t BOMB_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x60, 0xB9, 0x55, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00,
    0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80, 0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA, 0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4B, 0x47,
    0x44, 0x00, 0x00, 0xAA, 0x8D, 0x23, 0x32, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0E, 0xC4, 0x00, 0x00, 0x0E, 0xC4, 0x01, 0x95, 0x2B, 0x0E, 0x1B, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE3, 0x04, 0x02, 0x12, 0x06, 0x09, 0x33, 0xA9, 0xC5, 0xFB, 0x00, 0x00, 0x05,
    0x0B, 0x49, 0x44, 0x41, 0x54, 0x68, 0xDE, 0xBD, 0xD9, 0x6B, 0x8C, 0x55, 0xD5, 0x15, 0x07, 0xF0, 0xDF, 0x30, 0x75, 0x90, 0xB7, 0x88, 0x53, 0x15, 0x01, 0x5F, 0xC5, 0xB6, 0x5A, 0x62, 0x7C, 0x4B, 0xA5, 0xD4, 0x04, 0x34, 0x46, 0x63, 0x34, 0x1A, 0x8A, 0x8F, 0xDA, 0x0F, 0x1A, 0xA3, 0x69, 0xD4, 0x68, 0x34,
    0xF1, 0x8B, 0xE0, 0x0B, 0xFD, 0x62, 0xB4, 0x12, 0xE3, 0x07, 0x4D, 0xA8, 0x5A, 0x83, 0x91, 0x10, 0xC5, 0x68, 0x7C, 0x3F, 0x50, 0x63, 0x5A, 0x5B, 0x63, 0xD0, 0x8A, 0xC6, 0x07, 0x2D, 0x6A, 0x82, 0xF2, 0x18, 0x07, 0xC7, 0x99, 0x01, 0x84, 0x99, 0x59, 0x7E, 0xB8, 0x9B, 0xE3, 0x1D, 0xB8, 0x97, 0x7B, 0xCF,
    0x39, 0x57, 0xFF, 0xE7, 0xCB, 0xC9, 0x5E, 0x6B, 0xAF, 0xB5, 0xF6, 0xDA, 0x67, 0xEF, 0xF5, 0x38, 0x94, 0xC3, 0x19, 0x1E, 0xF2, 0x99, 0x7E, 0x3D, 0x56, 0x5B, 0xEC, 0xB8, 0x92, 0xD2, 0x72, 0x62, 0xBA, 0xB7, 0xC4, 0xB0, 0x67, 0xC8, 0x32, 0x13, 0x7F, 0x2E, 0xF5, 0xBF, 0xF7, 0x4D, 0xA6, 0xB8, 0xCF, 0xD6,
    0xEC, 0xFD, 0x53, 0xD3, 0x7E, 0x0E, 0xF5, 0x87, 0xD8, 0x28, 0x84, 0x2E, 0x37, 0x98, 0x0C, 0x7E, 0xE3, 0x2E, 0xDB, 0x84, 0xB0, 0xCA, 0xE8, 0x9F, 0xDE, 0x80, 0x15, 0x42, 0xF8, 0x68, 0x97, 0xD5, 0x9E, 0x94, 0xBC, 0xB2, 0xB0, 0xCE, 0xAC, 0x49, 0xAE, 0xF5, 0xA0, 0x0B, 0xCB, 0xAB, 0x9F, 0x21, 0x84, 0x7E,
    0x87, 0xEF, 0x46, 0x39, 0x53, 0x08, 0xDF, 0xD5, 0xF4, 0xC1, 0x2C, 0x5D, 0x42, 0x18, 0x74, 0x50, 0x59, 0x03, 0x6E, 0x16, 0xC2, 0x3D, 0x35, 0x69, 0x2B, 0x85, 0x70, 0x4E, 0x8D, 0xD5, 0x77, 0xA5, 0xAF, 0x64, 0x9D, 0x31, 0x3F, 0x0E, 0x8F, 0x28, 0x64, 0x40, 0xE5, 0xB8, 0xAD, 0xA8, 0x49, 0x5B, 0x51, 0xC5,
    0x51, 0x8D, 0x4B, 0x4C, 0xC2, 0xC7, 0xCE, 0x37, 0x43, 0xFF, 0x8F, 0xC3, 0xBF, 0x28, 0x64, 0xC0, 0x01, 0xE0, 0xF3, 0x9A, 0xB4, 0xFF, 0x43, 0xFA, 0x30, 0xAB, 0x31, 0x03, 0xDC, 0xE4, 0xC9, 0xE1, 0xC3, 0xC5, 0x3C, 0xD0, 0x01, 0xB6, 0xD7, 0xA4, 0x7D, 0x05, 0x35, 0x8E, 0xE2, 0xC1, 0x55, 0xE6, 0x95, 0xC6,
    0x7B, 0x42, 0xD8, 0xBF, 0x26, 0x6D, 0x9C, 0x6D, 0x42, 0xBF, 0xFD, 0x86, 0x8D, 0x76, 0xDA, 0x22, 0x6C, 0x33, 0x76, 0x57, 0xF6, 0x62, 0x1E, 0xD8, 0x13, 0x7A, 0xBD, 0x88, 0xD1, 0xEE, 0xAF, 0x92, 0x3D, 0xC2, 0xFD, 0x46, 0xE1, 0x79, 0x7D, 0x3F, 0xBD, 0x07, 0x38, 0xC6, 0x80, 0x10, 0x5E, 0x74, 0x02, 0xDA,
    0x9C, 0xE0, 0x65, 0x21, 0xEC, 0x70, 0x74, 0xAB, 0x56, 0xB9, 0x67, 0x03, 0xB8, 0x36, 0xBB, 0x98, 0xB7, 0xD8, 0x92, 0xBD, 0x5F, 0x53, 0x8B, 0xB5, 0xF9, 0x53, 0xD0, 0xE1, 0xA2, 0x4C, 0xE5, 0x2F, 0xC1, 0x55, 0xC3, 0x1C, 0xDA, 0x67, 0xA9, 0x6F, 0xD3, 0xFB, 0xBD, 0xFA, 0xDD, 0x6B, 0x34, 0x46, 0xA5, 0x91,
    0x7E, 0xD7, 0xF8, 0x7B, 0xB9, 0x55, 0x2F, 0xDC, 0x25, 0xF2, 0xED, 0xFE, 0x2C, 0x1F, 0xC6, 0x3F, 0xD9, 0x1D, 0x56, 0xE9, 0xD5, 0x6B, 0x95, 0x45, 0x0E, 0x2C, 0xEF, 0xF6, 0x7F, 0x34, 0x34, 0xE0, 0xBD, 0x22, 0x62, 0xF3, 0x5E, 0x44, 0x4B, 0x7C, 0x86, 0x51, 0x66, 0x58, 0x6B, 0x53, 0x36, 0x3A, 0xD6, 0x4D,
    0xE5, 0x57, 0xD8, 0x9C, 0x07, 0x4E, 0xAF, 0x49, 0xDB, 0xBF, 0xB8, 0x07, 0x9A, 0xBB, 0x07, 0x3A, 0x5C, 0xE1, 0xB4, 0x86, 0x5C, 0xD3, 0x2D, 0x30, 0xA1, 0xF5, 0x2B, 0x6F, 0x77, 0xA5, 0x2F, 0xB2, 0x7D, 0x3E, 0xB2, 0x26, 0xCF, 0x48, 0x7D, 0x89, 0xDE, 0xED, 0xE6, 0xD6, 0xA6, 0x23, 0x87, 0x7A, 0x33, 0x53,
    0xFE, 0xA5, 0x4B, 0xEB, 0xF2, 0xCD, 0xF5, 0x7E, 0xC6, 0xF7, 0x89, 0x13, 0x5B, 0xA5, 0xFE, 0x62, 0x3D, 0x49, 0xE8, 0x3B, 0x2E, 0x68, 0xF8, 0xC1, 0xCE, 0xF5, 0x7C, 0xE2, 0xDE, 0x61, 0x81, 0xB6, 0xF2, 0xEA, 0xAF, 0x36, 0x94, 0x52, 0xCE, 0x1B, 0x9B, 0x8E, 0x19, 0x67, 0x66, 0xDB, 0xF5, 0x68, 0xC1, 0x50,
    0x9F, 0xE1, 0xB6, 0x24, 0x68, 0xA5, 0xA9, 0xB9, 0xE6, 0x8D, 0xF7, 0x48, 0x9A, 0xF9, 0xB8, 0xBD, 0x8A, 0xAB, 0xBF, 0x2E, 0x09, 0x79, 0x2C, 0xC5, 0xFE, 0x7C, 0xB8, 0x35, 0xCD, 0x5E, 0x52, 0x54, 0xFD, 0x1F, 0xED, 0x10, 0xC2, 0xE2, 0xB4, 0x93, 0x47, 0x7A, 0xC1, 0x13, 0xC6, 0xE5, 0x90, 0x70, 0x65, 0xDA,
    0xBE, 0x2B, 0x8A, 0xA8, 0x9F, 0x6C, 0xBD, 0x10, 0x9E, 0x4A, 0x3B, 0x7F, 0x5E, 0x3A, 0x64, 0xF3, 0x73, 0x49, 0xB9, 0x53, 0x08, 0xDB, 0x8A, 0x9C, 0x88, 0xA5, 0x42, 0xF8, 0xD0, 0x78, 0xF0, 0xE7, 0x14, 0xDD, 0xD7, 0xE5, 0x4C, 0xA6, 0xDB, 0x2C, 0x4B, 0x65, 0x4A, 0x7B, 0x3E, 0xF5, 0x33, 0x0D, 0x55, 0x25,
    0x0F, 0xA7, 0xA7, 0xCD, 0x78, 0xAB, 0x40, 0x3C, 0x9B, 0x98, 0xAA, 0xA7, 0xCB, 0xF2, 0x4D, 0xFB, 0x77, 0x55, 0xCE, 0x7F, 0x90, 0x6E, 0x21, 0xBC, 0x94, 0xC5, 0xF5, 0x7C, 0xB8, 0x54, 0x08, 0xEB, 0xAB, 0xEB, 0x80, 0xC6, 0xEB, 0x0F, 0x61, 0x43, 0x72, 0xFF, 0x73, 0x42, 0x58, 0x63, 0x9F, 0x42, 0xEA, 0x19,
    0xE1, 0x3F, 0x79, 0x7D, 0xB0, 0x44, 0x08, 0x8B, 0xC0, 0x59, 0xA9, 0x00, 0x2B, 0x93, 0xC9, 0x5D, 0x24, 0x84, 0x7F, 0x35, 0xCB, 0x3E, 0x4E, 0xAF, 0x30, 0x90, 0x72, 0xF8, 0xB7, 0x85, 0x70, 0x7B, 0x09, 0xF5, 0x8C, 0xB4, 0x41, 0x88, 0x54, 0x96, 0x34, 0xC4, 0x59, 0x29, 0x9B, 0x85, 0xE3, 0x85, 0xD0, 0x63,
    0xDF, 0x52, 0x06, 0x70, 0xB7, 0x10, 0x6E, 0xAC, 0x47, 0x1E, 0x7E, 0xC7, 0xCF, 0x02, 0xAF, 0x42, 0x3A, 0xF5, 0x0F, 0xE8, 0x2E, 0x69, 0xC0, 0x6B, 0xE0, 0x94, 0xE6, 0x98, 0x2B, 0xA1, 0x77, 0x26, 0x58, 0x2D, 0x44, 0x32, 0xA9, 0x0C, 0x26, 0x18, 0x10, 0xBA, 0x9A, 0x8B, 0x8E, 0x9B, 0x85, 0xEF, 0x75, 0x60,
    0xBC, 0x41, 0xA1, 0xA7, 0x4C, 0x38, 0xC9, 0xF0, 0x81, 0x10, 0xA6, 0xD4, 0x26, 0x56, 0x6F, 0xC1, 0x5E, 0x26, 0x60, 0x93, 0xED, 0x98, 0x6E, 0x04, 0x56, 0xD9, 0xD1, 0x02, 0x03, 0x2A, 0xE5, 0x6A, 0x67, 0x63, 0x03, 0x26, 0x69, 0x43, 0x17, 0x24, 0x7B, 0x37, 0xB6, 0x40, 0xBD, 0x94, 0x3D, 0xEF, 0x57, 0x9B,
    0x58, 0x6D, 0x40, 0xA5, 0xC1, 0xB6, 0x19, 0x52, 0x5E, 0xB7, 0x49, 0x2B, 0xF0, 0x0D, 0xD4, 0x3B, 0x4D, 0xD5, 0x06, 0x0C, 0x40, 0x0A, 0x1D, 0x95, 0xF7, 0x22, 0xB9, 0xC0, 0xEE, 0xA8, 0x7C, 0x47, 0x75, 0x36, 0xB3, 0xDA, 0x80, 0x4A, 0xA5, 0x57, 0xB9, 0x84, 0x2B, 0x87, 0x2F, 0x5F, 0x2E, 0x54, 0x0F, 0x15,
    0x89, 0xBD, 0x8D, 0x0D, 0xE8, 0x32, 0x60, 0x67, 0x6F, 0x63, 0x0D, 0xB4, 0xA8, 0xE5, 0x58, 0xB9, 0x57, 0xD7, 0x37, 0xC3, 0xFA, 0x69, 0x56, 0x76, 0xB7, 0xE9, 0x16, 0x86, 0xCA, 0x37, 0xD4, 0xB0, 0x51, 0x18, 0xAC, 0x17, 0x4F, 0x87, 0xDF, 0x84, 0xAB, 0xC1, 0x4C, 0x84, 0xD7, 0xD1, 0x56, 0xA3, 0xDD, 0x96,
    0x17, 0xBF, 0xD2, 0x89, 0xFF, 0xD9, 0xDA, 0x8C, 0x01, 0xAF, 0x83, 0x39, 0xD8, 0xD9, 0x6E, 0xCB, 0x97, 0x86, 0xD5, 0xC2, 0x9C, 0x2A, 0xC9, 0x0D, 0x71, 0x54, 0x4A, 0xBE, 0xDA, 0x31, 0xC6, 0xB7, 0x2D, 0xB9, 0x8C, 0x5F, 0x11, 0xC2, 0xBC, 0x66, 0xD9, 0x2B, 0x05, 0xD6, 0x19, 0x60, 0x91, 0x10, 0xDE, 0x2F,
    0x55, 0x60, 0x4C, 0x33, 0x58, 0xB7, 0x75, 0x5B, 0x13, 0xD7, 0x0B, 0x91, 0xE2, 0xE1, 0xC4, 0x14, 0xCB, 0xCF, 0x2D, 0x61, 0xC0, 0x62, 0x21, 0x3C, 0xD4, 0xFC, 0x84, 0x7D, 0x92, 0xE3, 0x67, 0x83, 0xF9, 0x86, 0x0C, 0x38, 0xB9, 0xB0, 0xFA, 0xA9, 0xB6, 0x08, 0x43, 0xCD, 0xA6, 0x23, 0x15, 0xDC, 0x21, 0x84,
    0xFF, 0x26, 0xC7, 0x1F, 0xEB, 0xD7, 0x25, 0xD6, 0xBF, 0x5C, 0x88, 0x3A, 0x3D, 0xE5, 0xBA, 0x18, 0x6F, 0x9D, 0x10, 0x6E, 0x29, 0xA1, 0xB8, 0x82, 0x3F, 0xA5, 0xD2, 0x64, 0x7A, 0xDE, 0x89, 0xF3, 0x85, 0x30, 0x60, 0x6E, 0x29, 0xF5, 0x47, 0xA4, 0xCD, 0xBC, 0xB5, 0xC8, 0xE4, 0x87, 0x53, 0x3E, 0x78, 0x6C,
    0x61, 0xF5, 0x9D, 0xE9, 0x56, 0x7D, 0xBB, 0x58, 0x40, 0x1B, 0x93, 0x8E, 0xE3, 0x86, 0x82, 0x3F, 0xE2, 0xA6, 0xF8, 0x50, 0x08, 0x5F, 0x17, 0x0F, 0x67, 0x93, 0xAD, 0x4D, 0x3F, 0x5F, 0xCE, 0xCE, 0x3D, 0xF7, 0xB8, 0xD4, 0xA4, 0xE8, 0x71, 0x4C, 0x51, 0xF5, 0x70, 0x98, 0x35, 0xE9, 0x5F, 0xE0, 0xDF, 0x72,
    0xB4, 0x9D, 0xDA, 0x5D, 0x97, 0xFE, 0x9D, 0x75, 0x97, 0x4F, 0x68, 0x0F, 0xF0, 0x4E, 0x6A, 0x34, 0x7C, 0x6E, 0x5E, 0x53, 0x4D, 0x9A, 0xD9, 0xDE, 0xCD, 0x66, 0xFC, 0xAE, 0xAC, 0x7A, 0x18, 0xE9, 0xBE, 0xAC, 0xF7, 0xB5, 0xDA, 0xE5, 0x7B, 0xE8, 0x02, 0xEE, 0x6D, 0x9E, 0x37, 0x32, 0xDE, 0xA7, 0x4B, 0x97,
    0x33, 0x55, 0x38, 0xCD, 0x27, 0x99, 0xE0, 0xAD, 0x9E, 0x75, 0x83, 0x53, 0xD3, 0x3F, 0x23, 0xD8, 0xD7, 0xC9, 0xFE, 0x6A, 0xB9, 0xCD, 0x19, 0xCF, 0x7A, 0x7F, 0x69, 0x45, 0x87, 0x6C, 0xB8, 0x1F, 0xAE, 0xAA, 0x6A, 0x55, 0xEE, 0x7C, 0xBA, 0x75, 0xA7, 0xD6, 0x45, 0xF5, 0xD8, 0x2D, 0x85, 0x2B, 0xE9, 0x06,
    0xE8, 0x30, 0xCF, 0x33, 0xB6, 0xD7, 0xED, 0x94, 0x0F, 0x7A, 0xD3, 0xE5, 0xB9, 0xBA, 0x48, 0x09, 0xF9, 0x9C, 0x35, 0xD6, 0x6C, 0x7F, 0xF0, 0x5B, 0x47, 0xE8, 0x34, 0x56, 0xBB, 0x3E, 0x1B, 0xAD, 0xF5, 0xB1, 0x7F, 0x5A, 0x99, 0xEA, 0x89, 0xDC, 0xF8, 0x01, 0x1D, 0xF7, 0x2E, 0x9F, 0x10, 0xD4, 0x47, 0x4B,
    0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x32, 0x54, 0x31, 0x36, 0x3A, 0x30, 0x36, 0x3A, 0x30, 0x39, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0xB5, 0xBF, 0xF6, 0x3A, 0x00,
    0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x32, 0x54, 0x31, 0x36, 0x3A, 0x30, 0x36, 0x3A, 0x30, 0x39, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0xC4, 0xE2, 0x4E, 0x86, 0x00, 0x00,
    0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x6E, 0x6B, 0x73, 0x63, 0x61, 0x70, 0x65, 0x2E, 0x6F, 0x72, 0x67, 0x9B, 0xEE, 0x3C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82};

/*---------------------------------------------------------------------------*/

static const uint32_t BOMB_DARK_PNG_SIZE = 1638;

static const byte_t BOMB_DARK_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x60, 0xB9, 0x55, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00,
    0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80, 0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA, 0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4B, 0x47,
    0x44, 0x00, 0x00, 0xAA, 0x8D, 0x23, 0x32, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0E, 0xC4, 0x00, 0x00, 0x0E, 0xC4, 0x01, 0x95, 0x2B, 0x0E, 0x1B, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE3, 0x04, 0x03, 0x0E, 0x0F, 0x0B, 0xA1, 0xE5, 0x22, 0xEF, 0x00, 0x00, 0x05,
    0x34, 0x49, 0x44, 0x41, 0x54, 0x68, 0xDE, 0xBD, 0x99, 0x69, 0x6C, 0x54, 0x55, 0x14, 0xC7, 0xFF, 0xAF, 0x95, 0xD6, 0x96, 0xB6, 0x50, 0xA0, 0x82, 0x65, 0x73, 0x2B, 0x2A, 0xDA, 0x18, 0x40, 0x14, 0x14, 0xD1, 0x84, 0x25, 0x04, 0x63, 0x30, 0x9A, 0x8A, 0xE2, 0xF2, 0x01, 0x43, 0x20, 0x06, 0x09, 0x44, 0x12,
    0xBE, 0xB0, 0x2A, 0xF8, 0xC5, 0xA8, 0x34, 0x86, 0x0F, 0x9A, 0x20, 0x2E, 0x81, 0x48, 0x88, 0xD6, 0x68, 0x14, 0x51, 0x11, 0x24, 0x44, 0x51, 0x62, 0x0A, 0x5A, 0x0C, 0x9B, 0x82, 0x26, 0x68, 0x29, 0xC3, 0x94, 0xD2, 0x85, 0xDA, 0x4E, 0xE7, 0xE7, 0x87, 0x77, 0xE7, 0xF5, 0x0D, 0xBC, 0x61, 0xDE, 0x32, 0x70,
    0x3E, 0xBD, 0xDC, 0xB3, 0xFC, 0xCF, 0x39, 0x77, 0xEE, 0xBD, 0xE7, 0x9C, 0x91, 0x22, 0x11, 0x33, 0xD8, 0xC4, 0x31, 0xDA, 0x69, 0xA1, 0x81, 0x5A, 0xC6, 0x45, 0xB3, 0x16, 0x14, 0xBC, 0x8A, 0xBD, 0xA4, 0x53, 0x92, 0xAD, 0x94, 0x5F, 0x2D, 0xF8, 0xFB, 0x38, 0xEB, 0x00, 0xB7, 0x71, 0xC1, 0xF9, 0x3E, 0xCA,
    0x88, 0xAB, 0x01, 0x7F, 0x03, 0x4D, 0x00, 0xC4, 0x58, 0x4A, 0xA5, 0x24, 0x71, 0x1B, 0xAF, 0xD1, 0x09, 0x40, 0x3D, 0xC5, 0x57, 0xDE, 0x81, 0x3A, 0x00, 0x7E, 0x4F, 0x8F, 0x96, 0x7B, 0x4D, 0x56, 0x56, 0x66, 0xD0, 0x1A, 0xC8, 0x62, 0xDE, 0xE1, 0xA9, 0xE8, 0xF0, 0xD5, 0x00, 0xB4, 0x73, 0xF3, 0x25, 0x9C,
    0x99, 0x00, 0x9C, 0xF7, 0xCA, 0x01, 0x93, 0x88, 0x01, 0xD0, 0xC3, 0xD0, 0xA8, 0x0E, 0xAC, 0x02, 0xE0, 0x0D, 0x4F, 0xDE, 0x2E, 0x00, 0x66, 0x79, 0x44, 0x1F, 0x33, 0xBF, 0x92, 0x53, 0xF4, 0xED, 0x5D, 0xCF, 0x0B, 0xE5, 0x81, 0x7D, 0xDC, 0xEA, 0x3C, 0x79, 0x75, 0x2E, 0x09, 0x37, 0x3D, 0xAB, 0x81, 0x92,
    0x0E, 0xEB, 0x71, 0x55, 0x5B, 0xED, 0xBD, 0xCB, 0xD7, 0x84, 0x72, 0x60, 0x88, 0x24, 0xE9, 0xA4, 0x27, 0xEF, 0x4F, 0x49, 0x52, 0xE5, 0x25, 0xEB, 0xD5, 0x92, 0xA4, 0xE5, 0xD6, 0x27, 0xE9, 0xCB, 0xE1, 0x32, 0x50, 0x20, 0x49, 0xEA, 0xF2, 0xE4, 0xFD, 0x23, 0x49, 0xBA, 0xF4, 0x28, 0x8E, 0x74, 0xB9, 0x17,
    0x95, 0x38, 0x00, 0xC0, 0x60, 0x4F, 0x5E, 0x29, 0x9D, 0x40, 0x3B, 0x83, 0xD2, 0x56, 0x2B, 0xE8, 0x00, 0x3A, 0x29, 0xB9, 0x58, 0x3E, 0x5C, 0x06, 0x2E, 0x43, 0x56, 0xAB, 0x76, 0x48, 0x2A, 0xD6, 0x06, 0x1C, 0xDB, 0xE4, 0x69, 0x83, 0x8A, 0x24, 0x6D, 0xB7, 0xDA, 0xAE, 0x78, 0x06, 0x24, 0xC6, 0x90, 0x00,
    0x60, 0x07, 0xE3, 0x25, 0x2C, 0xC6, 0xF3, 0x0D, 0x00, 0xDD, 0xDC, 0x95, 0xA3, 0x28, 0x2F, 0xEF, 0x80, 0xC4, 0x62, 0xE7, 0x62, 0xEE, 0xA0, 0xC3, 0xF9, 0x5E, 0xE4, 0x25, 0xEB, 0xFB, 0x14, 0x50, 0xA0, 0x39, 0x4A, 0x41, 0x5E, 0x27, 0x49, 0x5A, 0x88, 0x3B, 0xA1, 0x6D, 0xDA, 0x6C, 0x9D, 0xB3, 0x3F, 0xAD,
    0xF5, 0xB4, 0x6B, 0xBD, 0x8A, 0x25, 0x15, 0x19, 0x6E, 0xBB, 0x16, 0x59, 0xEF, 0x46, 0x8B, 0x7A, 0x25, 0xD9, 0x68, 0x5B, 0x9A, 0x7C, 0x25, 0xEB, 0xA8, 0xA7, 0x95, 0x56, 0xEA, 0x59, 0xCB, 0xF5, 0xD1, 0xD3, 0xFE, 0x41, 0x56, 0x07, 0x0E, 0x84, 0xB1, 0x1B, 0xF4, 0x22, 0xDA, 0xA8, 0x63, 0x92, 0x8A, 0x54,
    0xAD, 0x13, 0x3A, 0xE3, 0xAC, 0x96, 0x68, 0x79, 0xE4, 0x08, 0x7D, 0x66, 0x60, 0xBA, 0x27, 0x6F, 0x70, 0xF8, 0x0C, 0xF8, 0xBA, 0x07, 0x28, 0x60, 0xBE, 0xA6, 0x65, 0x15, 0xAB, 0x62, 0x05, 0xFD, 0x72, 0x1F, 0x79, 0x3E, 0x0B, 0xF8, 0xCB, 0xD9, 0xE7, 0xD1, 0x9E, 0x32, 0x85, 0xB4, 0x19, 0x7E, 0x9C, 0x55,
    0x39, 0x2D, 0x47, 0xB8, 0x91, 0x3D, 0x0E, 0xF8, 0xDF, 0xCC, 0xCD, 0x28, 0x37, 0x95, 0x83, 0x8E, 0xDC, 0x11, 0xEE, 0xC9, 0x15, 0xFC, 0xD3, 0xB4, 0x18, 0xA3, 0xFB, 0x79, 0x92, 0x2C, 0x3F, 0x58, 0xA6, 0xB2, 0xDD, 0x48, 0x77, 0xB3, 0x02, 0x2B, 0x3A, 0xFC, 0x8B, 0x24, 0x4D, 0xC9, 0xB9, 0x0C, 0x9F, 0x6F,
    0x06, 0x33, 0x9D, 0xED, 0xFA, 0x30, 0x9B, 0xC3, 0xD9, 0x4C, 0xBD, 0x6C, 0x0C, 0xED, 0x62, 0x78, 0x20, 0xBD, 0x32, 0xDE, 0x37, 0x9A, 0x1F, 0xD1, 0x27, 0x3C, 0xFC, 0x12, 0x63, 0x64, 0x0B, 0x05, 0x21, 0xB4, 0xD7, 0x18, 0xED, 0x8D, 0x61, 0xE1, 0x1F, 0xA4, 0x1B, 0x80, 0x5A, 0x7B, 0x27, 0x19, 0xCD, 0x57,
    0x7C, 0x4C, 0x69, 0x00, 0x0B, 0x0B, 0xCC, 0xF6, 0xCD, 0x0F, 0x03, 0x5F, 0x49, 0x23, 0x00, 0x9F, 0xDA, 0x3B, 0xCF, 0x63, 0xE6, 0x90, 0xCD, 0x0E, 0x64, 0xE5, 0x55, 0x00, 0x3A, 0x43, 0x9C, 0x08, 0x36, 0x03, 0x70, 0x88, 0x32, 0x49, 0xE2, 0x19, 0xF3, 0xBA, 0x9F, 0x0A, 0x56, 0x4C, 0x63, 0xB1, 0xD5, 0xB4,
    0x29, 0xF9, 0xC1, 0xE0, 0x27, 0x92, 0xEC, 0x2D, 0x1E, 0x98, 0x6E, 0x36, 0x63, 0x6F, 0xF0, 0xF7, 0x8C, 0x72, 0xD3, 0x3D, 0x3D, 0x1F, 0x4C, 0xED, 0xA7, 0xDE, 0x9A, 0x9F, 0xA1, 0xC4, 0x01, 0xF8, 0x9A, 0xA2, 0x40, 0x46, 0x52, 0xB6, 0xE6, 0x02, 0xD0, 0xE8, 0xEE, 0x03, 0xB2, 0xC7, 0x0F, 0x70, 0xDA, 0xA4,
    0xFF, 0x4B, 0x00, 0x8E, 0xD3, 0x3F, 0x0C, 0xBC, 0x44, 0x1E, 0x3F, 0x07, 0xCC, 0x01, 0x1B, 0x01, 0x58, 0x2B, 0x49, 0x3C, 0x6C, 0x1A, 0xB0, 0x08, 0x95, 0x1C, 0x73, 0x00, 0xF8, 0xD1, 0xAF, 0x78, 0x29, 0xAD, 0x40, 0x82, 0x91, 0x92, 0xC4, 0x3E, 0x00, 0x5E, 0x09, 0x0F, 0x2F, 0x51, 0xC8, 0x69, 0x00, 0xAA,
    0xFD, 0x89, 0xDB, 0x31, 0xEF, 0x90, 0x24, 0xEE, 0x06, 0xA0, 0x85, 0x01, 0x51, 0x1C, 0x90, 0x78, 0x1D, 0x80, 0x65, 0x99, 0xF8, 0xE9, 0x77, 0xFC, 0x24, 0x49, 0xD2, 0x4E, 0x49, 0x92, 0x7D, 0xEA, 0xDF, 0xB6, 0xE2, 0xD1, 0x1C, 0xD0, 0x77, 0x92, 0xA4, 0xFB, 0xFD, 0x79, 0x6B, 0x3F, 0xBD, 0x13, 0x25, 0x89,
    0x06, 0x00, 0x26, 0x45, 0x84, 0x17, 0xFD, 0x48, 0x00, 0x31, 0x5F, 0xAF, 0x23, 0xCD, 0xC0, 0x7F, 0x14, 0x48, 0x94, 0xD1, 0x03, 0xB4, 0x44, 0x78, 0x4E, 0x7A, 0xAD, 0xFE, 0x06, 0xC0, 0x30, 0x6F, 0xAE, 0x6B, 0x0B, 0xE8, 0xA3, 0x7E, 0x92, 0xCE, 0x58, 0x5D, 0x92, 0xAA, 0x94, 0x27, 0xA9, 0xDE, 0xEA, 0x8E,
    0xEE, 0x80, 0x69, 0x57, 0x2B, 0xB2, 0x3A, 0xA0, 0x81, 0xB2, 0x24, 0xC5, 0x24, 0x49, 0xB6, 0xBF, 0x4D, 0x39, 0x80, 0x97, 0xA9, 0x9E, 0x07, 0x79, 0x33, 0xDD, 0x0E, 0xD8, 0x03, 0xB6, 0x66, 0x49, 0x52, 0xB1, 0x4B, 0x35, 0x2A, 0x9D, 0x95, 0x24, 0x65, 0x38, 0x4D, 0x6E, 0x07, 0x12, 0x92, 0xA4, 0x7C, 0xD7,
    0x77, 0x88, 0x5A, 0xC0, 0x83, 0xEC, 0xDF, 0x51, 0x86, 0xCD, 0x74, 0x3B, 0x60, 0x77, 0x7A, 0x65, 0x92, 0x24, 0xFB, 0xF0, 0x05, 0xAA, 0x85, 0x32, 0x92, 0x6D, 0xB1, 0x35, 0xBB, 0x03, 0x31, 0x25, 0x94, 0x9A, 0x6D, 0x1C, 0x97, 0xE4, 0x35, 0xE7, 0x08, 0x43, 0xF6, 0x6C, 0xA4, 0xD1, 0x87, 0x24, 0x47, 0x53,
    0x6D, 0x37, 0x16, 0x71, 0x20, 0x19, 0x79, 0xA0, 0x26, 0x89, 0x26, 0xA0, 0x27, 0xD3, 0x7B, 0x9A, 0x7E, 0x13, 0x36, 0x48, 0x92, 0x26, 0x4A, 0x16, 0xDA, 0x2D, 0xC9, 0xD2, 0x2C, 0x45, 0x24, 0x6E, 0x51, 0x85, 0xA4, 0x3F, 0xAC, 0x0B, 0x7E, 0x1C, 0xD8, 0x2D, 0x49, 0x9A, 0x22, 0x29, 0x35, 0x6E, 0x0B, 0x54,
    0x86, 0x79, 0xD2, 0x14, 0x97, 0xE5, 0xAC, 0xDE, 0xDE, 0x61, 0x8A, 0xAF, 0x7C, 0x89, 0xBE, 0x9C, 0xCB, 0xC5, 0x65, 0xCC, 0xB7, 0x00, 0xD4, 0xF8, 0x15, 0xB7, 0x1B, 0xAC, 0x19, 0x92, 0xC4, 0x5A, 0x00, 0x0E, 0x46, 0x69, 0x30, 0x18, 0x41, 0x0F, 0x19, 0x46, 0xB7, 0xDE, 0x0A, 0x2F, 0x01, 0xB0, 0x53, 0x92,
    0x28, 0x37, 0x6F, 0xF9, 0xA3, 0x11, 0x1C, 0xA8, 0x05, 0x60, 0x93, 0x7F, 0x85, 0xFE, 0x26, 0xF1, 0x93, 0x25, 0x89, 0xD9, 0x24, 0x49, 0x30, 0x21, 0x34, 0xFC, 0x70, 0x3A, 0x80, 0xA4, 0xCF, 0x72, 0xC4, 0x28, 0xAD, 0x03, 0xE0, 0x57, 0x3B, 0xF1, 0x8C, 0xE5, 0xD6, 0x08, 0xF1, 0x6F, 0x03, 0xA0, 0x2E, 0x98,
    0x52, 0x19, 0xA7, 0x00, 0x58, 0x1D, 0x1E, 0xD8, 0x58, 0x7A, 0xC2, 0xB4, 0x26, 0x55, 0x41, 0x15, 0x67, 0x03, 0x90, 0x60, 0x6A, 0x24, 0xF8, 0x51, 0x66, 0x33, 0xD7, 0x84, 0x51, 0x7E, 0xCF, 0xD4, 0x83, 0x63, 0x43, 0xC3, 0x57, 0x98, 0x5B, 0x75, 0x5F, 0x98, 0xE6, 0x56, 0xF4, 0x35, 0xC7, 0xF1, 0x74, 0xB8,
    0x3F, 0xE2, 0x18, 0xC6, 0x21, 0x00, 0xFE, 0x0D, 0xD6, 0xDA, 0xBB, 0x4D, 0x54, 0x72, 0x02, 0x80, 0xF3, 0x3C, 0x12, 0x58, 0x77, 0x9C, 0x19, 0x52, 0xB4, 0x30, 0x26, 0x6C, 0x06, 0x25, 0x71, 0x13, 0xC7, 0x01, 0x48, 0xF2, 0xA6, 0xFF, 0xB1, 0x13, 0xF9, 0x2C, 0x31, 0xFF, 0x9D, 0xC5, 0x23, 0x17, 0xB4, 0x0C,
    0x61, 0xBF, 0x19, 0x34, 0x9C, 0xA4, 0xC6, 0xCF, 0x90, 0x86, 0xC9, 0xFC, 0xE2, 0x68, 0xDC, 0x19, 0x11, 0x5E, 0x92, 0x28, 0xE4, 0x2D, 0x67, 0xF6, 0xD5, 0xC0, 0xBC, 0xCC, 0x53, 0x40, 0xAE, 0xA5, 0x86, 0xEF, 0x1D, 0xD9, 0xCF, 0xA2, 0xB6, 0x33, 0x6E, 0xD3, 0xD3, 0x38, 0xE2, 0x18, 0xBE, 0xC0, 0x17, 0x2C,
    0xE5, 0x21, 0x86, 0x38, 0xDC, 0x01, 0x4C, 0xE0, 0x05, 0xB6, 0xD1, 0xEC, 0xC8, 0x34, 0xF2, 0x5C, 0x0E, 0x26, 0x64, 0x17, 0xE5, 0x61, 0xA1, 0x6B, 0x54, 0x99, 0xA2, 0x38, 0x71, 0x33, 0xBA, 0x70, 0xAF, 0xAD, 0x0E, 0xDB, 0x49, 0x67, 0x73, 0xA2, 0x80, 0x1A, 0x3E, 0xA7, 0x8B, 0x4C, 0xD4, 0xC3, 0x1E, 0xE6,
    0x05, 0x99, 0x22, 0xA5, 0x28, 0x50, 0xB2, 0x28, 0xD1, 0x64, 0x3D, 0xA0, 0xDB, 0x35, 0x4A, 0x15, 0x2A, 0x51, 0xBE, 0xDA, 0xD4, 0xA4, 0x13, 0x3A, 0xAC, 0x1F, 0xB4, 0xCB, 0x8A, 0x85, 0x0B, 0xED, 0x7F, 0x8A, 0x74, 0xE6, 0x10, 0x8E, 0xE1, 0x57, 0x4D, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
    0x61, 0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A, 0x31, 0x35, 0x3A, 0x31, 0x31, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0x0E, 0x92, 0x27, 0x07, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
    0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A, 0x31, 0x35, 0x3A, 0x31, 0x31, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0x7F, 0xCF, 0x9F, 0xBB, 0x00, 0x00, 0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6F, 0x66,
    0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x6E, 0x6B, 0x73, 0x63, 0x61, 0x70, 0x65, 0x2E, 0x6F, 0x72, 0x67, 0x9B, 0xEE, 0x3C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82};

/*---------------------------------------------------------------------------*/

static const uint32_t CONFUSED_PNG_SIZE = 1652;

static const byte_t CONFUSED_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x60, 0xB9, 0x55, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00,
    0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80, 0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA, 0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4B, 0x47,
    0x44, 0x00, 0x00, 0xAA, 0x8D, 0x23, 0x32, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0E, 0xC4, 0x00, 0x00, 0x0E, 0xC4, 0x01, 0x95, 0x2B, 0x0E, 0x1B, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE3, 0x04, 0x03, 0x0E, 0x0F, 0x2B, 0x9A, 0x8B, 0x02, 0x27, 0x00, 0x00, 0x05,
    0x42, 0x49, 0x44, 0x41, 0x54, 0x68, 0xDE, 0xC5, 0x99, 0x6B, 0x6C, 0x54, 0x55, 0x10, 0xC7, 0x7F, 0xBB, 0x2D, 0x2A, 0x74, 0x8B, 0xB4, 0xD6, 0x96, 0x57, 0x69, 0x31, 0x52, 0x4A, 0x00, 0x1F, 0xF0, 0x45, 0x8C, 0x44, 0x13, 0x30, 0xD1, 0x94, 0xA6, 0x10, 0xBE, 0x28, 0x41, 0x1E, 0x7E, 0xD1, 0x2F, 0x94, 0x4A,
    0x1A, 0x8C, 0x08, 0x98, 0x68, 0x00, 0x41, 0x88, 0xD1, 0x48, 0x34, 0x46, 0x79, 0x94, 0x46, 0x83, 0xE2, 0x0B, 0x09, 0xCF, 0xF8, 0xA4, 0x52, 0x34, 0x08, 0xE5, 0xB1, 0xCA, 0x42, 0x8C, 0x18, 0x05, 0x0B, 0x7D, 0x41, 0x28, 0x44, 0x85, 0x76, 0xFC, 0x70, 0x67, 0x6F, 0xEF, 0x6E, 0xEF, 0x6B, 0x2F, 0xBB, 0x65,
    0xCE, 0xA7, 0x7B, 0xCE, 0xCC, 0xFC, 0xE7, 0x9C, 0x33, 0xE7, 0x9E, 0x99, 0x39, 0x21, 0x52, 0xA5, 0x42, 0x26, 0x33, 0x8E, 0x72, 0xCA, 0xC8, 0x63, 0x10, 0x11, 0xA0, 0x93, 0x8B, 0x74, 0x10, 0xE3, 0x24, 0x51, 0xBE, 0xA7, 0x25, 0x65, 0x8D, 0xBE, 0x69, 0x22, 0xEB, 0x38, 0x4E, 0x37, 0xE2, 0xD2, 0xBA, 0x39,
    0xC6, 0x3A, 0x26, 0xA4, 0x1B, 0x3A, 0x97, 0x45, 0x9C, 0x70, 0x05, 0x4E, 0x6E, 0x27, 0x78, 0x8E, 0x88, 0x1F, 0xD5, 0x21, 0x4F, 0x8E, 0x3C, 0xAA, 0xA9, 0x26, 0xDF, 0xD2, 0xF3, 0x0B, 0x07, 0x89, 0x11, 0xE3, 0x2F, 0x3A, 0xB9, 0x02, 0xE4, 0x10, 0xA1, 0x98, 0x32, 0x46, 0x33, 0x89, 0x31, 0x16, 0xBE, 0x36,
    0xDE, 0xE0, 0x4D, 0x2E, 0xDD, 0xC8, 0xCC, 0x43, 0xCC, 0xE3, 0x82, 0x39, 0xAB, 0x6B, 0xEC, 0x60, 0x36, 0x83, 0x5D, 0x25, 0x86, 0xF0, 0x14, 0x3B, 0xB9, 0x6E, 0xCA, 0x34, 0x33, 0xC7, 0xC7, 0x24, 0x1D, 0xE8, 0x2E, 0xF6, 0x9B, 0x8A, 0x2E, 0xB0, 0xC4, 0x03, 0x3A, 0xD1, 0x8C, 0xA5, 0xB4, 0x98, 0xB2, 0xDF,
    0x52, 0x1A, 0x04, 0x7E, 0x26, 0x17, 0x55, 0x41, 0x1B, 0x35, 0x0C, 0x48, 0x59, 0x3E, 0x87, 0x45, 0xB4, 0xAB, 0x86, 0x76, 0xA6, 0xA7, 0x26, 0x1C, 0x62, 0x8D, 0xE9, 0xD5, 0x1B, 0xB8, 0x33, 0xE8, 0x12, 0x52, 0xC8, 0x26, 0x3D, 0x35, 0xDD, 0xAC, 0xF4, 0xBF, 0x15, 0x59, 0xBC, 0xA7, 0xF0, 0x2D, 0x3C, 0x1E,
    0x18, 0x3C, 0x4E, 0x53, 0x68, 0x56, 0x6D, 0x75, 0xF4, 0xF3, 0x23, 0xD0, 0x8F, 0x2F, 0x54, 0xA0, 0x81, 0x61, 0x37, 0x0C, 0x0F, 0x30, 0x9C, 0x03, 0xAA, 0xF1, 0x73, 0xB2, 0xBD, 0x98, 0x43, 0x6C, 0x50, 0xE6, 0xED, 0xF4, 0x4F, 0x0B, 0x3C, 0xC0, 0xAD, 0x6C, 0x53, 0xAD, 0x5B, 0xBC, 0x36, 0x62, 0xB5, 0xB9,
    0x5C, 0x9E, 0xB6, 0xA6, 0x44, 0xD9, 0x6C, 0x51, 0xCD, 0x2B, 0xDD, 0xD8, 0x2A, 0xD5, 0x65, 0xB6, 0xA7, 0x19, 0x1E, 0x20, 0x8B, 0x4F, 0xD4, 0x1D, 0xA7, 0x3B, 0xB1, 0x8C, 0xA4, 0x03, 0x41, 0xF8, 0x21, 0x8D, 0x8B, 0x6F, 0xA5, 0xFE, 0x34, 0xEA, 0xB1, 0x2E, 0xB1, 0x1B, 0x0E, 0xF1, 0x9D, 0x7A, 0xFE, 0xF0,
    0x8C, 0xC0, 0x03, 0x14, 0xD3, 0x8A, 0x20, 0x7C, 0x6D, 0xE7, 0x09, 0x73, 0x75, 0x81, 0x6E, 0xFC, 0xE0, 0xB9, 0x51, 0x85, 0x6E, 0xF2, 0xAC, 0xE4, 0x81, 0x41, 0x9C, 0x47, 0x10, 0x36, 0x66, 0x14, 0x1E, 0xA0, 0x0E, 0x41, 0x38, 0xC7, 0xC0, 0xC4, 0xEE, 0xE5, 0xFA, 0xCB, 0x2C, 0xCC, 0xB8, 0x01, 0x45, 0xEA,
    0x69, 0x2F, 0x58, 0x3B, 0x23, 0xBA, 0x37, 0x8B, 0x32, 0x0E, 0x0F, 0x50, 0xAB, 0xD7, 0x5B, 0x4E, 0x4F, 0x57, 0x8D, 0xBA, 0x5F, 0x8E, 0xAB, 0xE0, 0x2D, 0xBE, 0x21, 0xDC, 0x39, 0xE3, 0xD3, 0xAD, 0xEE, 0xE9, 0x3A, 0x8E, 0x20, 0x2C, 0x75, 0x14, 0xE9, 0xC7, 0x4B, 0x9C, 0xA5, 0x8B, 0x28, 0x55, 0x9E, 0xE0,
    0xF3, 0x38, 0x8D, 0x70, 0x86, 0x6A, 0xC2, 0x8E, 0x3C, 0xCB, 0x10, 0x84, 0xA6, 0xF8, 0xE7, 0x04, 0x04, 0xE1, 0x3A, 0x43, 0x1C, 0x05, 0xD6, 0x5B, 0x82, 0xAD, 0x19, 0xAE, 0xF0, 0xCF, 0x58, 0x38, 0x97, 0x38, 0x72, 0x0D, 0xD5, 0x90, 0xE5, 0x1E, 0xE3, 0x73, 0x2D, 0x82, 0xB0, 0xCB, 0x91, 0x7D, 0x48, 0x42,
    0x20, 0x7A, 0xD2, 0xD5, 0x80, 0x66, 0x0B, 0xE7, 0x3F, 0xC9, 0x9E, 0x6E, 0xA1, 0xBD, 0x08, 0xC2, 0xAB, 0xC6, 0xC7, 0x51, 0x04, 0x61, 0x8E, 0x23, 0xF3, 0xD4, 0xA4, 0x80, 0xD3, 0xF9, 0x52, 0x2D, 0x4A, 0xE2, 0x9C, 0xE8, 0xC8, 0x39, 0x1F, 0x41, 0xF8, 0x19, 0xE0, 0x0E, 0xBA, 0x10, 0xC4, 0xE5, 0xEA, 0x1D,
    0x95, 0xA0, 0xB4, 0xD9, 0x65, 0xFE, 0x59, 0x5C, 0x4E, 0x08, 0xD1, 0x9D, 0x83, 0xB8, 0x62, 0x04, 0xA1, 0x8B, 0x02, 0x98, 0x81, 0x20, 0xFC, 0xEA, 0xA2, 0x36, 0xC4, 0x1E, 0x8B, 0x5A, 0xF7, 0xA3, 0xBA, 0xD6, 0xC2, 0xB9, 0xC9, 0x95, 0xF3, 0x14, 0x82, 0x50, 0x15, 0xF7, 0x48, 0xF7, 0x3F, 0x60, 0x11, 0x3B,
    0xD5, 0x51, 0x57, 0xB9, 0xF8, 0x36, 0xC0, 0x6D, 0xBC, 0xA3, 0x1E, 0xF3, 0x81, 0x8B, 0x07, 0x00, 0x6C, 0x46, 0x10, 0x5E, 0x84, 0x7A, 0x04, 0xE1, 0x79, 0xBC, 0x68, 0x2C, 0x53, 0x5C, 0xCE, 0x89, 0x95, 0x4A, 0x98, 0xCA, 0xDD, 0x9E, 0x5C, 0x4B, 0x10, 0x84, 0xCD, 0xF0, 0x93, 0x8F, 0xC3, 0x95, 0x09, 0x9A,
    0x89, 0x20, 0x1C, 0x0C, 0x53, 0x00, 0xC0, 0xD9, 0x3E, 0x37, 0xC0, 0x40, 0x2C, 0x08, 0x93, 0x0B, 0xC0, 0xE5, 0x3E, 0x37, 0xC0, 0x40, 0xCC, 0x0D, 0x6B, 0x0A, 0xD9, 0x79, 0xF3, 0x0C, 0xB8, 0xC9, 0x14, 0xD6, 0xB9, 0xFB, 0x4A, 0xA5, 0xD3, 0x4A, 0xBA, 0xF5, 0xE1, 0xF8, 0x52, 0xDC, 0x3C, 0x03, 0x5A, 0x01,
    0xD2, 0x94, 0x03, 0xA5, 0x42, 0x06, 0x62, 0x6B, 0x98, 0x53, 0x00, 0x8C, 0xEE, 0x73, 0x03, 0xCA, 0x01, 0x88, 0x85, 0xF5, 0x7A, 0xED, 0x7B, 0x03, 0xCA, 0x0C, 0x03, 0xB2, 0x89, 0x02, 0x30, 0xC9, 0xB7, 0x60, 0x11, 0x93, 0x19, 0x43, 0x3E, 0x97, 0xF9, 0x9D, 0x06, 0x4E, 0x07, 0x36, 0xE0, 0x41, 0x00, 0xA2,
    0x7E, 0xAE, 0xE3, 0x1E, 0xAA, 0x64, 0xAF, 0x72, 0xC7, 0xDB, 0x01, 0x2A, 0x03, 0xC1, 0x8F, 0xD0, 0xEB, 0x38, 0x1F, 0xA0, 0x09, 0x41, 0x98, 0xEB, 0xB9, 0x64, 0xFB, 0x11, 0xDB, 0xB6, 0x2D, 0xA1, 0x84, 0x65, 0xA5, 0xFB, 0x39, 0xC4, 0xC7, 0xB6, 0xD5, 0x95, 0xA7, 0x11, 0x84, 0x43, 0xC6, 0xC7, 0x6B, 0x08,
    0xC2, 0x6E, 0x57, 0xF8, 0x67, 0xB9, 0x62, 0x02, 0x36, 0xF1, 0x36, 0x2B, 0x58, 0x4F, 0x83, 0x19, 0xAA, 0x45, 0x6D, 0xD3, 0xB9, 0xC1, 0xFC, 0x81, 0x20, 0xCC, 0xB4, 0x19, 0xDB, 0x87, 0x20, 0xAC, 0x8A, 0xDB, 0x69, 0x2C, 0x87, 0x73, 0x4E, 0xB8, 0x50, 0x81, 0xBA, 0xD8, 0x9A, 0x10, 0x66, 0x8D, 0x62, 0xBB,
    0x8E, 0x9C, 0x51, 0xA7, 0xEA, 0xA1, 0x41, 0x1C, 0x46, 0x10, 0xAE, 0x32, 0xB2, 0x97, 0xBE, 0x78, 0x50, 0x3A, 0x3E, 0xDE, 0x61, 0x44, 0x85, 0xCB, 0x1C, 0x0D, 0xD8, 0x85, 0x20, 0xFC, 0xC6, 0x43, 0x36, 0x63, 0x0B, 0xD4, 0x2B, 0x9A, 0x79, 0xD8, 0xD2, 0x3B, 0x8E, 0xA8, 0x86, 0x65, 0x76, 0xB1, 0xA6, 0x91,
    0x87, 0x1D, 0x49, 0x9E, 0x61, 0xAB, 0xE3, 0x0F, 0xF9, 0x11, 0xA2, 0x7C, 0x44, 0x9E, 0xC3, 0xE8, 0x2C, 0xFE, 0x53, 0xB0, 0x0F, 0xA9, 0x60, 0x3C, 0x8F, 0xF1, 0x2E, 0xFF, 0xEA, 0xCA, 0xD4, 0xDA, 0xF0, 0xE7, 0x6A, 0x62, 0xB2, 0xA0, 0xA7, 0x2B, 0x47, 0xAB, 0x7A, 0xB5, 0x04, 0xA3, 0x0A, 0xAE, 0xDA, 0x38,
    0xE7, 0x35, 0x16, 0xDA, 0x72, 0x2F, 0x46, 0x10, 0xCE, 0x27, 0x3A, 0xE7, 0x52, 0x04, 0xE1, 0x92, 0xCF, 0xA0, 0xAB, 0x37, 0x95, 0xD3, 0x90, 0x04, 0x7F, 0x8C, 0x07, 0x6C, 0x39, 0xE3, 0xC9, 0x69, 0x52, 0x10, 0x78, 0x3B, 0x7F, 0xC7, 0x63, 0xB4, 0x80, 0x14, 0xE6, 0x51, 0xEA, 0x38, 0x4E, 0x2B, 0x31, 0xEA,
    0x99, 0xE6, 0x18, 0xBC, 0x1A, 0x31, 0xE8, 0xD9, 0xDE, 0xD7, 0xDF, 0x6C, 0xDD, 0xC7, 0x8A, 0xC0, 0x26, 0xF8, 0xA1, 0x78, 0x15, 0xEA, 0x89, 0xDE, 0x43, 0x21, 0xBE, 0x51, 0x57, 0x2C, 0xCE, 0x18, 0x7C, 0x09, 0x6D, 0x08, 0xC2, 0x3E, 0xFB, 0xE1, 0x52, 0xAD, 0xED, 0x36, 0x06, 0xA8, 0x0C, 0xFB, 0xA1, 0x01,
    0x1A, 0x81, 0xBB, 0x4C, 0x71, 0x9A, 0x2E, 0xD0, 0x8E, 0x8C, 0x94, 0xE9, 0x3E, 0xD3, 0x4D, 0x76, 0x4D, 0xF1, 0x57, 0x98, 0x15, 0xCD, 0x74, 0x17, 0x2A, 0xEB, 0x55, 0xF3, 0xCB, 0xEE, 0x8C, 0x21, 0xB3, 0x50, 0xFD, 0x65, 0x1A, 0x37, 0x62, 0x00, 0x3B, 0xCC, 0x0A, 0xAC, 0x67, 0xCD, 0x3C, 0x5B, 0x97, 0x4A,
    0x68, 0x4C, 0x93, 0x3B, 0x96, 0xF0, 0xA3, 0x6A, 0xFC, 0xD4, 0xDF, 0xBA, 0x66, 0xB3, 0x51, 0x05, 0x5A, 0xD3, 0x70, 0x28, 0x2B, 0xD5, 0xF3, 0x85, 0xF7, 0xFD, 0x6F, 0x6B, 0x88, 0x95, 0xE6, 0x43, 0x43, 0x1D, 0x45, 0x81, 0xC1, 0x07, 0x53, 0x6F, 0xEA, 0x79, 0x25, 0xD5, 0xB7, 0xA3, 0x2A, 0xF3, 0xC1, 0xA5,
    0x83, 0xDA, 0x00, 0x79, 0x43, 0x84, 0xC5, 0x96, 0x47, 0x9F, 0x40, 0x71, 0x53, 0xA9, 0xFE, 0x9A, 0x8C, 0x12, 0xDE, 0x32, 0x86, 0xFA, 0x96, 0x1C, 0xC6, 0x72, 0xBD, 0xF1, 0x04, 0xE1, 0x2B, 0x46, 0x04, 0x5D, 0xC2, 0x10, 0xB3, 0xF5, 0x8E, 0x30, 0xCA, 0x13, 0xBB, 0x99, 0xE7, 0x11, 0x3B, 0x0E, 0x67, 0x3E,
    0x7B, 0x2C, 0xCF, 0x76, 0xE7, 0x78, 0xD2, 0x0B, 0xC2, 0x8B, 0x06, 0xB2, 0x80, 0x1A, 0x4D, 0xE2, 0x0D, 0x8A, 0xD1, 0x48, 0x8C, 0x18, 0x7F, 0xD2, 0x49, 0x27, 0x10, 0x21, 0xC2, 0x08, 0xCA, 0x28, 0x67, 0x52, 0x42, 0x5C, 0xD4, 0xC2, 0xEB, 0xBC, 0x95, 0x9E, 0xBC, 0x3B, 0x87, 0x1A, 0x8E, 0x39, 0x84, 0xA4,
    0xF6, 0xED, 0x28, 0x0B, 0x3D, 0xEA, 0xAE, 0x01, 0xE8, 0x3E, 0xD6, 0x70, 0x24, 0x29, 0x2C, 0x4F, 0x6E, 0x5D, 0x1C, 0x66, 0x35, 0xF7, 0xFA, 0x57, 0x9A, 0xFA, 0xB3, 0x6A, 0x01, 0x93, 0x19, 0xCB, 0x18, 0xCA, 0xC8, 0xB7, 0x3C, 0xDF, 0xB7, 0x9B, 0xCF, 0xF7, 0x6D, 0xA9, 0xA9, 0xFB, 0x1F, 0x4A, 0x53, 0xC7,
    0x8F, 0x74, 0xB5, 0xE2, 0xF5, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A, 0x31, 0x35, 0x3A, 0x34, 0x33, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30,
    0xD1, 0xED, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A, 0x31, 0x35, 0x3A, 0x34, 0x33, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0xA0,
    0xB0, 0x80, 0xF6, 0x00, 0x00, 0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x6E, 0x6B, 0x73, 0x63, 0x61, 0x70, 0x65, 0x2E, 0x6F, 0x72, 0x67, 0x9B, 0xEE, 0x3C, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42,
    0x60, 0x82};

/*---------------------------------------------------------------------------*/

static const uint32_t CONFUSED_DARK_PNG_SIZE = 2413;

static const byte_t CONFUSED_DARK_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x60, 0xB9, 0x55, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61, 0x05, 0x00,
    0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80, 0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA, 0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4B, 0x47,
    0x44, 0x00, 0x00, 0xAA, 0x8D, 0x23, 0x32, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0D, 0xD7, 0x00, 0x00, 0x0D, 0xD7, 0x01, 0x42, 0x28, 0x9B, 0x78, 0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE3, 0x04, 0x03, 0x0E, 0x0F, 0x3B, 0x87, 0x3C, 0x12, 0x43, 0x00, 0x00, 0x08,
    0x3B, 0x49, 0x44, 0x41, 0x54, 0x68, 0xDE, 0xBD, 0x99, 0x7D, 0x6C, 0x95, 0xF5, 0x15, 0xC7, 0x3F, 0xCF, 0xD3, 0x5B, 0xDA, 0xD2, 0x52, 0x5E, 0xCB, 0x6B, 0x79, 0x47, 0x90, 0xB7, 0x86, 0x89, 0xCA, 0x36, 0xCA, 0xFE, 0x70, 0x05, 0x83, 0x0A, 0x31, 0xEE, 0x05, 0xB3, 0x6C, 0x66, 0x23, 0x31, 0x53, 0xD2, 0x28,
    0xB8, 0x98, 0xEC, 0x9F, 0x19, 0xA7, 0xC9, 0xE2, 0x00, 0x27, 0x6E, 0x31, 0x59, 0xB6, 0x48, 0x86, 0xBA, 0x44, 0xA7, 0xC3, 0x64, 0xD9, 0x9C, 0x0A, 0x73, 0x42, 0xD5, 0x48, 0x91, 0x54, 0x11, 0x68, 0x16, 0x91, 0xBE, 0xD0, 0xF2, 0xD2, 0x12, 0x5A, 0xA0, 0xA5, 0xED, 0xBD, 0xBD, 0xCF, 0x67, 0x7F, 0x50, 0x90,
    0x97, 0x7B, 0xDB, 0xDB, 0x52, 0x3C, 0x7F, 0xDD, 0xFC, 0x7E, 0xE7, 0x9C, 0xEF, 0xF7, 0x39, 0xCF, 0x79, 0x7E, 0xF7, 0xFC, 0xCE, 0x09, 0xE8, 0x97, 0x38, 0x84, 0xE9, 0xDC, 0xCA, 0x7C, 0x6E, 0x62, 0x3A, 0xA3, 0x19, 0xC1, 0x50, 0xE0, 0x3C, 0xAD, 0x9C, 0xA2, 0x86, 0xC3, 0x1C, 0xE0, 0x13, 0x6A, 0x82, 0x44,
    0x7F, 0x3C, 0x06, 0x19, 0x43, 0x8F, 0x60, 0x19, 0x77, 0xB1, 0x94, 0x62, 0x86, 0x90, 0x45, 0x48, 0x16, 0x01, 0x01, 0x01, 0x20, 0x22, 0x49, 0x22, 0x92, 0xC4, 0x39, 0xCA, 0x87, 0xBC, 0x45, 0x45, 0x70, 0x66, 0x10, 0x09, 0x58, 0xC2, 0xFD, 0x2C, 0xA7, 0x98, 0x02, 0x72, 0x89, 0x7D, 0xB5, 0x4C, 0x17, 0x1D,
    0x40, 0x1E, 0x39, 0x97, 0xF9, 0xE9, 0xA6, 0x83, 0x36, 0x1A, 0xD8, 0xC1, 0xAB, 0xC1, 0xE7, 0x83, 0x40, 0xC0, 0xC5, 0xFC, 0x8C, 0x52, 0x26, 0x31, 0x9C, 0x6C, 0x20, 0x4E, 0x03, 0x9F, 0x51, 0x4D, 0x2D, 0x8D, 0x34, 0xD3, 0x4D, 0x04, 0x84, 0xC4, 0x28, 0xA2, 0x98, 0x69, 0xCC, 0xA5, 0x84, 0x62, 0x86, 0x00,
    0x09, 0xCE, 0xD0, 0x48, 0x05, 0x5B, 0x83, 0xAA, 0x01, 0x13, 0x30, 0x64, 0x2C, 0x3F, 0xE5, 0xFB, 0x4C, 0x63, 0x24, 0x21, 0x71, 0x0E, 0xB1, 0x9B, 0x4A, 0x6A, 0x68, 0xE1, 0x2C, 0xE7, 0xE9, 0xA0, 0x2B, 0xB0, 0x47, 0x33, 0x20, 0x87, 0x3C, 0xF2, 0x19, 0xC6, 0x48, 0x66, 0xB0, 0x84, 0x52, 0xE6, 0x31, 0x84,
    0x88, 0x16, 0x6A, 0x78, 0x83, 0x6D, 0x34, 0x05, 0x51, 0xBF, 0x09, 0x98, 0xCF, 0x52, 0x1E, 0xE4, 0x76, 0xA6, 0x00, 0x6D, 0xEC, 0xE6, 0x5D, 0x3E, 0xA7, 0x8E, 0x13, 0x9C, 0xBF, 0x08, 0x9B, 0xD2, 0x2A, 0x20, 0x9F, 0xF1, 0x4C, 0x65, 0x21, 0x2B, 0x58, 0x46, 0x01, 0x50, 0x47, 0x25, 0x7F, 0xE6, 0xA3, 0xA0,
    0x3D, 0x93, 0x97, 0x7D, 0xC9, 0x8D, 0x13, 0x2D, 0xB7, 0xC2, 0x2E, 0x35, 0xE1, 0x3B, 0x3E, 0xEA, 0x52, 0x47, 0x1A, 0x66, 0x6C, 0x1F, 0x3A, 0xCA, 0x52, 0xD7, 0xBB, 0xC3, 0x84, 0xDA, 0xE5, 0x2E, 0xD7, 0x39, 0xD1, 0x4C, 0x13, 0xDE, 0x2C, 0xE7, 0xF8, 0x94, 0xD5, 0x6A, 0xD2, 0x5A, 0x9F, 0xF1, 0x0E, 0x87,
    0x65, 0x6C, 0x7C, 0xF9, 0x43, 0x0C, 0xB3, 0xCC, 0x8D, 0xD6, 0x99, 0x54, 0x0F, 0xFA, 0x6B, 0x67, 0x9B, 0x95, 0x89, 0x61, 0xCC, 0x12, 0x9F, 0xB5, 0x41, 0xED, 0x70, 0x97, 0xEB, 0x1C, 0xD3, 0x7F, 0xF0, 0xCB, 0x48, 0x14, 0x59, 0xEE, 0x6E, 0x3B, 0xD4, 0x06, 0x37, 0x5B, 0x62, 0xAC, 0x2F, 0x93, 0x2C, 0x4B,
    0x7C, 0xDE, 0x26, 0x23, 0x5B, 0x7C, 0xC3, 0x7B, 0x32, 0x0F, 0x7B, 0x2F, 0x1E, 0x57, 0xF9, 0x77, 0x5B, 0x8D, 0x6C, 0xF2, 0x79, 0x4B, 0x7A, 0x8D, 0x82, 0x81, 0x73, 0x7C, 0xD6, 0x26, 0x23, 0x9B, 0xDC, 0xE6, 0x37, 0xAE, 0x17, 0xFC, 0x92, 0xDF, 0x5B, 0x7C, 0xB9, 0xC7, 0xEB, 0x26, 0x67, 0xF7, 0x12, 0x51,
    0x27, 0xFA, 0x94, 0x0D, 0x46, 0x36, 0xF9, 0xA2, 0x73, 0x06, 0x0B, 0x1E, 0xC0, 0x9B, 0x7D, 0xD1, 0x26, 0x23, 0x8F, 0xFA, 0xA4, 0x13, 0xD2, 0x29, 0xE5, 0x5B, 0x6E, 0xB5, 0xDA, 0xE2, 0xCB, 0xCE, 0x1D, 0x4C, 0x78, 0x00, 0x67, 0xBB, 0xCD, 0x16, 0xF5, 0xA0, 0x0F, 0x9B, 0x9F, 0x4A, 0x21, 0x74, 0x85, 0xBB,
    0xD5, 0x0E, 0xDF, 0x18, 0xBC, 0xE0, 0x5F, 0x81, 0xB0, 0xD8, 0xED, 0x76, 0xA8, 0xBB, 0x2C, 0x4B, 0x91, 0x5B, 0x8E, 0xF7, 0x75, 0xBB, 0x4C, 0xBA, 0xCB, 0x7B, 0x6E, 0x04, 0x3C, 0x80, 0xAB, 0xAD, 0x30, 0x69, 0xA7, 0xAF, 0x39, 0xEE, 0xDA, 0xCD, 0x5F, 0x5A, 0xAB, 0xD6, 0xBA, 0xEE, 0xFA, 0x33, 0x3F, 0x2D,
    0x81, 0x2C, 0xCB, 0xAD, 0x53, 0x6B, 0x7C, 0xFC, 0xEA, 0xAD, 0x5B, 0xDC, 0xAB, 0x26, 0xFC, 0xAD, 0x45, 0x37, 0x0A, 0x1E, 0xC0, 0xB1, 0x6E, 0x32, 0xA1, 0x56, 0xBA, 0xE8, 0xCA, 0x8D, 0x3F, 0x78, 0x4A, 0x7D, 0xC7, 0x3B, 0x06, 0x7E, 0xEC, 0x64, 0x44, 0x20, 0xB0, 0xCC, 0x9D, 0x6A, 0xB3, 0x5B, 0x2E, 0x5F,
    0x5E, 0xE8, 0xA7, 0x26, 0x3D, 0xE7, 0xA3, 0x0E, 0xBB, 0x91, 0xF0, 0x00, 0x16, 0xBA, 0xC1, 0x36, 0x93, 0x56, 0xB9, 0x00, 0xE0, 0xC2, 0xFB, 0x5E, 0xC3, 0x24, 0x42, 0x2A, 0xF8, 0x84, 0xB6, 0x34, 0x66, 0x31, 0xA7, 0xBB, 0xD0, 0xB1, 0x7D, 0x9F, 0xE6, 0xC6, 0x9C, 0x60, 0x89, 0x53, 0xD2, 0x6A, 0x9E, 0x63,
    0x2F, 0x15, 0x84, 0x4C, 0x62, 0xCD, 0x45, 0x93, 0xE1, 0x56, 0x1A, 0xB7, 0xCB, 0xF5, 0x8E, 0x4A, 0xE3, 0x74, 0xA6, 0x9B, 0x7D, 0xDF, 0x4A, 0xDF, 0xF2, 0xA1, 0xB4, 0xC7, 0xC8, 0x05, 0xCD, 0xA9, 0x6E, 0x70, 0x87, 0x95, 0xEE, 0xF4, 0x69, 0x27, 0xA5, 0xD1, 0x19, 0xE5, 0x06, 0xE3, 0xC6, 0xDD, 0x63, 0xE1,
    0x85, 0x85, 0x55, 0x1E, 0x53, 0xAB, 0xBC, 0x23, 0x75, 0xFE, 0x9B, 0xE7, 0x0B, 0x1E, 0xB3, 0x5B, 0x8D, 0xBB, 0xDF, 0x07, 0xCD, 0xED, 0x25, 0xBC, 0xEB, 0xFD, 0x9F, 0x09, 0x35, 0x61, 0xAD, 0xCF, 0xA4, 0x8E, 0x82, 0xA1, 0x65, 0x7E, 0xA6, 0x1E, 0x73, 0xE5, 0x85, 0x57, 0xB0, 0x92, 0x02, 0xA0, 0x82, 0xBA,
    0x34, 0x75, 0xCB, 0x1C, 0x56, 0x30, 0x8E, 0x2C, 0x20, 0x9B, 0xB9, 0x94, 0x32, 0x39, 0x6D, 0x00, 0x66, 0x52, 0xCA, 0x2C, 0x62, 0x40, 0x8C, 0x62, 0xEE, 0x4E, 0xAD, 0x19, 0x44, 0xD4, 0x52, 0x01, 0x14, 0xB0, 0x12, 0x42, 0xB3, 0xF9, 0x36, 0x79, 0xC4, 0xA9, 0xE4, 0x64, 0x1A, 0xB7, 0x53, 0x18, 0xC6, 0xC5,
    0xD8, 0xC4, 0x18, 0x43, 0xFA, 0x0F, 0x75, 0x1C, 0x63, 0x2E, 0x69, 0x66, 0x31, 0x8A, 0xF1, 0x69, 0xF4, 0x4E, 0xB0, 0x87, 0x04, 0xB9, 0x94, 0x9A, 0x1D, 0x32, 0x9D, 0xC9, 0xC4, 0x68, 0xA0, 0x86, 0x74, 0x45, 0x53, 0x33, 0x71, 0x2E, 0x96, 0x61, 0xD2, 0xC6, 0xD9, 0xB4, 0x04, 0xCE, 0x5C, 0x96, 0xC4, 0xD2,
    0x41, 0x4B, 0x1A, 0xBD, 0x76, 0x8E, 0xD0, 0x48, 0x8C, 0x29, 0x4C, 0x0D, 0x59, 0x4C, 0x0E, 0xB0, 0x9F, 0xD3, 0x69, 0x6B, 0xBD, 0x6A, 0x3E, 0xE2, 0x5C, 0xCF, 0xEF, 0x7A, 0xF6, 0x52, 0x9F, 0x96, 0xC0, 0x61, 0xF6, 0x72, 0xBC, 0x07, 0xBE, 0x85, 0xFF, 0x52, 0x97, 0x5A, 0x2D, 0x90, 0x16, 0xF6, 0x13, 0x90,
    0xCB, 0xE2, 0x18, 0x0B, 0xC8, 0x02, 0xAA, 0x2F, 0x41, 0x5C, 0xAB, 0xDE, 0xEA, 0x0B, 0x74, 0x31, 0x9F, 0x5C, 0xCE, 0xB0, 0x83, 0x7F, 0x05, 0x69, 0x23, 0x10, 0x34, 0xFB, 0x0F, 0xF2, 0xF9, 0x0E, 0x05, 0xB4, 0xF3, 0x29, 0x7F, 0x0C, 0x3A, 0xD3, 0x52, 0x3D, 0x4B, 0x35, 0xAB, 0xC9, 0x62, 0x41, 0x8C, 0x59,
    0x84, 0x40, 0x2D, 0xBD, 0x54, 0xAD, 0x41, 0x85, 0x35, 0x2C, 0x62, 0x04, 0x75, 0x1C, 0x0C, 0x4E, 0xD3, 0x8B, 0x04, 0x55, 0x36, 0xF2, 0x36, 0x93, 0x68, 0xA2, 0x2A, 0x68, 0xEA, 0x45, 0xF1, 0x3C, 0xB5, 0x40, 0xC8, 0xCC, 0x18, 0xD3, 0x09, 0x81, 0x46, 0x3A, 0x7A, 0x75, 0xDC, 0x40, 0x03, 0x19, 0x49, 0xD0,
    0xC4, 0x7B, 0x19, 0xA8, 0x9D, 0xA7, 0x01, 0x08, 0x99, 0x11, 0x52, 0x44, 0x88, 0x34, 0xD3, 0x95, 0x19, 0xC0, 0x20, 0x49, 0x9C, 0x53, 0x48, 0xC8, 0xD8, 0x90, 0x61, 0x04, 0x74, 0x91, 0xE8, 0xED, 0xBA, 0x31, 0xF8, 0x12, 0x44, 0xC4, 0x49, 0x10, 0x50, 0x10, 0x92, 0x0F, 0x9C, 0x27, 0xBA, 0x6E, 0x9F, 0xFD,
    0x95, 0x24, 0xED, 0x40, 0xC1, 0x0D, 0x2B, 0x3E, 0x32, 0x95, 0x90, 0x76, 0x60, 0x28, 0x5F, 0x3F, 0x91, 0x2C, 0xF2, 0x81, 0xB6, 0x90, 0x73, 0x48, 0x0E, 0xD9, 0x37, 0xB6, 0x10, 0xB9, 0x5A, 0x0C, 0x19, 0x42, 0x36, 0xD2, 0x16, 0xD2, 0x4C, 0x44, 0x40, 0x11, 0x39, 0x5F, 0xEB, 0xF3, 0xE7, 0x50, 0x44, 0x40,
    0x44, 0x53, 0x48, 0x0D, 0x11, 0x50, 0x4C, 0xDE, 0xD7, 0x4A, 0x20, 0x8F, 0x62, 0x20, 0xE2, 0x48, 0xC8, 0x17, 0x44, 0xC0, 0x54, 0xF2, 0xAF, 0xD7, 0x67, 0xBF, 0x64, 0x28, 0x53, 0x81, 0x88, 0xC3, 0x31, 0x0E, 0x92, 0x04, 0xE6, 0x51, 0xD8, 0xB7, 0x95, 0x31, 0x26, 0x33, 0x9F, 0x59, 0x8C, 0x27, 0x8F, 0x6E,
    0x9A, 0xA9, 0xE5, 0x13, 0xBE, 0x64, 0x20, 0xE9, 0x53, 0xC8, 0x3C, 0x20, 0xC9, 0x81, 0x18, 0xFB, 0xE8, 0x22, 0x9F, 0x12, 0x46, 0x1A, 0xF4, 0xDA, 0xFB, 0xC8, 0x62, 0x1E, 0xA5, 0xDC, 0xCA, 0x6C, 0x8A, 0x19, 0x4D, 0x0E, 0xDD, 0x9C, 0xE1, 0x38, 0xD5, 0x54, 0xF0, 0x4F, 0x4F, 0x04, 0xC9, 0x14, 0x16, 0x90,
    0xC5, 0x4C, 0xCE, 0x71, 0xF2, 0xEA, 0x42, 0xC7, 0x80, 0x51, 0x94, 0x20, 0x9D, 0xEC, 0xC3, 0x6C, 0xAB, 0x4C, 0xD8, 0xE5, 0x8F, 0x2D, 0xE8, 0x05, 0x7E, 0xB4, 0xF7, 0xF9, 0xA2, 0x5F, 0x9A, 0x50, 0xB5, 0xDB, 0xCE, 0x9E, 0x5F, 0x7A, 0xC4, 0xE7, 0xBC, 0x2D, 0x55, 0x99, 0x66, 0xAE, 0xCB, 0x7D, 0xD1, 0xDF,
    0x39, 0xF1, 0xEA, 0x52, 0xCF, 0x02, 0x1F, 0x30, 0x6E, 0xDC, 0x7D, 0x66, 0xC7, 0x82, 0x84, 0x1F, 0x31, 0x93, 0x61, 0x2C, 0xE1, 0x63, 0x0E, 0xA7, 0x81, 0x2F, 0xE6, 0x3E, 0x7E, 0xC2, 0x7C, 0xF2, 0x68, 0xA3, 0x8E, 0xC3, 0x34, 0x71, 0x9E, 0x21, 0x8C, 0x61, 0x06, 0xF3, 0x99, 0x4E, 0x39, 0xE3, 0xF8, 0x93,
    0x7B, 0xAF, 0xEC, 0x02, 0x99, 0xCB, 0x2D, 0x3C, 0xCE, 0x72, 0x92, 0xBC, 0x4A, 0xF3, 0x55, 0x27, 0xED, 0x04, 0x96, 0x90, 0xCD, 0x39, 0x2A, 0x82, 0x04, 0xE0, 0xDD, 0x1E, 0x53, 0x3F, 0xF5, 0xBB, 0xE9, 0x2E, 0x65, 0x3E, 0x62, 0xBD, 0x91, 0x9D, 0x1E, 0x72, 0x9B, 0x6B, 0x9D, 0x63, 0x0E, 0x18, 0xB3, 0xD8,
    0x1F, 0xFA, 0x57, 0x8F, 0x9B, 0x34, 0xF2, 0x4D, 0xEF, 0xB4, 0xF0, 0xAB, 0xB2, 0xC9, 0x7C, 0x97, 0xF9, 0x92, 0x91, 0xFA, 0x85, 0xF3, 0xAF, 0xEC, 0x8B, 0x18, 0x5A, 0xE6, 0x7E, 0xB5, 0xD1, 0x3B, 0x2F, 0x2C, 0x14, 0xBA, 0xC7, 0xB8, 0xF1, 0x5E, 0xCA, 0xF2, 0xD7, 0x6D, 0xB3, 0xD5, 0xF7, 0x5C, 0xEB, 0x15,
    0x55, 0x9E, 0x81, 0x23, 0x7C, 0xC6, 0x3A, 0xBB, 0xD5, 0xB7, 0x5D, 0xE3, 0x54, 0xF3, 0x0C, 0xCC, 0xB5, 0xD8, 0xD5, 0x6E, 0xB7, 0xDB, 0xC8, 0x93, 0x96, 0x7B, 0xD5, 0x09, 0xE3, 0xE8, 0x9E, 0xB2, 0xFC, 0xE3, 0x4B, 0xD7, 0x20, 0x9F, 0xB6, 0x49, 0xFD, 0xB7, 0xA5, 0xA9, 0x13, 0xDA, 0xB5, 0xEE, 0xF4, 0x2F,
    0x2E, 0x31, 0x3B, 0xC5, 0x5E, 0xCC, 0x5F, 0xF5, 0xE4, 0xC6, 0x97, 0x6E, 0x71, 0x95, 0xB7, 0xBB, 0xD2, 0xDF, 0x78, 0x48, 0x4D, 0x7A, 0xDC, 0xCD, 0x86, 0x57, 0x66, 0xB6, 0x81, 0xCB, 0x7C, 0x5B, 0x6D, 0xF2, 0xA9, 0xAF, 0x16, 0x17, 0x58, 0x65, 0xD2, 0x36, 0xD7, 0xA7, 0xBB, 0x9A, 0x99, 0x97, 0xFE, 0x4E,
    0x64, 0xE8, 0x06, 0x0F, 0xDA, 0x69, 0xA4, 0x6A, 0xD2, 0x6E, 0x55, 0xE3, 0xD6, 0xBA, 0xD1, 0x21, 0xD7, 0x68, 0x17, 0xFA, 0x98, 0xED, 0x26, 0xAD, 0x72, 0xFE, 0xE5, 0xCB, 0xBF, 0xF7, 0x94, 0xBA, 0xC3, 0xB2, 0x81, 0xFD, 0x27, 0xB8, 0xD2, 0x9D, 0x9E, 0xB6, 0xCB, 0x6E, 0x93, 0x76, 0xDB, 0xE5, 0x19, 0x2B,
    0x5D, 0x73, 0xAD, 0x2F, 0x43, 0x57, 0xF8, 0x9E, 0xDA, 0xEC, 0x73, 0x57, 0x6E, 0x2C, 0xB2, 0x52, 0x4D, 0xB8, 0x71, 0xA0, 0xD7, 0x73, 0x87, 0xFB, 0x3D, 0xB7, 0x79, 0xC0, 0x63, 0x56, 0xFB, 0x8A, 0x3F, 0x32, 0xE5, 0xC1, 0xE6, 0x38, 0x37, 0xDB, 0xAD, 0xEE, 0xB1, 0xE4, 0xEA, 0xAD, 0xC7, 0xAD, 0x51, 0xEB,
    0x2C, 0xCF, 0xA8, 0x9D, 0x38, 0x30, 0x92, 0x31, 0x1F, 0xB1, 0x5E, 0x3D, 0xE2, 0x2F, 0x52, 0x71, 0x7B, 0xCD, 0x4E, 0x93, 0xEE, 0x76, 0xD5, 0x0D, 0x23, 0x70, 0xAF, 0x1F, 0x98, 0xB4, 0xD3, 0x57, 0x1D, 0x7B, 0xED, 0x66, 0x68, 0x99, 0xBB, 0xD4, 0x0E, 0xB7, 0xBB, 0xF8, 0x86, 0xC0, 0xDF, 0xE6, 0x9B, 0x76,
    0xAA, 0xEF, 0xA7, 0xB9, 0x06, 0x9B, 0xEF, 0x3A, 0x0F, 0xAA, 0xAD, 0xBE, 0xE2, 0xBC, 0x41, 0x87, 0x9F, 0xE3, 0x4B, 0xB6, 0xAA, 0x9F, 0xFB, 0x73, 0x87, 0xA6, 0x53, 0x9A, 0xE0, 0x93, 0x1E, 0x35, 0xB2, 0xD9, 0xAD, 0xDE, 0x3C, 0xA8, 0xF0, 0x73, 0xDD, 0x6A, 0x93, 0x91, 0xF5, 0x3E, 0xE1, 0xF8, 0xF4, 0x6A,
    0x81, 0xB3, 0xDD, 0xE4, 0x49, 0x23, 0x9B, 0x7C, 0x79, 0xF0, 0x5E, 0x84, 0xB7, 0xF9, 0x8A, 0xCD, 0x46, 0x9E, 0x74, 0xA3, 0x37, 0xF5, 0xFA, 0xA1, 0x9B, 0xE5, 0x42, 0xB7, 0x78, 0xD2, 0xC8, 0x56, 0xB7, 0xBB, 0xFA, 0xFA, 0xBF, 0x08, 0x63, 0xDE, 0xEB, 0x9B, 0xB6, 0x1A, 0x79, 0xD2, 0x2D, 0x2E, 0xEC, 0xB3,
    0x09, 0x68, 0xCC, 0x85, 0x6E, 0xF2, 0xA8, 0xDA, 0x61, 0x85, 0xE5, 0x8E, 0xBD, 0x8E, 0x76, 0x7D, 0xE8, 0x38, 0x1F, 0xF1, 0x03, 0x3B, 0xD5, 0x7A, 0x37, 0xBA, 0xB0, 0xCF, 0x76, 0x7D, 0x4F, 0x14, 0x66, 0xFB, 0xA4, 0x07, 0xD5, 0xA4, 0x75, 0x6E, 0xB2, 0x6C, 0x80, 0x03, 0x8B, 0x42, 0x97, 0xBB, 0xD9, 0x7A,
    0x93, 0xEA, 0x01, 0x9F, 0xF0, 0xA6, 0x8C, 0x5B, 0xA0, 0x06, 0x4E, 0xF0, 0x61, 0x77, 0xD9, 0xA9, 0x76, 0xBB, 0xD3, 0xF5, 0x96, 0x3A, 0xAA, 0x5F, 0x23, 0x9B, 0xD1, 0x2E, 0xF3, 0x31, 0xFF, 0x63, 0xB7, 0xDA, 0xE9, 0xFB, 0x3E, 0xE4, 0xF8, 0xD4, 0x0F, 0xD1, 0xDB, 0xD0, 0xEA, 0x5B, 0x3C, 0xC8, 0xED, 0x4C,
    0x03, 0xDA, 0xA9, 0xE0, 0x5D, 0xF6, 0x53, 0xC7, 0x09, 0xDA, 0xFB, 0x1C, 0x5A, 0x4D, 0x60, 0x2A, 0x25, 0xAC, 0x60, 0x19, 0x43, 0x81, 0x5A, 0xF6, 0xF0, 0x27, 0x3E, 0x0E, 0xCE, 0xA7, 0xB6, 0xE8, 0x7D, 0x6C, 0x57, 0xC4, 0x03, 0xFC, 0x80, 0x19, 0x8C, 0x24, 0x24, 0xC1, 0x21, 0x3E, 0x60, 0x0F, 0x47, 0x68,
    0xE1, 0x2C, 0xED, 0xD7, 0x8C, 0xED, 0x86, 0x32, 0x94, 0x42, 0x46, 0x32, 0x83, 0x6F, 0x52, 0xCA, 0x5C, 0xB2, 0x89, 0x38, 0x4D, 0x0D, 0x7F, 0xE3, 0x25, 0x4E, 0x0D, 0x60, 0x6C, 0x77, 0x89, 0xC6, 0x22, 0xD6, 0xB2, 0x8C, 0x49, 0x8C, 0x20, 0x1B, 0x48, 0xD0, 0xD8, 0x33, 0xB8, 0x6C, 0xA0, 0x99, 0x44, 0xCF,
    0xE0, 0x32, 0x9B, 0x22, 0x26, 0xF7, 0x0C, 0x2E, 0x27, 0xF5, 0xE8, 0xB5, 0xD2, 0xC8, 0x2E, 0xB6, 0x06, 0xFB, 0x7B, 0xF7, 0x9F, 0xD9, 0xE8, 0x76, 0x01, 0xF7, 0xB3, 0x9C, 0xC9, 0x14, 0x90, 0xD7, 0xC7, 0xE8, 0x56, 0xBA, 0xE9, 0xA4, 0x8D, 0xA3, 0xBC, 0xCB, 0x6B, 0xC1, 0x81, 0xBE, 0x7D, 0x67, 0x3E, 0xBC,
    0x2E, 0xA4, 0x94, 0xBB, 0x58, 0xCA, 0x14, 0x72, 0x52, 0x0C, 0xAF, 0x23, 0x22, 0x22, 0x92, 0x74, 0x52, 0xCF, 0x87, 0xBC, 0xC5, 0x87, 0xE9, 0x3B, 0x49, 0x03, 0x24, 0xD0, 0x43, 0x23, 0x9B, 0x69, 0xDC, 0xCA, 0x02, 0x66, 0x31, 0x83, 0x31, 0x0C, 0xBF, 0x70, 0xC3, 0xE5, 0x2C, 0xCD, 0x1C, 0xE1, 0x30, 0x07,
    0xD8, 0x47, 0x6D, 0xFF, 0xC6, 0xF7, 0xFF, 0x07, 0xBF, 0xD8, 0x5C, 0x3D, 0x21, 0x11, 0x7C, 0xBF, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A,
    0x31, 0x35, 0x3A, 0x35, 0x39, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0xB9, 0x37, 0x67, 0x9A, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x39, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x33, 0x54, 0x31, 0x32, 0x3A, 0x31,
    0x35, 0x3A, 0x35, 0x39, 0x2B, 0x30, 0x32, 0x3A, 0x30, 0x30, 0xC8, 0x6A, 0xDF, 0x26, 0x00, 0x00, 0x00, 0x19, 0x74, 0x45, 0x58, 0x74, 0x53, 0x6F, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x00, 0x77, 0x77, 0x77, 0x2E, 0x69, 0x6E, 0x6B, 0x73, 0x63, 0x61, 0x70, 0x65, 0x2E, 0x6F, 0x72, 0x67, 0x9B, 0xEE, 0x3C,
    0x1A, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82};

/*---------------------------------------------------------------------------*/

static const uint32_t LOGO_PNG_SIZE = 1658;

static const byte_t LOGO_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x03, 0x00, 0x00, 0x00, 0x9D, 0xB7, 0x81, 0xEC, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x2E, 0x23, 0x00, 0x00, 0x2E, 0x23, 0x01,
    0x78, 0xA5, 0x3F, 0x76, 0x00, 0x00, 0x02, 0x3D, 0x50, 0x4C, 0x54, 0x45, 0x47, 0x70, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9B, 0xA8, 0x68, 0x20, 0x00, 0x00, 0x00, 0xBE, 0x74, 0x52, 0x4E, 0x53, 0x00, 0xD6, 0xFE,
    0x2C, 0x4B, 0x21, 0x98, 0x0D, 0x08, 0xFB, 0xE0, 0xA8, 0xF9, 0xEE, 0xAC, 0xFD, 0xB2, 0x88, 0x7D, 0xAE, 0xC9, 0xBE, 0x6C, 0x2D, 0xF6, 0x2F, 0x86, 0xF2, 0xD9, 0xBD, 0x78, 0x69, 0x97, 0x61, 0x32, 0x55, 0x68, 0x63, 0xD3, 0x48, 0xEB, 0xC1, 0x40, 0x79, 0xEF, 0xD2, 0x45, 0x01, 0x4C, 0x62, 0x0B, 0xD7, 0xEC,
    0x59, 0x9B, 0x64, 0xB5, 0xDB, 0x2E, 0xBC, 0x7F, 0x96, 0x30, 0xF0, 0x81, 0x85, 0xC0, 0x82, 0xC6, 0x38, 0xDE, 0x9E, 0x93, 0x26, 0x8B, 0x31, 0xE5, 0xF1, 0x49, 0xD5, 0x03, 0x04, 0x18, 0x6B, 0x1C, 0x22, 0xA6, 0x83, 0x1F, 0x0C, 0x91, 0xA5, 0xB7, 0x8F, 0x5A, 0xCF, 0x5F, 0x74, 0x4E, 0x07, 0x09, 0xF5, 0xD4,
    0x4F, 0x28, 0xF4, 0x8A, 0x73, 0xB9, 0x70, 0x72, 0x8C, 0xE3, 0x2A, 0xDA, 0x9D, 0xC7, 0x02, 0x84, 0xEA, 0x41, 0x2B, 0xBF, 0xD0, 0x0A, 0x52, 0xDF, 0x92, 0x5E, 0x11, 0x7A, 0x37, 0xA9, 0xCA, 0x53, 0x94, 0x66, 0x39, 0xC8, 0xC4, 0x34, 0xED, 0xE7, 0xE6, 0x42, 0xC2, 0xA4, 0x5B, 0x77, 0x7C, 0xC3, 0x06, 0x5C,
    0x71, 0x15, 0xBB, 0x95, 0xE1, 0x7B, 0xE9, 0xDD, 0x46, 0x20, 0xAB, 0xA3, 0xBA, 0x76, 0xFC, 0x6D, 0xCC, 0x19, 0x33, 0x16, 0xF7, 0xCE, 0x3E, 0xD8, 0x60, 0x89, 0x9C, 0x54, 0xD1, 0x29, 0x24, 0x9A, 0x1A, 0x58, 0xDC, 0x51, 0x0E, 0x58, 0x93, 0xF5, 0xBC, 0x00, 0x00, 0x03, 0x19, 0x49, 0x44, 0x41, 0x54, 0x58,
    0xC3, 0x9D, 0x57, 0x65, 0x5B, 0x23, 0x31, 0x10, 0x0E, 0x85, 0x52, 0x28, 0x5E, 0x5A, 0xF4, 0xB0, 0x16, 0x3F, 0xE0, 0x70, 0x39, 0x1C, 0x0E, 0x38, 0xDC, 0xF5, 0xDC, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xF2, 0xDB, 0xAE, 0xED, 0x6E, 0x36, 0xC9, 0x6E, 0x36, 0xCD, 0x76, 0x3E, 0x75, 0xE6, 0x95,
    0x67, 0xB3, 0x99, 0x99, 0xB6, 0x00, 0xE8, 0x46, 0xF7, 0xA7, 0xCF, 0x4F, 0xAB, 0x5B, 0x1C, 0xD1, 0x1D, 0xAD, 0xAE, 0x4E, 0x60, 0x34, 0x02, 0xBB, 0xFA, 0x21, 0x15, 0xB3, 0x52, 0xDF, 0x1A, 0x90, 0xA7, 0xF5, 0x40, 0x46, 0xBC, 0x0A, 0x12, 0x94, 0x3F, 0x4A, 0x86, 0x3A, 0x11, 0x30, 0x2A, 0xA2, 0x4F, 0x87,
    0x9C, 0x38, 0xE8, 0x5B, 0x1F, 0x06, 0xB9, 0x71, 0xD2, 0x97, 0x3E, 0x93, 0x64, 0x87, 0x2E, 0x88, 0x4C, 0xAF, 0x8C, 0x2E, 0xA3, 0x1C, 0x02, 0xF9, 0xFA, 0x19, 0x98, 0x69, 0xBD, 0x35, 0x82, 0xAA, 0x89, 0xDB, 0x13, 0x94, 0xF2, 0x34, 0xBE, 0xC1, 0x3A, 0x99, 0x66, 0x4A, 0x50, 0xBD, 0xF2, 0x45, 0x8A, 0xC3,
    0x4C, 0xAE, 0x41, 0x8A, 0xCC, 0xDA, 0x11, 0xA2, 0x46, 0x76, 0x21, 0x83, 0x26, 0xAE, 0x41, 0x84, 0xCC, 0x9A, 0xD0, 0x42, 0x19, 0x32, 0x14, 0xCB, 0x35, 0x90, 0x49, 0xCF, 0x58, 0x58, 0xB8, 0x84, 0xE5, 0x71, 0x0D, 0xA2, 0x24, 0xD2, 0x74, 0x16, 0x36, 0x57, 0xC2, 0x52, 0x44, 0x8E, 0x10, 0xC7, 0xC2, 0x9E,
    0x88, 0x1C, 0x21, 0x80, 0xF3, 0x04, 0xD5, 0x12, 0x16, 0xCC, 0x35, 0xB8, 0x23, 0x91, 0xEE, 0xB2, 0xB0, 0x42, 0x09, 0x3B, 0xAC, 0xAF, 0x1E, 0xB4, 0xE5, 0xA2, 0xE1, 0xE5, 0xBC, 0x60, 0x98, 0xBD, 0x50, 0x47, 0x7F, 0x9F, 0x68, 0x58, 0x06, 0x1C, 0x8F, 0xD1, 0xC6, 0x7D, 0x0C, 0xFC, 0xF6, 0x7E, 0xB2, 0xE3,
    0x8F, 0x6B, 0x09, 0x07, 0x48, 0x7C, 0xAD, 0x76, 0x05, 0xD1, 0x43, 0x57, 0xA6, 0x21, 0x0C, 0xD0, 0x84, 0xF3, 0x16, 0x1A, 0xDE, 0xA4, 0x1E, 0xDB, 0x12, 0xB5, 0xC1, 0x65, 0x1A, 0x37, 0x15, 0x50, 0xCD, 0x6E, 0x79, 0x81, 0x80, 0x31, 0x93, 0xFC, 0x21, 0x9E, 0xD6, 0x67, 0xC9, 0xE5, 0x63, 0x9B, 0x99, 0x63,
    0x99, 0xAD, 0x38, 0x77, 0x36, 0xA1, 0x4F, 0xD4, 0x38, 0xD6, 0xA1, 0x6A, 0x3E, 0x5E, 0x18, 0x27, 0x30, 0x1C, 0x47, 0x4E, 0xBB, 0xB2, 0x11, 0x6B, 0x9D, 0x08, 0x5F, 0xDC, 0x8E, 0x6A, 0x0E, 0x7C, 0x9B, 0xC4, 0x6E, 0x21, 0xB6, 0xC8, 0x4B, 0x00, 0xDE, 0xE0, 0x6C, 0x55, 0x6C, 0xD2, 0xF3, 0xAB, 0xF3, 0x6A,
    0x89, 0x15, 0xB5, 0x14, 0x80, 0xA3, 0x78, 0xC7, 0x22, 0x83, 0x66, 0xCC, 0xF0, 0xBC, 0xDB, 0x34, 0xFD, 0x8D, 0xE8, 0x59, 0x26, 0x41, 0x38, 0x2D, 0x92, 0x0D, 0x4C, 0x4A, 0xA5, 0xDF, 0x9B, 0xAF, 0xD1, 0xD3, 0xB7, 0x51, 0x1D, 0x09, 0xA1, 0x5D, 0xD2, 0x57, 0xE0, 0x4A, 0x92, 0x54, 0x29, 0x66, 0xCA, 0xCB,
    0xCD, 0x12, 0x7A, 0x06, 0x97, 0x5E, 0x7B, 0x0B, 0x2D, 0xB8, 0x70, 0x11, 0x5D, 0x6B, 0xB4, 0x56, 0xBF, 0x1A, 0x9D, 0xD8, 0x86, 0x6B, 0xE3, 0xAA, 0x47, 0x82, 0x7B, 0x95, 0x8B, 0x31, 0x6F, 0xA1, 0xD4, 0xE7, 0x5A, 0x71, 0xDF, 0xE4, 0xE0, 0xF2, 0x1F, 0x4F, 0xDE, 0x87, 0xF3, 0x70, 0xAA, 0x77, 0xCE, 0xA6,
    0x86, 0xD9, 0xAD, 0xB9, 0x0F, 0x6A, 0xF2, 0x3A, 0xD2, 0x1E, 0x93, 0xF5, 0x21, 0xC2, 0x78, 0xD2, 0x9D, 0x4F, 0x41, 0xED, 0xBD, 0x00, 0x91, 0xC5, 0xE9, 0x89, 0xBF, 0xEE, 0xF4, 0x3D, 0x4E, 0xAF, 0x8B, 0x19, 0x44, 0x61, 0xC5, 0x14, 0xED, 0xE7, 0x10, 0x33, 0x58, 0x86, 0x15, 0xEE, 0x15, 0x6D, 0x21, 0x0C,
    0xB6, 0x1A, 0x3E, 0x42, 0x2E, 0x00, 0x4E, 0x22, 0xBD, 0x67, 0xD8, 0x00, 0x52, 0x9D, 0xC9, 0xDC, 0x64, 0xDA, 0x48, 0x24, 0x15, 0xFF, 0xC0, 0x4D, 0x32, 0x3D, 0x25, 0x62, 0xB0, 0x9E, 0x54, 0x4C, 0x80, 0x12, 0x32, 0x0D, 0x16, 0x31, 0x58, 0x4E, 0x2A, 0xBE, 0x2B, 0xDF, 0x99, 0x52, 0x6C, 0xF3, 0xAD, 0x8F,
    0xA7, 0x04, 0x3F, 0x80, 0x0B, 0x1A, 0x7C, 0x84, 0x42, 0x4A, 0x30, 0x04, 0xF2, 0xE9, 0x91, 0xD9, 0xE9, 0x4B, 0x5F, 0x47, 0xF3, 0x07, 0x80, 0x59, 0x35, 0x74, 0xDD, 0x7C, 0x7D, 0x96, 0x8A, 0xAE, 0xBA, 0x55, 0x4F, 0x54, 0xF1, 0xF4, 0xB3, 0x55, 0xE4, 0x6F, 0xEE, 0xDA, 0x47, 0xB5, 0x83, 0x7D, 0xA5, 0x9E,
    0xBC, 0xE8, 0x82, 0x9A, 0xFB, 0x85, 0x61, 0xEA, 0x8E, 0xD3, 0xF3, 0x19, 0xEA, 0xD2, 0x38, 0xAB, 0x96, 0xF9, 0xD5, 0x0D, 0x7C, 0x60, 0xEE, 0xAF, 0x3D, 0x5D, 0x15, 0x0D, 0x93, 0x48, 0x7B, 0xE8, 0x48, 0x46, 0xFD, 0x43, 0x26, 0x6D, 0xD0, 0x03, 0xBF, 0xD3, 0xDF, 0xC2, 0xA1, 0xBD, 0xE5, 0x11, 0xC9, 0x51,
    0xFA, 0xB8, 0xF4, 0x73, 0x27, 0x06, 0xFA, 0x1D, 0x7D, 0x5E, 0x83, 0x10, 0xBF, 0xF5, 0x3D, 0xF2, 0x11, 0xFD, 0x7E, 0x84, 0x1C, 0xF4, 0x92, 0x0A, 0xFC, 0xD3, 0xEF, 0x56, 0x6E, 0xA8, 0xC1, 0x2F, 0x7D, 0x28, 0xF1, 0x0B, 0x61, 0xD8, 0x1F, 0x03, 0x27, 0xD9, 0x25, 0x1B, 0x8C, 0xEB, 0x57, 0xD0, 0x7D, 0x96,
    0x64, 0x54, 0x5F, 0xAC, 0xEE, 0xD4, 0x2B, 0x86, 0xE4, 0xE1, 0x89, 0xDA, 0x5E, 0x37, 0x6F, 0x14, 0xD7, 0x5F, 0x5A, 0xC2, 0x1C, 0xB6, 0x6B, 0x82, 0xF2, 0x04, 0x97, 0xDE, 0xB8, 0x96, 0xD6, 0x8B, 0xDC, 0x5E, 0x2A, 0x6F, 0x61, 0xDC, 0xB0, 0x35, 0xF2, 0xE5, 0x35, 0x55, 0x3E, 0x97, 0x66, 0x5B, 0x7A, 0xAF,
    0x9E, 0xBA, 0xBD, 0xD9, 0x2C, 0xF6, 0xDD, 0x35, 0x92, 0x39, 0xA6, 0x59, 0x1E, 0xD9, 0x3F, 0x7F, 0x5B, 0x8C, 0xFD, 0x81, 0x1F, 0xCD, 0x19, 0x8E, 0xA9, 0x0C, 0x8B, 0x8C, 0x9C, 0x13, 0x3C, 0x9E, 0x95, 0xFF, 0x4B, 0x97, 0xF6, 0x1F, 0xBD, 0x1F, 0xD2, 0x18, 0xFD, 0x94, 0x4D, 0x5A, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82};

/*---------------------------------------------------------------------------*/

static const uint32_t LOGO_DARK_PNG_SIZE = 1679;

static const byte_t LOGO_DARK_PNG_DATA[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x08, 0x03, 0x00, 0x00, 0x00, 0x9D, 0xB7, 0x81, 0xEC, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x2E, 0x23, 0x00, 0x00, 0x2E, 0x23, 0x01,
    0x78, 0xA5, 0x3F, 0x76, 0x00, 0x00, 0x02, 0x49, 0x50, 0x4C, 0x54, 0x45, 0x47, 0x70, 0x4C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0x2D, 0xB8,
    0xDE, 0x00, 0x00, 0x00, 0xC2, 0x74, 0x52, 0x4E, 0x53, 0x00, 0x46, 0x92, 0xCA, 0x78, 0x75, 0x62, 0xF5, 0xA9, 0x8B, 0x87, 0xFE, 0xE9, 0xE0, 0xED, 0xF2, 0xC7, 0xA8, 0xDA, 0xF8, 0x53, 0x0A, 0xD6, 0x24, 0xEF, 0xBA, 0xF7, 0x48, 0xBF, 0x7A, 0x47, 0x6D, 0x86, 0x2D, 0x16, 0xC2, 0x4B, 0x65, 0x0B, 0xF4, 0x2C,
    0xD9, 0x06, 0x32, 0xEC, 0x39, 0xC6, 0xF0, 0x27, 0x5D, 0x5E, 0x77, 0x4E, 0xF6, 0x09, 0x94, 0x9A, 0xF9, 0x82, 0x52, 0x6E, 0xDE, 0x14, 0x3E, 0x01, 0x28, 0x56, 0xA4, 0x08, 0x74, 0x4C, 0xD5, 0x41, 0xEA, 0x9B, 0xCD, 0xFA, 0xE3, 0x7F, 0x38, 0x15, 0x58, 0x81, 0xA2, 0x34, 0xEE, 0x04, 0xBE, 0x88, 0x0D, 0xAB,
    0x44, 0x2A, 0x25, 0x11, 0xFD, 0xB6, 0xAF, 0x91, 0x7C, 0x93, 0x4F, 0xD4, 0x8F, 0x10, 0xD0, 0xE2, 0x8D, 0x96, 0x70, 0x2E, 0xCB, 0x54, 0xDF, 0x02, 0xAD, 0x7D, 0x1A, 0x40, 0x6A, 0xB3, 0xCC, 0xE4, 0x66, 0x79, 0x89, 0x8C, 0xE8, 0xB7, 0x4D, 0xD3, 0x99, 0xB1, 0x03, 0xD2, 0x67, 0x07, 0x85, 0xA7, 0x22, 0x21,
    0xE6, 0xC1, 0xE7, 0x71, 0xCE, 0x12, 0x1D, 0xB9, 0x6C, 0x0E, 0xE1, 0x1B, 0xAE, 0xCF, 0x59, 0x8A, 0x51, 0xDD, 0x5B, 0xBD, 0x18, 0x19, 0x9C, 0xF3, 0xBB, 0x8E, 0xD1, 0xC8, 0xDB, 0x2B, 0xA6, 0xF1, 0xC3, 0x5F, 0x0F, 0x9F, 0x3C, 0x0C, 0x64, 0xAA, 0xEB, 0x3A, 0xC9, 0x3B, 0x4A, 0xB8, 0x36, 0xFC, 0x43, 0x49,
    0x29, 0xDC, 0x73, 0xAA, 0xC2, 0x7E, 0xA2, 0x00, 0x00, 0x03, 0x1E, 0x49, 0x44, 0x41, 0x54, 0x58, 0xC3, 0x9D, 0x57, 0xF5, 0x5F, 0xDB, 0x40, 0x14, 0xBF, 0xB6, 0x50, 0x8A, 0x0C, 0x2B, 0x14, 0x6B, 0x29, 0x94, 0x52, 0x0A, 0x0C, 0x36, 0x86, 0xCB, 0x70, 0x77, 0x1D, 0x30, 0x60, 0xEE, 0xEE, 0xBE, 0x31, 0x77,
    0x77, 0x77, 0x77, 0x77, 0xCD, 0x5F, 0xB6, 0x7C, 0x1A, 0xB9, 0xBB, 0xE4, 0x72, 0x91, 0xF7, 0x53, 0xDE, 0xFB, 0x4A, 0x9B, 0xBB, 0x7B, 0x2F, 0x09, 0x00, 0x4A, 0xF1, 0x26, 0xD5, 0xF5, 0xF6, 0xE2, 0xDA, 0xEC, 0xD8, 0x73, 0x8F, 0x06, 0xBA, 0x9B, 0x3D, 0x40, 0x67, 0xBC, 0x6B, 0x6F, 0x63, 0xB0, 0x78, 0xD8,
    0x90, 0xA2, 0x43, 0xDE, 0xF4, 0x92, 0x21, 0x44, 0x67, 0x85, 0x46, 0x79, 0x6A, 0x31, 0xA3, 0x14, 0x33, 0xB4, 0xE8, 0x17, 0x30, 0x94, 0xB8, 0xA6, 0xAE, 0x3F, 0xC0, 0x50, 0x23, 0x49, 0x4D, 0x5F, 0x89, 0xB2, 0xCF, 0xCC, 0x5B, 0xEA, 0x0A, 0xDA, 0x73, 0xF0, 0x0A, 0x5A, 0x0B, 0x56, 0x31, 0x08, 0x11, 0x99,
    0x2D, 0xD6, 0x12, 0xA1, 0xB8, 0xA1, 0x2F, 0x1A, 0x3A, 0xCC, 0xA2, 0xEA, 0x17, 0xF3, 0xAC, 0x70, 0xBB, 0x09, 0x07, 0x06, 0xA7, 0x0A, 0x06, 0x55, 0x54, 0x83, 0x32, 0x9E, 0x15, 0x35, 0x2A, 0x45, 0x6A, 0xBB, 0x78, 0xE8, 0x2E, 0xD5, 0xC0, 0xC2, 0xB3, 0x7A, 0xE4, 0xD0, 0x05, 0x1E, 0x9A, 0xA4, 0x1A, 0xC4,
    0x72, 0xA4, 0x99, 0x24, 0x2C, 0x83, 0xC3, 0x92, 0xA9, 0x06, 0x87, 0x39, 0x52, 0x03, 0x09, 0xAB, 0xE0, 0xEF, 0x8E, 0x6A, 0x90, 0xCF, 0x91, 0xCA, 0x48, 0xD8, 0x2E, 0x0E, 0xDB, 0x41, 0x35, 0x98, 0xCD, 0x91, 0x6C, 0x24, 0x2C, 0x8D, 0xC3, 0x3A, 0xA8, 0x06, 0xED, 0x1C, 0x29, 0x9A, 0x84, 0xD9, 0x54, 0xCF,
    0x62, 0x49, 0x68, 0x32, 0xBF, 0xD2, 0xE5, 0x94, 0x05, 0x66, 0x98, 0x55, 0xE7, 0xC9, 0xFA, 0x7E, 0xE4, 0xC0, 0x4E, 0x97, 0xC3, 0x47, 0x11, 0x78, 0x11, 0x41, 0x5E, 0x3D, 0x05, 0x3D, 0xF1, 0xA1, 0x72, 0xC2, 0x56, 0x14, 0x4F, 0x4C, 0x90, 0xC2, 0x75, 0x73, 0xF1, 0xAE, 0xAB, 0x95, 0x19, 0x4C, 0xC3, 0x09,
    0x35, 0x38, 0x7A, 0x52, 0xDA, 0xB6, 0x31, 0x52, 0x7D, 0x98, 0x94, 0x91, 0x87, 0xA2, 0x39, 0x62, 0x13, 0x26, 0x3D, 0xE1, 0x2F, 0xCE, 0xE2, 0xFA, 0x5B, 0xC2, 0x7F, 0x7F, 0x20, 0x3A, 0x78, 0xE4, 0xA7, 0x94, 0x8D, 0xD4, 0x31, 0xE1, 0xCA, 0x8C, 0xEA, 0x83, 0x84, 0x6A, 0x66, 0x82, 0x48, 0xBD, 0x0D, 0xE1,
    0x7A, 0xB1, 0x98, 0x05, 0x80, 0x53, 0xB8, 0x8E, 0xCC, 0x14, 0xF0, 0x1B, 0xE2, 0x02, 0x3F, 0x03, 0xC0, 0x21, 0x92, 0x0B, 0x09, 0x53, 0xE4, 0x31, 0x00, 0x8D, 0x9D, 0xF0, 0x3E, 0xB3, 0x6D, 0x66, 0x73, 0xCC, 0x12, 0xE4, 0xC6, 0xEF, 0x03, 0xE0, 0x86, 0x59, 0x0E, 0xAF, 0xBF, 0x04, 0x4B, 0xCF, 0xD9, 0x74,
    0x5C, 0x79, 0x22, 0xB6, 0xB2, 0xB0, 0x4F, 0xBE, 0xD9, 0xE2, 0xB0, 0xE1, 0x5B, 0x35, 0x57, 0x49, 0xCF, 0x3D, 0x5B, 0x5A, 0x60, 0x81, 0xD3, 0xD7, 0xC0, 0xC2, 0x0B, 0xAE, 0x72, 0x6F, 0x05, 0x49, 0x3E, 0x54, 0x27, 0xDB, 0xD0, 0xD7, 0x81, 0xC2, 0x00, 0x2C, 0x1C, 0x91, 0xAD, 0x3A, 0x8C, 0x30, 0x01, 0x33,
    0xC1, 0x5A, 0x46, 0xA0, 0xF0, 0x13, 0x16, 0xD2, 0xE1, 0xCE, 0x54, 0x39, 0x50, 0xF5, 0xFA, 0xA0, 0x43, 0x22, 0x12, 0xCF, 0xE0, 0xF7, 0x30, 0xCE, 0x48, 0xEF, 0x49, 0x20, 0x16, 0x1D, 0x3B, 0x3E, 0x6C, 0xB1, 0x38, 0x6D, 0x23, 0x71, 0xCB, 0x30, 0x20, 0x1C, 0x0A, 0xBC, 0x6C, 0xFA, 0x4F, 0xC9, 0x40, 0x31,
    0x90, 0xB6, 0x33, 0xC3, 0x21, 0x14, 0x38, 0x3A, 0xDA, 0x0C, 0xB6, 0x43, 0x85, 0x85, 0x4D, 0xFF, 0xC2, 0x34, 0x42, 0x9B, 0x41, 0x34, 0xFE, 0x9F, 0x91, 0x2C, 0x44, 0x9B, 0xC1, 0x7E, 0x44, 0xE2, 0x03, 0xA3, 0x8C, 0xEE, 0x35, 0x40, 0x27, 0x83, 0x1F, 0x4C, 0xA0, 0x06, 0x27, 0x34, 0x19, 0xA0, 0x8A, 0x5F,
    0xE0, 0x07, 0x9A, 0xBA, 0xB5, 0xE8, 0x53, 0x50, 0xC5, 0x3A, 0xF0, 0x19, 0x4D, 0x97, 0x6B, 0x31, 0xB0, 0xA1, 0x8A, 0x02, 0xD0, 0x83, 0x9D, 0xD7, 0x74, 0x75, 0xFD, 0x65, 0x4C, 0xD0, 0x07, 0xFC, 0x58, 0xEE, 0x50, 0x37, 0xD8, 0x86, 0x09, 0xBE, 0x01, 0x0F, 0xDE, 0x32, 0x37, 0xD5, 0xF4, 0x56, 0x9C, 0x3F,
    0x88, 0xAF, 0xA9, 0xFA, 0x3B, 0x50, 0xA5, 0x84, 0xDE, 0x0B, 0x40, 0x97, 0xDA, 0x40, 0x47, 0x63, 0xB7, 0xB4, 0xC9, 0xD9, 0xDA, 0x47, 0x69, 0x2D, 0x4B, 0xF1, 0x75, 0xD2, 0x7B, 0x4A, 0xCA, 0xFD, 0xC2, 0x56, 0x3F, 0xC8, 0x67, 0x47, 0x71, 0x1A, 0xE1, 0xD9, 0xB8, 0xD9, 0x15, 0x21, 0x67, 0xA6, 0xB1, 0xC0,
    0x7B, 0xE2, 0xF8, 0xB3, 0xEF, 0x5D, 0x18, 0x97, 0xDB, 0xCB, 0x49, 0xE7, 0xF8, 0x8B, 0x82, 0x37, 0x26, 0x12, 0x69, 0x81, 0x6D, 0x7F, 0xCA, 0x18, 0x8E, 0x4F, 0x81, 0x1F, 0x88, 0x33, 0x6E, 0xC0, 0x6F, 0x59, 0x9B, 0x61, 0x03, 0x7E, 0x79, 0x9A, 0x8D, 0xEA, 0x57, 0x0B, 0x0B, 0xEC, 0x34, 0xA6, 0x87, 0x6F,
    0x93, 0x8D, 0xE5, 0x86, 0x0C, 0xAE, 0xC2, 0x3D, 0x5E, 0x63, 0x44, 0xEF, 0x45, 0x4F, 0x89, 0x49, 0xBF, 0x7E, 0x27, 0x7E, 0xCE, 0xB6, 0xE8, 0xD5, 0x17, 0x48, 0x4F, 0x6A, 0x42, 0x94, 0x1E, 0x79, 0x78, 0x1E, 0xA1, 0x55, 0xE6, 0x6B, 0xD7, 0xE7, 0xFB, 0x88, 0xCD, 0xD6, 0x1A, 0xA1, 0x4D, 0x1E, 0x52, 0xAF,
    0x3C, 0x6E, 0x22, 0xD5, 0xE5, 0xF6, 0x26, 0xEA, 0xC4, 0xD9, 0x77, 0x9A, 0x2E, 0xBF, 0x7E, 0x47, 0x75, 0x68, 0xC6, 0xBB, 0x5F, 0x29, 0xA9, 0x3B, 0x0A, 0xAB, 0x35, 0x7E, 0xFD, 0x7E, 0xED, 0xFF, 0x3E, 0x24, 0x19, 0x53, 0xC3, 0x23, 0x63, 0x7A, 0xBF, 0xE0, 0x27, 0x4C, 0xD6, 0x4D, 0xA1, 0xA5, 0xA5, 0x2B,
    0xBB, 0x33, 0x7F, 0xFF, 0x51, 0xFE, 0x58, 0xFC, 0x0F, 0x5E, 0xC4, 0xF3, 0x2C, 0xE8, 0x47, 0x74, 0x13, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82};

/*---------------------------------------------------------------------------*/

ResPack *res_gui_respack(const char_t *locale)
{
    ResPack *pack = respack_embedded("res_gui");
    /* Non-localized pack */
    {
        unref(locale);
        respack_add_msg(pack, ASSERT_CRASH_TEXT);
        respack_add_msg(pack, ASSERT_INFO_TEXT);
        respack_add_msg(pack, CONTACT_INFO_TEXT);
        respack_add_msg(pack, FILE_TEXT_TEXT);
        respack_add_msg(pack, LINE_TEXT_TEXT);
        respack_add_msg(pack, SHOW_ASSERT_TEXT);
        respack_add_msg(pack, ASSERT_LOG_TEXT);
        respack_add_msg(pack, ASSERT_TITLE_TEXT);
        respack_add_msg(pack, DEBUG_TEXT_TEXT);
        respack_add_msg(pack, CONTINUE_TEXT_TEXT);
        respack_add_msg(pack, EXIT_TEXT_TEXT);
        respack_add_cdata(pack, 1, BOMB_PNG_DATA, BOMB_PNG_SIZE);
        respack_add_cdata(pack, 1, BOMB_DARK_PNG_DATA, BOMB_DARK_PNG_SIZE);
        respack_add_cdata(pack, 1, CONFUSED_PNG_DATA, CONFUSED_PNG_SIZE);
        respack_add_cdata(pack, 1, CONFUSED_DARK_PNG_DATA, CONFUSED_DARK_PNG_SIZE);
        respack_add_cdata(pack, 1, LOGO_PNG_DATA, LOGO_PNG_SIZE);
        respack_add_cdata(pack, 1, LOGO_DARK_PNG_DATA, LOGO_DARK_PNG_SIZE);
        return pack;
    }
}
