---
layout: default
title: "TypeRig"
nav_order: 1
---

# TypeRig

<div class="uk-position-relative uk-visible-toggle uk-dark" tabindex="-1" uk-slider>
<ul class="uk-slider-items uk-child-width-1-1@">
<li>
<a href="/images/typerig/typerig-panel.png" data-fancybox="images" data-caption="TR Panel">
<img src="/images/typerig/typerig-panel.png" width="" height="" alt="">
</a>
</li>
<li>
<a href="/images/typerig/typerig-match-contours.png" data-fancybox="images" data-caption="TR Match Contours tool">
<img src="/images/typerig/typerig-match-contours.png" width="" height="" alt="">
</a>
</li>
</ul>
<a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slider-item="previous"></a>
<a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slider-item="next"></a>
</div>

**TypeRig** is a mighty collection of tools and scripts that extend the FontLab 8 & 7 font editor. TypeRig is developed by Vassil Kateliev. It works on the newest FontLab 8, and should work on FontLab 7 as well. Future versions will focus on FontLab 8.

## Installation

Click the button below to download the TypeRig installer, then open the downloaded `install.vfpy` file in the FontLab app.

[Download TypeRig installer](https://cdn.jsdelivr.net/gh/kateliev/TypeRig/install.vfpy){: .btn .btn-purple target="_blank" } [Documentation](https://kateliev.github.io/TypeRig/){: .btn target="_blank" }

## Intro video

<div class="video-container"><iframe src="https://www.youtube.com/embed/oM_89KA3Fnc" frameborder="0" allow="accelerometer; encrypted-media; gyroscope; picture-in-picture" width="1920" height="1080" allowfullscreen uk-responsive uk-video="automute: true"></iframe></div>

## Documentation

The documentation is usually a bit behind the current functionality. [Read more...](https://kateliev.github.io/TypeRig/)

### TypeRig Panel

- [Overview](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Panel-Basics)
- [Anchor](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Anchor-Panel)
- [Contour](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Contour-Panel)
- [Curve](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Curve-Panel)
- [Guide](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Guide-Panel)
- [Layer](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Layer-Panel)
- [Metrics](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Metrics-Panel)
- [Node](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Node-Panel)
- [Outline](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Outline-Panel)
- [Statistics](https://kateliev.github.io/TypeRig/Docs/GUI/TR-Stats-Panel)

### Delta Machine

- [Delta Machine](https://kateliev.github.io/TypeRig/Docs/DeltaMachine/DeltaMachine)

### TypeRig Tools

- [TypeRig Tools](https://github.com/kateliev/TypeRig/tree/master/Scripts/TypeRig%20Tools), check the source code for more info

## For font developers

- TypeRig also comes with a [`typerig`](https://fontlabcom.github.io/fontlab-python-docs/) Python library that provides a “Pythonic” interface to the FontLab Python API.
- [TypeRig on Github](https://github.com/kateliev/TypeRig)
