import en from '../en';
import type { BaseTranslation, Translation } from '../i18n-types';

const es = {
	...(en as Translation),
	addConnection: 'Agregar conexión',
	allowConnections: 'Cambia la configuración de tu servidor para permitir conexiones desde',
	allowMixedContent: 'Permitir contenido mixto',
	apiKey: 'Llave de API',
	areYouSureYouWantToDeleteAllKnowledge:
		'¿Estás seguro de que quieres eliminar todo el conocimiento?',
	areYouSureYouWantToDeleteAllSessions: '¿Estás seguro de que quieres eliminar todas las sesiones?',
	areYouSureYouWantToDeleteAllSettings: '¿Estás seguro de que quieres eliminar todos los ajustes?',
	areYouSureYouWantToLeave: '¿Estás seguro de que quieres salir?\nLa tarea en progreso se detendrá',
	assistant: 'Asistente',
	automatic: 'Automático',
	automaticallyCheckForUpdates: 'Buscar actualizaciones automáticamente',
	availableModels: 'Modelos disponibles',
	baseUrl: 'URL base',
	browseModels: 'Explorar la lista de modelos disponibles',
	cancel: 'Cancelar',
	cantConnectToOllamaServer: 'No se puede conectar al servidor de Ollama',
	checkBrowserExtensions:
		'También verifica que ninguna extensión del navegador esté bloqueando la conexión',
	checkingForUpdates: 'Buscando actualizaciones...',
	checkNow: 'Comprobar ahora',
	clear: 'Limpiar',
	confirmDeletion: 'Confirmar eliminación',
	connect: 'Conectar',
	connected: 'Conectado',
	connecting: 'Conectando...',
	connectionFailedToVerify:
		'No se pudo verificar la conexión, revisa la configuración e intenta de nuevo',
	connectionIsVerified: 'La conexión ha sido verificada y está lista para usar',
	connectionLabelHelp: 'Identifica la conexión en la lista de modelos',
	connectionType: 'Tipo de conexión',
	content: 'Contenido',
	controls: 'Controles',
	controlsOnlyAvailableForOllama:
		'Los controles avanzados actualmente solo están disponibles para modelos de Ollama',
	copy: 'Copiar',
	couldntCheckForUpdates: 'No se pudo buscar actualizaciones automáticamente',
	couldntConnectToOllamaServer: 'No se pudo conectar al servidor de Ollama',
	creatingTunnel: 'Creando un túnel',
	currentVersion: 'Versión actual',
	dangerZone: 'Zona de peligro',
	dark: 'Oscuro',
	deleteAllKnowledge: 'Eliminar todo el conocimiento',
	deleteAllSessions: 'Eliminar todas las sesiones',
	deleteAllSettings: 'Eliminar todos los ajustes',
	deleteKnowledge: 'Eliminar conocimiento',
	deleteServer: 'Eliminar servidor',
	deleteSession: 'Eliminar sesión',
	disconnected: 'Desconectado',
	dismiss: 'Descartar',
	downloadModel: 'Descargar modelo',
	edit: 'Editar',
	emptyKnowledge: 'Sin conocimiento',
	emptySessions: 'Sin sesiones',
	error: 'Error',
	genericError: 'Lo siento, algo salió mal',
	goToDownloads: 'Ir a descargas',
	goToKnowledge: 'Ir a conocimiento',
	goToReleases: 'Ir a versiones',
	howToObtainOpenAIKey: '¿Cómo obtener una llave de API de OpenAI?',
	howToUpdateDocker: '¿Cómo actualizar el contenedor Docker?',
	interface: 'Interfaz',
	internalServerError: 'Hubo un error interno del servidor, por favor intenta de nuevo más tarde',
	isCurrentVersionLatest: 'Estás en la última versión',
	isLatestVersion: 'Hay una versión más reciente disponible',
	knowledge: 'Conocimiento',
	knowledgeSaved: 'Conocimiento guardado',
	label: 'Etiqueta',
	language: 'Idioma',
	lastUsedModels: 'Modelos utilizados recientemente',
	light: 'Claro',
	messageOfTheDay: 'Mensaje del día',
	messages: 'Mensajes',
	modelNotFound: 'Modelo no encontrado',
	modelOptions: 'Opciones del modelo',
	modelWasDownloaded: '{model:string} fue descargado',
	modelsFilter: 'Filtro de nombres de modelos',
	modelsFilterHelp: 'Oculta los nombres de modelos que no empiecen con el filtro',
	motd: 'Mensaje del día',
	name: 'Nombre',
	newKnowledge: 'Nuevo conocimiento',
	newSession: 'Nueva sesión',
	noApiKey: 'No hay llave de API',
	noKnowledgeChosen: 'Crea un nuevo conocimiento o elige uno de la lista',
	noRecentModels: 'No hay modelos utilizados recientemente',
	noServerConnections: 'No hay conexiones de servidor, agrega una para comenzar',
	noSessionChosen: 'Crea una nueva sesión o elige una existente de la lista',
	notFound: 'La página que estás buscando no existe',
	ollama: 'Ollama',
	ollamaLibrary: 'Librería de Ollama',
	openAICompatible: 'OpenAI: Servidores compatibles (ej. llama.cpp)',
	openAIOfficialAPI: 'OpenAI: API Oficial',
	otherModels: 'Otros modelos',
	prompt: 'Indicación',
	promptPlaceholder: 'Escribe literalmente cualquier cosa',
	pullModel: 'Obtener modelo',
	pullModelPlaceholder: 'Etiqueta del modelo (ej. llama3.1)',
	pullingModel: 'Obteniendo modelo',
	random: 'Aleatorio',
	refreshToUpdate: 'Actualiza para actualizar',
	releaseHistory: 'Historial de versiones',
	retry: 'Reintentar',
	reVerify: 'Re-verificar',
	run: 'Ejecutar',
	runtimeOptions: 'Opciones de ejecución',
	save: 'Guardar',
	search: 'Buscar',
	searchEmpty: 'No se encontraron resultados',
	seeDocs: 'Ver documentación',
	servers: 'Servidores',
	serverSettingsUpdated:
		'La configuración del servidor fue actualizada y necesita ser re-verificada en "Ajustes"',
	session: 'Sesión',
	sessions: 'Sesiones',
	settings: 'Ajustes',
	somethingWentWrong: 'Lo sentimos, algo salió mal',
	stopCompletion: 'Detener respuesta',
	stopResponse: 'Detener respuesta',
	success: 'Éxito',
	system: 'Sistema',
	systemPrompt: 'Indicación del sistema',
	tryingToConnectNotLocalhost:
		'Si quieres conectarte a un servidor de Ollama que no está disponible en {hostname:string} o {ip:string} prueba',
	useModelsFromThisServer: 'Usar modelos de este servidor',
	verify: 'Verificar',
	version: 'Versión',
	writePromptToStart: 'Escribe una indicación para comenzar una nueva sesión',
	you: 'Tú'
} satisfies BaseTranslation;

export default es;
