import en from '../en';
import type { BaseTranslation, Translation } from '../i18n-types';

const de = {
	...(en as Translation),
	addConnection: 'Verbindung hinzufügen',
	allowConnections: 'Um Verbindungen zuzulassen, ändern Sie Ihre Servereinstellungen von',
	allowMixedContent: 'Gemischte Inhalte zulassen',
	apiKey: 'API-Schlüssel',
	areYouSureYouWantToDeleteAllKnowledge: 'Sind Sie sicher, dass Sie alles Wissen löschen möchten?',
	areYouSureYouWantToDeleteAllSessions: 'Sind Sie sicher, dass Sie alle Sitzungen löschen möchten?',
	areYouSureYouWantToDeleteAllSettings:
		'Sind Sie sicher, dass Sie alle Einstellungen löschen möchten?',
	areYouSureYouWantToLeave:
		'Sind Sie sicher, dass Sie die Seite verlassen möchten?\nDie laufende Ausführung wird gestoppt',
	assistant: 'Assistent',
	automatic: 'Automatisch',
	automaticallyCheckForUpdates: 'Automatisch auf Updates prüfen',
	availableModels: 'Verfügbare Modelle',
	baseUrl: 'Basis-URL',
	browseModels: 'Liste der verfügbaren Modelle durchsuchen',
	cancel: 'Abbrechen',
	cantConnectToOllamaServer: 'Kann keine Verbindung zum Ollama-Server herstellen',
	checkBrowserExtensions:
		'Überprüfen Sie auch, ob keine Browser-Erweiterungen die Verbindung blockieren',
	checkingForUpdates: 'Prüfe auf Updates...',
	checkNow: 'Jetzt prüfen',
	clear: 'Leeren',
	confirmDeletion: 'Löschen bestätigen',
	connectionType: 'Verbindungstyp',
	connectionLabelHelp: 'Bestimmt die Verbindung in der Modellliste',
	connecting: 'Verbinde...',
	connectionIsVerified: 'Die Verbindung wurde überprüft und ist einsatzbereit',
	connectionFailedToVerify:
		'Die Verbindung konnte nicht überprüft werden. Überprüfen Sie die Verbindungseinstellungen und versuchen Sie es erneut',
	content: 'Inhalt',
	controls: 'Steuerungen',
	controlsOnlyAvailableForOllama:
		'Erweiterte Steuerungen sind derzeit nur für Ollama-Modelle verfügbar',
	copy: 'Kopieren',
	couldntCheckForUpdates: 'Konnte nicht automatisch auf Updates prüfen',
	couldntConnectToOllamaServer: 'Konnte keine Verbindung zum Ollama-Server herstellen',
	creatingTunnel: 'Erstelle Tunnel',
	currentVersion: 'Aktuelle Version',
	dangerZone: 'Gefahrenzone',
	dark: 'Dunkel',
	deleteAllKnowledge: 'Alles Wissen löschen',
	deleteAllSessions: 'Alle Sitzungen löschen',
	deleteAllSettings: 'Alle Einstellungen löschen',
	deleteKnowledge: 'Wissen löschen',
	deleteServer: 'Server löschen',
	deleteSession: 'Sitzung löschen',
	disconnected: 'Getrennt',
	dismiss: 'Verwerfen',
	downloadModel: 'Modell herunterladen',
	edit: 'Bearbeiten',
	emptyKnowledge: 'Kein Wissen',
	emptySessions: 'Keine Sitzungen',
	error: 'Fehler',
	f16Kv: 'F16 KV',
	frequencyPenalty: 'Frequenzstrafe',
	genericError: 'Entschuldigung, etwas ist schiefgelaufen',
	goToDownloads: 'Zu Downloads gehen',
	goToKnowledge: 'Zum Wissen gehen',
	goToReleases: 'Zu Veröffentlichungen gehen',
	howToObtainOpenAIKey: 'Wie erhält man einen API-Schlüssel von OpenAI?',
	howToUpdateDocker: 'Wie aktualisiert man den Docker-Container?',
	interface: 'Oberfläche',
	internalServerError: 'Es gab einen internen Serverfehler. Bitte versuchen Sie es später erneut',
	isCurrentVersionLatest: 'Sie verwenden die neueste Version',
	isLatestVersion: 'Eine neuere Version ist verfügbar',
	knowledge: 'Wissen',
	knowledgeSaved: 'Wissen gespeichert',
	label: 'Label',
	language: 'Sprache',
	lastUsedModels: 'Zuletzt verwendete Modelle',
	light: 'Hell',
	lowVram: 'Niedriger VRAM',
	mainGpu: 'Haupt-GPU',
	messageOfTheDay: 'Nachricht des Tages',
	messages: 'Nachrichten',
	minP: 'Min P',
	mirostat: 'Mirostat',
	mirostatEta: 'Mirostat ETA',
	mirostatTau: 'Mirostat Tau',
	modelNotFound: 'Modell nicht gefunden',
	modelOptions: 'Modelloptionen',
	modelWasDownloaded: '{model:string} wurde heruntergeladen',
	modelsFilter: 'Modellnamen-Filter',
	modelsFilterHelp: 'Blendet Modellnamen aus, die nicht mit dem Filter beginnen',
	motd: 'Nachricht des Tages',
	name: 'Name',
	newKnowledge: 'Neues Wissen',
	newSession: 'Neue Sitzung',
	noApiKey: 'Kein API-Schlüssel',
	noKnowledgeChosen: 'Erstellen Sie neues Wissen oder wählen Sie eines aus der Liste',
	noRecentModels: 'Keine zuletzt verwendeten Modelle',
	noServerConnections: 'Keine Serververbindungen, fügen Sie eine hinzu, um zu beginnen',
	noSessionChosen: 'Erstellen Sie eine neue Sitzung oder wählen Sie eine aus der Liste',
	notFound: 'Die Seite, die Sie suchen, existiert nicht',
	numBatch: 'Anz. Bündel',
	numCtx: 'Kontextgröße',
	numGpu: 'Anz. GPU',
	numKeep: 'Anz. behalten',
	numPredict: 'Anz. vorhersagen',
	numThread: 'Anzahl der Threads',
	numa: 'NUMA',
	ollama: 'Ollama',
	ollamaLibrary: 'Ollamas Bibliothek',
	openAIOfficialAPI: 'OpenAI: Offizielle API',
	openAICompatible: 'OpenAI: Kompatible Server (z. B. llama.cpp)',
	otherModels: 'Andere Modelle',
	penalizeNewline: 'Neue Zeilen bestrafen',
	presencePenalty: 'Präsenzstrafe',
	prompt: 'Anweisung',
	promptPlaceholder: 'Schreiben Sie buchstäblich alles',
	pullModel: 'Modell abrufen',
	pullModelPlaceholder: 'Modell-Tag (z.B. llama3.1)',
	pullingModel: 'Modell wird abgerufen',
	random: 'Zufällig',
	refreshToUpdate: 'Neu laden, um zu aktualisieren',
	releaseHistory: 'Versionsverlauf',
	repeatLastN: 'Letzte N wiederholen',
	repeatPenalty: 'Wiederholungsstrafe',
	retry: 'Erneut versuchen',
	run: 'Ausführen',
	reVerify: 'Erneut überprüfen',
	runtimeOptions: 'Laufzeitoptionen',
	save: 'Speichern',
	search: 'Suchen',
	searchEmpty: 'Keine Ergebnisse gefunden',
	seed: 'Seed',
	seeDocs: 'Dokumentation ansehen',
	servers: 'Server',
	serverSettingsUpdated:
		'Die Serverkonfiguration wurde aktualisiert und muss in den "Einstellungen" erneut überprüft werden',
	session: 'Sitzung',
	sessions: 'Sitzungen',
	settings: 'Einstellungen',
	somethingWentWrong: 'Entschuldigung, etwas ist schiefgelaufen',
	stop: 'Stop-Sequenz',
	stopCompletion: 'Ausführung stoppen',
	stopResponse: 'Antwort stoppen',
	success: 'Erfolg',
	system: 'System',
	systemPrompt: 'System-Anweisung',
	temperature: 'Temperatur',
	tfsZ: 'TFS Z',
	topK: 'Top K',
	topP: 'Top P',
	tryingToConnectNotLocalhost:
		'Wenn Sie versuchen, eine Verbindung zu einem Ollama-Server herzustellen, der nicht unter {hostname:string} oder {ip:string} verfügbar ist, versuchen Sie',
	typicalP: 'Typisches P',
	useMlock: 'MLOCK verwenden',
	useMmap: 'MMAP verwenden',
	useModelsFromThisServer: 'Modelle von diesem Server verwenden',
	verify: 'Überprüfen',
	version: 'Version',
	vocabOnly: 'Nur Vokabular',
	writePromptToStart: 'Schreiben Sie eine Anweisung, um eine neue Sitzung zu starten',
	you: 'Sie'
} satisfies BaseTranslation;

export default de;
