package org.telegram.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import org.telegram.messenger.AndroidUtilities;
import org.telegram.messenger.LocaleController;
import org.telegram.messenger.MessagesController;
import org.telegram.messenger.NotificationCenter;
import org.telegram.messenger.R;
import org.telegram.messenger.UserConfig;
import org.telegram.ui.ActionBar.ActionBar;
import org.telegram.ui.ActionBar.BaseFragment;
import org.telegram.ui.ActionBar.Theme;
import org.telegram.ui.ActionBar.ThemeDescription;
import org.telegram.ui.Cells.HeaderCell;
import org.telegram.ui.Cells.ShadowSectionCell;
import org.telegram.ui.Cells.TextCheckCell;
import org.telegram.ui.Cells.TextDetailSettingsCell;
import org.telegram.ui.Cells.TextInfoPrivacyCell;
import org.telegram.ui.Cells.TextSettingsCell;
import org.telegram.ui.Components.LayoutHelper;
import org.telegram.ui.Components.RecyclerListView;

import java.util.ArrayList;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by flyun on 2023/7/13.
 */
public class ServerSettingActivity extends BaseFragment implements NotificationCenter.NotificationCenterDelegate {

    private RecyclerListView listView;
    private ListAdapter adapter;
    private LinearLayoutManager layoutManager;

    private int apiKeyHeaderRow;
    private int apiKeyRow;
    private int apiKeySectionRow;
    private int apiServerHeaderRow;
    private int apiServerRow;
    private int googleSectionRow;
    private int apiKeyGoogleHeaderRow;
    private int apiKeyGoogleRow;
    private int apiKeyGoogleSectionRow;
    private int apiServerGoogleHeaderRow;
    private int apiServerGoogleRow;
    private int claudeSectionRow;
    private int apiKeyClaudeHeaderRow;
    private int apiKeyClaudeRow;
    private int apiKeyClaudeSectionRow;
    private int apiServerClaudeHeaderRow;
    private int apiServerClaudeRow;

    private int rowCount = 0;

    @Override
    public boolean onFragmentCreate() {

        getNotificationCenter().addObserver(this, NotificationCenter.updateInterfaces);

        apiKeyHeaderRow = rowCount++;
        apiKeyRow = rowCount++;
        apiKeySectionRow = rowCount++;

        apiServerHeaderRow = rowCount++;
        apiServerRow = rowCount++;

        googleSectionRow = rowCount++;

        apiKeyGoogleHeaderRow = rowCount++;
        apiKeyGoogleRow = rowCount++;
        apiKeyGoogleSectionRow = rowCount++;

        apiServerGoogleHeaderRow = rowCount++;
        apiServerGoogleRow = rowCount++;

        claudeSectionRow = rowCount++;

        apiKeyClaudeHeaderRow = rowCount++;
        apiKeyClaudeRow = rowCount++;
        apiKeyClaudeSectionRow = rowCount++;

        apiServerClaudeHeaderRow = rowCount++;
        apiServerClaudeRow = rowCount++;
        return super.onFragmentCreate();
    }

    @Override
    public void onFragmentDestroy() {
        super.onFragmentDestroy();
        getNotificationCenter().removeObserver(this, NotificationCenter.updateInterfaces);
    }

    @Override
    public View createView(Context context) {
        actionBar.setBackButtonImage(R.drawable.ic_ab_back);
        actionBar.setAllowOverlayTitle(true);
        actionBar.setTitle(LocaleController.getString("ApiServerSetting", R.string.ApiServerSetting));
        actionBar.setActionBarMenuOnItemClick(new ActionBar.ActionBarMenuOnItemClick() {
            @Override
            public void onItemClick(int id) {
                if (id == -1) {
                    finishFragment();
                }
            }
        });

        fragmentView = new FrameLayout(context);
        FrameLayout frameLayout = (FrameLayout) fragmentView;
        frameLayout.setBackgroundColor(Theme.getColor(Theme.key_windowBackgroundGray));

        listView = new RecyclerListView(context);
        listView.setItemAnimator(null);
        listView.setLayoutAnimation(null);
        listView.setLayoutManager(layoutManager = new LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false) {
            @Override
            public boolean supportsPredictiveItemAnimations() {
                return false;
            }
        });
        listView.setVerticalScrollBarEnabled(false);
        frameLayout.addView(listView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        listView.setAdapter(adapter = new ListAdapter(context));

        //点击
        listView.setOnItemClickListener((view, position, x, y) ->{

            if (getParentActivity() == null) {
                return;
            }

            if (position == apiKeyRow) {
                presentFragment(new ChangeApiKeyActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeApiKey", "");

            } else if (position == apiServerRow){
                presentFragment(new ChangeApiServerActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeApiServer", "");
            } else if (position == apiKeyGoogleRow) {
                presentFragment(new ChangeGoogleApiKeyActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeGoogleApiKey", "");
            } else if (position == apiServerGoogleRow){
                presentFragment(new ChangeGoogleApiServerActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeGoogleApiServer", "");
            } else if (position == apiKeyClaudeRow) {
                presentFragment(new ChangeClaudeApiKeyActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeClaudeApiKey", "");
            } else if (position == apiServerClaudeRow){
                presentFragment(new ChangeClaudeApiServerActivity(getResourceProvider()));
                AndroidUtilities.logEvent("ChangeClaudeApiServer", "");
            }

        });

        return fragmentView;
    }

    private class ListAdapter extends RecyclerListView.SelectionAdapter {

        private final Context mContext;
        private final static int
                VIEW_TYPE_HEADER = 1,
                VIEW_TYPE_SELECT = 2,
                VIEW_TYPE_DETAIL_TIPS = 3,
                VIEW_TYPE_SHADOW = 4,
                VIEW_TYPE_TEXT_DETAIL = 5;

        public ListAdapter(Context context) {
            mContext = context;
        }

        @Override
        public boolean isEnabled(RecyclerView.ViewHolder holder) {
            int type = holder.getItemViewType();
            return type != VIEW_TYPE_HEADER && type != VIEW_TYPE_SHADOW;
        }

        @Override
        public int getItemCount() {
            return rowCount;
        }

        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view;
            switch (viewType) {
                case VIEW_TYPE_HEADER: {
                    view = new HeaderCell(mContext);
                    view.setBackgroundColor(Theme.getColor(Theme.key_windowBackgroundWhite));
                    break;
                }
                case VIEW_TYPE_TEXT_DETAIL:
                    view = new TextDetailSettingsCell(mContext);
                    view.setBackgroundColor(Theme.getColor(Theme.key_windowBackgroundWhite));
                    break;
                case VIEW_TYPE_SHADOW: {
                    view = new ShadowSectionCell(mContext);
                    break;
                }
                default: {
                    view = new TextInfoPrivacyCell(mContext);
                    break;
                }
            }
            return new RecyclerListView.Holder(view);
        }

        @Override
        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            switch (holder.getItemViewType()) {
                case VIEW_TYPE_HEADER: {
                    HeaderCell headerCell = (HeaderCell) holder.itemView;
                    if (position == apiKeyHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiKey", R.string.ApiKey));
                    } else if (position == apiServerHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiServer", R.string.ApiServer));
                    } else if (position == apiKeyGoogleHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiKeyGoogle", R.string.ApiKeyGoogle));
                    } else if (position == apiServerGoogleHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiServerGoogle", R.string.ApiServerGoogle));
                    } else if (position == apiKeyClaudeHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiKeyClaude", R.string.ApiKeyClaude));
                    } else if (position == apiServerClaudeHeaderRow) {
                        headerCell.setText(LocaleController.getString("ApiServerClaude", R.string.ApiServerClaude));
                    }
                    break;
                }
                case VIEW_TYPE_SHADOW:
                    View sectionCell = holder.itemView;
                    sectionCell.setTag(position);
                    sectionCell.setBackgroundDrawable(Theme.getThemedDrawable(mContext, R.drawable.greydivider, getThemedColor(Theme.key_windowBackgroundGrayShadow)));
                    break;
                case VIEW_TYPE_TEXT_DETAIL: {
                    TextDetailSettingsCell settingsCell = (TextDetailSettingsCell) holder.itemView;
                    settingsCell.setMultilineDetail(true);
                    if (position == apiKeyRow) {
                        settingsCell.setTextAndValue(
                                LocaleController.formatApiKey(UserConfig.getInstance(currentAccount).apiKey),
                                LocaleController.getString("ApiKeyTips", R.string.ApiKeyTips), false);
                    } else if (position == apiServerRow){
                        settingsCell.setTextAndValue(
                                UserConfig.getInstance(currentAccount).apiServer,
                                LocaleController.getString("ApiServerTips", R.string.ApiServerTips), false);
                    } else if (position == apiKeyGoogleRow) {
                        settingsCell.setTextAndValue(
                                LocaleController.formatApiKey(UserConfig.getInstance(currentAccount).apiKeyGoogle),
                                LocaleController.getString("ApiKeyTips", R.string.ApiKeyTips), false);
                    } else if (position == apiServerGoogleRow){
                        settingsCell.setTextAndValue(
                                UserConfig.getInstance(currentAccount).apiServerGoogle,
                                LocaleController.getString("ApiServerTips", R.string.ApiServerTips), false);
                    } else if (position == apiKeyClaudeRow) {
                        settingsCell.setTextAndValue(
                                LocaleController.formatApiKey(UserConfig.getInstance(currentAccount).apiKeyClaude),
                                LocaleController.getString("ApiKeyTips", R.string.ApiKeyTips), false);
                    } else if (position == apiServerClaudeRow){
                        settingsCell.setTextAndValue(
                                UserConfig.getInstance(currentAccount).apiServerClaude,
                                LocaleController.getString("ApiServerTips", R.string.ApiServerTips), false);
                    }
                }
            }
        }

        @Override
        public int getItemViewType(int position) {
            if (position == apiKeyHeaderRow || position == apiServerHeaderRow
                    || position == apiKeyGoogleHeaderRow || position == apiServerGoogleHeaderRow
                    || position == apiKeyClaudeHeaderRow || position == apiServerClaudeHeaderRow
            ) {
                return VIEW_TYPE_HEADER;
            } else if (position == apiKeyRow || position == apiServerRow
                    || position == apiKeyGoogleRow || position == apiServerGoogleRow
                    || position == apiKeyClaudeRow || position == apiServerClaudeRow
            ){
                return VIEW_TYPE_TEXT_DETAIL;
            } else if (position == apiKeySectionRow || position == apiKeyGoogleSectionRow
                    || position == googleSectionRow){
                return VIEW_TYPE_SHADOW;
            } else if (position == apiKeySectionRow || position == apiKeyClaudeSectionRow
                    || position == claudeSectionRow){
                return VIEW_TYPE_SHADOW;
            } else {
                return 0;
            }
        }
    }

    @Override
    public void didReceivedNotification(int id, int account, final Object... args) {
        if (id == NotificationCenter.updateInterfaces) {
            int mask = (Integer) args[0];
            if ((mask & MessagesController.UPDATE_MASK_API_KEY) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiKeyRow);
            } else if ((mask & MessagesController.UPDATE_MASK_API_SERVER) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiServerRow);
            } else if ((mask & MessagesController.UPDATE_MASK_GOOGLE_API_KEY) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiKeyGoogleRow);
            } else if ((mask & MessagesController.UPDATE_MASK_GOOGLE_API_SERVER) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiServerGoogleRow);
            } else if ((mask & MessagesController.UPDATE_MASK_CLAUDE_API_KEY) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiKeyClaudeRow);
            } else if ((mask & MessagesController.UPDATE_MASK_CLAUDE_API_SERVER) != 0) {
                if (adapter != null) adapter.notifyItemChanged(apiServerClaudeRow);
            }
        }
    }

    @Override
    public ArrayList<ThemeDescription> getThemeDescriptions(){
        ArrayList<ThemeDescription> themeDescriptions = new ArrayList<>();

        themeDescriptions.add(new ThemeDescription(listView, ThemeDescription.FLAG_CELLBACKGROUNDCOLOR, new Class[]{HeaderCell.class, TextCheckCell.class, TextSettingsCell.class, TextDetailSettingsCell.class}, null, null, null, Theme.key_windowBackgroundWhite));
        themeDescriptions.add(new ThemeDescription(fragmentView, ThemeDescription.FLAG_BACKGROUND, null, null, null, null, Theme.key_windowBackgroundGray));

        themeDescriptions.add(new ThemeDescription(actionBar, ThemeDescription.FLAG_BACKGROUND, null, null, null, null, Theme.key_actionBarDefault));
        themeDescriptions.add(new ThemeDescription(listView, ThemeDescription.FLAG_LISTGLOWCOLOR, null, null, null, null, Theme.key_actionBarDefault));
        themeDescriptions.add(new ThemeDescription(actionBar, ThemeDescription.FLAG_AB_ITEMSCOLOR, null, null, null, null, Theme.key_actionBarDefaultIcon));
        themeDescriptions.add(new ThemeDescription(actionBar, ThemeDescription.FLAG_AB_TITLECOLOR, null, null, null, null, Theme.key_actionBarDefaultTitle));
        themeDescriptions.add(new ThemeDescription(actionBar, ThemeDescription.FLAG_AB_SELECTORCOLOR, null, null, null, null, Theme.key_actionBarDefaultSelector));

        themeDescriptions.add(new ThemeDescription(listView, ThemeDescription.FLAG_SELECTOR, null, null, null, null, Theme.key_listSelector));

        themeDescriptions.add(new ThemeDescription(listView, 0, new Class[]{View.class}, Theme.dividerPaint, null, null, Theme.key_divider));

        themeDescriptions.add(new ThemeDescription(listView, 0, new Class[]{HeaderCell.class}, new String[]{"textView"}, null, null, null, Theme.key_windowBackgroundWhiteBlueHeader));


        themeDescriptions.add(new ThemeDescription(listView, 0, new Class[]{TextDetailSettingsCell.class}, new String[]{"textView"}, null, null, null, Theme.key_windowBackgroundWhiteBlackText));
        themeDescriptions.add(new ThemeDescription(listView, 0, new Class[]{TextDetailSettingsCell.class}, new String[]{"valueTextView"}, null, null, null, Theme.key_windowBackgroundWhiteGrayText2));


        return themeDescriptions;
    }
}
