/*
 * This is the source code of Telegram for Android v. 5.x.x.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Nikolai Kudashov, 2013-2018.
 */

package org.telegram.ui;

import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.ClipData;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.MediaStore;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.URLSpan;
import android.util.Pair;
import android.util.Property;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.HapticFeedbackConstants;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.DecelerateInterpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.zxing.common.detector.MathUtils;

import org.telegram.PhoneFormat.PhoneFormat;
import org.telegram.messenger.AccountInstance;
import org.telegram.messenger.AndroidUtilities;
import org.telegram.messenger.ApplicationLoader;
import org.telegram.messenger.BotWebViewVibrationEffect;
import org.telegram.messenger.BuildVars;
import org.telegram.messenger.ChatMessagesMetadataController;
import org.telegram.messenger.ChatObject;
import org.telegram.messenger.ChatThemeController;
import org.telegram.messenger.ContactsController;
import org.telegram.messenger.DialogObject;
import org.telegram.messenger.DownloadController;
import org.telegram.messenger.Emoji;
import org.telegram.messenger.EmojiData;
import org.telegram.messenger.FileLoader;
import org.telegram.messenger.FileLog;
import org.telegram.messenger.FlagSecureReason;
import org.telegram.messenger.ForwardingMessagesParams;
import org.telegram.messenger.ImageLocation;
import org.telegram.messenger.ImageReceiver;
import org.telegram.messenger.LanguageDetector;
import org.telegram.messenger.LiteMode;
import org.telegram.messenger.LocaleController;
import org.telegram.messenger.MediaController;
import org.telegram.messenger.MediaDataController;
import org.telegram.messenger.MessageObject;
import org.telegram.messenger.MessagesController;
import org.telegram.messenger.MessagesStorage;
import org.telegram.messenger.NotificationCenter;
import org.telegram.messenger.NotificationsController;
import org.telegram.messenger.R;
import org.telegram.messenger.SecretChatHelper;
import org.telegram.messenger.SendMessagesHelper;
import org.telegram.messenger.SharedConfig;
import org.telegram.messenger.TranslateController;
import org.telegram.messenger.UserConfig;
import org.telegram.messenger.UserObject;
import org.telegram.messenger.Utilities;
import org.telegram.messenger.VideoEditedInfo;
import org.telegram.messenger.browser.Browser;
import org.telegram.messenger.support.LongSparseIntArray;
import org.telegram.messenger.utils.PhotoUtilities;
import org.telegram.messenger.voip.VoIPService;
import org.telegram.tgnet.ConnectionsManager;
import org.telegram.tgnet.TLObject;
import org.telegram.tgnet.TLRPC;
import org.telegram.ui.ActionBar.ActionBar;
import org.telegram.ui.ActionBar.ActionBarLayout;
import org.telegram.ui.ActionBar.ActionBarMenu;
import org.telegram.ui.ActionBar.ActionBarMenuItem;
import org.telegram.ui.ActionBar.ActionBarMenuSubItem;
import org.telegram.ui.ActionBar.ActionBarPopupWindow;
import org.telegram.ui.ActionBar.AdjustPanLayoutHelper;
import org.telegram.ui.ActionBar.AlertDialog;
import org.telegram.ui.ActionBar.BackDrawable;
import org.telegram.ui.ActionBar.BaseFragment;
import org.telegram.ui.ActionBar.BottomSheet;
import org.telegram.ui.ActionBar.EmojiThemes;
import org.telegram.ui.ActionBar.INavigationLayout;
import org.telegram.ui.ActionBar.SimpleTextView;
import org.telegram.ui.ActionBar.Theme;
import org.telegram.ui.ActionBar.ThemeDescription;
import org.telegram.ui.Adapters.MessagesSearchAdapter;
import org.telegram.ui.Cells.BotHelpCell;
import org.telegram.ui.Cells.BotSwitchCell;
import org.telegram.ui.Cells.ChatActionCell;
import org.telegram.ui.Cells.ChatLoadingCell;
import org.telegram.ui.Cells.ChatMessageCell;
import org.telegram.ui.Cells.ChatUnreadCell;
import org.telegram.ui.Cells.CheckBoxCell;
import org.telegram.ui.Cells.ContextLinkCell;
import org.telegram.ui.Cells.DialogCell;
import org.telegram.ui.Cells.MentionCell;
import org.telegram.ui.Cells.StickerCell;
import org.telegram.ui.Cells.TextSelectionHelper;
import org.telegram.ui.Components.AlertsCreator;
import org.telegram.ui.Components.AnimatedEmojiDrawable;
import org.telegram.ui.Components.AnimatedEmojiSpan;
import org.telegram.ui.Components.AnimatedFileDrawable;
import org.telegram.ui.Components.AnimationProperties;
import org.telegram.ui.Components.AttachBotIntroTopView;
import org.telegram.ui.Components.AudioPlayerAlert;
import org.telegram.ui.Components.AutoDeletePopupWrapper;
import org.telegram.ui.Components.BackButtonMenu;
import org.telegram.ui.Components.BackupImageView;
import org.telegram.ui.Components.BlurBehindDrawable;
import org.telegram.ui.Components.BluredView;
import org.telegram.ui.Components.BlurredFrameLayout;
import org.telegram.ui.Components.BotCommandsMenuView;
import org.telegram.ui.Components.BotWebViewSheet;
import org.telegram.ui.Components.Bulletin;
import org.telegram.ui.Components.BulletinFactory;
import org.telegram.ui.Components.ChatActivityEnterTopView;
import org.telegram.ui.Components.ChatActivityEnterView;
import org.telegram.ui.Components.ChatActivityInterface;
import org.telegram.ui.Components.ChatAttachAlert;
import org.telegram.ui.Components.ChatAttachAlertDocumentLayout;
import org.telegram.ui.Components.ChatAvatarContainer;
import org.telegram.ui.Components.ChatBigEmptyView;
import org.telegram.ui.Components.ChatGreetingsView;
import org.telegram.ui.Components.ChatNotificationsPopupWrapper;
import org.telegram.ui.Components.ChatScrimPopupContainerLayout;
import org.telegram.ui.Components.ChatThemeBottomSheet;
import org.telegram.ui.Components.ChecksHintView;
import org.telegram.ui.Components.CircularProgressDrawable;
import org.telegram.ui.Components.ClippingImageView;
import org.telegram.ui.Components.CombinedDrawable;
import org.telegram.ui.Components.CounterView;
import org.telegram.ui.Components.CrossfadeDrawable;
import org.telegram.ui.Components.CubicBezierInterpolator;
import org.telegram.ui.Components.EditTextBoldCursor;
import org.telegram.ui.Components.EditTextCaption;
import org.telegram.ui.Components.EmbedBottomSheet;
import org.telegram.ui.Components.EmojiPacksAlert;
import org.telegram.ui.Components.EmojiView;
import org.telegram.ui.Components.ExtendedGridLayoutManager;
import org.telegram.ui.Components.FireworksOverlay;
import org.telegram.ui.Components.FloatingDebug.FloatingDebugController;
import org.telegram.ui.Components.FloatingDebug.FloatingDebugProvider;
import org.telegram.ui.Components.Forum.ForumUtilities;
import org.telegram.ui.Components.ForwardingPreviewView;
import org.telegram.ui.Components.FragmentContextView;
import org.telegram.ui.Components.GigagroupConvertAlert;
import org.telegram.ui.Components.HideViewAfterAnimation;
import org.telegram.ui.Components.HintView;
import org.telegram.ui.Components.ImageUpdater;
import org.telegram.ui.Components.ImportingAlert;
import org.telegram.ui.Components.InstantCameraView;
import org.telegram.ui.Components.InviteMembersBottomSheet;
import org.telegram.ui.Components.JoinGroupAlert;
import org.telegram.ui.Components.LayoutHelper;
import org.telegram.ui.Components.LinkSpanDrawable;
import org.telegram.ui.Components.MentionsContainerView;
import org.telegram.ui.Components.MessageBackgroundDrawable;
import org.telegram.ui.Components.MessageContainsEmojiButton;
import org.telegram.ui.Components.MotionBackgroundDrawable;
import org.telegram.ui.Components.NumberTextView;
import org.telegram.ui.Components.PhonebookShareAlert;
import org.telegram.ui.Components.PinnedLineView;
import org.telegram.ui.Components.PipRoundVideoView;
import org.telegram.ui.Components.PollVotesAlert;
import org.telegram.ui.Components.PopupSwipeBackLayout;
import org.telegram.ui.Components.Premium.GiftPremiumBottomSheet;
import org.telegram.ui.Components.Premium.PremiumFeatureBottomSheet;
import org.telegram.ui.Components.Premium.PremiumPreviewBottomSheet;
import org.telegram.ui.Components.RLottieDrawable;
import org.telegram.ui.Components.RadialProgressView;
import org.telegram.ui.Components.ReactedHeaderView;
import org.telegram.ui.Components.ReactedUsersListView;
import org.telegram.ui.Components.ReactionTabHolderView;
import org.telegram.ui.Components.Reactions.ChatSelectionReactionMenuOverlay;
import org.telegram.ui.Components.Reactions.ReactionsEffectOverlay;
import org.telegram.ui.Components.Reactions.ReactionsLayoutInBubble;
import org.telegram.ui.Components.ReactionsContainerLayout;
import org.telegram.ui.Components.RecyclerAnimationScrollHelper;
import org.telegram.ui.Components.RecyclerListView;
import org.telegram.ui.Components.ReportAlert;
import org.telegram.ui.Components.SearchCounterView;
import org.telegram.ui.Components.ShareAlert;
import org.telegram.ui.Components.SharedMediaLayout;
import org.telegram.ui.Components.SizeNotifierFrameLayout;
import org.telegram.ui.Components.StickersAlert;
import org.telegram.ui.Components.SuggestEmojiView;
import org.telegram.ui.Components.TextSelectionHint;
import org.telegram.ui.Components.TextStyleSpan;
import org.telegram.ui.Components.ThemeEditorView;
import org.telegram.ui.Components.TranscribeButton;
import org.telegram.ui.Components.TranslateAlert2;
import org.telegram.ui.Components.TranslateButton;
import org.telegram.ui.Components.TrendingStickersAlert;
import org.telegram.ui.Components.TypefaceSpan;
import org.telegram.ui.Components.URLSpanBotCommand;
import org.telegram.ui.Components.URLSpanMono;
import org.telegram.ui.Components.URLSpanNoUnderline;
import org.telegram.ui.Components.URLSpanReplacement;
import org.telegram.ui.Components.URLSpanUserMention;
import org.telegram.ui.Components.UndoView;
import org.telegram.ui.Components.UnreadCounterTextView;
import org.telegram.ui.Components.ViewHelper;
import org.telegram.ui.Components.spoilers.SpoilerEffect;
import org.telegram.ui.Components.voip.VoIPHelper;
import org.telegram.ui.Delegates.ChatActivityMemberRequestsDelegate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.graphics.ColorUtils;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import androidx.exifinterface.media.ExifInterface;
import androidx.recyclerview.widget.ChatListItemAnimator;
import androidx.recyclerview.widget.GridLayoutManagerFixed;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScrollerCustom;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import io.noties.markwon.core.CorePlugin;

//聊天页面
@SuppressWarnings("unchecked")
public class ChatActivity extends BaseFragment implements NotificationCenter.NotificationCenterDelegate, DialogsActivity.DialogsActivityDelegate, LocationActivity.LocationActivityDelegate, ChatAttachAlertDocumentLayout.DocumentSelectActivityDelegate, ChatActivityInterface, FloatingDebugProvider {
    private final static boolean PULL_DOWN_BACK_FRAGMENT = false;
    private final static boolean DISABLE_PROGRESS_VIEW = true;
    private final static int SKELETON_DISAPPEAR_MS = 200;

    private static int SKELETON_LIGHT_OVERLAY_ALPHA = 22;
    private static float SKELETON_SATURATION = 1.4f;

    public final static int DEBUG_SHARE_ALERT_MODE_NORMAL = 0,
            DEBUG_SHARE_ALERT_MODE_LESS = 1,
            DEBUG_SHARE_ALERT_MODE_MORE = 2;

    public int shareAlertDebugMode = DEBUG_SHARE_ALERT_MODE_NORMAL;
    public boolean shareAlertDebugTopicsSlowMotion;

    public boolean justCreatedTopic = false;
    public boolean justCreatedChat = false;
    protected TLRPC.Chat currentChat;
    protected TLRPC.User currentUser;
    protected TLRPC.EncryptedChat currentEncryptedChat;
    private boolean userBlocked;

    private long chatInviterId;

    private ArrayList<ChatMessageCell> chatMessageCellsCache = new ArrayList<>();

    private HashMap<MessageObject, Boolean> alreadyPlayedStickers = new HashMap<>();

    private Dialog closeChatDialog;
    private boolean showCloseChatDialogLater;
    private FrameLayout progressView;
    private View progressView2;
    private FrameLayout bottomOverlay;
    protected ChatActivityEnterView chatActivityEnterView;//底部输入框
    private ChatActivityEnterTopView chatActivityEnterTopView;//输入框上方view
    private int chatActivityEnterViewAnimateFromTop;
    private boolean chatActivityEnterViewAnimateBeforeSending;
    private ActionBarMenuItem.Item timeItem2;
    private ActionBarMenu.LazyItem attachItem;
    private ActionBarMenuItem headerItem;
    private ActionBarMenu.LazyItem editTextItem;
    private ActionBarMenuItem searchItem;
    private ActionBarMenuItem.Item translateItem;
    private ActionBarMenuItem searchIconItem;
    private ActionBarMenu.LazyItem audioCallIconItem;
    private boolean searchItemVisible;
    private ActionBarMenu.LazyItem contextClearIconItem;
    private ActionBarMenu.LazyItem undoContextClearIconItem;
    private RadialProgressView progressBar;
    private ActionBarMenuItem.Item addContactItem;
    private ActionBarMenuItem.Item clearHistoryItem;
    private ActionBarMenuItem.Item changeUserAiParameters;
    private ActionBarMenuItem.Item viewAsTopics;
    private ActionBarMenuItem.Item closeTopicItem;
    private ActionBarMenuItem.Item openForumItem;
    private ClippingImageView animatingImageView;
    private RecyclerListView chatListView;
    private ChatListItemAnimator chatListItemAnimator;
    private GridLayoutManagerFixed chatLayoutManager;
    private ChatActivityAdapter chatAdapter;
    private UnreadCounterTextView bottomOverlayChatText;
    private ImageView bottomOverlayImage;
    private RadialProgressView bottomOverlayProgress;
    private AnimatorSet bottomOverlayAnimation;
    private boolean bottomOverlayChatWaitsReply;
    private BlurredFrameLayout bottomOverlayChat;
    private BlurredFrameLayout bottomMessagesActionContainer;//底部提及、转发按钮布局
    @Nullable
    private TextView forwardButton;
    @Nullable
    private TextView replyButton;
    @Nullable
    private TextView shareButton;
    @Nullable
    private TextView copyButton;
    @Nullable
    private FrameLayout emptyViewContainer;
    private ChatGreetingsView greetingsViewContainer;
    public ChatActivityFragmentView contentView;
    private ChatBigEmptyView bigEmptyView;
    private ArrayList<View> actionModeViews = new ArrayList<>();
    private ChatAvatarContainer avatarContainer;
    private TextView bottomOverlayText;
    private NumberTextView selectedMessagesCountTextView;
    private RecyclerListView.OnItemClickListener mentionsOnItemClickListener;
    private SuggestEmojiView suggestEmojiPanel;
    private ActionBarMenuItem.Item muteItem;
    private ActionBarMenuItem.Item muteItemGap;
    private ChatNotificationsPopupWrapper chatNotificationsPopupWrapper;
    private float pagedownButtonEnterProgress;
    private float mentionsButtonEnterProgress;
    private float reactionsMentionButtonEnterProgress;
    private FrameLayout pagedownButton;//最下面按钮
    private ImageView pagedownButtonImage;
    private ImageView pagedownButtonArrow;
    private ImageView pagedownButtonLoading;
    private CircularProgressDrawable pagedownButtonLoadingDrawable;
    private boolean pagedownButtonShowedByScroll;
    private CounterView pagedownButtonCounter;
    private FrameLayout mentiondownButton;
    private SimpleTextView mentiondownButtonCounter;
    private ImageView mentiondownButtonImage;
    private Bulletin messageSeenPrivacyBulletin;

    private int reactionsMentionCount;
    private FrameLayout reactionsMentiondownButton;
    private CounterView reactionsMentiondownButtonCounter;
    private ImageView reactionsMentiondownButtonImage;

    private BackupImageView replyImageView;
    private SimpleTextView replyNameTextView;
    private SimpleTextView replyObjectTextView;
    private SimpleTextView replyObjectHintTextView;
    private boolean showTapForForwardingOptionsHit;
    private Runnable tapForForwardingOptionsHitRunnable;
    private ImageView replyIconImageView;
    private ImageView replyCloseImageView;//提及关闭按钮
    public MentionsContainerView mentionContainer;
    private AnimatorSet mentionListAnimation;
    public ChatAttachAlert chatAttachAlert;
    @Nullable
    private BlurredFrameLayout topChatPanelView;
    private AnimatorSet reportSpamViewAnimator;
    @Nullable
    private TextView addToContactsButton;
    private boolean addToContactsButtonArchive;
    @Nullable
    private TextView reportSpamButton;
    @Nullable
    private TextView restartTopicButton;
    @Nullable
    private TranslateButton translateButton;
    @Nullable
    private View topViewSeparator1, topViewSeparator2, topViewSeparator3;
    @Nullable
    private LinkSpanDrawable.LinksTextView emojiStatusSpamHint;
    @Nullable
    private ImageView closeReportSpam;
    private TextView chatWithAdminTextView;
    private FragmentContextView fragmentContextView;
    private FragmentContextView fragmentLocationContextView;
    private View replyLineView;
    private TextView emptyView;
    private HintView gifHintTextView;
    private HintView emojiHintTextView;
    private HintView mediaBanTooltip;
    private HintView searchAsListHint;
    private HintView scheduledOrNoSoundHint;
    private boolean searchAsListHintShown;
    private HintView fwdRestrictedTopHint;
    private HintView fwdRestrictedBottomHint;
    private HintView slowModeHint;
    private HintView pollHintView;
    private HintView timerHintView;
    private ChatMessageCell pollHintCell;
    private int pollHintX;
    private int pollHintY;
    private HintView voiceHintTextView;
    private HintView noSoundHintView;
    private HintView forwardHintView;
    private ChecksHintView checksHintView;
    private View emojiButtonRed;
    private BlurredFrameLayout pinnedMessageView;
    private BluredView blurredView;
    private PinnedLineView pinnedLineView;
    private boolean setPinnedTextTranslationX;
    private AnimatorSet pinnedMessageViewAnimator;
    private BackupImageView[] pinnedMessageImageView = new BackupImageView[2];
    private TrackingWidthSimpleTextView[] pinnedNameTextView = new TrackingWidthSimpleTextView[2];
    private SimpleTextView[] pinnedMessageTextView = new SimpleTextView[2];
    private PinnedMessageButton[] pinnedMessageButton = new PinnedMessageButton[2];
    private NumberTextView pinnedCounterTextView;
    private int pinnedCounterTextViewX;
    private AnimatorSet[] pinnedNextAnimation = new AnimatorSet[2];
    private boolean pinnedMessageButtonShown = false;
    private ImageView closePinned;
    private RadialProgressView pinnedProgress;
    private ImageView pinnedListButton;
    private AnimatorSet pinnedListAnimator;
    @Nullable
    private FrameLayout alertView;
    private Runnable hideAlertViewRunnable;
    private TextView alertNameTextView;
    private TextView alertTextView;
    private AnimatorSet alertViewAnimator;
    private final int searchContainerHeight = 51;
    private BlurredFrameLayout searchContainer;
    private View searchAsListTogglerView;
    private ImageView searchCalendarButton;
    private ImageView searchUserButton;
    private ImageView searchUpButton;
    private ImageView searchDownButton;
    private SearchCounterView searchCountText;
    private ChatActionCell floatingDateView;
    private ChatActionCell infoTopView;
    private int hideDateDelay = 500;
    private InstantCameraView instantCameraView;
    private View overlayView;
    private boolean currentFloatingDateOnScreen;
    private boolean currentFloatingTopIsNotMessage;
    private AnimatorSet floatingDateAnimation;
    private boolean scrollingFloatingDate;
    private boolean scrollingChatListView;
    private boolean checkTextureViewPosition;
    private boolean searchingForUser;
    private TLRPC.User searchingUserMessages;
    private TLRPC.Chat searchingChatMessages;
    private UndoView undoView;
    private UndoView topUndoView;
    private Bulletin pinBulletin;
    private boolean showPinBulletin;
    private int pinBullerinTag;
    protected boolean openKeyboardOnAttachMenuClose;
    private FlagSecureReason flagSecure;
    private boolean isFullyVisible;

    private MessageObject hintMessageObject;
    private int hintMessageType;

    private RecyclerListView messagesSearchListView;
    private MessagesSearchAdapter messagesSearchAdapter;
    private AnimatorSet messagesSearchListViewAnimation;

    public static final int MODE_SCHEDULED = 1;
    public static final int MODE_PINNED = 2;

    private int chatMode;
    private int scheduledMessagesCount = -1;

    private int reportType = -1;

    private MessageObject threadMessageObject;
    private MessageObject topicStarterMessageObject;
    private boolean threadMessageVisible = true;
    private ArrayList<MessageObject> threadMessageObjects;
    private MessageObject replyMessageHeaderObject;
    private TLRPC.TL_forumTopic forumTopic;
    private int threadMessageId;
    private int replyOriginalMessageId;
    private TLRPC.Chat replyOriginalChat;
    private boolean isComments;
    public boolean isTopic;
    private boolean threadMessageAdded;
    private boolean scrollToThreadMessage;
    private int threadMaxInboxReadId;
    private int threadMaxOutboxReadId;
    private int replyMaxReadId;
    private Runnable delayedReadRunnable;
    private SparseArray<MessageObject> pendingSendMessagesDict = new SparseArray<>();
    private ArrayList<MessageObject> pendingSendMessages = new ArrayList<>();
    private int threadUnreadMessagesCount;

    public ArrayList<MessageObject> animatingMessageObjects = new ArrayList<>();
    private HashMap<TLRPC.Document, Integer> animatingDocuments = new HashMap<>();
    private MessageObject needAnimateToMessage;

    private int scrollToPositionOnRecreate = -1;
    private int scrollToOffsetOnRecreate = 0;

    private ArrayList<MessageObject> pollsToCheck = new ArrayList<>(10);

    private int editTextStart;
    private int editTextEnd;

    private Runnable checkPaddingsRunnable;

    private boolean wasManualScroll;
    private boolean fixPaddingsInLayout;
    private boolean globalIgnoreLayout;

    private int topViewWasVisible;

    private ArrayList<Integer> pinnedMessageIds = new ArrayList<>();
    private HashMap<Integer, MessageObject> pinnedMessageObjects = new HashMap<>();
    private SparseArray<Boolean> loadingPinnedMessages = new SparseArray<>();
    private int currentPinnedMessageId;
    private int[] currentPinnedMessageIndex = new int[1];
    private int forceNextPinnedMessageId;
    private boolean forceScrollToFirst;
    private int loadedPinnedMessagesCount;
    private int totalPinnedMessagesCount;
    private boolean loadingPinnedMessagesList;
    private boolean pinnedEndReached;

    private ValueAnimator pagedownButtonAnimation;
    private ValueAnimator mentiondownButtonAnimation;
    private ValueAnimator reactionsMentionButtonAnimation;
    private AnimatorSet replyButtonAnimation;
    private AnimatorSet editButtonAnimation;
    private AnimatorSet forwardButtonAnimation;

    private static int lastStableId = 10;

    private boolean openSearchKeyboard;

    private boolean waitingForReplyMessageLoad;

    private boolean ignoreAttachOnPause;

    private boolean allowStickersPanel;
    private boolean allowContextBotPanel;
    private boolean allowContextBotPanelSecond = true;
    private AnimatorSet runningAnimation;
    private int runningAnimationIndex = -1;

    private MessageObject selectedObjectToEditCaption;
    private MessageObject selectedObject;
    private MessageObject.GroupedMessages selectedObjectGroup;
    private ForwardingMessagesParams forwardingMessages;
    private CharSequence formwardingNameText;
    private MessageObject forwardingMessage;
    private MessageObject.GroupedMessages forwardingMessageGroup;
    private MessageObject replyingMessageObject;
    private int editingMessageObjectReqId;
    private MessageObject editingMessageObject;
    private boolean paused = true;
    private boolean pausedOnLastMessage;
    private boolean wasPaused;
    boolean firstOpen = true;
    private int replyImageSize;
    private int replyImageCacheType;
    private TLRPC.PhotoSize replyImageLocation;
    private TLRPC.PhotoSize replyImageThumbLocation;
    private TLObject replyImageLocationObject;
    private boolean replyImageHasMediaSpoiler;
    private int pinnedImageSize;
    private int pinnedImageCacheType;
    private boolean pinnedImageHasBlur;
    private TLRPC.PhotoSize pinnedImageLocation;
    private TLRPC.PhotoSize pinnedImageThumbLocation;
    private TLObject pinnedImageLocationObject;
    private int linkSearchRequestId;
    private TLRPC.WebPage foundWebPage;
    private ArrayList<CharSequence> foundUrls;
    private String pendingLinkSearchString;
    private Runnable pendingWebPageTimeoutRunnable;
    private Runnable waitingForCharaterEnterRunnable;
    private Runnable onChatMessagesLoaded;

    private TLRPC.ChatInvite chatInvite;
    private Runnable chatInviteRunnable;

    private boolean clearingHistory;

    public boolean openAnimationEnded;
    public boolean fragmentOpened;
    private long openAnimationStartTime;

    private boolean scrollToTopOnResume;
    private boolean forceScrollToTop;
    private boolean scrollToTopUnReadOnResume;
    private long dialog_id;
    private Long dialog_id_Long;
    private int lastLoadIndex = 1;
    private SparseArray<MessageObject>[] selectedMessagesIds = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private SparseArray<MessageObject>[] selectedMessagesCanCopyIds = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private SparseArray<MessageObject>[] selectedMessagesCanStarIds = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private boolean hasUnfavedSelected;
    private int cantDeleteMessagesCount;
    private int cantForwardMessagesCount;
    private int canForwardMessagesCount;
    private int canEditMessagesCount;
    private int cantSaveMessagesCount;
    private int canSaveMusicCount;
    private int canSaveDocumentsCount;
    private ArrayList<Integer> waitingForLoad = new ArrayList<>();
    private boolean needRemovePreviousSameChatActivity = true;

    private int newUnreadMessageCount;
    private int prevSetUnreadCount = Integer.MIN_VALUE;
    private int newMentionsCount;
    private boolean hasAllMentionsLocal;

    private ArrayList<ChatMessageCell> animateSendingViews = new ArrayList<>();

    private SparseArray<MessageObject>[] messagesDict = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private SparseArray<MessageObject> repliesMessagesDict = new SparseArray<>();
    private SparseArray<ArrayList<Integer>> replyMessageOwners = new SparseArray<>();
    private HashMap<String, ArrayList<MessageObject>> messagesByDays = new HashMap<>();
    public ArrayList<MessageObject> messages = new ArrayList<>();
    private SparseArray<MessageObject> waitingForReplies = new SparseArray<>();
    private LongSparseArray<ArrayList<MessageObject>> polls = new LongSparseArray<>();
    private LongSparseArray<MessageObject.GroupedMessages> groupedMessagesMap = new LongSparseArray<>();
    private int[] maxMessageId = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    private int[] minMessageId = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] maxDate = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] minDate = new int[2];
    private boolean[] endReached = new boolean[2];
    private boolean[] cacheEndReached = new boolean[2];
    private boolean[] forwardEndReached = new boolean[]{true, true};
    private boolean hideForwardEndReached;
    private boolean loading;
    private boolean firstLoading = true;
    private boolean chatWasReset;
    private boolean firstUnreadSent;
    private int loadsCount;
    private int last_message_id = 0;
    private long mergeDialogId;
    private int lastMessagesCount;

    private long startMessageAppearTransitionMs;
    private List<MessageSkeleton> messageSkeletons = new ArrayList<>();
    private int lastSkeletonCount;
    private int lastSkeletonMessageCount;
    private Paint skeletonPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Paint skeletonServicePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private ColorMatrix skeletonColorMatrix = new ColorMatrix();
    private Theme.MessageDrawable.PathDrawParams skeletonBackgroundCacheParams = new Theme.MessageDrawable.PathDrawParams();
    private Theme.MessageDrawable skeletonBackgroundDrawable = new Theme.MessageDrawable(Theme.MessageDrawable.TYPE_TEXT, false, false, this::getThemedColor);
    private long skeletonLastUpdateTime;
    private int skeletonGradientWidth;
    private int skeletonTotalTranslation;
    private Matrix skeletonMatrix = new Matrix();
    private LinearGradient skeletonGradient;
    private int skeletonColor0;
    private int skeletonColor1;

    private Paint skeletonOutlinePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Matrix skeletonOutlineMatrix = new Matrix();
    private LinearGradient skeletonOutlineGradient;
    private boolean chatListViewAttached;

    {
        skeletonOutlinePaint.setStyle(Paint.Style.STROKE);
        skeletonOutlinePaint.setStrokeWidth(AndroidUtilities.dp(1));
    }

    private String inlineQueryForInput;
    private boolean premiumInvoiceBot;
    private boolean showScrollToMessageError;
    private int startLoadFromMessageId;
    private int startLoadFromDate;
    private int startLoadFromMessageIdSaved;
    private int startLoadFromMessageOffset = Integer.MAX_VALUE;
    private int startFromVideoTimestamp = -1;
    private int startFromVideoMessageId;
    private boolean needSelectFromMessageId;
    private int returnToMessageId;
    private int returnToLoadIndex;
    private int createUnreadMessageAfterId;
    private boolean createUnreadMessageAfterIdLoading;
    private boolean loadingFromOldPosition;
    private float alertViewEnterProgress;

    private boolean first = true;
    private int first_unread_id;
    private boolean loadingForward;
    private MessageObject unreadMessageObject;
    private MessageObject scrollToMessage;
    public int highlightMessageId = Integer.MAX_VALUE;
    private int scrollToMessagePosition = -10000;
    private Runnable unselectRunnable;

    private String currentPicturePath;

    private ChatObject.Call groupCall;
    private boolean lastCallCheckFromServer;
    private boolean createGroupCall;
    protected TLRPC.ChatFull chatInfo;
    protected TLRPC.UserFull userInfo;

    private LongSparseArray<TLRPC.BotInfo> botInfo = new LongSparseArray<>();
    private String botUser;
    private long inlineReturn;
    private String voiceChatHash;
    private boolean livestream;
    private String attachMenuBotToOpen;
    private String attachMenuBotStartCommand;
    private MessageObject botButtons;
    private MessageObject botReplyButtons;
    private int botsCount;
    private boolean hasBotsCommands;
    private boolean hasBotWebView;
    private long chatEnterTime;
    private long chatLeaveTime;

    private boolean locationAlertShown;

    private String startVideoEdit;

    private FrameLayout videoPlayerContainer;
    private ChatMessageCell drawLaterRoundProgressCell;
    private AspectRatioFrameLayout aspectRatioFrameLayout;
    private TextureView videoTextureView;
    private boolean scrollToVideo;
    private Path aspectPath;
    private Paint aspectPaint;
    private Runnable destroyTextureViewRunnable = () -> {
        destroyTextureView();
    };

    private Paint scrimPaint;
    private Paint actionBarBackgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private float scrimPaintAlpha = 0f;
    private View scrimView;
    private float scrimViewAlpha = 1f;
    private String scrimViewReaction;
    private int popupAnimationIndex = -1;
    private AnimatorSet scrimAnimatorSet;
    public ActionBarPopupWindow scrimPopupWindow;
    private boolean scrimPopupWindowHideDimOnDismiss = true;
    private int scrimPopupX, scrimPopupY;
    private ActionBarMenuSubItem[] scrimPopupWindowItems;
    private ActionBarMenuSubItem menuDeleteItem;
    private Runnable updateDeleteItemRunnable = new Runnable() {
        @Override
        public void run() {
            if (selectedObject == null || menuDeleteItem == null) {
                return;
            }
            int remaining = Math.max(0, selectedObject.messageOwner.ttl_period - (getConnectionsManager().getCurrentTime() - selectedObject.messageOwner.date));
            String ramainingStr;
            if (remaining < 24 * 60 * 60) {
                ramainingStr = AndroidUtilities.formatDuration(remaining, false);
            } else {
                ramainingStr = LocaleController.formatPluralString("Days", Math.round(remaining / (24 * 60 * 60.0f)));
            }
            menuDeleteItem.setSubtext(LocaleController.formatString("AutoDeleteIn", R.string.AutoDeleteIn, ramainingStr));
            AndroidUtilities.runOnUIThread(updateDeleteItemRunnable, 1000);
        }
    };

    private ChatActivityDelegate chatActivityDelegate;
    private RecyclerAnimationScrollHelper chatScrollHelper;

    private int postponedScrollMinMessageId;
    private int postponedScrollToLastMessageQueryIndex;
    private int postponedScrollMessageId;
    private boolean postponedScrollIsCanceled;
    private static ArrayList<ChatActivityTextSelectionHelper> textSelectionHelpersCache;
    private ChatActivityTextSelectionHelper textSelectionHelper;//文本选中工具类
    private ChatMessageCell slidingView;
    private boolean maybeStartTrackingSlidingView;
    private boolean startedTrackingSlidingView;

    private boolean canShowPagedownButton;
    private TextSelectionHint textSelectionHint;//文本选中提示
    private boolean textSelectionHintWasShowed;
    private float lastTouchY;

    private ChatMessageCell dummyMessageCell;
    private FireworksOverlay fireworksOverlay;

    private boolean swipeBackEnabled = true;

    public static Pattern publicMsgUrlPattern;
    public static Pattern voiceChatUrlPattern;
    public static Pattern privateMsgUrlPattern;
    private boolean waitingForSendingMessageLoad;
    private ValueAnimator changeBoundAnimator;
    private Animator messageEditTextAnimator;

    private int distanceToPeer;

    private boolean openImport;

    private float chatListViewPaddingTop;
    private float chatListViewPaddingTopOnlyTopViews;
    private int chatListViewPaddingVisibleOffset;

    private int contentPaddingTop;
    private float contentPanTranslation;
    private float floatingDateViewOffset;
    private float topChatPanelViewOffset;
    private float pinnedMessageEnterOffset;
    private float topViewOffset;
    private TLRPC.Document preloadedGreetingsSticker;
    private boolean forceHistoryEmpty;
    private float bottomPanelTranslationY;
    private float bottomPanelTranslationYReverse;
    private boolean invalidateChatListViewTopPadding;
    private long activityResumeTime;

    private int transitionAnimationIndex;
    private int transitionAnimationGlobalIndex;
    private int scrollAnimationIndex;
    private int scrollCallbackAnimationIndex;

    public boolean allowExpandPreviewByClick;
    private boolean showSearchAsIcon;
    private boolean showAudioCallAsIcon;
    public MessageEnterTransitionContainer messageEnterTransitionContainer;
    private float pullingDownOffset, pullingBottomOffset;
    private ChatPullingDownDrawable pullingDownDrawable;
    private Animator pullingDownBackAnimator;
    private boolean fromPullingDownTransition;
    private boolean toPullingDownTransition;
    private ChatActivity pullingDownAnimateToActivity;
    private float pullingDownAnimateProgress;
    private AnimatorSet fragmentTransition;
    private ChatActivity backToPreviousFragment;
    private Runnable fragmentTransitionRunnable = new Runnable() {
        @Override
        public void run() {
            if (fragmentTransition != null && !fragmentTransition.isRunning()) {
                fragmentTransition.start();
            }
        }
    };

    private ChatSelectionReactionMenuOverlay selectionReactionsOverlay;

    private boolean isPauseOnThemePreview;
    private ChatThemeBottomSheet chatThemeBottomSheet;
    public ThemeDelegate themeDelegate;
    private ChatActivityMemberRequestsDelegate pendingRequestsDelegate;
    private final ChatMessagesMetadataController chatMessagesMetadataController = new ChatMessagesMetadataController(this);
    private TLRPC.TL_channels_sendAsPeers sendAsPeersObj;

    private boolean switchFromTopics;
    private boolean switchingFromTopics;
    private float switchingFromTopicsProgress;

    private final static int OPTION_RETRY = 0;
    private final static int OPTION_DELETE = 1;
    private final static int OPTION_FORWARD = 2;
    private final static int OPTION_COPY = 3;
    private final static int OPTION_SAVE_TO_GALLERY = 4;
    private final static int OPTION_APPLY_LOCALIZATION_OR_THEME = 5;
    private final static int OPTION_SHARE = 6;
    private final static int OPTION_SAVE_TO_GALLERY2 = 7;
    private final static int OPTION_REPLY = 8;
    private final static int OPTION_ADD_TO_STICKERS_OR_MASKS = 9;
    private final static int OPTION_SAVE_TO_DOWNLOADS_OR_MUSIC = 10;
    private final static int OPTION_ADD_TO_GIFS = 11;
    private final static int OPTION_EDIT = 12;
    private final static int OPTION_PIN = 13;
    private final static int OPTION_UNPIN = 14;
    private final static int OPTION_ADD_CONTACT = 15;
    private final static int OPTION_COPY_PHONE_NUMBER = 16;
    private final static int OPTION_CALL = 17;
    private final static int OPTION_CALL_AGAIN = 18;
    private final static int OPTION_RATE_CALL = 19;
    private final static int OPTION_ADD_STICKER_TO_FAVORITES = 20;
    private final static int OPTION_DELETE_STICKER_FROM_FAVORITES = 21;
    private final static int OPTION_COPY_LINK = 22;
    private final static int OPTION_REPORT_CHAT = 23;
    private final static int OPTION_CANCEL_SENDING = 24;
    private final static int OPTION_UNVOTE = 25;
    private final static int OPTION_STOP_POLL_OR_QUIZ = 26;
    private final static int OPTION_VIEW_REPLIES_OR_THREAD = 27;
    private final static int OPTION_STATISTICS = 28;
    private final static int OPTION_TRANSLATE = 29;
    private final static int OPTION_TRANSCRIBE = 30;
    private final static int OPTION_HIDE_SPONSORED_MESSAGE = 31;
    private final static int OPTION_VIEW_IN_TOPIC = 32;
    private final static int OPTION_SHARE_CHAT = 51;
    private final static int OPTION_SEND_NOW = 100;
    private final static int OPTION_EDIT_SCHEDULE_TIME = 102;
    private final static int OPTION_SPEED_PROMO = 103;
    private final static int OPTION_OPEN_PROFILE = 104;

    private final static int[] allowedNotificationsDuringChatListAnimations = new int[]{
            NotificationCenter.messagesRead,
            NotificationCenter.threadMessagesRead,
            NotificationCenter.commentsRead,
            NotificationCenter.messagesReadEncrypted,
            NotificationCenter.messagesReadContent,
            NotificationCenter.didLoadPinnedMessages,
            NotificationCenter.newDraftReceived,
            NotificationCenter.updateMentionsCount,
            NotificationCenter.didUpdateConnectionState,
            //NotificationCenter.updateInterfaces,
            NotificationCenter.updateDefaultSendAsPeer,
            NotificationCenter.closeChats,
            NotificationCenter.chatInfoCantLoad,
            NotificationCenter.userInfoDidLoad,
            NotificationCenter.pinnedInfoDidLoad,
            NotificationCenter.didSetNewWallpapper,
            NotificationCenter.didApplyNewTheme
    };

    private final DialogInterface.OnCancelListener postponedScrollCancelListener = dialog -> {
        postponedScrollIsCanceled = true;
        postponedScrollMessageId = 0;
        nextScrollToMessageId = 0;
        forceNextPinnedMessageId = 0;
        invalidateMessagesVisiblePart();
        showPinnedProgress(false);
    };

    private NotificationCenter.PostponeNotificationCallback postponeNotificationsWhileLoadingCallback = new NotificationCenter.PostponeNotificationCallback() {
        @Override
        public boolean needPostpone(int id, int currentAccount, Object[] args) {
            if (id == NotificationCenter.didReceiveNewMessages) {
                long did = (Long) args[0];
                if (firstLoading && did == dialog_id) {
                    return true;
                }
            }
            return false;
        }
    };
    private int chatEmojiViewPadding;
    private int fixedKeyboardHeight = -1;
    private Runnable cancelFixedPositionRunnable;
    private boolean invalidateMessagesVisiblePart;
    private boolean scrollByTouch;
    int dialogFolderId;
    int dialogFilterId;
    boolean pulled = false;
    private static boolean replacingChatActivity = false;

    private PinchToZoomHelper pinchToZoomHelper;
    public EmojiAnimationsOverlay emojiAnimationsOverlay;
    public float drawingChatLisViewYoffset;
    public int blurredViewTopOffset;
    public int blurredViewBottomOffset;

    private ValueAnimator searchExpandAnimator;
    private float searchExpandProgress;

    private boolean isContextClear = true;

    public void deleteHistory(int dateSelectedStart, int dateSelectedEnd, boolean forAll) {
        chatAdapter.frozenMessages.clear();
        for (int i = 0; i < messages.size(); i++) {
            MessageObject messageObject = messages.get(i);
            if (messageObject.messageOwner.date <= dateSelectedStart || messageObject.messageOwner.date >= dateSelectedEnd) {
                chatAdapter.frozenMessages.add(messageObject);
            }
        }
        if (chatListView != null) {
            chatListView.setEmptyView(null);
        }
        if (chatAdapter.frozenMessages.isEmpty()) {
            showProgressView(true);
        }
        chatAdapter.isFrozen = true;
        chatAdapter.notifyDataSetChanged(true);
        UndoView undoView = getUndoView();
        if (undoView == null) {
            return;
        }

        undoView.showWithAction(dialog_id, UndoView.ACTION_CLEAR_DATES, () -> {
            getMessagesController().deleteMessagesRange(dialog_id, ChatObject.isChannel(currentChat) ? dialog_id : 0, dateSelectedStart, dateSelectedEnd, forAll, () -> {
                chatAdapter.frozenMessages.clear();
                chatAdapter.isFrozen = false;
                chatAdapter.notifyDataSetChanged(true);
                showProgressView(false);
            });
        }, () -> {
            chatAdapter.frozenMessages.clear();
            chatAdapter.isFrozen = false;
            chatAdapter.notifyDataSetChanged(true);
            showProgressView(false);
        });
    }

    public void showHeaderItem(boolean show) {
        if (show) {
            if (chatActivityEnterView.hasText() && TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                if (attachItem != null) {
                    attachItem.setVisibility(View.VISIBLE);
                }
                if (headerItem != null) {
                    headerItem.setVisibility(View.GONE);
                }
            } else {
                if (attachItem != null) {
                    attachItem.setVisibility(View.GONE);
                }
                if (headerItem != null) {
                    headerItem.setVisibility(View.VISIBLE);
                }
            }
        } else {
            if (attachItem != null) {
                attachItem.setVisibility(View.GONE);
            }
            if (headerItem != null) {
                headerItem.setVisibility(View.GONE);
            }
        }

    }

    public int getTopicId() {
        return isTopic ? threadMessageId : 0;
    }

    @Override
    public List<FloatingDebugController.DebugItem> onGetDebugItems() {
        List<FloatingDebugController.DebugItem> items = new ArrayList<>();
        if (ChatObject.isChannel(currentChat)) {
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugShareAlert)));
            String mode;
            switch (shareAlertDebugMode) {
                default:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeNormal);
                    break;
                case DEBUG_SHARE_ALERT_MODE_LESS:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeLess);
                    break;
                case DEBUG_SHARE_ALERT_MODE_MORE:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeMore);
                    break;
            }
            items.add(new FloatingDebugController.DebugItem(LocaleController.formatString(R.string.DebugShareAlertSwitchDialogsMode, mode), () -> {
                shareAlertDebugMode++;
                shareAlertDebugMode %= 3;
            }));

            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugShareAlertTopicsSlowMotion), ()-> shareAlertDebugTopicsSlowMotion = !shareAlertDebugTopicsSlowMotion));
        }
        if (currentUser == null) {
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletons)));
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletonsLightOverlayAlpha), 0, 255, new AnimationProperties.FloatProperty("") {
                @Override
                public void setValue(Object object, float value) {
                    SKELETON_LIGHT_OVERLAY_ALPHA = (int) value;
                }

                @Override
                public Object get(Object object) {
                    return (float) SKELETON_LIGHT_OVERLAY_ALPHA;
                }
            }));
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletonsSaturation), 1f, 10f, new AnimationProperties.FloatProperty("") {
                @Override
                public void setValue(Object object, float value) {
                    SKELETON_SATURATION = value;
                    skeletonColorMatrix.setSaturation(value);
                    skeletonServicePaint.setColorFilter(new ColorMatrixColorFilter(skeletonColorMatrix));
                }

                @Override
                public Object get(Object object) {
                    return SKELETON_SATURATION;
                }
            }));
        }

        return items;
    }

    public boolean allowSendPhotos() {
        if (currentChat != null && !ChatObject.canSendPhoto(currentChat)) {
            return false;
        } else {
            return true;
        }
    }

    private interface ChatActivityDelegate {
        default void openReplyMessage(int mid) {

        }

        default void openSearch(String text) {


        }

        default void onUnpin(boolean all, boolean hide) {

        }

        default void onReport() {

        }
    }

    ForwardingPreviewView forwardingPreviewView;

    private PhotoViewer.PhotoViewerProvider photoViewerProvider = new PhotoViewer.EmptyPhotoViewerProvider() {

        @Override
        public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview) {
            return ChatActivity.this.getPlaceForPhoto(messageObject, fileLocation, needPreview, false);
        }

        @Override
        public boolean validateGroupId(long groupId) {
            MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(groupId);
            return groupedMessages != null && groupedMessages.messages.size() > 1;
        }
    };

    private ArrayList<Object> botContextResults;
    private PhotoViewer.PhotoViewerProvider botContextProvider = new PhotoViewer.EmptyPhotoViewerProvider() {

        @Override
        public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview) {
            if (index < 0 || index >= botContextResults.size() || mentionContainer == null || mentionContainer.getListView() == null) {
                return null;
            }
            int count = mentionContainer.getListView().getChildCount();
            Object result = botContextResults.get(index);

            for (int a = 0; a < count; a++) {
                ImageReceiver imageReceiver = null;
                View view = mentionContainer.getListView().getChildAt(a);
                if (view instanceof ContextLinkCell) {
                    ContextLinkCell cell = (ContextLinkCell) view;
                    if (cell.getResult() == result) {
                        imageReceiver = cell.getPhotoImage();
                    }
                }

                if (imageReceiver != null) {
                    int[] coords = new int[2];
                    view.getLocationInWindow(coords);
                    PhotoViewer.PlaceProviderObject object = new PhotoViewer.PlaceProviderObject();
                    object.viewX = coords[0];
                    object.viewY = coords[1] - (Build.VERSION.SDK_INT >= 21 ? 0 : AndroidUtilities.statusBarHeight);
//                    object.clipTopAddition = (int) (chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4));
                    object.parentView = mentionContainer.getListView();
                    object.imageReceiver = imageReceiver;
                    object.thumb = imageReceiver.getBitmapSafe();
                    object.radius = imageReceiver.getRoundRadius();
                    return object;
                }
            }
            return null;
        }

        @Override
        public void sendButtonPressed(int index, VideoEditedInfo videoEditedInfo, boolean notify, int scheduleDate, boolean forceDocument) {
            if (index < 0 || index >= botContextResults.size()) {
                return;
            }
            sendBotInlineResult((TLRPC.BotInlineResult) botContextResults.get(index), notify, scheduleDate);
        }
    };

    private final static int copy = 10;
    private final static int forward = 11;
    private final static int delete = 12;
    private final static int chat_enc_timer = 13;
    private final static int chat_menu_attach = 14;
    private final static int chat_menu_search = -1;
    private final static int chat_menu_options = -2;
    private final static int chat_menu_edit_text_options = -3;
    private final static int clear_history = 15;
    private final static int delete_chat = 16;
    private final static int share_contact = 17;
    private final static int mute = 18;
    private final static int report = 21;
    private final static int star = 22;
    private final static int edit = 23;
    private final static int add_shortcut = 24;
    private final static int save_to = 25;
    private final static int auto_delete_timer = 26;
    private final static int change_colors = 27;

    private final static int bot_help = 30;
    private final static int bot_settings = 31;
    private final static int call = 32;
    private final static int video_call = 33;

    private final static int attach_photo = 0;
    private final static int attach_gallery = 1;
    private final static int attach_video = 2;

    private final static int text_bold = 50;
    private final static int text_italic = 51;
    private final static int text_mono = 52;
    private final static int text_link = 53;
    private final static int text_regular = 54;
    private final static int text_strike = 55;
    private final static int text_underline = 56;
    private final static int text_spoiler = 57;

    private final static int view_as_topics = 58;

    private final static int search = 40;

    private final static int topic_close = 60;
    private final static int open_forum = 61;

    private final static int translate = 62;

    private final static int share = 81;
    private final static int context_clear = 82;
    private final static int undo_context_clear = 83;
    private final static int change_user_ai_parameters = 84;

    private final static int id_chat_compose_panel = 1000;

    //聊天列表长按触发器
    RecyclerListView.OnItemLongClickListenerExtended onItemLongClickListener = new RecyclerListView.OnItemLongClickListenerExtended() {
        @Override
        public boolean onItemClick(View view, int position, float x, float y) {
            if (textSelectionHelper.isTryingSelect() || textSelectionHelper.isSelectionMode() || inPreviewMode) {
                return false;
            }
            wasManualScroll = true;
            boolean result = true;
            if (!actionBar.isActionModeShowed() && (reportType < 0 || (view instanceof ChatActionCell && (((ChatActionCell) view).getMessageObject().messageOwner.action instanceof TLRPC.TL_messageActionSetMessagesTTL) || ((view instanceof ChatActionCell) && ((ChatActionCell) view).getMessageObject().type == MessageObject.TYPE_SUGGEST_PHOTO)))) {
                //进入长按模式
                result = createMenu(view, false, true, x, y);
            } else {
                boolean outside = false;
                if (view instanceof ChatMessageCell) {
                    outside = !((ChatMessageCell) view).isInsideBackground(x, y);
                }
                //长按选中模式下选择
                processRowSelect(view, outside, x, y);
            }
            if (view instanceof ChatMessageCell) {
                startMultiselect(position);
                result = true;
            }
            return result;
        }
    };

    public RecyclerListView getChatListView() {
        return chatListView;
    }

    private void startMultiselect(int position) {
        int indexOfMessage = position - chatAdapter.messagesStartRow;
        if (indexOfMessage < 0 || indexOfMessage >= messages.size()) {
            return;
        }
        MessageObject messageObject = messages.get(indexOfMessage);
        final boolean unselect = selectedMessagesIds[0].get(messageObject.getId(), null) == null && selectedMessagesIds[1].get(messageObject.getId(), null) == null;
        SparseArray<MessageObject> alreadySelectedMessagesIds = new SparseArray<>();
        for (int i = 0; i < selectedMessagesIds[0].size(); i++) {
            alreadySelectedMessagesIds.put(selectedMessagesIds[0].keyAt(i), selectedMessagesIds[0].valueAt(i));
        }
        for (int i = 0; i < selectedMessagesIds[1].size(); i++) {
            alreadySelectedMessagesIds.put(selectedMessagesIds[1].keyAt(i), selectedMessagesIds[1].valueAt(i));
        }
        chatListView.startMultiselect(position, false, new RecyclerListView.onMultiSelectionChanged() {
            boolean limitReached;
            @Override
            public void onSelectionChanged(int position, boolean selected, float x, float y) {
                int i = position - chatAdapter.messagesStartRow;
                if (unselect) {
                    selected = !selected;
                }
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (selected && (selectedMessagesIds[0].indexOfKey(messageObject.getId()) >= 0 || selectedMessagesIds[1].indexOfKey(messageObject.getId()) >= 0)) {
                        return;
                    }
                    if (!selected && selectedMessagesIds[0].indexOfKey(messageObject.getId()) < 0 && selectedMessagesIds[1].indexOfKey(messageObject.getId()) < 0) {
                        return;
                    }
                    if (messageObject.contentType == 0) {
                        if (selected && selectedMessagesIds[0].size() + selectedMessagesIds[1].size() >= 100) {
                            limitReached = true;
                        } else {
                            limitReached = false;
                        }
                        RecyclerView.ViewHolder holder = chatListView.findViewHolderForAdapterPosition(position);
                        if (holder != null && holder.itemView instanceof ChatMessageCell) {
                            processRowSelect(holder.itemView, false, x, y);
                        } else {
                            addToSelectedMessages(messageObject, false);
                            updateActionModeTitle();
                            updateVisibleRows();
                        }
                    }
                }
            }

            @Override
            public boolean canSelect(int position) {
                int i = position - chatAdapter.messagesStartRow;
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (messageObject.contentType == 0) {
                        if (!unselect && alreadySelectedMessagesIds.get(messageObject.getId(), null) == null) {
                            return true;
                        }
                        if (unselect && alreadySelectedMessagesIds.get(messageObject.getId(), null) != null) {
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public int checkPosition(int position, boolean selectionTop) {
                int i = position - chatAdapter.messagesStartRow;
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (messageObject.contentType == 0 && messageObject.hasValidGroupId()) {
                        MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(messageObject.getGroupId());
                        if (groupedMessages != null) {
                            MessageObject messageObject1 = groupedMessages.messages.get(selectionTop ? 0 : groupedMessages.messages.size() - 1);
                            return chatAdapter.messagesStartRow + messages.indexOf(messageObject1);
                        }
                    }
                }
                return position;
            }

            @Override
            public boolean limitReached() {
                return limitReached;
            }

            @Override
            public void getPaddings(int[] paddings) {
                paddings[0] = (int) chatListViewPaddingTop;
                paddings[1] = blurredViewBottomOffset;
            }

            @Override
            public void scrollBy(int dy) {
                chatListView.scrollBy(0, dy);
            }
        });
    }

    //聊天列表点击回调
    RecyclerListView.OnItemClickListenerExtended onItemClickListener = new RecyclerListView.OnItemClickListenerExtended() {
        @Override
        public void onItemClick(View view, int position, float x, float y) {
            if (inPreviewMode) {
                return;
            }
            wasManualScroll = true;
            if (view instanceof ChatActionCell && ((ChatActionCell) view).getMessageObject().isDateObject) {
                if (BuildVars.IS_CHAT_AIR) return;
                Bundle bundle = new Bundle();
                int date = ((ChatActionCell) view).getMessageObject().messageOwner.date;
                bundle.putLong("dialog_id", dialog_id);
                bundle.putInt("topic_id", getTopicId());
                bundle.putInt("type", CalendarActivity.TYPE_CHAT_ACTIVITY);
                CalendarActivity calendarActivity = new CalendarActivity(bundle, SharedMediaLayout.FILTER_PHOTOS_AND_VIDEOS, date);
                presentFragment(calendarActivity);
                return;
            }
            if (actionBar.isActionModeShowed() || reportType >= 0) {
                boolean outside = false;
                if (view instanceof ChatMessageCell) {
                    if (textSelectionHelper.isSelected(((ChatMessageCell) view).getMessageObject())) {
                        return;
                    }
                    outside = !((ChatMessageCell) view).isInsideBackground(x, y);
                }
                processRowSelect(view, outside, x, y);
                return;
            }
            createMenu(view, true, false, x, y);
        }

        @Override
        public boolean hasDoubleTap(View view, int position) {
            //双击触发点赞表情
            if (BuildVars.IS_CHAT_AIR) return true;
            String reactionStringSetting = getMediaDataController().getDoubleTapReaction();
            TLRPC.TL_availableReaction reaction = getMediaDataController().getReactionsMap().get(reactionStringSetting);
            if (reaction == null && (reactionStringSetting == null || !reactionStringSetting.startsWith("animated_"))) {
                return false;
            }
            boolean available = dialog_id >= 0;
            if (!available && chatInfo != null) {
                available = ChatObject.reactionIsAvailable(chatInfo, reaction == null ? reactionStringSetting : reaction.reaction);
            }
            if (!available || !(view instanceof ChatMessageCell)) {
                return false;
            }
            ChatMessageCell cell = (ChatMessageCell) view;
            return !cell.getMessageObject().isSending() && !cell.getMessageObject().isEditing() && cell.getMessageObject().type != MessageObject.TYPE_PHONE_CALL && !actionBar.isActionModeShowed() && !isSecretChat() && !isInScheduleMode() && !cell.getMessageObject().isSponsored();
        }

        @Override
        public void onDoubleTap(View view, int position, float x, float y) {
            //双击触发点赞表情，都需要
            if (!(view instanceof ChatMessageCell) || getParentActivity() == null || isSecretChat() || isInScheduleMode() || isInPreviewMode()) {
                return;
            }
            ChatMessageCell cell = (ChatMessageCell) view;
            MessageObject primaryMessage = cell.getPrimaryMessageObject();

            if (BuildVars.IS_CHAT_AIR && primaryMessage != null) {
                //执行复制
                AndroidUtilities.addToClipboard(getMessageContent(primaryMessage, 0, false));
                //创造复制成功提示
                createUndoView();
                if (undoView == null) {
                    return;
                }
                //显示复制成功提示
                undoView.showWithAction(0, UndoView.ACTION_MESSAGE_COPIED, null);
                return;
            }

            if (primaryMessage.isSecretMedia()) {
                return;
            }
            ReactionsEffectOverlay.removeCurrent(false);
            String reactionString = getMediaDataController().getDoubleTapReaction();
            if (reactionString.startsWith("animated_")) {
                boolean available = dialog_id >= 0;
                if (!available && chatInfo != null) {
                    available = ChatObject.reactionIsAvailable(chatInfo, reactionString);
                }
                if (!available) {
                    return;
                }
                selectReaction(primaryMessage, null, null, x, y, ReactionsLayoutInBubble.VisibleReaction.fromEmojicon(reactionString), true, false, false);
            } else {
                TLRPC.TL_availableReaction reaction = getMediaDataController().getReactionsMap().get(reactionString);
                if (reaction == null || cell.getMessageObject().isSponsored()) {
                    return;
                }
                boolean available = dialog_id >= 0;
                if (!available && chatInfo != null) {
                    available = ChatObject.reactionIsAvailable(chatInfo, reaction.reaction);
                }
                if (!available) {
                    return;
                }
                selectReaction(primaryMessage, null, null, x, y, ReactionsLayoutInBubble.VisibleReaction.fromEmojicon(reaction), true, false, false);
            }
        }
    };

    //输入文字变动处理类
    private class ChatActivityEnterViewDelegate implements ChatActivityEnterView.ChatActivityEnterViewDelegate {

        int lastSize;
        boolean isEditTextItemVisibilitySuppressed;

        @Override
        public int getContentViewHeight() {
            return contentView.getHeight();
        }

        @Override
        public int measureKeyboardHeight() {
            return contentView.measureKeyboardHeight();
        }

        @Override
        public TLRPC.TL_channels_sendAsPeers getSendAsPeers() {
            return sendAsPeersObj;
        }

        //消息已经发送，更新设置
        @Override
        public void onMessageSend(CharSequence message, boolean notify, int scheduleDate) {
            if (chatListItemAnimator != null) {
                chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                if (chatActivityEnterViewAnimateFromTop != 0) {
                    chatActivityEnterViewAnimateBeforeSending = true;
                }
            }
            //提及内容添加数据库
            if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                mentionContainer.getAdapter().addHashtagsFromMessage(message);
            }
            //定时发送
            if (scheduleDate != 0) {
                if (scheduledMessagesCount == -1) {
                    scheduledMessagesCount = 0;
                }
                if (message != null) {
                    scheduledMessagesCount++;
                }
                if (forwardingMessages != null && !forwardingMessages.messages.isEmpty()) {
                    scheduledMessagesCount += forwardingMessages.messages.size();
                }
                updateScheduledInterface(false);
            }
            //设置转发消息
            if (!TextUtils.isEmpty(message) && forwardingMessages != null && !forwardingMessages.messages.isEmpty()) {
                ArrayList<MessageObject> messagesToForward = new ArrayList<>();
                forwardingMessages.getSelectedMessages(messagesToForward);
                boolean showReplyHint = messagesToForward.size() > 0;
                TLRPC.Peer toPeer = getMessagesController().getPeer(dialog_id);
                for (int i = 0; i < messagesToForward.size(); ++i) {
                    MessageObject msg = messagesToForward.get(i);
                    if (msg != null && msg.messageOwner != null && !MessageObject.peersEqual(msg.messageOwner.peer_id, toPeer)) {
                        showReplyHint = false;
                        break;
                    }
                }

                if (showReplyHint) {
                    checkTopUndoView();
                    if (topUndoView != null) {
                        topUndoView.showWithAction(0, UndoView.ACTION_HINT_SWIPE_TO_REPLY, null, null);
                    }
                }
            }
            //设置引用消息
            if (ChatObject.isForum(currentChat) && !isTopic && replyingMessageObject != null) {
                int topicId = replyingMessageObject.replyToForumTopic != null ? replyingMessageObject.replyToForumTopic.id : MessageObject.getTopicId(replyingMessageObject.messageOwner, true);
                if (topicId != 0) {
                    getMediaDataController().cleanDraft(dialog_id, topicId, false);
                }
            }

            //隐藏输入框上方UI
            hideFieldPanel(notify, scheduleDate, true);
            //发送表情
            if (chatActivityEnterView != null && chatActivityEnterView.getEmojiView() != null) {
                chatActivityEnterView.getEmojiView().onMessageSend();
            }

            if (!getMessagesController().premiumLocked && !getMessagesController().didPressTranscribeButtonEnough() && !getUserConfig().isPremium() && !TextUtils.isEmpty(message) && messages != null) {
                for (int i = 1; i < Math.min(5, messages.size()); ++i) {
                    MessageObject msg = messages.get(i);
                    if (msg != null && !msg.isOutOwner() && (msg.isVoice() || msg.isRoundVideo()) && msg.isContentUnread()) {
                        //关闭转录按钮
                        TranscribeButton.showOffTranscribe(msg);
                    }
                }
            }
        }

        @Override
        public void onEditTextScroll() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        }

        @Override
        public void onContextMenuOpen() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        }

        @Override
        public void onContextMenuClose() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.fireUpdate();
            }
        }

        @Override
        public void onSwitchRecordMode(boolean video) {
            showVoiceHint(false, video);
        }

        @Override
        public void onPreAudioVideoRecord() {
            showVoiceHint(true, false);
        }

        @Override
        public void onUpdateSlowModeButton(View button, boolean show, CharSequence time) {
            showSlowModeHint(button, show, time);
            if (headerItem != null && headerItem.getVisibility() != View.VISIBLE) {
                headerItem.setVisibility(View.VISIBLE);
                if (attachItem != null) {
                    attachItem.setVisibility(View.GONE);
                }
            }
        }

        @Override
        public void onTextSelectionChanged(int start, int end) {
            if (editTextItem == null) {
                return;
            }
            ActionBarMenu menu = actionBar.createMenu();
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.onTextSelectionChanged(start, end);
            }
            if (end - start > 0) {
                if (editTextItem.getTag() == null) {
                    editTextItem.setTag(1);

                    if (editTextItem.getVisibility() != View.VISIBLE) {
                        if (chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && reportType < 0) {
                            editTextItem.setVisibility(View.VISIBLE);
                            checkEditTextItemMenu();
                            headerItem.setVisibility(View.GONE);
                            attachItem.setVisibility(View.GONE);
                        } else {
                            ValueAnimator valueAnimator = ValueAnimator.ofFloat(AndroidUtilities.dp(48), 0);
                            valueAnimator.setDuration(220);
                            valueAnimator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            valueAnimator.addListener(new AnimatorListenerAdapter() {
                                @Override
                                public void onAnimationStart(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(true);
                                    checkEditTextItemMenu();
                                    editTextItem.setVisibility(View.VISIBLE);
                                    menu.translateXItems(AndroidUtilities.dp(48));
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(false);
                                }
                            });
                            valueAnimator.addUpdateListener(animation -> menu.translateXItems((float) animation.getAnimatedValue()));
                            valueAnimator.start();
                        }
                    }
                }
                editTextStart = start;
                editTextEnd = end;
            } else {
                if (editTextItem.getTag() != null) {
                    editTextItem.setTag(null);
                    if (editTextItem.getVisibility() != View.GONE) {
                        if (chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && reportType < 0) {
                            editTextItem.setVisibility(View.GONE);

                            if (chatActivityEnterView.hasText() && TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                                headerItem.setVisibility(View.GONE);
                                attachItem.setVisibility(View.VISIBLE);
                            } else {
                                headerItem.setVisibility(View.VISIBLE);
                                attachItem.setVisibility(View.GONE);
                            }
                        } else {
                            ValueAnimator valueAnimator = ValueAnimator.ofFloat(0, AndroidUtilities.dp(48));
                            valueAnimator.setDuration(220);
                            valueAnimator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            valueAnimator.addListener(new AnimatorListenerAdapter() {
                                @Override
                                public void onAnimationStart(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(true);
                                    isEditTextItemVisibilitySuppressed = true;
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    editTextItem.setVisibility(View.GONE);
                                    menu.translateXItems(0);

                                    actionBar.setMenuOffsetSuppressed(false);
                                    isEditTextItemVisibilitySuppressed = false;
                                }
                            });
                            valueAnimator.addUpdateListener(animation -> menu.translateXItems((float) animation.getAnimatedValue()));
                            valueAnimator.start();
                        }
                    }
                }
            }
        }

        @Override
        public void onTextChanged(final CharSequence text, boolean bigChange) {
            MediaController.getInstance().setInputFieldHasText(!TextUtils.isEmpty(text) || chatActivityEnterView.isEditingMessage());

            if (BuildVars.IS_CHAT_AIR) return;
            if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                mentionContainer.getAdapter().searchUsernameOrHashtag(text, chatActivityEnterView.getCursorPosition(), messages, false, false);
            }
            if (waitingForCharaterEnterRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(waitingForCharaterEnterRunnable);
                waitingForCharaterEnterRunnable = null;
            }
            if ((currentChat == null || ChatObject.canSendEmbed(currentChat)) && chatActivityEnterView.isMessageWebPageSearchEnabled() && (!chatActivityEnterView.isEditingMessage() || !chatActivityEnterView.isEditingCaption())) {
                if (bigChange) {
                    searchLinks(text, true);
                } else {
                    waitingForCharaterEnterRunnable = new Runnable() {
                        @Override
                        public void run() {
                            if (this == waitingForCharaterEnterRunnable) {
                                searchLinks(text, false);
                                waitingForCharaterEnterRunnable = null;
                            }
                        }
                    };
                    AndroidUtilities.runOnUIThread(waitingForCharaterEnterRunnable, AndroidUtilities.WEB_URL == null ? 3000 : 1000);
                }
            }
            if (emojiAnimationsOverlay != null) {
                emojiAnimationsOverlay.cancelAllAnimations();
            }
            ReactionsEffectOverlay.dismissAll();
        }

        @Override
        public void onTextSpansChanged(CharSequence text) {
            if (BuildVars.IS_CHAT_AIR) return;
            searchLinks(text, true);
        }

        @Override
        public void needSendTyping() {
            getMessagesController().sendTyping(dialog_id, threadMessageId, 0, classGuid);
        }

        @Override
        public void onAttachButtonHidden() {
            if (actionBar.isSearchFieldVisible()) {
                return;
            }
            if (editTextItem != null && !isEditTextItemVisibilitySuppressed) {
                editTextItem.setVisibility(View.GONE);
            }
            if (TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                if (headerItem != null) {
                    headerItem.setVisibility(View.GONE);
                }
                if (attachItem != null) {
                    attachItem.setVisibility(View.VISIBLE);
                }
            }
        }

        @Override
        public void onAttachButtonShow() {
            if (actionBar.isSearchFieldVisible()) {
                return;
            }
            if (headerItem != null) {
                headerItem.setVisibility(View.VISIBLE);
            }
            if (editTextItem != null && !isEditTextItemVisibilitySuppressed) {
                editTextItem.setVisibility(View.GONE);
            }
            if (attachItem != null) {
                attachItem.setVisibility(View.GONE);
            }
        }

        @Override
        public void onMessageEditEnd(boolean loading) {
            if (chatListItemAnimator != null) {
                chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                if (chatActivityEnterViewAnimateFromTop != 0) {
                    chatActivityEnterViewAnimateBeforeSending = true;
                }
            }
            if (!loading) {
                if (mentionContainer != null) {
                    mentionContainer.getAdapter().setNeedBotContext(true);
                }
                if (editingMessageObject != null) {
                    AndroidUtilities.runOnUIThread(() -> hideFieldPanel(true), 30);
                }
                boolean waitingForKeyboard = false;
                if (chatActivityEnterView.isPopupShowing()) {
                    chatActivityEnterView.setFieldFocused();
                    waitingForKeyboard = true;
                }
                chatActivityEnterView.setAllowStickersAndGifs(true, true, true, waitingForKeyboard);
                if (editingMessageObjectReqId != 0) {
                    getConnectionsManager().cancelRequest(editingMessageObjectReqId, true);
                    editingMessageObjectReqId = 0;
                }
                updatePinnedMessageView(true);
                updateBottomOverlay();
                updateVisibleRows();
            }
        }

        @Override
        public void onWindowSizeChanged(int size) {
            if (size < AndroidUtilities.dp(72) + actionBar.getActionBarHeight()) {
                allowStickersPanel = false;
                if (suggestEmojiPanel.getVisibility() == View.VISIBLE && !BuildVars.IS_CHAT_AIR) {
                    suggestEmojiPanel.setVisibility(View.INVISIBLE);
                }
            } else {
                allowStickersPanel = true;
                if (suggestEmojiPanel.getVisibility() == View.INVISIBLE && !BuildVars.IS_CHAT_AIR) {
                    suggestEmojiPanel.setVisibility(View.VISIBLE);
                }
            }

            allowContextBotPanel = !chatActivityEnterView.isPopupShowing();
//                checkContextBotPanel();
            int size2 = size + (chatActivityEnterView.isPopupShowing() ? 1 << 16 : 0);
            if (lastSize != size2) {
                chatActivityEnterViewAnimateFromTop = 0;
                chatActivityEnterViewAnimateBeforeSending = false;
            }
            lastSize = size2;
        }

        @Override
        public void onStickersTab(boolean opened) {
            if (emojiButtonRed != null) {
                emojiButtonRed.setVisibility(View.GONE);
            }
            allowContextBotPanelSecond = !opened;
//                checkContextBotPanel();
        }

        @Override
        public void didPressAttachButton() {
            if (chatAttachAlert != null) {
                chatAttachAlert.setEditingMessageObject(null);
            }
            openAttachMenu();
        }

        @Override
        public void needStartRecordVideo(int state, boolean notify, int scheduleDate) {
            checkInstantCameraView();
            if (instantCameraView != null) {
                if (state == 0) {
                    instantCameraView.showCamera();
                    chatListView.stopScroll();
                    chatAdapter.updateRowsSafe();
                } else if (state == 1 || state == 3 || state == 4) {
                    instantCameraView.send(state, notify, scheduleDate);
                } else if (state == 2 || state == 5) {
                    instantCameraView.cancel(state == 2);
                }
            }
        }

        @Override
        public void needChangeVideoPreviewState(int state, float seekProgress) {
            if (instantCameraView != null) {
                instantCameraView.changeVideoPreviewState(state, seekProgress);
            }
        }

        @Override
        public void needStartRecordAudio(int state) {
            int visibility = state == 0 ? View.GONE : View.VISIBLE;
            if (overlayView.getVisibility() != visibility) {
                overlayView.setVisibility(visibility);
            }
        }

        @Override
        public void needShowMediaBanHint() {
            showMediaBannedHint();
        }

        @Override
        public void onStickersExpandedChange() {
            checkRaiseSensors();
            if (chatActivityEnterView.isStickersExpanded()) {
                AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
                if (Bulletin.getVisibleBulletin() != null && Bulletin.getVisibleBulletin().isShowing()) {
                    Bulletin.getVisibleBulletin().hide();
                }
            } else {
                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }
            if (mentionContainer != null) {
                mentionContainer.animate().alpha(chatActivityEnterView.isStickersExpanded() ? 0 : 1f).setInterpolator(CubicBezierInterpolator.DEFAULT).start();
            }
            if (suggestEmojiPanel != null && !BuildVars.IS_CHAT_AIR) {
                suggestEmojiPanel.setVisibility(View.VISIBLE);
                suggestEmojiPanel.animate().alpha(chatActivityEnterView.isStickersExpanded() ? 0 : 1f).setInterpolator(CubicBezierInterpolator.DEFAULT).withEndAction(() -> {
                    if (suggestEmojiPanel != null && chatActivityEnterView.isStickersExpanded()) {
                        suggestEmojiPanel.setVisibility(View.GONE);
                    }
                }).start();
            }
        }

        @Override
        public void scrollToSendingMessage() {
            int id = getSendMessagesHelper().getSendingMessageId(dialog_id);
            if (id != 0) {
                scrollToMessageId(id, 0, true, 0, true, 0);
            }
        }

        @Override
        public boolean hasScheduledMessages() {
            return scheduledMessagesCount > 0 && chatMode == 0;
        }

        @Override
        public void onSendLongClick() {
            if (scheduledOrNoSoundHint != null) {
                scheduledOrNoSoundHint.hide();
            }
        }

        @Override
        public void openScheduledMessages() {
            ChatActivity.this.openScheduledMessages();
        }

        @Override
        public void onAudioVideoInterfaceUpdated() {
            updatePagedownButtonVisibility(true);
        }

        @Override
        public void bottomPanelTranslationYChanged(float translation) {
            if (translation != 0) {
                wasManualScroll = true;
            }
            bottomPanelTranslationY = chatActivityEnterView.panelAnimationInProgress() ? chatActivityEnterView.getEmojiPadding() - translation : 0;
            bottomPanelTranslationYReverse = chatActivityEnterView.panelAnimationInProgress() ? translation : 0;
            chatActivityEnterView.setTranslationY(translation);
            mentionContainer.setTranslationY(translation);
            contentView.setEmojiOffset(chatActivityEnterView.panelAnimationInProgress(), bottomPanelTranslationY);

            translation += chatActivityEnterView.getTopViewTranslation();
            mentionContainer.setTranslationY(translation);
            chatListView.setTranslationY(translation);

            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
            updateTextureViewPosition(false, false);
            contentView.invalidate();
            updateBulletinLayout();
        }

        @Override
        public void prepareMessageSending() {
            waitingForSendingMessageLoad = true;
        }

        @Override
        public void onTrendingStickersShowed(boolean show) {
            if (show) {
                AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
                fragmentView.requestLayout();
            } else {
                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }
        }

        @Override
        public boolean hasForwardingMessages() {
            return forwardingMessages != null && !forwardingMessages.messages.isEmpty();
        }
    }

    private final ChatScrollCallback chatScrollHelperCallback = new ChatScrollCallback();

    private final Runnable showScheduledOrNoSoundRunnable = () -> {
        if (getParentActivity() == null || fragmentView == null || chatActivityEnterView == null) {
            return;
        }
        View anchor = chatActivityEnterView.getSendButton();
        if (anchor == null || chatActivityEnterView.getEditField() == null || chatActivityEnterView.getEditField().getText().length() < 5) {
            return;
        }
        SharedConfig.increaseScheduledOrNoSuoundHintShowed();
        if (scheduledOrNoSoundHint == null) {
            scheduledOrNoSoundHint = new HintView(getParentActivity(), 4, themeDelegate);
            scheduledOrNoSoundHint.setShowingDuration(5000);
            scheduledOrNoSoundHint.setAlpha(0);
            scheduledOrNoSoundHint.setVisibility(View.INVISIBLE);
            scheduledOrNoSoundHint.setText(LocaleController.getString("ScheduledOrNoSoundHint", R.string.ScheduledOrNoSoundHint));
            contentView.addView(scheduledOrNoSoundHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }
        scheduledOrNoSoundHint.showForView(anchor, true);
    };

    public ChatActivity(Bundle args) {
        super(args);
    }

    //核心，最开始的启动
    @Override
    public boolean onFragmentCreate() {
        final long chatId = arguments.getLong("chat_id", 0);
        final long userId = arguments.getLong("user_id", 0);
        final int encId = arguments.getInt("enc_id", 0);
        dialogFolderId = arguments.getInt("dialog_folder_id", 0);
        dialogFilterId = arguments.getInt("dialog_filter_id", 0);
        chatMode = arguments.getInt("chatMode", 0);
        voiceChatHash = arguments.getString("voicechat", null);
        livestream = !TextUtils.isEmpty(arguments.getString("livestream", null));
        attachMenuBotToOpen = arguments.getString("attach_bot", null);
        attachMenuBotStartCommand = arguments.getString("attach_bot_start_command", null);
        inlineReturn = arguments.getLong("inline_return", 0);
        String inlineQuery = arguments.getString("inline_query");
        inlineQueryForInput = arguments.getString("inline_query_input");
        premiumInvoiceBot = arguments.getBoolean("premium_bot", false);
        startLoadFromMessageId = arguments.getInt("message_id", 0);
        startLoadFromDate = arguments.getInt("start_from_date", 0);
        startFromVideoTimestamp = arguments.getInt("video_timestamp", -1);
        threadUnreadMessagesCount = arguments.getInt("unread_count", 0);
        if (startFromVideoTimestamp >= 0) {
            startFromVideoMessageId = startLoadFromMessageId;
        }
        reportType = arguments.getInt("report", -1);
        pulled = arguments.getBoolean("pulled", false);
        boolean historyPreloaded = arguments.getBoolean("historyPreloaded", false);
        if (highlightMessageId != 0 && highlightMessageId != Integer.MAX_VALUE) {
            startLoadFromMessageId = highlightMessageId;
        }
        int migrated_to = arguments.getInt("migrated_to", 0);
        scrollToTopOnResume = arguments.getBoolean("scrollToTopOnResume", false);
        needRemovePreviousSameChatActivity = arguments.getBoolean("need_remove_previous_same_chat_activity", true);
        justCreatedChat = arguments.getBoolean("just_created_chat", false);

        if (chatId != 0) {
            currentChat = getMessagesController().getChat(chatId);
            if (currentChat == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                final MessagesStorage messagesStorage = getMessagesStorage();
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentChat = messagesStorage.getChat(chatId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentChat != null) {
                    getMessagesController().putChat(currentChat, true);
                } else {
                    return false;
                }
            }
            dialog_id = -chatId;
            if (ChatObject.isChannel(currentChat)) {
                getMessagesController().startShortPoll(currentChat, classGuid, false);
            }
        } else if (userId != 0) {
            currentUser = getMessagesController().getUser(userId);
            if (currentUser == null) {
                final MessagesStorage messagesStorage = getMessagesStorage();
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentUser = messagesStorage.getUser(userId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentUser != null) {
                    getMessagesController().putUser(currentUser, true);
                } else {
                    return false;
                }
            }
            dialog_id = userId;
            botUser = arguments.getString("botUser");
            if (inlineQuery != null) {
                getMessagesController().sendBotStart(currentUser, inlineQuery);
            } else if (premiumInvoiceBot && !TextUtils.isEmpty(botUser)) {
                getMessagesController().sendBotStart(currentUser, botUser);

                botUser = null;
                premiumInvoiceBot = false;
            }
        } else if (encId != 0) {
            currentEncryptedChat = getMessagesController().getEncryptedChat(encId);
            final MessagesStorage messagesStorage = getMessagesStorage();
            if (currentEncryptedChat == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentEncryptedChat = messagesStorage.getEncryptedChat(encId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentEncryptedChat != null) {
                    getMessagesController().putEncryptedChat(currentEncryptedChat, true);
                } else {
                    return false;
                }
            }
            currentUser = getMessagesController().getUser(currentEncryptedChat.user_id);
            if (currentUser == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentUser = messagesStorage.getUser(currentEncryptedChat.user_id);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentUser != null) {
                    getMessagesController().putUser(currentUser, true);
                } else {
                    return false;
                }
            }
            dialog_id = DialogObject.makeEncryptedDialogId(encId);
            maxMessageId[0] = maxMessageId[1] = Integer.MIN_VALUE;
            minMessageId[0] = minMessageId[1] = Integer.MAX_VALUE;
        } else {
            return false;
        }

        dialog_id_Long = dialog_id;

        transitionAnimationGlobalIndex = NotificationCenter.getGlobalInstance().setAnimationInProgress(transitionAnimationGlobalIndex, new int[0]);

        if (currentUser != null && Build.VERSION.SDK_INT < 23) {
            MediaController.getInstance().startMediaObserver();
        }

        getNotificationCenter().addPostponeNotificationsCallback(postponeNotificationsWhileLoadingCallback);

        if (chatMode != MODE_SCHEDULED) {
            if (threadMessageId == 0) {
                getNotificationCenter().addObserver(this, NotificationCenter.screenshotTook);
                getNotificationCenter().addObserver(this, NotificationCenter.encryptedChatUpdated);
                getNotificationCenter().addObserver(this, NotificationCenter.messagesReadEncrypted);
                getNotificationCenter().addObserver(this, NotificationCenter.botKeyboardDidLoad);
                getNotificationCenter().addObserver(this, NotificationCenter.updateMentionsCount);
                getNotificationCenter().addObserver(this, NotificationCenter.newDraftReceived);
                getNotificationCenter().addObserver(this, NotificationCenter.chatOnlineCountDidLoad);
                getNotificationCenter().addObserver(this, NotificationCenter.peerSettingsDidLoad);
                getNotificationCenter().addObserver(this, NotificationCenter.didLoadPinnedMessages);
                getNotificationCenter().addObserver(this, NotificationCenter.commentsRead);
                getNotificationCenter().addObserver(this, NotificationCenter.changeRepliesCounter);
                getNotificationCenter().addObserver(this, NotificationCenter.messagesRead);
                getNotificationCenter().addObserver(this, NotificationCenter.didLoadChatInviter);
                getNotificationCenter().addObserver(this, NotificationCenter.groupCallUpdated);
            } else {
                getNotificationCenter().addObserver(this, NotificationCenter.threadMessagesRead);
                if (isTopic) {
                    getNotificationCenter().addObserver(this, NotificationCenter.updateMentionsCount);
                    getNotificationCenter().addObserver(this, NotificationCenter.didLoadPinnedMessages);
                }
            }
            getNotificationCenter().addObserver(this, NotificationCenter.removeAllMessagesFromDialog);
            getNotificationCenter().addObserver(this, NotificationCenter.messagesReadContent);
            getNotificationCenter().addObserver(this, NotificationCenter.chatSearchResultsAvailable);
            getNotificationCenter().addObserver(this, NotificationCenter.chatSearchResultsLoading);
            getNotificationCenter().addObserver(this, NotificationCenter.didUpdateMessagesViews);
            getNotificationCenter().addObserver(this, NotificationCenter.didUpdatePollResults);
            if (currentEncryptedChat != null) {
                getNotificationCenter().addObserver(this, NotificationCenter.didVerifyMessagesStickers);
            }
        }
        getNotificationCenter().addObserver(this, NotificationCenter.messagesDidLoad);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.emojiLoaded);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.invalidateMotionBackground);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateConnectionState);
        getNotificationCenter().addObserver(this, NotificationCenter.updateInterfaces);
        getNotificationCenter().addObserver(this, NotificationCenter.updateDefaultSendAsPeer);
        if (chatMode != MODE_PINNED) {
            getNotificationCenter().addObserver(this, NotificationCenter.didReceiveNewMessages);
        }
        if (chatMode == 0) {
            getNotificationCenter().addObserver(this, NotificationCenter.didLoadSponsoredMessages);
        }
        getNotificationCenter().addObserver(this, NotificationCenter.didLoadSendAsPeers);
        getNotificationCenter().addObserver(this, NotificationCenter.closeChats);
        getNotificationCenter().addObserver(this, NotificationCenter.messagesDeleted);
        getNotificationCenter().addObserver(this, NotificationCenter.historyCleared);
        getNotificationCenter().addObserver(this, NotificationCenter.messageReceivedByServer);
        getNotificationCenter().addObserver(this, NotificationCenter.messageReceivedByAck);
        getNotificationCenter().addObserver(this, NotificationCenter.messageSendError);
        getNotificationCenter().addObserver(this, NotificationCenter.chatInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.contactsDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingProgressDidChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingDidReset);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingGoingToStop);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingPlayStateChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.blockedUsersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.fileNewChunkAvailable);
        getNotificationCenter().addObserver(this, NotificationCenter.didCreatedNewDeleteTask);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingDidStart);
        getNotificationCenter().addObserver(this, NotificationCenter.updateMessageMedia);
        getNotificationCenter().addObserver(this, NotificationCenter.voiceTranscriptionUpdate);
        getNotificationCenter().addObserver(this, NotificationCenter.animatedEmojiDocumentLoaded);
        getNotificationCenter().addObserver(this, NotificationCenter.replaceMessagesObjects);
        getNotificationCenter().addObserver(this, NotificationCenter.updateMessagesObjects);
        getNotificationCenter().addObserver(this, NotificationCenter.notificationsSettingsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.replyMessagesDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.didReceivedWebpages);
        getNotificationCenter().addObserver(this, NotificationCenter.didReceivedWebpagesInUpdates);
        getNotificationCenter().addObserver(this, NotificationCenter.botInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.chatInfoCantLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.userInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.pinnedInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.topicsDidLoaded);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.didSetNewWallpapper);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.didApplyNewTheme);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.goingToPreviewTheme);
        getNotificationCenter().addObserver(this, NotificationCenter.channelRightsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.audioRecordTooShort);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateReactions);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateExtendedMedia);
        getNotificationCenter().addObserver(this, NotificationCenter.videoLoadingStateChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.scheduledMessagesUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.diceStickersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogDeleted);
        getNotificationCenter().addObserver(this, NotificationCenter.chatAvailableReactionsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogsUnreadReactionsCounterChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.groupStickersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogTranslate);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogIsTranslatable);
        getNotificationCenter().addObserver(this, NotificationCenter.messageTranslated);
        getNotificationCenter().addObserver(this, NotificationCenter.messageTranslating);
        getNotificationCenter().addObserver(this, NotificationCenter.showAlert);
        getNotificationCenter().addObserver(this, NotificationCenter.updateModel);

        super.onFragmentCreate();

        if (chatMode == MODE_PINNED) {
            ArrayList<MessageObject> messageObjects = new ArrayList<>();
            for (int a = 0, N = pinnedMessageIds.size(); a < N; a++) {
                Integer id = pinnedMessageIds.get(a);
                MessageObject object = pinnedMessageObjects.get(id);
                if (object != null) {
                    MessageObject o = new MessageObject(object.currentAccount, object.messageOwner, true, false);
                    o.replyMessageObject = object.replyMessageObject;
                    o.mediaExists = object.mediaExists;
                    o.attachPathExists = object.attachPathExists;
                    messageObjects.add(o);
                }
            }
            int loadIndex = lastLoadIndex++;
            waitingForLoad.add(loadIndex);
            getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoad, dialog_id, messageObjects.size(), messageObjects, false, 0, last_message_id, 0, 0, 2, true, classGuid, loadIndex, pinnedMessageIds.get(0), 0, MODE_PINNED);
        } else if (!forceHistoryEmpty) {
            loading = true;
        }
        if (isThreadChat() && !isTopic) {
            if (highlightMessageId == startLoadFromMessageId) {
                needSelectFromMessageId = true;
            }
        } else {
            getMessagesController().setLastCreatedDialogId(dialog_id, chatMode == MODE_SCHEDULED, true);
            if (chatMode == 0) {
                if (currentEncryptedChat == null) {
                    getMediaDataController().loadBotKeyboard(dialog_id);
                }
                getMessagesController().loadPeerSettings(currentUser, currentChat);

                if (startLoadFromMessageId == 0) {
                    SharedPreferences sharedPreferences = MessagesController.getNotificationsSettings(currentAccount);
                    int messageId = sharedPreferences.getInt("diditem" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), 0);
                    if (messageId != 0) {
                        wasManualScroll = true;
                        loadingFromOldPosition = true;
                        startLoadFromMessageOffset = sharedPreferences.getInt("diditemo" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), 0);
                        startLoadFromMessageId = messageId;
                    }
                } else {
                    showScrollToMessageError = true;
                    needSelectFromMessageId = true;
                }
            }
        }

        boolean loadInfo = false;
        //如果当前聊天不为空，则加载当前聊天记录
        if (currentChat != null) {
            //载入群聊
            chatInfo = getMessagesController().getChatFull(currentChat.id);
            groupCall = getMessagesController().getGroupCall(currentChat.id, true);
            if (ChatObject.isChannel(currentChat) && !getMessagesController().isChannelAdminsLoaded(currentChat.id)) {
                getMessagesController().loadChannelAdmins(currentChat.id, true);
            }
            fillInviterId(false);
            if (chatMode != MODE_PINNED) {
                getMessagesStorage().loadChatInfo(currentChat.id, ChatObject.isChannel(currentChat), null, true, false, startLoadFromMessageId);
            }
            if (chatMode == 0 && chatInfo != null && ChatObject.isChannel(currentChat) && chatInfo.migrated_from_chat_id != 0 && !isThreadChat()) {
                mergeDialogId = -chatInfo.migrated_from_chat_id;
                maxMessageId[1] = chatInfo.migrated_from_max_id;
            }
            loadInfo = chatInfo == null;
            checkGroupCallJoin(false);
        } else if (currentUser != null) {
            //载入当前用户
            if (chatMode != MODE_PINNED) {
                getMessagesController().loadUserInfo(currentUser, true, classGuid, startLoadFromMessageId);
            }
            loadInfo = userInfo == null;
        }

        if (forceHistoryEmpty) {
            endReached[0] = endReached[1] = true;
            forwardEndReached[0] = forwardEndReached[1] = true;
            firstLoading = false;
            checkDispatchHideSkeletons(false);
        }
        //当前不为置顶或者强制空页面
        if (chatMode != MODE_PINNED && !forceHistoryEmpty) {
            waitingForLoad.add(lastLoadIndex);
            if (startLoadFromDate != 0) {
                getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, startLoadFromDate, true, 0, classGuid, 4, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            } else if (startLoadFromMessageId != 0 && (!isThreadChat() || startLoadFromMessageId == highlightMessageId || isTopic)) {
                startLoadFromMessageIdSaved = startLoadFromMessageId;
                if (migrated_to != 0) {
                    mergeDialogId = migrated_to;
                    getMessagesController().loadMessages(mergeDialogId, 0, loadInfo, loadingFromOldPosition ? 50 : (AndroidUtilities.isTablet() || (isThreadChat() && !isTopic) ? 30 : 20), startLoadFromMessageId, 0, true, 0, classGuid, 3, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                } else {
                    //点击聊天窗口载入老数据
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, loadInfo, loadingFromOldPosition ? 50 : (AndroidUtilities.isTablet() || (isThreadChat() && !isTopic)  ? 30 : 20), startLoadFromMessageId, 0, true, 0, classGuid, 3, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            } else {
                if (historyPreloaded) {
                    lastLoadIndex++;
                } else {
                    //核心，载入消息，然后由数据层将数据从新发送回来
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, loadInfo, BuildVars.IS_CHAT_AIR ? 50 : (AndroidUtilities.isTablet() || (isThreadChat() && !isTopic)  ? 30 : 20), startLoadFromMessageId, 0, true, 0, classGuid, 2, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            }
        }
        if (chatMode == 0 && !isThreadChat()) {
            waitingForLoad.add(lastLoadIndex);
            getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 1, 0, 0, true, 0, classGuid, 2, 0, MODE_SCHEDULED, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
        }

        if (chatMode == 0) {
            if (userId != 0 && currentUser.bot) {
                getMediaDataController().loadBotInfo(userId, userId, true, classGuid);
            } else if (chatInfo instanceof TLRPC.TL_chatFull) {
                for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                    TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                    TLRPC.User user = getMessagesController().getUser(participant.user_id);
                    if (user != null && user.bot) {
                        getMediaDataController().loadBotInfo(user.id, -chatInfo.id, true, classGuid);
                    }
                }
            }
            if (AndroidUtilities.isTablet() && !isComments) {
                getNotificationCenter().postNotificationName(NotificationCenter.openedChatChanged, dialog_id, getTopicId(), false);
            }

            if (currentUser != null && !UserObject.isReplyUser(currentUser)) {
                userBlocked = getMessagesController().blockePeers.indexOfKey(currentUser.id) >= 0;
            }

            if (currentEncryptedChat != null && AndroidUtilities.getMyLayerVersion(currentEncryptedChat.layer) != SecretChatHelper.CURRENT_SECRET_CHAT_LAYER) {
                getSecretChatHelper().sendNotifyLayerMessage(currentEncryptedChat, null);
            }
        }
        if (chatInfo != null && chatInfo.linked_chat_id != 0) {
            TLRPC.Chat chat = getMessagesController().getChat(chatInfo.linked_chat_id);
            if (chat != null && chat.megagroup) {
                getMessagesController().startShortPoll(chat, classGuid, false);
            }
        }

        themeDelegate = new ThemeDelegate();
        if (themeDelegate.isThemeChangeAvailable()) {
            NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.needSetDayNightTheme);
        }

        if (chatInvite != null) {
            int timeout = chatInvite.expires - getConnectionsManager().getCurrentTime();
            if (timeout < 0) {
                timeout = 10;
            }
            AndroidUtilities.runOnUIThread(chatInviteRunnable = () -> {
                chatInviteRunnable = null;
                if (getParentActivity() == null) {
                    return;
                }
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup) {
                    builder.setMessage(LocaleController.getString("JoinByPeekChannelText", R.string.JoinByPeekChannelText));
                    builder.setTitle(LocaleController.getString("JoinByPeekChannelTitle", R.string.JoinByPeekChannelTitle));
                } else {
                    builder.setMessage(LocaleController.getString("JoinByPeekGroupText", R.string.JoinByPeekGroupText));
                    builder.setTitle(LocaleController.getString("JoinByPeekGroupTitle", R.string.JoinByPeekGroupTitle));
                }
                builder.setPositiveButton(LocaleController.getString("JoinByPeekJoin", R.string.JoinByPeekJoin), (dialogInterface, i) -> {
                    if (bottomOverlayChatText != null) {
                        bottomOverlayChatText.callOnClick();
                    }
                });
                builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), (dialogInterface, i) -> finishFragment());
                showDialog(builder.create());
            }, timeout * 1000L);
        }

        if (isTopic) {
            getMessagesController().getTopicsController().getTopicRepliesCount(dialog_id, getTopicId());
        }

        return true;
    }

    private void fillInviterId(boolean load) {
        if (currentChat == null || chatInfo == null || ChatObject.isNotInChat(currentChat) || currentChat.creator) {
            return;
        }
        if (chatInfo.inviterId != 0) {
            chatInviterId = chatInfo.inviterId;
            return;
        }
        if (chatInfo.participants != null) {
            if (chatInfo.participants.self_participant != null) {
                chatInviterId = chatInfo.participants.self_participant.inviter_id;
                return;
            }
            long selfId = getUserConfig().getClientUserId();
            for (int a = 0, N = chatInfo.participants.participants.size(); a < N; a++) {
                TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                if (participant.user_id == selfId) {
                    chatInviterId = participant.inviter_id;
                    return;
                }
            }
        }
        if (load && chatInviterId == 0) {
            getMessagesController().checkChatInviter(currentChat.id, false);
        }
    }

    private void hideUndoViews() {
        if (undoView != null) {
            undoView.hide(true, 0);
        }
        if (pinBulletin != null) {
            pinBulletin.hide(false, 0);
        }
        if (topUndoView != null) {
            topUndoView.hide(true, 0);
        }
    }

    public int getOtherSameChatsDiff() {
        if (parentLayout == null || parentLayout.getFragmentStack() == null) {
            return 0;
        }
        int cur = parentLayout.getFragmentStack().indexOf(this);
        if (cur == -1) {
            cur = parentLayout.getFragmentStack().size();
        }
        int i = cur;
        for (int a = 0; a < parentLayout.getFragmentStack().size(); a++) {
            BaseFragment fragment = parentLayout.getFragmentStack().get(a);
            if (fragment != this && fragment instanceof ChatActivity) {
                ChatActivity chatActivity = (ChatActivity) fragment;
                if (chatActivity.dialog_id == dialog_id) {
                    i = a;
                    break;
                }
            }
        }
        return i - cur;
    }

    @Override
    public void onBeginSlide() {
        super.onBeginSlide();

        if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
            selectionReactionsOverlay.setHiddenByScroll(true);
        }
    }

    @Override
    public void onFragmentDestroy() {
        super.onFragmentDestroy();
        if (BuildVars.IS_CHAT_AIR && getSendMessagesHelper().isRequesting()) {
            getNotificationCenter().postNotificationName(NotificationCenter.cancelRequest);
        }
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onDestroy();
        }
        if (avatarContainer != null) {
            avatarContainer.onDestroy();
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onDestroy();
        }
        if (chatAttachAlert != null) {
            chatAttachAlert.dismissInternal();
        }
        getNotificationCenter().onAnimationFinish(transitionAnimationIndex);
        NotificationCenter.getGlobalInstance().onAnimationFinish(transitionAnimationGlobalIndex);
        getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
        getNotificationCenter().onAnimationFinish(scrollCallbackAnimationIndex);
        hideUndoViews();
        if (chatInviteRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(chatInviteRunnable);
            chatInviteRunnable = null;
        }
        getNotificationCenter().removePostponeNotificationsCallback(postponeNotificationsWhileLoadingCallback);
        getMessagesController().setLastCreatedDialogId(dialog_id, chatMode == MODE_SCHEDULED, false);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesDidLoad);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.emojiLoaded);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.invalidateMotionBackground);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateConnectionState);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateInterfaces);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateDefaultSendAsPeer);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceiveNewMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.closeChats);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.threadMessagesRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.commentsRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.changeRepliesCounter);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesDeleted);
        getNotificationCenter().removeObserver(this, NotificationCenter.historyCleared);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageReceivedByServer);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageReceivedByAck);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageSendError);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadChatInviter);
        getNotificationCenter().removeObserver(this, NotificationCenter.groupCallUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.encryptedChatUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesReadEncrypted);
        getNotificationCenter().removeObserver(this, NotificationCenter.removeAllMessagesFromDialog);
        getNotificationCenter().removeObserver(this, NotificationCenter.contactsDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingProgressDidChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingDidReset);
        getNotificationCenter().removeObserver(this, NotificationCenter.screenshotTook);
        getNotificationCenter().removeObserver(this, NotificationCenter.blockedUsersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.fileNewChunkAvailable);
        getNotificationCenter().removeObserver(this, NotificationCenter.didCreatedNewDeleteTask);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingDidStart);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingGoingToStop);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateMessageMedia);
        getNotificationCenter().removeObserver(this, NotificationCenter.voiceTranscriptionUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.animatedEmojiDocumentLoaded);
        getNotificationCenter().removeObserver(this, NotificationCenter.replaceMessagesObjects);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateMessagesObjects);
        getNotificationCenter().removeObserver(this, NotificationCenter.notificationsSettingsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.replyMessagesDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceivedWebpages);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceivedWebpagesInUpdates);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesReadContent);
        getNotificationCenter().removeObserver(this, NotificationCenter.botInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.botKeyboardDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatSearchResultsAvailable);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatSearchResultsLoading);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingPlayStateChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateMessagesViews);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatInfoCantLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadPinnedMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.peerSettingsDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.newDraftReceived);
        getNotificationCenter().removeObserver(this, NotificationCenter.userInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.pinnedInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.topicsDidLoaded);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.didSetNewWallpapper);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.didApplyNewTheme);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.goingToPreviewTheme);
        getNotificationCenter().removeObserver(this, NotificationCenter.channelRightsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateMentionsCount);
        getNotificationCenter().removeObserver(this, NotificationCenter.audioRecordTooShort);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdatePollResults);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateReactions);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateExtendedMedia);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatOnlineCountDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.videoLoadingStateChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.scheduledMessagesUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.diceStickersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogDeleted);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatAvailableReactionsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadSponsoredMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadSendAsPeers);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogsUnreadReactionsCounterChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.groupStickersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogTranslate);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogIsTranslatable);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageTranslated);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageTranslating);
        getNotificationCenter().removeObserver(this, NotificationCenter.showAlert);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateModel);
        if (currentEncryptedChat != null) {
            getNotificationCenter().removeObserver(this, NotificationCenter.didVerifyMessagesStickers);
        }
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.needSetDayNightTheme);

        if (chatMode == 0 && AndroidUtilities.isTablet()) {
            getNotificationCenter().postNotificationName(NotificationCenter.openedChatChanged, dialog_id, getTopicId(), true);
        }
        if (currentUser != null) {
            MediaController.getInstance().stopMediaObserver();
        }

        if (flagSecure != null) {
            flagSecure.detach();
        }
        if (currentUser != null) {
            getMessagesController().cancelLoadFullUser(currentUser.id);
        }
        AndroidUtilities.removeAdjustResize(getParentActivity(), classGuid);
        if (chatAttachAlert != null) {
            chatAttachAlert.onDestroy();
        }
        AndroidUtilities.unlockOrientation(getParentActivity());
        if (ChatObject.isChannel(currentChat)) {
            getMessagesController().startShortPoll(currentChat, classGuid, true);
            if (chatInfo != null && chatInfo.linked_chat_id != 0) {
                TLRPC.Chat chat = getMessagesController().getChat(chatInfo.linked_chat_id);
                getMessagesController().startShortPoll(chat, classGuid, true);
            }
        }
        if (textSelectionHelper != null) {
            textSelectionHelper.clear();
        }
        if (chatListItemAnimator != null) {
            chatListItemAnimator.onDestroy();
        }
        if (pinchToZoomHelper != null) {
            pinchToZoomHelper.clear();
        }
        chatThemeBottomSheet = null;

        INavigationLayout parentLayout = getParentLayout();
        if (parentLayout != null && parentLayout.getFragmentStack() != null) {
            BackButtonMenu.clearPulledDialogs(this, parentLayout.getFragmentStack().indexOf(this) - (replacingChatActivity ? 0 : 1));
        }
        replacingChatActivity = false;

        if (progressDialogCurrent != null) {
            progressDialogCurrent.cancel();
            progressDialogCurrent = null;
        }
        chatMessagesMetadataController.onFragmentDestroy();
    }

    private static class ChatActivityTextSelectionHelper extends TextSelectionHelper.ChatListTextSelectionHelper {
        ChatActivity chatActivity;
        public void setChatActivity(ChatActivity chatActivity) {
            cancelAllAnimators();
            clear();
            textSelectionOverlay = null;
            this.chatActivity = chatActivity;
        }

        @Override
        public int getParentTopPadding() {
            return chatActivity == null ? 0 : (int) chatActivity.chatListViewPaddingTop;
        }

        @Override
        public int getParentBottomPadding() {
            return chatActivity == null ? 0 : chatActivity.blurredViewBottomOffset;
        }

        @Override
        protected int getThemedColor(String key) {
            Integer color = chatActivity == null ? null : chatActivity.themeDelegate.getColor(key);
            return color != null ? color : super.getThemedColor(key);
        }

        @Override
        protected Theme.ResourcesProvider getResourcesProvider() {
            if (chatActivity != null) {
                return chatActivity.themeDelegate;
            }
            return null;
        }
    }

    //创建主界面UI
    @Override
    public View createView(Context context) {
        if (textSelectionHelper == null) {
            if (textSelectionHelpersCache != null && !textSelectionHelpersCache.isEmpty()) {
                textSelectionHelper = textSelectionHelpersCache.remove(0);
            } else {
                textSelectionHelper = new ChatActivityTextSelectionHelper();
            }
            textSelectionHelper.setChatActivity(this);
        }

        if (reportType >= 0) {
            actionBar.setBackgroundColor(getThemedColor(Theme.key_actionBarActionModeDefault));
            actionBar.setItemsColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), false);
            actionBar.setItemsBackgroundColor(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), false);
            actionBar.setTitleColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
            actionBar.setSubtitleColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        }
        actionBarBackgroundPaint.setColor(getThemedColor(Theme.key_actionBarDefault));

        if (chatMessageCellsCache.isEmpty()) {
            for (int a = 0; a < 15; a++) {
                chatMessageCellsCache.add(new ChatMessageCell(context, true, themeDelegate));
            }
        }
        for (int a = 1; a >= 0; a--) {
            selectedMessagesIds[a].clear();
            selectedMessagesCanCopyIds[a].clear();
            selectedMessagesCanStarIds[a].clear();
        }
        scheduledOrNoSoundHint = null;
        infoTopView = null;
        aspectRatioFrameLayout = null;
        videoTextureView = null;
        searchAsListHint = null;
        mediaBanTooltip = null;
        noSoundHintView = null;
        forwardHintView = null;
        checksHintView = null;
        textSelectionHint = null;
        emojiButtonRed = null;
        gifHintTextView = null;
        emojiHintTextView = null;
        pollHintView = null;
        timerHintView = null;
        videoPlayerContainer = null;
        voiceHintTextView = null;
        blurredView = null;
        dummyMessageCell = null;
        cantDeleteMessagesCount = 0;
        canEditMessagesCount = 0;
        cantForwardMessagesCount = 0;
        canForwardMessagesCount = 0;
        cantSaveMessagesCount = 0;
        canSaveMusicCount = 0;
        canSaveDocumentsCount = 0;

        hasOwnBackground = true;
        if (chatAttachAlert != null) {
            try {
                if (chatAttachAlert.isShowing()) {
                    chatAttachAlert.dismiss();
                }
            } catch (Exception ignore) {

            }
            chatAttachAlert.onDestroy();
            chatAttachAlert = null;
        }

        Theme.createChatResources(context, false);

        actionBar.setAddToContainer(false);
        if (inPreviewMode) {
            actionBar.setBackButtonDrawable(null);
        } else {
            actionBar.setBackButtonDrawable(new BackDrawable(reportType >= 0));
        }
        //actionBar点击事件
        actionBar.setActionBarMenuOnItemClick(new ActionBar.ActionBarMenuOnItemClick() {
            @Override
            public void onItemClick(final int id) {
                //返回键
                if (id == -1) {
                    if (actionBar.isActionModeShowed()) {
                        clearSelectionMode();
                    } else {
                        if (!checkRecordLocked(true)) {
                            finishFragment();
                        }
                    }
                } else if (id == view_as_topics) {
                    TopicsFragment.prepareToSwitchAnimation(ChatActivity.this);
                } else if (id == copy) {
                    if (!BuildVars.IS_CHAT_AIR) {
                        SpannableStringBuilder str = new SpannableStringBuilder();
                        long previousUid = 0;
                        for (int a = 1; a >= 0; a--) {
                            ArrayList<Integer> ids = new ArrayList<>();
                            for (int b = 0; b < selectedMessagesCanCopyIds[a].size(); b++) {
                                ids.add(selectedMessagesCanCopyIds[a].keyAt(b));
                            }
                            if (currentEncryptedChat == null) {
                                Collections.sort(ids);
                            } else {
                                Collections.sort(ids, Collections.reverseOrder());
                            }
                            for (int b = 0; b < ids.size(); b++) {
                                Integer messageId = ids.get(b);
                                MessageObject messageObject = selectedMessagesCanCopyIds[a].get(messageId);
                                if (str.length() != 0) {
                                    str.append("\n\n");
                                }
                                str.append(getMessageContent(messageObject, previousUid, ids.size() != 1 && (currentUser == null || !currentUser.self)));
                                previousUid = messageObject.getFromChatId();
                            }
                        }
                        if (str.length() != 0) {
                            AndroidUtilities.addToClipboard(str);
                            createUndoView();
                            undoView.showWithAction(0, UndoView.ACTION_TEXT_COPIED, null);
                        }
                        clearSelectionMode();
                    } else {
                        openCopy();
                    }
                } else if(id == share) {
                    openShare();
                } else if (id == delete) {
                    if (getParentActivity() == null) {
                        return;
                    }
                    createDeleteMessagesAlert(null, null);
                } else if (id == forward) {
                    openForward(true);
                } else if (id == save_to) {
                    ArrayList<MessageObject> messageObjects = new ArrayList<>();
                    for (int a = 1; a >= 0; a--) {
                        for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                            messageObjects.add(selectedMessagesIds[a].valueAt(b));
                        }
                        selectedMessagesIds[a].clear();
                        selectedMessagesCanCopyIds[a].clear();
                        selectedMessagesCanStarIds[a].clear();
                    }
                    boolean isMusic = canSaveMusicCount > 0;
                    hideActionMode();
                    updatePinnedMessageView(true);
                    updateVisibleRows();
                    MediaController.saveFilesFromMessages(getParentActivity(), getAccountInstance(), messageObjects, (count) -> {
                        if (count > 0) {
                            if (getParentActivity() == null) {
                                return;
                            }
                            BulletinFactory.of(ChatActivity.this).createDownloadBulletin(isMusic ? BulletinFactory.FileType.AUDIOS : BulletinFactory.FileType.UNKNOWNS, count, themeDelegate).show();
                        }
                    });
                } else if (id == chat_enc_timer) {
                    if (getParentActivity() == null) {
                        return;
                    }
                    showDialog(AlertsCreator.createTTLAlert(getParentActivity(), currentEncryptedChat, themeDelegate).create());
                } else if (id == clear_history || id == delete_chat || id == auto_delete_timer) {
                    if (getParentActivity() == null) {
                        return;
                    }
                    boolean canDeleteHistory = chatInfo != null && chatInfo.can_delete_channel;
                    if (id == auto_delete_timer || id == clear_history && currentEncryptedChat == null && ((currentUser != null && !UserObject.isUserSelf(currentUser) && !UserObject.isDeleted(currentUser)) || (chatInfo != null && chatInfo.can_delete_channel))) {
                        AlertsCreator.createClearDaysDialogAlert(ChatActivity.this, -1, currentUser, currentChat, canDeleteHistory, new MessagesStorage.BooleanCallback() {
                            @Override
                            public void run(boolean revoke) {
                                if (revoke && (currentUser != null || canDeleteHistory)) {
                                    getMessagesStorage().getMessagesCount(dialog_id, (count) -> {
                                        if (count >= 50) {
                                            AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, true, false, true, currentChat, currentUser, false, false, canDeleteHistory, (param) -> performHistoryClear(true, canDeleteHistory), themeDelegate);
                                        } else {
                                            performHistoryClear(true, canDeleteHistory);
                                        }
                                    });
                                } else {
                                    performHistoryClear(revoke, canDeleteHistory);
                                }
                            }
                        }, getResourceProvider());
                        return;
                    }
                    AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, id == clear_history, currentChat, currentUser, currentEncryptedChat != null, true, canDeleteHistory, (param) -> {
                        if (id == clear_history && ChatObject.isChannel(currentChat) && (!currentChat.megagroup || ChatObject.isPublic(currentChat))) {
                            getMessagesController().deleteDialog(dialog_id, 2, param);
                        } else {
                            if (id != clear_history) {
                                getNotificationCenter().removeObserver(ChatActivity.this, NotificationCenter.closeChats);
                                getNotificationCenter().postNotificationName(NotificationCenter.closeChats);
                                finishFragment();
                                getNotificationCenter().postNotificationName(NotificationCenter.needDeleteDialog, dialog_id, currentUser, currentChat, param);
                            } else {
                                performHistoryClear(param, canDeleteHistory);
                            }
                        }
                    }, themeDelegate);
                } else if (id == share_contact) {
                    if (currentUser == null || getParentActivity() == null) {
                        return;
                    }
                    if (addToContactsButton != null && addToContactsButton.getTag() != null) {
                        shareMyContact((Integer) addToContactsButton.getTag(), null);
                    } else {
                        Bundle args = new Bundle();
                        args.putLong("user_id", currentUser.id);
                        args.putBoolean("addContact", true);
                        presentFragment(new ContactAddActivity(args));
                    }
                } else if (id == mute) {
                    toggleMute(false);
                } else if (id == add_shortcut) {
                    try {
                        getMediaDataController().installShortcut(currentUser.id);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                } else if (id == report) {
                    AlertsCreator.createReportAlert(getParentActivity(), dialog_id, 0, ChatActivity.this, themeDelegate, null);
                } else if (id == star) {
                    for (int a = 0; a < 2; a++) {
                        for (int b = 0; b < selectedMessagesCanStarIds[a].size(); b++) {
                            MessageObject msg = selectedMessagesCanStarIds[a].valueAt(b);
                            getMediaDataController().addRecentSticker(MediaDataController.TYPE_FAVE, msg, msg.getDocument(), (int) (System.currentTimeMillis() / 1000), !hasUnfavedSelected);
                        }
                    }
                    clearSelectionMode();
                } else if (id == edit) {
                    MessageObject messageObject = null;
                    for (int a = 1; a >= 0; a--) {
                        if (messageObject == null && selectedMessagesIds[a].size() == 1) {
                            ArrayList<Integer> ids = new ArrayList<>();
                            for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                                ids.add(selectedMessagesIds[a].keyAt(b));
                            }
                            messageObject = messagesDict[a].get(ids.get(0));
                        }
                        selectedMessagesIds[a].clear();
                        selectedMessagesCanCopyIds[a].clear();
                        selectedMessagesCanStarIds[a].clear();
                    }
                    startEditingMessageObject(messageObject);
                    hideActionMode();
                    updatePinnedMessageView(true);
                    updateVisibleRows();
                } else if (id == chat_menu_attach) {
                    if (!BuildVars.IS_CHAT_AIR) {
                        ActionBarMenuSubItem attach = new ActionBarMenuSubItem(context, false, true, true, getResourceProvider());
                        attach.setTextAndIcon(LocaleController.getString("AttachMenu", R.string.AttachMenu), R.drawable.input_attach);
                        attach.setOnClickListener(view -> {
                            headerItem.closeSubMenu();
                            if (chatAttachAlert != null) {
                                chatAttachAlert.setEditingMessageObject(null);
                            }
                            openAttachMenu();
                        });
                        headerItem.toggleSubMenu(attach, attachItem.createView());
                    } else {
                        headerItem.toggleSubMenu(null, attachItem.createView());
                    }
                } else if (id == bot_help) {
                    getSendMessagesHelper().sendMessage("/help", dialog_id, null, null, null, false, null, null, null, true, 0, null, false);
                } else if (id == bot_settings) {
                    getSendMessagesHelper().sendMessage("/settings", dialog_id, null, null, null, false, null, null, null, true, 0, null, false);
                } else if (id == search) {
                    openSearchWithText(null);
                } else if (id == translate) {
                    getMessagesController().getTranslateController().setHideTranslateDialog(getDialogId(), false, true);
                    if (!getMessagesController().getTranslateController().toggleTranslatingDialog(getDialogId(), true)) {
                        updateTopPanel(true);
                    }
                } else if (id == call || id == video_call) {
                    if (currentUser != null && getParentActivity() != null) {
                        VoIPHelper.startCall(currentUser, id == video_call, userInfo != null && userInfo.video_calls_available, getParentActivity(), getMessagesController().getUserFull(currentUser.id), getAccountInstance());
                    }
                } else if (id == context_clear) {
                    clearContext();
                } else if (id == undo_context_clear) {
                    unClearContext();
                } else if (id == change_user_ai_parameters) {
                    if (avatarContainer != null) {
                        avatarContainer.openProfile(true);
                        AndroidUtilities.logEvent("openProfile", "actionBar");
                    }
                } else if (id == text_bold) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedBold();
                    }
                } else if (id == text_italic) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedItalic();
                    }
                } else if (id == text_spoiler) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedSpoiler();
                    }
                } else if (id == text_mono) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedMono();
                    }
                } else if (id == text_strike) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedStrike();
                    }
                } else if (id == text_underline) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedUnderline();
                    }
                } else if (id == text_link) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedUrl();
                    }
                } else if (id == text_regular) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedRegular();
                    }
                } else if (id == change_colors) {
                    showChatThemeBottomSheet();
                } else if (id == topic_close) {
                    getMessagesController().getTopicsController().toggleCloseTopic(currentChat.id, forumTopic.id, forumTopic.closed = true);
                    updateTopicButtons();
                    updateBottomOverlay();
                    updateTopPanel(true);
                } else if (id == open_forum) {
//                    TopicsFragment.prepareToSwitchAnimation(ChatActivity.this);
//                    Bundle bundle = new Bundle();
//                    bundle.putLong("chat_id", -dialog_id);
//                    presentFragment(new TopicsFragment(bundle));
                }
                AndroidUtilities.logEvent("chatActivityActionBarItem", String.valueOf(id));
            }
        });
        View backButton = actionBar.getBackButton();
        backButton.setOnTouchListener(new LongPressListenerWithMovingGesture() {
            @Override
            public void onLongPress() {
                scrimPopupWindow = BackButtonMenu.show(ChatActivity.this, backButton, dialog_id, getTopicId(), themeDelegate);
                if (scrimPopupWindow != null) {
                    setSubmenu(scrimPopupWindow);
                    scrimPopupWindow.setOnDismissListener(() -> {
                        setSubmenu(null);
                        scrimPopupWindow = null;
                        menuDeleteItem = null;
                        scrimPopupWindowItems = null;
                        chatLayoutManager.setCanScrollVertically(true);
                        if (scrimPopupWindowHideDimOnDismiss) {
                            dimBehindView(false);
                        } else {
                            scrimPopupWindowHideDimOnDismiss = true;
                        }
                        if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                            chatActivityEnterView.getEditField().setAllowDrawCursor(true);
                        }
                    });
                    chatListView.stopScroll();
                    chatLayoutManager.setCanScrollVertically(false);
                    dimBehindView(backButton, 0.3f);
                    hideHints(false);
                    if (topUndoView != null) {
                        topUndoView.hide(true, 1);
                    }
                    if (undoView != null) {
                        undoView.hide(true, 1);
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setAllowDrawCursor(false);
                    }
                }
            }
        });
        actionBar.setInterceptTouchEventListener((view, motionEvent) -> {
            if (chatThemeBottomSheet != null) {
                chatThemeBottomSheet.close();
                return true;
            }
            return false;
        });

        if (avatarContainer != null) {
            avatarContainer.onDestroy();
        }
        avatarContainer = new ChatAvatarContainer(context, this, currentEncryptedChat != null, themeDelegate);
        avatarContainer.allowShorterStatus = true;
        avatarContainer.premiumIconHiddable = true;
        AndroidUtilities.updateViewVisibilityAnimated(avatarContainer, true, 1f, false);
        updateTopicTitleIcon();
        if (inPreviewMode || inBubbleMode) {
            avatarContainer.setOccupyStatusBar(false);
        }
        if (reportType >= 0) {
            if (reportType == AlertsCreator.REPORT_TYPE_SPAM) {
                actionBar.setTitle(LocaleController.getString("ReportChatSpam", R.string.ReportChatSpam));
            } else if (reportType == AlertsCreator.REPORT_TYPE_VIOLENCE) {
                actionBar.setTitle(LocaleController.getString("ReportChatViolence", R.string.ReportChatViolence));
            } else if (reportType == AlertsCreator.REPORT_TYPE_CHILD_ABUSE) {
                actionBar.setTitle(LocaleController.getString("ReportChatChild", R.string.ReportChatChild));
            } else if (reportType == AlertsCreator.REPORT_TYPE_PORNOGRAPHY) {
                actionBar.setTitle(LocaleController.getString("ReportChatPornography", R.string.ReportChatPornography));
            } else if (reportType == AlertsCreator.REPORT_TYPE_ILLEGAL_DRUGS) {
                actionBar.setTitle(LocaleController.getString("ReportChatIllegalDrugs", R.string.ReportChatIllegalDrugs));
            } else if (reportType == AlertsCreator.REPORT_TYPE_PERSONAL_DETAILS) {
                actionBar.setTitle(LocaleController.getString("ReportChatPersonalDetails", R.string.ReportChatPersonalDetails));
            }
            actionBar.setSubtitle(LocaleController.getString("ReportSelectMessages", R.string.ReportSelectMessages));
        } else if (startLoadFromDate != 0) {
            final int date = startLoadFromDate;
            actionBar.setOnClickListener((v) -> {
                jumpToDate(date);
            });
            actionBar.setTitle(LocaleController.formatDateChat(startLoadFromDate, false));
            actionBar.setSubtitle(LocaleController.getString("Loading", R.string.Loading));

            TLRPC.TL_messages_getHistory gh1 = new TLRPC.TL_messages_getHistory();
            gh1.peer = getMessagesController().getInputPeer(dialog_id);
            gh1.offset_date = startLoadFromDate;
            gh1.limit = 1;
            gh1.add_offset = -1;

            int req = getConnectionsManager().sendRequest(gh1, (response, error) -> {
                if (response instanceof TLRPC.messages_Messages) {
                    List<TLRPC.Message> l = ((TLRPC.messages_Messages) response).messages;
                    if (!l.isEmpty()) {

                        TLRPC.TL_messages_getHistory gh2 = new TLRPC.TL_messages_getHistory();
                        gh2.peer = getMessagesController().getInputPeer(dialog_id);
                        gh2.offset_date = startLoadFromDate + 60 * 60 * 24;
                        gh2.limit = 1;

                        getConnectionsManager().sendRequest(gh2, (response1, error1) -> {
                            if (response1 instanceof TLRPC.messages_Messages) {
                                List<TLRPC.Message> l2 = ((TLRPC.messages_Messages) response1).messages;
                                int count = 0;
                                if (!l2.isEmpty()) {
                                    count = ((TLRPC.messages_Messages) response).offset_id_offset - ((TLRPC.messages_Messages) response1).offset_id_offset;
                                } else {
                                    count = ((TLRPC.messages_Messages) response).offset_id_offset;
                                }
                                int finalCount = count;
                                AndroidUtilities.runOnUIThread(() -> {
                                    if (finalCount != 0) {
                                        AndroidUtilities.runOnUIThread(() -> actionBar.setSubtitle(LocaleController.formatPluralString("messages", finalCount)));
                                    } else {
                                        actionBar.setSubtitle(LocaleController.getString("NoMessagesForThisDay", R.string.NoMessagesForThisDay));
                                    }
                                });
                            }
                        });
                    } else {
                        actionBar.setSubtitle(LocaleController.getString("NoMessagesForThisDay", R.string.NoMessagesForThisDay));
                    }
                }
            });
            getConnectionsManager().bindRequestToGuid(req, classGuid);
        } else {
            //添加actionBar内容view
            if(getUserConfig().isHideToolbar) {
                avatarContainer.setVisibility(View.GONE);
            }
            actionBar.addView(avatarContainer, 0, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.TOP | Gravity.LEFT, !inPreviewMode ? 56 : (chatMode == MODE_PINNED ? 10 : 0), 0, 40, 0));
        }

        ActionBarMenu menu = actionBar.createMenu();

        //搜索按钮
        if (!BuildVars.IS_CHAT_AIR && currentEncryptedChat == null && chatMode == 0 && reportType < 0) {
            searchIconItem = menu.addItem(search, R.drawable.ic_ab_search);
            searchIconItem.setContentDescription(LocaleController.getString("Search", R.string.Search));
            searchItem = menu.addItem(chat_menu_search, R.drawable.ic_ab_search, themeDelegate);
            searchItem.setIsSearchField(true);
            searchItem.setActionBarMenuItemSearchListener(getSearchItemListener());
            searchItem.setSearchFieldHint(LocaleController.getString("Search", R.string.Search));
            if (threadMessageId == 0 && !UserObject.isReplyUser(currentUser) || threadMessageObject != null && threadMessageObject.getRepliesCount() < 10) {
                searchItem.setVisibility(View.GONE);
            } else {
                searchItem.setVisibility(View.VISIBLE);
            }
            searchItemVisible = false;
        }

        //电话功能
        if (chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && reportType < 0 && !BuildVars.IS_CHAT_AIR) {
            TLRPC.UserFull userFull = null;
            if (currentUser != null) {
                audioCallIconItem = menu.lazilyAddItem(call, R.drawable.ic_call, themeDelegate);
                audioCallIconItem.setContentDescription(LocaleController.getString("Call", R.string.Call));
                userFull = getMessagesController().getUserFull(currentUser.id);
                if (userFull != null && userFull.phone_calls_available) {
                    showAudioCallAsIcon = !inPreviewMode;
                    audioCallIconItem.setVisibility(View.VISIBLE);
                } else {
                    showAudioCallAsIcon = false;
                    audioCallIconItem.setVisibility(View.GONE);
                }
                if (avatarContainer != null) {
                    avatarContainer.setTitleExpand(showAudioCallAsIcon);
                }
            }
        }

        if (BuildVars.IS_CHAT_AIR && currentUser == null || !currentUser.self) {
            contextClearIconItem = menu.lazilyAddItem(context_clear, R.drawable.msg_clear, themeDelegate);
            contextClearIconItem.setContentDescription(LocaleController.getString("ContextClear", R.string.ContextClear));
            contextClearIconItem.setVisibility(isContextClear ? View.VISIBLE: View.GONE);
            contextClearIconItem.setTag(null);

            undoContextClearIconItem = menu.lazilyAddItem(undo_context_clear, R.drawable.chats_undo, themeDelegate);
            undoContextClearIconItem.setContentDescription(LocaleController.getString("UndoContextClear", R.string.UndoContextClear));
            undoContextClearIconItem.setVisibility(!isContextClear ? View.VISIBLE: View.GONE);
            undoContextClearIconItem.setTag(null);
        }

        editTextItem = menu.lazilyAddItem(chat_menu_edit_text_options, R.drawable.ic_ab_other, themeDelegate);
        editTextItem.setContentDescription(LocaleController.getString("AccDescrMoreOptions", R.string.AccDescrMoreOptions));
        editTextItem.setTag(null);
        editTextItem.setVisibility(View.GONE);

        if (chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && reportType < 0) {
            TLRPC.UserFull userFull = null;
            if (currentUser != null) {
                userFull = getMessagesController().getUserFull(currentUser.id);
            }
            headerItem = menu.addItem(chat_menu_options, R.drawable.ic_ab_other, themeDelegate);
            headerItem.setContentDescription(LocaleController.getString("AccDescrMoreOptions", R.string.AccDescrMoreOptions));

            //静音图标
            if (currentUser == null || !currentUser.self && !BuildVars.IS_CHAT_AIR) {
                chatNotificationsPopupWrapper = new ChatNotificationsPopupWrapper(context, currentAccount, headerItem.getPopupLayout().getSwipeBack(), false, false, new ChatNotificationsPopupWrapper.Callback() {
                    @Override
                    public void dismiss() {
                        headerItem.toggleSubMenu();
                    }

                    @Override
                    public void toggleSound() {
                        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                        boolean enabled = !preferences.getBoolean("sound_enabled_" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), true);
                        preferences.edit().putBoolean("sound_enabled_" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), enabled).apply();
                        if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                            BulletinFactory.createSoundEnabledBulletin(ChatActivity.this, enabled ? NotificationsController.SETTING_SOUND_ON : NotificationsController.SETTING_SOUND_OFF, getResourceProvider()).show();
                        }
                        updateTitleIcons();
                    }

                    @Override
                    public void muteFor(int timeInSeconds) {
                        if (timeInSeconds == 0) {
                            if (getMessagesController().isDialogMuted(dialog_id, getTopicId())) {
                                ChatActivity.this.toggleMute(true);
                            }
                            if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                                BulletinFactory.createMuteBulletin(ChatActivity.this, NotificationsController.SETTING_MUTE_UNMUTE, timeInSeconds, getResourceProvider()).show();
                            }
                        } else {
                            getNotificationsController().muteUntil(dialog_id, getTopicId(), timeInSeconds);
                            if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                                BulletinFactory.createMuteBulletin(ChatActivity.this, NotificationsController.SETTING_MUTE_CUSTOM, timeInSeconds, getResourceProvider()).show();
                            }
                        }
                    }

                    @Override
                    public void showCustomize() {
                        if (dialog_id != 0) {
                            if (currentUser != null) {
                                getMessagesController().putUser(currentUser, true);
                            }
                            Bundle args = new Bundle();
                            args.putLong("dialog_id", dialog_id);
                            if (getTopicId() != 0) {
                                args.putInt("topic_id", getTopicId());
                            }
                            presentFragment(new ProfileNotificationsActivity(args, themeDelegate));
                        }
                    }

                    @Override
                    public void toggleMute() {
                        ChatActivity.this.toggleMute(true);
                        BulletinFactory.createMuteBulletin(ChatActivity.this, getMessagesController().isDialogMuted(dialog_id, getTopicId()), themeDelegate).show();
                    }
                }, getResourceProvider());
                muteItem = headerItem.lazilyAddSwipeBackItem(R.drawable.msg_mute, null, null, chatNotificationsPopupWrapper.windowLayout);
                muteItem.setOnClickListener(view -> {
                    boolean muted = MessagesController.getInstance(currentAccount).isDialogMuted(dialog_id, getTopicId());
                    if (muted) {
                        updateTitleIcons(true);
                        AndroidUtilities.runOnUIThread(() -> {
                            ChatActivity.this.toggleMute(true);
                        }, 150);
                        headerItem.toggleSubMenu();
                        if (ChatActivity.this.getParentActivity() != null) {
                            BulletinFactory.createMuteBulletin(ChatActivity.this, false, themeDelegate).show();
                        }
                    } else {
                        muteItem.openSwipeBack();
                    }
                });
                muteItemGap = headerItem.lazilyAddColoredGap();
            }
            if (currentUser != null && !BuildVars.IS_CHAT_AIR) {
                headerItem.lazilyAddSubItem(call, R.drawable.msg_callback, LocaleController.getString("Call", R.string.Call));
                if (Build.VERSION.SDK_INT >= 18) {
                    headerItem.lazilyAddSubItem(video_call, R.drawable.msg_videocall, LocaleController.getString("VideoCall", R.string.VideoCall));
                }
                if (userFull != null && userFull.phone_calls_available) {
                    headerItem.showSubItem(call);
                    if (userFull.video_calls_available) {
                        headerItem.showSubItem(video_call);
                    } else {
                        headerItem.hideSubItem(video_call);
                    }
                } else {
                    headerItem.hideSubItem(call);
                    headerItem.hideSubItem(video_call);
                }
            }

            if (searchItem != null) {
                headerItem.lazilyAddSubItem(search, R.drawable.msg_search, LocaleController.getString("Search", R.string.Search));
            }
            translateItem = headerItem.lazilyAddSubItem(translate, R.drawable.msg_translate, LocaleController.getString("TranslateMessage", R.string.TranslateMessage));
            updateTranslateItemVisibility();
            if (currentChat != null && !currentChat.creator && !ChatObject.hasAdminRights(currentChat)) {
                headerItem.lazilyAddSubItem(report, R.drawable.msg_report, LocaleController.getString("ReportChat", R.string.ReportChat));
            }
            if (currentUser != null) {
                addContactItem = headerItem.lazilyAddSubItem(share_contact, R.drawable.msg_addcontact, "");
            }
            if (currentEncryptedChat != null) {
                timeItem2 = headerItem.lazilyAddSubItem(chat_enc_timer, R.drawable.msg_autodelete, LocaleController.getString("SetTimer", R.string.SetTimer));
            }
            if (currentChat != null && !isTopic) {
                viewAsTopics = headerItem.lazilyAddSubItem(view_as_topics, R.drawable.msg_topics, LocaleController.getString("TopicViewAsTopics", R.string.TopicViewAsTopics));
            }

            if (BuildVars.IS_CHAT_AIR) {
                changeUserAiParameters = headerItem.lazilyAddSubItem(change_user_ai_parameters, R.drawable.list_reorder, LocaleController.getString("ModifyPrompts", R.string.ModifyPrompts));
            }

            if (!isTopic) {
                clearHistoryItem = headerItem.lazilyAddSubItem(clear_history, !BuildVars.IS_CHAT_AIR ? R.drawable.msg_clear : R.drawable.msg_clear_input, LocaleController.getString("ClearHistory", R.string.ClearHistory));
            }
            if (!BuildVars.IS_CHAT_AIR && themeDelegate.isThemeChangeAvailable()) {
                headerItem.lazilyAddSubItem(change_colors, R.drawable.msg_colors, LocaleController.getString("ChangeColors", R.string.ChangeColors));
            }
            if (!isTopic) {
                if (ChatObject.isChannel(currentChat) && !currentChat.creator) {
                    if (!ChatObject.isNotInChat(currentChat)) {
                        if (currentChat.megagroup) {
                            headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString("LeaveMegaMenu", R.string.LeaveMegaMenu));
                        } else {
                            headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString("LeaveChannelMenu", R.string.LeaveChannelMenu));
                        }
                    }
                } else if (!ChatObject.isChannel(currentChat) && (!BuildVars.IS_CHAT_AIR || (BuildVars.IS_CHAT_AIR && dialog_id != UserConfig.defaultUserId))) {
                    if (currentChat != null) {
                        headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString("DeleteAndExit", R.string.DeleteAndExit));
                    } else {
                        headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_delete, LocaleController.getString("DeleteChatUser", R.string.DeleteChatUser));
                    }
                }
            }
            if (currentUser != null && currentUser.self || true) {
                headerItem.lazilyAddSubItem(add_shortcut, R.drawable.msg_home, LocaleController.getString("AddShortcut", R.string.AddShortcut));
            }
            if (currentUser != null && currentEncryptedChat == null && currentUser.bot) {
                headerItem.lazilyAddSubItem(bot_settings, R.drawable.msg_settings_old, LocaleController.getString("BotSettings", R.string.BotSettings));
                headerItem.lazilyAddSubItem(bot_help, R.drawable.msg_help, LocaleController.getString("BotHelp", R.string.BotHelp));
                updateBotButtons();
            }
        }
        if (ChatObject.isForum(currentChat) && isTopic && getParentLayout() != null && getParentLayout().getFragmentStack() != null) {
            boolean hasMyForum = false;
            for (int i = 0; i < getParentLayout().getFragmentStack().size(); ++i) {
                BaseFragment fragment = getParentLayout().getFragmentStack().get(i);
                if (fragment instanceof TopicsFragment && ((TopicsFragment) fragment).getDialogId() == dialog_id) {
                    hasMyForum = true;
                    break;
                }
            }

            if (!hasMyForum) {
                openForumItem = headerItem.lazilyAddSubItem(open_forum, R.drawable.msg_discussion, LocaleController.getString("OpenAllTopics", R.string.OpenAllTopics));
            }
        }
        if (currentChat != null && forumTopic != null) {
            closeTopicItem = headerItem.lazilyAddSubItem(topic_close, R.drawable.msg_topic_close, LocaleController.getString("CloseTopic", R.string.CloseTopic));
            closeTopicItem.setVisibility(currentChat != null && ChatObject.canManageTopic(currentAccount, currentChat, forumTopic) && forumTopic != null && !forumTopic.closed ? View.VISIBLE : View.GONE);
        }
        menu.setVisibility(inMenuMode ? View.GONE : View.VISIBLE);

        //更新标题
        updateTitle(false);

        avatarContainer.updateOnlineCount();
        //更新副标题
        avatarContainer.updateSubtitle();
        //更新标题图标
        updateTitleIcons();

        if (chatMode == 0 && (!isThreadChat() || isTopic) && reportType < 0) {
            attachItem = menu.lazilyAddItem(chat_menu_attach, R.drawable.ic_ab_other, themeDelegate);
            attachItem.setOverrideMenuClick(true);
            attachItem.setAllowCloseAnimation(false);
            attachItem.setContentDescription(LocaleController.getString("AccDescrMoreOptions", R.string.AccDescrMoreOptions));
            attachItem.setVisibility(View.GONE);
        }

        if (inPreviewMode) {
            if (headerItem != null) {
                headerItem.setAlpha(0.0f);
            }
            if (attachItem != null) {
                attachItem.setAlpha(0.0f);
            }
        }

        actionModeViews.clear();
        selectedMessagesCountTextView = null;
        checkActionBarMenu(false);

        scrimPaint = new Paint();

        fragmentView = contentView = new ChatActivityFragmentView(context, parentLayout);
        contentView.needBlur = true;
        contentView.needBlurBottom = true;
        if (inBubbleMode) {
            contentView.setOccupyStatusBar(false);
        }

        //核心设置聊天背景
        contentView.setBackgroundImage(Theme.getCachedWallpaper(), Theme.isWallpaperMotion());

        emptyViewContainer = null;

        CharSequence oldMessage;
        //恢复上次在聊天框编辑的消息
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onDestroy();
            if (!chatActivityEnterView.isEditingMessage()) {
                oldMessage = chatActivityEnterView.getFieldText();
            } else {
                oldMessage = null;
            }
        } else {
            oldMessage = null;
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onDestroy();
        }

        //聊天列表
        chatListView = new RecyclerListView(context, themeDelegate) {

            private int lastWidth;

            private final ArrayList<ChatMessageCell> drawTimeAfter = new ArrayList<>();
            private final ArrayList<ChatMessageCell> drawNamesAfter = new ArrayList<>();
            private final ArrayList<ChatMessageCell> drawCaptionAfter = new ArrayList<>();
            private final ArrayList<MessageObject.GroupedMessages> drawingGroups = new ArrayList<>(10);

            private int startedTrackingX;
            private int startedTrackingY;
            private int startedTrackingPointerId;
            private long lastTrackingAnimationTime;
            private float trackAnimationProgress;
            private float endTrackingX;
            private boolean wasTrackingVibrate;

            private float springMultiplier = 2000f;

            private Paint outlineActionBackgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
            private Paint outlineActionBackgroundDarkenPaint = new Paint(Paint.ANTI_ALIAS_FLAG);

            private FloatValueHolder slidingDrawableVisibilityProgress = new FloatValueHolder(0);
            private SpringAnimation slidingDrawableVisibilitySpring = new SpringAnimation(slidingDrawableVisibilityProgress)
                    .setMinValue(0f)
                    .setMaxValue(springMultiplier)
                    .setSpring(new SpringForce(0)
                            .setStiffness(SpringForce.STIFFNESS_MEDIUM)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_NO_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private FloatValueHolder slidingFillProgress = new FloatValueHolder(0);
            private SpringAnimation slidingFillProgressSpring = new SpringAnimation(slidingFillProgress)
                    .setMinValue(0f)
                    .setSpring(new SpringForce(0)
                            .setStiffness(400f)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_MEDIUM_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private FloatValueHolder slidingOuterRingProgress = new FloatValueHolder(0);
            private SpringAnimation slidingOuterRingSpring = new SpringAnimation(slidingOuterRingProgress)
                    .setMinValue(0f)
                    .setSpring(new SpringForce(0)
                            .setStiffness(200f)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_NO_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private boolean slidingBeyondMax;
            private Path path = new Path();

            private boolean ignoreLayout;
            private boolean invalidated;

            int lastH = 0;

            {
                outlineActionBackgroundPaint.setStyle(Paint.Style.STROKE);
                outlineActionBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
                outlineActionBackgroundPaint.setStrokeWidth(AndroidUtilities.dp(2));
                outlineActionBackgroundDarkenPaint.setStyle(Paint.Style.STROKE);
                outlineActionBackgroundDarkenPaint.setStrokeCap(Paint.Cap.ROUND);
                outlineActionBackgroundDarkenPaint.setStrokeWidth(AndroidUtilities.dp(2));
            }

            @Override
            public void requestLayout() {
                if (ignoreLayout) {
                    return;
                }
                super.requestLayout();
            }

            @Override
            public void setTranslationY(float translationY) {
                if (translationY != getTranslationY()) {
                    super.setTranslationY(translationY);
                    if (emptyViewContainer != null) {
                        if (chatActivityEnterView != null && chatActivityEnterView.panelAnimationInProgress()) {
                            emptyViewContainer.setTranslationY(translationY / 2f);
                        } else {
                            emptyViewContainer.setTranslationY(translationY / 1.7f);
                        }
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.botCommandsMenuContainer != null) {
                        chatActivityEnterView.botCommandsMenuContainer.setTranslationY(translationY);
                    }
                    invalidateChatListViewTopPadding();
                    invalidateMessagesVisiblePart();
                }
            }

            @Override
            protected void onLayout(boolean changed, int l, int t, int r, int b) {
                super.onLayout(changed, l, t, r, b);
                if (lastWidth != r - l) {
                    lastWidth = r - l;
                    hideHints(false);
                }

                int height = getMeasuredHeight();
                if (lastH != height) {
                    ignoreLayout = true;
                    if (chatListItemAnimator != null) {
                        chatListItemAnimator.endAnimations();
                    }
                    chatScrollHelper.cancel();
                    ignoreLayout = false;
                    lastH = height;
                }

                forceScrollToTop = false;
                if (textSelectionHelper != null && textSelectionHelper.isSelectionMode()) {
                    textSelectionHelper.invalidate();
                }
                isSkeletonVisible();
            }

            private void setGroupTranslationX(ChatMessageCell view, float dx) {
                MessageObject.GroupedMessages group = view.getCurrentMessagesGroup();
                if (group == null) {
                    return;
                }
                int count = getChildCount();
                for (int a = 0; a < count; a++) {
                    View child = getChildAt(a);
                    if (child == view || !(child instanceof ChatMessageCell)) {
                        continue;
                    }
                    ChatMessageCell cell = (ChatMessageCell) child;
                    if (cell.getCurrentMessagesGroup() == group) {
                        cell.setSlidingOffset(dx);
                        cell.invalidate();
                    }
                }
                invalidate();
            }

            @Override
            public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
                if (scrimPopupWindow != null) {
                    return false;
                }
                return super.requestChildRectangleOnScreen(child, rect, immediate);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent e) {
                textSelectionHelper.checkSelectionCancel(e);
                if (isFastScrollAnimationRunning()) {
                    return false;
                }
                boolean result = super.onInterceptTouchEvent(e);
                if (actionBar.isActionModeShowed() || reportType >= 0) {
                    return result;
                }
                processTouchEvent(e);
                return result;
            }

            @Override
            public void setItemAnimator(ItemAnimator animator) {
                if (isFastScrollAnimationRunning()) {
                    return;
                }
                super.setItemAnimator(animator);
            }

            private void drawReplyButton(Canvas canvas) {
                if (slidingView == null || Thread.currentThread() != Looper.getMainLooper().getThread()) {
                    return;
                }
                Paint chatActionBackgroundPaint = getThemedPaint(Theme.key_paint_chatActionBackground);
                Paint chatActionBackgroundDarkenPaint = Theme.chat_actionBackgroundGradientDarkenPaint;
                if (outlineActionBackgroundPaint.getColor() != chatActionBackgroundPaint.getColor()) {
                    outlineActionBackgroundPaint.setColor(chatActionBackgroundPaint.getColor());
                }
                if (outlineActionBackgroundDarkenPaint.getColor() != chatActionBackgroundDarkenPaint.getColor()) {
                    outlineActionBackgroundDarkenPaint.setColor(chatActionBackgroundDarkenPaint.getColor());
                }
                if (outlineActionBackgroundPaint.getShader() != chatActionBackgroundPaint.getShader()) {
                    outlineActionBackgroundPaint.setShader(chatActionBackgroundPaint.getShader());
                }
                if (outlineActionBackgroundDarkenPaint.getShader() != chatActionBackgroundDarkenPaint.getShader()) {
                    outlineActionBackgroundDarkenPaint.setShader(chatActionBackgroundDarkenPaint.getShader());
                }

                float fillProgress = slidingFillProgress.getValue() / springMultiplier;
                int wasDarkenColor = outlineActionBackgroundDarkenPaint.getColor();

                if (fillProgress > 1) {
                    slidingBeyondMax = true;
                }

                float translationX = slidingView.getNonAnimationTranslationX(false);
                if (slidingDrawableVisibilityProgress.getValue() == 0) {
                    slidingFillProgressSpring.cancel();
                    slidingFillProgressSpring.getSpring().setFinalPosition(0);
                    slidingFillProgress.setValue(0f);
                    slidingOuterRingSpring.cancel();
                    slidingOuterRingSpring.getSpring().setFinalPosition(0);
                    slidingOuterRingProgress.setValue(0f);
                    slidingBeyondMax = false;
                }
                float progress;
                if (slidingFillProgressSpring.getSpring().getFinalPosition() != springMultiplier) {
                    progress = androidx.core.math.MathUtils.clamp((-translationX - AndroidUtilities.dp(20)) / AndroidUtilities.dp(30), 0, 1);
                } else {
                    progress = 1f;
                }

                if (progress == 1f && slidingFillProgressSpring.getSpring().getFinalPosition() != springMultiplier) {
                    slidingFillProgressSpring.getSpring().setFinalPosition(springMultiplier);
                    slidingFillProgressSpring.start();

                    slidingOuterRingSpring.getSpring().setFinalPosition(springMultiplier);
                    slidingOuterRingSpring.start();
                }

                boolean visible = translationX <= -AndroidUtilities.dp(20);
                float endVisibleValue = visible ? springMultiplier : 0;
                if (endVisibleValue != slidingDrawableVisibilitySpring.getSpring().getFinalPosition()) {
                    slidingDrawableVisibilitySpring.getSpring().setFinalPosition(endVisibleValue);
                    if (!slidingDrawableVisibilitySpring.isRunning()) {
                        slidingDrawableVisibilitySpring.start();
                    }
                }

                float iconProgress = slidingDrawableVisibilityProgress.getValue() / springMultiplier;
                float x = getMeasuredWidth() + translationX * (slidingView.getMessageObject() != null && slidingView.getMessageObject().isOut() ? 0.5f : 1f);
                float y = slidingView.getTop() + slidingView.getMeasuredHeight() / 2f;
                float scale = slidingBeyondMax ? fillProgress : iconProgress;

                float clearScale = slidingBeyondMax ? 0f : 1f - fillProgress;

                boolean isDark = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.5f;
                if (iconProgress != 0) {
                    AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale + outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (y - AndroidUtilities.dp(16) * scale + outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (x + AndroidUtilities.dp(16) * scale - outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (y + AndroidUtilities.dp(16) * scale - outlineActionBackgroundPaint.getStrokeWidth() / 2f));
                    Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                    if (fillProgress == 0) {
                        int outlineAlpha = outlineActionBackgroundPaint.getAlpha();
                        outlineActionBackgroundPaint.setAlpha((int) (outlineAlpha * iconProgress));
                        canvas.drawArc(AndroidUtilities.rectTmp, -90, 360 * progress, false, outlineActionBackgroundPaint);
                        outlineActionBackgroundPaint.setAlpha(outlineAlpha);

                        if (themeDelegate.hasGradientService()) {
                            outlineAlpha = outlineActionBackgroundDarkenPaint.getAlpha();
                            if (isDark) {
                                outlineActionBackgroundDarkenPaint.setColor(Color.WHITE);
                            }
                            outlineActionBackgroundDarkenPaint.setAlpha((int) (outlineAlpha * iconProgress));
                            canvas.drawArc(AndroidUtilities.rectTmp, -90, 360 * progress, false, outlineActionBackgroundDarkenPaint);
                        }
                    }
                }
                AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale), (int) (y - AndroidUtilities.dp(16) * scale), (int) (x + AndroidUtilities.dp(16) * scale), (int) (y + AndroidUtilities.dp(16) * scale));
                Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                path.rewind();
                path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * scale, AndroidUtilities.dp(16) * scale, Path.Direction.CW);

                int wasAlpha = chatActionBackgroundPaint.getAlpha();
                chatActionBackgroundPaint.setAlpha((int) (iconProgress * 0.6f * progress * wasAlpha));
                canvas.drawPath(path, chatActionBackgroundPaint);
                chatActionBackgroundPaint.setAlpha(wasAlpha);

                if (themeDelegate.hasGradientService()) {
                    wasAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                    if (isDark) {
                        Theme.chat_actionBackgroundGradientDarkenPaint.setColor(Color.WHITE);
                    }
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (iconProgress * 0.6f * progress * wasAlpha));
                    canvas.drawPath(path, Theme.chat_actionBackgroundGradientDarkenPaint);
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasAlpha);
                }

                if (clearScale != 0f) {
                    AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * clearScale), (int) (y - AndroidUtilities.dp(16) * clearScale), (int) (x + AndroidUtilities.dp(16) * clearScale), (int) (y + AndroidUtilities.dp(16) * clearScale));
                    path.rewind();
                    path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16), AndroidUtilities.dp(16), Path.Direction.CW);

                    canvas.save();
                    canvas.clipPath(path, Region.Op.DIFFERENCE);
                }

                AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale), (int) (y - AndroidUtilities.dp(16) * scale), (int) (x + AndroidUtilities.dp(16) * scale), (int) (y + AndroidUtilities.dp(16) * scale));
                Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                path.rewind();
                path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * scale, AndroidUtilities.dp(16) * scale, Path.Direction.CW);

                wasAlpha = chatActionBackgroundPaint.getAlpha();
                chatActionBackgroundPaint.setAlpha((int) (iconProgress * 0.4f * wasAlpha));
                canvas.drawPath(path, chatActionBackgroundPaint);
                chatActionBackgroundPaint.setAlpha(wasAlpha);

                if (themeDelegate.hasGradientService()) {
                    wasAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                    if (isDark) {
                        Theme.chat_actionBackgroundGradientDarkenPaint.setColor(Color.WHITE);
                    }
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (iconProgress * 0.4f * wasAlpha));
                    canvas.drawPath(path, Theme.chat_actionBackgroundGradientDarkenPaint);
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasAlpha);
                }
                if (clearScale != 0f) {
                    canvas.restore();
                }

                float outerRingProgress = slidingOuterRingProgress.getValue() / springMultiplier;
                if (outerRingProgress != 0 && outerRingProgress != 1) {
                    float outScale = 1f + outerRingProgress;

                    float wasWidth = outlineActionBackgroundPaint.getStrokeWidth();
                    float width = (1f - outerRingProgress) * wasWidth;
                    if (width != 0f) {
                        AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * outScale + width), (int) (y - AndroidUtilities.dp(16) * outScale + width), (int) (x + AndroidUtilities.dp(16) * outScale - width), (int) (y + AndroidUtilities.dp(16) * outScale - width));
                        Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);

                        wasAlpha = outlineActionBackgroundPaint.getAlpha();
                        outlineActionBackgroundPaint.setAlpha((int) (wasAlpha * iconProgress));

                        outlineActionBackgroundPaint.setStrokeWidth(width);
                        canvas.drawRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * outScale, AndroidUtilities.dp(16) * outScale, outlineActionBackgroundPaint);
                        outlineActionBackgroundPaint.setStrokeWidth(wasWidth);

                        outlineActionBackgroundPaint.setAlpha(wasAlpha);

                        if (themeDelegate.hasGradientService()) {
                            wasAlpha = outlineActionBackgroundDarkenPaint.getAlpha();
                            if (isDark) {
                                outlineActionBackgroundDarkenPaint.setColor(Color.WHITE);
                            }
                            outlineActionBackgroundDarkenPaint.setAlpha((int) (wasAlpha * iconProgress));

                            outlineActionBackgroundDarkenPaint.setStrokeWidth(width);
                            canvas.drawRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * outScale, AndroidUtilities.dp(16) * outScale, outlineActionBackgroundDarkenPaint);
                            outlineActionBackgroundDarkenPaint.setStrokeWidth(wasWidth);
                        }
                    }
                }

                int alpha = (int) (iconProgress * 0xFF);
                Drawable replyIconDrawable = getThemedDrawable(Theme.key_drawable_replyIcon);
                replyIconDrawable.setAlpha(alpha);
                replyIconDrawable.setBounds((int) (x - AndroidUtilities.dp(7) * scale), (int) (y - AndroidUtilities.dp(6) * scale), (int) (x + AndroidUtilities.dp(7) * scale), (int) (y + AndroidUtilities.dp(5) * scale));
                replyIconDrawable.draw(canvas);
                replyIconDrawable.setAlpha(255);

                outlineActionBackgroundDarkenPaint.setColor(wasDarkenColor);
                chatActionBackgroundDarkenPaint.setColor(wasDarkenColor);
            }

            //列表滚动动画
            private void processTouchEvent(MotionEvent e) {
                if (BuildVars.IS_CHAT_AIR) return;
                if (e != null) {
                    wasManualScroll = true;
                }
                if (e != null && e.getAction() == MotionEvent.ACTION_DOWN && !startedTrackingSlidingView && !maybeStartTrackingSlidingView && slidingView == null && !inPreviewMode) {
                    View view = getPressedChildView();
                    if (view instanceof ChatMessageCell) {
                        if (slidingView != null) {
                            slidingView.setSlidingOffset(0);
                        }
                        slidingView = (ChatMessageCell) view;
                        MessageObject message = slidingView.getMessageObject();
                        boolean allowReplyOnOpenTopic = false;
                        if (message != null && ChatObject.isForum(currentChat)) {
                            TLRPC.TL_forumTopic topic = getMessagesController().getTopicsController().findTopic(currentChat.id, MessageObject.getTopicId(message.messageOwner, true));
                            if (topic != null) {
                                allowReplyOnOpenTopic = !topic.closed || ChatObject.canManageTopic(currentAccount, currentChat, topic);
                            }
                        }
                        if (chatMode != 0 || threadMessageObjects != null && threadMessageObjects.contains(message) ||
                                getMessageType(message) == 1 && (message.getDialogId() == mergeDialogId || message.needDrawBluredPreview()) ||
                                currentEncryptedChat == null && message.getId() < 0 ||
                                bottomOverlayChat != null && bottomOverlayChat.getVisibility() == View.VISIBLE && !(bottomOverlayChatWaitsReply && allowReplyOnOpenTopic || message.wasJustSent) ||
                                currentChat != null && (ChatObject.isNotInChat(currentChat) && !isThreadChat() || ChatObject.isChannel(currentChat) && !ChatObject.canPost(currentChat) && !currentChat.megagroup || !ChatObject.canSendMessages(currentChat)) ||
                                textSelectionHelper.isSelectionMode()) {
                            slidingView.setSlidingOffset(0);
                            slidingView = null;
                            return;
                        }
                        startedTrackingPointerId = e.getPointerId(0);
                        maybeStartTrackingSlidingView = true;
                        startedTrackingX = (int) e.getX();
                        startedTrackingY = (int) e.getY();
                    }
                } else if (slidingView != null && e != null && e.getAction() == MotionEvent.ACTION_MOVE && e.getPointerId(0) == startedTrackingPointerId) {
                    int dx = Math.max(AndroidUtilities.dp(-80), Math.min(0, (int) (e.getX() - startedTrackingX)));
                    int dy = Math.abs((int) e.getY() - startedTrackingY);
                    if (getScrollState() == SCROLL_STATE_IDLE && maybeStartTrackingSlidingView && !startedTrackingSlidingView && dx <= -AndroidUtilities.getPixelsInCM(0.4f, true) && Math.abs(dx) / 3 > dy) {
                        MotionEvent event = MotionEvent.obtain(0, 0, MotionEvent.ACTION_CANCEL, 0, 0, 0);
                        slidingView.onTouchEvent(event);
                        super.onInterceptTouchEvent(event);
                        event.recycle();
                        chatLayoutManager.setCanScrollVertically(false);
                        maybeStartTrackingSlidingView = false;
                        startedTrackingSlidingView = true;
                        startedTrackingX = (int) e.getX();
                        if (getParent() != null) {
                            getParent().requestDisallowInterceptTouchEvent(true);
                        }
                    } else if (startedTrackingSlidingView) {
                        if (Math.abs(dx) >= AndroidUtilities.dp(50)) {
                            if (!wasTrackingVibrate) {
                                try {
                                    performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
                                } catch (Exception ignore) {

                                }
                                wasTrackingVibrate = true;
                            }
                        } else {
                            wasTrackingVibrate = false;
                        }
                        slidingView.setSlidingOffset(dx);
                        MessageObject messageObject = slidingView.getMessageObject();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            updateTextureViewPosition(false, false);
                        }
                        setGroupTranslationX(slidingView, dx);
                        invalidate();
                    }
                } else if (slidingView != null && (e == null || e.getPointerId(0) == startedTrackingPointerId && (e.getAction() == MotionEvent.ACTION_CANCEL || e.getAction() == MotionEvent.ACTION_UP || e.getAction() == MotionEvent.ACTION_POINTER_UP))) {
                    if (e != null && e.getAction() != MotionEvent.ACTION_CANCEL && Math.abs(slidingView.getNonAnimationTranslationX(false)) >= AndroidUtilities.dp(50)) {
                        showFieldPanelForReply(slidingView.getMessageObject());
                    }
                    endTrackingX = slidingView.getSlidingOffsetX();
                    if (endTrackingX == 0) {
                        slidingView = null;
                    }
                    lastTrackingAnimationTime = System.currentTimeMillis();
                    trackAnimationProgress = 0.0f;
                    invalidate();
                    maybeStartTrackingSlidingView = false;
                    startedTrackingSlidingView = false;
                    chatLayoutManager.setCanScrollVertically(true);
                }
            }

            @Override
            public boolean onTouchEvent(MotionEvent e) {
                textSelectionHelper.checkSelectionCancel(e);
                if (e.getAction() == MotionEvent.ACTION_DOWN) {
                    scrollByTouch = true;
                }
                if (pullingDownOffset != 0 && (e.getAction() == MotionEvent.ACTION_UP || e.getAction() == MotionEvent.ACTION_CANCEL)) {
                    float progress = Math.min(1f, pullingDownOffset / AndroidUtilities.dp(110));
                    if (e.getAction() == MotionEvent.ACTION_UP && progress == 1 && pullingDownDrawable != null && !pullingDownDrawable.emptyStub) {
                        if (pullingDownDrawable.animationIsRunning()) {
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, pullingDownOffset + AndroidUtilities.dp(8));
                            pullingDownBackAnimator = animator;
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(200);
                            animator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            animator.start();
                            pullingDownDrawable.runOnAnimationFinish(() -> {
                                animateToNextChat();
                            });
                        } else {
                            animateToNextChat();
                        }
                    } else {
                        if (pullingDownDrawable != null && pullingDownDrawable.emptyStub && (System.currentTimeMillis() - pullingDownDrawable.lastShowingReleaseTime) < 500 && pullingDownDrawable.animateSwipeToRelease) {
                            AnimatorSet animatorSet = new AnimatorSet();
                            pullingDownBackAnimator = animatorSet;
                            if (pullingDownDrawable != null) {
                                pullingDownDrawable.showBottomPanel(false);
                            }
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, AndroidUtilities.dp(111));
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(400);
                            animator.setInterpolator(CubicBezierInterpolator.DEFAULT);

                            ValueAnimator animator2 = ValueAnimator.ofFloat(AndroidUtilities.dp(111), 0);
                            animator2.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator2.setStartDelay(600);
                            animator2.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                            animator2.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);

                            animatorSet.playSequentially(animator, animator2);
                            animatorSet.start();
                        } else {
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, 0);
                            pullingDownBackAnimator = animator;
                            if (pullingDownDrawable != null) {
                                pullingDownDrawable.showBottomPanel(false);
                            }
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                            animator.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                            animator.start();
                        }
                    }
                }
                if (isFastScrollAnimationRunning()) {
                    return false;
                }
                boolean result = super.onTouchEvent(e);
                if (actionBar.isActionModeShowed() || reportType >= 0) {
                    return result;
                }
                processTouchEvent(e);
                return startedTrackingSlidingView || result;
            }

            @Override
            public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
                super.requestDisallowInterceptTouchEvent(disallowIntercept);
                if (slidingView != null) {
                    processTouchEvent(null);
                }
            }

            @Override
            protected void onChildPressed(View child, float x, float y, boolean pressed) {
                //点击聊天文字
                super.onChildPressed(child, x, y, pressed);
                if (child instanceof ChatMessageCell) {
                    ChatMessageCell chatMessageCell = (ChatMessageCell) child;
                    MessageObject object = chatMessageCell.getMessageObject();
                    if (object.isMusic() || object.isDocument()) {
                        return;
                    }
                    MessageObject.GroupedMessages groupedMessages = chatMessageCell.getCurrentMessagesGroup();
                    if (groupedMessages != null) {
                        int count = getChildCount();
                        for (int a = 0; a < count; a++) {
                            View item = getChildAt(a);
                            if (item == child || !(item instanceof ChatMessageCell)) {
                                continue;
                            }
                            ChatMessageCell cell = (ChatMessageCell) item;
                            if (cell.getCurrentMessagesGroup() == groupedMessages) {
                                cell.setPressed(pressed);
                            }
                        }
                    }
                }
            }

            @Override
            public void onDraw(Canvas c) {
                super.onDraw(c);
                if (slidingView != null) {
                    float translationX = slidingView.getSlidingOffsetX();
                    if (!maybeStartTrackingSlidingView && !startedTrackingSlidingView && endTrackingX != 0 && translationX != 0) {
                        long newTime = System.currentTimeMillis();
                        long dt = newTime - lastTrackingAnimationTime;
                        trackAnimationProgress += dt / 180.0f;
                        if (trackAnimationProgress > 1.0f) {
                            trackAnimationProgress = 1.0f;
                        }
                        lastTrackingAnimationTime = newTime;
                        translationX = endTrackingX * (1.0f - AndroidUtilities.decelerateInterpolator.getInterpolation(trackAnimationProgress));
                        if (translationX == 0) {
                            endTrackingX = 0;
                        }
                        setGroupTranslationX(slidingView, translationX);
                        slidingView.setSlidingOffset(translationX);
                        MessageObject messageObject = slidingView.getMessageObject();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            updateTextureViewPosition(false, false);
                        }

                        if (trackAnimationProgress == 1f || trackAnimationProgress == 0f) {
                            slidingView.setSlidingOffset(0);
                            slidingView = null;
                        }
                        invalidate();
                    }
                    drawReplyButton(c);
                }

                if (pullingDownOffset != 0 && !isInPreviewMode()) {
                    c.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset + (pullingDownAnimateToActivity == null ? 0 : pullingDownAnimateToActivity.pullingBottomOffset)) * pullingDownAnimateProgress;
                    }
                    c.translate(0, getMeasuredHeight() - blurredViewBottomOffset - transitionOffset);
                    if (pullingDownDrawable == null) {
                        pullingDownDrawable = new ChatPullingDownDrawable(currentAccount, fragmentView, dialog_id, dialogFolderId, dialogFilterId, themeDelegate);
                        pullingDownDrawable.onAttach();
                    }
                    pullingDownDrawable.setWidth(getMeasuredWidth());
                    float progress = Math.min(1f, pullingDownOffset / AndroidUtilities.dp(110));
                    pullingDownDrawable.draw(c, chatListView, progress, 1f - pullingDownAnimateProgress);

                    c.restore();

                    if (pullingDownAnimateToActivity != null) {
                        c.saveLayerAlpha(0, 0, pullingDownAnimateToActivity.chatListView.getMeasuredWidth(), pullingDownAnimateToActivity.chatListView.getMeasuredHeight(), (int) (255 * pullingDownAnimateProgress), Canvas.ALL_SAVE_FLAG);
                        c.translate(0, getMeasuredHeight() - pullingDownOffset - transitionOffset);
                        pullingDownAnimateToActivity.chatListView.draw(c);
                        c.restore();
                    }
                } else if (pullingDownDrawable != null) {
                    pullingDownDrawable.reset();
                }
            }

            @Override
            public void draw(Canvas canvas) {
                if ((startMessageAppearTransitionMs == 0 || System.currentTimeMillis() - startMessageAppearTransitionMs <= SKELETON_DISAPPEAR_MS) && !AndroidUtilities.isTablet() && !isComments && currentUser == null) {
                    boolean noAvatar = currentChat == null || ChatObject.isChannelAndNotMegaGroup(currentChat);
                    if (pullingDownOffset != 0) {
                        canvas.save();
                        canvas.translate(0, -pullingDownOffset);
                    }
                    updateSkeletonColors();
                    updateSkeletonGradient();

                    int lastTop = getHeight() - blurredViewBottomOffset;
                    int j = 0;

                    int childMaxTop = Integer.MAX_VALUE;
                    for (int i = 0; i < getChildCount(); i++) {
                        int top = getChildAt(i).getTop();
                        if (top < childMaxTop) {
                            childMaxTop = top;
                        }
                    }
                    if (startMessageAppearTransitionMs == 0 && childMaxTop <= 0) {
                        checkDispatchHideSkeletons(fragmentBeginToShow);
                    }

                    Paint servicePaint = getThemedPaint(Theme.key_paint_chatActionBackground);
                    if (skeletonServicePaint.getColor() != servicePaint.getColor()) {
                        skeletonServicePaint.setColor(servicePaint.getColor());
                    }
                    if (skeletonServicePaint.getShader() != servicePaint.getShader()) {
                        skeletonServicePaint.setShader(servicePaint.getShader());
                        skeletonColorMatrix.setSaturation(SKELETON_SATURATION);
                        skeletonServicePaint.setColorFilter(new ColorMatrixColorFilter(skeletonColorMatrix));
                    }

                    for (int i = 0; i < getChildCount(); i++) {
                        View v = getChildAt(i);
//                        if (v instanceof ChatMessageCell) {
//                            ChatMessageCell cell = (ChatMessageCell) v;
//                            if ((cell.getCurrentMessagesGroup() == null || cell.getCurrentMessagesGroup().findPrimaryMessageObject() == cell.getMessageObject())) {
//                                if (cell.shouldDrawAlphaLayer() || System.currentTimeMillis() - startMessageAppearTransitionMs >= SKELETON_DISAPPEAR_MS) {
//                                    float progress = cell.getAlpha();
//
//                                    MessageSkeleton skeleton;
//                                    if (j >= messageSkeletons.size()) {
//                                        skeleton = getNewSkeleton(noAvatar);
//                                        messageSkeletons.add(skeleton);
//                                    } else {
//                                        skeleton = messageSkeletons.get(j);
//                                    }
//
//                                    Rect bounds = cell.getCurrentBackgroundDrawable(true).getBounds();
//                                    MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
//
//                                    int alpha = skeletonPaint.getAlpha();
//                                    int wasServiceAlpha = servicePaint.getAlpha();
//                                    servicePaint.setAlpha((int) (wasServiceAlpha * 0.4f * (1f - progress)));
//                                    skeletonPaint.setAlpha((int) (alpha * (1f - progress)));
//                                    int bottom = (int) AndroidUtilities.lerp(Math.min(skeleton.lastBottom, lastTop - AndroidUtilities.dp(3f)), v.getBottom() + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0), progress);
//                                    int left = noAvatar ? AndroidUtilities.dp(3f) : AndroidUtilities.dp(51);
//                                    int top = (int) AndroidUtilities.lerp(bottom - skeleton.height, bounds.top + v.getTop() + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0), progress);
//                                    int right = skeleton.width;
//
//                                    boolean lerp = cell.getMessageObject() == null || !cell.getMessageObject().isOut();
//                                    skeletonBackgroundDrawable.setBounds(lerp ? AndroidUtilities.lerp(left, cell.getBackgroundDrawableLeft(), progress) : left, top,
//                                            lerp ? AndroidUtilities.lerp(right, cell.getBackgroundDrawableRight(), progress) : right, bottom);
//                                    Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + skeletonBackgroundDrawable.getBounds().top);
//                                    skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, servicePaint);
//                                    skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonPaint);
//                                    if (!noAvatar) {
//                                        Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + bottom - AndroidUtilities.dp(42));
//                                        canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), servicePaint);
//                                        canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), skeletonPaint);
//                                    }
//                                    servicePaint.setAlpha(wasServiceAlpha);
//                                    skeletonPaint.setAlpha(alpha);
//                                    j++;
//
//                                    if (top < lastTop) {
//                                        lastTop = top;
//                                    }
//
//                                    continue;
//                                }
//                                j++;
//                            }
//                        }
                        if (v instanceof ChatMessageCell) {
                            MessageObject.GroupedMessages group = ((ChatMessageCell) v).getCurrentMessagesGroup();
                            Rect bounds = ((ChatMessageCell) v).getCurrentBackgroundDrawable(true).getBounds();
                            int newTop = (int) (v.getTop() + bounds.top + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0));
                            int top = startMessageAppearTransitionMs == 0 && isSkeletonVisible() ? AndroidUtilities.lerp(lastTop, newTop, v.getAlpha()) : v.getAlpha() == 1f ? newTop : lastTop;
                            if (top < lastTop) {
                                lastTop = top;
                            }
                        } else if (v instanceof ChatActionCell) {
                            int top = startMessageAppearTransitionMs == 0 && isSkeletonVisible() ? AndroidUtilities.lerp(lastTop, v.getTop(), v.getAlpha()) : v.getAlpha() == 1f ? v.getTop() : lastTop;
                            if (top < lastTop) {
                                lastTop = top;
                            }
                        }
                    }

                    if (isSkeletonVisible()) {
                        boolean drawService = SharedConfig.getDevicePerformanceClass() != SharedConfig.PERFORMANCE_CLASS_LOW && Theme.hasGradientService();
                        boolean darkOverlay = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.7f && Theme.hasGradientService();
                        boolean blackOverlay = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.01f && Theme.hasGradientService();
                        if (drawService) {
                            Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() - contentPanTranslation);
                        }
                        int wasDarkenAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                        if (blackOverlay) {
                            Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (wasDarkenAlpha * 4f));
                        }

                        float topSkeletonAlpha = startMessageAppearTransitionMs != 0 ? 1f - (System.currentTimeMillis() - startMessageAppearTransitionMs) / (float) SKELETON_DISAPPEAR_MS : 1f;
                        int alpha = skeletonPaint.getAlpha();
                        int wasServiceAlpha = skeletonServicePaint.getAlpha();
                        int wasOutlineAlpha = skeletonOutlinePaint.getAlpha();
                        skeletonServicePaint.setAlpha((int) (0xFF * topSkeletonAlpha));
                        skeletonPaint.setAlpha((int) (topSkeletonAlpha * alpha));
                        skeletonOutlinePaint.setAlpha((int) (wasOutlineAlpha * alpha));
                        while (lastTop > blurredViewTopOffset) {
                            lastTop -= AndroidUtilities.dp(3f);

                            MessageSkeleton skeleton;
                            if (j >= messageSkeletons.size()) {
                                skeleton = getNewSkeleton(noAvatar);
                                messageSkeletons.add(skeleton);
                            } else {
                                skeleton = messageSkeletons.get(j);
                            }
                            skeleton.lastBottom = startMessageAppearTransitionMs != 0 ? messages.size() <= 2 ? Math.min(skeleton.lastBottom, lastTop) : skeleton.lastBottom : lastTop;

                            lastTop -= skeleton.height;

                            j++;
                        }

                        lastTop = messageSkeletons.isEmpty() ? getHeight() - blurredViewBottomOffset : messageSkeletons.get(0).lastBottom + AndroidUtilities.dp(3f);
                        for (int i = 0; i < messageSkeletons.size() && lastTop > blurredViewTopOffset; i++) {
                            lastTop -= AndroidUtilities.dp(3f);

                            MessageSkeleton skeleton = messageSkeletons.get(i);

                            int bottom = skeleton.lastBottom;
                            skeletonBackgroundDrawable.setBounds(noAvatar ? AndroidUtilities.dp(3f) : AndroidUtilities.dp(51), bottom - skeleton.height, skeleton.width, bottom);
                            if (drawService) {
                                skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonServicePaint);
                            }
                            skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonPaint);
                            if (darkOverlay) {
                                skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, Theme.chat_actionBackgroundGradientDarkenPaint);
                            }
                            skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonOutlinePaint);

                            if (!noAvatar) {
                                if (drawService) {
                                    canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), skeletonServicePaint);
                                }
                                canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), skeletonPaint);
                                if (darkOverlay) {
                                    canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), Theme.chat_actionBackgroundGradientDarkenPaint);
                                }
                                canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), skeletonOutlinePaint);
                            }

                            lastTop -= skeleton.height;
                        }

                        skeletonServicePaint.setAlpha(wasServiceAlpha);
                        skeletonPaint.setAlpha(alpha);
                        skeletonOutlinePaint.setAlpha(wasOutlineAlpha);
                        Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasDarkenAlpha);
                        invalidated = false;
                        invalidate();
                    } else if (System.currentTimeMillis() - startMessageAppearTransitionMs > SKELETON_DISAPPEAR_MS) {
                        messageSkeletons.clear();
                    }
                    lastSkeletonCount = messageSkeletons.size();
                    lastSkeletonMessageCount = messages.size();
                    if (pullingDownOffset != 0) {
                        canvas.restore();
                    }
                }
                super.draw(canvas);
            }

            private void updateSkeletonColors() {
                boolean dark = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.7f;
                int color0 = ColorUtils.blendARGB(getThemedColor(Theme.key_listSelector), Color.argb(dark ? 0x21 : 0x03, 0xFF, 0xFF, 0xFF), dark ? 0.9f : 0.5f);
                int color1 = ColorUtils.setAlphaComponent(getThemedColor(Theme.key_listSelector), dark ? 24 : SKELETON_LIGHT_OVERLAY_ALPHA);
                if (skeletonColor1 != color1 || skeletonColor0 != color0) {
                    skeletonColor0 = color0;
                    skeletonColor1 = color1;
                    skeletonGradient = new LinearGradient(0, 0, skeletonGradientWidth = AndroidUtilities.dp(200), 0, new int[]{color1, color0, color0, color1}, new float[]{0.0f, 0.4f, 0.6f, 1f}, Shader.TileMode.CLAMP);
                    skeletonTotalTranslation = -skeletonGradientWidth * 2;
                    skeletonPaint.setShader(skeletonGradient);

                    int outlineColor = Color.argb(dark ? 0x2B : 0x60, 0xFF, 0xFF, 0xFF);
                    skeletonOutlineGradient = new LinearGradient(0, 0, skeletonGradientWidth, 0, new int[]{Color.TRANSPARENT, outlineColor, outlineColor, Color.TRANSPARENT}, new float[]{0.0f, 0.4f, 0.6f, 1f}, Shader.TileMode.CLAMP);
                    skeletonOutlinePaint.setShader(skeletonOutlineGradient);
                }
            }

            private void updateSkeletonGradient() {
                long newUpdateTime = SystemClock.elapsedRealtime();
                long dt = Math.abs(skeletonLastUpdateTime - newUpdateTime);
                if (dt > 17) {
                    dt = 16;
                }
                if (dt < 4) {
                    dt = 0;
                }
                int width = getWidth();
                skeletonLastUpdateTime = newUpdateTime;
                skeletonTotalTranslation += dt * width / 400.0f;
                if (skeletonTotalTranslation >= width * 2) {
                    skeletonTotalTranslation = -skeletonGradientWidth * 2;
                }
                skeletonMatrix.setTranslate(skeletonTotalTranslation, 0);
                if (skeletonGradient != null) {
                    skeletonGradient.setLocalMatrix(skeletonMatrix);
                }
                skeletonOutlineMatrix.setTranslate(skeletonTotalTranslation, 0);
                if (skeletonOutlineGradient != null) {
                    skeletonOutlineGradient.setLocalMatrix(skeletonOutlineMatrix);
                }
            }

            @Override
            protected void dispatchDraw(Canvas canvas) {
                drawLaterRoundProgressCell = null;
                invalidated = false;

                canvas.save();
                if (fragmentTransition == null || (fromPullingDownTransition && !toPullingDownTransition)) {
                    canvas.clipRect(0, chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4), getMeasuredWidth(), getMeasuredHeight() - blurredViewBottomOffset);
                }
                selectorRect.setEmpty();
                if (pullingDownOffset != 0) {
                    int restoreToCount = canvas.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                    }
                    canvas.translate(0, drawingChatLisViewYoffset = -pullingDownOffset - transitionOffset);
                    drawChatBackgroundElements(canvas);
                    super.dispatchDraw(canvas);
                    drawChatForegroundElements(canvas);
                    canvas.restoreToCount(restoreToCount);
                } else {
                    drawChatBackgroundElements(canvas);
                    super.dispatchDraw(canvas);
                    drawChatForegroundElements(canvas);
                }
                canvas.restore();
            }

            private void drawChatForegroundElements(Canvas canvas) {
                int size = drawTimeAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawTimeAfter.get(a);
                        canvas.save();
                        canvas.translate(cell.getLeft() + cell.getNonAnimationTranslationX(false), cell.getY());
                        cell.drawTime(canvas, cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f, true);
                        canvas.restore();
                    }
                    drawTimeAfter.clear();
                }
                size = drawNamesAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawNamesAfter.get(a);
                        float canvasOffsetX = cell.getLeft() + cell.getNonAnimationTranslationX(false);
                        float canvasOffsetY = cell.getY();
                        float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;

                        canvas.save();
                        canvas.translate(canvasOffsetX, canvasOffsetY);
                        cell.setInvalidatesParent(true);
                        cell.drawNamesLayout(canvas, alpha);
                        cell.setInvalidatesParent(false);
                        canvas.restore();
                    }
                    drawNamesAfter.clear();
                }
                size = drawCaptionAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawCaptionAfter.get(a);
                        boolean selectionOnly = false;
                        if (cell.getCurrentPosition() != null) {
                            selectionOnly = (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0;
                        }
                        float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;
                        float canvasOffsetX = cell.getLeft() + cell.getNonAnimationTranslationX(false);
                        float canvasOffsetY = cell.getY();
                        canvas.save();
                        MessageObject.GroupedMessages groupedMessages = cell.getCurrentMessagesGroup();
                        if (groupedMessages != null && groupedMessages.transitionParams.backgroundChangeBounds) {
                            float x = cell.getNonAnimationTranslationX(true);
                            float l = (groupedMessages.transitionParams.left + x + groupedMessages.transitionParams.offsetLeft);
                            float t = (groupedMessages.transitionParams.top + groupedMessages.transitionParams.offsetTop);
                            float r = (groupedMessages.transitionParams.right + x + groupedMessages.transitionParams.offsetRight);
                            float b = (groupedMessages.transitionParams.bottom + groupedMessages.transitionParams.offsetBottom);

                            if (!groupedMessages.transitionParams.backgroundChangeBounds) {
                                t += cell.getTranslationY();
                                b += cell.getTranslationY();
                            }
                            canvas.clipRect(
                                    l + AndroidUtilities.dp(8), t + AndroidUtilities.dp(8),
                                    r - AndroidUtilities.dp(8), b - AndroidUtilities.dp(8)
                            );
                        }
                        if (cell.getTransitionParams().wasDraw) {
                            canvas.translate(canvasOffsetX, canvasOffsetY);
                            cell.setInvalidatesParent(true);
                            cell.drawCaptionLayout(canvas, selectionOnly, alpha);
                            cell.setInvalidatesParent(false);
                            canvas.restore();
                        }
                    }
                    drawCaptionAfter.clear();
                }
            }

            private void drawChatBackgroundElements(Canvas canvas) {
                int count = getChildCount();
                MessageObject.GroupedMessages lastDrawnGroup = null;

                for (int a = 0; a < count; a++) {
                    View child = getChildAt(a);
                    if (chatAdapter.isBot && child instanceof BotHelpCell) {
                        BotHelpCell botCell = (BotHelpCell) child;
                        float top = (getMeasuredHeight() - chatListViewPaddingTop - blurredViewBottomOffset) / 2 - child.getMeasuredHeight() / 2 + chatListViewPaddingTop;
                        if (!botCell.animating() && !chatListView.fastScrollAnimationRunning) {
                            if (child.getTop() > top) {
                                child.setTranslationY(top - child.getTop());
                            } else {
                                child.setTranslationY(0);
                            }
                        }
                        break;
                    } else if (child instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) child;
                        MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                        if (group == null || group != lastDrawnGroup) {
                            lastDrawnGroup = group;
                            MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                            MessageBackgroundDrawable backgroundDrawable = cell.getBackgroundDrawable();
                            if ((backgroundDrawable.isAnimationInProgress() || cell.isDrawingSelectionBackground()) && (position == null || (position.flags & MessageObject.POSITION_FLAG_RIGHT) != 0)) {
                                if (cell.isHighlighted() || cell.isHighlightedAnimated()) {
                                    if (position == null) {
                                        Paint backgroundPaint = getThemedPaint(Theme.key_paint_chatMessageBackgroundSelected);
                                        if (themeDelegate != null && themeDelegate.isDark || backgroundPaint == null) {
                                            backgroundPaint = Theme.chat_replyLinePaint;
                                            backgroundPaint.setColor(getThemedColor(Theme.key_chat_selectedBackground));
                                        } else {
                                            float viewTop = (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY();
                                            int backgroundHeight = contentView.getBackgroundSizeY();
                                            if (themeDelegate != null) {
                                                themeDelegate.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                            } else {
                                                Theme.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                            }
                                        }
                                        canvas.save();
                                        canvas.translate(0, cell.getTranslationY());
                                        int wasAlpha = backgroundPaint.getAlpha();
                                        backgroundPaint.setAlpha((int) (wasAlpha * cell.getHighlightAlpha() * cell.getAlpha()));
                                        canvas.drawRect(0, cell.getTop(), getMeasuredWidth(), cell.getBottom(), backgroundPaint);
                                        backgroundPaint.setAlpha(wasAlpha);
                                        canvas.restore();
                                    }
                                } else {
                                    int y = (int) cell.getY();
                                    int height;
                                    canvas.save();
                                    if (position == null) {
                                        height = cell.getMeasuredHeight();
                                    } else {
                                        height = y + cell.getMeasuredHeight();
                                        long time = 0;
                                        float touchX = 0;
                                        float touchY = 0;
                                        for (int i = 0; i < count; i++) {
                                            View inner = getChildAt(i);
                                            if (inner instanceof ChatMessageCell) {
                                                ChatMessageCell innerCell = (ChatMessageCell) inner;
                                                MessageObject.GroupedMessages innerGroup = innerCell.getCurrentMessagesGroup();
                                                if (innerGroup == group) {
                                                    MessageBackgroundDrawable drawable = innerCell.getBackgroundDrawable();
                                                    y = Math.min(y, (int) innerCell.getY());
                                                    height = Math.max(height, (int) innerCell.getY() + innerCell.getMeasuredHeight());
                                                    long touchTime = drawable.getLastTouchTime();
                                                    if (touchTime > time) {
                                                        touchX = drawable.getTouchX() + innerCell.getX();
                                                        touchY = drawable.getTouchY() + innerCell.getY();
                                                        time = touchTime;
                                                    }
                                                }
                                            }
                                        }
                                        backgroundDrawable.setTouchCoordsOverride(touchX, touchY - y);
                                        height -= y;
                                    }
                                    canvas.clipRect(0, y, getMeasuredWidth(), y + height);
                                    Paint selectedBackgroundPaint = getThemedPaint(Theme.key_paint_chatMessageBackgroundSelected);
                                    if (themeDelegate != null && !themeDelegate.isDark && selectedBackgroundPaint != null) {
                                        backgroundDrawable.setCustomPaint(selectedBackgroundPaint);
                                        float viewTop = (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY();
                                        int backgroundHeight = contentView.getBackgroundSizeY();
                                        if (themeDelegate != null) {
                                            themeDelegate.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                        } else {
                                            Theme.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                        }
                                    } else {
                                        backgroundDrawable.setCustomPaint(null);
                                        backgroundDrawable.setColor(getThemedColor(Theme.key_chat_selectedBackground));
                                    }
                                    backgroundDrawable.setBounds(0, y, getMeasuredWidth(), y + height);
                                    backgroundDrawable.draw(canvas);
                                    canvas.restore();
                                }
                            }
                        }
                        if (scrimView != cell && group == null && cell.drawBackgroundInParent()) {
                            canvas.save();
                            canvas.translate(cell.getX(), cell.getY());
                            if (cell.getScaleX() != 1f) {
                                canvas.scale(
                                    cell.getScaleX(), cell.getScaleY(),
                                    cell.getPivotX(), (cell.getHeight() >> 1)
                                );
                            }
                            cell.drawBackgroundInternal(canvas, true);
                            canvas.restore();
                        }
                    } else if (child instanceof ChatActionCell) {
                        ChatActionCell cell = (ChatActionCell) child;
                        if (cell.hasGradientService()) {
                            canvas.save();
                            canvas.translate(cell.getX(), cell.getY());
                            canvas.scale(cell.getScaleX(), cell.getScaleY(), cell.getMeasuredWidth() / 2f, cell.getMeasuredHeight() / 2f);
                            cell.drawBackground(canvas, true);
                            canvas.restore();
                        }
                    }
                }
                MessageObject.GroupedMessages scrimGroup = null;
                if (scrimView instanceof ChatMessageCell) {
                    scrimGroup = ((ChatMessageCell) scrimView).getCurrentMessagesGroup();
                }
                for (int k = 0; k < 3; k++) {
                    drawingGroups.clear();
                    if (k == 2 && !chatListView.isFastScrollAnimationRunning()) {
                        continue;
                    }
                    for (int i = 0; i < count; i++) {
                        View child = chatListView.getChildAt(i);
                        if (child instanceof ChatMessageCell) {
                            ChatMessageCell cell = (ChatMessageCell) child;
                            if (child.getY() > chatListView.getHeight() || child.getY() + child.getHeight() < 0) {
                                continue;
                            }
                            MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                            if (group == null || (k == 0 && group.messages.size() == 1) || (k == 1 && !group.transitionParams.drawBackgroundForDeletedItems)) {
                                continue;
                            }
                            if ((k == 0 && cell.getMessageObject().deleted) || (k == 1 && !cell.getMessageObject().deleted)) {
                                continue;
                            }
                            if ((k == 2 && !cell.willRemovedAfterAnimation()) || (k != 2 && cell.willRemovedAfterAnimation())) {
                                continue;
                            }

                            if (!drawingGroups.contains(group)) {
                                group.transitionParams.left = 0;
                                group.transitionParams.top = 0;
                                group.transitionParams.right = 0;
                                group.transitionParams.bottom = 0;

                                group.transitionParams.pinnedBotton = false;
                                group.transitionParams.pinnedTop = false;
                                group.transitionParams.cell = cell;
                                drawingGroups.add(group);
                            }

                            group.transitionParams.pinnedTop = cell.isPinnedTop();
                            group.transitionParams.pinnedBotton = cell.isPinnedBottom();

                            int left = (cell.getLeft() + cell.getBackgroundDrawableLeft());
                            int right = (cell.getLeft() + cell.getBackgroundDrawableRight());
                            int top = (cell.getTop() + cell.getBackgroundDrawableTop());
                            int bottom = (cell.getTop() + cell.getBackgroundDrawableBottom());

                            if ((cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_TOP) == 0) {
                                top -= AndroidUtilities.dp(10);
                            }

                            if ((cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_BOTTOM) == 0) {
                                bottom += AndroidUtilities.dp(10);
                            }

                            if (cell.willRemovedAfterAnimation()) {
                                group.transitionParams.cell = cell;
                            }

                            if (group.transitionParams.top == 0 || top < group.transitionParams.top) {
                                group.transitionParams.top = top;
                            }
                            if (group.transitionParams.bottom == 0 || bottom > group.transitionParams.bottom) {
                                group.transitionParams.bottom = bottom;
                            }
                            if (group.transitionParams.left == 0 || left < group.transitionParams.left) {
                                group.transitionParams.left = left;
                            }
                            if (group.transitionParams.right == 0 || right > group.transitionParams.right) {
                                group.transitionParams.right = right;
                            }
                        }
                    }

                    for (int i = 0; i < drawingGroups.size(); i++) {
                        MessageObject.GroupedMessages group = drawingGroups.get(i);
                        if (group == scrimGroup) {
                            continue;
                        }
                        float x = group.transitionParams.cell.getNonAnimationTranslationX(true);
                        float l = (group.transitionParams.left + x + group.transitionParams.offsetLeft);
                        float t = (group.transitionParams.top + group.transitionParams.offsetTop);
                        float r = (group.transitionParams.right + x + group.transitionParams.offsetRight);
                        float b = (group.transitionParams.bottom + group.transitionParams.offsetBottom);

                        if (!group.transitionParams.backgroundChangeBounds) {
                            t += group.transitionParams.cell.getTranslationY();
                            b += group.transitionParams.cell.getTranslationY();
                        }

                        if (t < chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20)) {
                            t = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20);
                        }

                        if (b > chatListView.getMeasuredHeight() +  AndroidUtilities.dp(20)) {
                            b = chatListView.getMeasuredHeight() + AndroidUtilities.dp(20);
                        }

                        boolean useScale = group.transitionParams.cell.getScaleX() != 1f || group.transitionParams.cell.getScaleY() != 1f;
                        if (useScale) {
                            canvas.save();
                            canvas.scale(group.transitionParams.cell.getScaleX(), group.transitionParams.cell.getScaleY(), l + (r - l) / 2, t + (b - t) / 2);
                        }
                        boolean selected = true;
                        for (int a = 0, N = group.messages.size(); a < N; a++) {
                            MessageObject object = group.messages.get(a);
                            int index = object.getDialogId() == dialog_id ? 0 : 1;
                            if (selectedMessagesIds[index].indexOfKey(object.getId()) < 0) {
                                selected = false;
                                break;
                            }
                        }
                        group.transitionParams.cell.drawBackground(canvas, (int) l, (int) t, (int) r, (int) b, group.transitionParams.pinnedTop, group.transitionParams.pinnedBotton, selected, contentView.getKeyboardHeight());
                        group.transitionParams.cell = null;
                        group.transitionParams.drawCaptionLayout = group.hasCaption;
                        if (useScale) {
                            canvas.restore();
                            for (int ii = 0; ii < count; ii++) {
                                View child = chatListView.getChildAt(ii);
                                if (child instanceof ChatMessageCell && ((ChatMessageCell) child).getCurrentMessagesGroup() == group) {
                                    ChatMessageCell cell = ((ChatMessageCell) child);
                                    int left = cell.getLeft();
                                    int top = cell.getTop();
                                    child.setPivotX(l - left + (r - l) / 2);
                                    child.setPivotY(t - top + (b - t) / 2);
                                }
                            }
                        }
                    }
                }
            }

            @Override
            public boolean drawChild(Canvas canvas, View child, long drawingTime) {
                if (isSkeletonVisible()) {
                    invalidated = false;
                    invalidate();
                }

                int clipLeft = 0;
                int clipBottom = 0;
                boolean skipDraw = child == scrimView;
                ChatMessageCell cell;
                ChatActionCell actionCell = null;
                float cilpTop = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4);

                if (child.getY() > getMeasuredHeight() || child.getY() + child.getMeasuredHeight() < cilpTop) {
                    skipDraw = true;
                }

                MessageObject.GroupedMessages group = null;

                if (child instanceof ChatMessageCell) {
                    cell = (ChatMessageCell) child;
                    if (animateSendingViews.contains(cell)) {
                        skipDraw = true;
                    }
                    MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                    group = cell.getCurrentMessagesGroup();
                    if (position != null) {
                        if (position.pw != position.spanSize && position.spanSize == 1000 && position.siblingHeights == null && group.hasSibling) {
                            clipLeft = cell.getBackgroundDrawableLeft();
                        } else if (position.siblingHeights != null) {
                            clipBottom = child.getBottom() - AndroidUtilities.dp(1 + (cell.isPinnedBottom() ? 1 : 0));
                        }
                    }
                    if (cell.needDelayRoundProgressDraw()) {
                        drawLaterRoundProgressCell = cell;
                    }
                    if (!skipDraw && scrimView instanceof ChatMessageCell) {
                        ChatMessageCell cell2 = (ChatMessageCell) scrimView;
                        if (cell2.getCurrentMessagesGroup() != null && cell2.getCurrentMessagesGroup() == group) {
                            skipDraw = true;
                        }
                    }
                    if (skipDraw) {
                        cell.getPhotoImage().skipDraw();
                    }
                } else if (child instanceof ChatActionCell) {
                    actionCell = (ChatActionCell) child;
                    cell = null;
                } else {
                    cell = null;
                }
                if (clipLeft != 0) {
                    canvas.save();
                } else if (clipBottom != 0) {
                    canvas.save();
                }
                boolean result;
                if (!skipDraw) {
                    boolean clipToGroupBounds = group != null && group.transitionParams.backgroundChangeBounds;
                    if (clipToGroupBounds) {
                        canvas.save();
                        float x = cell.getNonAnimationTranslationX(true);
                        float l = (group.transitionParams.left + x + group.transitionParams.offsetLeft);
                        float t = (group.transitionParams.top + group.transitionParams.offsetTop);
                        float r = (group.transitionParams.right + x + group.transitionParams.offsetRight);
                        float b = (group.transitionParams.bottom + group.transitionParams.offsetBottom);

                        canvas.clipRect(
                                l + AndroidUtilities.dp(4),
                                t + AndroidUtilities.dp(4),
                                r - AndroidUtilities.dp(4),
                                b - AndroidUtilities.dp(4)
                        );
                    }
                    if (cell != null && clipToGroupBounds) {
                        cell.clipToGroupBounds = true;
                        result = super.drawChild(canvas, child, drawingTime);
                        cell.clipToGroupBounds = false;
                    } else {
                        result = super.drawChild(canvas, child, drawingTime);
                    }
                    if (clipToGroupBounds) {
                        canvas.restore();
                    }
                    if (cell != null && cell.hasOutboundsContent()) {
                        canvas.save();
                        canvas.translate(cell.getX(), cell.getY());
                        cell.drawOutboundsContent(canvas);
                        canvas.restore();
                    } else if (actionCell != null) {
                        canvas.save();
                        canvas.translate(actionCell.getX(), actionCell.getY());
                        actionCell.drawOutboundsContent(canvas);
                        canvas.restore();
                    }
                } else {
                    result = false;
                }
                if (clipLeft != 0 || clipBottom != 0) {
                    canvas.restore();
                }

                if (child.getTranslationY() != 0) {
                    canvas.save();
                    canvas.translate(0, child.getTranslationY());
                }

                if (cell != null) {
                    cell.drawCheckBox(canvas);
                }

                if (child.getTranslationY() != 0) {
                    canvas.restore();
                }

                if (child.getTranslationY() != 0) {
                    canvas.save();
                    canvas.translate(0, child.getTranslationY());
                }

                if (cell != null) {
                    MessageObject message = cell.getMessageObject();
                    MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                    if (!skipDraw) {
                        if (position != null || cell.getTransitionParams().animateBackgroundBoundsInner) {
                            if (position == null || (position.last || position.minX == 0 && position.minY == 0)) {
                                if (position == null || position.last) {
                                    drawTimeAfter.add(cell);
                                }
                                if ((position == null || (position.minX == 0 && position.minY == 0)) && cell.hasNameLayout()) {
                                    drawNamesAfter.add(cell);
                                }
                            }
                            if (position != null || cell.getTransitionParams().transformGroupToSingleMessage || cell.getTransitionParams().animateBackgroundBoundsInner) {
                                if (position == null || (position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0) {
                                    drawCaptionAfter.add(cell);
                                }
                            }
                        }

                        if (videoPlayerContainer != null && (message.isRoundVideo() || message.isVideo()) && !message.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(message)) {
                            ImageReceiver imageReceiver = cell.getPhotoImage();
                            float newX = imageReceiver.getImageX() + cell.getX();
                            float newY = cell.getY() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                            if (videoPlayerContainer.getTranslationX() != newX || videoPlayerContainer.getTranslationY() != newY) {
                                videoPlayerContainer.setTranslationX(newX);
                                videoPlayerContainer.setTranslationY(newY);
                                fragmentView.invalidate();
                                videoPlayerContainer.invalidate();
                            }
                        }
                    }
                    ImageReceiver imageReceiver = cell.getAvatarImage();
                    if (imageReceiver != null) {
                        MessageObject.GroupedMessages groupedMessages = getValidGroupedMessage(message);
                        if (cell.getMessageObject().deleted) {
                            if (child.getTranslationY() != 0) {
                                canvas.restore();
                            }
                            imageReceiver.setVisible(false, false);
                            return result;
                        }

                        boolean replaceAnimation = chatListView.isFastScrollAnimationRunning() || (groupedMessages != null && groupedMessages.transitionParams.backgroundChangeBounds);
                        int top = replaceAnimation ? child.getTop() : (int) child.getY();
                        if (cell.drawPinnedBottom()) {
                            int p;
                            if (cell.willRemovedAfterAnimation()) {
                                p = chatScrollHelper.positionToOldView.indexOfValue(child);
                                if (p >= 0) {
                                    p = chatScrollHelper.positionToOldView.keyAt(p);
                                }
                            } else {
                                ViewHolder holder = chatListView.getChildViewHolder(child);
                                p = holder.getAdapterPosition();
                            }

                            if (p >= 0) {
                                int nextPosition;
                                if (groupedMessages != null && position != null) {
                                    int idx = groupedMessages.posArray.indexOf(position);
                                    int size = groupedMessages.posArray.size();
                                    if ((position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0) {
                                        nextPosition = p - size + idx;
                                    } else {
                                        nextPosition = p - 1;
                                        for (int a = idx + 1; a < size; a++) {
                                            if (groupedMessages.posArray.get(a).minY > position.maxY) {
                                                break;
                                            } else {
                                                nextPosition--;
                                            }
                                        }
                                    }
                                } else {
                                    nextPosition = p - 1;
                                }
                                if (cell.willRemovedAfterAnimation()) {
                                     View view = chatScrollHelper.positionToOldView.get(nextPosition);
                                     if (view != null) {
                                         if (child.getTranslationY() != 0) {
                                             canvas.restore();
                                         }
                                         imageReceiver.setVisible(false, false);
                                         return result;
                                     }
                                } else {
                                    ViewHolder holder = chatListView.findViewHolderForAdapterPosition(nextPosition);
                                    if (holder != null) {
                                        if (child.getTranslationY() != 0) {
                                            canvas.restore();
                                        }
                                        imageReceiver.setVisible(false, false);
                                        return result;
                                    }
                                }
                            }
                        }
                        float tx = cell.getSlidingOffsetX() + cell.getCheckBoxTranslation();

                        int y = (int) ((replaceAnimation ? child.getTop() : child.getY()) + cell.getLayoutHeight() + cell.getTransitionParams().deltaBottom);
                        int maxY = chatListView.getMeasuredHeight() - chatListView.getPaddingBottom();
                        if (cell.isPlayingRound() || cell.getTransitionParams().animatePlayingRound) {
                            if (cell.getTransitionParams().animatePlayingRound) {
                                float progressLocal = cell.getTransitionParams().animateChangeProgress;
                                if (!cell.isPlayingRound()) {
                                    progressLocal = 1f - progressLocal;
                                }
                                int fromY = y;
                                int toY = Math.min(y, maxY);
                                y = (int) (fromY * progressLocal + toY * (1f - progressLocal));
                            }
                        } else {
                            if (y > maxY) {
                                y = maxY;
                            }
                        }

                        if (!replaceAnimation && child.getTranslationY() != 0) {
                            canvas.restore();
                        }
                        if (cell.drawPinnedTop()) {
                            int p;
                            if (cell.willRemovedAfterAnimation()) {
                                p = chatScrollHelper.positionToOldView.indexOfValue(child);
                                if (p >= 0) {
                                    p = chatScrollHelper.positionToOldView.keyAt(p);
                                }
                            } else {
                                ViewHolder holder = chatListView.getChildViewHolder(child);
                                p = holder.getAdapterPosition();
                            }
                            if (p >= 0) {
                                int tries = 0;
                                while (true) {
                                    if (tries >= 20) {
                                        break;
                                    }
                                    tries++;

                                    int prevPosition;
                                    if (groupedMessages != null && position != null) {
                                        int idx = groupedMessages.posArray.indexOf(position);
                                        if (idx < 0) {
                                            break;
                                        }
                                        int size = groupedMessages.posArray.size();
                                        if ((position.flags & MessageObject.POSITION_FLAG_TOP) != 0) {
                                            prevPosition = p + idx + 1;
                                        } else {
                                            prevPosition = p + 1;
                                            for (int a = idx - 1; a >= 0; a--) {
                                                if (groupedMessages.posArray.get(a).maxY < position.minY) {
                                                    break;
                                                } else {
                                                    prevPosition++;
                                                }
                                            }
                                        }
                                    } else {
                                        prevPosition = p + 1;
                                    }
                                    if (cell.willRemovedAfterAnimation()) {
                                        View view = chatScrollHelper.positionToOldView.get(prevPosition);
                                        if (view != null) {
                                            top = view.getTop();
                                            if (view instanceof ChatMessageCell) {
                                                cell = (ChatMessageCell) view;
                                                if (!cell.drawPinnedTop()) {
                                                    break;
                                                } else {
                                                    p = prevPosition;
                                                }
                                            } else {
                                                break;
                                            }
                                        } else {
                                            break;
                                        }
                                    } else {
                                        ViewHolder holder = chatListView.findViewHolderForAdapterPosition(prevPosition);
                                        if (holder != null) {
                                            top = holder.itemView.getTop();
                                            if (holder.itemView instanceof ChatMessageCell) {
                                                cell = (ChatMessageCell) holder.itemView;
                                                if (!cell.drawPinnedTop()) {
                                                    break;
                                                } else {
                                                    p = prevPosition;
                                                }
                                            } else {
                                                break;
                                            }
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (y - AndroidUtilities.dp(48) < top) {
                            y = top + AndroidUtilities.dp(48);
                        }
                        if (!cell.drawPinnedBottom()) {
                            int cellBottom = replaceAnimation ? cell.getBottom() : (int) (cell.getY() + cell.getMeasuredHeight() + cell.getTransitionParams().deltaBottom);
                            if (y > cellBottom) {
                                y = cellBottom;
                            }
                        }
                        canvas.save();
                        if (tx != 0) {
                            canvas.translate(tx, 0);
                        }
                        if (cell.getCurrentMessagesGroup() != null) {
                            if (cell.getCurrentMessagesGroup().transitionParams.backgroundChangeBounds) {
                                y -= cell.getTranslationY();
                            }
                        }
                        imageReceiver.setImageY(y - AndroidUtilities.dp(44));
                        if (cell.shouldDrawAlphaLayer()) {
                            imageReceiver.setAlpha(cell.getAlpha());
                            canvas.scale(
                                    cell.getScaleX(), cell.getScaleY(),
                                    cell.getX() + cell.getPivotX(), cell.getY() + (cell.getHeight() >> 1)
                            );
                        } else {
                            imageReceiver.setAlpha(1f);
                        }
                        imageReceiver.setVisible(true, false);
                        imageReceiver.draw(canvas);
                        canvas.restore();

                        if (!replaceAnimation && child.getTranslationY() != 0) {
                            canvas.save();
                        }
                    }
                }

                if (child.getTranslationY() != 0) {
                    canvas.restore();
                }
                return result;
            }

            @Override
            public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
                if (currentEncryptedChat != null) {
                    return;
                }
                super.onInitializeAccessibilityNodeInfo(info);
                if (Build.VERSION.SDK_INT >= 19) {
                    AccessibilityNodeInfo.CollectionInfo collection = info.getCollectionInfo();
                    if (collection != null) {
                        info.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(collection.getRowCount(), 1, false));
                    }
                }
            }

            @Override
            public AccessibilityNodeInfo createAccessibilityNodeInfo() {
                if (currentEncryptedChat != null) {
                    return null;
                }
                return super.createAccessibilityNodeInfo();
            }

            @Override
            public void invalidate() {
                if (invalidated && slidingView == null) {
                    return;
                }
                invalidated = true;
                super.invalidate();
                contentView.invalidateBlur();
                if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
                    selectionReactionsOverlay.invalidatePosition();
                }
            }

            @Override
            public void onScrolled(int dx, int dy) {
                super.onScrolled(dx, dy);
            }

            @Override
            public void onScrollStateChanged(int state) {
                super.onScrollStateChanged(state);
            }

            @Override
            protected void onScrollChanged(int l, int t, int oldl, int oldt) {
                super.onScrollChanged(l, t, oldl, oldt);
            }

            @Override
            public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
                super.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            }

            @Override
            protected void onAttachedToWindow() {
                super.onAttachedToWindow();
                chatListViewAttached = true;
            }

            @Override
            protected void onDetachedFromWindow() {
                super.onDetachedFromWindow();
                chatListViewAttached = false;
                clearMessagesPreloading();
            }
        };
        if (currentEncryptedChat != null && Build.VERSION.SDK_INT >= 19) {
            chatListView.setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_NO_HIDE_DESCENDANTS);
        }
        chatListView.setAccessibilityEnabled(false);
        chatListView.setNestedScrollingEnabled(false);
        chatListView.setInstantClick(true);
        chatListView.setDisableHighlightState(true);
        chatListView.setTag(1);
        chatListView.setVerticalScrollBarEnabled(!SharedConfig.chatBlurEnabled());
        chatListView.setAdapter(chatAdapter = new ChatActivityAdapter(context));
        chatListView.setClipToPadding(false);
        chatListView.setAnimateEmptyView(true, RecyclerListView.EMPTY_VIEW_ANIMATION_TYPE_ALPHA_SCALE);
        chatListView.setScrollBarStyle(View.SCROLLBARS_OUTSIDE_OVERLAY);
        chatListViewPaddingTop = 0;
        invalidateChatListViewTopPadding();
        //配置聊天列表动画
        if (MessagesController.getGlobalMainSettings().getBoolean("view_animations", true)) {
            chatListItemAnimator = new ChatListItemAnimator(this, chatListView, themeDelegate) {

                Runnable finishRunnable;

                @Override
                public void checkIsRunning() {
                    if (scrollAnimationIndex == -1) {
                        scrollAnimationIndex = getNotificationCenter().setAnimationInProgress(scrollAnimationIndex, allowedNotificationsDuringChatListAnimations, false);
                    }
                }

                @Override
                public void onAnimationStart() {
                    scrollAnimationIndex = getNotificationCenter().setAnimationInProgress(scrollAnimationIndex, allowedNotificationsDuringChatListAnimations, false);
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                        finishRunnable = null;
                    }
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("chatItemAnimator disable notifications");
                    }
                    chatActivityEnterView.getAdjustPanLayoutHelper().runDelayedAnimation();
                    chatActivityEnterView.runEmojiPanelAnimation();
                }

                @Override
                protected void onAllAnimationsDone() {
                    super.onAllAnimationsDone();
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                        finishRunnable = null;
                    }
                    AndroidUtilities.runOnUIThread(finishRunnable = () -> {
                        finishRunnable = null;
                        if (scrollAnimationIndex != -1) {
                            getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
                            scrollAnimationIndex = -1;
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("chatItemAnimator enable notifications");
                        }
                    });
                }


                @Override
                public void endAnimations() {
                    super.endAnimations();
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                    }
                    AndroidUtilities.runOnUIThread(finishRunnable = () -> {
                        finishRunnable = null;
                        if (scrollAnimationIndex != -1) {
                            getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
                            scrollAnimationIndex = -1;
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("chatItemAnimator enable notifications");
                        }
                    });
                }
            };
        }

        //配置聊天列表管理类
        chatLayoutManager = new GridLayoutManagerFixed(context, 1000, LinearLayoutManager.VERTICAL, true) {

            boolean computingScroll;

            @Override
            public int getStartForFixGap() {
                int padding = (int) chatListViewPaddingTop;
                if (isThreadChat() && (!isTopic || topicStarterMessageObject != null) && pinnedMessageView != null && pinnedMessageView.getVisibility() == View.VISIBLE) {
                    padding -= Math.max(0, AndroidUtilities.dp(48) + pinnedMessageEnterOffset);
                }
                return padding;
            }

            @Override
            protected int getParentStart() {
                if (computingScroll) {
                    return (int) chatListViewPaddingTop;
                }
                return 0;
            }

            @Override
            public int getStartAfterPadding() {
                if (computingScroll) {
                    return (int) chatListViewPaddingTop;
                }
                return super.getStartAfterPadding();
            }

            @Override
            public int getTotalSpace() {
                if (computingScroll) {
                    return (int) (getHeight() - chatListViewPaddingTop - getPaddingBottom());
                }
                return super.getTotalSpace();
            }

            @Override
            public int computeVerticalScrollExtent(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollExtent(state);
                computingScroll = false;
                return r;
            }

            @Override
            public int computeVerticalScrollOffset(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollOffset(state);
                computingScroll = false;
                return r;
            }

            @Override
            public int computeVerticalScrollRange(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollRange(state);
                computingScroll = false;
                return r;
            }

            @Override
            public void scrollToPositionWithOffset(int position, int offset, boolean bottom) {
                if (!bottom) {
                    offset = (int) (offset - getPaddingTop() + chatListViewPaddingTop);
                }
                super.scrollToPositionWithOffset(position, offset, bottom);
            }

            @Override
            public boolean supportsPredictiveItemAnimations() {
                return true;
            }

            @Override
            public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
                scrollByTouch = false;
                LinearSmoothScrollerCustom linearSmoothScroller = new LinearSmoothScrollerCustom(recyclerView.getContext(), LinearSmoothScrollerCustom.POSITION_MIDDLE);
                linearSmoothScroller.setTargetPosition(position);
                startSmoothScroll(linearSmoothScroller);
            }

            @Override
            public boolean shouldLayoutChildFromOpositeSide(View child) {
                if (child instanceof ChatMessageCell) {
                    return !((ChatMessageCell) child).getMessageObject().isOutOwner();
                }
                return false;
            }


            @Override
            protected boolean hasSiblingChild(int position) {
                if (position >= chatAdapter.messagesStartRow && position < chatAdapter.messagesEndRow) {
                    int index = position - chatAdapter.messagesStartRow;
                    if (index >= 0 && index < messages.size()) {
                        MessageObject message = messages.get(index);
                        MessageObject.GroupedMessages group = getValidGroupedMessage(message);
                        if (group != null) {
                            MessageObject.GroupedMessagePosition pos = group.positions.get(message);
                            if (pos.minX == pos.maxX || pos.minY != pos.maxY || pos.minY == 0) {
                                return false;
                            }
                            int count = group.posArray.size();
                            for (int a = 0; a < count; a++) {
                                MessageObject.GroupedMessagePosition p = group.posArray.get(a);
                                if (p == pos) {
                                    continue;
                                }
                                if (p.minY <= pos.minY && p.maxY >= pos.minY) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }

            @Override
            public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                if (BuildVars.DEBUG_PRIVATE_VERSION) {
                    super.onLayoutChildren(recycler, state);
                } else {
                    try {
                        super.onLayoutChildren(recycler, state);
                    } catch (Exception e) {
                        FileLog.e(e);
                        AndroidUtilities.runOnUIThread(() -> chatAdapter.notifyDataSetChanged(false));
                    }
                }
            }

            @Override
            public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
                if (dy < 0 && pullingDownOffset != 0) {
                    pullingDownOffset += dy;
                    if (pullingDownOffset < 0) {
                        dy = (int) pullingDownOffset;
                        pullingDownOffset = 0;
                        chatListView.invalidate();
                    } else {
                        dy = 0;
                    }
                }

                int n = chatListView.getChildCount();
                int scrolled = 0;
                boolean foundTopView = false;
                for (int i = 0; i < n; i++) {
                    View child = chatListView.getChildAt(i);
                    float padding = chatListViewPaddingTop;
                    if (isThreadChat() && (!isTopic || topicStarterMessageObject != null) && pinnedMessageView != null && pinnedMessageView.getVisibility() == View.VISIBLE) {
                        padding -= Math.max(0, AndroidUtilities.dp(48) + pinnedMessageEnterOffset);
                    }
                    if (chatListView.getChildAdapterPosition(child) == chatAdapter.getItemCount() - 1) {
                        int dyLocal = dy;
                        if (child.getTop() - dy > padding) {
                            dyLocal = (int) (child.getTop() - padding);
                        }
                        scrolled = super.scrollVerticallyBy(dyLocal, recycler, state);
                        foundTopView = true;
                        break;
                    }
                }
                if (!foundTopView) {
                    scrolled = super.scrollVerticallyBy(dy, recycler, state);
                }
                if (dy > 0 && scrolled == 0 && ChatObject.isChannel(currentChat) && !currentChat.megagroup && chatListView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING && !chatListView.isFastScrollAnimationRunning() && !chatListView.isMultiselect() && reportType < 0) {
                    if (pullingDownOffset == 0 && pullingDownDrawable != null) {
                        pullingDownDrawable.updateDialog();
                    }
                    if (pullingDownBackAnimator != null) {
                        pullingDownBackAnimator.removeAllListeners();
                        pullingDownBackAnimator.cancel();
                    }

                    float k;
                    if (pullingDownOffset < AndroidUtilities.dp(110)) {
                        float progress = pullingDownOffset / AndroidUtilities.dp(110);
                        k = 0.65f * (1f - progress) + 0.45f * progress;
                    } else if (pullingDownOffset < AndroidUtilities.dp(160)) {
                        float progress = (pullingDownOffset - AndroidUtilities.dp(110)) / AndroidUtilities.dp(50);
                        k = 0.45f * (1f - progress) + 0.05f * progress;
                    } else {
                        k = 0.05f;
                    }

                    pullingDownOffset += dy * k;
                    ReactionsEffectOverlay.onScrolled((int) (dy * k));
                    chatListView.invalidate();
                }
                if (pullingDownOffset == 0) {
                    chatListView.setOverScrollMode(View.OVER_SCROLL_ALWAYS);
                } else {
                    chatListView.setOverScrollMode(View.OVER_SCROLL_NEVER);
                }
                if (pullingDownDrawable != null) {
                    pullingDownDrawable.showBottomPanel(pullingDownOffset > 0 && chatListView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING);
                }
                return scrolled;
            }
        };
        chatLayoutManager.setSpanSizeLookup(new GridLayoutManagerFixed.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                if (position >= chatAdapter.messagesStartRow && position < chatAdapter.messagesEndRow) {
                    int idx = position - chatAdapter.messagesStartRow;
                    if (idx >= 0 && idx < messages.size()) {
                        MessageObject message = messages.get(idx);
                        MessageObject.GroupedMessages groupedMessages = getValidGroupedMessage(message);
                        if (groupedMessages != null) {
                            return groupedMessages.positions.get(message).spanSize;
                        }
                    }
                }
                return 1000;
            }
        });
        chatListView.setLayoutManager(chatLayoutManager);
        //配置聊天列表分隔符
        chatListView.addItemDecoration(new RecyclerView.ItemDecoration() {
            @Override
            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                outRect.bottom = 0;
                if (view instanceof ChatMessageCell) {
                    ChatMessageCell cell = (ChatMessageCell) view;
                    MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                    if (group != null) {
                        MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                        if (position != null && position.siblingHeights != null) {
                            float maxHeight = Math.max(AndroidUtilities.displaySize.x, AndroidUtilities.displaySize.y) * 0.5f;
                            int h = cell.getExtraInsetHeight();
                            for (int a = 0; a < position.siblingHeights.length; a++) {
                                h += (int) Math.ceil(maxHeight * position.siblingHeights[a]);
                            }
                            h += (position.maxY - position.minY) * Math.round(7 * AndroidUtilities.density);
                            int count = group.posArray.size();
                            for (int a = 0; a < count; a++) {
                                MessageObject.GroupedMessagePosition pos = group.posArray.get(a);
                                if (pos.minY != position.minY || pos.minX == position.minX && pos.maxX == position.maxX && pos.minY == position.minY && pos.maxY == position.maxY) {
                                    continue;
                                }
                                if (pos.minY == position.minY) {
                                    h -= (int) Math.ceil(maxHeight * pos.ph) - AndroidUtilities.dp(4);
                                    break;
                                }
                            }
                            outRect.bottom = -h;
                        }
                    }
                }
            }
        });
        //配置聊天列表长按回调
        chatListView.setOnItemLongClickListener(onItemLongClickListener);
        //配置聊天列表点击回调
        chatListView.setOnItemClickListener(onItemClickListener);
        //配置聊天列表滚动回调
        chatListView.setOnScrollListener(new RecyclerView.OnScrollListener() {

            private float totalDy = 0;
            private boolean scrollUp;
            private final int scrollValue = AndroidUtilities.dp(100);

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == RecyclerView.SCROLL_STATE_IDLE) {
                    if (pollHintCell != null) {
                        pollHintView.showForMessageCell(pollHintCell, -1, pollHintX, pollHintY, true);
                        pollHintCell = null;
                    }
                    scrollingFloatingDate = false;
                    scrollingChatListView = false;
                    checkTextureViewPosition = false;
                    hideFloatingDateView(true);
                    checkAutoDownloadMessages(scrollUp);
                    if (SharedConfig.getDevicePerformanceClass() == SharedConfig.PERFORMANCE_CLASS_LOW) {
                        NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.startAllHeavyOperations, 512);
                    }
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.startSpoilers);
                    chatListView.setOverScrollMode(RecyclerView.OVER_SCROLL_ALWAYS);
                    textSelectionHelper.stopScrolling();
                    updateVisibleRows();
                    scrollByTouch = false;
                } else {
                    if (newState == RecyclerView.SCROLL_STATE_SETTLING) {
                        wasManualScroll = true;
                        scrollingChatListView = true;
                    } else if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                        pollHintCell = null;
                        wasManualScroll = true;
                        scrollingFloatingDate = true;
                        checkTextureViewPosition = true;
                        scrollingChatListView = true;
                    }
                    //滑动时，如果检测机器是低性能，则停止其他高性能消耗的操作
                    if (SharedConfig.getDevicePerformanceClass() == SharedConfig.PERFORMANCE_CLASS_LOW) {
                        NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.stopAllHeavyOperations, 512);
                    }
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.stopSpoilers);

                    if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
                        selectionReactionsOverlay.setHiddenByScroll(true);
                    }
                }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                chatListView.invalidate();
                scrollUp = dy < 0;
                int firstVisibleItem = chatLayoutManager.findFirstVisibleItemPosition();
                if (dy != 0 && (scrollByTouch && recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_SETTLING) || recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    if (forceNextPinnedMessageId != 0) {
                        if ((!scrollUp || forceScrollToFirst)) {
                            forceNextPinnedMessageId = 0;
                        } else if (!chatListView.isFastScrollAnimationRunning() && firstVisibleItem != RecyclerView.NO_POSITION) {
                            int lastVisibleItem = chatLayoutManager.findLastVisibleItemPosition();
                            MessageObject messageObject = null;
                            boolean foundForceNextPinnedView = false;
                            for (int i = lastVisibleItem; i >= firstVisibleItem; i--) {
                                View view = chatLayoutManager.findViewByPosition(i);
                                if (view instanceof ChatMessageCell) {
                                    messageObject = ((ChatMessageCell) view).getMessageObject();
                                } else if (view instanceof ChatActionCell) {
                                    messageObject = ((ChatActionCell) view).getMessageObject();
                                }
                                if (messageObject != null) {
                                    if (forceNextPinnedMessageId == messageObject.getId()) {
                                        foundForceNextPinnedView = true;
                                        break;
                                    }
                                }
                            }
                            if (!foundForceNextPinnedView && messageObject != null && messageObject.getId() < forceNextPinnedMessageId) {
                                forceNextPinnedMessageId = 0;
                            }
                        }

                    }
                }
                if (recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    forceScrollToFirst = false;
                    if (!wasManualScroll && dy != 0) {
                        wasManualScroll = true;
                    }
                }
                if (dy != 0) {
                    hideHints(true);
                }
                if (dy != 0 && scrollingFloatingDate && !currentFloatingTopIsNotMessage) {
                    if (highlightMessageId != Integer.MAX_VALUE) {
                        removeSelectedMessageHighlight();
                        updateVisibleRows();
                    }
                    showFloatingDateView(true);
                }
                checkScrollForLoad(true);
                if (firstVisibleItem != RecyclerView.NO_POSITION) {
                    int totalItemCount = chatAdapter.getItemCount();
                    if (firstVisibleItem == 0 && forwardEndReached[0]) {
                        if (dy >= 0) {
                            canShowPagedownButton = false;
                            updatePagedownButtonVisibility(true);
                        }
                    } else {
                        if (dy > 0) {
                            if (pagedownButton.getTag() == null) {
                                totalDy += dy;
                                if (totalDy > scrollValue) {
                                    totalDy = 0;
                                    canShowPagedownButton = true;
                                    updatePagedownButtonVisibility(true);
                                    pagedownButtonShowedByScroll = true;
                                }
                            }
                        } else {
                            if (pagedownButtonShowedByScroll && pagedownButton.getTag() != null) {
                                totalDy += dy;
                                if (totalDy < -scrollValue) {
                                    canShowPagedownButton = false;
                                    updatePagedownButtonVisibility(true);
                                    totalDy = 0;
                                }
                            }
                        }
                    }
                }
                invalidateMessagesVisiblePart();
                textSelectionHelper.onParentScrolled();
                emojiAnimationsOverlay.onScrolled(dy);
                ReactionsEffectOverlay.onScrolled(dy);

                checkTranslation(false);
            }
        });

        contentView.addView(chatListView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        selectionReactionsOverlay = new ChatSelectionReactionMenuOverlay(this, context);
        contentView.addView(selectionReactionsOverlay, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        animatingImageView = new ClippingImageView(context);
        animatingImageView.setVisibility(View.GONE);
        contentView.addView(animatingImageView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        progressView = new FrameLayout(context);
        progressView.setVisibility(View.INVISIBLE);
        contentView.addView(progressView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.TOP | Gravity.LEFT));

        progressView2 = new View(context);
        progressView2.setBackground(Theme.createServiceDrawable(AndroidUtilities.dp(18), progressView2, contentView, getThemedPaint(Theme.key_paint_chatActionBackground)));
        progressView.addView(progressView2, LayoutHelper.createFrame(36, 36, Gravity.CENTER));

        progressBar = new RadialProgressView(context, themeDelegate);
        progressBar.setSize(AndroidUtilities.dp(28));
        progressBar.setProgressColor(getThemedColor(Theme.key_chat_serviceText));
        progressView.addView(progressBar, LayoutHelper.createFrame(32, 32, Gravity.CENTER));

        //日期浮窗
        floatingDateView = new ChatActionCell(context, false, themeDelegate) {

            @Override
            public void setTranslationY(float translationY) {
                if (getTranslationY() != translationY) {
                    invalidate();
                }
                super.setTranslationY(translationY);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent ev) {
                if (getAlpha() == 0 || actionBar.isActionModeShowed() || reportType >= 0) {
                    return false;
                }
                return super.onInterceptTouchEvent(ev);
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                if (getAlpha() == 0 || actionBar.isActionModeShowed() || reportType >= 0) {
                    return false;
                }
                return super.onTouchEvent(event);
            }

            @Override
            protected void onDraw(Canvas canvas) {
                float clipTop = chatListView.getY() + chatListViewPaddingTop - getY();
                clipTop -= AndroidUtilities.dp(4);
                if (clipTop > 0) {
                    if (clipTop < getMeasuredHeight()) {
                        canvas.save();
                        canvas.clipRect(0, clipTop, getMeasuredWidth(), getMeasuredHeight());
                        super.onDraw(canvas);
                        canvas.restore();
                    }
                } else {
                    super.onDraw(canvas);
                }
            }
        };
        floatingDateView.setCustomDate((int) (System.currentTimeMillis() / 1000), false, false);
        floatingDateView.setAlpha(0.0f);
        floatingDateView.setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_NO);
        floatingDateView.setInvalidateColors(true);
        contentView.addView(floatingDateView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.CENTER_HORIZONTAL, 0, 4, 0, 0));
        //浮窗形式下的跳转
        floatingDateView.setOnClickListener(view -> {
            if (floatingDateView.getAlpha() == 0 || actionBar.isActionModeShowed() || reportType >= 0) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((long) floatingDateView.getCustomDate() * 1000);
            int year = calendar.get(Calendar.YEAR);
            int monthOfYear = calendar.get(Calendar.MONTH);
            int dayOfMonth = calendar.get(Calendar.DAY_OF_MONTH);

            calendar.clear();
            calendar.set(year, monthOfYear, dayOfMonth);
            jumpToDate((int) (calendar.getTime().getTime() / 1000));
        });

        if (currentChat != null) {
            pendingRequestsDelegate = new ChatActivityMemberRequestsDelegate(this, currentChat, this::invalidateChatListViewTopPadding);
            pendingRequestsDelegate.setChatInfo(chatInfo, false);
            contentView.addView(pendingRequestsDelegate.getView(), ViewGroup.LayoutParams.MATCH_PARENT, pendingRequestsDelegate.getViewHeight());
        }

        pinnedMessageView = null;

        undoView = null;
        topUndoView = null;
        topChatPanelView = null;
        reportSpamButton = null;
        emojiStatusSpamHint = null;
        topViewSeparator1 = null;
        topViewSeparator2 = null;
        topViewSeparator3 = null;
        addToContactsButton = null;
        restartTopicButton = null;
        closeReportSpam = null;
        translateButton = null;

        //跳转底部按钮
        pagedownButton = new FrameLayout(context);
        pagedownButton.setVisibility(View.INVISIBLE);
        contentView.addView(pagedownButton, LayoutHelper.createFrame(66, 61, Gravity.RIGHT | Gravity.BOTTOM, 0, 0, -3, 5));
        pagedownButton.setOnClickListener(view -> onPageDownClicked());

        //提及跳转按钮
        mentiondownButton = new FrameLayout(context);
        mentiondownButton.setVisibility(View.INVISIBLE);
        contentView.addView(mentiondownButton, LayoutHelper.createFrame(46, 61, Gravity.RIGHT | Gravity.BOTTOM, 0, 0, 7, 5));
        mentiondownButton.setOnClickListener(new View.OnClickListener() {

            private void loadLastUnreadMention() {
                wasManualScroll = true;
                if (hasAllMentionsLocal) {
                    getMessagesStorage().getUnreadMention(dialog_id, getTopicId(), param -> {
                        if (param == 0) {
                            hasAllMentionsLocal = false;
                            loadLastUnreadMention();
                        } else {
                            scrollToMessageId(param, 0, false, 0, true, 0);
                        }
                    });
                } else {
                    final MessagesStorage messagesStorage = getMessagesStorage();
                    TLRPC.TL_messages_getUnreadMentions req = new TLRPC.TL_messages_getUnreadMentions();
                    req.peer = getMessagesController().getInputPeer(dialog_id);
                    req.limit = 1;
                    if (isTopic) {
                        req.top_msg_id = threadMessageId;
                        req.flags |= 1;
                    }
                    req.add_offset = newMentionsCount - 1;
                    getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                        TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                        if (error != null || res.messages.isEmpty()) {
                            if (res != null) {
                                newMentionsCount = res.count;
                            } else {
                                newMentionsCount = 0;
                            }
                            messagesStorage.resetMentionsCount(dialog_id, getTopicId(), newMentionsCount);
                            if (newMentionsCount == 0) {
                                hasAllMentionsLocal = true;
                                showMentionDownButton(false, true);
                            } else {
                                mentiondownButtonCounter.setText(String.format("%d", newMentionsCount));
                                loadLastUnreadMention();
                            }
                        } else {
                            int id = res.messages.get(0).id;
                            MessageObject object = messagesDict[0].get(id);
                            messagesStorage.markMessageAsMention(dialog_id, id);
                            if (object != null) {
                                object.messageOwner.media_unread = true;
                                object.messageOwner.mentioned = true;
                            }
                            scrollToMessageId(id, 0, false, 0, true, 0);
                        }
                    }));
                }
            }

            @Override
            public void onClick(View view) {
                loadLastUnreadMention();
            }
        });
        mentiondownButton.setOnLongClickListener(view -> {
            scrimPopupWindow = ReadAllMentionsMenu.show(ReadAllMentionsMenu.TYPE_MENTIONS, getParentActivity(), getParentLayout(), contentView, view, getResourceProvider(), () -> {
                for (int a = 0; a < messages.size(); a++) {
                    MessageObject messageObject = messages.get(a);
                    if (messageObject.messageOwner.mentioned && !messageObject.isContentUnread()) {
                        messageObject.setContentIsRead();
                    }
                }
                newMentionsCount = 0;
                getMessagesController().markMentionsAsRead(dialog_id, getTopicId());
                hasAllMentionsLocal = true;
                showMentionDownButton(false, true);
                if (scrimPopupWindow != null) {
                    scrimPopupWindow.dismiss();
                }
            });
            dimBehindView(mentiondownButton, true);
            scrimPopupWindow.setOnDismissListener(() -> {
                scrimPopupWindow = null;
                menuDeleteItem = null;
                scrimPopupWindowItems = null;
                chatLayoutManager.setCanScrollVertically(true);
                dimBehindView(false);
                if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                    chatActivityEnterView.getEditField().setAllowDrawCursor(true);
                }
            });
            view.performHapticFeedback(HapticFeedbackConstants.LONG_PRESS, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
            return true;
        });

        updateMessageListAccessibilityVisibility();

        reactionsMentiondownButton = new FrameLayout(context);
        contentView.addView(reactionsMentiondownButton, LayoutHelper.createFrame(46, 61, Gravity.RIGHT | Gravity.BOTTOM, 0, 0, 7, 5));

        //输入@显示用户名
        mentionContainer = new MentionsContainerView(context, dialog_id, threadMessageId, ChatActivity.this, themeDelegate) {

            @Override
            protected boolean canOpen() {
                return bottomOverlay.getVisibility() != View.VISIBLE || searchingForUser;
            }

            @Override
            protected void onOpen() {
                if (allowStickersPanel && (!getAdapter().isBotContext() || (allowContextBotPanel || allowContextBotPanelSecond))) {
                    if (currentEncryptedChat != null && getAdapter().isBotContext()) {
                        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
                        if (!preferences.getBoolean("secretbot", false)) {
                            AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                            builder.setTitle(LocaleController.getString("AppName", R.string.AppName));
                            builder.setMessage(LocaleController.getString("SecretChatContextBotAlert", R.string.SecretChatContextBotAlert));
                            builder.setPositiveButton(LocaleController.getString("OK", R.string.OK), null);
                            showDialog(builder.create());
                            preferences.edit().putBoolean("secretbot", true).commit();
                        }
                    }
                }
                updateMessageListAccessibilityVisibility();
            }

            @Override
            protected void onClose() {
                updateMessageListAccessibilityVisibility();
            }

            @Override
            protected void onContextSearch(boolean searching) {
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setCaption(getAdapter().getBotCaption());
                    chatActivityEnterView.showContextProgress(searching);
                }
            }

            @Override
            protected void onContextClick(TLRPC.BotInlineResult result) {
                if (getParentActivity() == null || result.content == null) {
                    return;
                }
                if (result.type.equals("video") || result.type.equals("web_player_video")) {
                    int[] size = MessageObject.getInlineResultWidthAndHeight(result);
                    EmbedBottomSheet.show(ChatActivity.this, null, botContextProvider, result.title != null ? result.title : "", result.description, result.content.url, result.content.url, size[0], size[1], isKeyboardVisible());
                } else {
                    processExternalUrl(0, result.content.url, null, null, false);
                }
            }

            private boolean wasAtTop = true;
            @Override
            protected void onScrolled(boolean atTop, boolean atBottom) {
                if (wasAtTop != atTop) {
                    AndroidUtilities.updateViewShow(suggestEmojiPanel, atTop, false, true);
                    wasAtTop = atTop;
                }
            }
        };
        contentView.addView(mentionContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 110, Gravity.LEFT | Gravity.BOTTOM));

        final ContentPreviewViewer.ContentPreviewViewerDelegate contentPreviewViewerDelegate = new ContentPreviewViewer.ContentPreviewViewerDelegate() {
            @Override
            public void sendSticker(TLRPC.Document sticker, String query, Object parent, boolean notify, int scheduleDate) {
                chatActivityEnterView.onStickerSelected(sticker, query, parent, null, true, notify, scheduleDate);
            }

            @Override
            public boolean needSend(int contentType) {
                return true;
            }

            @Override
            public boolean canSchedule() {
                return ChatActivity.this.canScheduleMessage();
            }

            @Override
            public boolean isInScheduleMode() {
                return chatMode == MODE_SCHEDULED;
            }

            @Override
            public void openSet(TLRPC.InputStickerSet set, boolean clearsInputField) {
                if (set == null || getParentActivity() == null) {
                    return;
                }
                TLRPC.TL_inputStickerSetID inputStickerSet = new TLRPC.TL_inputStickerSetID();
                inputStickerSet.access_hash = set.access_hash;
                inputStickerSet.id = set.id;
                StickersAlert alert = new StickersAlert(getParentActivity(), ChatActivity.this, inputStickerSet, null, chatActivityEnterView, themeDelegate);
                alert.setCalcMandatoryInsets(isKeyboardVisible());
                alert.setClearsInputField(clearsInputField);
                showDialog(alert);
            }

            @Override
            public long getDialogId() {
                return dialog_id;
            }
        };
        mentionContainer.getListView().setOnTouchListener((v, event) -> ContentPreviewViewer.getInstance().onTouch(event, mentionContainer.getListView(), 0, mentionsOnItemClickListener, mentionContainer.getAdapter().isStickers() ? contentPreviewViewerDelegate : null, themeDelegate));
        if (!ChatObject.isChannel(currentChat) || currentChat.megagroup) {
            mentionContainer.getAdapter().setBotInfo(botInfo);
        }
        mentionContainer.getAdapter().setParentFragment(this);
        mentionContainer.getAdapter().setChatInfo(chatInfo);
        mentionContainer.getAdapter().setNeedUsernames(currentChat != null);
        mentionContainer.getAdapter().setNeedBotContext(true);
        mentionContainer.getAdapter().setBotsCount(currentChat != null ? botsCount : 1);
        mentionContainer.getListView().setOnItemClickListener(mentionsOnItemClickListener = (view, position) -> {
            if (position == 0 || mentionContainer.getAdapter().isBannedInline()) {
                return;
            }
            position--;
            Object object = mentionContainer.getAdapter().getItem(position);
            int start = mentionContainer.getAdapter().getResultStartPosition();
            int len = mentionContainer.getAdapter().getResultLength();
            if (object instanceof TLRPC.TL_document) {
                if (chatMode == 0 && checkSlowMode(view)) {
                    return;
                }
                MessageObject.SendAnimationData sendAnimationData = null;
                if (view instanceof StickerCell) {
                    sendAnimationData = ((StickerCell) view).getSendAnimationData();
                }
                TLRPC.TL_document document = (TLRPC.TL_document) object;
                Object parent = mentionContainer.getAdapter().getItemParent(position);
                String query = MessageObject.findAnimatedEmojiEmoticon(document);
                if (chatMode == MODE_SCHEDULED) {
                    AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate) -> SendMessagesHelper.getInstance(currentAccount).sendSticker(document, query, dialog_id, replyingMessageObject, getThreadMessage(), parent, null, notify, scheduleDate, false), themeDelegate);
                } else {
                    getSendMessagesHelper().sendSticker(document, query, dialog_id, replyingMessageObject, getThreadMessage(), parent, sendAnimationData, true, 0, false);
                }
                hideFieldPanel(false);
                chatActivityEnterView.addStickerToRecent(document);
                chatActivityEnterView.setFieldText("");
            } else if (object instanceof TLRPC.Chat) {
                TLRPC.Chat chat = (TLRPC.Chat) object;
                if (searchingForUser && searchContainer != null && searchContainer.getVisibility() == View.VISIBLE) {
                    searchUserMessages(null, chat);
                } else {
                    String username = ChatObject.getPublicUsername(chat);
                    if (username != null) {
                        chatActivityEnterView.replaceWithText(start, len, "@" + username + " ", false);
                    }
                }
            } else if (object instanceof TLRPC.User) {
                TLRPC.User user = (TLRPC.User) object;
                if (searchingForUser && searchContainer != null && searchContainer.getVisibility() == View.VISIBLE) {
                    searchUserMessages(user, null);
                } else {
                    if (UserObject.getPublicUsername(user) != null) {
                        chatActivityEnterView.replaceWithText(start, len, "@" + UserObject.getPublicUsername(user) + " ", false);
                    } else {
                        String name = UserObject.getFirstName(user, false);
                        Spannable spannable = new SpannableString(name + " ");
                        spannable.setSpan(new URLSpanUserMention("" + user.id, 3), 0, spannable.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                        chatActivityEnterView.replaceWithText(start, len, spannable, false);
                    }
                }
            } else if (object instanceof String) {
                if (mentionContainer.getAdapter().isBotCommands()) {
                    if (chatMode == MODE_SCHEDULED) {
                        AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate) -> {
                            getSendMessagesHelper().sendMessage((String) object, dialog_id, replyingMessageObject, getThreadMessage(), null, false, null, null, null, notify, scheduleDate, null, false);
                            chatActivityEnterView.setFieldText("");
                            hideFieldPanel(false);
                        }, themeDelegate);
                    } else {
                        if (checkSlowMode(view)) {
                            return;
                        }
                        getSendMessagesHelper().sendMessage((String) object, dialog_id, replyingMessageObject, getThreadMessage(), null, false, null, null, null, true, 0, null, false);
                        chatActivityEnterView.setFieldText("");
                        hideFieldPanel(false);
                    }
                } else {
                    chatActivityEnterView.replaceWithText(start, len, object + " ", false);
                }
            } else if (object instanceof TLRPC.BotInlineResult) {
                if (chatActivityEnterView.getFieldText() == null || chatMode != MODE_SCHEDULED && checkSlowMode(view)) {
                    return;
                }
                TLRPC.BotInlineResult result = (TLRPC.BotInlineResult) object;
                if (currentEncryptedChat != null) {
                    int error = 0;
                    if (result.send_message instanceof TLRPC.TL_botInlineMessageMediaAuto && "game".equals(result.type)) {
                        error = 1;
                    } else if (result.send_message instanceof TLRPC.TL_botInlineMessageMediaInvoice) {
                        error = 2;
                    }
                    if (error != 0) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                        builder.setTitle(LocaleController.getString("SendMessageTitle", R.string.SendMessageTitle));
                        if (error == 1) {
                            builder.setMessage(LocaleController.getString("GameCantSendSecretChat", R.string.GameCantSendSecretChat));
                        } else {
                            builder.setMessage(LocaleController.getString("InvoiceCantSendSecretChat", R.string.InvoiceCantSendSecretChat));
                        }
                        builder.setNegativeButton(LocaleController.getString("OK", R.string.OK), null);
                        showDialog(builder.create());
                        return;
                    }
                }
                if ((result.type.equals("photo") && (result.photo != null || result.content != null) ||
                        result.type.equals("gif") && (result.document != null || result.content != null) ||
                        result.type.equals("video") && (result.document != null/* || result.content_url != null*/))) {
                    ArrayList<Object> arrayList = botContextResults = new ArrayList<>(mentionContainer.getAdapter().getSearchResultBotContext());
                    PhotoViewer.getInstance().setParentActivity(ChatActivity.this, themeDelegate);
                    PhotoViewer.getInstance().openPhotoForSelect(arrayList, mentionContainer.getAdapter().getItemPosition(position), 3, false, botContextProvider, ChatActivity.this);
                } else {
                    if (chatMode == MODE_SCHEDULED) {
                        AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate) -> sendBotInlineResult(result, notify, scheduleDate), themeDelegate);
                    } else {
                        sendBotInlineResult(result, true, 0);
                    }
                }
            } else if (object instanceof TLRPC.TL_inlineBotWebView) {
                processInlineBotWebView((TLRPC.TL_inlineBotWebView) object);
            } else if (object instanceof TLRPC.TL_inlineBotSwitchPM) {
                processInlineBotContextPM((TLRPC.TL_inlineBotSwitchPM) object);
            } else if (object instanceof MediaDataController.KeywordResult) {
                String code = ((MediaDataController.KeywordResult) object).emoji;
                chatActivityEnterView.addEmojiToRecent(code);
                if (code != null && code.startsWith("animated_")) {
                    try {
                        Paint.FontMetricsInt fontMetrics = null;
                        try {
                            fontMetrics = chatActivityEnterView.getEditField().getPaint().getFontMetricsInt();
                        } catch (Exception e) {
                            FileLog.e(e, false);
                        }
                        long documentId = Long.parseLong(code.substring(9));
                        TLRPC.Document document = AnimatedEmojiDrawable.findDocument(currentAccount, documentId);
                        SpannableString emoji = new SpannableString(MessageObject.findAnimatedEmojiEmoticon(document));
                        AnimatedEmojiSpan span;
                        if (document != null) {
                            span = new AnimatedEmojiSpan(document, fontMetrics);
                        } else {
                            span = new AnimatedEmojiSpan(documentId, fontMetrics);
                        }
                        emoji.setSpan(span, 0, emoji.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                        chatActivityEnterView.replaceWithText(start, len, emoji, false);
                    } catch (Exception ignore) {
                        chatActivityEnterView.replaceWithText(start, len, code, true);
                    }
                } else {
                    chatActivityEnterView.replaceWithText(start, len, code, true);
                }
                mentionContainer.updateVisibility(false);
            }
        });
        mentionContainer.getListView().setOnItemLongClickListener((view, position) -> {
            if (getParentActivity() == null || !mentionContainer.getAdapter().isLongClickEnabled()) {
                return false;
            }
            if (position == 0 || mentionContainer.getAdapter().isBannedInline()) {
                return false;
            }
            position--;
            Object object = mentionContainer.getAdapter().getItem(position);
            if (object instanceof String) {
                if (mentionContainer.getAdapter().isBotCommands()) {
                    if (URLSpanBotCommand.enabled) {
                        chatActivityEnterView.setFieldText("");
                        chatActivityEnterView.setCommand(null, (String) object, true, currentChat != null && currentChat.megagroup);
                        return true;
                    }
                    return false;
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setTitle(LocaleController.getString("AppName", R.string.AppName));
                    builder.setMessage(LocaleController.getString("ClearSearch", R.string.ClearSearch));
                    builder.setPositiveButton(LocaleController.getString("ClearButton", R.string.ClearButton), (dialogInterface, i) -> mentionContainer.getAdapter().clearRecentHashtags());
                    builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), null);
                    showDialog(builder.create());
                    return true;
                }
            }
            return false;
        });

        //到最底部按钮
        pagedownButtonImage = new ImageView(context);
        pagedownButtonImage.setPadding(0, AndroidUtilities.dp(2), 0, 0);
        Drawable drawable;
        if (Build.VERSION.SDK_INT >= 21) {
            pagedownButtonImage.setOutlineProvider(new ViewOutlineProvider() {
                @Override
                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, AndroidUtilities.dp(42), AndroidUtilities.dp(42));
                }
            });
            drawable = Theme.createSimpleSelectorCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton), getThemedColor(Theme.key_listSelector));
        } else {
            drawable = Theme.createCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton));
        }
        Drawable shadowDrawable = context.getResources().getDrawable(R.drawable.pagedown_shadow).mutate();
        shadowDrawable.setColorFilter(new PorterDuffColorFilter(0xff000000, PorterDuff.Mode.MULTIPLY));
        CombinedDrawable combinedDrawable = new CombinedDrawable(shadowDrawable, drawable, 0, 0);
        combinedDrawable.setIconSize(AndroidUtilities.dp(42), AndroidUtilities.dp(42));
        drawable = combinedDrawable;
        pagedownButtonImage.setBackground(drawable);

        pagedownButton.addView(pagedownButtonImage, LayoutHelper.createFrame(46, 46, Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM));
        pagedownButton.setContentDescription(LocaleController.getString("AccDescrPageDown", R.string.AccDescrPageDown));

        pagedownButtonArrow = new ImageView(context);
        pagedownButtonArrow.setImageResource(R.drawable.pagedown);
        pagedownButtonArrow.setScaleType(ImageView.ScaleType.CENTER);
        pagedownButtonArrow.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_goDownButtonIcon), PorterDuff.Mode.MULTIPLY));
        pagedownButtonArrow.setPadding(0, AndroidUtilities.dp(2), 0, 0);
        pagedownButtonArrow.setPivotX(AndroidUtilities.dp(23));
        pagedownButtonArrow.setPivotY(AndroidUtilities.dp(33));
        pagedownButton.addView(pagedownButtonArrow, LayoutHelper.createFrame(46, 46, Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM));

        pagedownButtonLoading = new ImageView(context);
        pagedownButtonLoadingDrawable = new CircularProgressDrawable(AndroidUtilities.dp(18), AndroidUtilities.dp(1.7f), getThemedColor(Theme.key_chat_goDownButtonIcon));
        pagedownButtonLoadingDrawable.setAngleOffset(90);
        pagedownButtonLoading.setImageDrawable(pagedownButtonLoadingDrawable);
        pagedownButtonLoading.setAlpha(0f);
        pagedownButtonLoading.setVisibility(View.GONE);
        pagedownButton.addView(pagedownButtonLoading, LayoutHelper.createFrame(46, 46, Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM));

        pagedownButtonCounter = new CounterView(context, themeDelegate) {
            @Override
            public void invalidate() {
                if (isInOutAnimation()) {
                    contentView.invalidate();
                }
                super.invalidate();
            }
        };
        pagedownButtonCounter.setReverse(true);
        pagedownButton.addView(pagedownButtonCounter, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 28, Gravity.TOP | Gravity.LEFT));

        //被提及按钮，添加跳转提及聊天位置
        mentiondownButtonImage = new ImageView(context);
        mentiondownButtonImage.setImageResource(R.drawable.mentionbutton);
        mentiondownButtonImage.setScaleType(ImageView.ScaleType.CENTER);
        mentiondownButtonImage.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_goDownButtonIcon), PorterDuff.Mode.MULTIPLY));
        mentiondownButtonImage.setPadding(0, AndroidUtilities.dp(2), 0, 0);
        if (Build.VERSION.SDK_INT >= 21) {
            pagedownButtonImage.setOutlineProvider(new ViewOutlineProvider() {
                @Override
                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, AndroidUtilities.dp(42), AndroidUtilities.dp(42));
                }
            });
            drawable = Theme.createSimpleSelectorCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton), getThemedColor(Theme.key_listSelector));
        } else {
            drawable = Theme.createCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton));
        }
        shadowDrawable = context.getResources().getDrawable(R.drawable.pagedown_shadow).mutate();
        shadowDrawable.setColorFilter(new PorterDuffColorFilter(0xff000000, PorterDuff.Mode.MULTIPLY));
        combinedDrawable = new CombinedDrawable(shadowDrawable, drawable, 0, 0);
        combinedDrawable.setIconSize(AndroidUtilities.dp(42), AndroidUtilities.dp(42));
        drawable = combinedDrawable;
        mentiondownButtonImage.setBackgroundDrawable(drawable);

        mentiondownButton.addView(mentiondownButtonImage, LayoutHelper.createFrame(46, 46, Gravity.LEFT | Gravity.BOTTOM));

        mentiondownButtonCounter = new SimpleTextView(context);
        mentiondownButtonCounter.setVisibility(View.INVISIBLE);
        mentiondownButtonCounter.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        mentiondownButtonCounter.setTextSize(13);
        mentiondownButtonCounter.setTextColor(getThemedColor(Theme.key_chat_goDownButtonCounter));
        mentiondownButtonCounter.setGravity(Gravity.CENTER);
        mentiondownButtonCounter.setBackgroundDrawable(Theme.createRoundRectDrawable(AndroidUtilities.dp(11.5f), getThemedColor(Theme.key_chat_goDownButtonCounterBackground)));
        mentiondownButtonCounter.setMinWidth(AndroidUtilities.dp(23));
        mentiondownButtonCounter.setPadding(AndroidUtilities.dp(8), AndroidUtilities.dp(1), AndroidUtilities.dp(8), 0);
        mentiondownButton.addView(mentiondownButtonCounter, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 23, Gravity.TOP | Gravity.CENTER_HORIZONTAL));
        mentiondownButton.setContentDescription(LocaleController.getString("AccDescrMentionDown", R.string.AccDescrMentionDown));

        //情绪提及跳转
        reactionsMentiondownButton.setOnClickListener(view -> {
            wasManualScroll = true;
            getMessagesController().getNextReactionMention(dialog_id, getTopicId(), reactionsMentionCount, (messageId) -> {
                if (messageId == 0) {
                    reactionsMentionCount = 0;
                    updateReactionsMentionButton(true);
                    getMessagesController().markReactionsAsRead(dialog_id, getTopicId());
                } else {
                    updateReactionsMentionButton(true);
                    scrollToMessageId(messageId, 0, false, 0, true, 0);
                }
            });
        });
        reactionsMentiondownButton.setOnLongClickListener(view -> {
            scrimPopupWindow = ReadAllMentionsMenu.show(ReadAllMentionsMenu.TYPE_REACTIONS, getParentActivity(), getParentLayout(), contentView, view, getResourceProvider(), () -> {
                for (int i = 0; i < messages.size(); i++) {
                    messages.get(i).markReactionsAsRead();
                }
                reactionsMentionCount = 0;
                updateReactionsMentionButton(true);
                getMessagesController().markReactionsAsRead(dialog_id, getTopicId());
                if (scrimPopupWindow != null) {
                    scrimPopupWindow.dismiss();
                }
            });
            dimBehindView(reactionsMentiondownButton, true);
            scrimPopupWindow.setOnDismissListener(() -> {
                scrimPopupWindow = null;
                menuDeleteItem = null;
                scrimPopupWindowItems = null;
                chatLayoutManager.setCanScrollVertically(true);
                dimBehindView(false);
                if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                    chatActivityEnterView.getEditField().setAllowDrawCursor(true);
                }
            });
            view.performHapticFeedback(HapticFeedbackConstants.LONG_PRESS, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
            return false;
        });
        reactionsMentiondownButton.setVisibility(View.INVISIBLE);
        reactionsMentiondownButtonImage = new ImageView(context);
        reactionsMentiondownButtonImage.setImageResource(R.drawable.reactionbutton);
        reactionsMentiondownButtonImage.setScaleType(ImageView.ScaleType.CENTER);
        reactionsMentiondownButtonImage.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_goDownButtonIcon), PorterDuff.Mode.MULTIPLY));
        if (Build.VERSION.SDK_INT >= 21) {
            reactionsMentiondownButtonImage.setOutlineProvider(new ViewOutlineProvider() {
                @Override
                public void getOutline(View view, Outline outline) {
                    outline.setOval(0, 0, AndroidUtilities.dp(42), AndroidUtilities.dp(42));
                }
            });
            drawable = Theme.createSimpleSelectorCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton), getThemedColor(Theme.key_listSelector));
        } else {
            drawable = Theme.createCircleDrawable(AndroidUtilities.dp(42), getThemedColor(Theme.key_chat_goDownButton));
        }
        shadowDrawable = context.getResources().getDrawable(R.drawable.pagedown_shadow).mutate();
        shadowDrawable.setColorFilter(new PorterDuffColorFilter(0xff000000, PorterDuff.Mode.MULTIPLY));
        combinedDrawable = new CombinedDrawable(shadowDrawable, drawable, 0, 0);
        combinedDrawable.setIconSize(AndroidUtilities.dp(42), AndroidUtilities.dp(42));
        drawable = combinedDrawable;
        reactionsMentiondownButtonImage.setBackgroundDrawable(drawable);
        reactionsMentiondownButton.addView(reactionsMentiondownButtonImage, LayoutHelper.createFrame(46, 46, Gravity.LEFT | Gravity.BOTTOM));
        reactionsMentiondownButtonCounter = new CounterView(context, themeDelegate);
        reactionsMentiondownButton.addView(reactionsMentiondownButtonCounter, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 28, Gravity.TOP | Gravity.LEFT));
        reactionsMentiondownButton.setContentDescription(LocaleController.getString("AccDescrReactionMentionDown", R.string.AccDescrReactionMentionDown));

        //多媒体播放UI
        fragmentLocationContextView = new FragmentContextView(context, this, true, themeDelegate);
        fragmentContextView = new FragmentContextView(context, this, false, themeDelegate);
        contentView.addView(fragmentLocationContextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 38, Gravity.TOP | Gravity.LEFT, 0, -36, 0, 0));
        contentView.addView(fragmentContextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 38, Gravity.TOP | Gravity.LEFT, 0, -36, 0, 0));

        fragmentContextView.setAdditionalContextView(fragmentLocationContextView);
        fragmentLocationContextView.setAdditionalContextView(fragmentContextView);

        fragmentContextView.setEnabled(!inPreviewMode);
        fragmentLocationContextView.setEnabled(!inPreviewMode);

        if (chatMode != 0) {
            fragmentContextView.setSupportsCalls(false);
        }

        //消息搜索列表
        messagesSearchListView = new RecyclerListView(context, themeDelegate);
        messagesSearchListView.setBackgroundColor(getThemedColor(Theme.key_windowBackgroundWhite));
        LinearLayoutManager messagesSearchLayoutManager = new LinearLayoutManager(context);
        messagesSearchLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        messagesSearchListView.setLayoutManager(messagesSearchLayoutManager);
        messagesSearchListView.setVisibility(View.GONE);
        messagesSearchListView.setAlpha(0.0f);
        messagesSearchListView.setAdapter(messagesSearchAdapter = new MessagesSearchAdapter(context, themeDelegate));
        contentView.addView(messagesSearchListView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 48));
        messagesSearchListView.setOnItemClickListener((view, position) -> {
            getMediaDataController().jumpToSearchedMessage(classGuid, position);
            showMessagesSearchListView(false);
        });
        messagesSearchListView.setOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int lastVisibleItem = messagesSearchLayoutManager.findLastVisibleItemPosition();
                int visibleItemCount = lastVisibleItem == RecyclerView.NO_POSITION ? 0 : lastVisibleItem;
                if (visibleItemCount > 0 && lastVisibleItem > messagesSearchLayoutManager.getItemCount() - 5) {
                    getMediaDataController().loadMoreSearchMessages();
                }
            }
        });

        contentView.addView(actionBar);

        //覆盖层
        overlayView = new View(context);
        overlayView.setOnTouchListener((v, event) -> {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                checkRecordLocked(false);
            }
            overlayView.getParent().requestDisallowInterceptTouchEvent(true);
            return true;
        });
        contentView.addView(overlayView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));
        overlayView.setVisibility(View.GONE);
        contentView.setClipChildren(false);

        instantCameraView = null;

        //配置底部提及、转发按钮布局
        bottomMessagesActionContainer = new BlurredFrameLayout(context, contentView) {
            @Override
            public void onDraw(Canvas canvas) {
                int bottom = Theme.chat_composeShadowDrawable.getIntrinsicHeight();
                Theme.chat_composeShadowDrawable.setBounds(0, 0, getMeasuredWidth(), bottom);
                Theme.chat_composeShadowDrawable.draw(canvas);
                AndroidUtilities.rectTmp2.set(0, bottom, getMeasuredWidth(), getMeasuredHeight());
                contentView.drawBlurRect(canvas, getY(), AndroidUtilities.rectTmp2, getThemedPaint(Theme.key_paint_chatComposeBackground), false);
            }
        };
        bottomMessagesActionContainer.drawBlur = false;
        bottomMessagesActionContainer.isTopView = false;
        bottomMessagesActionContainer.setVisibility(View.INVISIBLE);
        bottomMessagesActionContainer.setWillNotDraw(false);
        bottomMessagesActionContainer.setPadding(0, AndroidUtilities.dp(2), 0, 0);
        contentView.addView(bottomMessagesActionContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 51, Gravity.BOTTOM));
        bottomMessagesActionContainer.setOnTouchListener((v, event) -> true);
        replyButton = null;
        forwardButton = null;
        shareButton = null;
        copyButton = null;

        //配置输入框
        chatActivityEnterView = new ChatActivityEnterView(getParentActivity(), contentView, this, true, themeDelegate) {

            int lastContentViewHeight;
            int messageEditTextPredrawHeigth;
            int messageEditTextPredrawScrollY;

            @Override
            public boolean onInterceptTouchEvent(MotionEvent ev) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.onInterceptTouchEvent(ev);
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.onTouchEvent(event);
            }

            @Override
            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.dispatchTouchEvent(ev);
            }

            @Override
            protected boolean pannelAnimationEnabled() {
                if (!openAnimationEnded) {
                    return false;
                }
                return true;
            }

            @Override
            public void checkAnimation() {
                if (actionBar.isActionModeShowed() || reportType >= 0) {
                    if (messageEditTextAnimator != null) {
                        messageEditTextAnimator.cancel();
                    }
                    if (changeBoundAnimator != null) {
                        changeBoundAnimator.cancel();
                    }

                    chatActivityEnterViewAnimateFromTop = 0;
                    shouldAnimateEditTextWithBounds = false;
                } else {
                    int t = getBackgroundTop();
                    if (chatActivityEnterViewAnimateFromTop != 0 && t != chatActivityEnterViewAnimateFromTop && lastContentViewHeight == contentView.getMeasuredHeight()) {
                        int dy = animatedTop + chatActivityEnterViewAnimateFromTop - t;
                        animatedTop = dy;
                        if (changeBoundAnimator != null) {
                            changeBoundAnimator.removeAllListeners();
                            changeBoundAnimator.cancel();
                        }

                        chatListView.setTranslationY(dy);
                        if (topView != null && topView.getVisibility() == View.VISIBLE) {
                            topView.setTranslationY(animatedTop + (1f - topViewEnterProgress) * topView.getLayoutParams().height);
                            if (topLineView != null) {
                                topLineView.setTranslationY(animatedTop);
                            }
                        }
                        if (mentionContainer != null) {
                            mentionContainer.setTranslationY(dy);
                        }

                        changeBoundAnimator = ValueAnimator.ofFloat(dy, 0);
                        changeBoundAnimator.addUpdateListener(a -> {
                            float top = (float) a.getAnimatedValue();
                            animatedTop = (int) top;
                            if (topView != null && topView.getVisibility() == View.VISIBLE) {
                                topView.setTranslationY(top + (1f - topViewEnterProgress) * topView.getLayoutParams().height);
                                if (topLineView != null) {
                                    topLineView.setTranslationY(top);
                                }
                            } else {
                                if (mentionContainer != null) {
                                    mentionContainer.setTranslationY(top);
                                }
                                chatListView.setTranslationY(top);
                                invalidateChatListViewTopPadding();
                                invalidateMessagesVisiblePart();
                            }
                            invalidate();
                        });
                        changeBoundAnimator.addListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                animatedTop = 0;
                                if (topView != null && topView.getVisibility() == View.VISIBLE) {
                                    topView.setTranslationY(animatedTop + (1f - topViewEnterProgress) * topView.getLayoutParams().height);
                                    if (topLineView != null) {
                                        topLineView.setTranslationY(animatedTop);
                                    }
                                } else {
                                    chatListView.setTranslationY(0);
                                    if (mentionContainer != null) {
                                        mentionContainer.setTranslationY(0);
                                    }
                                }
                                changeBoundAnimator = null;
                            }
                        });
                        changeBoundAnimator.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                        changeBoundAnimator.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                        if (!waitingForSendingMessageLoad) {
                            changeBoundAnimator.start();
                        }
                        invalidateChatListViewTopPadding();
                        invalidateMessagesVisiblePart();
                        chatActivityEnterViewAnimateFromTop = 0;
                    } else if (lastContentViewHeight != contentView.getMeasuredHeight()) {
                        chatActivityEnterViewAnimateFromTop = 0;
                    }
                    if (shouldAnimateEditTextWithBounds) {
                        float dy = (messageEditTextPredrawHeigth - messageEditText.getMeasuredHeight()) + (messageEditTextPredrawScrollY - messageEditText.getScrollY());
                        messageEditText.setOffsetY(messageEditText.getOffsetY() - dy);
                        ValueAnimator a = ValueAnimator.ofFloat(messageEditText.getOffsetY(), 0);
                        a.addUpdateListener(animation -> messageEditText.setOffsetY((float) animation.getAnimatedValue()));
                        if (messageEditTextAnimator != null) {
                            messageEditTextAnimator.cancel();
                        }
                        messageEditTextAnimator = a;
                        a.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                       // a.setStartDelay(chatActivityEnterViewAnimateBeforeSending ? 20 : 0);
                        a.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                        a.start();
                        shouldAnimateEditTextWithBounds = false;
                    }
                    lastContentViewHeight = contentView.getMeasuredHeight();

                    chatActivityEnterViewAnimateBeforeSending = false;
                }
            }

            @Override
            protected void onLineCountChanged(int oldLineCount, int newLineCount) {
                if (chatActivityEnterView != null) {
                    shouldAnimateEditTextWithBounds = true;
                    messageEditTextPredrawHeigth = messageEditText.getMeasuredHeight();
                    messageEditTextPredrawScrollY = messageEditText.getScrollY();
                    contentView.invalidate();
                    chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                }
            }
        };
        chatActivityEnterView.setDelegate(new ChatActivityEnterViewDelegate());
        chatActivityEnterView.setDialogId(dialog_id, currentAccount);
        if (chatInfo != null) {
            chatActivityEnterView.setChatInfo(chatInfo);
        }
        chatActivityEnterView.setId(id_chat_compose_panel);
        chatActivityEnterView.setBotsCount(botsCount, hasBotsCommands, false);
        chatActivityEnterView.updateBotWebView(false);
        chatActivityEnterView.setMinimumHeight(AndroidUtilities.dp(51));
        chatActivityEnterView.setAllowStickersAndGifs(true, true, currentEncryptedChat == null || AndroidUtilities.getPeerLayerVersion(currentEncryptedChat.layer) >= 46);
        if (inlineQueryForInput != null) {
            chatActivityEnterView.setFieldText(inlineQueryForInput);
            inlineQueryForInput = null;
        }
        if (inPreviewMode) {
            chatActivityEnterView.setVisibility(View.INVISIBLE);
        }
        if (!ChatObject.isChannel(currentChat) || currentChat.megagroup) {
            //默认会设置bot按钮布局（没有bot就配置没有bot的布局）
            chatActivityEnterView.setBotInfo(botInfo, false);
        }
        contentView.addView(chatActivityEnterView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM));
        chatActivityEnterView.checkChannelRights();

        chatActivityEnterTopView = new ChatActivityEnterTopView(context) {
            @Override
            public void setTranslationY(float translationY) {
                super.setTranslationY(translationY);
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.invalidate();
                }
                if (getVisibility() != GONE) {
                    hideHints(true);
                    if (chatListView != null) {
                        chatListView.setTranslationY(translationY);
                    }
                    if (progressView != null) {
                        progressView.setTranslationY(translationY);
                    }
                    invalidateChatListViewTopPadding();
                    invalidateMessagesVisiblePart();
                    if (fragmentView != null) {
                        fragmentView.invalidate();
                    }
                }
            }

            @Override
            public boolean hasOverlappingRendering() {
                return false;
            }

            @Override
            public void setVisibility(int visibility) {
                super.setVisibility(visibility);
                if (visibility == GONE) {
                    if (chatListView != null) {
                        chatListView.setTranslationY(0);
                    }
                    if (progressView != null) {
                        progressView.setTranslationY(0);
                    }
                }
            }
        };
        //设置输入框的引用布局
        replyLineView = new View(context);
        replyLineView.setBackgroundColor(getThemedColor(Theme.key_chat_replyPanelLine));
        //输入布局添加输入框上方布局以及引用布局
        chatActivityEnterView.addTopView(chatActivityEnterTopView, replyLineView, 48);

        final FrameLayout replyLayout = new FrameLayout(context);
        chatActivityEnterTopView.addReplyView(replyLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 52, 0));

        replyLayout.setOnClickListener(v -> {
            if (forwardingMessages != null && !forwardingMessages.messages.isEmpty()) {
                SharedConfig.forwardingOptionsHintHintShowed();
                openForwardingPreview();
            } else if (replyingMessageObject != null && (!isThreadChat() || replyingMessageObject.getId() != threadMessageId)) {
                scrollToMessageId(replyingMessageObject.getId(), 0, true, 0, true, 0);
            } else if (editingMessageObject != null) {
                if (editingMessageObject.canEditMedia() && editingMessageObjectReqId == 0) {
                    if (chatAttachAlert == null) {
                        createChatAttachView();
                    }
                    chatAttachAlert.setEditingMessageObject(editingMessageObject);
                    openAttachMenu();
                } else {
                    scrollToMessageId(editingMessageObject.getId(), 0, true, 0, true, 0);
                }
            }
        });

        replyIconImageView = new ImageView(context);
        replyIconImageView.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_replyPanelIcons), PorterDuff.Mode.MULTIPLY));
        replyIconImageView.setScaleType(ImageView.ScaleType.CENTER);
        replyLayout.addView(replyIconImageView, LayoutHelper.createFrame(52, 46, Gravity.TOP | Gravity.LEFT));

        replyCloseImageView = new ImageView(context);
        replyCloseImageView.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_replyPanelClose), PorterDuff.Mode.MULTIPLY));
        replyCloseImageView.setImageResource(R.drawable.input_clear);
        replyCloseImageView.setScaleType(ImageView.ScaleType.CENTER);
        if (Build.VERSION.SDK_INT >= 21) {
            replyCloseImageView.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff, 1, AndroidUtilities.dp(18)));
        }
        chatActivityEnterTopView.addView(replyCloseImageView, LayoutHelper.createFrame(52, 46, Gravity.RIGHT | Gravity.TOP, 0, 0.5f, 0, 0));
        replyCloseImageView.setOnClickListener(v -> {
            if (forwardingMessages == null || forwardingMessages.messages.isEmpty()) {
                if (ChatObject.isForum(currentChat) && !isTopic && replyingMessageObject != null) {
                    int topicId = MessageObject.getTopicId(replyingMessageObject.messageOwner, true);
                    if (topicId != 0) {
                        getMediaDataController().cleanDraft(dialog_id, topicId, false);
                    }
                }
                showFieldPanel(false, null, null, null, foundWebPage, true, 0, true, true);
            } else {
                openAnotherForward();
            }
        });

        replyNameTextView = new SimpleTextView(context);
        replyNameTextView.setTextSize(14);
        replyNameTextView.setTextColor(getThemedColor(Theme.key_chat_replyPanelName));
        replyNameTextView.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        replyLayout.addView(replyNameTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 6, 0, 0));

        replyObjectTextView = new SimpleTextView(context);
        replyObjectTextView.setTextSize(14);
        replyObjectTextView.setTextColor(getThemedColor(Theme.key_windowBackgroundWhiteGrayText));
        replyLayout.addView(replyObjectTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 24, 0, 0));

        replyObjectHintTextView = new SimpleTextView(context);
        replyObjectHintTextView.setTextSize(14);
        replyObjectHintTextView.setTextColor(getThemedColor(Theme.key_windowBackgroundWhiteGrayText));
        replyObjectHintTextView.setText(LocaleController.getString("TapForForwardingOptions", R.string.TapForForwardingOptions));
        replyObjectHintTextView.setAlpha(0f);
        replyLayout.addView(replyObjectHintTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 24, 0, 0));

        SpoilerEffect replySpoilerEffect = new SpoilerEffect();
        replyImageView = new BackupImageView(context) {
            Path path = new Path();

            @Override
            public void draw(Canvas canvas) {
                super.draw(canvas);

                if (replyImageHasMediaSpoiler) {
                    path.rewind();
                    AndroidUtilities.rectTmp.set(imageReceiver.getImageX(), imageReceiver.getImageY(), imageReceiver.getImageX2(), imageReceiver.getImageY2());
                    path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(2), AndroidUtilities.dp(2), Path.Direction.CW);

                    canvas.save();
                    canvas.clipPath(path);

                    int sColor = Color.WHITE;
                    replySpoilerEffect.setColor(ColorUtils.setAlphaComponent(sColor, (int) (Color.alpha(sColor) * 0.325f)));
                    replySpoilerEffect.setBounds((int) imageReceiver.getImageX(), (int) imageReceiver.getImageY(), (int) imageReceiver.getImageX2(), (int) imageReceiver.getImageY2());
                    replySpoilerEffect.draw(canvas);
                    invalidate();

                    canvas.restore();
                }
            }
        };
        replyImageView.setRoundRadius(AndroidUtilities.dp(2));
        replyLayout.addView(replyImageView, LayoutHelper.createFrame(34, 34, Gravity.TOP | Gravity.LEFT, 52, 6, 0, 0));

        //添加输入框快捷表情UI
        contentView.addView(
            suggestEmojiPanel = new SuggestEmojiView(context, currentAccount, chatActivityEnterView, themeDelegate),
            LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 160, Gravity.LEFT | Gravity.BOTTOM)
        );
        suggestEmojiPanel.setVisibility(View.GONE);

        //输入框顶部按钮，滚动到特定位置
        final ChatActivityEnterTopView.EditView editView = new ChatActivityEnterTopView.EditView(context);
        editView.setMotionEventSplittingEnabled(false);
        editView.setOrientation(LinearLayout.HORIZONTAL);
        editView.setOnClickListener(v -> {
            if (editingMessageObject != null) {
                scrollToMessageId(editingMessageObject.getId(), 0, true, 0, true, 0);
            }
        });
        chatActivityEnterTopView.addEditView(editView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 48, 0));

        for (int i = 0; i < 2; i++) {
            final boolean firstButton = i == 0;

            final ChatActivityEnterTopView.EditViewButton button = new ChatActivityEnterTopView.EditViewButton(context) {
                @Override
                public void setEditButton(boolean editButton) {
                    super.setEditButton(editButton);
                    if (firstButton) {
                        //核心配置编辑框宽度
                        getTextView().setMaxWidth(editButton ? AndroidUtilities.dp(116) : Integer.MAX_VALUE);
                    }
                }

                @Override
                public void updateColors() {
                    final int leftInset = firstButton ? AndroidUtilities.dp(14) : 0;
                    setBackground(Theme.createCircleSelectorDrawable(getThemedColor(Theme.key_chat_replyPanelName) & 0x19ffffff, leftInset, 0));
                    getImageView().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_replyPanelName), PorterDuff.Mode.MULTIPLY));
                    getTextView().setTextColor(getThemedColor(Theme.key_chat_replyPanelName));
                }
            };
            button.setOrientation(LinearLayout.HORIZONTAL);
            ViewHelper.setPadding(button, 10, 0, 10, 0);
            editView.addButton(button, LayoutHelper.createLinear(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT));

            final ImageView imageView = new ImageView(context);
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            imageView.setImageResource(firstButton ? R.drawable.msg_photoeditor : R.drawable.msg_replace);
            button.addImageView(imageView, LayoutHelper.createLinear(24, LayoutHelper.MATCH_PARENT));

            button.addView(new Space(context), LayoutHelper.createLinear(10, LayoutHelper.MATCH_PARENT));

            final TextView textView = new TextView(context);
            textView.setMaxLines(1);
            textView.setSingleLine(true);
            textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
            textView.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
            textView.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            button.addTextView(textView, LayoutHelper.createLinear(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT));

            button.updateColors();
            button.setOnClickListener(v -> {
                if (editingMessageObject == null || !editingMessageObject.canEditMedia() || editingMessageObjectReqId != 0) {
                    return;
                }
                if (button.isEditButton()) {
                    openEditingMessageInPhotoEditor();
                } else {
                    replyLayout.callOnClick();
                }
            });
        }
        searchContainer = null;

        bottomOverlay = new FrameLayout(context) {
            @Override
            public void onDraw(Canvas canvas) {
                int bottom = Theme.chat_composeShadowDrawable.getIntrinsicHeight();
                Theme.chat_composeShadowDrawable.setBounds(0, 0, getMeasuredWidth(), bottom);
                Theme.chat_composeShadowDrawable.draw(canvas);
                canvas.drawRect(0, bottom, getMeasuredWidth(), getMeasuredHeight(), getThemedPaint(Theme.key_paint_chatComposeBackground));
            }
        };
        bottomOverlay.setWillNotDraw(false);
        bottomOverlay.setVisibility(View.INVISIBLE);
        bottomOverlay.setFocusable(true);
        bottomOverlay.setFocusableInTouchMode(true);
        bottomOverlay.setClickable(true);
        bottomOverlay.setPadding(0, AndroidUtilities.dp(2), 0, 0);
        contentView.addView(bottomOverlay, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 51, Gravity.BOTTOM));

        bottomOverlayText = new TextView(context);
        bottomOverlayText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        bottomOverlayText.setGravity(Gravity.CENTER);
        bottomOverlayText.setMaxLines(2);
        bottomOverlayText.setEllipsize(TextUtils.TruncateAt.END);
        bottomOverlayText.setLineSpacing(AndroidUtilities.dp(2), 1);
        bottomOverlayText.setTextColor(getThemedColor(Theme.key_chat_secretChatStatusText));
        bottomOverlay.addView(bottomOverlayText, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.CENTER, 14, 0, 14, 0));

        //输入框底部覆盖层，弹出表情或者其他更多操作
        bottomOverlayChat = new BlurredFrameLayout(context, contentView) {
            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int allWidth = MeasureSpec.getSize(widthMeasureSpec);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) bottomOverlayChatText.getLayoutParams();
                layoutParams.width = allWidth;
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }

            @Override
            protected void dispatchDraw(Canvas canvas) {
                int bottom = Theme.chat_composeShadowDrawable.getIntrinsicHeight();
                Theme.chat_composeShadowDrawable.setBounds(0, 0, getMeasuredWidth(), bottom);
                Theme.chat_composeShadowDrawable.draw(canvas);
                if (SharedConfig.chatBlurEnabled()) {
                    if (backgroundPaint == null) {
                        backgroundPaint = new Paint();
                    }
                    backgroundPaint.setColor(getThemedColor(Theme.key_chat_messagePanelBackground));
                    AndroidUtilities.rectTmp2.set(0, bottom, getMeasuredWidth(), getMeasuredHeight());
                    contentView.drawBlurRect(canvas, getY(), AndroidUtilities.rectTmp2, backgroundPaint, false);
                } else {
                    canvas.drawRect(0, bottom, getMeasuredWidth(), getMeasuredHeight(), getThemedPaint(Theme.key_paint_chatComposeBackground));
                }
                super.dispatchDraw(canvas);
            }
        };
        bottomOverlayChat.isTopView = false;
        bottomOverlayChat.drawBlur = false;
        bottomOverlayChat.setWillNotDraw(false);
        bottomOverlayChat.setPadding(0, AndroidUtilities.dp(1.5f), 0, 0);
        bottomOverlayChat.setVisibility(View.INVISIBLE);
        bottomOverlayChat.setClipChildren(false);
        contentView.addView(bottomOverlayChat, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 51, Gravity.BOTTOM));

        bottomOverlayChatText = new UnreadCounterTextView(context) {
            @Override
            protected void updateCounter() {
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup && chatInfo != null && chatInfo.linked_chat_id != 0) {
                    TLRPC.Dialog dialog = getMessagesController().dialogs_dict.get(-chatInfo.linked_chat_id);
                    if (dialog != null) {
                        setCounter(dialog.unread_count);
                        return;
                    }
                }
                setCounter(0);
            }

            @Override
            protected boolean isTouchFullWidth() {
                return botInfo != null;
            }

            @Override
            protected Theme.ResourcesProvider getResourceProvider() {
                return themeDelegate;
            }

            @Override
            protected float getTopOffset() {
                return -AndroidUtilities.dp(2);
            }
        };
        bottomOverlayChat.addView(bottomOverlayChatText, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, 0, 0, 1.5f, 0, 0));
        bottomOverlayChatText.setOnClickListener(view -> {
            if (getParentActivity() == null || pullingDownOffset != 0) {
                return;
            }
            if (reportType >= 0) {
                showDialog(new ReportAlert(getParentActivity(), reportType) {
                    @Override
                    protected void onSend(int type, String message) {
                        ArrayList<Integer> ids = new ArrayList<>();
                        for (int b = 0; b < selectedMessagesIds[0].size(); b++) {
                            ids.add(selectedMessagesIds[0].keyAt(b));
                        }
                        TLRPC.InputPeer peer = currentUser != null ? MessagesController.getInputPeer(currentUser) : MessagesController.getInputPeer(currentChat);
                        AlertsCreator.sendReport(peer, reportType, message, ids);
                        finishFragment();
                        chatActivityDelegate.onReport();
                    }
                });
            } else if (chatMode == MODE_PINNED) {
                finishFragment();
                chatActivityDelegate.onUnpin(true, bottomOverlayChatText.getTag() == null);
            } else if (currentUser != null && userBlocked) {
                if (currentUser.bot) {
                    String botUserLast = botUser;
                    botUser = null;
                    getMessagesController().unblockPeer(currentUser.id);
                    if (botUserLast != null && botUserLast.length() != 0) {
                        getMessagesController().sendBotStart(currentUser, botUserLast);
                    } else {
                        getSendMessagesHelper().sendMessage("/start", dialog_id, null, null, null, false, null, null, null, true, 0, null, false);
                    }
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setMessage(LocaleController.getString("AreYouSureUnblockContact", R.string.AreYouSureUnblockContact));
                    builder.setPositiveButton(LocaleController.getString("OK", R.string.OK), (dialogInterface, i) -> getMessagesController().unblockPeer(currentUser.id));
                    builder.setTitle(LocaleController.getString("AppName", R.string.AppName));
                    builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), null);
                    showDialog(builder.create());
                }
            } else if (UserObject.isReplyUser(currentUser)) {
                toggleMute(true);
            } else if (currentUser != null && currentUser.bot && botUser != null) {
                if (botUser.length() != 0) {
                    getMessagesController().sendBotStart(currentUser, botUser);
                } else {
                    getSendMessagesHelper().sendMessage("/start", dialog_id, null, null, null, false, null, null, null, true, 0, null, false);
                }
                botUser = null;
                updateBottomOverlay();
            } else {
                if (ChatObject.isChannel(currentChat) && !(currentChat instanceof TLRPC.TL_channelForbidden)) {
                    if (ChatObject.isNotInChat(currentChat)) {
                        if (currentChat.join_request) {
//                            showDialog(new JoinGroupAlert(context, currentChat, null, this));
                            showBottomOverlayProgress(true, true);
                            MessagesController.getInstance(currentAccount).addUserToChat(
                                currentChat.id,
                                UserConfig.getInstance(currentAccount).getCurrentUser(),
                                0,
                                null,
                                null,
                                true,
                                () -> {
                                    showBottomOverlayProgress(false, true);
                                },
                                err -> {
                                    SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                    preferences.edit().putLong("dialog_join_requested_time_" + dialog_id, System.currentTimeMillis()).commit();
                                    if (err != null && "INVITE_REQUEST_SENT".equals(err.text)) {
                                        JoinGroupAlert.showBulletin(context, this, ChatObject.isChannel(currentChat) && !currentChat.megagroup);
                                    }
                                    showBottomOverlayProgress(false, true);
                                    return false;
                                }
                            );
                        } else {
                            if (chatInviteRunnable != null) {
                                AndroidUtilities.cancelRunOnUIThread(chatInviteRunnable);
                                chatInviteRunnable = null;
                            }
                            showBottomOverlayProgress(true, true);
                            getMessagesController().addUserToChat(currentChat.id, getUserConfig().getCurrentUser(), 0, null, ChatActivity.this, null);
                            NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.closeSearchByActiveAction);

                            if (hasReportSpam() && reportSpamButton.getTag(R.id.object_tag) != null) {
                                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                preferences.edit().putInt("dialog_bar_vis3" + dialog_id, 3).commit();
                                getNotificationCenter().postNotificationName(NotificationCenter.peerSettingsDidLoad, dialog_id);
                            }
                        }
                    } else {
                        toggleMute(true);
                    }
                } else {
                    boolean canDeleteHistory = chatInfo != null && chatInfo.can_delete_channel;
                    AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, false, currentChat, currentUser, currentEncryptedChat != null, true, canDeleteHistory, (param) -> {
                        getNotificationCenter().removeObserver(ChatActivity.this, NotificationCenter.closeChats);
                        getNotificationCenter().postNotificationName(NotificationCenter.closeChats);
                        finishFragment();
                        getNotificationCenter().postNotificationName(NotificationCenter.needDeleteDialog, dialog_id, currentUser, currentChat, param);
                    }, themeDelegate);
                }
            }
        });

        bottomOverlayProgress = new RadialProgressView(context, themeDelegate);
        bottomOverlayProgress.setSize(AndroidUtilities.dp(22));
        bottomOverlayProgress.setProgressColor(getThemedColor(Theme.key_chat_fieldOverlayText));
        bottomOverlayProgress.setVisibility(View.INVISIBLE);
        bottomOverlayProgress.setScaleX(0.1f);
        bottomOverlayProgress.setScaleY(0.1f);
        bottomOverlayProgress.setAlpha(1.0f);
        bottomOverlayChat.addView(bottomOverlayProgress, LayoutHelper.createFrame(30, 30, Gravity.CENTER));

        bottomOverlayImage = new ImageView(context);
        int color = getThemedColor(Theme.key_chat_fieldOverlayText);
        bottomOverlayImage.setImageResource(R.drawable.msg_help);
        bottomOverlayImage.setColorFilter(new PorterDuffColorFilter(color, PorterDuff.Mode.MULTIPLY));
        bottomOverlayImage.setScaleType(ImageView.ScaleType.CENTER);
        if (Build.VERSION.SDK_INT >= 21) {
            bottomOverlayImage.setBackgroundDrawable(Theme.createSelectorDrawable(Color.argb(24, Color.red(color), Color.green(color), Color.blue(color)), 1));
        }
        bottomOverlayChat.addView(bottomOverlayImage, LayoutHelper.createFrame(48, 48, Gravity.RIGHT | Gravity.TOP, 3, 1.5f, 0, 0));
        bottomOverlayImage.setContentDescription(LocaleController.getString("SettingsHelp", R.string.SettingsHelp));
        bottomOverlayImage.setOnClickListener(v -> {
            createUndoView();
            undoView.showWithAction(dialog_id, UndoView.ACTION_TEXT_INFO, LocaleController.getString("BroadcastGroupInfo", R.string.BroadcastGroupInfo));
        });

        contentView.addView(messageEnterTransitionContainer = new MessageEnterTransitionContainer(contentView, currentAccount));

        //缓慢发送模式
        if (currentChat != null) {
            slowModeHint = new HintView(getParentActivity(), 2, themeDelegate);
            slowModeHint.setAlpha(0.0f);
            slowModeHint.setVisibility(View.INVISIBLE);
            contentView.addView(slowModeHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
        }

        chatAdapter.updateRowsSafe();

        //加载信息，没有信息就加载等待界面
        if (loading && messages.isEmpty()) {
            showProgressView(chatAdapter.botInfoRow < 0);
            chatListView.setEmptyView(null);
        } else {
            showProgressView(false);
            createEmptyView();
            chatListView.setEmptyView(emptyViewContainer);
        }

        //检查机器人键盘
        checkBotKeyboard();
        updateBottomOverlay();
        updateSecretStatus();
        updateTopPanel(false);
        updatePinnedMessageView(false);
        updateInfoTopView(false);

        //初始化recycleView
        chatScrollHelper = new RecyclerAnimationScrollHelper(chatListView, chatLayoutManager);
        chatScrollHelper.setScrollListener(this::invalidateMessagesVisiblePart);
        chatScrollHelper.setAnimationCallback(chatScrollHelperCallback);

        flagSecure = new FlagSecureReason(getParentActivity().getWindow(), () -> currentEncryptedChat != null || SharedConfig.passcodeHash.length() > 0 && !SharedConfig.allowScreenCapture || getMessagesController().isChatNoForwards(currentChat));

        if (oldMessage != null) {
            chatActivityEnterView.setFieldText(oldMessage);
        }

        //根据是否为平板重新布局
        fixLayoutInternal();

        //文字选中操作
        textSelectionHelper.setCallback(new TextSelectionHelper.Callback() {
            @Override
            public void onStateChanged(boolean isSelected) {
                swipeBackEnabled = !isSelected;
                if (isSelected) {
                    if (slidingView != null) {
                        slidingView.setSlidingOffset(0);
                        slidingView = null;
                    }
                    maybeStartTrackingSlidingView = false;
                    startedTrackingSlidingView = false;
                    if (textSelectionHint != null) {
                        textSelectionHint.hide();
                    }
                }
                updatePagedownButtonVisibility(true);
            }

            @Override
            public void onTextCopied() {
                if (actionBar != null && actionBar.isActionModeShowed()) {
                    clearSelectionMode();
                }
                createUndoView();
                undoView.showWithAction(0, UndoView.ACTION_TEXT_COPIED, null);
            }
        });

        View overlay = textSelectionHelper.getOverlayView(context);
        if (overlay != null) {
            if (overlay.getParent() instanceof ViewGroup) {
                ((ViewGroup) overlay.getParent()).removeView(overlay);
            }
            contentView.addView(overlay);
        }
        textSelectionHelper.setParentView(chatListView);

        //设置全屏动画特效
        contentView.addView(fireworksOverlay = new FireworksOverlay(context), LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        //检查搜索
        checkInstantSearch();
        //如果有引用，则设置引用
        if (replyingMessageObject != null) {
            chatActivityEnterView.setReplyingMessageObject(replyingMessageObject);
        }

        ViewGroup decorView;
        if (Build.VERSION.SDK_INT >= 21) {
            decorView = (ViewGroup) getParentActivity().getWindow().getDecorView();
        } else {
            decorView = contentView;
        }
        //图片缩放配置
        pinchToZoomHelper = new PinchToZoomHelper(decorView, contentView) {
            @Override
            protected void drawOverlays(Canvas canvas, float alpha, float parentOffsetX, float parentOffsetY, float clipTop, float clipBottom) {
                if (alpha > 0) {
                    View view = getChild();
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;

                        int top = (int) Math.max(clipTop, parentOffsetY);
                        int bottom = (int) Math.min(clipBottom, parentOffsetY + cell.getMeasuredHeight());
                        AndroidUtilities.rectTmp.set(parentOffsetX, top, parentOffsetX + cell.getMeasuredWidth(), bottom);
                        canvas.saveLayerAlpha(AndroidUtilities.rectTmp, (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                        canvas.translate(parentOffsetX, parentOffsetY);
                        cell.drawFromPinchToZoom = true;
                        cell.drawOverlays(canvas);
                        if (cell.shouldDrawTimeOnMedia() && cell.getCurrentMessagesGroup() == null) {
                            cell.drawTime(canvas, 1f, false);
                        }
                        cell.drawFromPinchToZoom = false;
                        canvas.restore();
                    }
                }
            }
        };
        pinchToZoomHelper.setCallback(new PinchToZoomHelper.Callback() {

            @Override
            public TextureView getCurrentTextureView() {
                return videoTextureView;
            }

            @Override
            public void onZoomStarted(MessageObject messageObject) {
                chatListView.cancelClickRunnables(true);
                chatListView.stopScroll();
                if (MediaController.getInstance().isPlayingMessage(messageObject)) {
                    contentView.removeView(videoPlayerContainer);
                    videoPlayerContainer = null;
                    videoTextureView = null;
                    aspectRatioFrameLayout = null;
                }

                for (int i = 0; i < chatListView.getChildCount(); i++) {
                    if (chatListView.getChildAt(i) instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) chatListView.getChildAt(i);
                        if (cell.getMessageObject().getId() == messageObject.getId()) {
                            cell.getPhotoImage().setVisible(false, true);
                        }
                    }
                }
            }

            @Override
            public void onZoomFinished(MessageObject messageObject) {
                if (messageObject == null) {
                    return;
                }
                if (MediaController.getInstance().isPlayingMessage(messageObject)) {
                    for (int i = 0; i < chatListView.getChildCount(); i++) {
                        if (chatListView.getChildAt(i) instanceof ChatMessageCell) {
                            ChatMessageCell cell = (ChatMessageCell) chatListView.getChildAt(i);
                            if (cell.getMessageObject().getId() == messageObject.getId()) {
                                AnimatedFileDrawable animation = cell.getPhotoImage().getAnimation();
                                if (animation.isRunning()) {
                                    animation.stop();
                                }
                                if (animation != null) {
                                    Bitmap bitmap = animation.getAnimatedBitmap();
                                    if (bitmap != null) {
                                        try {
                                            Bitmap src = pinchToZoomHelper.getVideoBitmap(bitmap.getWidth(), bitmap.getHeight());
                                            Canvas canvas = new Canvas(bitmap);
                                            canvas.drawBitmap(src, 0, 0, null);
                                            src.recycle();
                                        } catch (Throwable e) {
                                            FileLog.e(e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    createTextureView(true);
                    MediaController.getInstance().setTextureView(videoTextureView, aspectRatioFrameLayout, videoPlayerContainer, true);
                }
                chatListView.invalidate();
            }

        });
        pinchToZoomHelper.setClipBoundsListener(topBottom -> {
            topBottom[1] = chatListView.getBottom() - blurredViewBottomOffset;
            topBottom[0] = chatListView.getTop() + chatListViewPaddingTop - AndroidUtilities.dp(4);
        });
        //表情动画配置
        emojiAnimationsOverlay = new EmojiAnimationsOverlay(ChatActivity.this, contentView, chatListView, currentAccount, dialog_id, threadMessageId) {
            @Override
            public void onAllEffectsEnd() {
                updateMessagesVisiblePart(false);
            }
        };
        //背景模糊配置
        actionBar.setDrawBlurBackground(contentView);
        if(getUserConfig().isHideToolbar) {
            actionBar.setHide(true);
        }

        if (isTopic) {
            reactionsMentionCount = forumTopic.unread_reactions_count;
            updateReactionsMentionButton(false);
        } else {
            TLRPC.Dialog dialog = getMessagesController().dialogs_dict.get(dialog_id);
            if (dialog != null) {
                reactionsMentionCount = dialog.unread_reactions_count;
                updateReactionsMentionButton(false);
            }
        }

        return fragmentView;
    }

    //核心底部长按复制
    private void createBottomMessagesActionButtons() {
        if (replyButton != null || getContext() == null) {
            return;
        }

        replyButton = new TextView(getContext());
        replyButton.setText(LocaleController.getString("Reply", R.string.Reply));
        replyButton.setGravity(Gravity.CENTER_VERTICAL);
        replyButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 15);
        replyButton.setPadding(AndroidUtilities.dp(14), 0, AndroidUtilities.dp(21), 0);
        replyButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
        replyButton.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        replyButton.setCompoundDrawablePadding(AndroidUtilities.dp(7));
        replyButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        Drawable image = getContext().getResources().getDrawable(R.drawable.input_reply).mutate();
        image.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), PorterDuff.Mode.MULTIPLY));
        replyButton.setCompoundDrawablesWithIntrinsicBounds(image, null, null, null);
        //点击底部引用按钮
        replyButton.setOnClickListener(v -> {
            MessageObject messageObject = null;
            for (int a = 1; a >= 0; a--) {
                if (messageObject == null && selectedMessagesIds[a].size() != 0) {
                    messageObject = messagesDict[a].get(selectedMessagesIds[a].keyAt(0));
                }
                selectedMessagesIds[a].clear();
                selectedMessagesCanCopyIds[a].clear();
                selectedMessagesCanStarIds[a].clear();
            }
            hideActionMode();
            if (messageObject != null && (messageObject.messageOwner.id > 0 || messageObject.messageOwner.id < 0 && currentEncryptedChat != null)) {
                showFieldPanelForReply(messageObject);
            }
            updatePinnedMessageView(true);
            updateVisibleRows();
            updateSelectedMessageReactions();
        });
        bottomMessagesActionContainer.addView(replyButton, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));

        if (BuildVars.IS_CHAT_AIR) replyButton.setVisibility(View.GONE);

        forwardButton = new TextView(getContext());
        forwardButton.setText(LocaleController.getString("Forward", R.string.Forward));
        forwardButton.setGravity(Gravity.CENTER_VERTICAL);
        forwardButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 15);
        forwardButton.setPadding(AndroidUtilities.dp(21), 0, AndroidUtilities.dp(21), 0);
        forwardButton.setCompoundDrawablePadding(AndroidUtilities.dp(6));
        forwardButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
        forwardButton.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        forwardButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        image = getContext().getResources().getDrawable(R.drawable.input_forward).mutate();
        image.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), PorterDuff.Mode.MULTIPLY));
        forwardButton.setCompoundDrawablesWithIntrinsicBounds(image, null, null, null);
        //点击底部转发按钮
        forwardButton.setOnClickListener(v -> openForward(false));
        if (BuildVars.IS_CHAT_AIR) forwardButton.setVisibility(View.GONE);
        bottomMessagesActionContainer.addView(forwardButton, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.RIGHT | Gravity.TOP));

        if(!BuildVars.IS_CHAT_AIR) return;
        //分享按钮
        shareButton = new TextView(getContext());
        shareButton.setText(LocaleController.getString("Share", R.string.Share));
        shareButton.setGravity(Gravity.CENTER_VERTICAL);
        shareButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 15);
        shareButton.setPadding(AndroidUtilities.dp(21), 0, AndroidUtilities.dp(21), 0);
        shareButton.setCompoundDrawablePadding(AndroidUtilities.dp(6));
        shareButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
        shareButton.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        shareButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        image = getContext().getResources().getDrawable(R.drawable.share).mutate();
        image.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), PorterDuff.Mode.MULTIPLY));
        shareButton.setCompoundDrawablesWithIntrinsicBounds(image, null, null, null);
        shareButton.setOnClickListener(v -> {
            openShare();
        });
        bottomMessagesActionContainer.addView(shareButton, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));

        //复制按钮
        copyButton = new TextView(getContext());
        copyButton.setText(LocaleController.getString("Copy", R.string.Copy));
        copyButton.setGravity(Gravity.CENTER_VERTICAL);
        copyButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 15);
        copyButton.setPadding(AndroidUtilities.dp(21), 0, AndroidUtilities.dp(21), 0);
        copyButton.setCompoundDrawablePadding(AndroidUtilities.dp(6));
        copyButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
        copyButton.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        copyButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        image = getContext().getResources().getDrawable(R.drawable.msg_copy).mutate();
        image.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), PorterDuff.Mode.MULTIPLY));
        copyButton.setCompoundDrawablesWithIntrinsicBounds(image, null, null, null);
        copyButton.setOnClickListener(v -> {
            openCopy();
        });
        bottomMessagesActionContainer.addView(copyButton, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.RIGHT | Gravity.TOP));

    }

    private void checkInstantSearch() {
        final long searchFromUserId = getArguments().getInt("search_from_user_id", 0);
        if (searchFromUserId != 0) {
            TLRPC.User user = getMessagesController().getUser(searchFromUserId);
            if (user != null) {
                openSearchWithText("");
                if (searchUserButton != null) {
                    searchUserButton.callOnClick();
                }
                searchUserMessages(user, null);
            }
        } else {
            final long searchFromChatId = getArguments().getInt("search_from_chat_id", 0);
            if (searchFromChatId != 0) {
                TLRPC.Chat chat = getMessagesController().getChat(searchFromChatId);
                if (chat != null) {
                    openSearchWithText("");
                    if (searchUserButton != null) {
                        searchUserButton.callOnClick();
                    }
                    searchUserMessages(null, chat);
                }
            }
        }
    }

    private void createTopPanel() {
        if (topChatPanelView != null || getContext() == null) {
            return;
        }

        topChatPanelView = new BlurredFrameLayout(getContext(), contentView) {

            private boolean ignoreLayout;

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int width = MeasureSpec.getSize(widthMeasureSpec);
                if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE && reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                    width = (width - AndroidUtilities.dp(31)) / 2;
                }
                ignoreLayout = true;
                if (reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) reportSpamButton.getLayoutParams();
                    layoutParams.width = width;
                    if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE) {
                        reportSpamButton.setPadding(AndroidUtilities.dp(4), 0, AndroidUtilities.dp(4), 0);
                        layoutParams.leftMargin = width;
                        layoutParams.width -= AndroidUtilities.dp(15);
                    } else {
                        reportSpamButton.setPadding(AndroidUtilities.dp(48), 0, AndroidUtilities.dp(48), 0);
                        layoutParams.leftMargin = 0;
                    }
                }
                if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) addToContactsButton.getLayoutParams();
                    layoutParams.width = width;
                    if (reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                        addToContactsButton.setPadding(AndroidUtilities.dp(11), 0, AndroidUtilities.dp(4), 0);
                    } else {
                        addToContactsButton.setPadding(AndroidUtilities.dp(48), 0, AndroidUtilities.dp(48), 0);
                        layoutParams.leftMargin = 0;
                    }
                }
                ignoreLayout = false;
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }


            @Override
            public void requestLayout() {
                if (ignoreLayout) {
                    return;
                }
                super.requestLayout();
            }
        };
        topChatPanelView.backgroundColor = getThemedColor(Theme.key_chat_topPanelBackground);
        topChatPanelView.backgroundPaddingBottom = AndroidUtilities.dp(2);
        topChatPanelView.setTag(1);
        topChatPanelViewOffset = -AndroidUtilities.dp(50);
        invalidateChatListViewTopPadding();
        topChatPanelView.setClickable(true);
        topChatPanelView.setVisibility(View.GONE);
        topChatPanelView.setBackgroundResource(R.drawable.blockpanel);
        topChatPanelView.getBackground().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelBackground), PorterDuff.Mode.MULTIPLY));
        int index = 8;
        if (pinnedMessageView != null && pinnedMessageView.getParent() == contentView) {
            index = contentView.indexOfChild(pinnedMessageView) + 1;
        }
        contentView.addView(topChatPanelView, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 50, Gravity.TOP | Gravity.LEFT));

        reportSpamButton = new TextView(getContext());
        reportSpamButton.setTextColor(getThemedColor(Theme.key_chat_reportSpam));
        if (Build.VERSION.SDK_INT >= 21) {
            reportSpamButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_chat_reportSpam) & 0x19ffffff, 3));
        }
        reportSpamButton.setTag(Theme.key_chat_reportSpam);
        reportSpamButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        reportSpamButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        reportSpamButton.setSingleLine(true);
        reportSpamButton.setMaxLines(1);
        reportSpamButton.setGravity(Gravity.CENTER);
        topChatPanelView.addView(reportSpamButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        reportSpamButton.setOnClickListener(v2 -> AlertsCreator.showBlockReportSpamAlert(ChatActivity.this, dialog_id, currentUser, currentChat, currentEncryptedChat, reportSpamButton.getTag(R.id.object_tag) != null, chatInfo, param -> {
            if (param == 0) {
                updateTopPanel(true);
            } else {
                finishFragment();
            }
        }, themeDelegate));

        emojiStatusSpamHint = new LinkSpanDrawable.LinksTextView(getContext(), themeDelegate) {
            Layout lastLayout;
            AnimatedEmojiSpan.EmojiGroupedSpans stack;
            PorterDuffColorFilter colorFilter;
            int lastColor;

            @Override
            protected void onDetachedFromWindow() {
                super.onDetachedFromWindow();
                AnimatedEmojiSpan.release(this, stack);
                lastLayout = null;
            }

            @Override
            protected void dispatchDraw(Canvas canvas) {
                super.dispatchDraw(canvas);
                if (lastLayout != getLayout()) {
                    stack = AnimatedEmojiSpan.update(AnimatedEmojiDrawable.CACHE_TYPE_EMOJI_STATUS, this, stack, lastLayout = getLayout());
                }
                int color = getThemedColor(Theme.key_windowBackgroundWhiteBlueIcon);
                if (lastColor != color || colorFilter == null) {
                    colorFilter = new PorterDuffColorFilter(color, PorterDuff.Mode.MULTIPLY);
                    lastColor = color;
                }
                AnimatedEmojiSpan.drawAnimatedEmojis(canvas, getLayout(), stack, 0, null, 0, 0, 0, 1f, colorFilter);
            }
        };
        emojiStatusSpamHint.setTextColor(getThemedColor(Theme.key_chat_topPanelMessage));
        emojiStatusSpamHint.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 13.3f);
        emojiStatusSpamHint.setGravity(Gravity.CENTER);
        emojiStatusSpamHint.setVisibility(View.GONE);
        emojiStatusSpamHint.setLinkTextColor(getThemedColor(Theme.key_windowBackgroundWhiteLinkText));
        topChatPanelView.addView(emojiStatusSpamHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 25, 0, 25, 1));

        topViewSeparator1 = new View(getContext());
        topViewSeparator1.setVisibility(View.GONE);
        topViewSeparator1.setBackgroundColor(getThemedColor(Theme.key_divider));
        topViewSeparator1.setAlpha(.5f);
        topChatPanelView.addView(topViewSeparator1, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 2));
        topViewSeparator2 = new View(getContext());
        topViewSeparator2.setVisibility(View.GONE);
        topViewSeparator2.setBackgroundColor(getThemedColor(Theme.key_divider));
        topChatPanelView.addView(topViewSeparator2, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.TOP, 10, 48, 10, 1));
        topViewSeparator3 = new View(getContext());
        topViewSeparator3.setVisibility(View.GONE);
        topViewSeparator3.setBackgroundColor(getThemedColor(Theme.key_divider));
        topChatPanelView.addView(topViewSeparator3, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 38));

        addToContactsButton = new TextView(getContext());
        addToContactsButton.setTextColor(getThemedColor(Theme.key_chat_addContact));
        addToContactsButton.setVisibility(View.GONE);
        addToContactsButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        addToContactsButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        addToContactsButton.setSingleLine(true);
        addToContactsButton.setMaxLines(1);
        addToContactsButton.setPadding(AndroidUtilities.dp(4), 0, AndroidUtilities.dp(4), 0);
        addToContactsButton.setGravity(Gravity.CENTER);
        if (Build.VERSION.SDK_INT >= 21) {
            addToContactsButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_chat_addContact) & 0x19ffffff, 3));
        }
        topChatPanelView.addView(addToContactsButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        addToContactsButton.setOnClickListener(v -> {
            if (addToContactsButtonArchive) {
                getMessagesController().addDialogToFolder(dialog_id, 0, 0, 0);
                createUndoView();
                undoView.showWithAction(dialog_id, UndoView.ACTION_CHAT_UNARCHIVED, null);
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("dialog_bar_archived" + dialog_id, false);
                editor.putBoolean("dialog_bar_block" + dialog_id, false);
                editor.putBoolean("dialog_bar_report" + dialog_id, false);
                editor.commit();
                updateTopPanel(false);
                getNotificationsController().clearDialogNotificationsSettings(dialog_id, getTopicId());
            } else if (addToContactsButton.getTag() != null && (Integer) addToContactsButton.getTag() == 4) {
                if (chatInfo != null && chatInfo.participants != null) {
                    LongSparseArray<TLObject> users = new LongSparseArray<>();
                    for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                        users.put(chatInfo.participants.participants.get(a).user_id, null);
                    }
                    long chatId = chatInfo.id;
                    InviteMembersBottomSheet bottomSheet = new InviteMembersBottomSheet(getContext(), currentAccount, users, chatInfo.id, ChatActivity.this, themeDelegate);
                    bottomSheet.setDelegate((users1, fwdCount) -> {
                        getMessagesController().addUsersToChat(currentChat, ChatActivity.this, users1, fwdCount, null, null, null);
                        getMessagesController().hidePeerSettingsBar(dialog_id, currentUser, currentChat);
                        updateTopPanel(true);
                        updateInfoTopView(true);
                    });
                    bottomSheet.show();
                }
            } else if (addToContactsButton.getTag() != null) {
                shareMyContact(1, null);
            } else {
                Bundle args = new Bundle();
                args.putLong("user_id", currentUser.id);
                args.putBoolean("addContact", true);
                ContactAddActivity activity = new ContactAddActivity(args);
                activity.setDelegate(() -> {
                    createUndoView();
                    undoView.showWithAction(dialog_id, UndoView.ACTION_CONTACT_ADDED, currentUser);
                });
                presentFragment(activity);
            }
        });

        restartTopicButton = new TextView(getContext());
        restartTopicButton.setTextColor(getThemedColor(Theme.key_chat_addContact));
        restartTopicButton.setVisibility(View.GONE);
        restartTopicButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        restartTopicButton.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        restartTopicButton.setSingleLine(true);
        restartTopicButton.setMaxLines(1);
        restartTopicButton.setPadding(AndroidUtilities.dp(4), 0, AndroidUtilities.dp(4), 0);
        restartTopicButton.setGravity(Gravity.CENTER);
        restartTopicButton.setText(LocaleController.getString("RestartTopic", R.string.RestartTopic).toUpperCase());
        if (Build.VERSION.SDK_INT >= 21) {
            restartTopicButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_chat_addContact) & 0x19ffffff, 3));
        }
        topChatPanelView.addView(restartTopicButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        restartTopicButton.setOnClickListener(v -> {
            getMessagesController().getTopicsController().toggleCloseTopic(currentChat.id, forumTopic.id, forumTopic.closed = false);
            updateTopicButtons();
            updateBottomOverlay();
            updateTopPanel(true);
        });

        closeReportSpam = new ImageView(getContext());
        closeReportSpam.setImageResource(R.drawable.miniplayer_close);
        closeReportSpam.setContentDescription(LocaleController.getString("Close", R.string.Close));
        if (Build.VERSION.SDK_INT >= 21) {
            closeReportSpam.setBackground(Theme.AdaptiveRipple.circle(getThemedColor(Theme.key_chat_topPanelClose)));
        }
        closeReportSpam.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        closeReportSpam.setScaleType(ImageView.ScaleType.CENTER);
        topChatPanelView.addView(closeReportSpam, LayoutHelper.createFrame(36, 36, Gravity.RIGHT | Gravity.TOP, 0, 6, 2, 0));
        closeReportSpam.setOnClickListener(v -> {
            long did = dialog_id;
            if (currentEncryptedChat != null) {
                did = currentUser.id;
            }
            getMessagesController().hidePeerSettingsBar(did, currentUser, currentChat);
            updateTopPanel(true);
            updateInfoTopView(true);
        });
    }

    private void createTranslateButton() {
        if (translateButton != null || getContext() == null) {
            return;
        }

        createTopPanel();
        translateButton = new TranslateButton(getContext(), this, themeDelegate) {
            @Override
            protected void onButtonClick() {
                if (getUserConfig().isPremium()) {
                    getMessagesController().getTranslateController().toggleTranslatingDialog(getDialogId());
                } else {
                    MessagesController.getNotificationsSettings(currentAccount).edit().putInt("dialog_show_translate_count" + getDialogId(), 14).commit();
                    showDialog(new PremiumFeatureBottomSheet(ChatActivity.this, PremiumPreviewFragment.PREMIUM_FEATURE_TRANSLATIONS, false));
                }
                updateTopPanel(true);
            }
        };
        topChatPanelView.addView(translateButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 36, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 2));
    }

    //创建底部提示tips
    private void createUndoView() {
        if (undoView != null || getContext() == null) {
            return;
        }
        undoView = new UndoView(getContext(), this, false, themeDelegate);
        undoView.setAdditionalTranslationY(AndroidUtilities.dp(51));
        contentView.addView(undoView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.BOTTOM | Gravity.LEFT, 8, 0, 8, 8));
    }

    @Override
    public INavigationLayout.BackButtonState getBackButtonState() {
        return INavigationLayout.BackButtonState.BACK;
    }

    //创建顶栏actionBar个性化按钮，用于选中多个聊天内容
    private void createActionMode() {
        if (selectedMessagesCountTextView != null || getContext() == null) {
            return;
        }
        final ActionBarMenu actionMode = actionBar.createActionMode();

        selectedMessagesCountTextView = new NumberTextView(actionMode.getContext());
        selectedMessagesCountTextView.setTextSize(18);
        selectedMessagesCountTextView.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        selectedMessagesCountTextView.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        selectedMessagesCountTextView.setOnTouchListener((v, event) -> true);
        actionMode.addView(selectedMessagesCountTextView, LayoutHelper.createLinear(0, LayoutHelper.MATCH_PARENT, 1.0f, 65, 0, 0, 0));

        if (currentEncryptedChat == null) {
            if (!BuildVars.IS_CHAT_AIR) actionModeViews.add(actionMode.addItemWithWidth(save_to, R.drawable.msg_download, AndroidUtilities.dp(54), LocaleController.getString("SaveToMusic", R.string.SaveToMusic)));
            if (!BuildVars.IS_CHAT_AIR) actionModeViews.add(actionMode.addItemWithWidth(edit, R.drawable.msg_edit, AndroidUtilities.dp(54), LocaleController.getString("Edit", R.string.Edit)));
            actionModeViews.add(actionMode.addItemWithWidth(star, R.drawable.msg_fave, AndroidUtilities.dp(54), LocaleController.getString("AddToFavorites", R.string.AddToFavorites)));
            actionModeViews.add(actionMode.addItemWithWidth(copy, R.drawable.msg_copy, AndroidUtilities.dp(54), LocaleController.getString("Copy", R.string.Copy)));
            if (!BuildVars.IS_CHAT_AIR) actionModeViews.add(actionMode.addItemWithWidth(forward, R.drawable.msg_forward, AndroidUtilities.dp(54), LocaleController.getString("Forward", R.string.Forward)));
            if (BuildVars.IS_CHAT_AIR) actionModeViews.add(actionMode.addItemWithWidth(share, R.drawable.share, AndroidUtilities.dp(54), LocaleController.getString("Share", R.string.Share)));
            actionModeViews.add(actionMode.addItemWithWidth(delete, R.drawable.msg_delete, AndroidUtilities.dp(54), LocaleController.getString("Delete", R.string.Delete)));
        } else {
            actionModeViews.add(actionMode.addItemWithWidth(edit, R.drawable.msg_edit, AndroidUtilities.dp(54), LocaleController.getString("Edit", R.string.Edit)));
            actionModeViews.add(actionMode.addItemWithWidth(star, R.drawable.msg_fave, AndroidUtilities.dp(54), LocaleController.getString("AddToFavorites", R.string.AddToFavorites)));
            actionModeViews.add(actionMode.addItemWithWidth(copy, R.drawable.msg_copy, AndroidUtilities.dp(54), LocaleController.getString("Copy", R.string.Copy)));
            actionModeViews.add(actionMode.addItemWithWidth(delete, R.drawable.msg_delete, AndroidUtilities.dp(54), LocaleController.getString("Delete", R.string.Delete)));
        }
        if (!BuildVars.IS_CHAT_AIR) actionMode.getItem(edit).setVisibility(canEditMessagesCount == 1 && selectedMessagesIds[0].size() + selectedMessagesIds[1].size() == 1 ? View.VISIBLE : View.GONE);
        actionMode.getItem(copy).setVisibility(!getMessagesController().isChatNoForwards(currentChat) && selectedMessagesCanCopyIds[0].size() + selectedMessagesCanCopyIds[1].size() != 0 ? View.VISIBLE : View.GONE);
        if (BuildVars.IS_CHAT_AIR) actionMode.getItem(share).setVisibility(!getMessagesController().isChatNoForwards(currentChat) && selectedMessagesCanCopyIds[0].size() + selectedMessagesCanCopyIds[1].size() != 0 ? View.VISIBLE : View.GONE);
        actionMode.getItem(star).setVisibility(selectedMessagesCanStarIds[0].size() + selectedMessagesCanStarIds[1].size() != 0 ? View.VISIBLE : View.GONE);
        actionMode.getItem(delete).setVisibility(cantDeleteMessagesCount == 0 ? View.VISIBLE : View.GONE);
    }

    private void createSearchContainer() {
        if (searchContainer != null || getContext() == null) {
            return;
        }

        searchContainer = new BlurredFrameLayout(getContext(), contentView) {
            @Override
            public void onDraw(Canvas canvas) {
                int bottom = Theme.chat_composeShadowDrawable.getIntrinsicHeight();
                if (chatActivityEnterView.getVisibility() != View.VISIBLE) {
                    Theme.chat_composeShadowDrawable.setBounds(0, 0, getMeasuredWidth(), bottom);
                    Theme.chat_composeShadowDrawable.draw(canvas);
                }
                AndroidUtilities.rectTmp2.set(0, bottom, getMeasuredWidth(), getMeasuredHeight());
                contentView.drawBlurRect(canvas, getY(), AndroidUtilities.rectTmp2, getThemedPaint(Theme.key_paint_chatComposeBackground), false);
            }

            @Override
            protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
                if (child == searchCountText) {
                    int leftMargin = 14;
                    if (searchCalendarButton != null && searchCalendarButton.getVisibility() != GONE) {
                        leftMargin += 48;
                    }
                    if (searchUserButton != null && searchUserButton.getVisibility() != GONE) {
                        leftMargin += 48;
                    }
                    ((MarginLayoutParams) child.getLayoutParams()).leftMargin = AndroidUtilities.dp(leftMargin);
                }
                super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
            }
        };
        searchContainer.drawBlur = false;
        searchContainer.isTopView = false;
        searchContainer.setWillNotDraw(false);
        searchContainer.setVisibility(View.INVISIBLE);
        searchContainer.setPadding(0, AndroidUtilities.dp(3), 0, 0);
        searchContainer.setClipToPadding(false);

        searchAsListTogglerView = new View(getContext());
        searchAsListTogglerView.setOnTouchListener((v, event) -> getMediaDataController().getFoundMessageObjects().size() <= 1);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            searchAsListTogglerView.setBackground(Theme.getSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), false));
        }
        searchAsListTogglerView.setOnClickListener(v -> {
            if (getMediaDataController().getFoundMessageObjects().size() > 1) {
                if (searchAsListHint != null) {
                    searchAsListHint.hide();
                }
                toggleMesagesSearchListView();
                if (!SharedConfig.searchMessagesAsListUsed) {
                    SharedConfig.setSearchMessagesAsListUsed(true);
                }
            }
        });
        final float paddingTop = Theme.chat_composeShadowDrawable.getIntrinsicHeight() / AndroidUtilities.density - 3f;
        searchContainer.addView(searchAsListTogglerView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, paddingTop, 0, 0));

        searchUpButton = new ImageView(getContext());
        searchUpButton.setScaleType(ImageView.ScaleType.CENTER);
        searchUpButton.setImageResource(R.drawable.msg_go_up);
        searchUpButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
        searchUpButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
        searchContainer.addView(searchUpButton, LayoutHelper.createFrame(48, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 48, 0));
        searchUpButton.setOnClickListener(view -> {
            getMediaDataController().searchMessagesInChat(null, dialog_id, mergeDialogId, classGuid, 1, threadMessageId, searchingUserMessages, searchingChatMessages);
            showMessagesSearchListView(false);
            if (!SharedConfig.searchMessagesAsListUsed && SharedConfig.searchMessagesAsListHintShows < 3 && !searchAsListHintShown && Math.random() <= 0.25) {
                showSearchAsListHint();
                searchAsListHintShown = true;
                SharedConfig.increaseSearchAsListHintShows();
            }
        });
        searchUpButton.setContentDescription(LocaleController.getString("AccDescrSearchNext", R.string.AccDescrSearchNext));

        searchDownButton = new ImageView(getContext());
        searchDownButton.setScaleType(ImageView.ScaleType.CENTER);
        searchDownButton.setImageResource(R.drawable.msg_go_down);
        searchDownButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
        searchDownButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
        searchContainer.addView(searchDownButton, LayoutHelper.createFrame(48, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 0, 0));
        searchDownButton.setOnClickListener(view -> {
            getMediaDataController().searchMessagesInChat(null, dialog_id, mergeDialogId, classGuid, 2, threadMessageId, searchingUserMessages, searchingChatMessages);
            showMessagesSearchListView(false);
        });
        searchDownButton.setContentDescription(LocaleController.getString("AccDescrSearchPrev", R.string.AccDescrSearchPrev));

        if (currentChat != null && (!ChatObject.isChannel(currentChat) || currentChat.megagroup)) {
            searchUserButton = new ImageView(getContext());
            searchUserButton.setScaleType(ImageView.ScaleType.CENTER);
            searchUserButton.setImageResource(R.drawable.msg_usersearch);
            searchUserButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
            searchUserButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
            searchContainer.addView(searchUserButton, LayoutHelper.createFrame(48, 48, Gravity.LEFT | Gravity.TOP, 48, 0, 0, 0));
            searchUserButton.setOnClickListener(view -> {
                if (mentionContainer != null) {
                    mentionContainer.setReversed(true);
                    mentionContainer.getAdapter().setSearchingMentions(true);
                }
                searchCalendarButton.setVisibility(View.GONE);
                searchUserButton.setVisibility(View.GONE);
                searchingForUser = true;
                searchingUserMessages = null;
                searchingChatMessages = null;
                searchItem.setSearchFieldHint(LocaleController.getString("SearchMembers", R.string.SearchMembers));
                searchItem.setSearchFieldCaption(LocaleController.getString("SearchFrom", R.string.SearchFrom));
                AndroidUtilities.showKeyboard(searchItem.getSearchField());
                searchItem.clearSearchText();
            });
            searchUserButton.setContentDescription(LocaleController.getString("AccDescrSearchByUser", R.string.AccDescrSearchByUser));
        }

        searchCalendarButton = new ImageView(getContext());
        searchCalendarButton.setScaleType(ImageView.ScaleType.CENTER);
        searchCalendarButton.setImageResource(R.drawable.msg_calendar);
        searchCalendarButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
        searchCalendarButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
        searchContainer.addView(searchCalendarButton, LayoutHelper.createFrame(48, 48, Gravity.LEFT | Gravity.TOP));
        searchCalendarButton.setOnClickListener(view -> {
            if (getParentActivity() == null) {
                return;
            }
            AndroidUtilities.hideKeyboard(searchItem.getSearchField());
            showDialog(AlertsCreator.createCalendarPickerDialog(getParentActivity(), 1375315200000L, new MessagesStorage.IntCallback() {
                @Override
                public void run(int param) {
                    jumpToDate(param);
                }
            }, themeDelegate).create());
        });
        searchCalendarButton.setContentDescription(LocaleController.getString("JumpToDate", R.string.JumpToDate));

        searchCountText = new SearchCounterView(getContext(), themeDelegate);
        searchCountText.setGravity(Gravity.LEFT);
        searchContainer.addView(searchCountText, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.CENTER_VERTICAL, 0, 0, 108, 0));
        contentView.addView(searchContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, searchContainerHeight, Gravity.BOTTOM));
    }

    public void onPageDownClicked() {
        wasManualScroll = true;
        textSelectionHelper.cancelTextSelectionRunnable();
        Runnable inCaseLoading = () -> {
            setPagedownLoading(true, true);
        };
        if (createUnreadMessageAfterId != 0) {
            scrollToMessageId(createUnreadMessageAfterId, 0, false, returnToLoadIndex, true, 0, inCaseLoading);
        } else if (returnToMessageId > 0) {
            scrollToMessageId(returnToMessageId, 0, true, returnToLoadIndex, true, 0, inCaseLoading);
        } else {
            scrollToLastMessage(false, true, inCaseLoading);
            if (!pinnedMessageIds.isEmpty()) {
                forceScrollToFirst = true;
                forceNextPinnedMessageId = pinnedMessageIds.get(0);
            }
        }
    }

    public ActionBarMenuItem getHeaderItem() {
        return headerItem;
    }

    private void playReactionAnimation(Integer messageId) {
        if (fragmentView == null) {
            return;
        }
        ChatMessageCell cell = findMessageCell(messageId, false);
        if (cell != null) {
            TLRPC.MessagePeerReaction reaction = cell.getMessageObject().getRandomUnreadReaction();
            if (reaction != null && cell.reactionsLayoutInBubble.hasUnreadReactions) {
                ReactionsEffectOverlay.show(ChatActivity.this, null, cell, null,0, 0, ReactionsLayoutInBubble.VisibleReaction.fromTLReaction(reaction.reaction), currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                ReactionsEffectOverlay.startAnimation();
            }
            cell.markReactionsAsRead();
        }
    }

    private void dimBehindView(View view, boolean enable) {
        setScrimView(view);
        dimBehindView(enable ? 0.2f : 0, view != reactionsMentiondownButton && view != mentiondownButton);
    }

    private void dimBehindView(View view, float value) {
        setScrimView(view);
        dimBehindView(value, view != reactionsMentiondownButton && view != mentiondownButton);
    }

    private void setScrimView(View scrimView) {
        if (this.scrimView == scrimView) {
            return;
        }
        if (this.scrimView != null) {
            if (this.scrimView instanceof ChatActionCell) {
                ((ChatActionCell) this.scrimView).setInvalidateWithParent(null);
            }
        }
        this.scrimView = scrimView;
        if (this.scrimView instanceof ChatActionCell) {
            ((ChatActionCell) this.scrimView).setInvalidateWithParent(fragmentView);
        }
    }
    public void dimBehindView(boolean enable) {
        dimBehindView(enable ? 0.2f : 0, true);
    }

    private void checkInstantCameraView() {
        if (instantCameraView != null || getContext() == null) {
            return;
        }
        instantCameraView = new InstantCameraView(getContext(), this, themeDelegate);
        contentView.addView(instantCameraView, 21, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));
    }

    private void dimBehindView(float value,  boolean hidePagedownButtons) {
        boolean enable = value > 0;
        if (scrimView instanceof ChatMessageCell) {
            ChatMessageCell cell = (ChatMessageCell) scrimView;
            cell.setInvalidatesParent(enable);
            if (enable) {
                restartSticker(cell);
            }
        }
        contentView.invalidate();
        chatListView.invalidate();
        if (scrimAnimatorSet != null) {
            scrimAnimatorSet.removeAllListeners();
            scrimAnimatorSet.cancel();
        }
        scrimAnimatorSet = new AnimatorSet();
        ArrayList<Animator> animators = new ArrayList<>();
        ValueAnimator scrimPaintAlphaAnimator;
        if (enable) {
            scrimViewAlpha = 1f;
            if (scrimViewAlphaAnimator != null) {
                scrimViewAlphaAnimator.cancel();
            }
            animators.add(scrimPaintAlphaAnimator = ValueAnimator.ofFloat(0, value));
        } else {
            animators.add(scrimPaintAlphaAnimator = ValueAnimator.ofFloat(scrimPaintAlpha, 0));
        }
        scrimPaintAlphaAnimator.addUpdateListener(a -> {
            scrimPaintAlpha = (float) a.getAnimatedValue();
            if (fragmentView != null) {
                fragmentView.invalidate();
            }
        });
        if (!enable || hidePagedownButtons) {
            if (pagedownButton != null) {
                animators.add(ObjectAnimator.ofFloat(pagedownButton, View.ALPHA, enable ? 0 : 1));
            }
            if (mentiondownButton != null) {
                animators.add(ObjectAnimator.ofFloat(mentiondownButton, View.ALPHA, enable ? 0 : 1));
            }
            if (reactionsMentiondownButton != null) {
                animators.add(ObjectAnimator.ofFloat(reactionsMentiondownButton, View.ALPHA, enable ? 0 : 1));
            }
        }
        scrimAnimatorSet.playTogether(animators);
        scrimAnimatorSet.setDuration(enable ? 150 : 220);
        scrimAnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (!enable) {
                    setScrimView(null);
                    scrimViewReaction = null;
                    contentView.invalidate();
                    chatListView.invalidate();
                }
            }
        });
        if (scrimView != null && scrimViewAlpha <= 0f) {
            setScrimView(null);
        }
        scrimAnimatorSet.start();
    }

    private class PinnedMessageButton extends TextView {
        public PinnedMessageButton(Context context) {
            super(context);

            setSingleLine(true);
            setLines(1);
            setMaxLines(1);
            setEllipsize(TextUtils.TruncateAt.END);
            setTextColor(getThemedColor(Theme.key_featuredStickers_buttonText));
            setBackground(Theme.AdaptiveRipple.filledRect(getThemedColor(Theme.key_featuredStickers_addButton), 16));
            setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
            setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
            setGravity(Gravity.CENTER);
            setPadding(AndroidUtilities.dp(14), 0, AndroidUtilities.dp(14), 0);
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(
                View.MeasureSpec.makeMeasureSpec(Math.min(View.MeasureSpec.getSize(widthMeasureSpec), (int) (AndroidUtilities.displaySize.x * 0.45f)), View.MeasureSpec.AT_MOST),
                heightMeasureSpec
            );
        }
    }

    private boolean filledEditTextItemMenu = false;
    private void checkEditTextItemMenu() {
        if (filledEditTextItemMenu) {
            return;
        }

        ActionBarMenuItem item = editTextItem.createView();
        item.addSubItem(text_spoiler, LocaleController.getString("Spoiler", R.string.Spoiler));
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder(LocaleController.getString("Bold", R.string.Bold));
        stringBuilder.setSpan(new TypefaceSpan(AndroidUtilities.getTypeface("fonts/rmedium.ttf")), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_bold, stringBuilder);
        stringBuilder = new SpannableStringBuilder(LocaleController.getString("Italic", R.string.Italic));
        stringBuilder.setSpan(new TypefaceSpan(AndroidUtilities.getTypeface("fonts/ritalic.ttf")), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_italic, stringBuilder);
        stringBuilder = new SpannableStringBuilder(LocaleController.getString("Mono", R.string.Mono));
        stringBuilder.setSpan(new TypefaceSpan(Typeface.MONOSPACE), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_mono, stringBuilder);
        if (currentEncryptedChat == null || AndroidUtilities.getPeerLayerVersion(currentEncryptedChat.layer) >= 101) {
            stringBuilder = new SpannableStringBuilder(LocaleController.getString("Strike", R.string.Strike));
            TextStyleSpan.TextStyleRun run = new TextStyleSpan.TextStyleRun();
            run.flags |= TextStyleSpan.FLAG_STYLE_STRIKE;
            stringBuilder.setSpan(new TextStyleSpan(run), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            item.addSubItem(text_strike, stringBuilder);

            stringBuilder = new SpannableStringBuilder(LocaleController.getString("Underline", R.string.Underline));
            run = new TextStyleSpan.TextStyleRun();
            run.flags |= TextStyleSpan.FLAG_STYLE_UNDERLINE;
            stringBuilder.setSpan(new TextStyleSpan(run), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            item.addSubItem(text_underline, stringBuilder);
        }
        item.addSubItem(text_link, LocaleController.getString("CreateLink", R.string.CreateLink));
        item.addSubItem(text_regular, LocaleController.getString("Regular", R.string.Regular));

        filledEditTextItemMenu = true;
    }

    private void updatePagedownButtonsPosition() {
        float baseTranslationY = chatActivityEnterView.getAnimatedTop() + chatActivityEnterView.getTranslationY() + (chatActivityEnterTopView.getVisibility() == View.VISIBLE ? chatActivityEnterTopView.getTranslationY() : 0);
        if (pagedownButton != null) {
            pagedownButton.setTranslationY(baseTranslationY + AndroidUtilities.dp(100) * (1f - pagedownButtonEnterProgress));
        }
        if (mentiondownButton != null) {
            mentiondownButton.setTranslationY(baseTranslationY + AndroidUtilities.dp(100) * (1f - mentionsButtonEnterProgress) - (AndroidUtilities.dp(72) * pagedownButtonEnterProgress) * mentionsButtonEnterProgress);
        }
        if (reactionsMentiondownButton != null) {
            reactionsMentiondownButton.setTranslationY(baseTranslationY + AndroidUtilities.dp(100) * (1f - reactionsMentionButtonEnterProgress) - ((AndroidUtilities.dp(50) + AndroidUtilities.dp(22) * pagedownButtonCounter.getEnterProgress()) * pagedownButtonEnterProgress + AndroidUtilities.dp(72) * mentionsButtonEnterProgress) * reactionsMentionButtonEnterProgress);
        }
        if (suggestEmojiPanel != null) {
            suggestEmojiPanel.setTranslationY(baseTranslationY);
        }
    }

    private void updateReactionsMentionButton(boolean animated) {
        if (reactionsMentiondownButtonCounter == null || getParentActivity() == null) {
            return;
        }
        boolean visible = reactionsMentionCount > 0 && chatMode == 0;
        reactionsMentiondownButtonCounter.setCount(reactionsMentionCount, animated);
        if (visible && reactionsMentiondownButton.getTag() == null) {
            reactionsMentiondownButton.setTag(1);
            if (reactionsMentionButtonAnimation != null) {
                reactionsMentionButtonAnimation.removeAllListeners();
                reactionsMentionButtonAnimation.cancel();
                reactionsMentionButtonAnimation = null;
            }
            if (animated) {
                reactionsMentiondownButton.setVisibility(View.VISIBLE);
                reactionsMentionButtonAnimation = ValueAnimator.ofFloat(reactionsMentionButtonEnterProgress, 1f);
                reactionsMentionButtonAnimation.addUpdateListener(valueAnimator -> {
                    reactionsMentionButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                    contentView.invalidate();
                });
                reactionsMentionButtonAnimation.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        reactionsMentionButtonEnterProgress = 1f;
                        contentView.invalidate();
                    }
                });
                reactionsMentionButtonAnimation.setDuration(200);
                reactionsMentionButtonAnimation.start();
            } else {
                reactionsMentiondownButton.setVisibility(View.VISIBLE);
                reactionsMentionButtonEnterProgress = 1f;
                contentView.invalidate();
            }
        } else if (!visible && reactionsMentiondownButton.getTag() != null) {
            reactionsMentiondownButton.setTag(null);
            if (reactionsMentionButtonAnimation != null) {
                reactionsMentionButtonAnimation.removeAllListeners();
                reactionsMentionButtonAnimation.cancel();
                reactionsMentionButtonAnimation = null;
            }
            if (animated) {
                reactionsMentiondownButton.setVisibility(View.VISIBLE);
                reactionsMentionButtonAnimation = ValueAnimator.ofFloat(reactionsMentionButtonEnterProgress, 0f);
                reactionsMentionButtonAnimation.addUpdateListener(valueAnimator -> {
                    reactionsMentionButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                    contentView.invalidate();
                });
                reactionsMentionButtonAnimation.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        reactionsMentiondownButton.setVisibility(View.INVISIBLE);
                        reactionsMentionButtonEnterProgress = 0f;
                        contentView.invalidate();
                    }
                });
                reactionsMentionButtonAnimation.setDuration(200);
                reactionsMentionButtonAnimation.start();
            } else {
                reactionsMentiondownButton.setVisibility(View.INVISIBLE);
                reactionsMentionButtonEnterProgress = 0f;
                contentView.invalidate();
            }
        }

    }

    private void openForwardingPreview() {
        boolean keyboardVisible = chatActivityEnterView.isKeyboardVisible();
        forwardingPreviewView = new ForwardingPreviewView(contentView.getContext(), forwardingMessages, currentUser, currentChat, currentAccount, themeDelegate) {
            @Override
            protected void onDismiss(boolean canShowKeyboard) {
                checkShowBlur(true);
                if (forwardingMessages != null) {
                    ArrayList<MessageObject> selectedMessage = new ArrayList<>();
                    forwardingMessages.getSelectedMessages(selectedMessage);
                    showFieldPanelForForward(true, selectedMessage);
                }

                if (keyboardVisible && canShowKeyboard) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.openKeyboard();
                        }
                    }, 50);
                }

                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }

            @Override
            protected void selectAnotherChat() {
                super.selectAnotherChat();
                dismiss(false);
                if (forwardingMessages != null) {
                    int hasPoll = 0;
                    boolean hasInvoice = false;
                    for (int a = 0, N = forwardingMessages.messages.size(); a < N; a++) {
                        MessageObject messageObject = forwardingMessages.messages.get(a);
                        if (messageObject.isPoll()) {
                            if (hasPoll != 2) {
                                hasPoll = messageObject.isPublicPoll() ? 2 : 1;
                            }
                        } else if (messageObject.isInvoice()) {
                            hasInvoice = true;
                        }
                        selectedMessagesIds[0].put(messageObject.getId(), messageObject);
                    }
                    Bundle args = new Bundle();
                    args.putBoolean("onlySelect", true);
                    args.putInt("dialogsType", DialogsActivity.DIALOGS_TYPE_FORWARD);
                    args.putInt("hasPoll", hasPoll);
                    args.putBoolean("hasInvoice", hasInvoice);
                    args.putInt("messagesCount", forwardingMessages.messages.size());
                    args.putBoolean("canSelectTopics", true);
                    DialogsActivity fragment = new DialogsActivity(args);
                    fragment.setDelegate(ChatActivity.this);
                    presentFragment(fragment);
                }
            }

            @Override
            protected void didSendPressed() {
                super.didSendPressed();
                dismiss(true);
                chatActivityEnterView.getSendButton().callOnClick();
            }
        };
        TLRPC.Peer defPeer = chatInfo != null ? chatInfo.default_send_as : null;
        if (defPeer == null && sendAsPeersObj != null && !sendAsPeersObj.peers.isEmpty()) {
            defPeer = sendAsPeersObj.peers.get(0).peer;
        }
        forwardingPreviewView.setSendAsPeer(defPeer);
        checkShowBlur(true);
        contentView.addView(forwardingPreviewView);

        if (keyboardVisible) {
            chatActivityEnterView.showEmojiView();
            openKeyboardOnAttachMenuClose = true;
        }
        AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
        fragmentView.requestLayout();
    }

    private void animateToNextChat() {
        if (pullingDownDrawable == null) {
            return;
        }
//        if (getParentLayout().fragmentsStack.size() > 1) {
//            BaseFragment previousFragment = getParentLayout().fragmentsStack.get(getParentLayout().fragmentsStack.size() - 2);
//            if (previousFragment instanceof ChatActivity) {
//                getParentLayout().fragmentsStack.remove(getParentLayout().fragmentsStack.size() - 2);
//            }
//        }
        addToPulledDialogsMyself();
        addToPulledDialogs(pullingDownDrawable.nextChat, pullingDownDrawable.nextDialogId, pullingDownDrawable.dialogFolderId, pullingDownDrawable.dialogFilterId);
        Bundle bundle = new Bundle();
        bundle.putLong("chat_id", pullingDownDrawable.getChatId());
        bundle.putInt("dialog_folder_id", pullingDownDrawable.dialogFolderId);
        bundle.putInt("dialog_filter_id", pullingDownDrawable.dialogFilterId);
        bundle.putBoolean("pulled", true);
        SharedPreferences sharedPreferences = MessagesController.getNotificationsSettings(currentAccount);
        sharedPreferences.edit().remove("diditem" + pullingDownDrawable.nextDialogId).apply();
        ChatActivity chatActivity = new ChatActivity(bundle);
        chatActivity.setPullingDownTransition(true);
        replacingChatActivity = true;
        presentFragment(chatActivity, true);
    }

    private void addToPulledDialogsMyself() {
        if (getParentLayout() == null) {
            return;
        }
        int stackIndex = getParentLayout().getFragmentStack().indexOf(this);
        BackButtonMenu.addToPulledDialogs(this, stackIndex, currentChat, currentUser, dialog_id, dialogFilterId, dialogFolderId);
    }
    private void addToPulledDialogs(TLRPC.Chat chat, long dialogId, int folderId, int filterId) {
        if (getParentLayout() == null) {
            return;
        }
        int stackIndex = getParentLayout().getFragmentStack().indexOf(this);
        BackButtonMenu.addToPulledDialogs(this, stackIndex, chat, null, dialogId, folderId, filterId);
    }

    private void setPullingDownTransition(boolean fromPullingDownTransition) {
        this.fromPullingDownTransition = fromPullingDownTransition;
    }

    public void setSwitchFromTopics(boolean switchFromTopics) {
        this.switchFromTopics = switchFromTopics;
    }
    private void updateBulletinLayout() {
        Bulletin bulletin = Bulletin.getVisibleBulletin();
        if (bulletin != null && bulletinDelegate != null) {
            bulletin.updatePosition();
        }
    }

    private void searchUserMessages(TLRPC.User user, TLRPC.Chat chat) {
        searchingUserMessages = user;
        searchingChatMessages = chat;
        if (searchItem == null || mentionContainer == null || searchingUserMessages == null && searchingChatMessages == null) {
            return;
        }
        String name;
        if (searchingUserMessages != null) {
            name = searchingUserMessages.first_name;
            if (TextUtils.isEmpty(name)) {
                name = searchingUserMessages.last_name;
            }
        } else {
            name = searchingChatMessages.title;
        }
        if (name == null) {
            return;
        }
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        searchingForUser = false;
        String from = LocaleController.getString("SearchFrom", R.string.SearchFrom);
        Spannable spannable = new SpannableString(from + " " + name);
        spannable.setSpan(new ForegroundColorSpan(getThemedColor(Theme.key_actionBarDefaultSubtitle)), from.length() + 1, spannable.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        searchItem.setSearchFieldCaption(spannable);
        mentionContainer.getAdapter().searchUsernameOrHashtag(null, 0, null, false, true);
        searchItem.setSearchFieldHint(null);
        searchItem.clearSearchText();
        getMediaDataController().searchMessagesInChat("", dialog_id, mergeDialogId, classGuid, 0, threadMessageId, searchingUserMessages, searchingChatMessages);
    }

    private void updateTranslateItemVisibility() {
        if (translateItem == null) {
            return;
        }
        translateItem.setVisibility(getMessagesController().getTranslateController().isTranslateDialogHidden(getDialogId()) && getMessagesController().getTranslateController().isDialogTranslatable(getDialogId()) ? View.VISIBLE : View.GONE);
    }

    private Animator infoTopViewAnimator;

    private void updateInfoTopView(boolean animated) {
        if (contentView == null) {
            return;
        }
        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
        distanceToPeer = preferences.getInt("dialog_bar_distance" + dialog_id, -1);

        CharSequence text = null;
        View.OnClickListener onClickListener = null;
        if (distanceToPeer >= 0 && currentUser != null) {
            text = LocaleController.formatString("ChatDistanceToPeer", R.string.ChatDistanceToPeer, currentUser.first_name, LocaleController.formatDistance(distanceToPeer, 0));
            onClickListener = v -> presentFragment(new PeopleNearbyActivity());
        } else if (currentChat != null && chatInviterId != 0) {
            boolean show = preferences.getInt("dialog_bar_vis3" + dialog_id, 0) == 2;
            boolean showReport = preferences.getBoolean("dialog_bar_report" + dialog_id, false);
            boolean showBlock = preferences.getBoolean("dialog_bar_block" + dialog_id, false);
            if (show && (showReport || showBlock)) {
                TLRPC.User user = getMessagesController().getUser(chatInviterId);
                if (user != null) {
                    text = ChatObject.isChannel(currentChat) && !currentChat.megagroup ? LocaleController.getString("ActionUserInvitedToChannel", R.string.ActionUserInvitedToChannel) : LocaleController.getString("ActionUserInvitedToGroup", R.string.ActionUserInvitedToGroup);
                    text = MessageObject.replaceWithLink(text, "un1", user);
                    onClickListener = (v) -> {
                        Bundle args = new Bundle();
                        args.putLong("user_id", chatInviterId);
                        presentFragment(new ProfileActivity(args));
                    };
                }
            } else {
                hideInfoView();
            }
        }
        if (text != null) {
            if (infoTopViewAnimator != null) {
                infoTopViewAnimator.cancel();
            }
            if (infoTopView == null) {
                infoTopView = new ChatActionCell(contentView.getContext(), false, themeDelegate);
                infoTopView.setCustomText(text);
                infoTopView.setInvalidateColors(true);
                infoTopView.setOnClickListener(onClickListener);
                contentView.addView(infoTopView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.CENTER_HORIZONTAL, 0, 0, 0, 0));
            }
            if (animated) {
                if (infoTopView.getTag() == null) {
                    ValueAnimator a = ValueAnimator.ofFloat(0, 1f);
                    infoTopView.setTag(1);
                    infoTopView.setAlpha(0f);
                    View distanceTopViewFinal = infoTopView;
                    a.addUpdateListener(animation -> {
                        float alpha = (float) animation.getAnimatedValue();
                        topViewOffset = (alpha) * AndroidUtilities.dp(30);
                        invalidateChatListViewTopPadding();
                        distanceTopViewFinal.setAlpha(alpha);
                    });
                    a.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            topViewOffset = AndroidUtilities.dp(30);
                            invalidateChatListViewTopPadding();
                        }
                    });
                    a.setDuration(150);
                    infoTopViewAnimator = a;
                    a.start();
                }
            } else {
                infoTopView.setTag(1);
                topViewOffset = AndroidUtilities.dp(30);
                invalidateChatListViewTopPadding();
            }
        }
    }

    private void checkTopUndoView() {
        if (topUndoView != null) {
            return;
        }
        topUndoView = new UndoView(getContext(), this, true, themeDelegate) {
            @Override
            public void didPressUrl(CharacterStyle span) {
                didPressMessageUrl(span, false, null, null);
            }

            @Override
            public void showWithAction(long did, int action, Object infoObject, Object infoObject2, Runnable actionRunnable, Runnable cancelRunnable) {
                setAdditionalTranslationY(fragmentContextView != null && fragmentContextView.isCallTypeVisible() ? AndroidUtilities.dp(fragmentContextView.getStyleHeight()) : 0);
                super.showWithAction(did, action, infoObject, infoObject2, actionRunnable, cancelRunnable);
            }
        };
        contentView.addView(topUndoView, 17, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.LEFT, 8, 8, 8, 0));
    }

    private void createPinnedMessageView() {
        if (currentEncryptedChat != null || pinnedMessageView != null || getContext() == null) {
            return;
        }
        pinnedMessageView = new BlurredFrameLayout(getContext(), contentView) {

            float lastY;
            float startY;

            {
                setOnLongClickListener(v -> {
                    if (AndroidUtilities.isTablet() || isThreadChat()) {
                        return false;
                    }
                    startY = lastY;
                    openPinnedMessagesList(true);
                    return true;
                });
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                lastY = event.getY();
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    finishPreviewFragment();
                } else if (event.getAction() == MotionEvent.ACTION_MOVE) {
                    float dy = startY - lastY;
                    movePreviewFragment(dy);
                    if (dy < 0) {
                        startY = lastY;
                    }
                }
                return super.onTouchEvent(event);
            }

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (setPinnedTextTranslationX) {
                    for (int a = 0; a < pinnedNextAnimation.length; a++) {
                        if (pinnedNextAnimation[a] != null) {
                            pinnedNextAnimation[a].start();
                        }
                    }
                    setPinnedTextTranslationX = false;
                }
            }

            @Override
            protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
                if (child == pinnedLineView) {
                    canvas.save();
                    canvas.clipRect(0, 0, getMeasuredWidth(), AndroidUtilities.dp(48));
                }
                boolean result;
                if (child == pinnedMessageTextView[0] || child == pinnedMessageTextView[1]) {
                    canvas.save();
                    canvas.clipRect(0,0,getMeasuredWidth() - AndroidUtilities.dp(38),getMeasuredHeight());
                    result = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                } else {
                    result = super.drawChild(canvas, child, drawingTime);
                    if (child == pinnedLineView) {
                        canvas.restore();
                    }
                }

                return result;
            }
        };
        pinnedMessageView.setTag(1);
        pinnedMessageEnterOffset = -AndroidUtilities.dp(50);
        pinnedMessageView.setVisibility(View.GONE);
        pinnedMessageView.setBackgroundResource(R.drawable.blockpanel);
        pinnedMessageView.backgroundColor = getThemedColor(Theme.key_chat_topPanelBackground);
        pinnedMessageView.backgroundPaddingBottom = AndroidUtilities.dp(2);
        pinnedMessageView.getBackground().mutate().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelBackground), PorterDuff.Mode.MULTIPLY));
        int index = 8;
        if (topChatPanelView != null && topChatPanelView.getParent() == contentView) {
            index = contentView.indexOfChild(topChatPanelView);
        }
        contentView.addView(pinnedMessageView, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 50, Gravity.TOP | Gravity.LEFT));
        pinnedMessageView.setOnClickListener(v -> {
            wasManualScroll = true;
            if (isThreadChat() && !isTopic) {
                scrollToMessageId(threadMessageId, 0, true, 0, true, 0);
            } else if (currentPinnedMessageId != 0) {
                int currentPinned = currentPinnedMessageId;

                int forceNextPinnedMessageId = 0;
                if (!pinnedMessageIds.isEmpty()) {
                    if (currentPinned == pinnedMessageIds.get(pinnedMessageIds.size() - 1)) {
                        forceNextPinnedMessageId = pinnedMessageIds.get(0) + 1;
                        forceScrollToFirst = true;
                    } else {
                        forceNextPinnedMessageId = currentPinned - 1;
                        forceScrollToFirst = false;
                    }
                }
                this.forceNextPinnedMessageId = forceNextPinnedMessageId;
                if (!forceScrollToFirst) {
                    forceNextPinnedMessageId = -forceNextPinnedMessageId;
                }
                scrollToMessageId(currentPinned, 0, true, 0, true, forceNextPinnedMessageId);
                updateMessagesVisiblePart(false);
            }
        });
        pinnedMessageView.setEnabled(!isInPreviewMode());

        View selector = new View(getContext());
        selector.setBackground(Theme.getSelectorDrawable(false));
        pinnedMessageView.addView(selector, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 2));

        pinnedLineView = new PinnedLineView(getContext(), themeDelegate);
        pinnedMessageView.addView(pinnedLineView, LayoutHelper.createFrame(2, 48, Gravity.LEFT | Gravity.TOP, 8, 0, 0, 0));
        pinnedMessageView.setClipChildren(false);

        pinnedCounterTextView = new NumberTextView(getContext());
        pinnedCounterTextView.setAddNumber();
        pinnedCounterTextView.setTextSize(14);
        pinnedCounterTextView.setTextColor(getThemedColor(Theme.key_chat_topPanelTitle));
        pinnedCounterTextView.setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
        pinnedMessageView.addView(pinnedCounterTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 7, 44, 0));

        for (int a = 0; a < 2; a++) {
            pinnedNameTextView[a] = new TrackingWidthSimpleTextView(getContext());
            pinnedNameTextView[a].setTextSize(14);
            pinnedNameTextView[a].setTextColor(getThemedColor(Theme.key_chat_topPanelTitle));
            pinnedNameTextView[a].setTypeface(AndroidUtilities.getTypeface("fonts/rmedium.ttf"));
            pinnedMessageView.addView(pinnedNameTextView[a], LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 7.3f, 44, 0));

            pinnedMessageTextView[a] = new SimpleTextView(getContext()) {
                @Override
                public void setTranslationY(float translationY) {
                    super.setTranslationY(translationY);
                    if (this == pinnedMessageTextView[0] && pinnedNextAnimation[1] != null) {
                        if (forceScrollToFirst && translationY < 0) {
                            pinnedLineView.setTranslationY(translationY / 2);
                        } else {
                            pinnedLineView.setTranslationY(0);
                        }
                    }
                }
            };
            pinnedMessageTextView[a].setTextSize(14);
            pinnedMessageTextView[a].setTextColor(getThemedColor(Theme.key_chat_topPanelMessage));
            pinnedMessageView.addView(pinnedMessageTextView[a], LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 25.3f, 44, 0));

            pinnedMessageButton[a] = new PinnedMessageButton(getContext());
            pinnedMessageView.addView(pinnedMessageButton[a], LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 28, Gravity.TOP | Gravity.RIGHT, 0, 10, 14, 0));

            pinnedMessageImageView[a] = new BackupImageView(getContext()) {
                private SpoilerEffect spoilerEffect = new SpoilerEffect();
                private Path path = new Path();
                private float[] radii = new float[8];

                @Override
                protected void onDraw(Canvas canvas) {
                    super.onDraw(canvas);

                    if (hasBlur) {
                        canvas.save();
                        AndroidUtilities.rectTmp.set(0, 0, getWidth(), getHeight());

                        int[] rad = imageReceiver.getRoundRadius();
                        radii[0] = radii[1] = rad[0];
                        radii[2] = radii[3] = rad[1];
                        radii[4] = radii[5] = rad[2];
                        radii[6] = radii[7] = rad[3];

                        path.rewind();
                        path.addRoundRect(AndroidUtilities.rectTmp, radii, Path.Direction.CW);
                        canvas.clipPath(path);

                        int sColor = Color.WHITE;
                        spoilerEffect.setColor(ColorUtils.setAlphaComponent(sColor, (int) (Color.alpha(sColor) * 0.325f)));
                        spoilerEffect.setBounds(0, 0, getWidth(), getHeight());
                        spoilerEffect.draw(canvas);

                        canvas.restore();
                        invalidate();
                    }
                }
            };
            pinnedMessageImageView[a].setBlurAllowed(true);
            pinnedMessageImageView[a].setRoundRadius(AndroidUtilities.dp(2));
            pinnedMessageView.addView(pinnedMessageImageView[a], LayoutHelper.createFrame(32, 32, Gravity.TOP | Gravity.LEFT, 17, 8, 0, 0));
            if (a == 1) {
                pinnedNameTextView[a].setVisibility(View.INVISIBLE);
                pinnedMessageButton[a].setVisibility(View.INVISIBLE);
                pinnedMessageTextView[a].setVisibility(View.INVISIBLE);
                pinnedMessageImageView[a].setVisibility(View.INVISIBLE);
            }
        }

        pinnedListButton = new ImageView(getContext());
        pinnedListButton.setImageResource(R.drawable.msg_pinnedlist);
        pinnedListButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        pinnedListButton.setScaleType(ImageView.ScaleType.CENTER);
        pinnedListButton.setContentDescription(LocaleController.getString("AccPinnedMessagesList", R.string.AccPinnedMessagesList));
        pinnedListButton.setVisibility(View.INVISIBLE);
        pinnedListButton.setAlpha(0.0f);
        pinnedListButton.setScaleX(0.4f);
        pinnedListButton.setScaleY(0.4f);
        if (Build.VERSION.SDK_INT >= 21) {
            pinnedListButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff));
        }
        pinnedMessageView.addView(pinnedListButton, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 7, 0));
        pinnedListButton.setOnClickListener(v -> openPinnedMessagesList(false));

        closePinned = new ImageView(getContext());
        closePinned.setImageResource(R.drawable.miniplayer_close);
        closePinned.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        closePinned.setScaleType(ImageView.ScaleType.CENTER);
        closePinned.setVisibility(View.GONE);
        closePinned.setContentDescription(LocaleController.getString("Close", R.string.Close));

        pinnedProgress = new RadialProgressView(getContext(), themeDelegate);
        pinnedProgress.setVisibility(View.GONE);
        pinnedProgress.setSize(AndroidUtilities.dp(16));
        pinnedProgress.setStrokeWidth(2f);
        pinnedProgress.setProgressColor(getThemedColor(Theme.key_chat_topPanelLine));
        pinnedMessageView.addView(pinnedProgress, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 2, 0));

        if (Build.VERSION.SDK_INT >= 21) {
            closePinned.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff, 1, AndroidUtilities.dp(14)));
        }
        pinnedMessageView.addView(closePinned, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 2, 0));
        closePinned.setOnClickListener(v -> {
            if (getParentActivity() == null) {
                return;
            }
            boolean allowPin;
            if (currentChat != null) {
                allowPin = ChatObject.canPinMessages(currentChat);
            } else if (currentEncryptedChat == null) {
                if (userInfo != null) {
                    allowPin = userInfo.can_pin_message;
                } else {
                    allowPin = false;
                }
            } else {
                allowPin = false;
            }
            if (allowPin) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                builder.setTitle(LocaleController.getString("UnpinMessageAlertTitle", R.string.UnpinMessageAlertTitle));
                builder.setMessage(LocaleController.getString("UnpinMessageAlert", R.string.UnpinMessageAlert));
                builder.setPositiveButton(LocaleController.getString("UnpinMessage", R.string.UnpinMessage), (dialogInterface, i) -> {
                    MessageObject messageObject = pinnedMessageObjects.get(currentPinnedMessageId);
                    if (messageObject == null) {
                        messageObject = messagesDict[0].get(currentPinnedMessageId);
                    }
                    unpinMessage(messageObject);
                });
                builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), null);
                showDialog(builder.create());
            } else if (!pinnedMessageIds.isEmpty()) {
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                updatePinnedMessageView(true);
            }
        });

        updatePinnedListButton(false);
    }

    private void openAnotherForward() {
        if (forwardingMessages == null || forwardingMessages.messages == null) {
            return;
        }
        boolean fewSenders = false;
        long lastPeerId = 0;
        long dialogId = 0;
        for (int a = 0, N = forwardingMessages.messages.size(); a < N; a++) {
            MessageObject message = forwardingMessages.messages.get(a);
            if (lastPeerId == 0) {
                dialogId = message.getDialogId();
                lastPeerId = message.getFromChatId();
            } else if (lastPeerId != message.getFromChatId()) {
                fewSenders = true;
                break;
            }
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
        builder.setButtonsVertical(true);
        String message;
        if (dialogId > 0) {
            TLRPC.User user = getMessagesController().getUser(dialogId);
            if (user == null) {
                return;
            }
            message = LocaleController.formatString("CancelForwardPrivate", R.string.CancelForwardPrivate, LocaleController.formatPluralString("MessagesBold", forwardingMessages.messages.size()), ContactsController.formatName(user.first_name, user.last_name));
        } else {
            TLRPC.Chat chat = getMessagesController().getChat(-dialogId);
            if (chat == null) {
                return;
            }
            message = LocaleController.formatString("CancelForwardChat", R.string.CancelForwardChat, LocaleController.formatPluralString("MessagesBold", forwardingMessages.messages.size()), chat == null ? "" : chat.title);
        }
        builder.setMessage(AndroidUtilities.replaceTags(message));
        builder.setTitle(LocaleController.formatPluralString("messages", forwardingMessages.messages.size()));
        builder.setPositiveButton(LocaleController.getString("CancelForwarding", R.string.CancelForwarding), (dialogInterface, i) -> {
            if (forwardingMessages != null) {
                forwardingMessages = null;
            }
            showFieldPanel(false, null, null, null, foundWebPage, true, 0, true, true);
        });

        builder.setNegativeButton(LocaleController.getString("ShowForwardingOptions", R.string.ShowForwardingOptions), (dialogInterface, i) -> {
            openForwardingPreview();
        });
        AlertDialog dialog = builder.create();
        showDialog(dialog);
        TextView button = (TextView) dialog.getButton(DialogInterface.BUTTON_POSITIVE);
        if (button != null) {
            button.setTextColor(getThemedColor(Theme.key_dialogTextRed));
        }
    }

    private void openPinnedMessagesList(boolean preview) {
        if (getParentActivity() == null || parentLayout == null || parentLayout.getLastFragment() != this || pinnedMessageIds.isEmpty()) {
            return;
        }
        Bundle bundle = new Bundle();
        if (currentChat != null) {
            bundle.putLong("chat_id", currentChat.id);
        } else {
            bundle.putLong("user_id", currentUser.id);
        }
        bundle.putInt("chatMode", MODE_PINNED);
        ChatActivity fragment = new ChatActivity(bundle);
        fragment.pinnedMessageIds = new ArrayList<>(pinnedMessageIds);
        fragment.pinnedMessageObjects = new HashMap<>(pinnedMessageObjects);
        for (int a = 0, N = pinnedMessageIds.size(); a < N; a++) {
            Integer id = pinnedMessageIds.get(a);
            MessageObject object = pinnedMessageObjects.get(id);
            MessageObject object2 = messagesDict[0].get(id);
            if (object == null) {
                object = object2;
            } else if (object2 != null) {
                object.mediaExists = object2.mediaExists;
                object.attachPathExists = object2.attachPathExists;
            }
            if (object != null) {
                fragment.pinnedMessageObjects.put(id, object);
                fragment.updatePinnedTopicStarterMessage();
            }
        }
        fragment.loadedPinnedMessagesCount = loadedPinnedMessagesCount;
        fragment.totalPinnedMessagesCount = isTopic ? pinnedMessageIds.size() : totalPinnedMessagesCount;
        fragment.pinnedEndReached = pinnedEndReached;
        fragment.userInfo = userInfo;
        fragment.chatInfo = chatInfo;
        fragment.chatActivityDelegate = new ChatActivityDelegate() {
            @Override
            public void openReplyMessage(int mid) {
                scrollToMessageId(mid, 0, true, 0, true, 0);
            }

            @Override
            public void openSearch(String text) {
                openSearchWithText(text);
            }

            @Override
            public void onUnpin(boolean all, boolean hide) {
                if (all) {
                    ArrayList<Integer> ids = new ArrayList<>(pinnedMessageIds);
                    ArrayList<MessageObject> objects = new ArrayList<>(pinnedMessageObjects.values());
                    if (hide) {
                        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                        preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                        updatePinnedMessageView(true);
                    } else {
                        getNotificationCenter().postNotificationName(NotificationCenter.didLoadPinnedMessages, dialog_id, ids, false, null, null, 0, 0, true);
                    }
                    if (pinBulletin != null) {
                        pinBulletin.hide();
                    }
                    showPinBulletin = true;
                    int tag = ++pinBullerinTag;
                    int oldTotalPinnedCount = getPinnedMessagesCount();
                    pinBulletin = BulletinFactory.createUnpinAllMessagesBulletin(ChatActivity.this, oldTotalPinnedCount, hide,
                            () -> {
                                if (hide) {
                                    SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                    preferences.edit().remove("pin_" + dialog_id).commit();
                                    updatePinnedMessageView(true);
                                } else {
                                    getNotificationCenter().postNotificationName(NotificationCenter.didLoadPinnedMessages, dialog_id, ids, true, objects, null, 0, oldTotalPinnedCount, pinnedEndReached);
                                }
                                if (tag == pinBullerinTag) {
                                    pinBulletin = null;
                                }
                            },
                            () -> {
                                if (!hide) {
                                    if (isTopic) {
                                        for (int i = 0; i < pinnedMessageIds.size(); i++) {
                                            getMessagesController().pinMessage(currentChat, currentUser, pinnedMessageIds.get(i), true, false, false);
                                        }
                                    } else {
                                        getMessagesController().unpinAllMessages(currentChat, currentUser);
                                    }
                                }
                                if (tag == pinBullerinTag) {
                                    pinBulletin = null;
                                }
                            }, themeDelegate);
                } else {
                    MessageObject messageObject = pinnedMessageObjects.get(currentPinnedMessageId);
                    if (messageObject == null) {
                        messageObject = messagesDict[0].get(currentPinnedMessageId);
                    }
                    unpinMessage(messageObject);
                }
            }
        };
        if (preview) {
            presentFragmentAsPreview(fragment);
            checkShowBlur(true);
        } else {
            presentFragment(fragment, false);
        }
    }

    private void checkShowBlur(boolean animated) {
        boolean show = (parentLayout != null && parentLayout.isInPreviewMode() && !parentLayout.hasIntegratedBlurInPreview() && !inPreviewMode) || (forwardingPreviewView != null && forwardingPreviewView.isShowing());

        if (show && (blurredView == null || blurredView.getTag() == null)) {

            if (blurredView == null) {
                blurredView = new BluredView(fragmentView.getContext(), fragmentView, themeDelegate) {
                    @Override
                    public void setAlpha(float alpha) {
                        super.setAlpha(alpha);
                        fragmentView.invalidate();
                    }

                    @Override
                    public void setVisibility(int visibility) {
                        super.setVisibility(visibility);
                        fragmentView.invalidate();
                    }
                };
                contentView.addView(blurredView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
            } else {
                int idx = contentView.indexOfChild(blurredView);
                if (idx != contentView.getChildCount() - 1) {
                    contentView.removeView(blurredView);
                    contentView.addView(blurredView);
                }
                blurredView.update();
                blurredView.setVisibility(View.VISIBLE);
            }

            blurredView.setAlpha(0.0f);
            blurredView.animate().setListener(null).cancel();
            blurredView.animate().alpha(1f).setListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (fragmentView == null || chatListView == null) {
                        return;
                    }
                    chatListView.invalidate();
                    fragmentView.invalidate();
                }
            }).start();

            blurredView.setTag(1);
        } else if (!show && blurredView != null && blurredView.getTag() != null) {
            blurredView.animate().setListener(null).cancel();
            blurredView.animate().setListener(new HideViewAfterAnimation(blurredView)).alpha(0).start();
            blurredView.setTag(null);
            chatListView.invalidate();
            fragmentView.invalidate();
        }
    }

    @Override
    public int getPreviewHeight() {
        if (chatMode == MODE_PINNED && messages.size() == 2) {
            return getHeightForMessage(messages.get(0)) + AndroidUtilities.dp(80) + actionBar.getActionBarHeight();
        }
        return super.getPreviewHeight();
    }

    boolean animateProgressViewTo;

    private void showProgressView(boolean show) {
        if (progressView == null) {
            return;
        }
        if (DISABLE_PROGRESS_VIEW && !AndroidUtilities.isTablet() && !isComments && currentUser == null && LiteMode.isEnabled(LiteMode.FLAGS_CHAT)) {
            animateProgressViewTo = show;
            return;
        }
        if (fragmentOpened && SharedConfig.animationsEnabled()) {
            if (show == animateProgressViewTo) {
                return;
            }
            animateProgressViewTo = show;
            if (show) {
                if (progressView.getVisibility() != View.VISIBLE) {
                    progressView.setVisibility(View.VISIBLE);
                    progressView.setAlpha(0f);
                    progressView.setScaleX(0.3f);
                    progressView.setScaleY(0.3f);
                }
                progressView.animate().setListener(null).cancel();
                progressView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
            } else {
                progressView.animate().setListener(null).cancel();
                progressView.animate().alpha(0).scaleX(0.3f).scaleY(0.3f).setDuration(150).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        progressView.setVisibility(View.INVISIBLE);
                    }
                }).start();
            }
        } else {
            animateProgressViewTo = show;
            progressView.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
        }
    }

    private void hideInfoView() {
        if (distanceToPeer >= 0) {
            distanceToPeer = -1;
            SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
            preferences.edit().putInt("dialog_bar_distance" + dialog_id, -2).commit();
        }

        if (infoTopViewAnimator != null) {
            infoTopViewAnimator.cancel();
        }
        if (infoTopView != null && infoTopView.getTag() != null) {
            infoTopView.setTag(null);
            View topViewFinal = infoTopView;
            ValueAnimator a = ValueAnimator.ofFloat(1f, 0);
            a.addUpdateListener(animation -> {
                float alpha = (float) animation.getAnimatedValue();
                topViewOffset = (alpha) * AndroidUtilities.dp(30);
                invalidateChatListViewTopPadding();
                invalidateMessagesVisiblePart();
                topViewFinal.setAlpha(alpha);
            });
            a.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    topViewOffset = 0;
                    if (animation == infoTopViewAnimator) {
                        ViewGroup parent = (ViewGroup) topViewFinal.getParent();
                        if (parent != null) {
                            parent.removeView(topViewFinal);
                        }
                        infoTopView = null;
                        infoTopViewAnimator = null;
                    }
                }
            });
            a.setDuration(150);
            infoTopViewAnimator = a;
            a.start();
        }
    }

    private void updateChatListViewTopPadding() {
        if (!invalidateChatListViewTopPadding || chatListView == null || (fixedKeyboardHeight > 0 && searchExpandProgress == 0)) {
            return;
        }
        float topPanelViewH = Math.max(0, topChatPanelView != null && topChatPanelView.getVisibility() == View.VISIBLE ? (topChatPanelView.getLayoutParams().height - AndroidUtilities.dp(2)) : 0);
        topPanelViewH += Math.max(-topPanelViewH, topChatPanelViewOffset);
        float pinnedViewH = 0;
        if (pinnedMessageView != null && pinnedMessageView.getVisibility() == View.VISIBLE) {
            pinnedViewH = Math.max(0, AndroidUtilities.dp(48) + pinnedMessageEnterOffset);
        }
        float pendingViewH = 0;
        View pendingRequestsView = pendingRequestsDelegate != null ? pendingRequestsDelegate.getView() : null;
        if (pendingRequestsView != null && pendingRequestsView.getVisibility() == View.VISIBLE) {
            pendingViewH = Math.max(0, pendingRequestsView.getHeight() + pendingRequestsDelegate.getViewEnterOffset());
        }
        float oldPadding = chatListViewPaddingTop;
        chatListViewPaddingTopOnlyTopViews = topPanelViewH + pinnedViewH;
        chatListViewPaddingTop = AndroidUtilities.dp(4) + contentPaddingTop + topPanelViewH + pinnedViewH + pendingViewH;
        chatListViewPaddingTop += blurredViewTopOffset;
        chatListViewPaddingVisibleOffset = 0;
        chatListViewPaddingTop += contentPanTranslation + bottomPanelTranslationY;
        float searchExpandOffset = 0;
        if (searchExpandProgress != 0 && chatActivityEnterView.getVisibility() == View.VISIBLE) {
            chatListViewPaddingTop -= (searchExpandOffset = searchExpandProgress * (chatActivityEnterView.getMeasuredHeight() - AndroidUtilities.dp(searchContainerHeight)));
        }
        if (bottomPanelTranslationY == 0 && !chatActivityEnterView.panelAnimationInProgress() && (contentView.getLayoutParams().height < 0 || (contentView.getKeyboardHeight() <= AndroidUtilities.dp(20) && chatActivityEnterView.isPopupShowing()))) {
            chatListViewPaddingTop += contentView.getKeyboardHeight() <= AndroidUtilities.dp(20) && !AndroidUtilities.isInMultiwindow && !inBubbleMode ? chatActivityEnterView.getEmojiPadding() : contentView.getKeyboardHeight();
        }
        if (!inPreviewMode && chatActivityEnterView != null) {
            if (chatActivityEnterView.getAnimatedTop() != 0) {
                chatListViewPaddingTop += chatActivityEnterView.getHeightWithTopView() - AndroidUtilities.dp(51) - chatActivityEnterView.getAnimatedTop();
            } else if (!chatActivityEnterView.panelAnimationInProgress())  {
                chatListViewPaddingTop += chatActivityEnterView.getHeightWithTopView() - AndroidUtilities.dp(51);
                if (chatActivityEnterView.currentTopViewAnimation == null) {
                    chatListViewPaddingTop -= chatListView.getTranslationY();
                }
            }
        }

        if (infoTopView != null) {
            infoTopView.setTranslationY(chatListViewPaddingTop - AndroidUtilities.dp(30) + topViewOffset);
            chatListViewPaddingTop += topViewOffset;
            chatListViewPaddingVisibleOffset += topViewOffset;
        }

        if (floatingDateView != null) {
            floatingDateView.setTranslationY(chatListView.getTranslationY() - searchExpandOffset + chatListViewPaddingTop + floatingDateViewOffset - AndroidUtilities.dp(4));
        }

        int p = chatListView.getMeasuredHeight() * 2 / 3;

        if (chatListView != null && chatLayoutManager != null && chatAdapter != null) {
            if (chatListView.getPaddingTop() != p) {
                int firstVisPos = chatLayoutManager.findFirstVisibleItemPosition();
                int lastVisPos = chatLayoutManager.findLastVisibleItemPosition();
                int top = 0;
                MessageObject scrollToMessageObject = null;
                if (firstVisPos != RecyclerView.NO_POSITION) {
                    for (int i = firstVisPos; i <= lastVisPos; i++) {
                        View v = chatLayoutManager.findViewByPosition(i);
                        if (v instanceof ChatMessageCell) {
                            scrollToMessageObject = ((ChatMessageCell) v).getMessageObject();
                            top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                            break;
                        } else if (v instanceof ChatActionCell) {
                            scrollToMessageObject = ((ChatActionCell) v).getMessageObject();
                            top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                            break;
                        }
                    }
                }

                chatListView.setPadding(0, p, 0, AndroidUtilities.dp(3) + blurredViewBottomOffset);

                if (firstVisPos != RecyclerView.NO_POSITION && scrollToMessageObject != null) {
                    chatAdapter.updateRowsSafe();
                    int index = messages.indexOf(scrollToMessageObject);
                    if (index >= 0) {
                        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + index, top);
                    }
                }

                invalidateMessagesVisiblePart();
            }

            chatListView.setTopGlowOffset((int) (chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4)));

            if (oldPadding != chatListViewPaddingTop) {
                int n = chatListView.getChildCount();
                for (int i = 0; i < n; i++) {
                    View child = chatListView.getChildAt(i);
                    int adapterPosition = chatListView.getChildAdapterPosition(child);
                    if (adapterPosition == chatAdapter.getItemCount() - 1) {
                        float padding = chatListViewPaddingTop;
                        if (isThreadChat() && (!isTopic || topicStarterMessageObject != null) && pinnedMessageView != null && pinnedMessageView.getVisibility() == View.VISIBLE) {
                            padding -= Math.max(0, AndroidUtilities.dp(48) + pinnedMessageEnterOffset);
                        }
                        if (child.getTop() > padding) {
                            chatListView.scrollBy(0, (int) (child.getTop() - padding));
                        }
                        break;
                    }
                }
            }

            if (!isThreadChat() && !wasManualScroll && unreadMessageObject != null && chatListView != null) {
                chatListView.scrollBy(0, (int) (oldPadding - chatListViewPaddingTop));
            }
        }

        invalidateChatListViewTopPadding = false;
    }

    private void invalidateChatListViewTopPadding() {
        if (!invalidateChatListViewTopPadding) {
            invalidateChatListViewTopPadding = true;
            if (contentView != null) {
                contentView.invalidate();
            }
            if (chatListView != null) {
                chatListView.invalidate();
            }
        }

        int topPanelHeight = topChatPanelView != null && topChatPanelView.getVisibility() == View.VISIBLE ? ((topChatPanelView.getLayoutParams() == null ? AndroidUtilities.dp(50) : topChatPanelView.getLayoutParams().height) - AndroidUtilities.dp(2)) : 0;
        topPanelHeight = topPanelHeight + (int) Math.max(-topPanelHeight, topChatPanelViewOffset);
        float translation = contentPanTranslation + contentPaddingTop + Math.max(0, topPanelHeight);
        if (pinnedMessageView != null) {
            translation += pinnedMessageEnterOffset;
            pinnedMessageView.setTranslationY(translation);
            translation += AndroidUtilities.dp(48);
        }
        View pendingRequestsView = pendingRequestsDelegate != null ? pendingRequestsDelegate.getView() : null;
        if (pendingRequestsView != null) {
            translation += pendingRequestsDelegate.getViewEnterOffset();
            pendingRequestsView.setTranslationY(translation);
        }
        if (fragmentContextView != null) {
            float from = 0;
            if (fragmentLocationContextView != null && fragmentLocationContextView.getVisibility() == View.VISIBLE) {
                from += AndroidUtilities.dp(36);
            }
            fragmentContextView.setTranslationY(contentPanTranslation + from + fragmentContextView.getTopPadding());
        }
        if (fragmentLocationContextView != null) {
            float from = 0;
            if (fragmentContextView != null && fragmentContextView.getVisibility() == View.VISIBLE) {
                from += AndroidUtilities.dp(fragmentContextView.getStyleHeight()) + fragmentContextView.getTopPadding();
            }
            fragmentLocationContextView.setTranslationY(contentPanTranslation + from + fragmentLocationContextView.getTopPadding());
        }
        if (topChatPanelView != null) {
            topChatPanelView.setTranslationY(contentPanTranslation + contentPaddingTop + topChatPanelViewOffset);
        }
        if (alertView != null && alertView.getVisibility() == View.VISIBLE) {
            alertView.setTranslationY(contentPanTranslation + contentPaddingTop - AndroidUtilities.dp(50) * (1f - alertViewEnterProgress));
        }
        if (bottomOverlayChat != null) {
            bottomOverlayChat.setTranslationY(bottomPanelTranslationYReverse);
        }
        if (bottomMessagesActionContainer != null) {
            bottomMessagesActionContainer.setTranslationY(bottomPanelTranslationYReverse);
        }
        if (undoView != null) {
            undoView.setAdditionalTranslationY(chatActivityEnterView.getHeightWithTopView() - chatActivityEnterView.getAnimatedTop());
        }
    }

    //创建视频通话TextureView
    private TextureView createTextureView(boolean add) {
        if (parentLayout == null) {
            return null;
        }
        AndroidUtilities.cancelRunOnUIThread(destroyTextureViewRunnable);
        if (videoPlayerContainer == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                videoPlayerContainer = new FrameLayout(getParentActivity()) {
                    @Override
                    public void setTranslationY(float translationY) {
                        super.setTranslationY(translationY);
                        contentView.invalidate();
                    }
                };
                videoPlayerContainer.setOutlineProvider(new ViewOutlineProvider() {

                    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
                    @Override
                    public void getOutline(View view, Outline outline) {
                        ImageReceiver imageReceiver = (ImageReceiver) view.getTag(R.id.parent_tag);
                        if (imageReceiver != null) {
                            int[] rad = imageReceiver.getRoundRadius();
                            int maxRad = 0;
                            for (int a = 0; a < 4; a++) {
                                maxRad = Math.max(maxRad, rad[a]);
                            }
                            outline.setRoundRect(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight(), maxRad);
                        } else {
                            outline.setOval(0, 0, AndroidUtilities.roundPlayingMessageSize, AndroidUtilities.roundPlayingMessageSize);
                        }
                    }
                });
                videoPlayerContainer.setClipToOutline(true);
            } else {
                videoPlayerContainer = new FrameLayout(getParentActivity()) {

                    RectF rect = new RectF();

                    @Override
                    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
                        super.onSizeChanged(w, h, oldw, oldh);
                        aspectPath.reset();
                        ImageReceiver imageReceiver = (ImageReceiver) getTag(R.id.parent_tag);
                        if (imageReceiver != null) {
                            int[] rad = imageReceiver.getRoundRadius();
                            int maxRad = 0;
                            for (int a = 0; a < 4; a++) {
                                maxRad = Math.max(maxRad, rad[a]);
                            }
                            rect.set(0, 0, w, h);
                            aspectPath.addRoundRect(rect, AndroidUtilities.dp(4), AndroidUtilities.dp(4), Path.Direction.CW);
                        } else {
                            aspectPath.addCircle(w / 2, h / 2, w / 2, Path.Direction.CW);
                        }
                        aspectPath.toggleInverseFillType();
                    }

                    @Override
                    public void setTranslationY(float translationY) {
                        super.setTranslationY(translationY);
                        contentView.invalidate();
                    }

                    @Override
                    public void setVisibility(int visibility) {
                        super.setVisibility(visibility);
                        if (visibility == VISIBLE) {
                            setLayerType(View.LAYER_TYPE_HARDWARE, null);
                        }
                    }

                    @Override
                    protected void dispatchDraw(Canvas canvas) {
                        super.dispatchDraw(canvas);
                        if (getTag() == null) {
                            canvas.drawPath(aspectPath, aspectPaint);
                        }
                    }
                };
                aspectPath = new Path();
                aspectPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
                aspectPaint.setColor(0xff000000);
                aspectPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            }
            videoPlayerContainer.setWillNotDraw(false);

            aspectRatioFrameLayout = new AspectRatioFrameLayout(getParentActivity());
            aspectRatioFrameLayout.setBackgroundColor(0);
            if (add) {
                videoPlayerContainer.addView(aspectRatioFrameLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.CENTER));
            }

            videoTextureView = new TextureView(getParentActivity());
            videoTextureView.setOpaque(false);
            aspectRatioFrameLayout.addView(videoTextureView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        }
        ViewGroup parent = (ViewGroup) videoPlayerContainer.getParent();
        if (parent != null && parent != contentView) {
            parent.removeView(videoPlayerContainer);
            parent = null;
        }
        if (parent == null) {
            contentView.addView(videoPlayerContainer, 1, new FrameLayout.LayoutParams(AndroidUtilities.roundPlayingMessageSize, AndroidUtilities.roundPlayingMessageSize));
        }
        videoPlayerContainer.setTag(null);
        aspectRatioFrameLayout.setDrawingReady(false);
        return videoTextureView;
    }

    private void destroyTextureView() {
        if (videoPlayerContainer == null || videoPlayerContainer.getParent() == null) {
            return;
        }
        chatListView.invalidateViews();
        aspectRatioFrameLayout.setDrawingReady(false);
        videoPlayerContainer.setTag(null);
        if (Build.VERSION.SDK_INT < 21) {
            videoPlayerContainer.setLayerType(View.LAYER_TYPE_NONE, null);
        }
        contentView.removeView(videoPlayerContainer);
    }

    private boolean hasSelectedNoforwardsMessage() {
        try {
            for (int i = 0; i < selectedMessagesIds.length; ++i) {
                for (int j = 0; j < selectedMessagesIds[i].size(); ++j) {
                    MessageObject msg = selectedMessagesIds[i].valueAt(j);
                    if (msg != null && msg.messageOwner != null && msg.messageOwner.noforwards) {
                        return true;
                    }
                }
            }
        } catch (Exception ignore) {}
        return false;
    }

    private float pagedownLoadingT;
    private ValueAnimator pagedownAnimator;
    private void setPagedownLoading(boolean loading, boolean animated) {
        if (animated && Math.abs(pagedownLoadingT - (loading ? 1 : 0)) > .01f) {
            if (pagedownAnimator != null) {
                pagedownAnimator.cancel();
            }
            final boolean[] startedLoading = new boolean[1];
            pagedownButtonArrow.setVisibility(View.VISIBLE);
            pagedownAnimator = ValueAnimator.ofFloat(pagedownLoadingT, loading ? 1 : 0);
            pagedownAnimator.addUpdateListener(anm -> {
                pagedownLoadingT = (float) anm.getAnimatedValue();

                if (!startedLoading[0] && loading && pagedownLoadingT > .5f) {
                    startedLoading[0] = true;
                    pagedownButtonLoadingDrawable.reset();
                    pagedownButtonLoading.setVisibility(View.VISIBLE);
                }

                pagedownButtonLoading.setAlpha(Math.max(0, (pagedownLoadingT - .5f) * 2));
                pagedownButtonArrow.setScaleX(1f - pagedownLoadingT);
                pagedownButtonArrow.setScaleY(1f - pagedownLoadingT);
            });
            pagedownAnimator.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (loading) {
                        pagedownButtonArrow.setVisibility(View.GONE);
                        if (!startedLoading[0]) {
                            pagedownButtonLoadingDrawable.reset();
                            pagedownButtonLoading.setVisibility(View.VISIBLE);
                        }
                    } else {
                        pagedownButtonLoading.setVisibility(View.GONE);
                    }
                }
            });
            pagedownAnimator.setInterpolator(CubicBezierInterpolator.EASE_OUT);
            pagedownAnimator.setDuration(260);
            pagedownAnimator.start();
        } else {
            if (loading) {
                pagedownButtonArrow.setScaleX(0);
                pagedownButtonArrow.setScaleY(0);
                pagedownButtonArrow.setVisibility(View.GONE);
                pagedownButtonLoading.setVisibility(View.VISIBLE);
            } else {
                pagedownButtonArrow.setScaleX(1);
                pagedownButtonArrow.setScaleY(1);
                pagedownButtonArrow.setVisibility(View.VISIBLE);
                pagedownButtonLoading.setVisibility(View.GONE);
            }
        }
    }

    private void openForward(boolean fromActionBar) {
        if (getMessagesController().isChatNoForwards(currentChat) || hasSelectedNoforwardsMessage()) {
            // We should update text if user changed locale without re-opening chat activity
            String str;
            if (getMessagesController().isChatNoForwards(currentChat)) {
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup) {
                    str = LocaleController.getString("ForwardsRestrictedInfoChannel", R.string.ForwardsRestrictedInfoChannel);
                } else {
                    str = LocaleController.getString("ForwardsRestrictedInfoGroup", R.string.ForwardsRestrictedInfoGroup);
                }
            } else {
                str = LocaleController.getString("ForwardsRestrictedInfoBot", R.string.ForwardsRestrictedInfoBot);
            }
            if (fromActionBar) {
                if (fwdRestrictedTopHint == null) {
                    SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
                    int index = frameLayout.indexOfChild(chatActivityEnterView);
                    if (index == -1) {
                        return;
                    }
                    fwdRestrictedTopHint = new HintView(getParentActivity(), 7, true);
                    frameLayout.addView(fwdRestrictedTopHint, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 12, 0, 12, 0));
                    fwdRestrictedTopHint.setAlpha(0.0f);
                    fwdRestrictedTopHint.setVisibility(View.INVISIBLE);
                }

                fwdRestrictedTopHint.setText(str);
                fwdRestrictedTopHint.showForView(actionBar.getActionMode().getItem(forward), true);
            } else {
                if (fwdRestrictedBottomHint == null) {
                    SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
                    int index = frameLayout.indexOfChild(chatActivityEnterView);
                    if (index == -1) {
                        return;
                    }
                    fwdRestrictedBottomHint = new HintView(getParentActivity(), 9);
                    frameLayout.addView(fwdRestrictedBottomHint, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 12, 0, 12, 0));
                    fwdRestrictedBottomHint.setAlpha(0.0f);
                    fwdRestrictedBottomHint.setVisibility(View.INVISIBLE);
                }

                fwdRestrictedBottomHint.setText(str);
                fwdRestrictedBottomHint.showForView(forwardButton, true);
            }
            return;
        }
        int hasPoll = 0;
        boolean hasInvoice = false;
        for (int a = 0; a < 2; a++) {
            for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                MessageObject messageObject = selectedMessagesIds[a].valueAt(b);
                if (messageObject.isPoll()) {
                    hasPoll = messageObject.isPublicPoll() ? 2 : 1;
                    if (hasPoll == 2) {
                        break;
                    }
                } else if (messageObject.isInvoice()) {
                    hasInvoice = true;
                }
            }
            if (hasPoll == 2) {
                break;
            }
        }
        if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
            selectionReactionsOverlay.setHiddenByScroll(true);
        }
        Bundle args = new Bundle();
        args.putBoolean("onlySelect", true);
        args.putInt("dialogsType", DialogsActivity.DIALOGS_TYPE_FORWARD);
        args.putInt("messagesCount", canForwardMessagesCount);
        args.putInt("hasPoll", hasPoll);
        args.putBoolean("hasInvoice", hasInvoice);
        args.putBoolean("canSelectTopics", true);
        DialogsActivity fragment = new DialogsActivity(args);
        fragment.setDelegate(ChatActivity.this);
        presentFragment(fragment);
    }

    private void openCopy() {
        SpannableStringBuilder str = new SpannableStringBuilder();
        long previousUid = 0;
        for (int a = 1; a >= 0; a--) {
            ArrayList<Integer> ids = new ArrayList<>();
            for (int b = 0; b < selectedMessagesCanCopyIds[a].size(); b++) {
                ids.add(selectedMessagesCanCopyIds[a].keyAt(b));
            }
            if (currentEncryptedChat == null) {
                Collections.sort(ids);
            } else {
                Collections.sort(ids, Collections.reverseOrder());
            }
            for (int b = 0; b < ids.size(); b++) {
                Integer messageId = ids.get(b);
                MessageObject messageObject = selectedMessagesCanCopyIds[a].get(messageId);
                if (str.length() != 0) {
                    str.append("\n\n");
                }
                str.append(getMessageContent(messageObject, previousUid, false));
                previousUid = messageObject.getFromChatId();
            }
        }
        if (str.length() != 0) {
            AndroidUtilities.addToClipboard(str);
            createUndoView();
            undoView.showWithAction(0, UndoView.ACTION_TEXT_COPIED, null);
        }
        clearSelectionMode();
    }

    private void openShare() {
        SpannableStringBuilder str = new SpannableStringBuilder();
        long previousUid = 0;
        for (int a = 1; a >= 0; a--) {
            ArrayList<Integer> ids = new ArrayList<>();
            for (int b = 0; b < selectedMessagesCanCopyIds[a].size(); b++) {
                ids.add(selectedMessagesCanCopyIds[a].keyAt(b));
            }
            if (currentEncryptedChat == null) {
                Collections.sort(ids);
            } else {
                Collections.sort(ids, Collections.reverseOrder());
            }
            for (int b = 0; b < ids.size(); b++) {
                Integer messageId = ids.get(b);
                MessageObject messageObject = selectedMessagesCanCopyIds[a].get(messageId);
                if (str.length() != 0) {
                    str.append("\n\n");
                }
                str.append(getMessageContent(messageObject, previousUid, false));
                previousUid = messageObject.getFromChatId();
            }
        }
        if (str.length() != 0) {
            try {
                Intent intent = new Intent(Intent.ACTION_SEND);
                intent.setType("text/plain");
                String text = str.toString();
                intent.putExtra(Intent.EXTRA_TEXT, text);
                getParentActivity().startActivityForResult(Intent.createChooser(intent, text), 500);
            } catch (Exception e) {
                FileLog.e(e);
            }finally {
                clearSelectionMode();
            }
        }
    }

    private void showBottomOverlayProgress(boolean show, boolean animated) {
        if (show && bottomOverlayProgress.getTag() != null || !show && bottomOverlayProgress.getTag() == null) {
            return;
        }
        if (bottomOverlayAnimation != null) {
            bottomOverlayAnimation.cancel();
            bottomOverlayAnimation = null;
        }
        bottomOverlayProgress.setTag(show ? 1 : null);
        if (animated) {
            bottomOverlayAnimation = new AnimatorSet();
            if (show) {
                bottomOverlayProgress.setVisibility(View.VISIBLE);
                bottomOverlayAnimation.playTogether(
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_X, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_Y, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.ALPHA, 0.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_X, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_Y, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.ALPHA, 1.0f));
                bottomOverlayAnimation.setStartDelay(200);
            } else {
                bottomOverlayChatText.setVisibility(View.VISIBLE);
                bottomOverlayAnimation.playTogether(
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_X, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_Y, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.ALPHA, 0.0f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_X, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_Y, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.ALPHA, 1.0f));
            }
            bottomOverlayAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (bottomOverlayAnimation != null && bottomOverlayAnimation.equals(animation)) {
                        if (!show) {
                            bottomOverlayProgress.setVisibility(View.INVISIBLE);
                        } else {
                            bottomOverlayChatText.setVisibility(View.INVISIBLE);
                        }
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (bottomOverlayAnimation != null && bottomOverlayAnimation.equals(animation)) {
                        bottomOverlayAnimation = null;
                    }
                }
            });
            bottomOverlayAnimation.setDuration(150);
            bottomOverlayAnimation.start();
        } else {
            bottomOverlayProgress.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
            bottomOverlayProgress.setScaleX(show ? 1.0f : 0.1f);
            bottomOverlayProgress.setScaleY(show ? 1.0f : 0.1f);
            bottomOverlayProgress.setAlpha(show ? 1.0f : 1.0f);
            bottomOverlayChatText.setVisibility(show ? View.INVISIBLE : View.VISIBLE);
            bottomOverlayChatText.setScaleX(show ? 0.1f : 1.0f);
            bottomOverlayChatText.setScaleY(show ? 0.1f : 1.0f);
            bottomOverlayChatText.setAlpha(show ? 0.0f : 1.0f);
        }
    }

    private void sendBotInlineResult(TLRPC.BotInlineResult result, boolean notify, int scheduleDate) {
        if (mentionContainer == null) {
            return;
        }
        long uid = mentionContainer.getAdapter().getContextBotId();
        HashMap<String, String> params = new HashMap<>();
        params.put("id", result.id);
        params.put("query_id", "" + result.query_id);
        params.put("bot", "" + uid);
        params.put("bot_name", mentionContainer.getAdapter().getContextBotName());
        SendMessagesHelper.prepareSendingBotContextResult(this, getAccountInstance(), result, params, dialog_id, replyingMessageObject, getThreadMessage(), notify, scheduleDate);
        chatActivityEnterView.setFieldText("");
        hideFieldPanel(false);
        getMediaDataController().increaseInlineRaiting(uid);
    }

    private void checkBotCommands() {
        URLSpanBotCommand.enabled = false;
        if (currentUser != null && currentUser.bot) {
            URLSpanBotCommand.enabled = !UserObject.isReplyUser(currentUser);
        } else if (chatInfo instanceof TLRPC.TL_chatFull) {
            for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                TLRPC.User user = getMessagesController().getUser(participant.user_id);
                if (user != null && user.bot) {
                    URLSpanBotCommand.enabled = true;
                    break;
                }
            }
        } else if (chatInfo instanceof TLRPC.TL_channelFull) {
            URLSpanBotCommand.enabled = !chatInfo.bot_info.isEmpty() && currentChat != null && currentChat.megagroup;
        }
    }

    private MessageObject.GroupedMessages getValidGroupedMessage(MessageObject message) {
        MessageObject.GroupedMessages groupedMessages = null;
        if (message.getGroupId() != 0) {
            groupedMessages = groupedMessagesMap.get(message.getGroupId());
            if (groupedMessages != null && (groupedMessages.messages.size() <= 1 || groupedMessages.positions.get(message) == null)) {
                groupedMessages = null;
            }
        }
        return groupedMessages;
    }

    public void jumpToDate(int date) {
        if (messages.isEmpty()) {
            return;
        }
        MessageObject firstMessage = messages.get(0);
        MessageObject lastMessage = messages.get(messages.size() - 1);
        if (firstMessage.messageOwner.date >= date && lastMessage.messageOwner.date <= date || lastMessage.messageOwner.date >= date && endReached[0]) {
            for (int a = messages.size() - 1; a >= 0; a--) {
                MessageObject message = messages.get(a);
                if (message.messageOwner.date >= date && message.getId() != 0) {
                    scrollToMessageId(message.getId(), 0, false, message.getDialogId() == mergeDialogId ? 1 : 0, true, 0);
                    break;
                }
            }
        } else if (!DialogObject.isEncryptedDialog(dialog_id)) {
            int scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UNSET;
            int end = chatLayoutManager.findLastVisibleItemPosition();
            for (int i = chatLayoutManager.findFirstVisibleItemPosition(); i <= end; i++) {
                if (i >= chatAdapter.messagesStartRow && i < chatAdapter.messagesEndRow) {
                    TLRPC.Message message = messages.get(i - chatAdapter.messagesStartRow).messageOwner;
                    if (message != null) {
                        boolean scrollDown = message.date < date;
                        if (isSecretChat()) {
                            scrollDown = !scrollDown;
                        }
                        scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                        break;
                    }
                }
            }
            chatScrollHelper.setScrollDirection(scrollDirection);

            if (progressDialog != null) {
                progressDialog.dismiss();
            }
            updatePinnedListButton(false);
            progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
            progressDialog.setOnCancelListener(postponedScrollCancelListener);
            progressDialog.showDelayed(1000);

            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            waitingForLoad.add(lastLoadIndex);
            postponedScrollMessageId = 0;
            postponedScrollIsCanceled = false;
            getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, date, true, 0, classGuid, 4, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            floatingDateView.setAlpha(0.0f);
            floatingDateView.setTag(null);
        }
    }

    public void processInlineBotWebView(TLRPC.TL_inlineBotWebView object) {
        BotWebViewSheet webViewSheet = new BotWebViewSheet(getContext(), getResourceProvider());
        webViewSheet.setParentActivity(getParentActivity());
        webViewSheet.requestWebView(currentAccount, currentUser != null ? currentUser.id : currentChat.id, mentionContainer.getAdapter().getFoundContextBot().id, object.text, object.url, BotWebViewSheet.TYPE_SIMPLE_WEB_VIEW_BUTTON, 0, false, BotWebViewSheet.FLAG_FROM_INLINE_SWITCH);
        webViewSheet.show();
    }

    public void processInlineBotContextPM(TLRPC.TL_inlineBotSwitchPM object) {
        if (object == null || mentionContainer == null) {
            return;
        }
        TLRPC.User user = mentionContainer.getAdapter().getContextBotUser();
        if (user == null) {
            return;
        }
        chatActivityEnterView.setFieldText("");
        if (dialog_id == user.id) {
            inlineReturn = dialog_id;
            getMessagesController().sendBotStart(currentUser, object.start_param);
        } else {
            Bundle args = new Bundle();
            args.putLong("user_id", user.id);
            args.putString("inline_query", object.start_param);
            args.putLong("inline_return", dialog_id);
            if (!getMessagesController().checkCanOpenChat(args, ChatActivity.this)) {
                return;
            }
            presentFragment(new ChatActivity(args));
        }
    }

    // 附件弹窗
    private void createChatAttachView() {
        if (getParentActivity() == null || getContext() == null) {
            return;
        }
        if (chatAttachAlert == null) {
            chatAttachAlert = new ChatAttachAlert(getParentActivity(), this, false, false, themeDelegate) {
                @Override
                public void dismissInternal() {
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
                    }
                    super.dismissInternal();
                    onEditTextDialogClose(false, true);
                }

                @Override
                public void onDismissAnimationStart() {
                    if (chatAttachAlert != null) {
                        chatAttachAlert.setFocusable(false);
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().requestFocus();
                    }
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
                    }
                    onEditTextDialogClose(false, false);
                }
            };
            // 附件弹窗回调
            chatAttachAlert.setDelegate(new ChatAttachAlert.ChatAttachViewDelegate() {
                @Override
                public void didPressedButton(int button, boolean arg, boolean notify, int scheduleDate, boolean forceDocument) {

                    // 附件发送消息
                    if (getParentActivity() == null || chatAttachAlert == null) {
                        return;
                    }
                    editingMessageObject = chatAttachAlert.getEditingMessageObject();
                    if (button == 8 || button == 7 || button == 4 && !chatAttachAlert.getPhotoLayout().getSelectedPhotos().isEmpty()) {
                        if (button != 8) {
                            chatAttachAlert.dismiss(true);
                        }
                        HashMap<Object, Object> selectedPhotos = chatAttachAlert.getPhotoLayout().getSelectedPhotos();
                        ArrayList<Object> selectedPhotosOrder = chatAttachAlert.getPhotoLayout().getSelectedPhotosOrder();
                        if (!selectedPhotos.isEmpty()) {
                            for (int i = 0; i < Math.ceil(selectedPhotos.size() / 10f); ++i) {
                                int count = Math.min(10, selectedPhotos.size() - (i * 10));
                                ArrayList<SendMessagesHelper.SendingMediaInfo> photos = new ArrayList<>();
                                for (int a = 0; a < count; a++) {
                                    if (i * 10 + a >= selectedPhotosOrder.size()) {
                                        continue;
                                    }// 这里出现问题，因为从selectedPhotos获取，导致拍照的图片其他信息没有更新到selectedPhotos中
                                    MediaController.PhotoEntry photoEntry = (MediaController.PhotoEntry) selectedPhotos.get(selectedPhotosOrder.get(i * 10 + a));

                                    SendMessagesHelper.SendingMediaInfo info = new SendMessagesHelper.SendingMediaInfo();
                                    if (!photoEntry.isVideo && photoEntry.imagePath != null) {
                                        info.path = photoEntry.imagePath;
                                    } else if (photoEntry.path != null) {
                                        info.path = photoEntry.path;
                                    }
                                    info.thumbPath = photoEntry.thumbPath;
                                    info.isVideo = photoEntry.isVideo;
                                    info.caption = photoEntry.caption != null ? photoEntry.caption.toString() : null;
                                    info.entities = photoEntry.entities;
                                    info.masks = photoEntry.stickers;
                                    info.ttl = photoEntry.ttl;
                                    info.videoEditedInfo = photoEntry.editedInfo;
                                    info.canDeleteAfter = photoEntry.canDeleteAfter;
                                    info.updateStickersOrder = SendMessagesHelper.checkUpdateStickersOrder(photoEntry.caption);
                                    info.hasMediaSpoilers = photoEntry.hasSpoiler;
                                    photos.add(info);
                                    photoEntry.reset();
                                }
                                boolean updateStickersOrder = false;
                                if (i == 0) {
                                    fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
                                    updateStickersOrder = photos.get(0).updateStickersOrder;
                                }
                                getAccountInstance().getSendMessagesHelper().prepareSendingMedia(getAccountInstance(), messages, photos, dialog_id, replyingMessageObject, getThreadMessage(), null, button == 4 || forceDocument, arg, editingMessageObject, notify, scheduleDate, updateStickersOrder);
                            }
                            afterMessageSend();
                            chatActivityEnterView.setFieldText("");
                        }
                        if (scheduleDate != 0) {
                            if (scheduledMessagesCount == -1) {
                                scheduledMessagesCount = 0;
                            }
                            scheduledMessagesCount += selectedPhotos.size();
                            updateScheduledInterface(true);
                        }
                        return;
                    } else if (chatAttachAlert != null) {
                        chatAttachAlert.dismissWithButtonClick(button);
                    }
                    processSelectedAttach(button);
                }

                @Override
                public View getRevealView() {
                    return chatActivityEnterView.getAttachButton();
                }

                @Override
                public void didSelectBot(TLRPC.User user) {
                    String username = UserObject.getPublicUsername(user);
                    if (chatActivityEnterView == null || user == null || TextUtils.isEmpty(username)) {
                        return;
                    }
                    chatActivityEnterView.setFieldText("@" + username + " ");
                    chatActivityEnterView.openKeyboard();
                }

                @Override
                public void onCameraOpened() {
                    chatActivityEnterView.closeKeyboard();
                }

                @Override
                public boolean needEnterComment() {
                    return needEnterText();
                }

                @Override
                public void doOnIdle(Runnable runnable) {
                    ChatActivity.this.doOnIdle(runnable);
                }
            });
        }
    }

    public boolean needEnterText() {
        boolean keyboardVisible = chatActivityEnterView.isKeyboardVisible();
        if (keyboardVisible) {
            chatActivityEnterView.showEmojiView();
            openKeyboardOnAttachMenuClose = true;
        }
        AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
        fragmentView.requestLayout();
        return keyboardVisible;
    }

    public void onEditTextDialogClose(boolean resetAdjust, boolean reset) {
        if (openKeyboardOnAttachMenuClose) {
            AndroidUtilities.runOnUIThread(() -> chatActivityEnterView.openKeyboard(), 50);
            if (reset) {
                openKeyboardOnAttachMenuClose = false;
            }
        }
        if (resetAdjust) {
            AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
        }
    }

    public void doOnIdle(Runnable runnable) {
        NotificationCenter.getInstance(currentAccount).doOnIdle(runnable);
    }

    public void performHistoryClear(boolean revoke, boolean canDeleteHistory) {
        clearingHistory = true;
        createUndoView();
        if (undoView == null) {
            return;
        }
        undoView.showWithAction(dialog_id, UndoView.ACTION_CLEAR, () -> {
            if (!pinnedMessageIds.isEmpty()) {
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                pinnedMessageIds.clear();
                pinnedMessageObjects.clear();
                currentPinnedMessageId = 0;
                loadedPinnedMessagesCount = 0;
                totalPinnedMessagesCount = 0;
                updatePinnedMessageView(true);
            }
            getMessagesController().deleteDialog(dialog_id, 1, revoke);
            clearingHistory = false;
            clearHistory(false, null);
            chatAdapter.notifyDataSetChanged();
        }, () -> {
            clearingHistory = false;
            chatAdapter.notifyDataSetChanged();
        });
        chatAdapter.notifyDataSetChanged();
    }

    public long getDialogId() {
        return dialog_id;
    }
    public int getDialogFolderId() {
        return dialogFolderId;
    }
    public int getDialogFilterId() {
        return dialogFilterId;
    }

    public boolean openedWithLivestream() {
        return livestream;
    }

    @Nullable
    public UndoView getUndoView() {
        createUndoView();
        return undoView;
    }

    public long getMergeDialogId() {
        return mergeDialogId;
    }

    public boolean hasReportSpam() {
        return topChatPanelView != null && topChatPanelView.getTag() == null && reportSpamButton.getVisibility() != View.GONE;
    }

    public boolean isReport() {
        return reportType >= 0;
    }

    public void setChatInvite(TLRPC.ChatInvite invite) {
        chatInvite = invite;
    }

    public void setBotUser(String value) {
        if (inlineReturn != 0) {
            getMessagesController().sendBotStart(currentUser, value);
        } else {
            botUser = value;
            updateBottomOverlay();
        }
    }

    private void afterMessageSend() {
        hideFieldPanel(false);
        if (chatMode == 0) {
            getMediaDataController().cleanDraft(dialog_id, threadMessageId, true);
        }
    }

    private void toggleMesagesSearchListView() {
        if (messagesSearchListView != null) {
            showMessagesSearchListView(messagesSearchListView.getTag() == null);
        }
    }

    private void showMessagesSearchListView(boolean show) {
        if (messagesSearchListView == null || show && messagesSearchListView.getTag() != null || !show && messagesSearchListView.getTag() == null) {
            return;
        }
        if (messagesSearchListViewAnimation != null) {
            messagesSearchListViewAnimation.cancel();
            messagesSearchListViewAnimation = null;
        }
        if (show) {
            messagesSearchListView.setVisibility(View.VISIBLE);
        }
        messagesSearchListView.setTag(show ? 1 : null);
        messagesSearchListViewAnimation = new AnimatorSet();
        messagesSearchListViewAnimation.playTogether(ObjectAnimator.ofFloat(messagesSearchListView, View.ALPHA, show ? 1.0f : 0.0f));
        messagesSearchListViewAnimation.setInterpolator(CubicBezierInterpolator.EASE_IN);
        messagesSearchListViewAnimation.setDuration(180);
        messagesSearchListViewAnimation.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (animation.equals(messagesSearchListViewAnimation)) {
                    messagesSearchListViewAnimation = null;
                    if (!show) {
                        messagesSearchListView.setVisibility(View.GONE);
                    }
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                if (animation.equals(messagesSearchListViewAnimation)) {
                    messagesSearchListViewAnimation = null;
                }
            }
        });
        messagesSearchListViewAnimation.start();

    }

    public boolean playFirstUnreadVoiceMessage() {
        if (chatActivityEnterView != null && chatActivityEnterView.isRecordingAudioVideo()) {
            return true;
        }
        for (int a = messages.size() - 1; a >= 0; a--) {
            MessageObject messageObject = messages.get(a);
            if ((messageObject.isVoice() || messageObject.isRoundVideo()) && messageObject.isContentUnread() && !messageObject.isOut()) {
                MediaController.getInstance().setVoiceMessagesPlaylist(MediaController.getInstance().playMessage(messageObject) ? createVoiceMessagesPlaylist(messageObject, true) : null, true);
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 23 && getParentActivity() != null) {
            if (getParentActivity().checkSelfPermission(Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
                getParentActivity().requestPermissions(new String[]{Manifest.permission.RECORD_AUDIO}, 3);
                return true;
            }
        }
        return false;
    }

    private void openScheduledMessages() {
        if (parentLayout == null || parentLayout.getLastFragment() != this) {
            return;
        }
        Bundle bundle = new Bundle();
        if (currentEncryptedChat != null) {
            bundle.putInt("enc_id", currentEncryptedChat.id);
        } else if (currentChat != null) {
            bundle.putLong("chat_id", currentChat.id);
        } else {
            bundle.putLong("user_id", currentUser.id);
        }
        bundle.putInt("chatMode", MODE_SCHEDULED);
        ChatActivity fragment = new ChatActivity(bundle);
        fragment.chatActivityDelegate = new ChatActivityDelegate() {
            @Override
            public void openReplyMessage(int mid) {
                scrollToMessageId(mid, 0, true, 0, true, 0);
            }

            @Override
            public void openSearch(String text) {
                openSearchWithText(text);
            }
        };
        presentFragment(fragment, false);
    }

    public void shareMyContact(int type, MessageObject messageObject) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
        builder.setTitle(LocaleController.getString("ShareYouPhoneNumberTitle", R.string.ShareYouPhoneNumberTitle));
        if (currentUser != null) {
            if (currentUser.bot) {
                builder.setMessage(LocaleController.getString("AreYouSureShareMyContactInfoBot", R.string.AreYouSureShareMyContactInfoBot));
            } else {
                builder.setMessage(AndroidUtilities.replaceTags(LocaleController.formatString("AreYouSureShareMyContactInfoUser", R.string.AreYouSureShareMyContactInfoUser, PhoneFormat.getInstance().format("+" + getUserConfig().getCurrentUser().phone), ContactsController.formatName(currentUser.first_name, currentUser.last_name))));
            }
        } else {
            builder.setMessage(LocaleController.getString("AreYouSureShareMyContactInfo", R.string.AreYouSureShareMyContactInfo));
        }
        builder.setPositiveButton(LocaleController.getString("ShareContact", R.string.ShareContact), (dialogInterface, i) -> {
            if (type == 1) {
                TLRPC.TL_contacts_acceptContact req = new TLRPC.TL_contacts_acceptContact();
                req.id = getMessagesController().getInputUser(currentUser);
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error != null) {
                        return;
                    }
                    getMessagesController().processUpdates((TLRPC.Updates) response, false);
                });
            } else {
                SendMessagesHelper.getInstance(currentAccount).sendMessage(getUserConfig().getCurrentUser(), dialog_id, messageObject, getThreadMessage(), null, null, true, 0);
                if (chatMode == 0) {
                    moveScrollToLastMessage(false);
                }
                hideFieldPanel(false);
            }
        });
        builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), null);
        showDialog(builder.create());
    }

    private void showVoiceHint(boolean hide, boolean video) {
        if (BuildVars.IS_CHAT_AIR || getParentActivity() == null || fragmentView == null || hide && voiceHintTextView == null || chatMode != 0 || chatActivityEnterView == null  || chatActivityEnterView.getAudioVideoButtonContainer() == null || chatActivityEnterView.getAudioVideoButtonContainer().getVisibility() != View.VISIBLE || isInPreviewMode()) {
            return;
        }
        if (voiceHintTextView == null) {
            SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
            int index = frameLayout.indexOfChild(chatActivityEnterView);
            if (index == -1) {
                return;
            }
            voiceHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
            frameLayout.addView(voiceHintTextView, index + 1,  LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }
        if (hide) {
            voiceHintTextView.hide();
            return;
        }

        if (chatActivityEnterView.hasRecordVideo()) {
            voiceHintTextView.setText(video ? LocaleController.getString("HoldToVideo", R.string.HoldToVideo) : LocaleController.getString("HoldToAudio", R.string.HoldToAudio));
        } else {
            voiceHintTextView.setText(LocaleController.getString("HoldToAudioOnly", R.string.HoldToAudioOnly));
        }

        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), true);
    }

    public boolean checkSlowMode(View view) {
        CharSequence time = chatActivityEnterView.getSlowModeTimer();
        if (time != null) {
            showSlowModeHint(view, true, time);
            return true;
        }
        return false;
    }

    public boolean checkSlowModeAlert() {
        CharSequence time = chatActivityEnterView.getSlowModeTimer();
        if (time != null) {
            new AlertDialog.Builder(getContext())
                .setTitle(LocaleController.getString("Slowmode", R.string.Slowmode))
                .setMessage(AndroidUtilities.replaceTags(LocaleController.formatString("SlowModeHint", R.string.SlowModeHint, time)))
                .setPositiveButton(LocaleController.getString("OK", R.string.OK), null)
                .show();
            return false;
        }
        return true;
    }

    private void hideHints(boolean scroll) {
        if (!scroll) {
            if (slowModeHint != null) {
                slowModeHint.hide();
            }
            if (searchAsListHint != null) {
                searchAsListHint.hide();
            }
            if (scheduledOrNoSoundHint != null) {
                scheduledOrNoSoundHint.hide();
            }
        }
        if (fwdRestrictedBottomHint != null) {
            fwdRestrictedBottomHint.hide();
        }
        if (fwdRestrictedTopHint != null) {
            fwdRestrictedTopHint.hide();
        }
        if (noSoundHintView != null) {
            noSoundHintView.hide();
        }
        if (forwardHintView != null) {
            forwardHintView.hide();
        }
        if (pollHintView != null) {
            pollHintView.hide();
        }
        if (timerHintView != null) {
            timerHintView.hide();
        }
        if (checksHintView != null) {
            checksHintView.hide();
        }
    }

    private void showSlowModeHint(View view, boolean show, CharSequence time) {
        if (getParentActivity() == null || fragmentView == null || !show && (slowModeHint == null || slowModeHint.getVisibility() != View.VISIBLE)) {
            return;
        }
        slowModeHint.setText(AndroidUtilities.replaceTags(LocaleController.formatString("SlowModeHint", R.string.SlowModeHint, time)));
        if (show) {
            slowModeHint.showForView(view, true);
        }
    }

    public void showTimerHint() {
        if (getParentActivity() == null || fragmentView == null || chatInfo == null) {
            return;
        }
        if (timerHintView == null) {
            timerHintView = new HintView(getParentActivity(), 7, true, themeDelegate);
            timerHintView.setAlpha(0.0f);
            timerHintView.setVisibility(View.INVISIBLE);
            timerHintView.setShowingDuration(4000);
            contentView.addView(timerHintView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
        }
        String time;
        if (chatInfo.ttl_period > 24 * 60 * 60) {
            time = LocaleController.formatPluralString("Days", chatInfo.ttl_period / (24 * 60 * 60));
        } else if (chatInfo.ttl_period >= 60 * 60) {
            time = LocaleController.formatPluralString("Hours", chatInfo.ttl_period / (60 * 60));
        } else if (chatInfo.ttl_period >= 60) {
            time = LocaleController.formatPluralString("Minutes", chatInfo.ttl_period / 60);
        } else {
            time = LocaleController.formatPluralString("Seconds", chatInfo.ttl_period);
        }
        timerHintView.setText(LocaleController.formatString("AutoDeleteSetInfo", R.string.AutoDeleteSetInfo, time));
        timerHintView.showForView(avatarContainer.getTimeItem(), true);
    }

    private void showSearchAsListHint() {
        if (BuildVars.IS_CHAT_AIR || getParentActivity() == null || fragmentView == null || searchCountText == null) {
            return;
        }
        if (searchAsListHint == null) {
            searchAsListHint = new HintView(getParentActivity(), HintView.TYPE_SEARCH_AS_LIST, themeDelegate);
            searchAsListHint.setAlpha(0.0f);
            searchAsListHint.setVisibility(View.INVISIBLE);
            searchAsListHint.setText(LocaleController.getString("TapToViewAsList", R.string.TapToViewAsList));
            contentView.addView(searchAsListHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
        }
        searchAsListHint.showForView(searchCountText, true);
    }

    private void showScheduledOrNoSoundHint() {
        boolean disableNoSound = (UserObject.isUserSelf(currentUser) || (chatInfo != null && chatInfo.slowmode_next_send_date > 0) && chatMode == 0);
        if (BuildVars.IS_CHAT_AIR || SharedConfig.scheduledOrNoSoundHintShows >= 3 || System.currentTimeMillis() % 4 != 0 || disableNoSound) {
            return;
        }
        AndroidUtilities.cancelRunOnUIThread(showScheduledOrNoSoundRunnable);
        AndroidUtilities.runOnUIThread(showScheduledOrNoSoundRunnable, 200);
    }

    private void showMediaBannedHint() {
        if (getParentActivity() == null || currentChat == null && userInfo == null || fragmentView == null || mediaBanTooltip != null && mediaBanTooltip.getVisibility() == View.VISIBLE) {
            return;
        }
        SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
        int index = frameLayout.indexOfChild(chatActivityEnterView);
        if (index == -1) {
            return;
        }

        try {
            fragmentView.performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
        } catch (Exception e) {
            FileLog.e(e);
        }

        if (mediaBanTooltip == null) {
            mediaBanTooltip = new HintView(getParentActivity(), 9, themeDelegate);
            mediaBanTooltip.setVisibility(View.GONE);
            frameLayout.addView(mediaBanTooltip, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }

        if (userInfo != null && userInfo.voice_messages_forbidden) {
            mediaBanTooltip.setText(AndroidUtilities.replaceTags(LocaleController.formatString(chatActivityEnterView.isInVideoMode() ? R.string.VideoMessagesRestrictedByPrivacy : R.string.VoiceMessagesRestrictedByPrivacy, currentUser.first_name)));
        } else if (!ChatObject.canSendVoice(currentChat) && !ChatObject.canSendRoundVideo(currentChat)) {
            if (chatActivityEnterView.isInVideoMode()) {
                mediaBanTooltip.setText(ChatObject.getRestrictedErrorText(currentChat, ChatObject.ACTION_SEND_ROUND));
            } else {
                mediaBanTooltip.setText(ChatObject.getRestrictedErrorText(currentChat, ChatObject.ACTION_SEND_VOICE));
            }
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_VOICE)) {
            mediaBanTooltip.setText(LocaleController.getString("GlobalAttachVoiceRestricted", R.string.GlobalAttachVoiceRestricted));
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_ROUND)) {
            mediaBanTooltip.setText(LocaleController.getString("GlobalAttachRoundRestricted", R.string.GlobalAttachRoundRestricted));
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_MEDIA)) {
            mediaBanTooltip.setText(LocaleController.getString("GlobalAttachMediaRestricted", R.string.GlobalAttachMediaRestricted));
        } else {
            if (currentChat.banned_rights == null) {
                return;
            }
            if (AndroidUtilities.isBannedForever(currentChat.banned_rights)) {
                mediaBanTooltip.setText(LocaleController.getString("AttachMediaRestrictedForever", R.string.AttachMediaRestrictedForever));
            } else {
                mediaBanTooltip.setText(LocaleController.formatString("AttachMediaRestricted", R.string.AttachMediaRestricted, LocaleController.formatDateForBan(currentChat.banned_rights.until_date)));
            }
        }

        View sendBtn = chatActivityEnterView.getSendButton();
        View audioVideoBtn = chatActivityEnterView.getAudioVideoButtonContainer();
        View viewForTooltip = sendBtn;
        if (sendBtn.getAlpha() < audioVideoBtn.getAlpha()) {
            viewForTooltip = audioVideoBtn;
        }
        mediaBanTooltip.showForView(viewForTooltip, true);
    }

    private void showNoSoundHint() {
        if (scrollingChatListView || SharedConfig.noSoundHintShowed || chatListView == null || getParentActivity() == null || fragmentView == null || noSoundHintView != null && noSoundHintView.getTag() != null) {
            return;
        }

        if (noSoundHintView == null) {
            SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
            int index = frameLayout.indexOfChild(chatActivityEnterView);
            if (index == -1) {
                return;
            }
            noSoundHintView = new HintView(getParentActivity(), 0, themeDelegate);
            noSoundHintView.setShowingDuration(10000);
            frameLayout.addView(noSoundHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
            noSoundHintView.setAlpha(0.0f);
            noSoundHintView.setVisibility(View.INVISIBLE);
        }

        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View child = chatListView.getChildAt(a);
            if (!(child instanceof ChatMessageCell)) {
                continue;
            }
            ChatMessageCell messageCell = (ChatMessageCell) child;
            MessageObject messageObject = messageCell.getMessageObject();
            if (messageObject == null || !messageObject.isVideo()) {
                continue;
            }
            ImageReceiver imageReceiver = messageCell.getPhotoImage();
            AnimatedFileDrawable animation = imageReceiver.getAnimation();
            if (animation == null || animation.getCurrentProgressMs() < 3000) {
                continue;
            }
            if (noSoundHintView.showForMessageCell(messageCell, true)) {
                SharedConfig.setNoSoundHintShowed(true);
                break;
            }
        }
    }

    private void checkChecksHint() {
        if (getMessagesController().pendingSuggestions.contains("NEWCOMER_TICKS")) {
            AndroidUtilities.runOnUIThread(this::showChecksHint, 1000);
        }
    }

    private void showChecksHint() {
        if (scrollingChatListView || chatListView == null || getParentActivity() == null || fragmentView == null || checksHintView != null && checksHintView.getTag() != null) {
            return;
        }

        if (checksHintView == null) {
            SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
            int index = frameLayout.indexOfChild(chatActivityEnterView);
            if (index == -1) {
                return;
            }
            checksHintView = new ChecksHintView(getParentActivity(), themeDelegate);
            frameLayout.addView(checksHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
            checksHintView.setAlpha(0.0f);
            checksHintView.setVisibility(View.INVISIBLE);
        }

        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View child = chatListView.getChildAt(a);
            if (!(child instanceof ChatMessageCell)) {
                continue;
            }
            ChatMessageCell messageCell = (ChatMessageCell) child;
            MessageObject messageObject = messageCell.getMessageObject();
            if (messageObject == null || !messageObject.isOutOwner() || !messageObject.isSent()) {
                continue;
            }
            if (checksHintView.showForMessageCell(messageCell, true)) {
                getMessagesController().removeSuggestion(0, "NEWCOMER_TICKS");
                break;
            }
        }
    }

    private void showForwardHint(ChatMessageCell cell) {
        if (scrollingChatListView || chatListView == null || getParentActivity() == null || fragmentView == null) {
            return;
        }

        if (forwardHintView == null) {
            SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
            int index = frameLayout.indexOfChild(chatActivityEnterView);
            if (index == -1) {
                return;
            }
            forwardHintView = new HintView(getParentActivity(), 1, themeDelegate);
            frameLayout.addView(forwardHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
            forwardHintView.setAlpha(0.0f);
            forwardHintView.setVisibility(View.INVISIBLE);
        }
        forwardHintView.showForMessageCell(cell, true);
    }

    private void showTextSelectionHint(MessageObject messageObject) {
        if (getParentActivity() == null || getMessagesController().isChatNoForwards(messageObject.getChatId()) || (messageObject != null && messageObject.messageOwner != null && messageObject.messageOwner.noforwards)) {
            return;
        }
        CharSequence text;
        boolean canShowText = false;
        if (messageObject.textLayoutBlocks != null && !messageObject.textLayoutBlocks.isEmpty()) {
            text = messageObject.messageText;
            if (messageObject.textLayoutBlocks.size() > 1) {
                canShowText = true;
            }
        } else {
            text = messageObject.caption;
        }

        if (!canShowText && text != null) {
            canShowText = text.length() > 200;
        }
        if (!canShowText || SharedConfig.textSelectionHintShows > 2 || textSelectionHintWasShowed || lastTouchY > chatActivityEnterView.getTop() - AndroidUtilities.dp(60)) {
            return;
        }
        textSelectionHintWasShowed = true;
        SharedConfig.increaseTextSelectionHintShowed();
        if (textSelectionHint == null) {
            textSelectionHint = new TextSelectionHint(getParentActivity(), themeDelegate) {

                @Override
                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    updatePosition();
                }

                @Override
                protected void onDraw(Canvas canvas) {
                    super.onDraw(canvas);
                    updatePosition();
                }

                public void updatePosition() {
                    int start = -(getMeasuredHeight() + AndroidUtilities.dp(16));
                    int end = chatActivityEnterView.getTop() - contentView.getMeasuredHeight();
                    setTranslationY(end - (end + start) * (1f - getPrepareProgress()));
                }
            };
            contentView.addView(textSelectionHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 56, Gravity.BOTTOM | Gravity.LEFT, 8, 0, 8, 8));
        }
        textSelectionHint.show();
    }

    public boolean showEmojiHint() {
        if (chatActivityEnterView == null || chatActivityEnterView.getVisibility() != View.VISIBLE) {
            return false;
        }
        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
        int moreemojihint;
        if ((moreemojihint = preferences.getInt("moreemojihint", 0)) > 3 && UserConfig.getInstance(currentAccount).isPremium()) {
            return false;
        }
        if (UserConfig.getInstance(currentAccount).isPremium()) {
            preferences.edit().putInt("moreemojihint", moreemojihint + 1).commit();
        }

        if (getParentActivity() == null || fragmentView == null || emojiHintTextView != null) {
            return false;
        }
        if (!allowContextBotPanelSecond) {
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setOpenGifsTabFirst();
            }
            return false;
        }
        SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
        int index = frameLayout.indexOfChild(chatActivityEnterView);
        if (index == -1) {
            return false;
        }
        chatActivityEnterView.setOpenGifsTabFirst();
//        emojiButtonRed = new View(getParentActivity());
//        emojiButtonRed.setBackgroundResource(R.drawable.redcircle);
//        frameLayout.addView(emojiButtonRed, index + 1, LayoutHelper.createFrame(10, 10, Gravity.BOTTOM | Gravity.LEFT, 30, 0, 0, 27));

        emojiHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
        final String emojiPlaceholder = "<<EMOJI>>";
        String textString = LocaleController.formatString("TapHereEmoji", R.string.TapHereEmoji, emojiPlaceholder);
        SpannableStringBuilder text = new SpannableStringBuilder(textString);
        int i = textString.indexOf(emojiPlaceholder);
        if (i >= 0) {
            SpannableString emoji = new SpannableString("x");
            Drawable emojiDrawable = getContext().getResources().getDrawable(R.drawable.smiles_tab_smiles).mutate();
            emojiDrawable.setBounds(0, 0, AndroidUtilities.dp(20), AndroidUtilities.dp(20));
            emojiDrawable.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_gifSaveHintText), PorterDuff.Mode.MULTIPLY));
            emoji.setSpan(new ImageSpan(emojiDrawable, ImageSpan.ALIGN_BOTTOM), 0, emoji.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            text.replace(i, i + emojiPlaceholder.length(), emoji);
            emojiHintTextView.textView.setPadding(AndroidUtilities.dp(8), AndroidUtilities.dp(0), AndroidUtilities.dp(8), AndroidUtilities.dp(6));
        }
        emojiHintTextView.setText(text);
        frameLayout.addView(emojiHintTextView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM, 5, 0, 5, 3));

        AnimatorSet AnimatorSet = new AnimatorSet();
        AnimatorSet.playTogether(
                ObjectAnimator.ofFloat(emojiHintTextView, View.ALPHA, 0.0f, 1.0f)
        );
        AnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (emojiHintTextView == null) {
                        return;
                    }
                    AnimatorSet AnimatorSet = new AnimatorSet();
                    AnimatorSet.playTogether(
                            ObjectAnimator.ofFloat(emojiHintTextView, View.ALPHA, 0.0f)
                    );
                    AnimatorSet.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (emojiHintTextView != null) {
                                emojiHintTextView.setVisibility(View.GONE);
                                frameLayout.removeView(emojiHintTextView);
                                emojiHintTextView = null;
                            }
                        }
                    });
                    AnimatorSet.setDuration(300);
                    AnimatorSet.start();
                }, 2000);
            }
        });
        AnimatorSet.setDuration(300);
        AnimatorSet.start();

        View emojiButton = chatActivityEnterView.getEmojiButton();
        if (emojiButton != null) {
            emojiHintTextView.showForView(emojiButton, true);
        }
        return true;
    }

    private boolean showGifHint() {
        if (chatActivityEnterView == null || chatActivityEnterView.getVisibility() != View.VISIBLE) {
            return false;
        }
        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
        if (preferences.getBoolean("gifhint", false)) {
            return false;
        }
        preferences.edit().putBoolean("gifhint", true).commit();

        if (getParentActivity() == null || fragmentView == null || gifHintTextView != null) {
            return false;
        }
        if (!allowContextBotPanelSecond) {
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setOpenGifsTabFirst();
            }
            return false;
        }
        SizeNotifierFrameLayout frameLayout = (SizeNotifierFrameLayout) fragmentView;
        int index = frameLayout.indexOfChild(chatActivityEnterView);
        if (index == -1) {
            return false;
        }
        chatActivityEnterView.setOpenGifsTabFirst();
        emojiButtonRed = new View(getParentActivity());
        emojiButtonRed.setBackgroundResource(R.drawable.redcircle);
        frameLayout.addView(emojiButtonRed, index + 1, LayoutHelper.createFrame(10, 10, Gravity.BOTTOM | Gravity.LEFT, 30, 0, 0, 27));

        gifHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
        gifHintTextView.setText(LocaleController.getString("TapHereGifs", R.string.TapHereGifs));
        frameLayout.addView(gifHintTextView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM, 5, 0, 5, 3));

        AnimatorSet AnimatorSet = new AnimatorSet();
        AnimatorSet.playTogether(
                ObjectAnimator.ofFloat(gifHintTextView, View.ALPHA, 0.0f, 1.0f),
                ObjectAnimator.ofFloat(emojiButtonRed, View.ALPHA, 0.0f, 1.0f)
        );
        AnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (gifHintTextView == null) {
                        return;
                    }
                    AnimatorSet AnimatorSet = new AnimatorSet();
                    AnimatorSet.playTogether(
                            ObjectAnimator.ofFloat(gifHintTextView, View.ALPHA, 0.0f)
                    );
                    AnimatorSet.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (gifHintTextView != null) {
                                gifHintTextView.setVisibility(View.GONE);
                            }
                        }
                    });
                    AnimatorSet.setDuration(300);
                    AnimatorSet.start();
                }, 2000);
            }
        });
        AnimatorSet.setDuration(300);
        AnimatorSet.start();

        View emojiButton = chatActivityEnterView.getEmojiButton();
        if (emojiButton != null) {
            gifHintTextView.showForView(emojiButton, true);
        }
        return true;
    }

    // 打开附件
    private void openAttachMenu() {
        if (getParentActivity() == null || chatActivityEnterView != null && !TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
            return;
        }
        createChatAttachView();
        chatAttachAlert.getPhotoLayout().loadGalleryPhotos();
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            chatActivityEnterView.closeKeyboard();
        }
        if (currentChat != null && !ChatObject.hasAdminRights(currentChat) && currentChat.slowmode_enabled) {
            chatAttachAlert.setMaxSelectedPhotos(10, true);
        } else {

            if (BuildVars.IS_CHAT_AIR) {
                chatAttachAlert.setMaxSelectedPhotos(1, true);

            } else {
                chatAttachAlert.setMaxSelectedPhotos(-1, true);
            }
        }
        if (BuildVars.IS_CHAT_AIR) {

            chatAttachAlert.setPhotoPicker(true);
            chatAttachAlert.init();
            chatAttachAlert.setPhotoPicker();

            boolean isGeminiProVision = UserConfig.isGeminiProVision(currentAccount, dialog_id);
            if(isGeminiProVision) {
                String prompt = UserConfig.getUserAiPrompt(currentAccount, dialog_id);
                chatAttachAlert.getCommentTextView().setText(prompt);
            }

            AndroidUtilities.logEvent("openAttachMenu", "photoPicker");
        } else {
            chatAttachAlert.getCommentTextView().setText(chatActivityEnterView.getFieldText());
        }
        chatAttachAlert.parentThemeDelegate = themeDelegate;
        showDialog(chatAttachAlert);
    }

    ArrayList<MessageObject> preloadingMessages = new ArrayList<>();
    ArrayList<MessageObject> preloadingMessagesTmp = new ArrayList<>();
    SparseArray<MessageObject> attachedMessaesTmp = new SparseArray<>();

    private void checkAutoDownloadMessages(boolean scrollUp) {
        if (chatListView == null || !chatListViewAttached) {
            return;
        }
        preloadingMessagesTmp.clear();
        preloadingMessagesTmp.addAll(preloadingMessages);
        preloadingMessages.clear();
        attachedMessaesTmp.clear();
        int count = chatListView.getChildCount();
        int firstMessagePosition = -1;
        int lastMessagePosition = -1;
        for (int a = 0; a < count; a++) {
            View child = chatListView.getChildAt(a);
            if (!(child instanceof ChatMessageCell)) {
                continue;
            }
            RecyclerListView.ViewHolder holder = chatListView.findContainingViewHolder(child);
            if (holder != null) {
                int p = holder.getAdapterPosition();
                if (firstMessagePosition == -1) {
                    firstMessagePosition = p;
                }
                lastMessagePosition = p;
            }
            ChatMessageCell cell = (ChatMessageCell) child;
            MessageObject object = cell.getMessageObject();
            attachedMessaesTmp.put(object.getId(), object);
        }
        if (firstMessagePosition != -1) {
            int lastPosition;
            if (scrollUp) {
                firstMessagePosition = lastPosition = lastMessagePosition;
                firstMessagePosition = Math.min(firstMessagePosition + 10, chatAdapter.messagesEndRow);
                for (int a = lastPosition, N = messages.size(); a < firstMessagePosition; a++) {
                    int n = a - chatAdapter.messagesStartRow;
                    if (n < 0 || n >= N) {
                        continue;
                    }
                    preloadingMessagesTmp.remove(messages.get(n));
                    preloadingMessages.add(messages.get(n));
                    checkAutoDownloadMessage(messages.get(n));
                }
            } else {
                lastPosition = Math.max(firstMessagePosition - 20, chatAdapter.messagesStartRow);
                for (int a = firstMessagePosition - 1, N = messages.size(); a >= lastPosition; a--) {
                    int n = a - chatAdapter.messagesStartRow;
                    if (n < 0 || n >= N) {
                        continue;
                    }
                    preloadingMessagesTmp.remove(messages.get(n));
                    preloadingMessages.add(messages.get(n));
                    checkAutoDownloadMessage(messages.get(n));
                }
            }
        }
        for (int i = 0; i < preloadingMessagesTmp.size(); i++) {
            MessageObject object = preloadingMessagesTmp.get(i);
            if (attachedMessaesTmp.get(object.getId()) != null) {
                continue;
            }
            cancelPreload(object);
        }
        showNoSoundHint();
    }

    private void cancelPreload(MessageObject object) {
        TLRPC.Document document = object.getDocument();
        TLRPC.PhotoSize photo = document == null ? FileLoader.getClosestPhotoSizeWithSize(object.photoThumbs, AndroidUtilities.getPhotoSize()) : null;
        if (document == null && photo == null) {
            return;
        }
        if (object.putInDownloadsStore || DownloadController.getInstance(currentAccount).isDownloading(object.messageOwner.id)) {
            return;
        }
        if (document != null) {
            getFileLoader().cancelLoadFile(document);
        } else {
            ImageLocation.getForObject(photo, object.photoThumbsObject);
            getFileLoader().cancelLoadFile(ImageLocation.getForObject(photo, object.photoThumbsObject).location, null);
        }
    }

    private void checkAutoDownloadMessage(MessageObject object) {
        if (object.mediaExists) {
            return;
        }
        TLRPC.Message message = object.messageOwner;
        int canDownload = getDownloadController().canDownloadMedia(message);
        if (canDownload == 0) {
            return;
        }
        TLRPC.Document document = object.getDocument();
        TLRPC.PhotoSize photo = document == null ? FileLoader.getClosestPhotoSizeWithSize(object.photoThumbs, AndroidUtilities.getPhotoSize()) : null;
        if (document == null && photo == null) {
            return;
        }
        if (canDownload == 2 || canDownload == 1 && object.isVideo()) {
//            if (document != null && currentEncryptedChat == null && !object.shouldEncryptPhotoOrVideo() && object.canStreamVideo()) {
//                getFileLoader().loadFile(document, object, FileLoader.PRIORITY_LOW, 10);
//            }
        } else {
            if (document != null) {
                getFileLoader().loadFile(document, object, FileLoader.PRIORITY_LOW, MessageObject.isVideoDocument(document) && object.shouldEncryptPhotoOrVideo() ? 2 : 0);
            } else {
                getFileLoader().loadFile(ImageLocation.getForObject(photo, object.photoThumbsObject), object, null, FileLoader.PRIORITY_LOW, object.shouldEncryptPhotoOrVideo() ? 2 : 0);
            }
        }
    }

    public void clearMessagesPreloading() {
        for (int i = 0; i < preloadingMessages.size(); i++) {
            MessageObject object = preloadingMessages.get(i);
            cancelPreload(object);
        }
        preloadingMessages.clear();
    }

    //显示浮窗日期
    private void showFloatingDateView(boolean scroll) {
        if (floatingDateView == null) {
            return;
        }
        if (floatingDateView.getTag() == null) {
            if (floatingDateAnimation != null) {
                floatingDateAnimation.cancel();
            }
            floatingDateView.setTag(1);
            floatingDateAnimation = new AnimatorSet();
            floatingDateAnimation.setDuration(150);
            floatingDateAnimation.playTogether(ObjectAnimator.ofFloat(floatingDateView, View.ALPHA, 1.0f));
            floatingDateAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (animation.equals(floatingDateAnimation)) {
                        floatingDateAnimation = null;
                    }
                }
            });
            floatingDateAnimation.start();
        }
        if (!scroll) {
            invalidateMessagesVisiblePart();
            hideDateDelay = 1000;
        }
    }

    //隐藏浮窗日期
    private void hideFloatingDateView(boolean animated) {
        if (floatingDateView.getTag() != null && !currentFloatingDateOnScreen && (!scrollingFloatingDate || currentFloatingTopIsNotMessage)) {
            floatingDateView.setTag(null);
            if (animated) {
                floatingDateAnimation = new AnimatorSet();
                floatingDateAnimation.setDuration(150);
                floatingDateAnimation.playTogether(ObjectAnimator.ofFloat(floatingDateView, View.ALPHA, 0.0f));
                floatingDateAnimation.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (animation.equals(floatingDateAnimation)) {
                            floatingDateAnimation = null;
                        }
                    }
                });
                floatingDateAnimation.setStartDelay(hideDateDelay);
                floatingDateAnimation.start();
            } else {
                if (floatingDateAnimation != null) {
                    floatingDateAnimation.cancel();
                    floatingDateAnimation = null;
                }
                floatingDateView.setAlpha(0.0f);
            }
            hideDateDelay = 500;
        }
    }

    @Override
    public void onRemoveFromParent() {
        MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
        if (messageObject != null && messageObject.isVideo()) {
            MediaController.getInstance().cleanupPlayer(true, true);
        } else {
            MediaController.getInstance().setTextureView(videoTextureView, null, null, false);
        }
    }

    protected void setIgnoreAttachOnPause(boolean value) {
        ignoreAttachOnPause = value;
    }

    public ChatActivityEnterView getChatActivityEnterViewForStickers() {
        return bottomOverlayChat.getVisibility() != View.VISIBLE && (currentChat == null || ChatObject.canSendStickers(currentChat)) ? chatActivityEnterView : null;
    }

    public ChatActivityEnterView getChatActivityEnterView() {
        return chatActivityEnterView;
    }

    public boolean isKeyboardVisible() {
        return contentView.getKeyboardHeight() > AndroidUtilities.dp(20);
    }

    private void checkScrollForLoad(boolean scroll) {
        if (chatLayoutManager == null || paused || chatAdapter.isFrozen) {
            return;
        }
        int firstVisibleItem = RecyclerListView.NO_POSITION;
        int visibleItemCount = 0;
        for (int i = 0; i < chatListView.getChildCount(); i++) {
            int position = chatListView.getChildAdapterPosition(chatListView.getChildAt(i));
            if (position != RecyclerListView.NO_POSITION) {
                if (firstVisibleItem == RecyclerListView.NO_POSITION || position < firstVisibleItem) {
                    firstVisibleItem = position;
                }
                visibleItemCount++;
            }
        }
        final int firstVisibleItemFinal = firstVisibleItem;
        final int visibleItemCountFinal = visibleItemCount;
        int totalItemCount = chatAdapter.getItemCount();
        int checkLoadCount;
        if (scroll) {
            checkLoadCount = 25;
        } else {
            checkLoadCount = 5;
        }
        AndroidUtilities.runOnUIThread(() -> {
            if (totalItemCount - firstVisibleItemFinal - visibleItemCountFinal <= checkLoadCount && !loading) {
                if (!endReached[0]) {
                    loading = true;
                    waitingForLoad.add(lastLoadIndex);
                    if (messagesByDays.size() != 0) {
                        getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, maxMessageId[0], 0, !cacheEndReached[0], minDate[0], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    } else {
                        //检查滚动时载入聊天数据
                        getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, 0, 0, !cacheEndReached[0], minDate[0], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    }
                } else if (mergeDialogId != 0 && !endReached[1]) {
                    loading = true;
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(mergeDialogId, 0, false, 50, maxMessageId[1], 0, !cacheEndReached[1], minDate[1], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            }
            if (visibleItemCountFinal > 0 && !loadingForward && firstVisibleItemFinal <= 10) {
                if (mergeDialogId != 0 && !forwardEndReached[1]) {
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(mergeDialogId, 0, false, 50, minMessageId[1], 0, true, maxDate[1], classGuid, 1, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    loadingForward = true;
                } else if (!forwardEndReached[0]) {
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, minMessageId[0], 0, true, maxDate[0], classGuid, 1, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    loadingForward = true;
                }
            }
        });
    }

    private void processSelectedAttach(int which) {
        if (which == attach_photo) {
            if (Build.VERSION.SDK_INT >= 23 && getParentActivity().checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                getParentActivity().requestPermissions(new String[]{Manifest.permission.CAMERA}, 19);
                return;
            }
            try {
                Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
                File image = AndroidUtilities.generatePicturePath();
                if (image != null) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(getParentActivity(), ApplicationLoader.getApplicationId() + ".provider", image));
                        takePictureIntent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                        takePictureIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                    } else {
                        takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(image));
                    }
                    currentPicturePath = image.getAbsolutePath();
                }
                startActivityForResult(takePictureIntent, 0);
            } catch (Exception e) {
                FileLog.e(e);
            }
        } else if (which == attach_gallery) {
            final Activity activity = getParentActivity();
            if (Build.VERSION.SDK_INT >= 33) {
                if (activity.checkSelfPermission(Manifest.permission.READ_MEDIA_IMAGES) != PackageManager.PERMISSION_GRANTED) {
                    try {
                        getParentActivity().requestPermissions(new String[]{Manifest.permission.READ_MEDIA_IMAGES, Manifest.permission.READ_MEDIA_VIDEO}, BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE);
                    } catch (Throwable ignore) {}
                    return;
                }
            } else if (Build.VERSION.SDK_INT >= 23) {
                if (activity.checkSelfPermission(Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
                    try {
                        getParentActivity().requestPermissions(new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE);
                    } catch (Throwable ignore) {}
                    return;
                }
            }
            boolean allowGifs;
            if (ChatObject.isChannel(currentChat) && currentChat.banned_rights != null && currentChat.banned_rights.send_gifs) {
                allowGifs = false;
            } else {
                allowGifs = true;
            }
            PhotoAlbumPickerActivity fragment = new PhotoAlbumPickerActivity(PhotoAlbumPickerActivity.SELECT_TYPE_ALL, allowGifs, true, ChatActivity.this);
            if (currentChat != null && !ChatObject.hasAdminRights(currentChat) && currentChat.slowmode_enabled) {
                fragment.setMaxSelectedPhotos(10, true);
            } else {
                fragment.setMaxSelectedPhotos(editingMessageObject != null ? 1 : 0, editingMessageObject == null);
            }
            fragment.setDelegate(new PhotoAlbumPickerActivity.PhotoAlbumPickerActivityDelegate() {
                @Override
                public void didSelectPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate) {

                }

                @Override
                public void startPhotoSelectActivity() {
                    try {
                        Intent videoPickerIntent = new Intent();
                        videoPickerIntent.setType("video/*");
                        videoPickerIntent.setAction(Intent.ACTION_GET_CONTENT);
                        videoPickerIntent.putExtra(MediaStore.EXTRA_SIZE_LIMIT, FileLoader.DEFAULT_MAX_FILE_SIZE);

                        Intent photoPickerIntent = new Intent(Intent.ACTION_PICK);
                        photoPickerIntent.setType("image/*");
                        Intent chooserIntent = Intent.createChooser(photoPickerIntent, null);
                        chooserIntent.putExtra(Intent.EXTRA_INITIAL_INTENTS, new Intent[]{videoPickerIntent});

                        startActivityForResult(chooserIntent, 1);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                }
            });
            presentFragment(fragment);
        } else if (which == attach_video) {
            if (Build.VERSION.SDK_INT >= 23 && getParentActivity().checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                try {
                    getParentActivity().requestPermissions(new String[]{Manifest.permission.CAMERA}, BasePermissionsActivity.REQUEST_CODE_OPEN_CAMERA);
                } catch (Throwable ignore) {

                }
                return;
            }
            try {
                Intent takeVideoIntent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
                File video = AndroidUtilities.generateVideoPath();
                if (video != null) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        takeVideoIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(getParentActivity(), ApplicationLoader.getApplicationId() + ".provider", video));
                        takeVideoIntent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                        takeVideoIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                    } else if (Build.VERSION.SDK_INT >= 18) {
                        takeVideoIntent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(video));
                    }
                    takeVideoIntent.putExtra(MediaStore.EXTRA_SIZE_LIMIT, FileLoader.DEFAULT_MAX_FILE_SIZE);
                    currentPicturePath = video.getAbsolutePath();
                }
                startActivityForResult(takeVideoIntent, 2);
            } catch (Exception e) {
                FileLog.e(e);
            }
        }
    }

    public boolean allowSendGifs() {
        if (ChatObject.isChannel(currentChat) && currentChat.banned_rights != null && currentChat.banned_rights.send_gifs) {
            return false;
        } else {
            return true;
        }
    }

    public void openPollCreate(Boolean quiz) {
        PollCreateActivity pollCreateActivity = new PollCreateActivity(ChatActivity.this, quiz);
        pollCreateActivity.setDelegate((poll, params, notify, scheduleDate) -> {
            if (checkSlowModeAlert()) {
                getSendMessagesHelper().sendMessage(poll, dialog_id, replyingMessageObject, getThreadMessage(), null, params, notify, scheduleDate);
                afterMessageSend();
            }
        });
        presentFragment(pollCreateActivity);
    }

    @Override
    public void didSelectFiles(ArrayList<String> files, String caption, ArrayList<MessageObject> fmessages, boolean notify, int scheduleDate) {
        fillEditingMediaWithCaption(caption, null);
        if (checkSlowModeAlert()) {
            if (!fmessages.isEmpty() && !TextUtils.isEmpty(caption)) {
                SendMessagesHelper.getInstance(currentAccount).sendMessage(caption, dialog_id, null, null, null, true, null, null, null, true, 0, null, false);
                caption = null;
            }
            getSendMessagesHelper().sendMessage(fmessages, dialog_id, false, false, true, 0);
            SendMessagesHelper.prepareSendingDocuments(getAccountInstance(), files, files, null, caption, null, dialog_id, replyingMessageObject, getThreadMessage(), null, editingMessageObject, notify, scheduleDate);
            afterMessageSend();
        }
    }

    @Override
    public void didSelectPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate) {
        fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
        SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, true, false, editingMessageObject, notify, scheduleDate, photos.get(0).updateStickersOrder);
        afterMessageSend();
        if (scheduleDate != 0) {
            if (scheduledMessagesCount == -1) {
                scheduledMessagesCount = 0;
            }
            scheduledMessagesCount += photos.size();
            updateScheduledInterface(true);
        }
    }

    public void didSelectSearchPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate) {
        if (photos.isEmpty()) {
            return;
        }
        if (!checkSlowModeAlert()) {
            return;
        }
        boolean hasNoGifs = false;
        for (int a = 0; a < photos.size(); a++) {
            SendMessagesHelper.SendingMediaInfo info = photos.get(a);
            if (info.inlineResult == null && info.videoEditedInfo == null) {
                hasNoGifs = true;
                break;
            }
        }
        if (!hasNoGifs && !TextUtils.isEmpty(photos.get(0).caption)) {
            SendMessagesHelper.getInstance(currentAccount).sendMessage(photos.get(0).caption, dialog_id, replyingMessageObject, getThreadMessage(), null, false, photos.get(0).entities, null, null, notify, scheduleDate, null, false);
        }
        for (int a = 0; a < photos.size(); a++) {
            SendMessagesHelper.SendingMediaInfo info = photos.get(a);
            if (info.inlineResult != null && info.videoEditedInfo == null) {
                SendMessagesHelper.prepareSendingBotContextResult(this, getAccountInstance(), info.inlineResult, info.params, dialog_id, replyingMessageObject, getThreadMessage(), notify, scheduleDate);
                photos.remove(a);
                a--;
            }
        }
        if (photos.isEmpty()) {
            return;
        }
        fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
        SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, false, true, editingMessageObject, notify, scheduleDate, photos.get(0).updateStickersOrder);
        afterMessageSend();
        if (scheduleDate != 0) {
            if (scheduledMessagesCount == -1) {
                scheduledMessagesCount = 0;
            }
            scheduledMessagesCount += photos.size();
            updateScheduledInterface(true);
        }
    }

    @Override
    public void startDocumentSelectActivity() {
        try {
            Intent photoPickerIntent = new Intent(Intent.ACTION_GET_CONTENT);
            if (Build.VERSION.SDK_INT >= 18) {
                photoPickerIntent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
            }
            photoPickerIntent.setType("*/*");
            startActivityForResult(photoPickerIntent, 21);
        } catch (Exception e) {
            FileLog.e(e);
        }
    }

    @Override
    public boolean dismissDialogOnPause(Dialog dialog) {
        return dialog != chatAttachAlert && super.dismissDialogOnPause(dialog);
    }

    //输入词汇检测
    private void searchLinks(final CharSequence charSequence, final boolean force) {
        if (currentEncryptedChat != null && getMessagesController().secretWebpagePreview == 0 || editingMessageObject != null && !editingMessageObject.isWebpage()) {
            return;
        }
        if (force && foundWebPage != null) {
            if (foundWebPage.url != null) {
                int index = TextUtils.indexOf(charSequence, foundWebPage.url);
                char lastChar = 0;
                boolean lenEqual = false;
                if (index == -1) {
                    if (foundWebPage.display_url != null) {
                        index = TextUtils.indexOf(charSequence, foundWebPage.display_url);
                        lenEqual = index != -1 && index + foundWebPage.display_url.length() == charSequence.length();
                        lastChar = index != -1 && !lenEqual ? charSequence.charAt(index + foundWebPage.display_url.length()) : 0;
                    }
                } else {
                    lenEqual = index + foundWebPage.url.length() == charSequence.length();
                    lastChar = !lenEqual ? charSequence.charAt(index + foundWebPage.url.length()) : 0;
                }
                if (index != -1 && (lenEqual || lastChar == ' ' || lastChar == ',' || lastChar == '.' || lastChar == '!' || lastChar == '/')) {
                    return;
                }
            }
            pendingLinkSearchString = null;
            foundUrls = null;
            showFieldPanelForWebPage(false, foundWebPage, false);
        }
        final MessagesController messagesController = getMessagesController();
        Utilities.searchQueue.postRunnable(() -> {
            if (linkSearchRequestId != 0) {
                getConnectionsManager().cancelRequest(linkSearchRequestId, true);
                linkSearchRequestId = 0;
            }
            ArrayList<CharSequence> urls = null;
            CharSequence textToCheck;
            try {
                Matcher m = AndroidUtilities.WEB_URL.matcher(charSequence);
                while (m.find()) {
                    if (m.start() > 0) {
                        if (charSequence.charAt(m.start() - 1) == '@') {
                            continue;
                        }
                    }
                    if (urls == null) {
                        urls = new ArrayList<>();
                    }
                    urls.add(charSequence.subSequence(m.start(), m.end()));
                }
                if (charSequence instanceof Spannable) {
                    URLSpanReplacement[] spans = ((Spannable) charSequence).getSpans(0, charSequence.length(), URLSpanReplacement.class);
                    if (spans != null && spans.length > 0) {
                        if (urls == null) {
                            urls = new ArrayList<>();
                        }
                        for (int a = 0; a < spans.length; a++) {
                            urls.add(spans[a].getURL());
                        }
                    }
                }
                if (urls != null && foundUrls != null && urls.size() == foundUrls.size()) {
                    boolean clear = true;
                    for (int a = 0; a < urls.size(); a++) {
                        if (!TextUtils.equals(urls.get(a), foundUrls.get(a))) {
                            clear = false;
                        }
                    }
                    if (clear) {
                        return;
                    }
                }
                foundUrls = urls;
                if (urls == null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (foundWebPage != null) {
                            showFieldPanelForWebPage(false, foundWebPage, false);
                            foundWebPage = null;
                        }
                    });
                    return;
                }
                textToCheck = TextUtils.join(" ", urls);
            } catch (Exception e) {
                FileLog.e(e);
                String text = charSequence.toString().toLowerCase();
                if (charSequence.length() < 13 || !text.contains("http://") && !text.contains("https://")) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (foundWebPage != null) {
                            showFieldPanelForWebPage(false, foundWebPage, false);
                            foundWebPage = null;
                        }
                    });
                    return;
                }
                textToCheck = charSequence;
            }

            if (currentEncryptedChat != null && messagesController.secretWebpagePreview == 2) {
                AndroidUtilities.runOnUIThread(() -> {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setTitle(LocaleController.getString("AppName", R.string.AppName));
                    builder.setPositiveButton(LocaleController.getString("OK", R.string.OK), (dialog, which) -> {
                        messagesController.secretWebpagePreview = 1;
                        MessagesController.getGlobalMainSettings().edit().putInt("secretWebpage2", getMessagesController().secretWebpagePreview).commit();
                        foundUrls = null;
                        searchLinks(charSequence, force);
                    });
                    builder.setNegativeButton(LocaleController.getString("Cancel", R.string.Cancel), null);
                    builder.setMessage(LocaleController.getString("SecretLinkPreviewAlert", R.string.SecretLinkPreviewAlert));
                    showDialog(builder.create());

                    messagesController.secretWebpagePreview = 0;
                    MessagesController.getGlobalMainSettings().edit().putInt("secretWebpage2", messagesController.secretWebpagePreview).commit();
                });
                return;
            }

            final TLRPC.TL_messages_getWebPagePreview req = new TLRPC.TL_messages_getWebPagePreview();
            if (textToCheck instanceof String) {
                req.message = (String) textToCheck;
            } else {
                req.message = textToCheck.toString();
            }
            linkSearchRequestId = getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                linkSearchRequestId = 0;
                if (error == null) {
                    if (response instanceof TLRPC.TL_messageMediaWebPage) {
                        foundWebPage = ((TLRPC.TL_messageMediaWebPage) response).webpage;
                        if (foundWebPage instanceof TLRPC.TL_webPage || foundWebPage instanceof TLRPC.TL_webPagePending) {
                            if (foundWebPage instanceof TLRPC.TL_webPagePending) {
                                pendingLinkSearchString = req.message;
                            }
                            if (currentEncryptedChat != null && foundWebPage instanceof TLRPC.TL_webPagePending) {
                                foundWebPage.url = req.message;
                            }
                            showFieldPanelForWebPage(true, foundWebPage, false);
                        } else {
                            if (foundWebPage != null) {
                                showFieldPanelForWebPage(false, foundWebPage, false);
                                foundWebPage = null;
                            }
                        }
                    } else {
                        if (foundWebPage != null) {
                            showFieldPanelForWebPage(false, foundWebPage, false);
                            foundWebPage = null;
                        }
                    }
                }
            }));

            getConnectionsManager().bindRequestToGuid(linkSearchRequestId, classGuid);
        });
    }

    private void forwardMessages(ArrayList<MessageObject> arrayList, boolean fromMyName, boolean hideCaption, boolean notify, int scheduleDate) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        if (!checkSlowModeAlert()) {
            return;
        }
        if ((scheduleDate != 0) == (chatMode == MODE_SCHEDULED)) {
            waitingForSendingMessageLoad = true;
        }
        int result = getSendMessagesHelper().sendMessage(arrayList, dialog_id, fromMyName, hideCaption, notify, scheduleDate, getThreadMessage());
        AlertsCreator.showSendMediaAlert(result, this, themeDelegate);
        if (result != 0) {
            AndroidUtilities.runOnUIThread(() -> {
                waitingForSendingMessageLoad = false;
                hideFieldPanel(true);
            });
        }
    }

    public boolean shouldShowImport() {
        return openImport;
    }

    public void setOpenImport() {
        openImport = true;
    }

    private void checkBotKeyboard() {
        if (chatActivityEnterView == null || botButtons == null || userBlocked) {
            return;
        }
        if (botButtons.messageOwner.reply_markup instanceof TLRPC.TL_replyKeyboardForceReply) {
            SharedPreferences preferences = MessagesController.getMainSettings(currentAccount);
            if (preferences.getInt("answered_" + dialog_id, 0) != botButtons.getId() && (replyingMessageObject == null || chatActivityEnterView.getFieldText() == null)) {
                botReplyButtons = botButtons;
                chatActivityEnterView.setButtons(botButtons);
                showFieldPanelForReply(botButtons);
            }
        } else {
            if (replyingMessageObject != null && botReplyButtons == replyingMessageObject) {
                botReplyButtons = null;
                hideFieldPanel(true);
            }
            chatActivityEnterView.setButtons(botButtons);
        }
    }

    public void hideFieldPanel(boolean animated) {
        showFieldPanel(false, null, null, null, null, true, 0, false, animated);
    }

    public void hideFieldPanel(boolean notify, int scheduleDate, boolean animated) {
        showFieldPanel(false, null, null, null, null, notify, scheduleDate, false, animated);
    }

    public void showFieldPanelForWebPage(boolean show, TLRPC.WebPage webPage, boolean cancel) {
        showFieldPanel(show, null, null, null, webPage, true, 0, cancel, true);
    }

    public void showFieldPanelForForward(boolean show, ArrayList<MessageObject> messageObjectsToForward) {
        showFieldPanel(show, null, null, messageObjectsToForward, null, true, 0, false, true);
    }

    public void showFieldPanelForReply(MessageObject messageObjectToReply) {
        showFieldPanel(true, messageObjectToReply, null, null, null, true, 0, false, true);
    }

    public void showFieldPanelForEdit(boolean show, MessageObject messageObjectToEdit) {
        showFieldPanel(show, null, messageObjectToEdit, null, null, true, 0, false, true);
    }

    //显示隐藏输入框上方UI
    public void showFieldPanel(boolean show, MessageObject messageObjectToReply, MessageObject messageObjectToEdit, ArrayList<MessageObject> messageObjectsToForward, TLRPC.WebPage webPage, boolean notify, int scheduleDate, boolean cancel, boolean animated) {
        if (chatActivityEnterView == null) {
            return;
        }
        boolean showHint = false, showReplyHint = false;
        if (show) {
            if (messageObjectToReply == null && messageObjectsToForward == null && messageObjectToEdit == null && webPage == null) {
                return;
            }
            hideHints(false);
            if (searchItem != null && actionBar.isSearchFieldVisible()) {
                actionBar.closeSearchField(false);
                chatActivityEnterView.setFieldFocused();
                AndroidUtilities.runOnUIThread(() -> {
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.openKeyboard();
                    }
                }, 100);
            }
            boolean openKeyboard = false;
            if (messageObjectToReply != null && messageObjectToReply.getDialogId() != dialog_id) {
                messageObjectsToForward = new ArrayList<>();
                messageObjectsToForward.add(messageObjectToReply);
                messageObjectToReply = null;
                openKeyboard = true;
            }
            chatActivityEnterTopView.setEditMode(false);
            //编辑信息
            if (messageObjectToEdit != null) {
                forwardingMessages = null;
                if (threadMessageId == 0 || isTopic) {
                    if (isTopic) {
                        replyingMessageObject = threadMessageObject;
                    } else {
                        replyingMessageObject = null;
                    }
                    chatActivityEnterView.setReplyingMessageObject(null);
                    updateBottomOverlay();
                }
                editingMessageObject = messageObjectToEdit;
                final boolean mediaEmpty = messageObjectToEdit.isMediaEmpty();
                chatActivityEnterView.setEditingMessageObject(messageObjectToEdit, !mediaEmpty);
                if (foundWebPage != null) {
                    return;
                }
                chatActivityEnterView.setForceShowSendButton(false, false);
                final boolean canEditMedia = messageObjectToEdit.canEditMedia();
                replyCloseImageView.setContentDescription(LocaleController.getString("AccDescrCancelEdit", R.string.AccDescrCancelEdit));
                if (!mediaEmpty && canEditMedia) {
                    //修复媒体 内容
                    String editButtonText = null;
                    String replaceButtonText;
                    if (messageObjectToEdit.isPhoto()) {
                        editButtonText = LocaleController.getString("EditMessageEditPhoto", R.string.EditMessageEditPhoto);
                        replaceButtonText = LocaleController.getString("EditMessageReplacePhoto", R.string.EditMessageReplacePhoto);
                    } else if (messageObjectToEdit.isVideo()) {
                        editButtonText = LocaleController.getString("EditMessageEditVideo", R.string.EditMessageEditVideo);
                        replaceButtonText = LocaleController.getString("EditMessageReplaceVideo", R.string.EditMessageReplaceVideo);
                    } else if (messageObjectToEdit.isGif()) {
                        replaceButtonText = LocaleController.getString("EditMessageReplaceGif", R.string.EditMessageReplaceGif);
                    } else if (messageObjectToEdit.isMusic()) {
                        replaceButtonText = LocaleController.getString("EditMessageReplaceAudio", R.string.EditMessageReplaceAudio);
                    } else {
                        replaceButtonText = LocaleController.getString("EditMessageReplaceFile", R.string.EditMessageReplaceFile);
                    }
                    final ChatActivityEnterTopView.EditViewButton[] buttons = chatActivityEnterTopView.getEditView().getButtons();
                    buttons[0].setEditButton(editButtonText != null);
                    buttons[0].getTextView().setText(editButtonText != null ? editButtonText : replaceButtonText);
                    buttons[0].getImageView().setImageResource(editButtonText != null ? R.drawable.msg_photoeditor : R.drawable.msg_replace);
                    buttons[1].setVisibility(editButtonText != null ? View.VISIBLE : View.GONE);
                    if (editButtonText != null) {
                        buttons[1].getTextView().setText(replaceButtonText);
                    }
                    chatActivityEnterTopView.setEditMode(true);
                } else {
                    //修复文本内容
                    replyIconImageView.setImageResource(R.drawable.group_edit);
                    replyIconImageView.setContentDescription(LocaleController.getString("AccDescrEditing", R.string.AccDescrEditing));
                    if (mediaEmpty) {
                        replyNameTextView.setText(LocaleController.getString("EditMessage", R.string.EditMessage));
                    } else {
                        replyNameTextView.setText(LocaleController.getString("EditCaption", R.string.EditCaption));
                    }
                    if (canEditMedia) {
                        replyObjectTextView.setText(LocaleController.getString("EditMessageMedia", R.string.EditMessageMedia));
                    } else if (messageObjectToEdit.messageText != null || messageObjectToEdit.caption != null) {
                        String mess = messageObjectToEdit.caption != null ? messageObjectToEdit.caption.toString() : messageObjectToEdit.messageText.toString();
                        if (mess.length() > 150) {
                            mess = mess.substring(0, 150);
                        }
                        mess = mess.replace('\n', ' ');
                        Spannable cs = new SpannableStringBuilder(Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), AndroidUtilities.dp(14), false));
                        MediaDataController.addTextStyleRuns(messageObjectToEdit, cs);
                        if (messageObjectToEdit.messageOwner != null) {
                            cs = MessageObject.replaceAnimatedEmoji(cs, messageObjectToEdit.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                        }
                        replyObjectTextView.setText(AnimatedEmojiSpan.cloneSpans(cs));
                    }
                }
            } else if (messageObjectToReply != null) {
                //提及
                editingMessageObject = null;
                replyingMessageObject = messageObjectToReply;
                chatActivityEnterView.setReplyingMessageObject(messageObjectToReply);
                chatActivityEnterView.setEditingMessageObject(null, false);
                if (foundWebPage != null) {
                    return;
                }
                String restrictionReason = MessagesController.getRestrictionReason(messageObjectToReply.messageOwner.restriction_reason);
                chatActivityEnterView.setForceShowSendButton(false, false);
                String name;
                if (messageObjectToReply.isFromUser()) {
                    if (messageObjectToReply.messageOwner.from_id.channel_id != 0) {
                        TLRPC.Chat chat = getMessagesController().getChat(messageObjectToReply.messageOwner.from_id.channel_id);
                        if (chat == null) {
                            return;
                        }
                        name = chat.title;
                    } else {
                        TLRPC.User user = getMessagesController().getUser(messageObjectToReply.messageOwner.from_id.user_id);
                        if (user == null) {
                            return;
                        }
                        name = UserObject.getUserName(user);
                    }
                } else {
                    TLRPC.Chat chat;
                    if (ChatObject.isChannel(currentChat) && currentChat.megagroup && messageObjectToReply.isForwardedChannelPost()) {
                        chat = getMessagesController().getChat(messageObjectToReply.messageOwner.fwd_from.from_id.channel_id);
                    } else {
                        chat = getMessagesController().getChat(-messageObjectToReply.getSenderId());
                    }
                    if (chat == null) {
                        return;
                    }
                    name = chat.title;
                }
                replyIconImageView.setImageResource(R.drawable.msg_panel_reply);
                replyNameTextView.setText(name);
                replyIconImageView.setContentDescription(LocaleController.getString("AccDescrReplying", R.string.AccDescrReplying));
                replyCloseImageView.setContentDescription(LocaleController.getString("AccDescrCancelReply", R.string.AccDescrCancelReply));

                CharSequence replyObjectText = null;
                CharSequence sourceText = null;
                if (!TextUtils.isEmpty(restrictionReason)) {
                    replyObjectText = restrictionReason;
                    sourceText = restrictionReason;
                } else if (MessageObject.isTopicActionMessage(messageObjectToReply)) {
                    ForumUtilities.applyTopicToMessage(messageObjectToReply);
                    if (messageObjectToReply.messageTextForReply != null) {
                        replyObjectText = messageObjectToReply.messageTextForReply;
                    } else {
                        replyObjectText = messageObjectToReply.messageTextShort;
                    }
                    AnimatedEmojiSpan.applyFontMetricsForString(replyObjectText, replyObjectTextView.getPaint());
                } else if (messageObjectToReply.replyToForumTopic != null) {
                    replyObjectText = ForumUtilities.getTopicSpannedName(messageObjectToReply.replyToForumTopic, replyObjectTextView.getPaint());
                } else if (messageObjectToReply.messageOwner.media instanceof TLRPC.TL_messageMediaGame) {
                    replyObjectText = Emoji.replaceEmoji(messageObjectToReply.messageOwner.media.game.title, replyObjectTextView.getPaint().getFontMetricsInt(), AndroidUtilities.dp(14), false);
                    sourceText = messageObjectToReply.messageOwner.media.game.title;
                } else if (messageObjectToReply.messageText != null || messageObjectToReply.caption != null) {
                    CharSequence mess = messageObjectToReply.caption != null ? messageObjectToReply.caption.toString() : messageObjectToReply.messageText.toString();
                    sourceText = mess;
                    if (mess.length() > 150) {
                        mess = mess.subSequence(0, 150);
                    }
                    mess = AndroidUtilities.replaceNewLines(mess);
                    if (messageObjectToReply.messageOwner != null && messageObjectToReply.messageOwner.entities != null) {
                        mess = MessageObject.replaceAnimatedEmoji(mess, messageObjectToReply.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                    }
                    replyObjectText = Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), AndroidUtilities.dp(14), false);
                }
                if (replyObjectText != null) {
                    if (replyObjectText instanceof Spannable && sourceText != null) {
                        MediaDataController.addTextStyleRuns(messageObjectToReply.messageOwner.entities, sourceText, (Spannable) replyObjectText);
                    }

                    replyObjectTextView.setText(AnimatedEmojiSpan.cloneSpans(replyObjectText));
                }
                updateBottomOverlay();
            } else if (messageObjectsToForward != null) {
                //转发
                if (messageObjectsToForward.isEmpty()) {
                    return;
                }
                if (threadMessageId == 0 || isTopic) {
                    if (isTopic) {
                        replyingMessageObject = threadMessageObject;
                    } else {
                        replyingMessageObject = null;
                    }
                    chatActivityEnterView.setReplyingMessageObject(replyingMessageObject);
                    updateBottomOverlay();
                }
                editingMessageObject = null;
                chatActivityEnterView.setEditingMessageObject(null, false);
                if (forwardingMessages == null) {
                    forwardingMessages = new ForwardingMessagesParams(messageObjectsToForward, dialog_id);
                }
                if (foundWebPage != null) {
                    return;
                }
                chatActivityEnterView.setForceShowSendButton(true, false);
                ArrayList<Long> uids = new ArrayList<>();
                replyIconImageView.setImageResource(R.drawable.msg_panel_forward);
                replyIconImageView.setContentDescription(LocaleController.getString("AccDescrForwarding", R.string.AccDescrForwarding));
                replyCloseImageView.setContentDescription(LocaleController.getString("AccDescrCancelForward", R.string.AccDescrCancelForward));
                MessageObject object = messageObjectsToForward.get(0);
                if (object.isFromUser()) {
                    uids.add(object.messageOwner.from_id.user_id);
                } else {
                    TLRPC.Chat chat = getMessagesController().getChat(object.messageOwner.peer_id.channel_id);
                    if (ChatObject.isChannel(chat) && chat.megagroup && object.isForwardedChannelPost()) {
                        uids.add(-object.messageOwner.fwd_from.from_id.channel_id);
                    } else {
                        uids.add(-object.messageOwner.peer_id.channel_id);
                    }
                }

                int type = object.isAnimatedEmoji() || object.isDice() ? 0 : object.type;
                for (int a = 1; a < messageObjectsToForward.size(); a++) {
                    object = messageObjectsToForward.get(a);
                    long uid;
                    if (object.isFromUser()) {
                        uid = object.messageOwner.from_id.user_id;
                    } else {
                        TLRPC.Chat chat = getMessagesController().getChat(object.messageOwner.peer_id.channel_id);
                        if (ChatObject.isChannel(chat) && chat.megagroup && object.isForwardedChannelPost()) {
                            uid = -object.messageOwner.fwd_from.from_id.channel_id;
                        } else {
                            uid = -object.messageOwner.peer_id.channel_id;
                        }
                    }
                    if (!uids.contains(uid)) {
                        uids.add(uid);
                    }
                    if (messageObjectsToForward.get(a).type != type) {
                        type = -1;
                    }
                }
                StringBuilder userNames = new StringBuilder();
                for (int a = 0; a < uids.size(); a++) {
                    Long uid = uids.get(a);
                    TLRPC.Chat chat = null;
                    TLRPC.User user = null;
                    if (uid > 0) {
                        user = getMessagesController().getUser(uid);
                    } else {
                        chat = getMessagesController().getChat(-uid);
                    }
                    if (user == null && chat == null) {
                        continue;
                    }
                    if (uids.size() == 1) {
                        if (user != null) {
                            userNames.append(UserObject.getUserName(user));
                        } else {
                            userNames.append(chat.title);
                        }
                    } else if (uids.size() == 2 || userNames.length() == 0) {
                        if (userNames.length() > 0) {
                            userNames.append(", ");
                        }
                        if (user != null) {
                            if (!TextUtils.isEmpty(user.first_name)) {
                                userNames.append(user.first_name);
                            } else if (!TextUtils.isEmpty(user.last_name)) {
                                userNames.append(user.last_name);
                            } else {
                                userNames.append(" ");
                            }
                        } else {
                            userNames.append(chat.title);
                        }
                    } else {
                        userNames.append(" ");
                        userNames.append(LocaleController.formatPluralString("AndOther", uids.size() - 1));
                        break;
                    }
                }
                formwardingNameText = userNames;
                if (type == -1 || type == 0 || type == 10 || type == 11 || type == MessageObject.TYPE_EMOJIS) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardMessagesCount", messageObjectsToForward.size()));
                } else if (type == 1) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardPhoto", messageObjectsToForward.size()));
                    if (messageObjectsToForward.size() == 1) {
                            messageObjectToReply = messageObjectsToForward.get(0);
                    }
                } else if (type == 4) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardLocation", messageObjectsToForward.size()));
                } else if (type == 3) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardVideo", messageObjectsToForward.size()));
                    if (messageObjectsToForward.size() == 1) {
                        messageObjectToReply = messageObjectsToForward.get(0);
                    }
                } else if (type == 12) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardContact", messageObjectsToForward.size()));
                } else if (type == 2) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardAudio", messageObjectsToForward.size()));
                } else if (type == MessageObject.TYPE_ROUND_VIDEO) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardRound", messageObjectsToForward.size()));
                } else if (type == 14) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardMusic", messageObjectsToForward.size()));
                } else if (type == MessageObject.TYPE_STICKER || type == MessageObject.TYPE_ANIMATED_STICKER) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardSticker", messageObjectsToForward.size()));
                } else if (type == 17) {
                    replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardPoll", messageObjectsToForward.size()));
                } else if (type == 8 || type == 9) {
                    if (messageObjectsToForward.size() == 1 & type == 9) {
                        messageObjectToReply = messageObjectsToForward.get(0);
                    }
                    if (messageObjectsToForward.size() == 1 && type == 8) {
                        replyNameTextView.setText(LocaleController.getString("AttachGif", R.string.AttachGif));
                    } else {
                        replyNameTextView.setText(LocaleController.formatPluralString("PreviewForwardFile", messageObjectsToForward.size()));
                    }
                }

                if (forwardingMessages.hideForwardSendersName) {
                    replyObjectTextView.setText(LocaleController.getString("HiddenSendersNameDescription", R.string.HiddenSendersNameDescription));
                } else {
                    if ((type == -1 || type == 0 || type == 10 || type == 11 || type == MessageObject.TYPE_EMOJIS) && (messageObjectsToForward.size() == 1 && messageObjectsToForward.get(0).messageText != null)) {
                        MessageObject messageObject = messageObjectsToForward.get(0);
                        CharSequence mess = new SpannableStringBuilder(messageObject.messageText.toString());
                        if (mess.length() > 150) {
                            mess = mess.subSequence(0, 150);
                        }
                        mess = Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), AndroidUtilities.dp(14), false);
                        if (mess instanceof Spannable) {
                            MediaDataController.addTextStyleRuns(messageObject.messageOwner.entities, messageObject.messageText, (Spannable) mess);
                            if (messageObject.messageOwner != null) {
                                mess = MessageObject.replaceAnimatedEmoji(mess, messageObject.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                            }
                        }
                        replyObjectTextView.setText(mess);
                    } else {
                        replyObjectTextView.setText(LocaleController.formatString("ForwardingFromNames", R.string.ForwardingFromNames, userNames));
                    }
                }
                if (!SharedConfig.forwardingOptionsHintShown) {
                    showHint = true;
                }
            } else {
                //超链接
                replyIconImageView.setImageResource(R.drawable.msg_link);
                if (webPage instanceof TLRPC.TL_webPagePending) {
                    replyNameTextView.setText(LocaleController.getString("GettingLinkInfo", R.string.GettingLinkInfo));
                    replyObjectTextView.setText(pendingLinkSearchString);
                } else {
                    if (webPage.site_name != null) {
                        replyNameTextView.setText(webPage.site_name);
                    } else if (webPage.title != null) {
                        replyNameTextView.setText(webPage.title);
                    } else {
                        replyNameTextView.setText(LocaleController.getString("LinkPreview", R.string.LinkPreview));
                    }
                    if (webPage.title != null) {
                        replyObjectTextView.setText(webPage.title);
                    } else if (webPage.description != null) {
                        replyObjectTextView.setText(webPage.description);
                    } else if (webPage.author != null) {
                        replyObjectTextView.setText(webPage.author);
                    } else {
                        replyObjectTextView.setText(webPage.display_url);
                    }
                    chatActivityEnterView.setWebPage(webPage, true);
                }
            }
            MessageObject thumbMediaMessageObject;
            if (messageObjectToReply != null) {
                thumbMediaMessageObject = messageObjectToReply;
            } else if (messageObjectToEdit != null) {
                if (!chatActivityEnterTopView.isEditMode()) {
                    thumbMediaMessageObject = messageObjectToEdit;
                } else {
                    thumbMediaMessageObject = null;
                }
            } else {
                thumbMediaMessageObject = null;
            }

            FrameLayout.LayoutParams layoutParams1 = (FrameLayout.LayoutParams) replyNameTextView.getLayoutParams();
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams) replyObjectTextView.getLayoutParams();
            FrameLayout.LayoutParams layoutParams3 = (FrameLayout.LayoutParams) replyObjectHintTextView.getLayoutParams();

            int cacheType = 1;
            int size = 0;
            TLRPC.PhotoSize photoSize = null;
            TLRPC.PhotoSize thumbPhotoSize = null;
            TLObject photoSizeObject = null;
            if (thumbMediaMessageObject != null && TextUtils.isEmpty(MessagesController.getRestrictionReason(thumbMediaMessageObject.messageOwner.restriction_reason))) {
                photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs2, 320);
                thumbPhotoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs2, AndroidUtilities.dp(40));
                photoSizeObject = thumbMediaMessageObject.photoThumbsObject2;
                if (photoSize == null) {
                    if (thumbMediaMessageObject.mediaExists) {
                        photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, AndroidUtilities.getPhotoSize());
                        if (photoSize != null) {
                            size = photoSize.size;
                        }
                        cacheType = 0;
                    } else {
                        photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, 320);
                    }
                    thumbPhotoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, AndroidUtilities.dp(40));
                    photoSizeObject = thumbMediaMessageObject.photoThumbsObject;
                }
            }
            if (photoSize == thumbPhotoSize) {
                thumbPhotoSize = null;
            }
            if (photoSize == null || photoSize instanceof TLRPC.TL_photoSizeEmpty || photoSize.location instanceof TLRPC.TL_fileLocationUnavailable || thumbMediaMessageObject.isAnyKindOfSticker() || thumbMediaMessageObject.isSecretMedia() || thumbMediaMessageObject.isWebpageDocument()) {
                replyImageView.setImageBitmap(null);
                replyImageLocation = null;
                replyImageLocationObject = null;
                replyImageView.setVisibility(View.INVISIBLE);
                layoutParams1.leftMargin = layoutParams2.leftMargin = layoutParams3.leftMargin = AndroidUtilities.dp(52);
            } else {
                if (thumbMediaMessageObject.isRoundVideo()) {
                    replyImageView.setRoundRadius(AndroidUtilities.dp(17));
                } else {
                    replyImageView.setRoundRadius(AndroidUtilities.dp(2));
                }
                replyImageSize = size;
                replyImageCacheType = cacheType;
                replyImageLocation = photoSize;
                replyImageThumbLocation = thumbPhotoSize;
                replyImageLocationObject = photoSizeObject;
                replyImageHasMediaSpoiler = thumbMediaMessageObject.hasMediaSpoilers();
                replyImageView.setImage(ImageLocation.getForObject(replyImageLocation, photoSizeObject), replyImageHasMediaSpoiler ? "5_5_b" : "50_50", ImageLocation.getForObject(thumbPhotoSize, photoSizeObject), replyImageHasMediaSpoiler ? "5_5_b" : "50_50_b", null, size, cacheType, thumbMediaMessageObject);
                replyImageView.setVisibility(View.VISIBLE);
                layoutParams1.leftMargin = layoutParams2.leftMargin = layoutParams3.leftMargin = AndroidUtilities.dp(96);
            }
            replyNameTextView.setLayoutParams(layoutParams1);
            replyObjectTextView.setLayoutParams(layoutParams2);
            replyObjectTextView.setLayoutParams(layoutParams3);
            chatActivityEnterView.showTopView(true, openKeyboard);
        } else {
            if (replyingMessageObject == null && forwardingMessages == null && foundWebPage == null && editingMessageObject == null && !chatActivityEnterView.isTopViewVisible()) {
                return;
            }
            if (replyingMessageObject != null && replyingMessageObject.messageOwner.reply_markup instanceof TLRPC.TL_replyKeyboardForceReply) {
                SharedPreferences preferences = MessagesController.getMainSettings(currentAccount);
                preferences.edit().putInt("answered_" + dialog_id, replyingMessageObject.getId()).commit();
            }
            if (foundWebPage != null) {
                foundWebPage = null;
                chatActivityEnterView.setWebPage(null, !cancel);
                if (webPage != null && (replyingMessageObject != null || forwardingMessages != null || editingMessageObject != null)) {
                    showFieldPanel(true, replyingMessageObject, editingMessageObject, forwardingMessages != null ? forwardingMessages.messages : null, null, notify, scheduleDate, false, true);
                    return;
                }
            }
            if (forwardingMessages != null) {
                ArrayList<MessageObject> messagesToForward = new ArrayList<>();
                forwardingMessages.getSelectedMessages(messagesToForward);
                forwardMessages(messagesToForward, forwardingMessages.hideForwardSendersName, forwardingMessages.hideCaption, notify, scheduleDate != 0 && scheduleDate != 0x7ffffffe ? scheduleDate + 1 : scheduleDate);
                forwardingMessages = null;
            }
            chatActivityEnterView.setForceShowSendButton(false, animated);
            if (!waitingForSendingMessageLoad) {
                chatActivityEnterView.hideTopView(animated);
            }
            chatActivityEnterView.setReplyingMessageObject(threadMessageObject);
            chatActivityEnterView.setEditingMessageObject(null, false);
            topViewWasVisible = 0;
            replyingMessageObject = threadMessageObject;
            editingMessageObject = null;
            replyImageLocation = null;
            replyImageLocationObject = null;
            updateBottomOverlay();
        }

        //通过通明度是否显示提示内容
        if (showHint) {
            if (tapForForwardingOptionsHitRunnable == null) {
                AndroidUtilities.runOnUIThread(tapForForwardingOptionsHitRunnable = () -> {
                    showTapForForwardingOptionsHit = !showTapForForwardingOptionsHit;
                    replyObjectTextView.setPivotX(0);
                    replyObjectHintTextView.setPivotX(0);
                    if (showTapForForwardingOptionsHit) {
                        replyObjectTextView.animate().alpha(0f).scaleX(0.98f).scaleY(0.98f).setDuration(150).start();
                        replyObjectHintTextView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
                    } else {
                        replyObjectTextView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
                        replyObjectHintTextView.animate().alpha(0f).scaleX(0.98f).scaleY(0.98f).setDuration(150).start();
                    }
                    AndroidUtilities.runOnUIThread(tapForForwardingOptionsHitRunnable, 6000);
                }, 6000);
            }
        } else {
            if (tapForForwardingOptionsHitRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(tapForForwardingOptionsHitRunnable);
                tapForForwardingOptionsHitRunnable = null;
            }
            replyObjectTextView.setAlpha(1f);
            replyObjectHintTextView.setAlpha(0);
        }

        if (showReplyHint) {

        } else {

        }
    }

    private void moveScrollToLastMessage(boolean skipSponsored) {
        if (chatListView != null && !messages.isEmpty() && !pinchToZoomHelper.isInOverlayMode()) {
            int position = 0;
            if (skipSponsored) {
                position += getSponsoredMessagesCount();
            }
            chatLayoutManager.scrollToPositionWithOffset(position, 0);
            chatListView.stopScroll();
        }
    }

    private Runnable sendSecretMessageRead(MessageObject messageObject, boolean readNow) {
        if (messageObject == null || messageObject.isOut() || !messageObject.isSecretMedia() || messageObject.messageOwner.destroyTime != 0 || messageObject.messageOwner.ttl <= 0) {
            return null;
        }
        messageObject.messageOwner.destroyTime = messageObject.messageOwner.ttl + getConnectionsManager().getCurrentTime();
        if (readNow) {
            if (currentEncryptedChat != null) {
                getMessagesController().markMessageAsRead(dialog_id, messageObject.messageOwner.random_id, messageObject.messageOwner.ttl);
            } else {
                getMessagesController().markMessageAsRead2(dialog_id, messageObject.getId(), null, messageObject.messageOwner.ttl, 0);
            }
            return null;
        } else {
            return () -> {
                if (currentEncryptedChat != null) {
                    getMessagesController().markMessageAsRead(dialog_id, messageObject.messageOwner.random_id, messageObject.messageOwner.ttl);
                } else {
                    getMessagesController().markMessageAsRead2(dialog_id, messageObject.getId(), null, messageObject.messageOwner.ttl, 0);
                }
            };
        }
    }

    private void clearChatData() {
        messages.clear();
        messagesByDays.clear();
        waitingForLoad.clear();
        groupedMessagesMap.clear();
        threadMessageAdded = false;

        if (chatAdapter != null) {
            showProgressView(chatAdapter.botInfoRow < 0);
        }
        if (chatListView != null) {
            chatListView.setEmptyView(null);
        }
        for (int a = 0; a < 2; a++) {
            messagesDict[a].clear();
            if (currentEncryptedChat == null) {
                maxMessageId[a] = Integer.MAX_VALUE;
                minMessageId[a] = Integer.MIN_VALUE;
            } else {
                maxMessageId[a] = Integer.MIN_VALUE;
                minMessageId[a] = Integer.MAX_VALUE;
            }
            maxDate[a] = Integer.MIN_VALUE;
            minDate[a] = 0;
            endReached[a] = false;
            cacheEndReached[a] = false;
            forwardEndReached[a] = true;
        }
        first = true;
        firstLoading = true;
        loading = true;
        loadingForward = false;
        waitingForReplyMessageLoad = false;
        startLoadFromMessageId = 0;
        showScrollToMessageError = false;
        last_message_id = 0;
        unreadMessageObject = null;
        createUnreadMessageAfterId = 0;
        createUnreadMessageAfterIdLoading = false;
        needSelectFromMessageId = false;
        if (chatAdapter != null) {
            chatAdapter.notifyDataSetChanged(false);
        }
    }

    public void scrollToLastMessage(boolean skipSponsored, boolean top) {
        scrollToLastMessage(skipSponsored, top, null);
    }

    public void scrollToLastMessage(boolean skipSponsored, boolean top, Runnable inCaseLoading) {
        if (chatListView.isFastScrollAnimationRunning()) {
            return;
        }
        forceNextPinnedMessageId = 0;
        nextScrollToMessageId = 0;
        forceScrollToFirst = false;
        chatScrollHelper.setScrollDirection(RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN);
        if (forwardEndReached[0] && first_unread_id == 0 && startLoadFromMessageId == 0) {
            setPagedownLoading(false, true);
            if (chatLayoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                canShowPagedownButton = false;
                updatePagedownButtonVisibility(true);
                removeSelectedMessageHighlight();
                updateVisibleRows();
            } else {
                chatAdapter.updateRowsSafe();
                chatScrollHelperCallback.scrollTo = null;
                int position = 0;
                if (skipSponsored) {
                    while (position < messages.size()) {
                        if (!messages.get(position).isSponsored()) {
                            break;
                        }
                        position++;
                    }
                }
                if (top && messages != null && messages.size() > 0 && messages.get(position) != null) {
                    long groupId = messages.get(position).getGroupId();
                    while (groupId != 0 && position + 1 < messages.size()) {
                        if (groupId != messages.get(position + 1).getGroupId()) {
                            break;
                        }
                        position++;
                    }
                }
                if (messages != null && messages.size() > 0) {
                    position = Math.min(position, messages.size() - 1);
                }
                final int finalPosition = position;
                Runnable scroll = () -> {
                    chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = finalPosition, chatScrollHelperCallback.offset = 0, chatScrollHelperCallback.bottom = !top, true);
                };
                if (SCROLL_DEBUG_DELAY && inCaseLoading != null) {
                    inCaseLoading.run();
                    AndroidUtilities.runOnUIThread(() -> {
                        resetProgressDialogLoading();
                        scroll.run();
                    }, 7500);
                } else {
                    scroll.run();
                }
            }
        } else {
            if (progressDialog != null) {
                progressDialog.dismiss();
            }

            updatePinnedListButton(false);
            if (inCaseLoading != null) {
                inCaseLoading.run();
            } else {
                resetProgressDialogLoading();
                progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
                progressDialog.setOnCancelListener(postponedScrollCancelListener);
                progressDialog.showDelayed(1000);
            }

            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            postponedScrollMessageId = 0;
            postponedScrollIsCanceled = false;
            waitingForLoad.clear();

            waitingForLoad.add(lastLoadIndex);
            AndroidUtilities.runOnUIThread(() -> {
                getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, 0, true, 0, classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            }, SCROLL_DEBUG_DELAY ? 7500 : 0);
        }
    }

    public void updateTextureViewPosition(boolean needVisibleUpdate, boolean needScroll) {
        if (fragmentView == null || paused) {
            return;
        }
        boolean foundTextureViewMessage = false;
        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View view = chatListView.getChildAt(a);
            if (view instanceof ChatMessageCell) {
                ChatMessageCell messageCell = (ChatMessageCell) view;
                MessageObject messageObject = messageCell.getMessageObject();
                if (videoPlayerContainer != null && (messageObject.isRoundVideo() || messageObject.isVideo()) && !messageObject.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                    ImageReceiver imageReceiver = messageCell.getPhotoImage();
                    videoPlayerContainer.setTranslationX(imageReceiver.getImageX() + messageCell.getX());
                    float translationY = messageCell.getY() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                    videoPlayerContainer.setTranslationY(translationY);
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) videoPlayerContainer.getLayoutParams();
                    if (messageObject.isRoundVideo()) {
                        videoPlayerContainer.setTag(R.id.parent_tag, null);
                        if (layoutParams.width != AndroidUtilities.roundPlayingMessageSize || layoutParams.height != AndroidUtilities.roundPlayingMessageSize) {
                            layoutParams.width = layoutParams.height = AndroidUtilities.roundPlayingMessageSize;
                            aspectRatioFrameLayout.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FIT);
                            videoPlayerContainer.setLayoutParams(layoutParams);
                        }
                        float scale = (AndroidUtilities.roundPlayingMessageSize + AndroidUtilities.roundMessageInset * 2) / (float) AndroidUtilities.roundPlayingMessageSize;
                        float transitionScale = messageCell.getPhotoImage().getImageWidth() / AndroidUtilities.roundPlayingMessageSize;
                        if (videoPlayerContainer.getScaleX() != transitionScale) {
                            videoPlayerContainer.invalidate();
                            fragmentView.invalidate();
                        }
                        videoPlayerContainer.setPivotX(0);
                        videoPlayerContainer.setPivotY(0);
                        videoPlayerContainer.setScaleX(transitionScale);
                        videoPlayerContainer.setScaleY(transitionScale);
                        videoTextureView.setScaleX(scale);
                        videoTextureView.setScaleY(scale);
                    } else {
                        videoPlayerContainer.setTag(R.id.parent_tag, imageReceiver);
                        if (layoutParams.width != imageReceiver.getImageWidth() || layoutParams.height != imageReceiver.getImageHeight()) {
                            aspectRatioFrameLayout.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FILL);
                            layoutParams.width = (int) imageReceiver.getImageWidth();
                            layoutParams.height = (int) imageReceiver.getImageHeight();
                            videoPlayerContainer.setLayoutParams(layoutParams);
                        }
                        videoTextureView.setScaleX(1f);
                        videoTextureView.setScaleY(1f);
                    }
                    fragmentView.invalidate();
                    videoPlayerContainer.invalidate();
                    foundTextureViewMessage = true;
                    break;
                }
            }
        }
        if (needVisibleUpdate && videoPlayerContainer != null) {
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            if (messageObject != null && messageObject.eventId == 0) {
                if (!foundTextureViewMessage) {
                    if (checkTextureViewPosition && messageObject.isVideo()) {
                        MediaController.getInstance().cleanupPlayer(true, true);
                    } else {
                        videoPlayerContainer.setTranslationY(-AndroidUtilities.roundPlayingMessageSize - 100);
                        fragmentView.invalidate();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            if (checkTextureViewPosition || PipRoundVideoView.getInstance() != null) {
                                MediaController.getInstance().setCurrentVideoVisible(false);
                            } else if (needScroll) {
                                scrollToMessageId(messageObject.getId(), 0, false, 0, true, 0);
                            }
                        }
                    }
                } else {
                    MediaController.getInstance().setCurrentVideoVisible(true);
                    if (messageObject.isRoundVideo() || scrollToVideo) {
                     //   scrollToMessageId(messageObject.getId(), 0, false, 0, true, 0);
                    } else {
                        chatListView.invalidate();
                    }
                }
            }
        }
    }

    public void invalidateMessagesVisiblePart() {
        invalidateMessagesVisiblePart = true;
        if (fragmentView != null) {
            fragmentView.invalidate();
        }
    }

    private Integer findClosest(ArrayList<Integer> arrayList, int target, int[] index) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        Integer val = arrayList.get(0);
        if (target >= val) {
            index[0] = 0;
            return val;
        }
        int n = arrayList.size();
        val = arrayList.get(n - 1);
        if (target <= val) {
            index[0] = n - 1;
            return val;
        }

        int i = 0, j = n, mid = 0;
        while (i < j) {
            mid = (i + j) / 2;

            val = arrayList.get(mid);
            if (val == target) {
                index[0] = mid;
                return val;
            }
            if (target < val) {
                if (mid > 0) {
                    Integer val2 = arrayList.get(mid - 1);
                    if (target > val2) {
                        index[0] = mid - 1;
                        return val2;
                    }
                }
                i = mid + 1;
            } else {
                if (mid > 0) {
                    Integer val2 = arrayList.get(mid - 1);
                    if (target < val2) {
                        index[0] = mid;
                        return val;
                    }
                }
                j = mid;
            }
        }
        index[0] = mid;
        return arrayList.get(mid);
    }

    public void updateMessagesVisiblePart(boolean inLayout) {
        if (chatListView == null || fragmentView == null) {
            return;
        }
        int count = chatListView.getChildCount();
        int height = chatListView.getMeasuredHeight();
        int minPositionHolder = Integer.MAX_VALUE;
        int minPositionDateHolder = Integer.MAX_VALUE;
        View minDateChild = null;
        View minChild = null;
        View minMessageChild = null;
        boolean foundTextureViewMessage = false;
        boolean previousThreadMessageVisible = threadMessageVisible;
        int previousPinnedMessageId = currentPinnedMessageId;
        int maxVisibleId = Integer.MIN_VALUE;
        MessageObject maxVisibleMessageObject = null;
        threadMessageVisible = firstLoading;

        Integer currentReadMaxId = null;
        int threadId = threadMessageId;
        if (threadId != 0 && currentChat != null) {
            currentReadMaxId = replyMaxReadId;
        } else {
            currentReadMaxId = getMessagesController().dialogs_read_inbox_max.get(dialog_id_Long);
        }
        if (currentReadMaxId == null) {
            currentReadMaxId = 0;
        }
        int maxPositiveUnreadId = Integer.MIN_VALUE;
        int maxNegativeUnreadId = Integer.MAX_VALUE;
        int maxUnreadDate = Integer.MIN_VALUE;
        int recyclerChatViewHeight = (contentView.getHeightWithKeyboard() - (inPreviewMode ? 0 : AndroidUtilities.dp(48)) - chatListView.getTop());
        pollsToCheck.clear();
        float clipTop = chatListViewPaddingTop;
        long currentTime = System.currentTimeMillis();
        int maxAdapterPosition = -1;
        int minAdapterPosition = -1;

        boolean blurEnabled = SharedConfig.chatBlurEnabled() && Color.alpha(Theme.getColor(Theme.key_chat_BlurAlpha)) != 255;

        MessageObject messageStarter = isTopic ? topicStarterMessageObject : threadMessageObject;

        for (int a = 0; a < count; a++) {
            View view = chatListView.getChildAt(a);
            MessageObject messageObject = null;
            int adapterPosition = chatListView.getChildAdapterPosition(view);
            if (adapterPosition >= 0) {
                if (adapterPosition > maxAdapterPosition || maxAdapterPosition == -1) {
                    maxAdapterPosition = adapterPosition;
                }
                if (adapterPosition < minAdapterPosition || minAdapterPosition == -1) {
                    minAdapterPosition = adapterPosition;
                }
            }
            int top = (int) view.getY();
            int bottom = top + view.getMeasuredHeight();
            ChatMessageCell messageCell = null;
            if (view instanceof ChatMessageCell) {
                messageCell = (ChatMessageCell) view;
            }
            if (messageCell != null) {
                messageCell.isBlurred = (top < clipTop && bottom > clipTop) || (bottom > chatListView.getMeasuredHeight() - blurredViewBottomOffset && top < chatListView.getMeasuredHeight() - blurredViewBottomOffset);
            }

            if (bottom <= clipTop - chatListViewPaddingVisibleOffset || top > chatListView.getMeasuredHeight() - blurredViewBottomOffset) {
                if (messageCell != null) {
                    if (!blurEnabled) {
                        messageCell.setVisibleOnScreen(false);
                    } else {
                        messageCell.setVisibleOnScreen(true);
                    }
                }
                continue;
            }
            if (messageCell != null) {
                messageCell.setVisibleOnScreen(true);
            }

            int viewTop = top >= 0 ? 0 : -top;
            int viewBottom = view.getMeasuredHeight();
            if (viewBottom > height) {
                viewBottom = viewTop + height;
            }
            int keyboardOffset = contentView.getKeyboardHeight();
            if (keyboardOffset < AndroidUtilities.dp(20) && chatActivityEnterView.isPopupShowing() || chatActivityEnterView.panelAnimationInProgress()) {
                keyboardOffset = chatActivityEnterView.getEmojiPadding();
            }

            if (messageCell != null) {
                messageObject = messageCell.getMessageObject();
                if (messageObject.getDialogId() == dialog_id && messageObject.getId() > maxVisibleId) {
                    maxVisibleId = messageObject.getId();
                    maxVisibleMessageObject = messageObject;
                }

                messageCell.setParentBounds(chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4), chatListView.getMeasuredHeight() - blurredViewBottomOffset);
                messageCell.setVisiblePart(viewTop, viewBottom - viewTop, recyclerChatViewHeight, keyboardOffset, view.getY() + (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY(), contentView.getMeasuredWidth(), contentView.getBackgroundSizeY(), blurredViewTopOffset, blurredViewBottomOffset);
                markSponsoredAsRead(messageObject);
                if (!threadMessageVisible && messageStarter != null && (messageObject == messageStarter || isTopic && messageObject != null && messageObject.getId() == messageStarter.getId()) && messageCell.getBottom() > chatListViewPaddingTop) {
                    threadMessageVisible = true;
                }
                if (videoPlayerContainer != null && (messageObject.isVideo() || messageObject.isRoundVideo()) && !messageObject.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                    ImageReceiver imageReceiver = messageCell.getPhotoImage();
                    if (top + imageReceiver.getImageY2() < 0) {
                        foundTextureViewMessage = false;
                    } else {
                        videoPlayerContainer.setTranslationX(imageReceiver.getImageX() + messageCell.getX());

                        float translationY = messageCell.getY() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                        videoPlayerContainer.setTranslationY(translationY);
                        fragmentView.invalidate();
                        videoPlayerContainer.invalidate();
                        foundTextureViewMessage = true;
                    }
                }
                if (startFromVideoTimestamp >= 0 && fragmentOpened && !chatListView.isFastScrollAnimationRunning() && startFromVideoMessageId == messageObject.getId() && (messageObject.isVideo() || messageObject.isRoundVideo() || messageObject.isVoice() || messageObject.isMusic())) {
                    messageObject.forceSeekTo = startFromVideoTimestamp / (float) messageObject.getDuration();
                    MessageObject finalMessage = messageObject;
                    AndroidUtilities.runOnUIThread(() -> {
                        if (finalMessage.isVideo()) {
                            openPhotoViewerForMessage(null, finalMessage);
                        } else {
                            MediaController.getInstance().playMessage(finalMessage);
                        }
                    }, 40);
                    startFromVideoTimestamp = -1;
                }

                if (fragmentOpened && openAnimationEnded && (chatListItemAnimator == null || !chatListItemAnimator.isRunning()) && messageCell.checkUnreadReactions(clipTop, chatListView.getMeasuredHeight() - blurredViewBottomOffset)) {
                    reactionsMentionCount--;
                    getMessagesStorage().markMessageReactionsAsRead(getDialogId(), getTopicId(), messageCell.getMessageObject().getId(), true);
                    if (reactionsMentionCount <= 0) {
                        getMessagesController().markReactionsAsRead(dialog_id, getTopicId());
                    }
                    if (reactionsMentionCount >= 0) {
                        TLRPC.MessagePeerReaction reaction = messageCell.getMessageObject().getRandomUnreadReaction();
                        if (reaction != null) {
                            ReactionsLayoutInBubble.VisibleReaction visibleReaction =  ReactionsLayoutInBubble.VisibleReaction.fromTLReaction(reaction.reaction);
                            ReactionsEffectOverlay.show(ChatActivity.this, null, messageCell, null, 0, 0, visibleReaction, currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                            ReactionsEffectOverlay.startAnimation();
                        }
                        messageCell.markReactionsAsRead();
                    } else {
                        reactionsMentionCount = 0;
                    }
                    updateReactionsMentionButton(true);
                }
                getDownloadController().checkUnviewedDownloads(messageCell.getId(), dialog_id);
                boolean allowPlayEffect =  ((messageObject.messageOwner.media != null && !messageObject.messageOwner.media.nopremium) || (messageObject.isAnimatedEmojiStickerSingle() && dialog_id > 0));
                if ((chatListItemAnimator == null || !chatListItemAnimator.isRunning()) && (!messageObject.isOutOwner() || messageObject.forcePlayEffect) && allowPlayEffect && !messageObject.messageOwner.premiumEffectWasPlayed && (messageObject.isPremiumSticker() || messageObject.isAnimatedEmojiStickerSingle()) && emojiAnimationsOverlay.isIdle() && emojiAnimationsOverlay.checkPosition(messageCell, chatListViewPaddingTop, chatListView.getMeasuredHeight() - blurredViewBottomOffset)) {
                    emojiAnimationsOverlay.onTapItem(messageCell, ChatActivity.this, false);
                } else if (messageObject.isAnimatedAnimatedEmoji()) {
                    emojiAnimationsOverlay.preloadAnimation(messageCell);
                }
            } else if (view instanceof ChatActionCell) {
                ChatActionCell cell = (ChatActionCell) view;
                messageObject = cell.getMessageObject();
                if (messageObject != null && messageObject.getDialogId() == dialog_id && messageObject.getId() > maxVisibleId) {
                    maxVisibleId = Math.max(maxVisibleId, messageObject.getId());
                }
                cell.setVisiblePart(view.getY() + (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY(), contentView.getBackgroundSizeY());
            } else if (view instanceof BotHelpCell) {
                view.invalidate();
            }
            if (chatMode != MODE_SCHEDULED && messageObject != null) {
                int id = messageObject.getId();
                if (!isThreadChat() && (!messageObject.isOut() && messageObject.isUnread() || messageObject.messageOwner.from_scheduled && id > currentReadMaxId) || id > 0 && isThreadChat() && id > currentReadMaxId && id > replyMaxReadId) {
                    if (id > 0) {
                        maxPositiveUnreadId = Math.max(maxPositiveUnreadId, messageObject.getId());
                    }
                    if (id < 0 && !isThreadChat()) {
                        maxNegativeUnreadId = Math.min(maxNegativeUnreadId, messageObject.getId());
                    }
                    maxUnreadDate = Math.max(maxUnreadDate, messageObject.messageOwner.date);
                }
                if (messageObject.type == MessageObject.TYPE_POLL && messageObject.getId() > 0) {
                    pollsToCheck.add(messageObject);
                }
            }
            if (bottom <= clipTop) {
                if (view instanceof ChatActionCell && messageObject.isDateObject) {
                    view.setAlpha(0);
                }
                continue;
            }
            int position = view.getBottom();
            if (position < minPositionHolder) {
                minPositionHolder = position;
                if (view instanceof ChatMessageCell || view instanceof ChatActionCell) {
                    minMessageChild = view;
                }
                minChild = view;
            }
            if (chatListItemAnimator == null || (!chatListItemAnimator.willRemoved(view) && !chatListItemAnimator.willAddedFromAlpha(view))) {
                if (view instanceof ChatActionCell && messageObject.isDateObject) {
                    if (view.getAlpha() != 1.0f) {
                        view.setAlpha(1.0f);
                    }
                    if (position < minPositionDateHolder) {
                        minPositionDateHolder = position;
                        minDateChild = view;
                    }
                }
            }
        }
        currentPinnedMessageId = 0;
        if (!pinnedMessageIds.isEmpty()) {
            if (maxVisibleId == Integer.MIN_VALUE) {
                if (startLoadFromMessageId != 0) {
                    maxVisibleId = startLoadFromMessageId;
                } else if (!pinnedMessageIds.isEmpty()) {
                    maxVisibleId = pinnedMessageIds.get(0) + 1;
                }
            } else if (maxVisibleId < 0) {
                int idx = messages.indexOf(maxVisibleMessageObject);
                if (idx >= 0) {
                    for (int a = idx - 1; a >= 0; a--) {
                        MessageObject object = messages.get(a);
                        if (object.getId() > 0) {
                            maxVisibleId = object.getId();
                            break;
                        }
                    }
                    if (maxVisibleId < 0) {
                        for (int a = idx + 1, N = messages.size(); a < N; a++) {
                            MessageObject object = messages.get(a);
                            if (object.getId() > 0) {
                                maxVisibleId = object.getId();
                                break;
                            }
                        }
                    }
                }
            }
            currentPinnedMessageId = findClosest(pinnedMessageIds, forceNextPinnedMessageId != 0 ? forceNextPinnedMessageId : maxVisibleId, currentPinnedMessageIndex);
            if (!inMenuMode && !loadingPinnedMessagesList && !pinnedEndReached && !pinnedMessageIds.isEmpty() && currentPinnedMessageIndex[0] > pinnedMessageIds.size() - 2) {
                getMediaDataController().loadPinnedMessages(dialog_id, pinnedMessageIds.get(pinnedMessageIds.size() - 1), 0);
                loadingPinnedMessagesList = true;
            }
        }
        getMessagesController().addToPollsQueue(dialog_id, pollsToCheck);
        chatMessagesMetadataController.checkMessages(chatAdapter, maxAdapterPosition, minAdapterPosition, currentTime);
        if (videoPlayerContainer != null) {
            if (!foundTextureViewMessage) {
                MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
                if (messageObject != null) {
                    if (checkTextureViewPosition && messageObject.isVideo()) {
                        MediaController.getInstance().cleanupPlayer(true, true);
                    } else {
                        videoPlayerContainer.setTranslationY(-AndroidUtilities.roundPlayingMessageSize - 100);
                        fragmentView.invalidate();
                        if ((messageObject.isRoundVideo() || messageObject.isVideo()) && messageObject.eventId == 0 && checkTextureViewPosition && !chatListView.isFastScrollAnimationRunning()) {
                            MediaController.getInstance().setCurrentVideoVisible(false);
                        }
                    }
                }
            } else {
                MediaController.getInstance().setCurrentVideoVisible(true);
            }
        }
        if (minMessageChild != null) {
            MessageObject messageObject;
            if (minMessageChild instanceof ChatMessageCell) {
                messageObject = ((ChatMessageCell) minMessageChild).getMessageObject();
            } else {
                messageObject = ((ChatActionCell) minMessageChild).getMessageObject();
            }
            floatingDateView.setCustomDate(messageObject.messageOwner.date, chatMode == MODE_SCHEDULED, true);
        }
        currentFloatingDateOnScreen = false;
        currentFloatingTopIsNotMessage = !(minChild instanceof ChatMessageCell || minChild instanceof ChatActionCell);
        if (minDateChild != null) {
            boolean showFloatingView = false;
            if (minDateChild.getY() > clipTop || currentFloatingTopIsNotMessage) {
                if (minDateChild.getAlpha() != 1.0f) {
                    minDateChild.setAlpha(1.0f);
                }
                if (chatListView.getChildAdapterPosition(minDateChild) == chatAdapter.messagesStartRow + messages.size() - 1) {
                    if (minDateChild.getAlpha() != 1.0f) {
                        minDateChild.setAlpha(1.0f);
                    }
                    if (floatingDateAnimation != null) {
                        floatingDateAnimation.cancel();
                        floatingDateAnimation = null;
                    }
                    floatingDateView.setTag(null);
                    floatingDateView.setAlpha(0);
                    currentFloatingDateOnScreen = false;
                } else {
                    hideFloatingDateView(!currentFloatingTopIsNotMessage);
                }
            } else {
                if (minDateChild.getAlpha() != 0.0f) {
                    minDateChild.setAlpha(0.0f);
                }
                showFloatingView = true;
            }
            float offset = minDateChild.getY() + minDateChild.getMeasuredHeight() - clipTop;
            if (offset > floatingDateView.getMeasuredHeight() && offset < floatingDateView.getMeasuredHeight() * 2) {
                if (chatListView.getChildAdapterPosition(minDateChild) == chatAdapter.messagesStartRow + messages.size() - 1) {
                    showFloatingView = false;
                    if (minDateChild.getAlpha() != 1.0f) {
                        minDateChild.setAlpha(1.0f);
                    }
                    if (floatingDateAnimation != null) {
                        floatingDateAnimation.cancel();
                        floatingDateAnimation = null;
                    }
                    floatingDateView.setTag(null);
                    floatingDateView.setAlpha(0);
                } else {
                    floatingDateViewOffset = -floatingDateView.getMeasuredHeight() * 2 + offset;
                }
            } else {
                floatingDateViewOffset = 0;
            }
            if (showFloatingView) {
                if (floatingDateAnimation != null) {
                    floatingDateAnimation.cancel();
                    floatingDateAnimation = null;
                }
                if (floatingDateView.getTag() == null) {
                    floatingDateView.setTag(1);
                }
                if (floatingDateView.getAlpha() != 1.0f) {
                    floatingDateView.setAlpha(1.0f);
                }
                currentFloatingDateOnScreen = true;
            }
        } else {
            hideFloatingDateView(true);
            floatingDateViewOffset = 0;
        }
        if (isThreadChat()) {
            if (previousThreadMessageVisible != threadMessageVisible) {
                AndroidUtilities.runOnUIThread(() -> {
                    updatePinnedMessageView(openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150);
                });
            }
        } else {
            if (currentPinnedMessageId != 0) {
                MessageObject object = pinnedMessageObjects.get(currentPinnedMessageId);
                if (object == null) {
                    object = messagesDict[0].get(currentPinnedMessageId);
                }
                if (object == null) {
                    if (loadingPinnedMessages.indexOfKey(currentPinnedMessageId) < 0) {
                        loadingPinnedMessages.put(currentPinnedMessageId, true);
                        ArrayList<Integer> ids = new ArrayList<>();
                        ids.add(currentPinnedMessageId);
                        getMediaDataController().loadPinnedMessages(dialog_id, ChatObject.isChannel(currentChat) ? currentChat.id : 0, ids, true);
                    }
                    currentPinnedMessageId = previousPinnedMessageId;
                }
            } else if (previousPinnedMessageId != 0 && !pinnedMessageIds.isEmpty()) {
                currentPinnedMessageId = previousPinnedMessageId;
            }
            boolean animated = (fromPullingDownTransition && fragmentView.getVisibility() == View.VISIBLE) || (openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150);
            if (previousPinnedMessageId != currentPinnedMessageId) {
                int animateToNext;
                if (previousPinnedMessageId == 0) {
                    animateToNext = 0;
                } else if (previousPinnedMessageId > currentPinnedMessageId) {
                    animateToNext = 1;
                } else {
                    animateToNext = 2;
                }

                AndroidUtilities.runOnUIThread(() -> {
                    updatePinnedMessageView(animated, animateToNext);
                });
            } else {
                updatePinnedListButton(animated);
            }
        }
        if (floatingDateView != null) {
            floatingDateView.setTranslationY(chatListView.getTranslationY() + chatListViewPaddingTop + floatingDateViewOffset - AndroidUtilities.dp(4));
        }
        invalidateChatListViewTopPadding();
        if (!firstLoading && !paused && !inPreviewMode && chatMode == 0 && !getMessagesController().ignoreSetOnline) {
            int scheduledRead = 0;
            if ((maxPositiveUnreadId != Integer.MIN_VALUE || maxNegativeUnreadId != Integer.MAX_VALUE)) {
                int counterDecrement = 0;
                for (int a = 0; a < messages.size(); a++) {
                    MessageObject messageObject = messages.get(a);
                    int id = messageObject.getId();
                    if (maxPositiveUnreadId != Integer.MIN_VALUE) {
                        if (id > 0 && id <= maxPositiveUnreadId && (messageObject.messageOwner.from_scheduled && id > currentReadMaxId || messageObject.isUnread() && !messageObject.isOut())) {
                            if (messageObject.messageOwner.from_scheduled) {
                                scheduledRead++;
                            } else {
                                messageObject.setIsRead();
                            }
                            counterDecrement++;
                        }
                    }
                    if (maxNegativeUnreadId != Integer.MAX_VALUE) {
                        if (id < 0 && id >= maxNegativeUnreadId && messageObject.isUnread()) {
                            messageObject.setIsRead();
                            counterDecrement++;
                        }
                    }
                }
                if (forwardEndReached[0] && maxPositiveUnreadId == minMessageId[0] || maxNegativeUnreadId == minMessageId[0]) {
                    newUnreadMessageCount = 0;
                } else {
                    newUnreadMessageCount -= counterDecrement;
                    if (newUnreadMessageCount < 0) {
                        newUnreadMessageCount = 0;
                    }
                }
                if (inLayout) {
                    AndroidUtilities.runOnUIThread(this::inlineUpdate1);
                } else {
                    inlineUpdate1();
                }
                getMessagesController().markDialogAsRead(dialog_id, maxPositiveUnreadId, maxNegativeUnreadId, maxUnreadDate, false, threadId, counterDecrement, maxPositiveUnreadId == minMessageId[0] || maxNegativeUnreadId == minMessageId[0], scheduledRead);
                firstUnreadSent = true;
            } else if (!firstUnreadSent && currentEncryptedChat == null) {
                if (chatLayoutManager.findFirstVisibleItemPosition() == 0) {
                    newUnreadMessageCount = 0;
                    if (inLayout) {
                        AndroidUtilities.runOnUIThread(this::inlineUpdate2);
                    } else {
                        inlineUpdate2();
                    }
                    getMessagesController().markDialogAsRead(dialog_id, minMessageId[0], minMessageId[0], maxDate[0], false, threadId, 0, true, scheduledRead);
                    if (isTopic) {
                        getMessagesStorage().updateRepliesMaxReadId(replyOriginalChat.id, replyOriginalMessageId, Math.max(maxPositiveUnreadId, replyMaxReadId), 0, true);
                    }
                    firstUnreadSent = true;
                }
            }
            if (threadId != 0 && maxPositiveUnreadId > 0 && replyMaxReadId != maxPositiveUnreadId) {
                replyMaxReadId = maxPositiveUnreadId;
                getMessagesStorage().updateRepliesMaxReadId(replyOriginalChat.id, replyOriginalMessageId, replyMaxReadId, newUnreadMessageCount, true);
                if (!isTopic) {
                    getNotificationCenter().postNotificationName(NotificationCenter.commentsRead, replyOriginalChat.id, replyOriginalMessageId, replyMaxReadId);
                }
            }
        }
    }

    private void inlineUpdate1() {
        if (prevSetUnreadCount != newUnreadMessageCount) {
            prevSetUnreadCount = newUnreadMessageCount;
            pagedownButtonCounter.setCount(newUnreadMessageCount, openAnimationEnded);
        }
    }

    private void inlineUpdate2() {
        if (prevSetUnreadCount != newUnreadMessageCount) {
            prevSetUnreadCount = newUnreadMessageCount;
            pagedownButtonCounter.setCount(newUnreadMessageCount, true);
        }
    }

    private void toggleMute(boolean instant) {
        boolean muted = getMessagesController().isDialogMuted(dialog_id, getTopicId());
        if (!muted) {
            if (instant) {
                getNotificationsController().muteDialog(dialog_id, getTopicId(), true);
            } else {
                BottomSheet alert = AlertsCreator.createMuteAlert(this, dialog_id, getTopicId(), themeDelegate);
                alert.setCalcMandatoryInsets(isKeyboardVisible());
                showDialog(alert);
            }
        } else {
            getNotificationsController().muteDialog(dialog_id, getTopicId(), false);
            if (!instant) {
                BulletinFactory.createMuteBulletin(this, false, themeDelegate).show();
            }
        }
    }

    private int getScrollOffsetForMessage(MessageObject object) {
        return getScrollOffsetForMessage(getHeightForMessage(object));
    }
    private int getScrollOffsetForMessage(int messageHeight) {
        return (int) Math.max(-AndroidUtilities.dp(2), (chatListView.getMeasuredHeight() - blurredViewBottomOffset - chatListViewPaddingTop - messageHeight) / 2);
    }

    private int getHeightForMessage(MessageObject object) {
        if (getParentActivity() == null) {
            return 0;
        }
        if (dummyMessageCell == null) {
            dummyMessageCell = new ChatMessageCell(getParentActivity(), true, themeDelegate);
        }
        dummyMessageCell.isChat = currentChat != null || UserObject.isUserSelf(currentUser);
        dummyMessageCell.isBot = currentUser != null && currentUser.bot;
        dummyMessageCell.isMegagroup = ChatObject.isChannel(currentChat) && currentChat.megagroup;
        return dummyMessageCell.computeHeight(object, groupedMessagesMap.get(object.getGroupId()));
    }

    private void startMessageUnselect() {
        if (unselectRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(unselectRunnable);
        }
        unselectRunnable = () -> {
            highlightMessageId = Integer.MAX_VALUE;
            updateVisibleRows();
            unselectRunnable = null;
        };
        AndroidUtilities.runOnUIThread(unselectRunnable, 1000);
    }

    private void removeSelectedMessageHighlight() {
        if (unselectRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(unselectRunnable);
            unselectRunnable = null;
        }
        highlightMessageId = Integer.MAX_VALUE;
    }

    private AlertDialog progressDialog;
    private int nextScrollToMessageId;
    private int nextScrollFromMessageId;
    private boolean nextScrollSelect;
    private int nextScrollLoadIndex;
    private boolean nextScrollForce;
    private int nextScrollForcePinnedMessageId;

    public static final int PROGRESS_REPLY = 0;
    public static final int PROGRESS_LINK = 1;
    public static final int PROGRESS_INSTANT = 2;
    public static final int PROGRESS_BOT_BUTTON = 3;

    private int progressDialogAtMessageId;
    private int progressDialogAtMessageType;
    private CharacterStyle progressDialogLinkSpan;
    private String progressDialogBotButtonUrl;
    private Browser.Progress progressDialogCurrent;
    private void resetProgressDialogLoading() {
        progressDialogLinkSpan = null;
        progressDialogAtMessageId = 0;
        progressDialogAtMessageType = -1;
        progressDialogBotButtonUrl = null;
        progressDialogCurrent = null;

        setPagedownLoading(false, true);
    }

    public static final boolean SCROLL_DEBUG_DELAY = false;
    private boolean pinnedProgressIsShowing;
    Runnable updatePinnedProgressRunnable;

    public void scrollToMessageId(int id, int fromMessageId, boolean select, int loadIndex, boolean forceScroll, int forcePinnedMessageId) {
        scrollToMessageId(id, fromMessageId, select, loadIndex, forceScroll, forcePinnedMessageId, null);
    }

    public void scrollToMessageId(int id, int fromMessageId, boolean select, int loadIndex, boolean forceScroll, int forcePinnedMessageId, Runnable inCaseLoading) {
        if (id == 0 || NotificationCenter.getInstance(currentAccount).isAnimationInProgress() || getParentActivity() == null) {
            if (NotificationCenter.getInstance(currentAccount).isAnimationInProgress()) {
                nextScrollToMessageId = id;
                nextScrollFromMessageId = fromMessageId;
                nextScrollSelect = select;
                nextScrollLoadIndex = loadIndex;
                nextScrollForce = forceScroll;
                nextScrollForcePinnedMessageId = forcePinnedMessageId;
                NotificationCenter.getInstance(currentAccount).doOnIdle(() -> {
                    if (nextScrollToMessageId != 0) {
                        scrollToMessageId(nextScrollToMessageId, nextScrollFromMessageId, nextScrollSelect, nextScrollLoadIndex, nextScrollForce, nextScrollForcePinnedMessageId);
                        nextScrollToMessageId = 0;
                    }
                });
            }
            return;
        }

        forceNextPinnedMessageId = Math.abs(forcePinnedMessageId);
        forceScrollToFirst = forcePinnedMessageId > 0;
        wasManualScroll = true;
        MessageObject object = messagesDict[loadIndex].get(id);
        boolean query = false;
        int scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UNSET;
        int scrollFromIndex = 0;
        if (fromMessageId != 0) {
            boolean scrollDown = fromMessageId < id;
            if (isSecretChat()) {
                scrollDown = !scrollDown;
            }
            scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
        } else if (messages.size() > 0) {
            if (isThreadChat() && id == threadMessageId) {
                scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
            } else {
                int end = chatLayoutManager.findLastVisibleItemPosition();
                for (int i = chatLayoutManager.findFirstVisibleItemPosition(); i <= end; i++) {
                    if (i >= chatAdapter.messagesStartRow && i < chatAdapter.messagesEndRow) {
                        MessageObject messageObject = messages.get(i - chatAdapter.messagesStartRow);
                        if (messageObject.getId() == 0) {
                            continue;
                        }
                        scrollFromIndex = i - chatAdapter.messagesStartRow;
                        boolean scrollDown = messageObject.getId() < id;
                        if (isSecretChat()) {
                            scrollDown = !scrollDown;
                        }
                        scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                        break;
                    }
                }
            }
        }

        chatScrollHelper.setScrollDirection(scrollDirection);
        if (!SCROLL_DEBUG_DELAY && object != null) {
            MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(object.getGroupId());
            if (object.getGroupId() != 0 && groupedMessages != null) {
                MessageObject primary = groupedMessages.findPrimaryMessageObject();
                if (primary != null) {
                    object = primary;
                }
            }

            int index = messages.indexOf(object);
            if (index != -1) {
                if (scrollFromIndex > 0) {
                    scrollDirection = scrollFromIndex > index ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                    chatScrollHelper.setScrollDirection(scrollDirection);
                }
                removeSelectedMessageHighlight();
                if (select) {
                    highlightMessageId = id;
                }

                chatAdapter.updateRowsSafe();
                int position = chatAdapter.messagesStartRow + messages.indexOf(object);

                updateVisibleRows();
                boolean found = false;
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View view = chatListView.getChildAt(a);
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject != null && messageObject.getId() == object.getId()) {
                            found = true;
                            view.sendAccessibilityEvent(AccessibilityEvent.TYPE_VIEW_FOCUSED);
                        }
                    } else if (view instanceof ChatActionCell) {
                        ChatActionCell cell = (ChatActionCell) view;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject != null && messageObject.getId() == object.getId()) {
                            found = true;
                            view.sendAccessibilityEvent(AccessibilityEvent.TYPE_VIEW_FOCUSED);
                        }
                    }

                    if (found) {
                        int yOffset = getScrollOffsetForMessage(view.getHeight());
                        int scrollY = (int) (view.getTop() - chatListViewPaddingTop - yOffset);
                        int maxScrollOffset = chatListView.computeVerticalScrollRange() - chatListView.computeVerticalScrollOffset() - chatListView.computeVerticalScrollExtent();
                        if (maxScrollOffset < 0) {
                            maxScrollOffset = 0;
                        }
                        if (scrollY > maxScrollOffset) {
                            scrollY = maxScrollOffset;
                        }
                        if (scrollY != 0) {
                            scrollByTouch = false;
                            chatListView.smoothScrollBy(0, scrollY);
                            chatListView.setOverScrollMode(RecyclerListView.OVER_SCROLL_NEVER);
                        }
                        break;
                    }
                }
                if (!found) {
                    int yOffset = getScrollOffsetForMessage(object);
                    chatScrollHelperCallback.scrollTo = object;
                    chatScrollHelperCallback.lastBottom = false;
                    chatScrollHelperCallback.lastItemOffset = yOffset;
                    chatScrollHelperCallback.lastPadding = (int) chatListViewPaddingTop;
                    chatScrollHelper.setScrollDirection(scrollDirection);
                    chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = position, chatScrollHelperCallback.offset = yOffset, chatScrollHelperCallback.bottom = false, true);
                    canShowPagedownButton = true;
                    updatePagedownButtonVisibility(true);
                }
            } else {
                query = true;
            }
        } else {
            query = true;
        }

        if (query) {
            if (isThreadChat() && id == threadMessageId) {
                scrollToThreadMessage = true;
                id = 1;
            }
            if (progressDialog != null) {
                progressDialog.dismiss();
            }

            showPinnedProgress(forceNextPinnedMessageId != 0);

            if (inCaseLoading != null) {
                inCaseLoading.run();
            } else if (forceNextPinnedMessageId == 0) {
                progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
                progressDialog.setOnShowListener(dialogInterface -> showPinnedProgress(false));
                progressDialog.setOnCancelListener(postponedScrollCancelListener);
                progressDialog.showDelayed(400);
            }

            waitingForLoad.clear();
            removeSelectedMessageHighlight();
            scrollToMessagePosition = -10000;
            startLoadFromMessageId = id;
            showScrollToMessageError = !forceScroll;
            if (id == createUnreadMessageAfterId) {
                createUnreadMessageAfterIdLoading = true;
            }
            postponedScrollIsCanceled = false;
            waitingForLoad.add(lastLoadIndex);
            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            postponedScrollMinMessageId = minMessageId[0];
            postponedScrollMessageId = id;
            AndroidUtilities.runOnUIThread(() -> {
                getMessagesController().loadMessages(loadIndex == 0 ? dialog_id : mergeDialogId, 0, false, ((isThreadChat() && !isTopic) || AndroidUtilities.isTablet()) ? 30 : 20, startLoadFromMessageId, 0, true, 0, classGuid, 3, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            }, SCROLL_DEBUG_DELAY ? 7500 : 0);
        } else {
            View child = chatListView.getChildAt(0);
            if (child != null && child.getTop() <= 0) {
                showFloatingDateView(false);
            }
        }
        returnToMessageId = fromMessageId;
        returnToLoadIndex = loadIndex;
        needSelectFromMessageId = select;
    }

    private void showPinnedProgress(boolean show) {
        if (show) {
            if (updatePinnedProgressRunnable == null) {
                updatePinnedProgressRunnable = () -> {
                    pinnedProgressIsShowing = true;
                    updatePinnedListButton(true);
                };
                AndroidUtilities.runOnUIThread(updatePinnedProgressRunnable, 100);
            }
        } else {
            if (updatePinnedProgressRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(updatePinnedProgressRunnable);
            }
            updatePinnedProgressRunnable = null;
            pinnedProgressIsShowing = false;
            updatePinnedListButton(true);
        }
    }

    //是否显示跳转底部按钮
    private void updatePagedownButtonVisibility(boolean animated) {
        if (pagedownButton == null) {
            return;
        }
        boolean show = canShowPagedownButton && !textSelectionHelper.isSelectionMode() && !chatActivityEnterView.isRecordingAudioVideo();
        if (show) {
            if (animated && (openAnimationStartTime == 0 || SystemClock.elapsedRealtime() < openAnimationStartTime + 150)) {
                animated = false;
            }
            pagedownButtonShowedByScroll = false;
            if (pagedownButton.getTag() == null) {
                if (pagedownButtonAnimation != null) {
                    pagedownButtonAnimation.removeAllListeners();
                    pagedownButtonAnimation.cancel();
                    pagedownButtonAnimation = null;
                }
                pagedownButton.setTag(1);
                if (animated) {
                    pagedownButton.setVisibility(View.VISIBLE);
                    pagedownButtonAnimation = ValueAnimator.ofFloat(pagedownButtonEnterProgress, 1f);
                    pagedownButtonAnimation.addUpdateListener(valueAnimator -> {
                        pagedownButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                        contentView.invalidate();
                    });
                    pagedownButtonAnimation.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            pagedownButtonEnterProgress = 1f;
                            contentView.invalidate();
                        }
                    });
                    pagedownButtonAnimation.setDuration(200);
                    pagedownButtonAnimation.start();
                } else {
                    pagedownButtonEnterProgress = 1f;
                    contentView.invalidate();
                    pagedownButton.setVisibility(View.VISIBLE);
                }
            }
        } else {
            returnToMessageId = 0;
            newUnreadMessageCount = 0;
            if (pagedownButton.getTag() != null) {
                pagedownButton.setTag(null);
                if (pagedownButtonAnimation != null) {
                    pagedownButtonAnimation.removeAllListeners();
                    pagedownButtonAnimation.cancel();
                    pagedownButtonAnimation = null;
                }
                if (animated) {
                    pagedownButton.setVisibility(View.VISIBLE);
                    pagedownButtonAnimation = ValueAnimator.ofFloat(pagedownButtonEnterProgress, 0);
                    pagedownButtonAnimation.addUpdateListener(valueAnimator -> {
                        pagedownButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                        contentView.invalidate();
                    });
                    pagedownButtonAnimation.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            pagedownButtonEnterProgress = 0;
                            pagedownButton.setVisibility(View.INVISIBLE);
                            contentView.invalidate();
                        }
                    });
                    pagedownButtonAnimation.setDuration(200);
                    pagedownButtonAnimation.start();
                } else {
                    pagedownButtonEnterProgress = 0;
                    pagedownButton.setVisibility(View.INVISIBLE);
                }
            }
        }
    }

    private void showMentionDownButton(boolean show, boolean animated) {
        if (mentiondownButton == null) {
            return;
        }
        if (show) {
            if (mentiondownButton.getTag() == null) {
                if (mentiondownButtonAnimation != null) {
                    mentiondownButtonAnimation.removeAllListeners();
                    mentiondownButtonAnimation.cancel();
                    mentiondownButtonAnimation = null;
                }
                if (animated) {
                    mentiondownButton.setVisibility(View.VISIBLE);
                    mentiondownButton.setTag(1);
                    mentiondownButtonAnimation = ValueAnimator.ofFloat(mentionsButtonEnterProgress, 1f);
                    mentiondownButtonAnimation.addUpdateListener(valueAnimator -> {
                        mentionsButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                        contentView.invalidate();
                    });
                    mentiondownButtonAnimation.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            mentionsButtonEnterProgress = 1f;
                            contentView.invalidate();
                        }
                    });
                    mentiondownButtonAnimation.setDuration(200);
                    mentiondownButtonAnimation.start();
                } else {
                    mentionsButtonEnterProgress = 1f;
                    contentView.invalidate();
                }
            }
        } else {
            returnToMessageId = 0;
            if (mentiondownButton.getTag() != null) {
                mentiondownButton.setTag(null);
                if (mentiondownButtonAnimation != null) {
                    mentiondownButtonAnimation.removeAllListeners();
                    mentiondownButtonAnimation.cancel();
                    mentiondownButtonAnimation = null;
                }
                if (animated) {
                    mentiondownButtonAnimation = ValueAnimator.ofFloat(mentionsButtonEnterProgress, 0f);
                    mentiondownButtonAnimation.addUpdateListener(valueAnimator -> {
                        mentionsButtonEnterProgress = (float) valueAnimator.getAnimatedValue();
                        contentView.invalidate();
                    });
                    mentiondownButtonAnimation.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            mentionsButtonEnterProgress = 0f;
                            mentiondownButton.setVisibility(View.INVISIBLE);
                            contentView.invalidate();
                        }
                    });
                    mentiondownButtonAnimation.setDuration(200);
                    mentiondownButtonAnimation.start();
                } else {
                    mentionsButtonEnterProgress = 0f;
                    mentiondownButton.setVisibility(View.INVISIBLE);
                }
            }
        }
    }

    //聊天整体布局类
    public class ChatActivityFragmentView extends SizeNotifierFrameLayout {

        public ChatActivityFragmentView(Context context, INavigationLayout parentLayout) {
            super(context, parentLayout);
            adjustPanLayoutHelper = new AdjustPanLayoutHelper(this) {

                @Override
                protected void onTransitionStart(boolean keyboardVisible, int contentHeight) {
                    wasManualScroll = true;
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionStart(keyboardVisible, contentHeight);
                    }
                    if (mentionContainer != null) {
                        mentionContainer.onPanTransitionStart();
                    }
                    if (mediaBanTooltip != null) {
                        mediaBanTooltip.hide(false);
                    }
                }

                @Override
                protected void onTransitionEnd() {
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionEnd();
                    }
                    if (mentionContainer != null) {
                        mentionContainer.onPanTransitionEnd();
                    }
                    if (voiceHintTextView != null && voiceHintTextView.getVisibility() == View.VISIBLE) {
                        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), false);
                    }
                }

                @Override
                protected void onPanTranslationUpdate(float y, float progress, boolean keyboardVisible) {
                    if (getParentLayout() != null && getParentLayout().isPreviewOpenAnimationInProgress()) {
                        return;
                    }
                    contentPanTranslation = y;
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        setNonNoveTranslation(y);
                    } else {
                        actionBar.setTranslationY(y);
                        if (emptyViewContainer != null) {
                            emptyViewContainer.setTranslationY(y / 2);
                        }
                        progressView.setTranslationY(y / 2);
                        contentView.setBackgroundTranslation((int) y);
                        if (instantCameraView != null) {
                            instantCameraView.onPanTranslationUpdate(y);
                        }
                        if (blurredView != null) {
                            blurredView.drawable.onPanTranslationUpdate(y);
                        }
                        setFragmentPanTranslationOffset((int) y);
                        invalidateChatListViewTopPadding();
                        invalidateMessagesVisiblePart();
                    }
                    chatListView.invalidate();
                    updateBulletinLayout();
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionUpdate(y, progress, keyboardVisible);
                    }
                    if (mentionContainer != null) {
                        mentionContainer.onPanTransitionUpdate(y);
                    }
                    if (AndroidUtilities.isTablet() && getParentActivity() instanceof LaunchActivity) {
                        BaseFragment mainFragment = ((LaunchActivity)getParentActivity()).getActionBarLayout().getLastFragment();
                        if (mainFragment instanceof DialogsActivity) {
                            ((DialogsActivity)mainFragment).setPanTranslationOffset(y);
                        }
                    }
                    if (voiceHintTextView != null && voiceHintTextView.getVisibility() == View.VISIBLE) {
                        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), false);
                    }
                    if (fragmentContextView != null) {
                        fragmentContextView.onPanTranslationUpdate(y);
                    }
                }

                @Override
                protected boolean heightAnimationEnabled() {
                    INavigationLayout actionBarLayout = getParentLayout();
                    if (inPreviewMode || inBubbleMode || AndroidUtilities.isInMultiwindow || actionBarLayout == null || fixedKeyboardHeight > 0) {
                        return false;
                    }
                    if (System.currentTimeMillis() - activityResumeTime < 250) {
                        return false;
                    }
                    if ((ChatActivity.this == actionBarLayout.getLastFragment() && actionBarLayout.isTransitionAnimationInProgress()) || actionBarLayout.isPreviewOpenAnimationInProgress() || isPaused || !openAnimationEnded || (chatAttachAlert != null && chatAttachAlert.isShowing())) {
                        return false;
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getTrendingStickersAlert() != null && chatActivityEnterView.getTrendingStickersAlert().isShowing()) {
                        return false;
                    }
                    return true;
                }

                @Override
                protected int startOffset() {
                    int keyboardSize = getKeyboardHeight();
                    if (keyboardSize <= AndroidUtilities.dp(20) && chatActivityEnterView.isPopupShowing()) {
                        return chatActivityEnterView.getEmojiPadding();
                    }
                    return 0;
                }
            };
        }

        int inputFieldHeight = 0;
        int lastHeight;

        int lastWidth;

        ArrayList<ChatMessageCell> drawTimeAfter = new ArrayList<>();
        ArrayList<ChatMessageCell> drawNamesAfter = new ArrayList<>();
        ArrayList<ChatMessageCell> drawCaptionAfter = new ArrayList<>();

        Paint backgroundPaint;
        int backgroundColor;

        @Override
        protected void drawList(Canvas blurCanvas, boolean top) {
            float cilpTop = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4);

            for (int i = 0; i < chatListView.getChildCount(); i++) {
                View child = chatListView.getChildAt(i);
                if (top && child.getY() > cilpTop + AndroidUtilities.dp(40)) {
                    continue;
                }
                if (!top && child.getY() + child.getMeasuredHeight() < AndroidUtilities.dp(203)) {
                    continue;
                }

                blurCanvas.save();
                if (top) {
                    blurCanvas.translate(chatListView.getX() + child.getX(), chatListView.getY() + child.getY() - contentPanTranslation);
                } else {
                    blurCanvas.translate(chatListView.getX() + child.getX(), chatListView.getTop() + child.getY());
                }
                if (child instanceof ChatMessageCell) {
                    ChatMessageCell cell = (ChatMessageCell) child;
                    cell.drawForBlur = true;
                    if (cell.drawBackgroundInParent()) {
                        cell.drawBackgroundInternal(blurCanvas, true);
                    }
                    child.draw(blurCanvas);
                    if (cell.hasOutboundsContent()) {
                        ((ChatMessageCell) child).drawOutboundsContent(blurCanvas);
                    }
                    cell.drawForBlur = false;
                } else if (child instanceof ChatActionCell) {
                    child.draw(blurCanvas);
                    ((ChatActionCell) child).drawOutboundsContent(blurCanvas);
                } else {
                    child.draw(blurCanvas);
                }
                blurCanvas.restore();
            }
        }

        @Override
        protected int getScrollOffset() {
            return chatListView.computeVerticalScrollOffset();
        }

        @Override
        protected float getBottomOffset() {
            return chatListView.getBottom();
        }

        @Override
        protected float getListTranslationY() {
            return chatListView.getTranslationY();
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            adjustPanLayoutHelper.onAttach();
            chatActivityEnterView.setAdjustPanLayoutHelper(adjustPanLayoutHelper);
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            if (messageObject != null && (messageObject.isRoundVideo() || messageObject.isVideo()) && messageObject.eventId == 0 && messageObject.getDialogId() == dialog_id) {
                MediaController.getInstance().setTextureView(createTextureView(false), aspectRatioFrameLayout, videoPlayerContainer, true);
            }
            if (pullingDownDrawable != null) {
                pullingDownDrawable.onAttach();
            }
            emojiAnimationsOverlay.onAttachedToWindow();
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            adjustPanLayoutHelper.onDetach();
            if (pullingDownDrawable != null) {
                pullingDownDrawable.onDetach();
                pullingDownDrawable = null;
            }
            emojiAnimationsOverlay.onDetachedFromWindow();
            AndroidUtilities.runOnUIThread(() -> {
                ReactionsEffectOverlay.removeCurrent(true);
            });
        }

        private float x, y;
        private long pressTime;

        @Override
        public boolean dispatchTouchEvent(MotionEvent ev) {
            float expandY;
            if (AndroidUtilities.isInMultiwindow || isInBubbleMode()) {
                expandY = chatActivityEnterView.getEmojiView() != null ? chatActivityEnterView.getEmojiView().getY() : chatActivityEnterView.getY();
            } else {
                expandY = chatActivityEnterView.getY();
            }
            if ((scrimView != null && scrimView != actionBar.getBackButton()) || chatActivityEnterView != null && chatActivityEnterView.isStickersExpanded() && ev.getY() < expandY) {
                return false;
            }

            lastTouchY = ev.getY();
            TextSelectionHelper.TextSelectionOverlay selectionOverlay = textSelectionHelper.getOverlayView(getContext());
            ev.offsetLocation(-selectionOverlay.getX(), -selectionOverlay.getY());
            if (textSelectionHelper.isSelectionMode() && textSelectionHelper.getOverlayView(getContext()).onTouchEvent(ev)) {
                return true;
            } else {
                ev.offsetLocation(selectionOverlay.getX(), selectionOverlay.getY());
            }

            if (selectionOverlay.checkOnTap(ev)) {
                ev.setAction(MotionEvent.ACTION_CANCEL);
            }

            if (ev.getAction() == MotionEvent.ACTION_DOWN && textSelectionHelper.isSelectionMode() && (ev.getY() < chatListView.getTop() || ev.getY() > chatListView.getBottom())) {
                ev.offsetLocation(-selectionOverlay.getX(), -selectionOverlay.getY());
                if (textSelectionHelper.getOverlayView(getContext()).onTouchEvent(ev)) {
                    ev.offsetLocation(selectionOverlay.getX(), selectionOverlay.getY());
                    return super.dispatchTouchEvent(ev);
                } else {
                    return true;
                }
            }

            if (pinchToZoomHelper.isInOverlayMode()) {
                return pinchToZoomHelper.onTouchEvent(ev);
            }

            if (AvatarPreviewer.hasVisibleInstance()) {
                AvatarPreviewer.getInstance().onTouchEvent(ev);
                return true;
            }

            boolean r = false;
            if (isInPreviewMode() && allowExpandPreviewByClick) {
                if (ev.getAction() == MotionEvent.ACTION_DOWN) {
                    boolean pressedOnPageDownButtons = false, pressedOnAvatar = false;
                    int[] off = new int[2];
                    getLocationInWindow(off);
                    int[] pos = new int[2];
                    if (pagedownButton != null) {
                        pagedownButton.getLocationInWindow(pos);
                        AndroidUtilities.rectTmp2.set(pos[0] - off[0], pos[1] - off[1], pos[0] - off[0] + pagedownButton.getMeasuredWidth(), pos[1] - off[1] + pagedownButton.getMeasuredHeight());
                        if (AndroidUtilities.rectTmp2.contains((int) ev.getX(), (int) ev.getY())) {
                            pressedOnPageDownButtons = true;
                        }
                    }
                    if (avatarContainer != null && avatarContainer.getAvatarImageView() != null) {
                        BackupImageView avatar = avatarContainer.getAvatarImageView();
                        avatar.getLocationInWindow(pos);
                        AndroidUtilities.rectTmp2.set(pos[0] - off[0], pos[1] - off[1], pos[0] - off[0] + avatar.getMeasuredWidth(), pos[1] - off[1] + avatar.getMeasuredHeight());
                        if (AndroidUtilities.rectTmp2.contains((int) ev.getX(), (int) ev.getY())) {
                            pressedOnAvatar = true;
                        }
                    }
                    if (!pressedOnPageDownButtons && mentiondownButton != null) {
                        mentiondownButton.getLocationInWindow(pos);
                        AndroidUtilities.rectTmp2.set(pos[0] - off[0], pos[1] - off[1], pos[0] - off[0] + mentiondownButton.getMeasuredWidth(), pos[1] - off[1] + mentiondownButton.getMeasuredHeight());
                        if (AndroidUtilities.rectTmp2.contains((int) ev.getX(), (int) ev.getY())) {
                            pressedOnPageDownButtons = true;
                        }
                    }
                    if (!pressedOnPageDownButtons && !pressedOnAvatar) {
                        x = ev.getX();
                        y = ev.getY();
                        pressTime = SystemClock.elapsedRealtime();
                        r = true;
                    } else {
                        pressTime = -1;
                    }
                } else if (ev.getAction() == MotionEvent.ACTION_UP) {
                    if (MathUtils.distance(x, y, ev.getX(), ev.getY()) < AndroidUtilities.dp(6) && SystemClock.elapsedRealtime() - pressTime <= ViewConfiguration.getTapTimeout()) {
                        parentLayout.expandPreviewFragment();
                        ev.setAction(MotionEvent.ACTION_CANCEL);
                    }
                    pressTime = -1;
                } else if (ev.getAction() == MotionEvent.ACTION_CANCEL) {
                    pressTime = -1;
                }
            }

            return super.dispatchTouchEvent(ev) || r;
        }

        @Override
        protected void onDraw(Canvas canvas) {
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) != null) {
                return;
            }
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) == null && (instantCameraView != null && instantCameraView.blurFullyDrawing() || (blurredView != null && blurredView.fullyDrawing() && blurredView.getTag() != null))) {
                return;
            }
            super.onDraw(canvas);
        }

        @Override
        protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
            if ((scrimView != null || messageEnterTransitionContainer.isRunning()) && (child == pagedownButton || child == mentiondownButton || child == floatingDateView || child == fireworksOverlay || child == reactionsMentiondownButton || child == gifHintTextView || child == emojiHintTextView || child == undoView || child == topUndoView)) {
                return false;
            }
            if (child == fragmentContextView && fragmentContextView.isCallStyle()) {
                return true;
            }
            if (child == undoView && PhotoViewer.getInstance().isVisible()) {
                return true;
            }
            if (toPullingDownTransition && child == chatListView) {
                return true;
            }
            if (switchingFromTopics && child == actionBar) {
                return true;
            }
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) != null) {
                boolean needBlur;
                if (((int) getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND)) == BlurBehindDrawable.STATIC_CONTENT) {
                    needBlur = child == actionBar || child == fragmentContextView || child == pinnedMessageView;
                } else {
                    needBlur = child == chatListView || child == chatActivityEnterView || chatActivityEnterView.isPopupView(child);
                }
                if (!needBlur) {
                    return false;
                }
            } else if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) == null && (instantCameraView != null && instantCameraView.blurFullyDrawing() || (blurredView != null && blurredView.fullyDrawing() && blurredView.getTag() != null))) {
                boolean needBlur = child == actionBar || child == chatListView || child == pinnedMessageView || child == fragmentContextView;
                if (needBlur) {
                    return false;
                }
            }
            boolean result;
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            boolean isRoundVideo = false;
            boolean isVideo = messageObject != null && messageObject.eventId == 0 && ((isRoundVideo = messageObject.isRoundVideo()) || messageObject.isVideo());
            if (child == videoPlayerContainer) {
                canvas.save();
                float transitionOffset = 0;
                if (pullingDownAnimateProgress != 0) {
                    transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                }
                canvas.translate(0, -pullingDownOffset - transitionOffset);
                if (messageObject != null && messageObject.type == MessageObject.TYPE_ROUND_VIDEO) {
                    if (Theme.chat_roundVideoShadow != null && aspectRatioFrameLayout.isDrawingReady()) {
                        int x = (int) child.getX() - AndroidUtilities.dp(3);
                        int y = (int) child.getY() - AndroidUtilities.dp(2);
                        canvas.save();
                        canvas.scale(videoPlayerContainer.getScaleX(), videoPlayerContainer.getScaleY(), child.getX(), child.getY());
                        Theme.chat_roundVideoShadow.setAlpha(255);
                        Theme.chat_roundVideoShadow.setBounds(x, y, x + AndroidUtilities.roundPlayingMessageSize + AndroidUtilities.dp(6), y + AndroidUtilities.roundPlayingMessageSize + AndroidUtilities.dp(6));
                        Theme.chat_roundVideoShadow.draw(canvas);
                        canvas.restore();
                    }
                    result = super.drawChild(canvas, child, drawingTime);
                } else {
                    if (child.getTag() == null) {
                        float oldTranslation = child.getTranslationY();
                        child.setTranslationY(-AndroidUtilities.dp(1000));
                        result = super.drawChild(canvas, child, drawingTime);
                        child.setTranslationY(oldTranslation);
                    } else {
                        result = false;
                    }
                }
                canvas.restore();
            } else {
                result = super.drawChild(canvas, child, drawingTime);
                if (isVideo && child == chatListView && messageObject.type != MessageObject.TYPE_ROUND_VIDEO && videoPlayerContainer != null && videoPlayerContainer.getTag() != null) {
                    canvas.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                    }
                    canvas.translate(0, -pullingDownOffset - transitionOffset + pullingBottomOffset);
                    super.drawChild(canvas, videoPlayerContainer, drawingTime);
                    if (drawLaterRoundProgressCell != null) {
                        canvas.save();
                        canvas.translate(drawLaterRoundProgressCell.getX(), drawLaterRoundProgressCell.getTop() + chatListView.getY());
                        if (isRoundVideo) {
                            drawLaterRoundProgressCell.drawRoundProgress(canvas);
                            invalidate();
                            drawLaterRoundProgressCell.invalidate();
                        } else {
                            drawLaterRoundProgressCell.drawOverlays(canvas);
                            if (drawLaterRoundProgressCell.needDrawTime()) {
                                drawLaterRoundProgressCell.drawTime(canvas, drawLaterRoundProgressCell.getAlpha(), true);
                            }
                        }
                        canvas.restore();
                    }
                    canvas.restore();
                }
            }
            if (child == actionBar && parentLayout != null) {
                parentLayout.drawHeaderShadow(canvas, actionBar.getVisibility() == VISIBLE ? (int) actionBar.getTranslationY() + actionBar.getMeasuredHeight() + (inPreviewMode && Build.VERSION.SDK_INT >= 21 ? AndroidUtilities.statusBarHeight : 0) : 0);
            }
            return result;
        }

        @Override
        protected boolean isActionBarVisible() {
            if(actionBar.isHide()) return false;
            return actionBar.getVisibility() == VISIBLE;
        }

        private void drawChildElement(Canvas canvas, float listTop, ChatMessageCell cell, int type) {
            canvas.save();
            float canvasOffsetX = chatListView.getLeft() + cell.getLeft();
            float canvasOffsetY = chatListView.getY() + cell.getY();
            float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;
            canvas.clipRect(chatListView.getLeft(), listTop, chatListView.getRight(), chatListView.getY() + chatListView.getMeasuredHeight() - blurredViewBottomOffset);
            canvas.translate(canvasOffsetX, canvasOffsetY);
            cell.setInvalidatesParent(true);
            if (type == 0) {
                cell.drawTime(canvas, alpha, true);
            } else if (type == 1) {
                cell.drawNamesLayout(canvas, alpha);
            } else {
                cell.drawCaptionLayout(canvas, cell.getCurrentPosition() != null && (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0, alpha);
            }
            cell.setInvalidatesParent(false);
            canvas.restore();
        }

        @Override
        protected void dispatchDraw(Canvas canvas) {
            chatActivityEnterView.checkAnimation();
            updateChatListViewTopPadding();
            if (invalidateMessagesVisiblePart || (chatListItemAnimator != null && chatListItemAnimator.isRunning())) {
                invalidateMessagesVisiblePart = false;
                updateMessagesVisiblePart(false);
            }
            updateTextureViewPosition(false, false);
            updatePagedownButtonsPosition();
            int restoreToCount = -1;
            if (switchingFromTopics) {
                restoreToCount = canvas.saveLayerAlpha(0, actionBar.getBottom(), getMeasuredWidth(), getMeasuredHeight(), (int) (255 * switchingFromTopicsProgress), Canvas.ALL_SAVE_FLAG);
                float s = 0.8f + 0.2f * switchingFromTopicsProgress;
                canvas.scale(s, s, getMeasuredWidth() / 2f, getMeasuredHeight() / 2f);
            }
            super.dispatchDraw(canvas);
            if (fragmentContextView != null && fragmentContextView.isCallStyle()) {
                float alpha = (blurredView != null && blurredView.getVisibility() == View.VISIBLE) ? 1f - blurredView.getAlpha() : 1f;
                if (alpha > 0) {
                    if (alpha == 1f) {
                        canvas.save();
                    } else {
                        canvas.saveLayerAlpha(fragmentContextView.getX(), fragmentContextView.getY() - AndroidUtilities.dp(30), fragmentContextView.getX() + fragmentContextView.getMeasuredWidth(), fragmentContextView.getY() + fragmentContextView.getMeasuredHeight(), (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                    }
                    canvas.translate(fragmentContextView.getX(), fragmentContextView.getY());
                    fragmentContextView.setDrawOverlay(true);
                    fragmentContextView.draw(canvas);
                    fragmentContextView.setDrawOverlay(false);
                    canvas.restore();
                }
                fragmentView.invalidate();
            }
            if (chatActivityEnterView != null) {
                if (chatActivityEnterView.panelAnimationInProgress() && chatActivityEnterView.getEmojiPadding() < bottomPanelTranslationY) {
                    int color = getThemedColor(Theme.key_chat_emojiPanelBackground);
                    if (backgroundPaint == null) {
                        backgroundPaint = new Paint();
                    }
                    if (backgroundColor != color) {
                        backgroundPaint.setColor(backgroundColor = color);
                    }
                    int offset = (int) (bottomPanelTranslationY  - chatActivityEnterView.getEmojiPadding()) + 3;
                    canvas.drawRect(0, getMeasuredHeight() - offset, getMeasuredWidth(), getMeasuredHeight(), backgroundPaint);
                    setFragmentPanTranslationOffset(chatActivityEnterView.getEmojiPadding());
                }
            }
            for (int a = 0, N = animateSendingViews.size(); a < N; a++) {
                ChatMessageCell cell = animateSendingViews.get(a);
                MessageObject.SendAnimationData data = cell.getMessageObject().sendAnimationData;
                if (data != null) {
                    canvas.save();
                    ImageReceiver imageReceiver = cell.getPhotoImage();
                    canvas.translate(data.currentX, data.currentY);
                    canvas.scale(data.currentScale, data.currentScale);
                    canvas.translate(-imageReceiver.getCenterX(), -imageReceiver.getCenterY());
                    cell.setTimeAlpha(data.timeAlpha);
                    animateSendingViews.get(a).draw(canvas);
                    canvas.restore();
                }
            }
            if (scrimViewReaction == null || scrimView == null) {
                scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (scrimView != null ? scrimViewAlpha : 1f)));
                canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
            }
            if (scrimView != null) {
                if (scrimView == reactionsMentiondownButton || scrimView == mentiondownButton) {
                    if (scrimViewAlpha < 1f) {
                        scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                    }
                } else if (scrimView instanceof ImageView) {
                    int c = canvas.save();
                    if (scrimViewAlpha < 1f) {
                        canvas.saveLayerAlpha(scrimView.getLeft(), scrimView.getTop(), scrimView.getRight(), scrimView.getBottom(), (int) (255 * scrimViewAlpha), Canvas.ALL_SAVE_FLAG);
                    }
                    canvas.translate(scrimView.getLeft(), scrimView.getTop());
                    if (scrimView == actionBar.getBackButton()) {
                        int r = Math.max(scrimView.getMeasuredWidth(), scrimView.getMeasuredHeight()) / 2;
                        canvas.drawCircle(r, r, r * 0.7f, actionBarBackgroundPaint);
                    }
                    scrimView.draw(canvas);
                    canvas.restoreToCount(c);

                    if (scrimViewAlpha < 1f) {
                        scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                    }
                } else {
                    float listTop = chatListView.getY() + chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4);
                    MessageObject.GroupedMessages scrimGroup;
                    if (scrimView instanceof ChatMessageCell) {
                        scrimGroup = ((ChatMessageCell) scrimView).getCurrentMessagesGroup();
                    } else {
                        scrimGroup = null;
                    }
                    boolean groupedBackgroundWasDraw = false;
                    int count = chatListView.getChildCount();
                    for (int num = 0; num < count; num++) {
                        View child = chatListView.getChildAt(num);
                        MessageObject.GroupedMessages group;
                        MessageObject.GroupedMessagePosition position;
                        ChatMessageCell cell;
                        ChatActionCell actionCell;
                        if (child instanceof ChatMessageCell) {
                            cell = (ChatMessageCell) child;
                            actionCell = null;
                            group = cell.getCurrentMessagesGroup();
                            position = cell.getCurrentPosition();
                        } else {
                            position = null;
                            group = null;
                            cell = null;
                            actionCell = child instanceof ChatActionCell ? ((ChatActionCell) child) : null;
                        }
                        if (child != scrimView && (scrimGroup == null || scrimGroup != group) || child.getAlpha() == 0f) {
                            continue;
                        }
                        if (!groupedBackgroundWasDraw && cell != null && scrimGroup != null && scrimGroup.transitionParams.cell != null) {
                            float x = scrimGroup.transitionParams.cell.getNonAnimationTranslationX(true);

                            float l = (scrimGroup.transitionParams.left + x + scrimGroup.transitionParams.offsetLeft);
                            float t = (scrimGroup.transitionParams.top + scrimGroup.transitionParams.offsetTop);
                            float r = (scrimGroup.transitionParams.right + x + scrimGroup.transitionParams.offsetRight);
                            float b = (scrimGroup.transitionParams.bottom + scrimGroup.transitionParams.offsetBottom);

                            if (!scrimGroup.transitionParams.backgroundChangeBounds) {
                                t += scrimGroup.transitionParams.cell.getTranslationY();
                                b += scrimGroup.transitionParams.cell.getTranslationY();
                            }

                            if (t < chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20)) {
                                t = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20);
                            }

                            if (b > chatListView.getMeasuredHeight() + AndroidUtilities.dp(20)) {
                                b = chatListView.getMeasuredHeight() + AndroidUtilities.dp(20);
                            }

                            boolean selected = true;
                            for (int a = 0, N = scrimGroup.messages.size(); a < N; a++) {
                                MessageObject object = scrimGroup.messages.get(a);
                                int index = object.getDialogId() == dialog_id ? 0 : 1;
                                if (selectedMessagesIds[index].indexOfKey(object.getId()) < 0) {
                                    selected = false;
                                    break;
                                }
                            }

                            canvas.save();
                            canvas.clipRect(0, listTop + (mentionContainer != null ? mentionContainer.clipTop() : 0), getMeasuredWidth(), chatListView.getY() + chatListView.getMeasuredHeight() - blurredViewBottomOffset - (mentionContainer != null ? mentionContainer.clipBottom() : 0));
                            canvas.translate(0, chatListView.getY());
                            scrimGroup.transitionParams.cell.drawBackground(canvas, (int) l, (int) t, (int) r, (int) b, scrimGroup.transitionParams.pinnedTop, scrimGroup.transitionParams.pinnedBotton, selected, contentView.getKeyboardHeight());
                            canvas.restore();
                            groupedBackgroundWasDraw = true;
                        }

                        if (cell != null && cell.getPhotoImage().isAnimationRunning()) {
                            invalidate();
                        }

                        float viewClipLeft = chatListView.getLeft();
                        float viewClipTop = listTop;
                        float viewClipRight = chatListView.getRight();
                        float viewClipBottom = chatListView.getY() + chatListView.getMeasuredHeight() - blurredViewBottomOffset;

                        if (mentionContainer != null) {
                            viewClipTop += mentionContainer.clipTop();
                            viewClipBottom -= mentionContainer.clipBottom();
                        }

                        if (cell == null || !cell.getTransitionParams().animateBackgroundBoundsInner) {
                            viewClipLeft = Math.max(viewClipLeft, chatListView.getLeft() + child.getX());
                            viewClipTop = Math.max(viewClipTop, chatListView.getY() + child.getY());
                            viewClipRight = Math.min(viewClipRight, chatListView.getLeft() + child.getX() + child.getMeasuredWidth());
                            viewClipBottom = Math.min(viewClipBottom, chatListView.getY() + child.getY() + child.getMeasuredHeight());
                        }

                        if (viewClipTop < viewClipBottom) {
                            if (child.getAlpha() != 1f) {
                                canvas.saveLayerAlpha(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom, (int) (255 * child.getAlpha()), Canvas.ALL_SAVE_FLAG);
                            } else {
                                canvas.save();
                            }
                            if (cell != null) {
                                cell.setInvalidatesParent(true);
                                cell.setScrimReaction(scrimViewReaction);
                            }
                            canvas.clipRect(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom);
                            canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY());
                            if (cell != null && scrimGroup == null && cell.drawBackgroundInParent()) {
                                cell.drawBackgroundInternal(canvas, true);
                            }
                            child.draw(canvas);
                            if (cell != null && cell.hasOutboundsContent()) {
                                cell.drawOutboundsContent(canvas);
                            }
                            if (actionCell != null) {
                                actionCell.drawOutboundsContent(canvas);
                            }

                            canvas.restore();

                            if (cell != null) {
                                cell.setInvalidatesParent(false);
                                cell.setScrimReaction(null);
                            }
                        }

                        if (position != null || (cell != null && cell.getTransitionParams().animateBackgroundBoundsInner)) {
                            if (position == null || position.last || position.minX == 0 && position.minY == 0) {
                                if (position == null || position.last) {
                                    drawTimeAfter.add(cell);
                                }
                                if (position == null || (position.minX == 0 && position.minY == 0 && cell.hasNameLayout())) {
                                    drawNamesAfter.add(cell);
                                }
                            }
                            if (position == null || (position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0) {
                                drawCaptionAfter.add(cell);
                            }
                        }
                        if (scrimViewReaction != null && cell != null) {
                            scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * scrimViewAlpha));
                            canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);

                            if (viewClipTop < viewClipBottom) {
                                float alpha = child.getAlpha() * scrimViewAlpha;
                                if (alpha < 1f) {
                                    canvas.saveLayerAlpha(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom, (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                                } else {
                                    canvas.save();
                                }
                                canvas.clipRect(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom);
                                canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY());
                                cell.drawScrimReaction(canvas, scrimViewReaction);
                                canvas.restore();
                            }
                        }
                    }

                    int size = drawTimeAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            drawChildElement(canvas, listTop, drawTimeAfter.get(a), 0);
                        }
                        drawTimeAfter.clear();
                    }
                    size = drawNamesAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            drawChildElement(canvas, listTop, drawNamesAfter.get(a), 1);
                        }
                        drawNamesAfter.clear();
                    }
                    size = drawCaptionAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            ChatMessageCell cell = drawCaptionAfter.get(a);
                            if (cell.getCurrentPosition() == null && !cell.getTransitionParams().animateBackgroundBoundsInner) {
                                continue;
                            }
                            drawChildElement(canvas, listTop, cell, 2);
                        }
                        drawCaptionAfter.clear();
                    }
                }

                if (scrimViewReaction == null && scrimViewAlpha < 1f) {
                    scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                    canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                }
            }

            if (scrimView != null || messageEnterTransitionContainer.isRunning()) {
                if (mentionContainer == null || mentionContainer.getVisibility() != View.VISIBLE) {
                    if (pagedownButton != null && pagedownButton.getTag() != null) {
                        super.drawChild(canvas, pagedownButton, SystemClock.uptimeMillis());
                    }
                    if (mentiondownButton != null && mentiondownButton.getTag() != null) {
                        super.drawChild(canvas, mentiondownButton, SystemClock.uptimeMillis());
                    }
                    if (reactionsMentiondownButton != null && reactionsMentiondownButton.getTag() != null) {
                        super.drawChild(canvas, reactionsMentiondownButton, SystemClock.uptimeMillis());
                    }
                }
                if (floatingDateView != null && floatingDateView.getTag() != null) {
                    super.drawChild(canvas, floatingDateView, SystemClock.uptimeMillis());
                }
                if (fireworksOverlay != null) {
                    super.drawChild(canvas, fireworksOverlay, SystemClock.uptimeMillis());
                }
                if (gifHintTextView != null) {
                    super.drawChild(canvas, gifHintTextView, SystemClock.uptimeMillis());
                }
                if (emojiHintTextView != null) {
                    super.drawChild(canvas, emojiHintTextView, SystemClock.uptimeMillis());
                }
                if (undoView != null && undoView.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, undoView, SystemClock.uptimeMillis());
                }
                if (topUndoView != null && topUndoView.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, topUndoView, SystemClock.uptimeMillis());
                }
            }

            if (fixedKeyboardHeight > 0 && keyboardHeight < AndroidUtilities.dp(20)) {
                int color = getThemedColor(Theme.key_windowBackgroundWhite);
                if (backgroundPaint == null) {
                    backgroundPaint = new Paint();
                }
                if (backgroundColor != color) {
                    backgroundPaint.setColor(backgroundColor = color);
                }
                canvas.drawRect(0,getMeasuredHeight() - fixedKeyboardHeight, getMeasuredWidth(), getMeasuredHeight(), backgroundPaint);
            }
            if (pullingDownDrawable != null && pullingDownDrawable.needDrawBottomPanel()) {
                int top, bottom;
                if (chatActivityEnterView != null && chatActivityEnterView.getVisibility() == View.VISIBLE) {
                    top = chatActivityEnterView.getTop() + AndroidUtilities.dp2(2);
                    bottom = chatActivityEnterView.getBottom();
                } else {
                    top = bottomOverlayChat.getTop() + AndroidUtilities.dp2(2);
                    bottom = bottomOverlayChat.getBottom();
                }
                top -= (int) ((pullingDownAnimateToActivity == null ? 0 : pullingDownAnimateToActivity.pullingBottomOffset) * pullingDownAnimateProgress);
                pullingDownDrawable.drawBottomPanel(canvas, top, bottom, getMeasuredWidth());
            }
            if (pullingDownAnimateToActivity != null) {
                canvas.saveLayerAlpha(0, 0, getMeasuredWidth(), getMeasuredHeight(), (int) (255 * pullingDownAnimateProgress), Canvas.ALL_SAVE_FLAG);
                pullingDownAnimateToActivity.fragmentView.draw(canvas);
                canvas.restore();
            }

            emojiAnimationsOverlay.draw(canvas);

            if (restoreToCount >= 0) {
                canvas.restore();
            }
            if (switchingFromTopics) {
                canvas.save();
                canvas.translate(actionBar.getX(), actionBar.getY());
                canvas.saveLayerAlpha(0, 0, actionBar.getWidth(), actionBar.getHeight(), (int) (255 * switchingFromTopicsProgress), Canvas.ALL_SAVE_FLAG);
                actionBar.draw(canvas);
                canvas.restore();
                canvas.restore();
            }
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int allHeight;
            int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
            int heightSize = allHeight = View.MeasureSpec.getSize(heightMeasureSpec);

            if (lastWidth != widthSize) {
                globalIgnoreLayout = true;
                lastWidth = widthMeasureSpec;
                if (!inPreviewMode && currentUser != null && currentUser.self) {
                    SimpleTextView textView = avatarContainer.getTitleTextView();
                    int textWidth = (int) textView.getPaint().measureText(textView.getText(), 0, textView.getText().length());
                    if (widthSize - AndroidUtilities.dp(96 + 56) > textWidth + AndroidUtilities.dp(10)) {
                        showSearchAsIcon = !showAudioCallAsIcon;
                    } else {
                        showSearchAsIcon = false;
                    }
                } else {
                    showSearchAsIcon = false;
                }
                if (showSearchAsIcon || showAudioCallAsIcon || BuildVars.IS_CHAT_AIR) {
                    if (avatarContainer != null && avatarContainer.getLayoutParams() != null) {
                        ((ViewGroup.MarginLayoutParams) avatarContainer.getLayoutParams()).rightMargin = AndroidUtilities.dp(96);
                    }
                } else {
                    if (avatarContainer != null && avatarContainer.getLayoutParams() != null) {
                        ((ViewGroup.MarginLayoutParams) avatarContainer.getLayoutParams()).rightMargin = AndroidUtilities.dp(40);
                    }
                }
                if (showSearchAsIcon) {
                    if (!actionBar.isSearchFieldVisible() && searchIconItem != null) {
                        searchIconItem.setVisibility(View.VISIBLE);
                    }
                    if (headerItem != null) {
                        headerItem.hideSubItem(search);
                    }
                } else {
                    if (headerItem != null) {
                        headerItem.showSubItem(search);
                    }
                    if (searchIconItem != null) {
                        searchIconItem.setVisibility(View.GONE);
                    }
                }
                if (!actionBar.isSearchFieldVisible() && audioCallIconItem != null) {
                    audioCallIconItem.setVisibility((showAudioCallAsIcon && !showSearchAsIcon) ? View.VISIBLE : View.GONE);
                }
                if (headerItem != null) {
                    TLRPC.UserFull userInfo = getCurrentUserInfo();
                    if (showAudioCallAsIcon) {
                        headerItem.hideSubItem(call);
                    } else if (userInfo != null && userInfo.phone_calls_available) {
                        headerItem.showSubItem(call, true);
                    }
                }
                globalIgnoreLayout = false;
            }

            setMeasuredDimension(widthSize, heightSize);
            heightSize -= getPaddingTop();

            measureChildWithMargins(actionBar, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int actionBarHeight = actionBar.getMeasuredHeight();
            if (actionBar.getVisibility() == VISIBLE) {
                heightSize -= actionBarHeight;
            }
            int keyboardHeightOld = keyboardHeight + chatEmojiViewPadding;
            boolean keyboardVisibleOld = keyboardHeight + chatEmojiViewPadding >= AndroidUtilities.dp(20);
            if (lastHeight != allHeight) {
                measureKeyboardHeight();
            }
            int keyboardSize = getKeyboardHeight();
            if (fixedKeyboardHeight > 0 && keyboardSize <= AndroidUtilities.dp(20)) {
                chatEmojiViewPadding = fixedKeyboardHeight;
            } else {
                if (keyboardSize <= AndroidUtilities.dp(20)) {
                    chatEmojiViewPadding = chatActivityEnterView.isPopupShowing() ? chatActivityEnterView.getEmojiPadding() : 0;
                } else {
                    chatEmojiViewPadding = 0;
                }
            }
            setEmojiKeyboardHeight(chatEmojiViewPadding);

            boolean keyboardVisible = keyboardHeight + chatEmojiViewPadding >= AndroidUtilities.dp(20);
            boolean waitingChatListItemAnimator = false;
            if (MediaController.getInstance().getPlayingMessageObject() != null && MediaController.getInstance().getPlayingMessageObject().isRoundVideo() && keyboardVisibleOld != keyboardVisible) {
                for (int i = 0; i < chatListView.getChildCount(); i++) {
                    View child = chatListView.getChildAt(i);
                    if (child instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) child;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject.isRoundVideo() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                            int p = chatListView.getChildAdapterPosition(child);
                            if (p >= 0) {
                                chatLayoutManager.scrollToPositionWithOffset(p, (int) ((chatListView.getMeasuredHeight() - chatListViewPaddingTop - blurredViewBottomOffset + (keyboardHeight + chatEmojiViewPadding - keyboardHeightOld) - (keyboardVisible ? AndroidUtilities.roundMessageSize : AndroidUtilities.roundPlayingMessageSize)) / 2), false);
                                chatAdapter.notifyItemChanged(p);
                                adjustPanLayoutHelper.delayAnimation();
                                waitingChatListItemAnimator = true;
                                break;
                            }
                        }
                    }
                }
            }

            if (!waitingChatListItemAnimator) {
                chatActivityEnterView.runEmojiPanelAnimation();
            }

            int childCount = getChildCount();
            measureChildWithMargins(chatActivityEnterView, widthMeasureSpec, 0, heightMeasureSpec, 0);

            int listViewTopHeight;
            if (inPreviewMode) {
                inputFieldHeight = 0;
                listViewTopHeight = 0;
            } else {
                inputFieldHeight = chatActivityEnterView.getMeasuredHeight();
                listViewTopHeight = AndroidUtilities.dp(49);
            }

            blurredViewTopOffset = 0;
            blurredViewBottomOffset = 0;
            if (SharedConfig.chatBlurEnabled()) {
                blurredViewTopOffset = actionBarHeight;
                blurredViewBottomOffset = AndroidUtilities.dp(203);
            }
            for (int i = 0; i < childCount; i++) {
                View child = getChildAt(i);

                if (child == null || child.getVisibility() == GONE || child == chatActivityEnterView || child == actionBar) {
                    continue;
                }
                if (child == backgroundView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == blurredView) {
                    int h = allHeight;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        h += keyboardSize;
                    }
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == chatListView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int h = heightSize - listViewTopHeight - (inPreviewMode && Build.VERSION.SDK_INT >= 21 ? AndroidUtilities.statusBarHeight : 0) + blurredViewTopOffset + blurredViewBottomOffset;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        h += keyboardSize;
                    }
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(Math.max(AndroidUtilities.dp(10), h), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == progressView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(Math.max(AndroidUtilities.dp(10), heightSize - inputFieldHeight - (inPreviewMode && Build.VERSION.SDK_INT >= 21 ? AndroidUtilities.statusBarHeight : 0) + AndroidUtilities.dp(2 + (chatActivityEnterView.isTopViewVisible() ? 48 : 0))), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == instantCameraView || child == overlayView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight - inputFieldHeight - chatEmojiViewPadding + AndroidUtilities.dp(3), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == emptyViewContainer) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == messagesSearchListView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight - actionBarHeight - AndroidUtilities.dp(48), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (chatActivityEnterView.isPopupView(child)) {
                    if (inBubbleMode) {
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(heightSize - inputFieldHeight + actionBarHeight + getPaddingTop(), View.MeasureSpec.EXACTLY));
                    } else if (AndroidUtilities.isInMultiwindow) {
                        if (AndroidUtilities.isTablet()) {
                            child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(Math.min(AndroidUtilities.dp(320), heightSize - inputFieldHeight + actionBarHeight - AndroidUtilities.statusBarHeight + getPaddingTop()), View.MeasureSpec.EXACTLY));
                        } else {
                            child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(heightSize - inputFieldHeight + actionBarHeight - AndroidUtilities.statusBarHeight + getPaddingTop(), View.MeasureSpec.EXACTLY));
                        }
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(child.getLayoutParams().height, View.MeasureSpec.EXACTLY));
                    }
                } else if (child == mentionContainer) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) mentionContainer.getLayoutParams();
                    if (mentionContainer.getAdapter().isBannedInline()) {
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(heightSize, View.MeasureSpec.AT_MOST));
                    } else {
                        int height;
                        mentionContainer.setIgnoreLayout(true);
                        LinearLayoutManager layoutManager = mentionContainer.getCurrentLayoutManager();
                        if (layoutManager instanceof ExtendedGridLayoutManager) {
                            int size = ((ExtendedGridLayoutManager) layoutManager).getRowsCount(widthSize);
                            int maxHeight = size * 102;
                            if (mentionContainer.getAdapter().isBotContext()) {
                                if (mentionContainer.getAdapter().getBotContextSwitch() != null || mentionContainer.getAdapter().getBotWebViewSwitch() != null) {
                                    maxHeight += 34;
                                }
                            }
                            height = heightSize - chatActivityEnterView.getMeasuredHeight() + (maxHeight != 0 ? AndroidUtilities.dp(2) : 0);
                            int padding = Math.max(0, height - AndroidUtilities.dp(Math.min(maxHeight, 68 * 1.8f)));
                        } else {
                            int size = mentionContainer.getAdapter().getLastItemCount();
                            int maxHeight = 0;
                            if (mentionContainer.getAdapter().isBotContext()) {
                                if (mentionContainer.getAdapter().getBotContextSwitch() != null || mentionContainer.getAdapter().getBotWebViewSwitch() != null) {
                                    maxHeight += 36;
                                    size -= 1;
                                }
                                maxHeight += size * 68;
                            } else {
                                maxHeight += size * 36;
                            }
                            height = heightSize - chatActivityEnterView.getMeasuredHeight() + (maxHeight != 0 ? AndroidUtilities.dp(2) : 0);
                        }

                        layoutParams.height = height;
                        layoutParams.topMargin = 0;

                        mentionContainer.setIgnoreLayout(false);
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(layoutParams.height, View.MeasureSpec.EXACTLY));
                    }
                    mentionContainer.setTranslationY(chatActivityEnterView.getAnimatedTop());
                } else if (child == textSelectionHelper.getOverlayView(getContext())) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int h = heightSize + blurredViewTopOffset;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        h += keyboardSize;
                        textSelectionHelper.setKeyboardSize(keyboardSize);
                    } else {
                        textSelectionHelper.setKeyboardSize(0);
                    }
                    child.measure(contentWidthSpec, View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY));
                } else if (child == forwardingPreviewView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int h = allHeight - AndroidUtilities.statusBarHeight;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        h += keyboardSize;
                    }
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else {
                    measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                }
            }
            if (fixPaddingsInLayout) {
                globalIgnoreLayout = true;
                invalidateChatListViewTopPadding();
                invalidateMessagesVisiblePart();
                fixPaddingsInLayout = false;
                chatListView.measure(View.MeasureSpec.makeMeasureSpec(chatListView.getMeasuredWidth(), View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(chatListView.getMeasuredHeight(), View.MeasureSpec.EXACTLY));
                globalIgnoreLayout = false;
            }
            if (scrollToPositionOnRecreate != -1) {
                final int scrollTo = scrollToPositionOnRecreate;
                AndroidUtilities.runOnUIThread(() -> chatLayoutManager.scrollToPositionWithOffset(scrollTo, scrollToOffsetOnRecreate));
                scrollToPositionOnRecreate = -1;
            }

            updateBulletinLayout();

            lastHeight = allHeight;
        }

        @Override
        public void requestLayout() {
            if (globalIgnoreLayout) {
                return;
            }
            super.requestLayout();
        }

        @Override
        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            final int count = getChildCount();
            int keyboardSize = getKeyboardHeight();
            int paddingBottom;

            if (fixedKeyboardHeight > 0 && keyboardSize <= AndroidUtilities.dp(20)) {
                paddingBottom = fixedKeyboardHeight;
            } else {
                paddingBottom = keyboardSize <= AndroidUtilities.dp(20) && !AndroidUtilities.isInMultiwindow && !inBubbleMode ? chatActivityEnterView.getEmojiPadding() : 0;
            }

            for (int i = 0; i < count; i++) {
                final View child = getChildAt(i);
                if (child == null || child.getVisibility() == GONE) {
                    continue;
                }
                final FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams) child.getLayoutParams();

                final int width = child.getMeasuredWidth();
                final int height = child.getMeasuredHeight();

                int childLeft;
                int childTop;

                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = Gravity.TOP | Gravity.LEFT;
                }

                final int absoluteGravity = gravity & Gravity.HORIZONTAL_GRAVITY_MASK;
                final int verticalGravity = gravity & Gravity.VERTICAL_GRAVITY_MASK;

                switch (absoluteGravity & Gravity.HORIZONTAL_GRAVITY_MASK) {
                    case Gravity.CENTER_HORIZONTAL:
                        childLeft = (r - l - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    case Gravity.RIGHT:
                        childLeft = r - width - lp.rightMargin;
                        break;
                    case Gravity.LEFT:
                    default:
                        childLeft = lp.leftMargin;
                }

                switch (verticalGravity) {
                    case Gravity.TOP:
                        childTop = lp.topMargin + getPaddingTop();
                        if (child != actionBar && actionBar.getVisibility() == VISIBLE) {
                            childTop += actionBar.getMeasuredHeight();
                            if (inPreviewMode && Build.VERSION.SDK_INT >= 21) {
                                childTop += AndroidUtilities.statusBarHeight;
                            }
                        }
                        break;
                    case Gravity.CENTER_VERTICAL:
                        childTop = ((b - paddingBottom) - t - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    case Gravity.BOTTOM:
                        childTop = ((b - paddingBottom) - t) - height - lp.bottomMargin;
                        break;
                    default:
                        childTop = lp.topMargin;
                }

                if (child == blurredView || child == backgroundView) {
                    childTop = 0;
                } else if (child instanceof HintView || child instanceof ChecksHintView) {
                    childTop = 0;
                } else if (child == mentionContainer) {
                    childTop -= chatActivityEnterView.getMeasuredHeight() - AndroidUtilities.dp(2);
                    mentionContainer.setTranslationY(chatActivityEnterView.getAnimatedTop());
                } else if (child == pagedownButton || child == mentiondownButton || child == reactionsMentiondownButton) {
                    if (!inPreviewMode) {
                        childTop -= chatActivityEnterView.getMeasuredHeight();
                    }
                } else if (child == emptyViewContainer) {
                    childTop -= inputFieldHeight / 2 - (actionBar.getVisibility() == VISIBLE ? actionBar.getMeasuredHeight() / 2 : 0);
                } else if (chatActivityEnterView.isPopupView(child)) {
                    if (AndroidUtilities.isInMultiwindow || inBubbleMode) {
                        childTop = chatActivityEnterView.getTop() - child.getMeasuredHeight() + AndroidUtilities.dp(1);
                    } else {
                        childTop = chatActivityEnterView.getBottom();
                    }
                } else if (child == gifHintTextView || child == voiceHintTextView || child == mediaBanTooltip || child == emojiHintTextView) {
                    childTop -= inputFieldHeight;
                } else if (child == chatListView || child == floatingDateView || child == infoTopView) {
                    childTop -= blurredViewTopOffset;
                    if (!inPreviewMode) {
                        childTop -= (inputFieldHeight - AndroidUtilities.dp(51));
                    }
                    childTop -= paddingBottom;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        childTop -= keyboardSize;
                    }
                } else if (child == progressView) {
                    if (chatActivityEnterView.isTopViewVisible()) {
                        childTop -= AndroidUtilities.dp(48);
                    }
                } else if (child == actionBar) {
                    if (inPreviewMode && Build.VERSION.SDK_INT >= 21) {
                        childTop += AndroidUtilities.statusBarHeight;
                    }
                    childTop -= getPaddingTop();
                } else if (child == videoPlayerContainer) {
                    childTop = actionBar.getMeasuredHeight();
                    childTop -= paddingBottom;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        childTop -= keyboardSize;
                    }
                } else if (child == instantCameraView || child == overlayView || child == animatingImageView) {
                    childTop = 0;
                } else if (child == textSelectionHelper.getOverlayView(getContext())) {
                    childTop -= paddingBottom;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0) {
                        childTop -= keyboardSize;
                    }
                    childTop -= blurredViewTopOffset;
                } else if (chatActivityEnterView != null && child == chatActivityEnterView.botCommandsMenuContainer) {
                    childTop -= inputFieldHeight;
                } else if (child == forwardingPreviewView) {
                    childTop = AndroidUtilities.statusBarHeight;
                }
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
            }

            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
            updateTextureViewPosition(false, false);

            if (!scrollingChatListView) {
                checkAutoDownloadMessages(false);
            }
            notifyHeightChanged();
        }

        private void setNonNoveTranslation(float y) {
            contentView.setTranslationY(y);
            actionBar.setTranslationY(0);
            emptyViewContainer.setTranslationY(0);
            progressView.setTranslationY(0);
            contentPanTranslation = 0;
            contentView.setBackgroundTranslation(0);
            if (instantCameraView != null) {
                instantCameraView.onPanTranslationUpdate(0);
            }
            if (blurredView != null) {
                blurredView.drawable.onPanTranslationUpdate(0);
            }
            setFragmentPanTranslationOffset(0);
            invalidateChatListViewTopPadding();
        }

        @Override
        public void setPadding(int left, int top, int right, int bottom) {
            contentPaddingTop = top;
            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == KeyEvent.KEYCODE_BACK && event.getAction() == 1 && forwardingPreviewView != null && forwardingPreviewView.isShowing()) {
                forwardingPreviewView.dismiss(true);
                return true;
            }
            return super.dispatchKeyEvent(event);
        }

        protected Drawable getNewDrawable() {
            Drawable drawable = themeDelegate.getWallpaperDrawable();
            return drawable != null ? drawable : super.getNewDrawable();
        }
    };

    private void updateSecretStatus() {
        if (bottomOverlay == null) {
            return;
        }
        boolean hideKeyboard = false;
        if (currentChat != null && !ChatObject.canSendMessages(currentChat) && !ChatObject.canSendAnyMedia(currentChat) && !currentChat.gigagroup && (!ChatObject.isChannel(currentChat) || currentChat.megagroup)) {
            if (currentChat.default_banned_rights != null && currentChat.default_banned_rights.send_messages) {
                bottomOverlayText.setText(LocaleController.getString("GlobalSendMessageRestricted", R.string.GlobalSendMessageRestricted));
            } else if (AndroidUtilities.isBannedForever(currentChat.banned_rights)) {
                bottomOverlayText.setText(LocaleController.getString("SendMessageRestrictedForever", R.string.SendMessageRestrictedForever));
            } else {
                bottomOverlayText.setText(LocaleController.formatString("SendMessageRestricted", R.string.SendMessageRestricted, LocaleController.formatDateForBan(currentChat.banned_rights.until_date)));
            }
            bottomOverlay.setVisibility(View.VISIBLE);
            if (mentionListAnimation != null) {
                mentionListAnimation.cancel();
                mentionListAnimation = null;
            }
            mentionContainer.setVisibility(View.GONE);
            mentionContainer.setTag(null);
            updateMessageListAccessibilityVisibility();
            hideKeyboard = true;
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        } else {
            createEmptyView();
            if (currentEncryptedChat == null || bigEmptyView == null) {
                bottomOverlay.setVisibility(View.INVISIBLE);
                if (suggestEmojiPanel != null && chatActivityEnterView != null && chatActivityEnterView.hasText()) {
                    suggestEmojiPanel.fireUpdate();
                }
                return;
            }
            if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatRequested) {
                bottomOverlayText.setText(LocaleController.getString("EncryptionProcessing", R.string.EncryptionProcessing));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatWaiting) {
                bottomOverlayText.setText(AndroidUtilities.replaceTags(LocaleController.formatString("AwaitingEncryption", R.string.AwaitingEncryption, "<b>" + currentUser.first_name + "</b>")));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatDiscarded) {
                bottomOverlayText.setText(LocaleController.getString("EncryptionRejected", R.string.EncryptionRejected));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                chatActivityEnterView.setFieldText("");
                getMediaDataController().cleanDraft(dialog_id, threadMessageId, false);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChat) {
                bottomOverlay.setVisibility(View.INVISIBLE);
                if (!inPreviewMode) {
                    chatActivityEnterView.setVisibility(View.VISIBLE);
                }
            }
            checkRaiseSensors();
            checkActionBarMenu(false);
        }
        if (inPreviewMode) {
            bottomOverlay.setVisibility(View.INVISIBLE);
        }
        if (hideKeyboard) {
            chatActivityEnterView.hidePopup(false);
            if (getParentActivity() != null) {
                AndroidUtilities.hideKeyboard(getParentActivity().getCurrentFocus());
            }
        }
    }

    @Override
    public void onRequestPermissionsResultFragment(int requestCode, String[] permissions, int[] grantResults) {
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        }
        if (requestCode == BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE && chatAttachAlert != null) {
            chatAttachAlert.getPhotoLayout().checkStorage();
        } else if ((requestCode == BasePermissionsActivity.REQUEST_CODE_ATTACH_CONTACT || requestCode == 30) && chatAttachAlert != null) {
            chatAttachAlert.onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        } else if ((requestCode == 17 || requestCode == 18) && chatAttachAlert != null) {
            chatAttachAlert.getPhotoLayout().checkCamera(grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED);
            chatAttachAlert.getPhotoLayout().checkStorage();
        } else if (requestCode == 21) {
            if (getParentActivity() == null) {
                return;
            }
            if (grantResults != null && grantResults.length != 0 && grantResults[0] != PackageManager.PERMISSION_GRANTED) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                builder.setTitle(LocaleController.getString("AppName", R.string.AppName));
                builder.setMessage(LocaleController.getString("PermissionNoAudioVideoWithHint", R.string.PermissionNoAudioVideoWithHint));
                builder.setNegativeButton(LocaleController.getString("PermissionOpenSettings", R.string.PermissionOpenSettings), (dialog, which) -> {
                    try {
                        Intent intent = new Intent(android.provider.Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
                        intent.setData(Uri.parse("package:" + ApplicationLoader.applicationContext.getPackageName()));
                        getParentActivity().startActivity(intent);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                });
                builder.setPositiveButton(LocaleController.getString("OK", R.string.OK), null);
                builder.show();
            }
        } else if (requestCode == 19 && grantResults != null && grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            processSelectedAttach(attach_photo);
        } else if (requestCode == BasePermissionsActivity.REQUEST_CODE_OPEN_CAMERA && grantResults != null && grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            processSelectedAttach(attach_video);
        } else if ((requestCode == 101 || requestCode == 102) && currentUser != null || requestCode == 103 && currentChat != null) {
            boolean allGranted = true;
            for (int a = 0; a < grantResults.length; a++) {
                if (grantResults[a] != PackageManager.PERMISSION_GRANTED) {
                    allGranted = false;
                    break;
                }
            }
            if (grantResults.length > 0 && allGranted) {
                if (requestCode == 103) {
                    VoIPHelper.startCall(currentChat, null, null, createGroupCall, getParentActivity(), ChatActivity.this, getAccountInstance());
                } else {
                    VoIPHelper.startCall(currentUser, requestCode == 102, userInfo != null && userInfo.video_calls_available, getParentActivity(), getMessagesController().getUserFull(currentUser.id), getAccountInstance());
                }
            } else {
                VoIPHelper.permissionDenied(getParentActivity(), null, requestCode);
            }
        }
    }

    private void checkActionBarMenu(boolean animated) {
        if (currentEncryptedChat != null && !(currentEncryptedChat instanceof TLRPC.TL_encryptedChat) ||
                currentChat != null && (chatMode != 0 || threadMessageId != 0 || chatInfo == null || chatInfo.ttl_period == 0) ||
                currentUser != null && (UserObject.isDeleted(currentUser) || currentEncryptedChat == null && (userInfo == null || userInfo.ttl_period == 0))) {
            if (timeItem2 != null) {
                timeItem2.setVisibility(View.GONE);
            }
            if (avatarContainer != null) {
                avatarContainer.hideTimeItem(animated);
            }
        } else {
            if (timeItem2 != null) {
                timeItem2.setVisibility(View.VISIBLE);
            }
            if (avatarContainer != null) {
                avatarContainer.showTimeItem(animated);
            }
        }
        if (viewAsTopics != null) {
            viewAsTopics.setVisibility(currentChat != null && currentChat.forum ? View.VISIBLE : View.GONE);
        }
        if (avatarContainer != null) {
            if (currentEncryptedChat != null) {
                avatarContainer.setTime(currentEncryptedChat.ttl, animated);
            } else if (userInfo != null) {
                avatarContainer.setTime(userInfo.ttl_period, animated);
            } else if (chatInfo != null) {
                avatarContainer.setTime(chatInfo.ttl_period, animated);
            }
        }
        if (clearHistoryItem != null && chatInfo != null) {
            boolean visible = chatInfo.can_delete_channel || !ChatObject.isChannel(currentChat) || currentChat.megagroup && !ChatObject.isPublic(currentChat);
            clearHistoryItem.setVisibility(visible ? View.VISIBLE : View.GONE);
        }
        checkAndUpdateAvatar();
    }

    //获得当前聊天类型
    private int getMessageType(MessageObject messageObject) {
        //未知的聊天类型
        if (messageObject == null) {
            return -1;
        }
        if (currentEncryptedChat == null) {
            if (messageObject.isEditing()) {
                return -1;
            } else if (messageObject.getId() <= 0 && messageObject.isOut()) {
                //发送失败，Id为负值为本地生成，网络获取为正
                if (messageObject.isSendError()) {
                    if (!messageObject.isMediaEmpty()) {
                        //普通聊天类型发送失败
                        return 0;
                    } else {
                        //媒体聊天类型发送失败
                        return 20;
                    }
                } else {
                    return -1;
                }
            } else {
                if (messageObject.isAnimatedEmoji()) {
                    //动画聊天类型
                    return 2;
                } else if (messageObject.type == 6) {
                    return -1;
                } else if (messageObject.type == 10 || messageObject.type == MessageObject.TYPE_ACTION_PHOTO || messageObject.type == MessageObject.TYPE_SUGGEST_PHOTO) {
                    //日期、图片、建议图片聊天类型
                    if (messageObject.getId() == 0) {
                        return -1;
                    }
                    return 1;
                } else {
                    if (messageObject.isVoice()) {
                        //音频聊天类型
                        return 2;
                    } else if (messageObject.isSticker() || messageObject.isAnimatedSticker()) {
                        //贴纸聊天类型
                        TLRPC.InputStickerSet inputStickerSet = messageObject.getInputStickerSet();
                        if (inputStickerSet instanceof TLRPC.TL_inputStickerSetID) {
                            if (!getMediaDataController().isStickerPackInstalled(inputStickerSet.id)) {
                                return 7;
                            }
                        } else if (inputStickerSet instanceof TLRPC.TL_inputStickerSetShortName) {
                            if (!getMediaDataController().isStickerPackInstalled(inputStickerSet.short_name)) {
                                return 7;
                            }
                        }
                        return 9;
                    } else if (!messageObject.isRoundVideo() && (messageObject.messageOwner.media instanceof TLRPC.TL_messageMediaPhoto || messageObject.getDocument() != null || messageObject.isMusic() || messageObject.isVideo())) {
                        boolean canSave = false;
                        if (!TextUtils.isEmpty(messageObject.messageOwner.attachPath)) {
                            File f = new File(messageObject.messageOwner.attachPath);
                            if (f.exists()) {
                                canSave = true;
                            }
                        }
                        if (!canSave) {
                            if (messageObject.mediaExists) {
                                canSave = true;
                            }
                        }
                        if (canSave) {
                            if (messageObject.getDocument() != null && !messageObject.isMusic()) {
                                String mime = messageObject.getDocument().mime_type;
                                if (mime != null) {
                                    if (messageObject.getDocumentName().toLowerCase().endsWith("attheme")) {
                                        //主题文档聊天类型
                                        return 10;
                                    } else if (mime.endsWith("/xml")) {
                                        //文档聊天类型
                                        return 5;
                                    } else if (!messageObject.isNewGif() && mime.endsWith("/mp4") || mime.endsWith("/png") || mime.endsWith("/jpg") || mime.endsWith("/jpeg")) {
                                        //图片、视频聊天类型
                                        return 6;
                                    }
                                }
                            }
                            //多媒体通用聊天类型
                            return 4;
                        }
                    } else if (messageObject.type == MessageObject.TYPE_CONTACT) {
                        //联系人聊天类型
                        return 8;
                    } else if (messageObject.isMediaEmpty()) {
                        //最基本的聊天类型，空媒体聊天类型
                        return 3;
                    }
                    //普通聊天类型
                    return 2;
                }
            }
        } else {
            //加密聊天
            if (messageObject.isSending()) {
                return -1;
            }
            if (messageObject.isAnimatedEmoji()) {
                return 2;
            } else if (messageObject.type == 6) {
                return -1;
            } else if (messageObject.isSendError()) {
                if (!messageObject.isMediaEmpty()) {
                    return 0;
                } else {
                    return 20;
                }
            } else if (messageObject.type == 10 || messageObject.type == MessageObject.TYPE_ACTION_PHOTO) {
                if (messageObject.getId() == 0 || messageObject.isSending()) {
                    return -1;
                } else {
                    return 1;
                }
            } else {
                if (messageObject.isVoice()) {
                    return 2;
                } else if (!messageObject.isAnimatedEmoji() && (messageObject.isSticker() || messageObject.isAnimatedSticker())) {
                    TLRPC.InputStickerSet inputStickerSet = messageObject.getInputStickerSet();
                    if (inputStickerSet instanceof TLRPC.TL_inputStickerSetShortName) {
                        if (!getMediaDataController().isStickerPackInstalled(inputStickerSet.short_name)) {
                            return 7;
                        }
                    }
                } else if (!messageObject.isRoundVideo() && (messageObject.messageOwner.media instanceof TLRPC.TL_messageMediaPhoto || messageObject.getDocument() != null || messageObject.isMusic() || messageObject.isVideo())) {
                    boolean canSave = false;
                    if (!TextUtils.isEmpty(messageObject.messageOwner.attachPath)) {
                        File f = new File(messageObject.messageOwner.attachPath);
                        if (f.exists()) {
                            canSave = true;
                        }
                    }
                    if (!canSave) {
                        File f = FileLoader.getInstance(currentAccount).getPathToMessage(messageObject.messageOwner);
                        if (f.exists()) {
                            canSave = true;
                        }
                    }
                    if (canSave) {
                        if (messageObject.getDocument() != null) {
                            String mime = messageObject.getDocument().mime_type;
                            if (mime != null && mime.endsWith("text/xml")) {
                                return 5;
                            }
                        }
                        if (messageObject.messageOwner.ttl <= 0) {
                            return 4;
                        }
                    }
                } else if (messageObject.type == MessageObject.TYPE_CONTACT) {
                    return 8;
                } else if (messageObject.isMediaEmpty()) {
                    return 3;
                }
                return 2;
            }
        }
    }

    private void addToSelectedMessages(MessageObject messageObject, boolean outside) {
        addToSelectedMessages(messageObject, outside, true);
    }

    //添加选中聊天内容
    private void addToSelectedMessages(MessageObject messageObject, boolean outside, boolean last) {
        int prevCantForwardCount = cantForwardMessagesCount;
        if (messageObject != null) {
            if (threadMessageObjects != null && threadMessageObjects.contains(messageObject)) {
                return;
            }
            int index = messageObject.getDialogId() == dialog_id ? 0 : 1;
            if (outside && messageObject.getGroupId() != 0) {
                boolean hasUnselected = false;
                MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(messageObject.getGroupId());
                if (groupedMessages != null) {
                    int lastNum = 0;
                    for (int a = 0; a < groupedMessages.messages.size(); a++) {
                        MessageObject message = groupedMessages.messages.get(a);
                        if (selectedMessagesIds[index].indexOfKey(message.getId()) < 0) {
                            hasUnselected = true;
                            lastNum = a;
                        }
                    }

                    for (int a = 0; a < groupedMessages.messages.size(); a++) {
                        MessageObject message = groupedMessages.messages.get(a);
                        if (hasUnselected) {
                            if (selectedMessagesIds[index].indexOfKey(message.getId()) < 0) {
                                addToSelectedMessages(message, false, a == lastNum);
                            }
                        } else {
                            addToSelectedMessages(message, false, a == groupedMessages.messages.size() - 1);
                        }

                        if (!TextUtils.isEmpty(message.caption)) {
                            showTextSelectionHint(messageObject);
                        }
                    }
                }
                return;
            }
            if (selectedMessagesIds[index].indexOfKey(messageObject.getId()) >= 0) {
                selectedMessagesIds[index].remove(messageObject.getId());
                if (reportType < 0) {
                    if ((messageObject.type == MessageObject.TYPE_TEXT || messageObject.isAnimatedEmoji() || messageObject.caption != null) && !(messageObject.messageOwner != null && messageObject.messageOwner.noforwards)) {
                        selectedMessagesCanCopyIds[index].remove(messageObject.getId());
                    }
                    if (!messageObject.isAnimatedEmoji() && (messageObject.isSticker() || messageObject.isAnimatedSticker()) && MessageObject.isStickerHasSet(messageObject.getDocument())) {
                        selectedMessagesCanStarIds[index].remove(messageObject.getId());
                    }
                    if (messageObject.canEditMessage(currentChat)) {
                        canEditMessagesCount--;
                    }
                    if (!messageObject.canDeleteMessage(chatMode == MODE_SCHEDULED, currentChat)) {
                        cantDeleteMessagesCount--;
                    }
                    boolean noforwards = getMessagesController().isChatNoForwards(currentChat);
                    if (chatMode == MODE_SCHEDULED || !messageObject.canForwardMessage() || noforwards) {
                        cantForwardMessagesCount--;
                    } else {
                        canForwardMessagesCount--;
                    }
                    if (messageObject.isMusic() && !noforwards) {
                        canSaveMusicCount--;
                    } else if (messageObject.isDocument() && !noforwards) {
                        canSaveDocumentsCount--;
                    } else {
                        cantSaveMessagesCount--;
                    }
                }
            } else {
                if (selectedMessagesIds[0].size() + selectedMessagesIds[1].size() >= 100) {
                    AndroidUtilities.shakeView(selectedMessagesCountTextView);
                    Vibrator vibrator = (Vibrator) ApplicationLoader.applicationContext.getSystemService(Context.VIBRATOR_SERVICE);
                    if (vibrator != null) {
                        vibrator.vibrate(200);
                    }
                    return;
                }
                selectedMessagesIds[index].put(messageObject.getId(), messageObject);
                if (reportType < 0) {
                    if ((messageObject.type == MessageObject.TYPE_TEXT || messageObject.isAnimatedEmoji() || messageObject.caption != null) && !(messageObject.messageOwner != null && messageObject.messageOwner.noforwards)) {
                        selectedMessagesCanCopyIds[index].put(messageObject.getId(), messageObject);
                    }
                    if (!messageObject.isAnimatedEmoji() && (messageObject.isSticker() || messageObject.isAnimatedSticker()) && MessageObject.isStickerHasSet(messageObject.getDocument())) {
                        selectedMessagesCanStarIds[index].put(messageObject.getId(), messageObject);
                    }
                    if (messageObject.canEditMessage(currentChat)) {
                        canEditMessagesCount++;
                    }
                    if (!messageObject.canDeleteMessage(chatMode == MODE_SCHEDULED, currentChat)) {
                        cantDeleteMessagesCount++;
                    }
                    boolean noforwards = getMessagesController().isChatNoForwards(currentChat);
                    if (chatMode == MODE_SCHEDULED || !messageObject.canForwardMessage() || noforwards) {
                        cantForwardMessagesCount++;
                    } else {
                        canForwardMessagesCount++;
                    }
                    if (messageObject.isMusic() && !noforwards) {
                        canSaveMusicCount++;
                    } else if (messageObject.isDocument() && !noforwards) {
                        canSaveDocumentsCount++;
                    } else {
                        cantSaveMessagesCount++;
                    }
                    if (outside) {
                        showTextSelectionHint(messageObject);
                    }
                }
            }
        }
        if (forwardButtonAnimation != null) {
            forwardButtonAnimation.cancel();
            forwardButtonAnimation = null;
        }
        if (last && actionBar.isActionModeShowed() && reportType < 0) {
            int selectedCount = selectedMessagesIds[0].size() + selectedMessagesIds[1].size();
            if (selectedCount == 0) {
                hideActionMode();
                updatePinnedMessageView(true);
            } else {
                createActionMode();
                ActionBarMenuItem saveItem = actionBar.createActionMode().getItem(save_to);
                ActionBarMenuItem copyItem = actionBar.createActionMode().getItem(copy);
                ActionBarMenuItem shareItem = actionBar.createActionMode().getItem(share);
                ActionBarMenuItem starItem = actionBar.createActionMode().getItem(star);
                ActionBarMenuItem editItem = actionBar.createActionMode().getItem(edit);
                ActionBarMenuItem forwardItem = actionBar.createActionMode().getItem(forward);
                ActionBarMenuItem deleteItem = actionBar.createActionMode().getItem(delete);

                createBottomMessagesActionButtons();
                boolean noforwards = getMessagesController().isChatNoForwards(currentChat) || hasSelectedNoforwardsMessage();
                if (prevCantForwardCount == 0 && cantForwardMessagesCount != 0 || prevCantForwardCount != 0 && cantForwardMessagesCount == 0) {
                    forwardButtonAnimation = new AnimatorSet();
                    ArrayList<Animator> animators = new ArrayList<>();
                    if (forwardItem != null) {
                        forwardItem.setEnabled(cantForwardMessagesCount == 0 || noforwards);
                        animators.add(ObjectAnimator.ofFloat(forwardItem, View.ALPHA, cantForwardMessagesCount == 0 ? 1.0f : 0.5f));

                        if (noforwards && forwardItem.getBackground() != null) {
                            forwardItem.setBackground(null);
                        } else if (forwardItem.getBackground() == null) {
                            forwardItem.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 5));
                        }
                    }
                    if (forwardButton != null) {
                        forwardButton.setEnabled(cantForwardMessagesCount == 0 || noforwards);
                        if (noforwards && forwardButton.getBackground() != null) {
                            forwardButton.setBackground(null);
                        } else if (forwardButton.getBackground() == null) {
                            forwardButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
                        }
                        animators.add(ObjectAnimator.ofFloat(forwardButton, View.ALPHA, cantForwardMessagesCount == 0 ? 1.0f : 0.5f));
                    }
                    forwardButtonAnimation.playTogether(animators);
                    forwardButtonAnimation.setDuration(100);
                    forwardButtonAnimation.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            forwardButtonAnimation = null;
                        }
                    });
                    forwardButtonAnimation.start();
                } else {
                    if (forwardItem != null) {
                        forwardItem.setEnabled(cantForwardMessagesCount == 0 || noforwards);
                        forwardItem.setAlpha(cantForwardMessagesCount == 0 ? 1.0f : 0.5f);
                        if (noforwards) {
                            if (forwardButton != null && forwardItem.getBackground() != null) {
                                forwardButton.setBackground(null);
                            }
                        } else if (forwardItem.getBackground() == null) {
                            forwardItem.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
                        }
                    }
                    if (forwardButton != null) {
                        forwardButton.setEnabled(cantForwardMessagesCount == 0 || noforwards);
                        if (noforwards) {
                            if (forwardButton.getBackground() != null) forwardButton.setBackground(null);
                        } else if (forwardButton.getBackground() == null) {
                            forwardButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 3));
                        }
                        forwardButton.setAlpha(cantForwardMessagesCount == 0 ? 1.0f : 0.5f);
                    }
                }
                if (saveItem != null) {
                    saveItem.setVisibility(((canSaveMusicCount > 0 && canSaveDocumentsCount == 0) || (canSaveMusicCount == 0 && canSaveDocumentsCount > 0)) && cantSaveMessagesCount == 0 ? View.VISIBLE : View.GONE);
                    saveItem.setContentDescription(canSaveMusicCount > 0 ? LocaleController.getString("SaveToMusic", R.string.SaveToMusic) : LocaleController.getString("SaveToDownloads", R.string.SaveToDownloads));
                }

                int copyVisible = View.GONE, starVisible = View.GONE, newCopyVisible = View.GONE, newStarVisible = View.GONE;
                if (copyItem != null) {
                    copyVisible = copyItem.getVisibility();
                    copyItem.setVisibility(!noforwards && selectedMessagesCanCopyIds[0].size() + selectedMessagesCanCopyIds[1].size() != 0 ? View.VISIBLE : View.GONE);
                    newCopyVisible = copyItem.getVisibility();
                }
                if (shareItem != null) {
                    shareItem.setVisibility(!noforwards && selectedMessagesCanCopyIds[0].size() + selectedMessagesCanCopyIds[1].size() != 0 ? View.VISIBLE : View.GONE);
                }
                if (starItem != null) {
                    starVisible = starItem.getVisibility();
                    starItem.setVisibility(getMediaDataController().canAddStickerToFavorites() && (selectedMessagesCanStarIds[0].size() + selectedMessagesCanStarIds[1].size()) == selectedCount ? View.VISIBLE : View.GONE);
                    newStarVisible = starItem.getVisibility();
                }

                if (deleteItem != null) {
                    deleteItem.setVisibility(cantDeleteMessagesCount == 0 ? View.VISIBLE : View.GONE);
                }
                hasUnfavedSelected = false;
                for (int a = 0; a < 2; a++) {
                    for (int b = 0; b < selectedMessagesCanStarIds[a].size(); b++) {
                        MessageObject msg = selectedMessagesCanStarIds[a].valueAt(b);
                        if (msg != null && !getMediaDataController().isStickerInFavorites(msg.getDocument())) {
                            hasUnfavedSelected = true;
                            break;
                        }
                    }
                    if (hasUnfavedSelected) {
                        break;
                    }
                }
                if (starItem != null) {
                    starItem.setIcon(hasUnfavedSelected ? R.drawable.msg_fave : R.drawable.msg_unfave);
                }
                final int newEditVisibility = canEditMessagesCount == 1 && selectedCount == 1 ? View.VISIBLE : View.GONE;
                createBottomMessagesActionButtons();
                if (replyButton != null) {
                    boolean allowChatActions = true;
                    if (bottomOverlayChat != null && bottomOverlayChat.getVisibility() == View.VISIBLE && !bottomOverlayChatWaitsReply ||
                            currentChat != null && (ChatObject.isNotInChat(currentChat) && !isThreadChat() || ChatObject.isChannel(currentChat) && !ChatObject.canPost(currentChat) && !currentChat.megagroup || !ChatObject.canSendMessages(currentChat))) {
                        allowChatActions = false;
                    }

                    int newVisibility;

                    if (chatMode == MODE_SCHEDULED || !allowChatActions || selectedMessagesIds[0].size() != 0 && selectedMessagesIds[1].size() != 0) {
                        newVisibility = View.GONE;
                    } else if (selectedCount == 1) {
                        newVisibility = View.VISIBLE;
                    } else {
                        newVisibility = View.VISIBLE;
                        long lastGroupId = 0;
                        for (int a = 0; a < 2; a++) {
                            for (int b = 0, N = selectedMessagesIds[a].size(); b < N; b++) {
                                MessageObject message = selectedMessagesIds[a].valueAt(b);
                                long groupId = message.getGroupId();
                                if (groupId == 0 || lastGroupId != 0 && lastGroupId != groupId) {
                                    newVisibility = View.GONE;
                                    break;
                                }
                                lastGroupId = groupId;
                            }
                            if (newVisibility == View.GONE) {
                                break;
                            }
                        }
                    }
                    if (threadMessageObjects != null && newVisibility == View.VISIBLE) {
                        for (int b = 0, N = selectedMessagesIds[0].size(); b < N; b++) {
                            MessageObject message = selectedMessagesIds[0].valueAt(b);
                            if (threadMessageObjects.contains(message)) {
                                newVisibility = View.GONE;
                            }
                        }
                    }

                    if (replyButton.getVisibility() != newVisibility && !BuildVars.IS_CHAT_AIR) {
                        if (replyButtonAnimation != null) {
                            replyButtonAnimation.cancel();
                        }
                        replyButtonAnimation = new AnimatorSet();
                        if (newVisibility == View.VISIBLE) {
                            replyButton.setVisibility(newVisibility);
                            replyButtonAnimation.playTogether(
                                    ObjectAnimator.ofFloat(replyButton, View.ALPHA, 1.0f),
                                    ObjectAnimator.ofFloat(replyButton, View.SCALE_Y, 1.0f)
                            );
                        } else {
                            replyButtonAnimation.playTogether(
                                    ObjectAnimator.ofFloat(replyButton, View.ALPHA, 0.0f),
                                    ObjectAnimator.ofFloat(replyButton, View.SCALE_Y, 0.0f)
                            );
                        }
                        replyButtonAnimation.setDuration(100);
                        int newVisibilityFinal = newVisibility;
                        replyButtonAnimation.addListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                if (replyButtonAnimation != null && replyButtonAnimation.equals(animation)) {
                                    if (newVisibilityFinal == View.GONE) {
                                        replyButton.setVisibility(View.GONE);
                                    }
                                }
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {
                                if (replyButtonAnimation != null && replyButtonAnimation.equals(animation)) {
                                    replyButtonAnimation = null;
                                }
                            }
                        });
                        replyButtonAnimation.start();
                    }
                }

                if (editItem != null) {
                    if (copyVisible != newCopyVisible || starVisible != newStarVisible) {
                        if (newEditVisibility == View.VISIBLE) {
                            editItem.setAlpha(1.0f);
                            editItem.setScaleX(1.0f);
                        } else {
                            editItem.setAlpha(0.0f);
                            editItem.setScaleX(0.0f);
                        }
                        editItem.setVisibility(newEditVisibility);
                    } else if (editItem.getVisibility() != newEditVisibility) {
                        if (editButtonAnimation != null) {
                            editButtonAnimation.cancel();
                        }
                        editButtonAnimation = new AnimatorSet();
                        editItem.setPivotX(AndroidUtilities.dp(54));
                        editItem.setPivotX(AndroidUtilities.dp(54));
                        if (newEditVisibility == View.VISIBLE) {
                            editItem.setVisibility(newEditVisibility);
                            editButtonAnimation.playTogether(
                                    ObjectAnimator.ofFloat(editItem, View.ALPHA, 1.0f),
                                    ObjectAnimator.ofFloat(editItem, View.SCALE_X, 1.0f)
                            );
                        } else {
                            editButtonAnimation.playTogether(
                                    ObjectAnimator.ofFloat(editItem, View.ALPHA, 0.0f),
                                    ObjectAnimator.ofFloat(editItem, View.SCALE_X, 0.0f)
                            );
                        }
                        editButtonAnimation.setDuration(100);
                        editButtonAnimation.addListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                if (editButtonAnimation != null && editButtonAnimation.equals(animation)) {
                                    if (newEditVisibility == View.GONE) {
                                        editItem.setVisibility(View.GONE);
                                    }
                                }
                            }

                            @Override
                            public void onAnimationCancel(Animator animation) {
                                if (editButtonAnimation != null && editButtonAnimation.equals(animation)) {
                                    editButtonAnimation = null;
                                }
                            }
                        });
                        editButtonAnimation.start();
                    }
                }
            }
        }
        updateSelectedMessageReactions();
    }

    // 更新表情反应弹窗
    private void updateSelectedMessageReactions() {
        if (BuildVars.IS_CHAT_AIR) return;

        List<MessageObject> selected = new ArrayList<>();
        SparseArray<MessageObject> objs = selectedMessagesIds[0];
        for (int i = 0; i < objs.size(); i++) {
            selected.add(objs.valueAt(i));
        }
        objs = selectedMessagesIds[1];
        for (int i = 0; i < objs.size(); i++) {
            selected.add(objs.valueAt(i));
        }
        selectionReactionsOverlay.setSelectedMessages(selected);
    }

    //长按选中模式下选择
    private void processRowSelect(View view, boolean outside, float touchX, float touchY) {
        MessageObject message = null;
        if (view instanceof ChatMessageCell) {
            ChatMessageCell cell = (ChatMessageCell) view;
            message = cell.getMessageObject();
            cell.setLastTouchCoords(touchX, touchY);
        } else if (view instanceof ChatActionCell) {
            message = ((ChatActionCell) view).getMessageObject();
        }

        int type = getMessageType(message);

        if (type < 2 || type == 20 || type == MessageObject.TYPE_SUGGEST_PHOTO) {
            return;
        }
        addToSelectedMessages(message, outside);
        updateActionModeTitle();
        updateVisibleRows();
    }

    private void updateActionModeTitle() {
        if (reportType < 0) {
            if (!actionBar.isActionModeShowed()) {
                return;
            }
            if (selectedMessagesCountTextView != null && (selectedMessagesIds[0].size() != 0 || selectedMessagesIds[1].size() != 0)) {
                selectedMessagesCountTextView.setNumber(selectedMessagesIds[0].size() + selectedMessagesIds[1].size(), true);
            }
        } else {
            int size = selectedMessagesIds[0].size() + selectedMessagesIds[1].size();
            if (size == 0) {
                bottomOverlayChatText.setText(LocaleController.getString("ReportMessages", R.string.ReportMessages));
                bottomOverlayChatText.setAlpha(0.5f);
                bottomOverlayChatText.setEnabled(false);
            } else {
                bottomOverlayChatText.setText(LocaleController.formatString("ReportMessagesCount", R.string.ReportMessagesCount, LocaleController.formatPluralString("messages", size)).toUpperCase());
                bottomOverlayChatText.setAlpha(1.0f);
                bottomOverlayChatText.setEnabled(true);
            }
        }
    }

    //更新actionBar标题
    public void updateTitle(boolean animated) {
        if (avatarContainer == null) {
            return;
        }
        if (isThreadChat()) {
            if (isTopic) {
                updateTopicHeader();
            } else if (isComments) {
                if (threadMessageObject.hasReplies()) {
                    avatarContainer.setTitle(LocaleController.formatPluralString("Comments", threadMessageObject.getRepliesCount()));
                } else {
                    avatarContainer.setTitle(LocaleController.getString("CommentsTitle", R.string.CommentsTitle));
                }
            } else {
                avatarContainer.setTitle(LocaleController.formatPluralString("Replies", threadMessageObject.getRepliesCount()));
            }
        } else if (UserObject.isReplyUser(currentUser)) {
            avatarContainer.setTitle(LocaleController.getString("RepliesTitle", R.string.RepliesTitle));
        } else if (chatMode == MODE_SCHEDULED) {
            if (UserObject.isUserSelf(currentUser)) {
                avatarContainer.setTitle(LocaleController.getString("Reminders", R.string.Reminders));
            } else {
                avatarContainer.setTitle(LocaleController.getString("ScheduledMessages", R.string.ScheduledMessages));
            }
        } else if (chatMode == MODE_PINNED) {
            avatarContainer.setTitle(LocaleController.formatPluralString("PinnedMessagesCount", getPinnedMessagesCount()));
        } else if (currentChat != null) {
            avatarContainer.setTitle(currentChat.title, currentChat.scam, currentChat.fake, currentChat.verified, false, null, animated);
        } else if (currentUser != null) {
            if (currentUser.self) {
                avatarContainer.setTitle(LocaleController.getString("SavedMessages", R.string.SavedMessages));
            } else if (!MessagesController.isSupportUser(currentUser) && getContactsController().contactsDict.get(currentUser.id) == null && (getContactsController().contactsDict.size() != 0 || !getContactsController().isLoadingContacts())) {
                //普通用户
                if (!TextUtils.isEmpty(currentUser.phone) && !BuildVars.IS_CHAT_AIR) {
                    //拥有电话
                    avatarContainer.setTitle(PhoneFormat.getInstance().format("+" + currentUser.phone), currentUser.scam, currentUser.fake, currentUser.verified, getMessagesController().isPremiumUser(currentUser), currentUser.emoji_status, animated);
                } else {
                    //核心设置actionbar主标题
                    avatarContainer.setTitle(UserObject.getUserName(currentUser), currentUser.scam, currentUser.fake, currentUser.verified, getMessagesController().isPremiumUser(currentUser), currentUser.emoji_status, animated);
                }
            } else {
                String title = UserObject.getUserName(currentUser);
                avatarContainer.setTitle(title, currentUser.scam, currentUser.fake, currentUser.verified,  getMessagesController().isPremiumUser(currentUser), currentUser.emoji_status, animated);
            }
        }
        setParentActivityTitle(avatarContainer.getTitleTextView().getText());
    }

    private void updateTopicTitleIcon() {
        if (forumTopic != null && avatarContainer != null) {
            avatarContainer.getAvatarImageView().setVisibility(View.VISIBLE);
            ForumUtilities.setTopicIcon(avatarContainer.getAvatarImageView(), forumTopic, true, true, themeDelegate);
        }
    }

    private int getPinnedMessagesCount() {
        return Math.max(loadedPinnedMessagesCount, totalPinnedMessagesCount);
    }

    private void updateTopicButtons() {
        if (closeTopicItem != null) {
            closeTopicItem.setVisibility(currentChat != null && ChatObject.canManageTopic(currentAccount, currentChat, forumTopic) && forumTopic != null && !forumTopic.closed ? View.VISIBLE : View.GONE);
        }
    }

    private void updateBotButtons() {
        if (headerItem == null || currentUser == null || currentEncryptedChat != null || !currentUser.bot) {
            return;
        }
        boolean hasHelp = false;
        boolean hasSettings = false;
        if (botInfo.size() != 0) {
            for (int b = 0; b < botInfo.size(); b++) {
                TLRPC.BotInfo info = botInfo.valueAt(b);
                for (int a = 0; a < info.commands.size(); a++) {
                    TLRPC.TL_botCommand command = info.commands.get(a);
                    if (command.command.toLowerCase().equals("help")) {
                        hasHelp = true;
                    } else if (command.command.toLowerCase().equals("settings")) {
                        hasSettings = true;
                    }
                    if (hasSettings && hasHelp) {
                        break;
                    }
                }
            }
        }
        if (hasHelp) {
            headerItem.showSubItem(bot_help);
        } else {
            headerItem.hideSubItem(bot_help);
        }
        if (hasSettings) {
            headerItem.showSubItem(bot_settings);
        } else {
            headerItem.hideSubItem(bot_settings);
        }
    }

    private void updateTitleIcons() {
        updateTitleIcons(false);
    }

    private void updateTitleIcons(boolean forceToggleMuted) {
        if (avatarContainer == null || chatMode != 0) {
            return;
        }
        boolean isMuted = getMessagesController().isDialogMuted(dialog_id, getTopicId());
        if (forceToggleMuted) {
            isMuted = !isMuted;
        }
        Drawable rightIcon = null;
        if (!UserObject.isReplyUser(currentUser) && (!isThreadChat() || isTopic) && isMuted) {
            rightIcon = getThemedDrawable(Theme.key_drawable_muteIconDrawable);
        }
        avatarContainer.setTitleIcons(currentEncryptedChat != null ? getThemedDrawable(Theme.key_drawable_lockIconDrawable) : null, rightIcon);
        if (!forceToggleMuted && muteItem != null) {
            if (isMuted) {
                muteItem.setRightIconVisibility(View.GONE);
                muteItem.setText(LocaleController.getString("Unmute", R.string.Unmute));
                muteItem.setIcon(R.drawable.msg_mute);
            } else {
                muteItem.setRightIconVisibility(View.VISIBLE);
                if (getMessagesController().isDialogNotificationsSoundEnabled(dialog_id, getTopicId())) {
                    muteItem.setText(LocaleController.getString("Mute", R.string.Mute));
                    muteItem.setIcon(R.drawable.msg_unmute);
                } else {
                    muteItem.setText(LocaleController.getString("Mute", R.string.Mute));
                    muteItem.setIcon(R.drawable.msg_silent);
                }
            }
        }
        if (chatNotificationsPopupWrapper != null) {
            chatNotificationsPopupWrapper.update(dialog_id, getTopicId(), null);
        }
    }

    public void checkAndUpdateAvatar() {
        if (isTopic) {
            return;
        }
        if (currentUser != null) {
            TLRPC.User user = getMessagesController().getUser(currentUser.id);
            if (user == null) {
                return;
            }
            currentUser = user;
        } else if (currentChat != null) {
            TLRPC.Chat chat = getMessagesController().getChat(currentChat.id);
            if (chat == null) {
                return;
            }
            currentChat = chat;
        }
        if (avatarContainer != null) {
            avatarContainer.checkAndUpdateAvatar();
        }
    }

    public void openVideoEditor(String videoPath, String caption) {
        if (getParentActivity() != null) {
            final Bitmap thumb = SendMessagesHelper.createVideoThumbnail(videoPath, MediaStore.Video.Thumbnails.MINI_KIND);
            PhotoViewer.getInstance().setParentActivity(this, themeDelegate);
            final ArrayList<Object> cameraPhoto = new ArrayList<>();
            MediaController.PhotoEntry entry = new MediaController.PhotoEntry(0, 0, 0, videoPath, 0, true, 0, 0, 0);
            entry.caption = caption;
            cameraPhoto.add(entry);
            PhotoViewer.getInstance().openPhotoForSelect(cameraPhoto, 0, 0, false, new PhotoViewer.EmptyPhotoViewerProvider() {
                @Override
                public ImageReceiver.BitmapHolder getThumbForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index) {
                    return new ImageReceiver.BitmapHolder(thumb, null, 0);
                }

                @Override
                public void sendButtonPressed(int index, VideoEditedInfo videoEditedInfo, boolean notify, int scheduleDate, boolean forceDocument) {
                    sendMedia((MediaController.PhotoEntry) cameraPhoto.get(0), videoEditedInfo, notify, scheduleDate, forceDocument);
                }

                @Override
                public boolean canScrollAway() {
                    return false;
                }
            }, this);
        } else {
            fillEditingMediaWithCaption(caption, null);
            SendMessagesHelper.prepareSendingVideo(getAccountInstance(), videoPath, null, dialog_id, replyingMessageObject, getThreadMessage(), null, null, 0, editingMessageObject, true, 0, false, false);
            afterMessageSend();
        }
    }

    public boolean openPhotosEditor(ArrayList<SendMessagesHelper.SendingMediaInfo> photoPathes, CharSequence caption) {
        final ArrayList<MediaController.PhotoEntry> entries = new ArrayList<>();
        for (int a = 0; a < photoPathes.size(); ++a) {
            SendMessagesHelper.SendingMediaInfo photoInfo = photoPathes.get(a);
            String path = null;
            if (photoInfo.path != null) {
                path = photoInfo.path;
            } else if (photoInfo.uri != null) {
//                path = AndroidUtilities.getPath(photoInfo.uri);
                if (path == null) {
                    try {
                        final File file = AndroidUtilities.generatePicturePath(isSecretChat(), "");
                        InputStream in = ApplicationLoader.applicationContext.getContentResolver().openInputStream(photoInfo.uri);
                        FileOutputStream fos = new FileOutputStream(file);
                        byte[] buffer = new byte[8 * 1024];
                        int lengthRead;
                        while ((lengthRead = in.read(buffer)) > 0) {
                            fos.write(buffer, 0, lengthRead);
                            fos.flush();
                        }
                        in.close();
                        fos.close();
                        path = file.getAbsolutePath();
                    } catch (Exception e) {
                        FileLog.e(e);
                        continue;
                    }
                }
            }
            if (path == null) {
                continue;
            }
            int orientation = 0;
            try {
                ExifInterface ei = new ExifInterface(path);
                int exif = ei.getAttributeInt(ExifInterface.TAG_ORIENTATION, ExifInterface.ORIENTATION_NORMAL);
                switch (exif) {
                    case ExifInterface.ORIENTATION_ROTATE_90:
                        orientation = 90;
                        break;
                    case ExifInterface.ORIENTATION_ROTATE_180:
                        orientation = 180;
                        break;
                    case ExifInterface.ORIENTATION_ROTATE_270:
                        orientation = 270;
                        break;
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
            MediaController.PhotoEntry entry = new MediaController.PhotoEntry(0, 0, 0, path, orientation, photoInfo.isVideo, 0, 0, 0);
            if (a == photoPathes.size() - 1 && caption != null) {
                entry.caption = caption;
            }
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            return false;
        }
        if (getParentActivity() != null) {
            final boolean[] checked = new boolean[entries.size()];
            Arrays.fill(checked, true);
            PhotoViewer.getInstance().setParentActivity(this, themeDelegate);
            PhotoViewer.getInstance().openPhotoForSelect(new ArrayList<>(entries), entries.size() - 1, 0, false, new PhotoViewer.EmptyPhotoViewerProvider() {
                @Override
                public ImageReceiver.BitmapHolder getThumbForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index) {
                    return null;
                }

                @Override
                public void sendButtonPressed(int index, VideoEditedInfo videoEditedInfo, boolean notify, int scheduleDate, boolean forceDocument) {
                    for (int i = entries.size() - 1; i >= 0; --i) {
                        if (!checked[i]) {
                            entries.remove(i);
                        }
                    }
                    sendPhotosGroup(entries, notify, scheduleDate, forceDocument);
                }

                @Override
                public int setPhotoChecked(int index, VideoEditedInfo videoEditedInfo) {
                    return index;
                }

                @Override
                public boolean isPhotoChecked(int index) {
                    return checked[index];
                }

                @Override
                public boolean canScrollAway() {
                    return false;
                }
            }, this);
        } else {
            fillEditingMediaWithCaption(caption, null);
            sendPhotosGroup(entries, false, 0, false);
            afterMessageSend();
        }
        return true;
    }
    private void sendPhotosGroup(ArrayList<MediaController.PhotoEntry> entries, boolean notify, int scheduleDate, boolean forceDocument) {
        if (!entries.isEmpty()) {
            ArrayList<SendMessagesHelper.SendingMediaInfo> photos = new ArrayList<>();
            for (MediaController.PhotoEntry entry : entries) {
                SendMessagesHelper.SendingMediaInfo info = new SendMessagesHelper.SendingMediaInfo();
                if (!entry.isVideo && entry.imagePath != null) {
                    info.path = entry.imagePath;
                } else if (entry.path != null) {
                    info.path = entry.path;
                }
                info.thumbPath = entry.thumbPath;
                info.isVideo = entry.isVideo;
                info.caption = entry.caption != null ? entry.caption.toString() : null;
                info.entities = entry.entities;
                info.masks = entry.stickers;
                info.ttl = entry.ttl;
                info.videoEditedInfo = entry.editedInfo;
                info.canDeleteAfter = entry.canDeleteAfter;
                photos.add(info);
                entry.reset();
            }
            fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
            SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, forceDocument, true, null, notify, scheduleDate, photos.get(0).updateStickersOrder);
            afterMessageSend();
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setFieldText("");
            }
        }
        if (scheduleDate != 0) {
            if (scheduledMessagesCount == -1) {
                scheduledMessagesCount = 0;
            }
            scheduledMessagesCount += entries.size();
            updateScheduledInterface(true);
        }
    }

    private void openEditingMessageInPhotoEditor() {
        if (editingMessageObject == null || !editingMessageObject.canEditMedia() || editingMessageObjectReqId != 0) {
            return;
        }
        if (!editingMessageObject.isPhoto() && !editingMessageObject.isVideo()) {
            return;
        }
        final MessageObject object = editingMessageObject;
        File file = null;
        if (!TextUtils.isEmpty(object.messageOwner.attachPath)) {
            file = new File(object.messageOwner.attachPath);
            if (!file.exists()) {
                file = null;
            }
        }
        if (file == null) {
            file = FileLoader.getInstance(currentAccount).getPathToMessage(object.messageOwner);
        }
        if (!file.exists()) {
            return;
        }
        PhotoViewer.getInstance().setParentActivity(this, themeDelegate);
        final ArrayList<Object> photos = new ArrayList<>();
        final MediaController.PhotoEntry entry = new MediaController.PhotoEntry(0, 0, 0, file.getAbsolutePath(), 0, object.isVideo(), 0, 0, 0);
        entry.caption = chatActivityEnterView.getFieldText();
        photos.add(entry);
        PhotoViewer.getInstance().openPhotoForSelect(photos, 0, 2, false, new PhotoViewer.EmptyPhotoViewerProvider() {
            @Override
            public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview) {
                return ChatActivity.this.getPlaceForPhoto(object, null, needPreview, true);
            }

            @Override
            public void sendButtonPressed(int index, VideoEditedInfo videoEditedInfo, boolean notify, int scheduleDate, boolean forceDocument) {
                if (editingMessageObject != object) {
                    return;
                }
                if (entry.isCropped || entry.isPainted || entry.isFiltered || videoEditedInfo != null) {
                    sendMedia(entry, videoEditedInfo, notify, scheduleDate, forceDocument);
                } else {
                    chatActivityEnterView.doneEditingMessage();
                }
            }

            @Override
            public boolean canCaptureMorePhotos() {
                return false;
            }

            @Override
            public boolean allowSendingSubmenu() {
                return false;
            }

            @Override
            public MessageObject getEditingMessageObject() {
                return editingMessageObject == object ? object : null;
            }

            @Override
            public void onCaptionChanged(CharSequence caption) {
                if (editingMessageObject == object) {
                    chatActivityEnterView.setFieldText(caption, true);
                }
            }

            @Override
            public boolean closeKeyboard() {
                if (chatActivityEnterView != null && isKeyboardVisible()) {
                    chatActivityEnterView.closeKeyboard();
                    return true;
                }
                return false;
            }
        }, this);
    }

    private PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, boolean needPreview, boolean onlyIfVisible) {
        int count = chatListView.getChildCount();

        for (int a = 0; a < count; a++) {
            ImageReceiver imageReceiver = null;
            View view = chatListView.getChildAt(a);
            if (view instanceof ChatMessageCell) {
                if (messageObject != null) {
                    ChatMessageCell cell = (ChatMessageCell) view;
                    MessageObject message = cell.getMessageObject();
                    if (message != null && message.getId() == messageObject.getId()) {
                        imageReceiver = cell.getPhotoImage();
                    }
                }
            } else if (view instanceof ChatActionCell) {
                ChatActionCell cell = (ChatActionCell) view;
                MessageObject message = cell.getMessageObject();
                if (message != null) {
                    if (messageObject != null) {
                        if (message.getId() == messageObject.getId()) {
                            imageReceiver = cell.getPhotoImage();
                        }
                    } else if (fileLocation != null && message.photoThumbs != null) {
                        for (int b = 0; b < message.photoThumbs.size(); b++) {
                            TLRPC.PhotoSize photoSize = message.photoThumbs.get(b);
                            if (photoSize.location != null && photoSize.location.volume_id == fileLocation.volume_id && photoSize.location.local_id == fileLocation.local_id) {
                                imageReceiver = cell.getPhotoImage();
                                break;
                            }
                        }
                        if (imageReceiver == null && message.messageOwner != null && message.messageOwner.action != null && message.messageOwner.action.photo != null && message.messageOwner.action.photo.video_sizes != null && !message.messageOwner.action.photo.video_sizes.isEmpty()) {
                            TLRPC.VideoSize photoSize = message.messageOwner.action.photo.video_sizes.get(0);
                            if (photoSize.location != null && photoSize.location.volume_id == fileLocation.volume_id && photoSize.location.local_id == fileLocation.local_id) {
                                imageReceiver = cell.getPhotoImage();
                            }
                        }
                    }
                }
            }

            if (imageReceiver != null) {
                if (onlyIfVisible && view.getY() + imageReceiver.getImageY2() < chatListViewPaddingTop - AndroidUtilities.dp(4)) {
                    return null;
                }
                int[] coords = new int[2];
                view.getLocationInWindow(coords);
                PhotoViewer.PlaceProviderObject object = new PhotoViewer.PlaceProviderObject();
                object.viewX = coords[0];
                object.viewY = coords[1] - (Build.VERSION.SDK_INT >= 21 ? 0 : AndroidUtilities.statusBarHeight);
                object.parentView = chatListView;
                object.animatingImageView = null;
                object.imageReceiver = imageReceiver;
                if (needPreview) {
                    object.thumb = imageReceiver.getBitmapSafe();
                }
                object.radius = imageReceiver.getRoundRadius();
                if (view instanceof ChatActionCell && currentChat != null) {
                    object.dialogId = -currentChat.id;
                }
                object.clipTopAddition = (int) (chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4));
                object.clipBottomAddition = blurredViewBottomOffset;
                return object;
            }
        }
        return null;
    }

    private void showAttachmentError() {
        if (getParentActivity() == null) {
            return;
        }
        BulletinFactory.of(this).createErrorBulletin(LocaleController.getString("UnsupportedAttachment", R.string.UnsupportedAttachment), themeDelegate).show();
    }

    private void fillEditingMediaWithCaption(CharSequence caption, ArrayList<TLRPC.MessageEntity> entities) {
        if (editingMessageObject == null) {
            return;
        }
        if (!TextUtils.isEmpty(caption)) {
            editingMessageObject.editingMessage = caption;
            editingMessageObject.editingMessageEntities = entities;
        } else if (chatActivityEnterView != null) {
            editingMessageObject.editingMessage = chatActivityEnterView.getFieldText();
            if (editingMessageObject.editingMessage == null && !TextUtils.isEmpty(editingMessageObject.messageOwner.message)) {
                editingMessageObject.editingMessage = "";
            }
        }
    }

    private void sendUriAsDocument(Uri uri) {
        if (uri == null) {
            return;
        }
        String extractUriFrom = uri.toString();
        if (extractUriFrom.contains("com.google.android.apps.photos.contentprovider")) {
            try {
                String firstExtraction = extractUriFrom.split("/1/")[1];
                int index = firstExtraction.indexOf("/ACTUAL");
                if (index != -1) {
                    firstExtraction = firstExtraction.substring(0, index);
                    String secondExtraction = URLDecoder.decode(firstExtraction, "UTF-8");
                    uri = Uri.parse(secondExtraction);
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
        }
        String tempPath = AndroidUtilities.getPath(uri);
        String originalPath = tempPath;
        boolean sendAsUri = false;
        if (!BuildVars.NO_SCOPED_STORAGE) {
            sendAsUri = true;
        } else if (tempPath == null) {
            originalPath = uri.toString();
            tempPath = MediaController.copyFileToCache(uri, "file");

            if (tempPath == null) {
                showAttachmentError();
                return;
            }
        }
        fillEditingMediaWithCaption(null, null);
        if (sendAsUri) {
            SendMessagesHelper.prepareSendingDocument(getAccountInstance(), null, null, uri, null, null, dialog_id, replyingMessageObject, getThreadMessage(), null, editingMessageObject, true, 0);
        } else {
            SendMessagesHelper.prepareSendingDocument(getAccountInstance(), tempPath, originalPath, null, null, null, dialog_id, replyingMessageObject, getThreadMessage(), null, editingMessageObject, true, 0);
        }
        hideFieldPanel(false);
    }

    @Override
    public void onActivityResultFragment(int requestCode, int resultCode, Intent data) {
        if (resultCode == Activity.RESULT_OK) {
            if (requestCode == 0 || requestCode == 2) {
                createChatAttachView();
                if (chatAttachAlert != null) {
                    chatAttachAlert.getPhotoLayout().onActivityResultFragment(requestCode, data, currentPicturePath);
                }
                currentPicturePath = null;
            } else if (requestCode == 1) {
                if (data == null || data.getData() == null) {
                    showAttachmentError();
                    return;
                }
                Uri uri = data.getData();
                if (uri.toString().contains("video")) {
                    String videoPath = null;
                    try {
                        videoPath = AndroidUtilities.getPath(uri);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    if (videoPath == null) {
                        showAttachmentError();
                    }
                    if (paused) {
                        startVideoEdit = videoPath;
                    } else {
                        openVideoEditor(videoPath, null);
                    }
                } else {
                    if (editingMessageObject == null && chatMode == MODE_SCHEDULED) {
                        AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate) -> {
                            fillEditingMediaWithCaption(null, null);
                            SendMessagesHelper.prepareSendingPhoto(getAccountInstance(), null, uri, dialog_id, replyingMessageObject, getThreadMessage(), null, null, null, null, 0, editingMessageObject, notify, scheduleDate);
                        }, themeDelegate);
                    } else {
                        fillEditingMediaWithCaption(null, null);
                        SendMessagesHelper.prepareSendingPhoto(getAccountInstance(), null, uri, dialog_id, replyingMessageObject, getThreadMessage(), null, null, null, null, 0, editingMessageObject, true, 0);
                    }
                }
                afterMessageSend();
            } else if (requestCode == 21) {
                if (data == null) {
                    showAttachmentError();
                    return;
                }
                if (data.getData() != null) {
                    sendUriAsDocument(data.getData());
                } else if (data.getClipData() != null) {
                    ClipData clipData = data.getClipData();
                    for (int i = 0; i < clipData.getItemCount(); i++) {
                        sendUriAsDocument(clipData.getItemAt(i).getUri());
                    }
                } else {
                    showAttachmentError();
                }
                if (chatAttachAlert != null) {
                    chatAttachAlert.dismiss();
                }
                afterMessageSend();
            }
        }
    }

    @Override
    public void saveSelfArgs(Bundle args) {
        if (currentPicturePath != null) {
            args.putString("path", currentPicturePath);
        }
    }

    @Override
    public void restoreSelfArgs(Bundle args) {
        currentPicturePath = args.getString("path");
    }

    private boolean isSkeletonVisible() {
        if (justCreatedTopic || justCreatedChat || currentUser != null || chatListView == null || !SharedConfig.animationsEnabled() || !LiteMode.isEnabled(LiteMode.FLAGS_CHAT)) {
            return false;
        }
        int childHeight = 0;
        int maxTop = Integer.MAX_VALUE;
        for (int i = 0; i < chatListView.getChildCount(); i++) {
            childHeight += chatListView.getChildAt(i).getHeight();
            int top = chatListView.getChildAt(i).getTop();
            if (top < maxTop) {
                maxTop = top;
            }
        }
        if (maxTop <= chatListViewPaddingTop) {
            checkDispatchHideSkeletons(fragmentBeginToShow);
        }

        boolean visible = (!endReached[0] || mergeDialogId != 0 && !endReached[1] || messages.isEmpty()) && loading && maxTop > chatListViewPaddingTop && (messages.isEmpty() ? animateProgressViewTo : childHeight != 0);
        if (!visible && startMessageAppearTransitionMs == 0) {
            checkDispatchHideSkeletons(fragmentBeginToShow);
        }
        if (SharedConfig.getDevicePerformanceClass() != SharedConfig.PERFORMANCE_CLASS_LOW && !fromPullingDownTransition && fragmentBeginToShow) {
            boolean rotate = visible && startMessageAppearTransitionMs == 0;
            Drawable wallpaper = themeDelegate.getWallpaperDrawable();
            if (fragmentView != null) {
                wallpaper = ((SizeNotifierFrameLayout) fragmentView).getBackgroundImage();
            }
            if (wallpaper instanceof MotionBackgroundDrawable) {
                MotionBackgroundDrawable motion = (MotionBackgroundDrawable) wallpaper;
                if (((MotionBackgroundDrawable) wallpaper).isIndeterminateAnimation() != rotate) {
                    if (!rotate) {
                        motion.generateNextGradient();
                    }
                    motion.setIndeterminateAnimation(rotate);
                    motion.setIndeterminateSpeedScale(rotate ? 1.5f : 1f);
                    motion.updateAnimation(true);
                } else if (rotate) {
                    motion.updateAnimation(false);
                }
            }
        }
        return visible || startMessageAppearTransitionMs != 0 && System.currentTimeMillis() - startMessageAppearTransitionMs <= SKELETON_DISAPPEAR_MS;
    }

    private void checkDispatchHideSkeletons(boolean animate) {
        if (startMessageAppearTransitionMs == 0) {
            if (animate && !messageSkeletons.isEmpty()) {
                startMessageAppearTransitionMs = System.currentTimeMillis();
            } else {
                startMessageAppearTransitionMs = 1;
            }
            isSkeletonVisible();
            if (chatListView != null) {
                chatListView.invalidate();
            }
        }
    }

    private void removeUnreadPlane(boolean scrollToEnd) {
        if (unreadMessageObject != null) {
            if (scrollToEnd) {
                forwardEndReached[0] = forwardEndReached[1] = true;
                first_unread_id = 0;
                last_message_id = 0;
            }
            createUnreadMessageAfterId = 0;
            createUnreadMessageAfterIdLoading = false;
            removeMessageObject(unreadMessageObject);
            unreadMessageObject = null;
        }
    }

    //核心，接收全局消息
    @Override
    public void didReceivedNotification(int id, int account, final Object... args) {

        if (id == NotificationCenter.messagesDidLoad) {
            int guid = (Integer) args[10];
            if (guid != classGuid) {
                return;
            }
            int queryLoadIndex = (Integer) args[11];
            boolean doNotRemoveLoadIndex;
            if (queryLoadIndex < 0) {
                doNotRemoveLoadIndex = true;
                queryLoadIndex = -queryLoadIndex;
            } else {
                doNotRemoveLoadIndex = false;
            }
            if (!doNotRemoveLoadIndex && !fragmentBeginToShow && !paused) {
                int[] alowedNotifications = new int[]{NotificationCenter.messagesDidLoad, NotificationCenter.chatInfoDidLoad, NotificationCenter.groupCallUpdated, NotificationCenter.dialogsNeedReload, NotificationCenter.scheduledMessagesUpdated,
                        NotificationCenter.closeChats, NotificationCenter.botKeyboardDidLoad, NotificationCenter.userInfoDidLoad, NotificationCenter.pinnedInfoDidLoad, NotificationCenter.needDeleteDialog/*, NotificationCenter.botInfoDidLoad*/};
                if (transitionAnimationIndex == 0) {
                    transitionAnimationIndex = getNotificationCenter().setAnimationInProgress(transitionAnimationIndex, alowedNotifications);
                    AndroidUtilities.runOnUIThread(() -> getNotificationCenter().onAnimationFinish(transitionAnimationIndex), 800);
                } else {
                    getNotificationCenter().updateAllowedNotifications(transitionAnimationIndex, alowedNotifications);
                }
            }
            int index = waitingForLoad.indexOf(queryLoadIndex);
            long currentUserId = getUserConfig().getClientUserId();
            int mode = (Integer) args[14];
            boolean isCache = (Boolean) args[3];
            boolean postponedScroll = postponedScrollToLastMessageQueryIndex > 0 && queryLoadIndex == postponedScrollToLastMessageQueryIndex;
            if (postponedScroll) {
                postponedScrollToLastMessageQueryIndex = 0;
            }

            if (index == -1) {
                if (chatMode == MODE_SCHEDULED && mode == MODE_SCHEDULED && !isCache) {
                    waitingForReplyMessageLoad = true;
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, false, AndroidUtilities.isTablet() ? 30 : 20, 0, 0, true, 0, classGuid, 2, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
                return;
            } else if (!doNotRemoveLoadIndex) {
                waitingForLoad.remove(index);
            }
            //将接收的消息转为ArrayList
            ArrayList<MessageObject> messArr = (ArrayList<MessageObject>) args[2];
            //空消息，载入空页面，修改
            if (messages.isEmpty() && messArr.size() == 1 && MessageObject.isSystemSignUp(messArr.get(0))) {
                forceHistoryEmpty = true;
                endReached[0] = endReached[1] = true;
                forwardEndReached[0] = forwardEndReached[1] = true;
                firstLoading = false;
                showProgressView(false);
                checkDispatchHideSkeletons(true);
                if (chatListView != null) {
                    createEmptyView();
                    if (!fragmentOpened) {
                        chatListView.setAnimateEmptyView(false, 1);
                        chatListView.setEmptyView(emptyViewContainer);
                        chatListView.setAnimateEmptyView(true, RecyclerListView.EMPTY_VIEW_ANIMATION_TYPE_ALPHA_SCALE);
                    } else {
                        chatListView.setEmptyView(emptyViewContainer);
                    }
                    chatAdapter.notifyDataSetChanged(true);
                }

                resumeDelayedFragmentAnimation();
                MessageObject messageObject = messArr.get(0);
                getMessagesController().markDialogAsRead(dialog_id, messageObject.getId(), messageObject.getId(), messageObject.messageOwner.date, false, 0, 0, true, 0);
                AndroidUtilities.cancelRunOnUIThread(fragmentTransitionRunnable);
                fragmentTransitionRunnable.run();
                return;
            }
            if (chatMode != mode) {
                if (chatMode != MODE_SCHEDULED) {
                    scheduledMessagesCount = messArr.size();
                    updateScheduledInterface(true);
                }
                return;
            }
            boolean createUnreadLoading = false;
            boolean showDateAfter = waitingForReplyMessageLoad;
            //等待回复消息就加载
            if (waitingForReplyMessageLoad) {
                if (chatMode != MODE_SCHEDULED && !createUnreadMessageAfterIdLoading) {
                    boolean found = false;
                    for (int a = 0; a < messArr.size(); a++) {
                        MessageObject obj = messArr.get(a);
                        if (obj.getId() == startLoadFromMessageId) {
                            found = true;
                            break;
                        }
                        if (a + 1 < messArr.size()) {
                            MessageObject obj2 = messArr.get(a + 1);
                            if (obj.getId() >= startLoadFromMessageId && obj2.getId() < startLoadFromMessageId) {
                                startLoadFromMessageId = obj.getId();
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) {
                        startLoadFromMessageId = 0;
                        return;
                    }
                }
                int startLoadFrom = startLoadFromMessageId;
                boolean needSelect = needSelectFromMessageId;
                int unreadAfterId = createUnreadMessageAfterId;
                createUnreadLoading = createUnreadMessageAfterIdLoading;
                clearChatData();
                if (chatMode == 0) {
                    createUnreadMessageAfterId = unreadAfterId;
                    startLoadFromMessageId = startLoadFrom;
                    needSelectFromMessageId = needSelect;
                }
            }

            loadsCount++;
            long did = (Long) args[0];
            int loadIndex = did == dialog_id ? 0 : 1;
            int count = (Integer) args[1];
            int fnid = (Integer) args[4];
            int last_unread_date = (Integer) args[7];
            int load_type = (Integer) args[8];
            boolean isEnd = (Boolean) args[9];
            int loaded_max_id = (Integer) args[12];
            int loaded_mentions_count = chatWasReset ? 0 : (Integer) args[13];

            if (loaded_mentions_count < 0) {
                loaded_mentions_count *= -1;
                hasAllMentionsLocal = false;
            } else if (first) {
                hasAllMentionsLocal = true;
            }
            if (load_type == 4) {
                startLoadFromMessageId = loaded_max_id;

                for (int a = messArr.size() - 1; a > 0; a--) {
                    MessageObject obj = messArr.get(a);
                    if (obj.type < 0 && obj.getId() == startLoadFromMessageId) {
                        startLoadFromMessageId = messArr.get(a - 1).getId();
                        break;
                    }
                }
            }

            if (postponedScroll) {
                if (load_type == 0 && isCache && messArr.size() < count) {
                    postponedScrollToLastMessageQueryIndex = lastLoadIndex;
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, false, count, 0, 0, false, 0, classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    return;
                }

                if (load_type == 4) {
                    postponedScrollMessageId = startLoadFromMessageId;
                }

                if (progressDialog != null) {
                    progressDialog.dismiss();
                }
                resetProgressDialogLoading();
                showPinnedProgress(false);
                if (postponedScrollIsCanceled) {
                    return;
                }
                if (postponedScrollMessageId == 0) {
                    clearChatData();
                } else {
                    if (showScrollToMessageError) {
                        boolean found = false;
                        for (int k = 0; k < messArr.size(); k++) {
                            if (messArr.get(k).getId() == postponedScrollMessageId) {
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            if (isThreadChat()) {
                                Bundle bundle = new Bundle();
                                if (currentEncryptedChat != null) {
                                    bundle.putInt("enc_id", currentEncryptedChat.id);
                                } else if (currentChat != null) {
                                    bundle.putLong("chat_id", currentChat.id);
                                } else {
                                    bundle.putLong("user_id", currentUser.id);
                                }
                                bundle.putInt("message_id", postponedScrollMessageId);
                                presentFragment(new ChatActivity(bundle), true);
                            } else {
                                BulletinFactory.of(this).createErrorBulletin(LocaleController.getString("MessageNotFound", R.string.MessageNotFound), themeDelegate).show();
                            }
                            return;
                        }
                        showScrollToMessageError = false;
                    }
                    int startLoadFrom = startLoadFromMessageId;
                    boolean needSelect = needSelectFromMessageId;
                    int unreadAfterId = createUnreadMessageAfterId;
                    createUnreadLoading = createUnreadMessageAfterIdLoading;
                    clearChatData();
                    if (chatMode == 0) {
                        createUnreadMessageAfterId = unreadAfterId;
                        startLoadFromMessageId = startLoadFrom;
                        needSelectFromMessageId = needSelect;
                    }
                }
            }

            if (chatListItemAnimator != null) {
                chatListItemAnimator.setShouldAnimateEnterFromBottom(false);
            }

            int unread_to_load = 0;
            if (fnid != 0) {
                if (!chatWasReset) {
                    last_message_id = (Integer) args[5];
                }
                if (load_type == 3) {
                    if (loadingFromOldPosition) {
                        if (!chatWasReset) {
                            unread_to_load = (Integer) args[6];
                            if (unread_to_load != 0) {
                                createUnreadMessageAfterId = fnid;
                            }
                        }
                        loadingFromOldPosition = false;
                    }
                    first_unread_id = 0;
                } else {
                    if (isTopic) {
                        if (first_unread_id == 0) {
                            for (int i =  messArr.size() - 1; i >= 0; i--) {
                                if (messArr.get(i).getId() > threadMaxInboxReadId) {
                                    first_unread_id = messArr.get(i).getId();
                                    break;
                                }
                            }
                        }
                    } else {
                        first_unread_id = fnid;
                    }
                    if (!chatWasReset) {
                        unread_to_load = (Integer) args[6];
                    }
                }
            } else if (!chatWasReset && startLoadFromMessageId != 0 && (load_type == 3 || load_type == 4)) {
                last_message_id = (Integer) args[5];
            } else if (did == 777000 && load_type == 2) {
                int unreadCount = (Integer) args[6];
                unreadCount--;
                if (unreadCount > 0 && unreadCount < messArr.size() - 1) {
                    first_unread_id = messArr.get(unreadCount).messageOwner.id;
                }
            }
            if (isThreadChat() && threadUnreadMessagesCount != 0) {
                unread_to_load = threadUnreadMessagesCount;
                threadUnreadMessagesCount = 0;
            }
            int newRowsCount = 0;

            if (load_type != 0 && (isThreadChat() && !isTopic && first_unread_id != 0 || startLoadFromMessageId != 0 || last_message_id != 0)) {
                forwardEndReached[loadIndex] = false;
                hideForwardEndReached = false;
            }
            if ((load_type == 1 || load_type == 3) && loadIndex == 1) {
                endReached[0] = cacheEndReached[0] = true;
                forwardEndReached[0] = false;
                hideForwardEndReached = false;
                minMessageId[0] = 0;
                checkDispatchHideSkeletons(true);
            }
            if (chatMode == MODE_SCHEDULED) {
                endReached[0] = cacheEndReached[0] = true;
                forwardEndReached[0] = forwardEndReached[0] = true;
            }
            if ((!isThreadChat() || isTopic) && ChatObject.isChannel(currentChat) && !getMessagesController().dialogs_dict.containsKey(dialog_id) && load_type == 2 && loadIndex == 0) {
                forwardEndReached[0] = false;
                hideForwardEndReached = true;
            }

            if (loadsCount == 1 && messArr.size() > 20) {
                loadsCount++;
            }
            boolean isFirstLoading = firstLoading;
            if (firstLoading) {
                if (!forwardEndReached[loadIndex]) {
                    messages.clear();
                    messagesByDays.clear();
                    groupedMessagesMap.clear();
                    threadMessageAdded = false;
                    for (int a = 0; a < 2; a++) {
                        messagesDict[a].clear();
                        if (currentEncryptedChat == null) {
                            maxMessageId[a] = Integer.MAX_VALUE;
                            minMessageId[a] = Integer.MIN_VALUE;
                        } else {
                            maxMessageId[a] = Integer.MIN_VALUE;
                            minMessageId[a] = Integer.MAX_VALUE;
                        }
                        maxDate[a] = Integer.MIN_VALUE;
                        minDate[a] = 0;
                    }
                }
                firstLoading = false;
                AndroidUtilities.runOnUIThread(() -> {
                    getNotificationCenter().runDelayedNotifications();
                    resumeDelayedFragmentAnimation();
                    AndroidUtilities.cancelRunOnUIThread(fragmentTransitionRunnable);
                    fragmentTransitionRunnable.run();
                });
            }

            if (isThreadChat() && !isTopic && (load_type == 2 || load_type == 3) && !isCache) {
                if (load_type == 3 && scrollToThreadMessage) {
                    startLoadFromMessageId = threadMessageId;
                }
                int beforMax = 0;
                int afterMax = 0;
                boolean hasMaxId = false;
                for (int a = 0, N = messArr.size(); a < N; a++) {
                    MessageObject message = messArr.get(a);
                    int mid = message.getId();
                    if (mid == loaded_max_id) {
                        hasMaxId = true;
                    }
                    if (mid > loaded_max_id) {
                        afterMax++;
                    } else {
                        beforMax++;
                    }
                }
                int num;
                if (load_type == 2) {
                    num = 10;
                } else {
                    num = count / 2;
                }
                if (hasMaxId) {
                    num++;
                }
                if (beforMax < num) {
                    endReached[0] = true;
                    checkDispatchHideSkeletons(true);
                }
                if (!chatWasReset && afterMax < count - num) {
                    forwardEndReached[0] = true;
                }
            }
            if (chatMode == MODE_PINNED) {
                endReached[loadIndex] = true;
            }

            if (load_type == 0 && forwardEndReached[0] && !pendingSendMessages.isEmpty()) {
                for (int a = 0, N = messArr.size(); a < N; a++) {
                    MessageObject existing = pendingSendMessagesDict.get(messArr.get(a).getId());
                    if (existing != null) {
                        pendingSendMessagesDict.remove(existing.getId());
                        pendingSendMessages.remove(existing);
                    }
                }
                if (!pendingSendMessages.isEmpty()) {
                    int pasteIndex = 0;
                    int date = pendingSendMessages.get(0).messageOwner.date;
                    if (!messArr.isEmpty()) {
                        if (date >= messArr.get(0).messageOwner.date) {
                            pasteIndex = 0;
                        } else if (date <= messArr.get(messArr.size() - 1).messageOwner.date) {
                            pasteIndex = messArr.size();
                        } else {
                            for (int a = 0, N = messArr.size(); a < N - 1; a++) {
                                if (messArr.get(a).messageOwner.date >= date && messArr.get(a + 1).messageOwner.date <= date) {
                                    pasteIndex = a + 1;
                                }
                            }
                        }
                    }
                    messArr = new ArrayList<>(messArr);
                    messArr.addAll(pasteIndex, pendingSendMessages);
                    pendingSendMessages.clear();
                    pendingSendMessagesDict.clear();
                }
            }

            if (!isTopic && !threadMessageAdded && isThreadChat() && (load_type == 0 && messArr.size() < count || (load_type == 2 || load_type == 3) && endReached[0])) {
                TLRPC.Message msg = new TLRPC.TL_message();
                if (threadMessageObject.getRepliesCount() == 0) {
                    if (isComments) {
                        msg.message = LocaleController.getString("NoComments", R.string.NoComments);
                    } else {
                        msg.message = LocaleController.getString("NoReplies", R.string.NoReplies);
                    }
                } else {
                    msg.message = LocaleController.getString("DiscussionStarted", R.string.DiscussionStarted);
                }
                msg.id = 0;
                msg.date = threadMessageObject.messageOwner.date;
                replyMessageHeaderObject = new MessageObject(currentAccount, msg, false, false);
                replyMessageHeaderObject.type = 10;
                replyMessageHeaderObject.contentType = 1;
                replyMessageHeaderObject.isDateObject = true;
                replyMessageHeaderObject.stableId = lastStableId++;
                messArr.add(replyMessageHeaderObject);
                updateReplyMessageHeader(false);

                messArr.addAll(threadMessageObjects);

                count += 2;
                threadMessageAdded = true;
            }
            if (load_type == 1) {
                Collections.reverse(messArr);
            }
            if (currentEncryptedChat == null) {
                getMediaDataController().loadReplyMessagesForMessages(messArr, dialog_id, chatMode == MODE_SCHEDULED, 0, null);
            }
            int approximateHeightSum = 0;
            if (!chatWasReset && (load_type == 2 || load_type == 1) && messArr.isEmpty() && !isCache) {
                forwardEndReached[0] = true;
            }
            LongSparseArray<MessageObject.GroupedMessages> newGroups = null;
            LongSparseArray<MessageObject.GroupedMessages> changedGroups = null;
            MediaController mediaController = MediaController.getInstance();
            TLRPC.MessageAction dropPhotoAction = null;
            boolean createdWas = false;
            boolean moveCurrentDateObject = false;
            boolean scrolledToUnread = false;
            for (int a = 0, N = messArr.size(); a < N; a++) {
                MessageObject obj = messArr.get(N - a - 1);
                TLRPC.MessageAction action = obj.messageOwner.action;
                if (a == 0 && action instanceof TLRPC.TL_messageActionChatCreate) {
                    createdWas = true;
                } else if (!createdWas) {
                    break;
                } else if (a < 2 && action instanceof TLRPC.TL_messageActionChatEditPhoto) {
                    dropPhotoAction = action;
                }
            }
            //遍历历史消息
            for (int a = 0; a < messArr.size(); a++) {
                MessageObject obj = messArr.get(a);
                if (obj.replyMessageObject != null) {
                    repliesMessagesDict.put(obj.replyMessageObject.getId(), obj.replyMessageObject);
                    addReplyMessageOwner(obj, 0);
                }
                int messageId = obj.getId();
                if (threadMessageId != 0) {
                    if (messageId <= (obj.isOut() ? threadMaxOutboxReadId : threadMaxInboxReadId)) {
                        obj.setIsRead();
                    }
                }
                approximateHeightSum += obj.getApproximateHeight();
                if (currentUser != null) {
                    if (currentUser.self) {
                        obj.messageOwner.out = true;
                    }
                    if (chatMode != MODE_SCHEDULED && (currentUser.bot && obj.isOut() || currentUser.id == currentUserId)) {
                        obj.setIsRead();
                    }
                }
                if (messagesDict[loadIndex].indexOfKey(messageId) >= 0) {
                    continue;
                }
                if (threadMessageId != 0 && obj.messageOwner instanceof TLRPC.TL_messageEmpty) {
                    continue;
                }
                if (getTopicId() != 0 && obj.messageOwner.action instanceof TLRPC.TL_messageActionTopicCreate) {
                    if (obj.isUnread()) {
                        obj.setIsRead();
                        newUnreadMessageCount--;
                        if (newUnreadMessageCount < 0) {
                            newUnreadMessageCount = 0;
                        }
                        getMessagesStorage().updateRepliesMaxReadId(replyOriginalChat.id, replyOriginalMessageId, obj.getId(), newUnreadMessageCount, true);
                    }
                    endReached[0] = true;
                    continue;
                }
                if (currentEncryptedChat != null && obj.messageOwner.stickerVerified == 0) {
                    getMediaDataController().verifyAnimatedStickerMessage(obj.messageOwner);
                }
                addToPolls(obj, null);
                if (isSecretChat()) {
                    checkSecretMessageForLocation(obj);
                }
                if (mediaController.isPlayingMessage(obj)) {
                    MessageObject player = mediaController.getPlayingMessageObject();
                    obj.audioProgress = player.audioProgress;
                    obj.audioProgressSec = player.audioProgressSec;
                    obj.audioPlayerDuration = player.audioPlayerDuration;
                }
                if (loadIndex == 0 && ChatObject.isChannel(currentChat) && messageId == 1) {
                    endReached[loadIndex] = true;
                    cacheEndReached[loadIndex] = true;
                }
                if (messageId > 0) {
                    maxMessageId[loadIndex] = Math.min(messageId, maxMessageId[loadIndex]);
                    minMessageId[loadIndex] = Math.max(messageId, minMessageId[loadIndex]);
                } else if (currentEncryptedChat != null) {
                    maxMessageId[loadIndex] = Math.max(messageId, maxMessageId[loadIndex]);
                    minMessageId[loadIndex] = Math.min(messageId, minMessageId[loadIndex]);
                }
                if (obj.messageOwner.date != 0) {
                    maxDate[loadIndex] = Math.max(maxDate[loadIndex], obj.messageOwner.date);
                    if (minDate[loadIndex] == 0 || obj.messageOwner.date < minDate[loadIndex]) {
                        minDate[loadIndex] = obj.messageOwner.date;
                    }
                }

                if (!chatWasReset && messageId != 0 && messageId == last_message_id) {
                    forwardEndReached[loadIndex] = true;
                }

                TLRPC.MessageAction action = obj.messageOwner.action;
                if (obj.type < 0 || loadIndex == 1 && action instanceof TLRPC.TL_messageActionChatMigrateTo) {
                    continue;
                }

                if (currentChat != null && currentChat.creator && (action instanceof TLRPC.TL_messageActionChatCreate || dropPhotoAction != null && action == dropPhotoAction)) {
                    continue;
                }
                if (obj.messageOwner.action instanceof TLRPC.TL_messageActionChannelMigrateFrom) {
                    continue;
                }

                if (needAnimateToMessage != null && needAnimateToMessage.getId() == messageId && messageId < 0 && chatMode != MODE_SCHEDULED) {
                    obj = needAnimateToMessage;
                    animatingMessageObjects.add(obj);
                    needAnimateToMessage = null;
                }

                MessageObject oldMessage = messagesDict[loadIndex].get(messageId);
                messagesDict[loadIndex].put(messageId, obj);
                ArrayList<MessageObject> dayArray = messagesByDays.get(obj.dateKey);

                if (dayArray == null) {
                    dayArray = new ArrayList<>();
                    messagesByDays.put(obj.dateKey, dayArray);
                    TLRPC.Message dateMsg = new TLRPC.TL_message();
                    if (chatMode == MODE_SCHEDULED) {
                        if (obj.messageOwner.date == 0x7ffffffe) {
                            dateMsg.message = LocaleController.getString("MessageScheduledUntilOnline", R.string.MessageScheduledUntilOnline);
                        } else {
                            dateMsg.message = LocaleController.formatString("MessageScheduledOn", R.string.MessageScheduledOn, LocaleController.formatDateChat(obj.messageOwner.date, true));
                        }
                    } else {
                        dateMsg.message = LocaleController.formatDateChat(obj.messageOwner.date);
                    }
                    dateMsg.id = 0;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(((long) obj.messageOwner.date) * 1000);
                    calendar.set(Calendar.HOUR_OF_DAY, 0);
                    calendar.set(Calendar.MINUTE, 0);
                    dateMsg.date = (int) (calendar.getTimeInMillis() / 1000);
                    MessageObject dateObj = new MessageObject(currentAccount, dateMsg, false, false);
                    dateObj.type = MessageObject.TYPE_DATE;
                    dateObj.contentType = 1;
                    dateObj.isDateObject = true;
                    dateObj.stableId = lastStableId++;
                    if (load_type == 1) {
                        messages.add(0, dateObj);
                    } else {
                        //核心添加历史消息
                        messages.add(dateObj);
                    }
                    newRowsCount++;
                } else {
                    if (!moveCurrentDateObject && !messages.isEmpty() && messages.get(messages.size() - 1).isDateObject) {
                        messages.get(messages.size() - 1).stableId = lastStableId++;
                        moveCurrentDateObject = true;
                    }
                }

                if (obj.hasValidGroupId()) {
                    MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(obj.getGroupIdForUse());
                    if (groupedMessages != null) {
                        if (messages.size() > 1) {
                            MessageObject previous;
                            if (load_type == 1) {
                                previous = messages.get(0);
                            } else {
                                previous = messages.get(messages.size() - 2);
                            }
                            if (previous.getGroupIdForUse() == obj.getGroupIdForUse()) {
                                if (previous.localGroupId != 0) {
                                    obj.localGroupId = previous.localGroupId;
                                    groupedMessages = groupedMessagesMap.get(previous.localGroupId);
                                }
                            } else if (previous.getGroupIdForUse() != obj.getGroupIdForUse()) {
                                obj.localGroupId = Utilities.random.nextLong();
                                groupedMessages = null;
                            }
                        }
                    }
                    if (groupedMessages == null) {
                        groupedMessages = new MessageObject.GroupedMessages();
                        groupedMessages.groupId = obj.getGroupId();
                        groupedMessagesMap.put(groupedMessages.groupId, groupedMessages);
                    } else if (newGroups == null || newGroups.indexOfKey(obj.getGroupId()) < 0) {
                        if (changedGroups == null) {
                            changedGroups = new LongSparseArray<>();
                        }
                        changedGroups.put(obj.getGroupId(), groupedMessages);
                    }
                    if (newGroups == null) {
                        newGroups = new LongSparseArray<>();
                    }
                    newGroups.put(groupedMessages.groupId, groupedMessages);
                    if (load_type == 1) {
                        groupedMessages.messages.add(obj);
                    } else {
                        groupedMessages.messages.add(0, obj);
                    }
                } else if (obj.getGroupIdForUse() != 0) {
                    obj.messageOwner.grouped_id = 0;
                    obj.localSentGroupId = 0;
                }

                newRowsCount++;
                dayArray.add(obj);
                if (oldMessage != null) {
                    obj.stableId =  oldMessage.stableId;
                } else {
                    obj.stableId = lastStableId++;
                }
                getMessagesController().getTranslateController().checkTranslation(obj, false);
                if (load_type == 1) {
                    messages.add(0, obj);
                } else {
                    messages.get(messages.size() - 1).stableId = lastStableId++;
                    messages.add(messages.size() - 1, obj);
                }

                MessageObject prevObj;
                if (currentEncryptedChat == null) {
                    if (createUnreadMessageAfterId != 0 && load_type != 1 && a + 1 < messArr.size()) {
                        prevObj = messArr.get(a + 1);
                        if (obj.isOut() && !obj.messageOwner.from_scheduled || prevObj.getId() >= createUnreadMessageAfterId) {
                            prevObj = null;
                        }
                    } else {
                        prevObj = null;
                    }
                } else {
                    if (createUnreadMessageAfterId != 0 && load_type != 1 && a - 1 >= 0) {
                        prevObj = messArr.get(a - 1);
                        if (obj.isOut() && !obj.messageOwner.from_scheduled || prevObj.getId() >= createUnreadMessageAfterId) {
                            prevObj = null;
                        }
                    } else {
                        prevObj = null;
                    }
                }
                if (load_type == 2 && messageId != 0 && messageId == first_unread_id) {
                    if ((approximateHeightSum > AndroidUtilities.displaySize.y / 2 || isThreadChat()) || !forwardEndReached[0]) {
                        if (!isThreadChat() || threadMaxInboxReadId != 0) {
                            TLRPC.Message dateMsg = new TLRPC.TL_message();
                            dateMsg.message = "";
                            dateMsg.id = 0;
                            MessageObject dateObj = new MessageObject(currentAccount, dateMsg, false, false);
                            dateObj.type = MessageObject.TYPE_LOADING;
                            dateObj.contentType = 2;
                            dateObj.stableId = lastStableId++;
                            messages.add(messages.size() - 1, dateObj);
                            unreadMessageObject = dateObj;
                            scrollToMessage = unreadMessageObject;
                        } else {
                            scrollToMessage = obj;
                        }
                        scrollToMessagePosition = -10000;
                        scrolledToUnread = true;
                        newRowsCount++;
                    }
                } else if ((load_type == 3 || load_type == 4) && (startLoadFromMessageId < 0 && messageId == startLoadFromMessageId || startLoadFromMessageId > 0 && messageId > 0 && messageId <= startLoadFromMessageId)) {
                    removeSelectedMessageHighlight();
                    if (needSelectFromMessageId && messageId == startLoadFromMessageId) {
                        highlightMessageId = messageId;
                    }
                    if (showScrollToMessageError && messageId != startLoadFromMessageId) {
                        BulletinFactory.of(this).createErrorBulletin(LocaleController.getString("MessageNotFound", R.string.MessageNotFound), themeDelegate).show();
                    }
                    scrollToMessage = obj;
                    if (postponedScroll) {
                        postponedScrollMessageId = scrollToMessage.getId();
                    }
                    startLoadFromMessageId = 0;
                    if (scrollToMessagePosition == -10000) {
                        scrollToMessagePosition = -9000;
                    }
                }
                if (load_type != 2 && unreadMessageObject == null && createUnreadMessageAfterId != 0 &&
                        (currentEncryptedChat == null && (!obj.isOut() || obj.messageOwner.from_scheduled) && messageId >= createUnreadMessageAfterId || currentEncryptedChat != null && (!obj.isOut() || obj.messageOwner.from_scheduled) && messageId <= createUnreadMessageAfterId) &&
                        (load_type == 1 || prevObj != null || prevObj == null && createUnreadLoading && a == messArr.size() - 1)) {
                    TLRPC.Message dateMsg = new TLRPC.TL_message();
                    dateMsg.message = "";
                    dateMsg.id = 0;
                    MessageObject dateObj = new MessageObject(currentAccount, dateMsg, false, false);
                    dateObj.type = MessageObject.TYPE_LOADING;
                    dateObj.contentType = 2;
                    dateObj.stableId = lastStableId++;
                    if (load_type == 1) {
                        messages.add(1, dateObj);
                    } else {
                        messages.add(messages.size() - 1, dateObj);
                    }
                    unreadMessageObject = dateObj;
                    if (load_type == 3) {
                        scrollToMessage = unreadMessageObject;
                        startLoadFromMessageId = 0;
                        scrollToMessagePosition = -9000;
                    }
                    newRowsCount++;
                }
            }
            if (createUnreadLoading) {
                createUnreadMessageAfterId = 0;
            }
            if (load_type == 0 && newRowsCount == 0) {
                loadsCount--;
            }

            if (forwardEndReached[loadIndex] && loadIndex != 1) {
                first_unread_id = 0;
                last_message_id = 0;
                createUnreadMessageAfterId = 0;
            }

            if (load_type == 1) {
                if (!chatWasReset && messArr.size() != count && (!isCache || currentEncryptedChat != null || forwardEndReached[loadIndex])) {
                    forwardEndReached[loadIndex] = true;
                    if (loadIndex != 1) {
                        first_unread_id = 0;
                        last_message_id = 0;
                        createUnreadMessageAfterId = 0;
                        chatAdapter.notifyItemRemoved(chatAdapter.loadingDownRow);
                    }
                    startLoadFromMessageId = 0;
                }
                if (newRowsCount > 0) {
                    int firstVisPos = chatLayoutManager.findFirstVisibleItemPosition();
                    int lastVisPos = chatLayoutManager.findLastVisibleItemPosition();
                    int top = 0;
                    MessageObject scrollToMessageObject = null;
                    if (firstVisPos != RecyclerView.NO_POSITION) {
                        for (int i = firstVisPos; i <= lastVisPos; i++) {
                            View v = chatLayoutManager.findViewByPosition(i);
                            if (v instanceof ChatMessageCell) {
                                scrollToMessageObject = ((ChatMessageCell) v).getMessageObject();
                                top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                                break;
                            } else if (v instanceof ChatActionCell) {
                                scrollToMessageObject = ((ChatActionCell) v).getMessageObject();
                                top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                                break;
                            }
                        }
                    }

                    if (!postponedScroll) {
                        chatAdapter.notifyItemRangeInserted(1, newRowsCount);
                        if (scrollToMessageObject != null) {
                            int scrollToIndex = messages.indexOf(scrollToMessageObject);
                            if (scrollToIndex > 0) {
                                chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + scrollToIndex, top);
                            }
                        }
                    }
                }
                loadingForward = false;
            } else {
                if (messArr.size() < count && load_type != 3 && load_type != 4) {
                    if (isCache) {
                        if (currentEncryptedChat != null || loadIndex == 1 && mergeDialogId != 0 && isEnd) {
                            endReached[loadIndex] = true;
                        }
                        if (load_type != 2) {
                            cacheEndReached[loadIndex] = true;
                            //修复只从缓存加载聊天，导致缓存加载完毕一直转圈加载的问题
                            if(BuildVars.IS_CHAT_AIR && loadIndex == 0) endReached[loadIndex] = true;
                        }
                    } else if (load_type != 2 || messArr.size() == 0 && messages.isEmpty()) {
                        endReached[loadIndex] = true;
                    }
                }
                loading = false;
                if (onChatMessagesLoaded != null) {
                    onChatMessagesLoaded.run();
                    onChatMessagesLoaded = null;
                }
                loadSendAsPeers(fragmentBeginToShow);

                if (chatListView != null && chatScrollHelper != null) {
                    if (first || scrollToTopOnResume || forceScrollToTop) {
                        forceScrollToTop = false;
                        if (!postponedScroll) {
                            chatAdapter.notifyDataSetChanged(true);
                        }
                        if (isTopic && startLoadFromMessageId == getTopicId() && messArr.size() > 0 && messages.size() > 0) {
                            scrollToMessage = messages.get(messArr.size() - 1);
                        }
                        if (scrollToMessage != null) {
                            addSponsoredMessages(!isFirstLoading);
                            int yOffset;
                            boolean bottom = true;
                            if (startLoadFromMessageOffset != Integer.MAX_VALUE) {
                                yOffset = -startLoadFromMessageOffset - chatListView.getPaddingBottom();
                                startLoadFromMessageOffset = Integer.MAX_VALUE;
                            } else if (scrollToMessagePosition == -9000) {
                                yOffset = getScrollOffsetForMessage(scrollToMessage);
                                bottom = false;
                            } else if (scrollToMessagePosition == -10000) {
                                yOffset = -AndroidUtilities.dp(11);
                                if (scrolledToUnread && threadMessageId != 0) {
                                    yOffset += AndroidUtilities.dp(48);
                                }
                                bottom = false;
                            } else {
                                yOffset = scrollToMessagePosition;
                            }
                            yOffset += AndroidUtilities.dp(50); // in case pinned message view is visible
                            if (!postponedScroll) {
                                if (!messages.isEmpty()) {
                                    if (chatAdapter.loadingUpRow >= 0 && !messages.isEmpty() && (messages.get(messages.size() - 1) == scrollToMessage || messages.get(messages.size() - 2) == scrollToMessage)) {
                                        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.loadingUpRow, yOffset, bottom);
                                    } else {
                                        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + messages.indexOf(scrollToMessage), yOffset, bottom);
                                    }
                                }
                            }
                            chatListView.invalidate();
                            if (scrollToMessagePosition == -10000 || scrollToMessagePosition == -9000) {
                                canShowPagedownButton = true;
                                updatePagedownButtonVisibility(true);
                                if (unread_to_load != 0) {
                                    if (pagedownButtonCounter != null) {
                                        if (prevSetUnreadCount != newUnreadMessageCount) {
                                            pagedownButtonCounter.setCount(newUnreadMessageCount = unread_to_load, openAnimationEnded);
                                            prevSetUnreadCount = newUnreadMessageCount;
                                        }
                                    }
                                }
                            }
                            scrollToMessagePosition = -10000;
                            scrollToMessage = null;
                        } else {
                            addSponsoredMessages(!isFirstLoading);
                            moveScrollToLastMessage(true);
                        }
                        if (loaded_mentions_count != 0) {
                            showMentionDownButton(true, true);
                            if (mentiondownButtonCounter != null) {
                                mentiondownButtonCounter.setVisibility(View.VISIBLE);
                                mentiondownButtonCounter.setText(String.format("%d", newMentionsCount = loaded_mentions_count));
                            }
                        }
                    } else {
                        if (newRowsCount != 0) {
                            int firstVisPos = chatLayoutManager.findFirstVisibleItemPosition();
                            int lastVisPos = chatLayoutManager.findLastVisibleItemPosition();
                            int top = 0;
                            MessageObject scrollToMessageObject = null;
                            if (firstVisPos != RecyclerView.NO_POSITION) {
                                for (int i = firstVisPos; i <= lastVisPos; i++) {
                                    View v = chatLayoutManager.findViewByPosition(i);
                                    if (v instanceof ChatMessageCell) {
                                        scrollToMessageObject = ((ChatMessageCell) v).getMessageObject();
                                        top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                                        break;
                                    } else if (v instanceof ChatActionCell) {
                                        scrollToMessageObject = ((ChatActionCell) v).getMessageObject();
                                        top = chatListView.getMeasuredHeight() - v.getBottom() - chatListView.getPaddingBottom();
                                        break;
                                    }
                                }
                            }
                            int insertStart = chatAdapter.messagesEndRow;
                            int loadingUpRow = chatAdapter.loadingUpRow;
                            chatAdapter.updateRowsInternal();
                            if (loadingUpRow >= 0 && chatAdapter.loadingUpRow < 0) {
                                chatAdapter.notifyItemRemoved(loadingUpRow);
                            }
                            if (newRowsCount > 0) {
                                if (moveCurrentDateObject) {
                                    chatAdapter.notifyItemRemoved(insertStart - 1);
                                    chatAdapter.notifyItemRangeInserted(insertStart - 1, newRowsCount + 1);
                                } else {
                                    chatAdapter.notifyItemChanged(insertStart - 1);
                                    chatAdapter.notifyItemRangeInserted(insertStart, newRowsCount);
                                }
                            }
                            if (!postponedScroll && scrollToMessageObject != null) {
                                int scrollToIndex = messages.indexOf(scrollToMessageObject);
                                if (scrollToIndex > 0) {
                                    chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + scrollToIndex, top);
                                }
                            }
                        } else if (chatAdapter.loadingUpRow >= 0 && endReached[loadIndex] && (loadIndex == 0 && mergeDialogId == 0 || loadIndex == 1)) {
                            chatAdapter.notifyItemRemoved(chatAdapter.loadingUpRow);
                        } else {
                            chatAdapter.notifyDataSetChanged(true);
                        }
                    }

                    if (paused) {
                        scrollToTopOnResume = true;
                        if (scrollToMessage != null) {
                            scrollToTopUnReadOnResume = true;
                        }
                    }

                    if (first) {
                        if (chatListView != null) {
                            AndroidUtilities.runOnUIThread(() -> {
                                createEmptyView();
                                if (!fragmentBeginToShow) {
                                    chatListView.setAnimateEmptyView(false, 0);
                                    chatListView.setEmptyView(emptyViewContainer);
                                    chatListView.setAnimateEmptyView(true, RecyclerListView.EMPTY_VIEW_ANIMATION_TYPE_ALPHA_SCALE);
                                } else {
                                    chatListView.setEmptyView(emptyViewContainer);
                                }
                            });
                        }
                    }
                } else {
                    scrollToTopOnResume = true;
                    if (scrollToMessage != null) {
                        scrollToTopUnReadOnResume = true;
                    }
                }
            }
            if (newGroups != null) {
                for (int a = 0; a < newGroups.size(); a++) {
                    MessageObject.GroupedMessages groupedMessages = newGroups.valueAt(a);
                    groupedMessages.calculate();
                    if (chatAdapter != null && changedGroups != null && changedGroups.indexOfKey(newGroups.keyAt(a)) >= 0) {
                        MessageObject messageObject = groupedMessages.messages.get(groupedMessages.messages.size() - 1);
                        int idx = messages.indexOf(messageObject);
                        if (idx >= 0) {
                            if (chatListItemAnimator != null) {
                                chatListItemAnimator.groupWillChanged(groupedMessages);
                            }
                            chatAdapter.notifyItemRangeChanged(idx + chatAdapter.messagesStartRow, groupedMessages.messages.size());
                        }
                    }
                }
            }

            if (first && messages.size() > 0) {
                first = false;
                if (isThreadChat()) {
                    invalidateMessagesVisiblePart();
                }
                if (startLoadFromDate != 0) {
                    int dateObjectIndex = -1;
                    int closeDateObjectIndex = -1;
                    int closeDateDiff = 0;
                    for (int i = 0; i < messages.size(); i++) {
                        if (messages.get(i).isDateObject && Math.abs(startLoadFromDate - messages.get(i).messageOwner.date) <= 100) {
                            dateObjectIndex = i;
                            break;
                        }
                        if (messages.get(i).isDateObject) {
                            int timeDiff = Math.abs(startLoadFromDate - messages.get(i).messageOwner.date);
                            if (closeDateObjectIndex == -1 || timeDiff < closeDateDiff) {
                                closeDateDiff = timeDiff;
                                closeDateObjectIndex = i;
                            }
                        }
                    }
                    if (dateObjectIndex >= 0) {
                        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + dateObjectIndex, (int) (AndroidUtilities.dp(4)), false);
                    } else if (closeDateObjectIndex >= 0) {
                        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + closeDateObjectIndex, chatListView.getMeasuredHeight() / 2 - AndroidUtilities.dp(24), false);
                    }
                }
            }
            if (messages.isEmpty() && currentEncryptedChat == null && currentUser != null && currentUser.bot && botUser == null) {
                botUser = "";
                updateBottomOverlay();
            }

            if (newRowsCount == 0 && (mergeDialogId != 0 && loadIndex == 0 || currentEncryptedChat != null && !endReached[0])) {
                first = true;
                if (chatListView != null) {
                    chatListView.setEmptyView(null);
                }
                if (emptyViewContainer != null) {
                    emptyViewContainer.setVisibility(View.INVISIBLE);
                }
            } else {
                showProgressView(false);
            }

            if (newRowsCount == 0 && mergeDialogId != 0 && loadIndex == 0) {
                getNotificationCenter().updateAllowedNotifications(transitionAnimationIndex, new int[]{NotificationCenter.chatInfoDidLoad, NotificationCenter.groupCallUpdated, NotificationCenter.dialogsNeedReload, NotificationCenter.scheduledMessagesUpdated,
                        NotificationCenter.closeChats, NotificationCenter.messagesDidLoad, NotificationCenter.botKeyboardDidLoad, NotificationCenter.userInfoDidLoad, NotificationCenter.pinnedInfoDidLoad, NotificationCenter.needDeleteDialog/*, NotificationCenter.botInfoDidLoad*/});
            }
            if (showDateAfter) {
                showFloatingDateView(false);
            }
            addSponsoredMessages(!isFirstLoading);
            checkScrollForLoad(false);

            if (postponedScroll) {
                chatAdapter.notifyDataSetChanged(true);
                if (progressDialog != null) {
                    progressDialog.dismiss();
                }
                resetProgressDialogLoading();
                updatePinnedListButton(false);
                if (postponedScrollMessageId == 0) {
                    chatScrollHelperCallback.scrollTo = null;
                    chatScrollHelperCallback.lastBottom = true;
                    chatScrollHelperCallback.lastItemOffset = 0;
                    chatScrollHelperCallback.lastPadding = (int) chatListViewPaddingTop;
                    chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = 0, chatScrollHelperCallback.offset = 0, chatScrollHelperCallback.bottom = true, true);
                } else {
                    MessageObject object = messagesDict[loadIndex].get(postponedScrollMessageId);
                    if (object != null) {
                        MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(object.getGroupId());
                        if (object.getGroupId() != 0 && groupedMessages != null) {
                            MessageObject primary = groupedMessages.findPrimaryMessageObject();
                            if (primary != null) {
                                object = primary;
                            }
                        }
                    }

                    if (object != null) {
                        int k = messages.indexOf(object);
                        if (k >= 0) {
                            int fromPosition = chatLayoutManager.findFirstVisibleItemPosition();
                            highlightMessageId = object.getId();
                            int direction;
                            if (postponedScrollMinMessageId != 0) {
                                if (highlightMessageId < 0 && postponedScrollMinMessageId < 0) {
                                    direction = highlightMessageId < postponedScrollMinMessageId ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                                } else {
                                    direction = highlightMessageId > postponedScrollMinMessageId ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                                }
                            } else {
                                direction = fromPosition > k ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                            }
                            chatScrollHelper.setScrollDirection(direction);

                            if (!needSelectFromMessageId) {
                                removeSelectedMessageHighlight();
                            }

                            int yOffset = getScrollOffsetForMessage(object);
                            chatScrollHelperCallback.scrollTo = object;
                            chatScrollHelperCallback.lastBottom = false;
                            chatScrollHelperCallback.lastItemOffset = yOffset;
                            chatScrollHelperCallback.lastPadding = (int) chatListViewPaddingTop;
                            chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = chatAdapter.messagesStartRow + k, chatScrollHelperCallback.offset = yOffset, chatScrollHelperCallback.bottom = false, true);
                        }
                    }
                }
            }
            chatWasReset = false;
        } else if (id == NotificationCenter.invalidateMotionBackground) {
            if (chatListView != null) {
                chatListView.invalidateViews();
            }
            if (messageEnterTransitionContainer != null) {
                messageEnterTransitionContainer.invalidate();
            }
        } else if (id == NotificationCenter.emojiLoaded) {
            if (chatListView != null) {
                chatListView.invalidateViews();
            }
            if (replyObjectTextView != null) {
                replyObjectTextView.invalidate();
            }
            if (alertTextView != null) {
                alertTextView.invalidate();
            }
            for (int a = 0; a < 2; a++) {
                if (pinnedMessageTextView[a] != null) {
                    pinnedMessageTextView[a].invalidate();
                }
            }
            if (mentionContainer != null) {
                mentionContainer.getListView().invalidateViews();
            }
            if (messagesSearchListView != null) {
                messagesSearchListView.invalidateViews();
            }
            if (undoView != null) {
                undoView.invalidate();
            }
            if (chatActivityEnterView != null) {
                EditTextBoldCursor editText = chatActivityEnterView.getEditField();
                if (editText != null) {
                    int color = editText.getCurrentTextColor();
                    editText.setTextColor(0xffffffff);
                    editText.setTextColor(color);
                }
            }
            if (pinnedMessageButton[0] != null) {
                pinnedMessageButton[0].invalidate();
            }
            if (pinnedMessageButton[1] != null) {
                pinnedMessageButton[1].invalidate();
            }
        } else if (id == NotificationCenter.didUpdateConnectionState) {
            int state = ConnectionsManager.getInstance(account).getConnectionState();
            if (state == ConnectionsManager.ConnectionStateConnected) {
                checkAutoDownloadMessages(false);
            }
        } else if (id == NotificationCenter.chatOnlineCountDidLoad) {
            Long chatId = (Long) args[0];
            if (chatInfo == null || currentChat == null || currentChat.id != chatId) {
                return;
            }
            chatInfo.online_count = (Integer) args[1];
            if (avatarContainer != null) {
                avatarContainer.updateOnlineCount();
                avatarContainer.updateSubtitle();
            }
        } else if (id == NotificationCenter.updateDefaultSendAsPeer) {
            long chatId = (long) args[0];
            if (chatId == dialog_id) {
                chatActivityEnterView.updateSendAsButton(true);
            }
        } else if (id == NotificationCenter.updateInterfaces) {
            int updateMask = (Integer) args[0];
            if ((updateMask & MessagesController.UPDATE_MASK_NAME) != 0 || (updateMask & MessagesController.UPDATE_MASK_CHAT_NAME) != 0 || (updateMask & MessagesController.UPDATE_MASK_EMOJI_STATUS) != 0) {
                if (currentChat != null) {
                    TLRPC.Chat chat = getMessagesController().getChat(currentChat.id);
                    if (chat != null) {
                        currentChat = chat;
                    }
                } else if (currentUser != null) {
                    TLRPC.User user = getMessagesController().getUser(currentUser.id);
                    if (user != null) {
                        currentUser = user;
                    }
                }
                updateTitle(true);
            }
            boolean updateSubtitle = false;
            if (!isThreadChat() && ((updateMask & MessagesController.UPDATE_MASK_CHAT_MEMBERS) != 0 || (updateMask & MessagesController.UPDATE_MASK_STATUS) != 0)) {
                if (currentChat != null && avatarContainer != null) {
                    avatarContainer.updateOnlineCount();
                }
                updateSubtitle = true;
            }
            if ((updateMask & MessagesController.UPDATE_MASK_AVATAR) != 0 || (updateMask & MessagesController.UPDATE_MASK_CHAT_AVATAR) != 0 || (updateMask & MessagesController.UPDATE_MASK_NAME) != 0) {
                checkAndUpdateAvatar();
                updateVisibleRows();
            }
            if ((updateMask & MessagesController.UPDATE_MASK_USER_PRINT) != 0) {
                updateSubtitle = true;
            }
            if ((updateMask & MessagesController.UPDATE_MASK_CHAT) != 0 && currentChat != null) {
                boolean fwdBefore = getMessagesController().isChatNoForwards(currentChat);
                TLRPC.Chat chat = getMessagesController().getChat(currentChat.id);
                if (chat == null) {
                    return;
                }
                currentChat = chat;
                boolean fwdChanged = getMessagesController().isChatNoForwards(currentChat) != fwdBefore;
                updateSubtitle = !isThreadChat();
                updateBottomOverlay();
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setDialogId(dialog_id, currentAccount);
                }
                if (flagSecure != null) {
                    flagSecure.invalidate();
                }
            }

            //如果updateSubtitle为true，则不需要更新，下面会更新
            updateMessageStatus(!updateSubtitle);

            if (avatarContainer != null && updateSubtitle) {
                avatarContainer.updateSubtitle(true);
            }
            if ((updateMask & MessagesController.UPDATE_MASK_USER_PHONE) != 0) {
                updateTopPanel(true);
            }
        } else if (id == NotificationCenter.didReceiveNewMessages) {
            //接收新消息
            long did = (Long) args[0];
            ArrayList<MessageObject> arr = (ArrayList<MessageObject>) args[1];
            if (did == dialog_id) {
                boolean scheduled = (Boolean) args[2];
                if (scheduled != (chatMode == MODE_SCHEDULED)) {
                    if (chatMode != MODE_SCHEDULED && !isPaused && forwardingMessages == null) {
                        if (!arr.isEmpty() && arr.get(0).getId() < 0) {
                            openScheduledMessages();
                        }
                    }
                    return;
                }
                processNewMessages(arr);
            } else if (ChatObject.isChannel(currentChat) && !currentChat.megagroup && chatInfo != null && did == -chatInfo.linked_chat_id) {
                for (int a = 0, N = arr.size(); a < N; a++) {
                    MessageObject messageObject = arr.get(a);
                    if (messageObject.isReply()) {
                        waitingForReplies.put(messageObject.getId(), messageObject);
                    }
                }
                checkWaitingForReplies();
            }
        } else if (id == NotificationCenter.didLoadSendAsPeers) {
            loadSendAsPeers(true);
        } else if (id == NotificationCenter.didLoadSponsoredMessages) {
            addSponsoredMessages(true);
        } else if (id == NotificationCenter.closeChats) {
            if (args != null && args.length > 0) {
                long did = (Long) args[0];
                if (did == dialog_id) {
                    finishFragment();
                }
            } else {
                if (AndroidUtilities.isTablet() && parentLayout != null && parentLayout.getFragmentStack().size() > 1) {
                    finishFragment();
                } else {
                    removeSelfFromStack(true);
                }
            }
        } else if (id == NotificationCenter.commentsRead) {
            long channelId = (Long) args[0];
            if (currentChat != null && currentChat.id == channelId) {
                int mid = (Integer) args[1];
                MessageObject obj = messagesDict[0].get(mid);
                if (obj != null && obj.hasReplies()) {
                    int maxReadId = (Integer) args[2];
                    if (paused) {
                        if (delayedReadRunnable != null) {
                            AndroidUtilities.cancelRunOnUIThread(delayedReadRunnable);
                            delayedReadRunnable = null;
                        }
                        obj.messageOwner.replies.read_max_id = maxReadId;
                    } else {
                        AndroidUtilities.runOnUIThread(delayedReadRunnable = () -> {
                            delayedReadRunnable = null;
                            obj.messageOwner.replies.read_max_id = maxReadId;
                        }, 500);
                    }
                }
            }
        } else if (id == NotificationCenter.changeRepliesCounter) {
            long channelId = (Long) args[0];
            if (currentChat != null && currentChat.id == channelId) {
                int mid = (Integer) args[1];
                MessageObject obj = messagesDict[0].get(mid);
                if (obj != null && obj.messageOwner.replies != null) {
                    Integer count = (Integer) args[2];
                    obj.messageOwner.replies.replies += count;
                    if (count > 0) {
                        TLRPC.Peer peer = getMessagesController().getPeer(ChatObject.getSendAsPeerId(currentChat, getMessagesController().getChatFull(currentChat.id)));
                        for (int c = 0, N = obj.messageOwner.replies.recent_repliers.size(); c < N; c++) {
                            if (MessageObject.getPeerId(obj.messageOwner.replies.recent_repliers.get(c)) == MessageObject.getPeerId(peer)) {
                                obj.messageOwner.replies.recent_repliers.remove(c);
                                break;
                            }
                        }
                        obj.messageOwner.replies.recent_repliers.add(0, peer);
                    }
                    if (obj.messageOwner.replies.replies < 0) {
                        obj.messageOwner.replies.replies = 0;
                    }
                }
            }
        } else if (id == NotificationCenter.threadMessagesRead) {
            long did = (Long) args[0];
            if (dialog_id != did) {
                return;
            }
            int threadId = (Integer) args[1];
            if (threadId != threadMessageId) {
                return;
            }
            int inbox = (Integer) args[2];
            int outbox = (Integer) args[3];
            if (inbox > threadMaxInboxReadId) {
                threadMaxInboxReadId = inbox;
                for (int a = 0, size2 = messages.size(); a < size2; a++) {
                    MessageObject obj = messages.get(a);
                    int messageId = obj.getId();
                    if (!obj.isOut() && messageId > 0 && messageId <= threadMaxInboxReadId) {
                        if (!obj.isUnread()) {
                            break;
                        }
                        obj.setIsRead();
                        if (chatAdapter != null) {
                            chatAdapter.invalidateRowWithMessageObject(obj);
                        }
                    }
                }
            }
            if (outbox > threadMaxOutboxReadId) {
                threadMaxOutboxReadId = outbox;
                for (int a = 0, size2 = messages.size(); a < size2; a++) {
                    MessageObject obj = messages.get(a);
                    int messageId = obj.getId();
                    if (obj.isOut() && messageId > 0 && messageId <= threadMaxOutboxReadId) {
                        if (!obj.isUnread()) {
                            break;
                        }
                        obj.setIsRead();
                        if (chatAdapter != null) {
                            chatAdapter.updateRowWithMessageObject(obj, false);
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.messagesRead) {
            if (chatMode == MODE_SCHEDULED) {
                return;
            }
            LongSparseIntArray inbox = (LongSparseIntArray) args[0];
            LongSparseIntArray outbox = (LongSparseIntArray) args[1];
            boolean updated = false;
            if (inbox != null) {
                for (int b = 0, size = inbox.size(); b < size; b++) {
                    long key = inbox.keyAt(b);
                    long messageId = inbox.get(key);
                    if (key != dialog_id) {
                        continue;
                    }
                    for (int a = 0, size2 = messages.size(); a < size2; a++) {
                        MessageObject obj = messages.get(a);
                        if (!obj.isOut() && obj.getId() > 0 && obj.getId() <= (int) messageId) {
                            if (!obj.isUnread()) {
                                break;
                            }
                            obj.setIsRead();
                            if (chatAdapter != null) {
                                chatAdapter.invalidateRowWithMessageObject(obj);
                            }
                            updated = true;
                            newUnreadMessageCount--;
                        }
                    }
                    removeUnreadPlane(false);
                    break;
                }
            }
            if (updated) {
                if (newUnreadMessageCount < 0) {
                    newUnreadMessageCount = 0;
                }
                if (pagedownButtonCounter != null) {
                    if (prevSetUnreadCount != newUnreadMessageCount) {
                        prevSetUnreadCount = newUnreadMessageCount;
                        pagedownButtonCounter.setCount(newUnreadMessageCount, true);
                    }
                }
            }
            if (outbox != null) {
                for (int b = 0, size = outbox.size(); b < size; b++) {
                    long key = outbox.keyAt(b);
                    int messageId = (int) outbox.get(key);
                    if (key != dialog_id) {
                        continue;
                    }
                    for (int a = 0, size2 = messages.size(); a < size2; a++) {
                        MessageObject obj = messages.get(a);
                        if (obj.isOut() && obj.getId() > 0 && obj.getId() <= messageId) {
                            obj.setIsRead();
                            if (chatAdapter != null) {
                                chatAdapter.invalidateRowWithMessageObject(obj);
                            }
                        }
                    }
                    break;
                }
            }
        } else if (id == NotificationCenter.historyCleared) {
            long did = (Long) args[0];
            if (did != dialog_id) {
                return;
            }
            int max_id = (Integer) args[1];
            if (!pinnedMessageIds.isEmpty()) {
                pinnedMessageIds.clear();
                pinnedMessageObjects.clear();
                currentPinnedMessageId = 0;
                loadedPinnedMessagesCount = 0;
                totalPinnedMessagesCount = 0;
                updatePinnedMessageView(true);
            }

            boolean updated = false;
            for (int b = 0; b < messages.size(); b++) {
                MessageObject obj = messages.get(b);
                int mid = obj.getId();
                if (mid <= 0 || mid > max_id) {
                    continue;
                }
                messages.remove(b);
                b--;
                messagesDict[0].remove(mid);
                ArrayList<MessageObject> dayArr = messagesByDays.get(obj.dateKey);
                if (dayArr != null) {
                    dayArr.remove(obj);
                    if (dayArr.isEmpty()) {
                        messagesByDays.remove(obj.dateKey);
                        if (b >= 0 && b < messages.size()) {
                            messages.remove(b);
                            b--;
                        }
                    }
                }
                updated = true;
            }

            if (messages.isEmpty()) {
                if (!endReached[0] && !loading) {
                    showProgressView(false);
                    if (chatListView != null) {
                        chatListView.setEmptyView(null);
                    }
                    if (currentEncryptedChat == null) {
                        maxMessageId[0] = maxMessageId[1] = Integer.MAX_VALUE;
                        minMessageId[0] = minMessageId[1] = Integer.MIN_VALUE;
                    } else {
                        maxMessageId[0] = maxMessageId[1] = Integer.MIN_VALUE;
                        minMessageId[0] = minMessageId[1] = Integer.MAX_VALUE;
                    }
                    maxDate[0] = maxDate[1] = Integer.MIN_VALUE;
                    minDate[0] = minDate[1] = 0;
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, 0, !cacheEndReached[0], minDate[0], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    loading = true;
                } else {
                    if (botButtons != null) {
                        botButtons = null;
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.setButtons(null, false);
                        }
                    }
                    if (currentEncryptedChat == null && currentUser != null && currentUser.bot && botUser == null) {
                        botUser = "";
                        updateBottomOverlay();
                    }
                }
            }
            canShowPagedownButton = false;
            updatePagedownButtonVisibility(true);
            showMentionDownButton(false, true);
            removeUnreadPlane(true);
            if (updated && chatAdapter != null) {
                chatAdapter.notifyDataSetChanged(false);
            }
        } else if (id == NotificationCenter.messagesDeleted) {
            boolean scheduled = (Boolean) args[2];
            if (scheduled != (chatMode == MODE_SCHEDULED)) {
                return;
            }
            ArrayList<Integer> markAsDeletedMessages = (ArrayList<Integer>) args[0];
            long channelId = (Long) args[1];
            processDeletedMessages(markAsDeletedMessages, channelId);
            updateMessageStatus(true);
        } else if (id == NotificationCenter.messageReceivedByServer) {
            //接收来自服务器的消息
            Boolean scheduled = (Boolean) args[6];
            if (scheduled != (chatMode == MODE_SCHEDULED)) {
                return;
            }
            Integer msgId = (Integer) args[0];
            MessageObject obj = messagesDict[0].get(msgId);
            //消息收到回执
            if (isThreadChat() && pendingSendMessagesDict.size() > 0) {
                 MessageObject object = pendingSendMessagesDict.get(msgId);
                 if (object != null) {
                     Integer newMsgId = (Integer) args[1];
                     pendingSendMessagesDict.put(newMsgId, object);
                 }
            }
            if (obj != null) {
                checkChecksHint();
                if (obj.shouldRemoveVideoEditedInfo) {
                    obj.videoEditedInfo = null;
                    obj.shouldRemoveVideoEditedInfo = false;
                }
                Integer newMsgId = (Integer) args[1];
                if (!newMsgId.equals(msgId) && messagesDict[0].indexOfKey(newMsgId) >= 0) {
                    MessageObject removed = messagesDict[0].get(msgId);
                    messagesDict[0].remove(msgId);
                    if (removed != null) {
                        int index = messages.indexOf(removed);
                        messages.remove(index);
                        ArrayList<MessageObject> dayArr = messagesByDays.get(removed.dateKey);
                        dayArr.remove(obj);
                        if (dayArr.isEmpty()) {
                            messagesByDays.remove(obj.dateKey);
                            if (index >= 0 && index < messages.size()) {
                                messages.remove(index);
                            }
                        }
                        if (chatAdapter != null) {
                            chatAdapter.notifyDataSetChanged(true);
                        }
                    }
                    return;
                }
                TLRPC.Message newMsgObj = (TLRPC.Message) args[2];
                Long grouped_id;
                if (args.length >= 4) {
                    grouped_id = (Long) args[4];
                } else {
                    grouped_id = 0L;
                }
                boolean mediaUpdated = false;
                boolean updatedForward = false;
                if (newMsgObj != null) {
                    try {
                        updatedForward = obj.isForwarded() && (obj.messageOwner.reply_markup == null && newMsgObj.reply_markup != null || !obj.messageOwner.message.equals(newMsgObj.message));
                        mediaUpdated = updatedForward ||
                                obj.messageOwner.params != null && obj.messageOwner.params.containsKey("query_id") ||
                                newMsgObj.media != null && obj.messageOwner.media != null && !newMsgObj.media.getClass().equals(obj.messageOwner.media.getClass());
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    if (obj.getGroupId() != 0 && newMsgObj.grouped_id != 0) {
                        MessageObject.GroupedMessages oldGroup = groupedMessagesMap.get(obj.getGroupId());
                        if (oldGroup != null) {
                            groupedMessagesMap.put(newMsgObj.grouped_id, oldGroup);
                        }
                        obj.localSentGroupId = obj.messageOwner.grouped_id;
                        obj.messageOwner.grouped_id = grouped_id;
                    }
                    TLRPC.MessageFwdHeader fwdHeader = obj.messageOwner.fwd_from;
                    obj.messageOwner = newMsgObj;
                    if (fwdHeader != null && newMsgObj.fwd_from != null && !TextUtils.isEmpty(newMsgObj.fwd_from.from_name)) {
                        obj.messageOwner.fwd_from = fwdHeader;
                        obj.isOutOwnerCached = null;
                    }
                    obj.generateThumbs(true);
                    obj.setType();

                    if (newMsgObj.media instanceof TLRPC.TL_messageMediaGame) {
                        obj.applyNewText();
                    }
                }
                if (updatedForward) {
                    obj.measureInlineBotButtons();
                }
                messagesDict[0].remove(msgId);
                messagesDict[0].put(newMsgId, obj);
                obj.messageOwner.id = newMsgId;
                obj.messageOwner.send_state = MessageObject.MESSAGE_SEND_STATE_SENT;
                obj.forceUpdate = mediaUpdated;
                addReplyMessageOwner(obj, msgId);
                if (args.length >= 6) {
                    obj.applyMediaExistanceFlags((Integer) args[5]);
                }
                addToPolls(obj, null);
                ArrayList<MessageObject> messArr = new ArrayList<>();
                messArr.add(obj);
                if (currentEncryptedChat == null) {
                    getMediaDataController().loadReplyMessagesForMessages(messArr, dialog_id, chatMode == MODE_SCHEDULED, 0, null);
                }
                if (chatAdapter != null) {
                    chatAdapter.updateRowWithMessageObject(obj, false);
                }
                if (chatLayoutManager != null) {
                    if (mediaUpdated && chatLayoutManager.findFirstVisibleItemPosition() == 0) {
                        moveScrollToLastMessage(false);
                    }
                }
                if (obj == null || obj.messageOwner == null || !obj.messageOwner.silent) {
                    getNotificationsController().playOutChatSound();
                }
            }
        } else if (id == NotificationCenter.messageReceivedByAck) {
            Integer msgId = (Integer) args[0];
            MessageObject obj = messagesDict[0].get(msgId);
            if (obj != null) {
                obj.messageOwner.send_state = MessageObject.MESSAGE_SEND_STATE_SENT;
                if (chatAdapter != null) {
                    chatAdapter.updateRowWithMessageObject(obj, false);
                }
            }
        } else if (id == NotificationCenter.messageSendError) {
            Integer msgId = (Integer) args[0];
            MessageObject obj = messagesDict[0].get(msgId);
            if (obj != null) {
                obj.messageOwner.send_state = MessageObject.MESSAGE_SEND_STATE_SEND_ERROR;
                updateVisibleRows();
            }
        } else if (id == NotificationCenter.groupCallUpdated) {
            Long chatId = (Long) args[0];
            if (dialog_id == -chatId) {
                groupCall = getMessagesController().getGroupCall(currentChat.id, false);
                if (fragmentContextView != null) {
                    fragmentContextView.checkCall(openAnimationStartTime == 0 || SystemClock.elapsedRealtime() < openAnimationStartTime + 150);
                }
                checkGroupCallJoin(false);
            }
        } else if (id == NotificationCenter.didLoadChatInviter) {
            long chatId = (Long) args[0];
            if (dialog_id == -chatId && chatInviterId == 0) {
                chatInviterId = (Long) args[1];
                if (chatInfo != null) {
                    chatInfo.inviterId = chatInviterId;
                }
                updateInfoTopView(openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150);
            }
        } else if (id == NotificationCenter.chatInfoDidLoad) {
            TLRPC.ChatFull chatFull = (TLRPC.ChatFull) args[0];
            if (currentChat != null && chatFull.id == currentChat.id) {
                if (chatFull instanceof TLRPC.TL_channelFull) {
                    if (currentChat.megagroup) {
                        int lastDate = 0;
                        if (chatFull.participants != null) {
                            for (int a = 0; a < chatFull.participants.participants.size(); a++) {
                                lastDate = Math.max(chatFull.participants.participants.get(a).date, lastDate);
                            }
                        }
                        if (lastDate == 0 || Math.abs(System.currentTimeMillis() / 1000 - lastDate) > 60 * 60) {
                            getMessagesController().loadChannelParticipants(currentChat.id);
                        }
                    }
                    if (chatFull.participants == null && chatInfo != null) {
                        chatFull.participants = chatInfo.participants;
                    }
                }
                showGigagroupConvertAlert();
                long prevLinkedChatId = chatInfo != null ? chatInfo.linked_chat_id : 0;
                chatInfo = chatFull;
                groupCall = getMessagesController().getGroupCall(currentChat.id, true);
                if (ChatObject.isChannel(currentChat) && currentChat.megagroup && fragmentContextView != null) {
                    fragmentContextView.checkCall(openAnimationStartTime == 0 || SystemClock.elapsedRealtime() < openAnimationStartTime + 150);
                }
                loadSendAsPeers(fragmentBeginToShow);
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.updateSendAsButton(fragmentBeginToShow);
                    chatActivityEnterView.updateFieldHint(false);
                }
                if (chatAdapter != null) {
                    chatAdapter.notifyDataSetChanged(true);
                }
                if (prevLinkedChatId != chatInfo.linked_chat_id) {
                    if (prevLinkedChatId != 0) {
                        TLRPC.Chat chat = getMessagesController().getChat(prevLinkedChatId);
                        getMessagesController().startShortPoll(chat, classGuid, true);
                    }
                    if (chatInfo.linked_chat_id != 0) {
                        TLRPC.Chat chat = getMessagesController().getChat(chatInfo.linked_chat_id);
                        if (chat != null && chat.megagroup) {
                            getMessagesController().startShortPoll(chat, classGuid, false);
                        }
                    }
                }
                boolean animated = openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150;
                checkActionBarMenu(animated);
                if (chatInviterId == 0) {
                    fillInviterId(true);
                    updateInfoTopView(animated);
                }
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setChatInfo(chatInfo);
                }
                if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                    mentionContainer.getAdapter().setChatInfo(chatInfo);
                }
                if (!isThreadChat() || isTopic) {
                    if (avatarContainer != null) {
                        avatarContainer.updateOnlineCount();
                        avatarContainer.updateSubtitle();
                    }
                    if (!inMenuMode && !loadingPinnedMessagesList && !pinnedMessageIds.isEmpty() && chatInfo.pinned_msg_id > pinnedMessageIds.get(0)) {
                        getMediaDataController().loadPinnedMessages(dialog_id, 0, chatInfo.pinned_msg_id);
                        loadingPinnedMessagesList = true;
                    }
                }
                if (chatInfo instanceof TLRPC.TL_chatFull) {
                    hasBotsCommands = false;
                    botInfo.clear();
                    botsCount = 0;
                    URLSpanBotCommand.enabled = false;
                    for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                        TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                        TLRPC.User user = getMessagesController().getUser(participant.user_id);
                        if (user != null && user.bot) {
                            URLSpanBotCommand.enabled = true;
                            botsCount++;
                            if (!isThreadChat()) {
                                hasBotsCommands = true;
                            }
                            getMediaDataController().loadBotInfo(user.id, -chatInfo.id, true, classGuid);
                        }
                    }
                    if (chatListView != null) {
                        chatListView.invalidateViews();
                    }
                } else if (chatInfo instanceof TLRPC.TL_channelFull) {
                    hasBotsCommands = false;
                    botInfo.clear();
                    botsCount = 0;
                    URLSpanBotCommand.enabled = !chatInfo.bot_info.isEmpty() && currentChat != null && currentChat.megagroup;
                    botsCount = chatInfo.bot_info.size();
                    for (int a = 0; a < chatInfo.bot_info.size(); a++) {
                        TLRPC.BotInfo bot = chatInfo.bot_info.get(a);
                        if (!isThreadChat() && !bot.commands.isEmpty() && (!ChatObject.isChannel(currentChat) || currentChat != null && currentChat.megagroup)) {
                            hasBotsCommands = true;
                        }
                        botInfo.put(bot.user_id, bot);
                    }
                    if (chatListView != null) {
                        chatListView.invalidateViews();
                    }
                    if (!ChatObject.isChannel(currentChat) || currentChat != null && currentChat.megagroup) {
                        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                            mentionContainer.getAdapter().setBotInfo(botInfo);
                        }
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.setBotInfo(botInfo);
                        }
                    }
                }
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setBotsCount(botsCount, hasBotsCommands, true);
                }
                if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                    mentionContainer.getAdapter().setBotsCount(botsCount);
                }
                if (chatMode == 0 && ChatObject.isChannel(currentChat) && mergeDialogId == 0 && chatInfo.migrated_from_chat_id != 0 && !isThreadChat()) {
                    mergeDialogId = -chatInfo.migrated_from_chat_id;
                    maxMessageId[1] = chatInfo.migrated_from_max_id;
                    if (chatAdapter != null) {
                        chatAdapter.notifyDataSetChanged(true);
                    }
                    if (mergeDialogId != 0 && endReached[0]) {
                        checkScrollForLoad(false);
                    }
                }
                checkGroupCallJoin((Boolean) args[3]);
                checkThemeEmoticon();
                if (pendingRequestsDelegate != null) {
                    pendingRequestsDelegate.setChatInfo(chatInfo, true);
                }
            }
        } else if (id == NotificationCenter.chatInfoCantLoad) {
            //聊天错误提示
            long chatId = (Long) args[0];
            if (currentChat != null && currentChat.id == chatId) {
                int reason = (Integer) args[1];
                if (getParentActivity() == null || closeChatDialog != null) {
                    return;
                }
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                builder.setTitle(LocaleController.getString(R.string.AppName));
                Map<String, Integer> colorsReplacement = new HashMap<>();
                colorsReplacement.put("info1.**", getThemedColor(Theme.key_dialogTopBackground));
                colorsReplacement.put("info2.**", getThemedColor(Theme.key_dialogTopBackground));
                builder.setTopAnimation(R.raw.not_available, AlertsCreator.NEW_DENY_DIALOG_TOP_ICON_SIZE, false, getThemedColor(Theme.key_dialogTopBackground), colorsReplacement);
                builder.setTopAnimationIsNew(true);
                if (reason == 0) {
                    if (currentChat instanceof TLRPC.TL_channelForbidden) {
                        builder.setTitle(LocaleController.getString("ChannelCantOpenBannedByAdminTitle", R.string.ChannelCantOpenBannedByAdminTitle));
                        builder.setMessage(LocaleController.getString("ChannelCantOpenBannedByAdmin", R.string.ChannelCantOpenBannedByAdmin));
                    } else {
                        builder.setTitle(LocaleController.getString(R.string.ChannelPrivate));
                        builder.setMessage(LocaleController.getString("ChannelCantOpenPrivate2", R.string.ChannelCantOpenPrivate2));
                    }
                } else if (reason == 1) {
                    builder.setMessage(LocaleController.getString("ChannelCantOpenNa", R.string.ChannelCantOpenNa));
                } else if (reason == 2) {
                    builder.setMessage(LocaleController.getString("ChannelCantOpenBanned", R.string.ChannelCantOpenBanned));
                } else if (reason == 3) {
                    builder.setTitle(LocaleController.getString(R.string.ChannelPrivate));
                    builder.setMessage(LocaleController.getString("JoinByPeekChannelText", R.string.JoinByPeekChannelText));
                }
                builder.setPositiveButton(LocaleController.getString(R.string.Close), null);
                if (showDialog(closeChatDialog = builder.create()) == null) {
                    showCloseChatDialogLater = true;
                }

                loading = false;
                showProgressView(false);
                if (chatAdapter != null) {
                    chatAdapter.notifyDataSetChanged(false);
                }
            }
        } else if (id == NotificationCenter.contactsDidLoad) {
            updateTopPanel(true);
            if (!isThreadChat() && avatarContainer != null) {
                avatarContainer.updateSubtitle();
            }
        } else if (id == NotificationCenter.encryptedChatUpdated) {
            TLRPC.EncryptedChat chat = (TLRPC.EncryptedChat) args[0];
            if (currentEncryptedChat != null && chat.id == currentEncryptedChat.id) {
                currentEncryptedChat = chat;
                updateTopPanel(true);
                updateSecretStatus();
                if (suggestEmojiPanel != null) {
                    suggestEmojiPanel.fireUpdate();
                }
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setAllowStickersAndGifs(true, true, true);
                    chatActivityEnterView.checkRoundVideo();
                }
                if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                    mentionContainer.getAdapter().setNeedBotContext(!chatActivityEnterView.isEditingMessage());
                }
            }
        } else if (id == NotificationCenter.messagesReadEncrypted) {
            int encId = (Integer) args[0];
            if (currentEncryptedChat != null && currentEncryptedChat.id == encId) {
                int date = (Integer) args[1];
                for (MessageObject obj : messages) {
                    if (!obj.isOut()) {
                        continue;
                    } else if (obj.isOut() && !obj.isUnread()) {
                        break;
                    }
                    if (obj.messageOwner.date - 1 <= date) {
                        obj.setIsRead();
                        if (chatAdapter != null) {
                            chatAdapter.invalidateRowWithMessageObject(obj);
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.removeAllMessagesFromDialog) {
            long did = (Long) args[0];
            if (dialog_id == did) {
                if (threadMessageId != 0) {
                    if (forwardEndReached[0]) {
                        forwardEndReached[0] = false;
                        hideForwardEndReached = false;
                        if (chatAdapter != null) {
                            chatAdapter.notifyItemInserted(0);
                        }
                    }
                    getMessagesController().addToViewsQueue(threadMessageObject);
                } else {
                    clearHistory((Boolean) args[1], (TLRPC.TL_updates_channelDifferenceTooLong) args[2]);
                }
            }
        } else if (id == NotificationCenter.screenshotTook) {
            updateInformationForScreenshotDetector();
        } else if (id == NotificationCenter.blockedUsersDidLoad) {
            if (currentUser != null && !UserObject.isReplyUser(currentUser)) {
                boolean oldValue = userBlocked;
                userBlocked = getMessagesController().blockePeers.indexOfKey(currentUser.id) >= 0;
                if (oldValue != userBlocked) {
                    updateBottomOverlay();
                }
            }
        } else if (id == NotificationCenter.fileNewChunkAvailable) {
            MessageObject messageObject = (MessageObject) args[0];
            long finalSize = (Long) args[3];
            if (finalSize != 0 && dialog_id == messageObject.getDialogId()) {
                MessageObject currentObject = messagesDict[0].get(messageObject.getId());
                if (currentObject != null && currentObject.messageOwner.media.document != null) {
                    currentObject.messageOwner.media.document.size = (int) finalSize;
                    updateVisibleRows();
                }
            }
        } else if (id == NotificationCenter.didCreatedNewDeleteTask) {
            long dialogId = (Long) args[0];
            if (dialogId != dialog_id) {
                return;
            }
            SparseArray<ArrayList<Integer>> mids = (SparseArray<ArrayList<Integer>>) args[1];
            boolean changed = false;
            for (int i = 0; i < mids.size(); i++) {
                int key = mids.keyAt(i);
                ArrayList<Integer> arr = mids.get(key);
                for (int a = 0; a < arr.size(); a++) {
                    Integer mid = arr.get(a);
                    MessageObject messageObject = messagesDict[0].get(mid);
                    if (messageObject != null) {
                        messageObject.messageOwner.destroyTime = key;
                        changed = true;
                    }
                }
            }
            if (changed) {
                updateVisibleRows();
            }
        } else if (id == NotificationCenter.messagePlayingDidStart) {
            MessageObject messageObject = (MessageObject) args[0];
            MessageObject oldPlayingObject = (MessageObject) args[1];
            if (messageObject.eventId != 0) {
                return;
            }
            sendSecretMessageRead(messageObject, true);

            if ((messageObject.isRoundVideo() || messageObject.isVideo()) && fragmentView != null && fragmentView.getParent() != null) {
                if (!messageObject.isVoiceTranscriptionOpen()) {
                    MediaController.getInstance().setTextureView(createTextureView(true), aspectRatioFrameLayout, videoPlayerContainer, true);
                    boolean needScroll = false;
                    if (oldPlayingObject != null) {
                        int index1 = messages.indexOf(oldPlayingObject);
                        int index2 = messages.indexOf(messageObject);
                        if (index1 >= 0 && index2 >= 0 && Math.abs(index1 - index2) < 5) {
                            needScroll = true;
                        }
                    }
                    updateTextureViewPosition(true, needScroll);
                    if (!needScroll) {
                        checkTextureViewPosition = true;
                        updateMessagesVisiblePart(false);
                    }
                } else {
                    MediaController.getInstance().setTextureView(createTextureView(true), aspectRatioFrameLayout, videoPlayerContainer, true);
                }
            }

            if (chatListView != null) {
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View view = chatListView.getChildAt(a);
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;
                        MessageObject messageObject1 = cell.getMessageObject();
                        if (messageObject1 != null) {
                            boolean isVideo = messageObject1.isVideo();
                            if (messageObject1.isRoundVideo() || isVideo) {
                                cell.checkVideoPlayback(!messageObject.equals(messageObject1), null);
                                if (!MediaController.getInstance().isPlayingMessage(messageObject1)) {
                                    if (isVideo && !MediaController.getInstance().isGoingToShowMessageObject(messageObject1)) {
                                        AnimatedFileDrawable animation = cell.getPhotoImage().getAnimation();
                                        if (animation != null) {
                                            animation.start();
                                        }
                                    }
                                    if (messageObject1.audioProgress != 0) {
                                        messageObject1.resetPlayingProgress();
                                        cell.invalidate();
                                    }
                                } else if (isVideo) {
                                    cell.updateButtonState(false, true, false);
                                }
                                if (messageObject1.isRoundVideo()) {
                                    int position = chatListView.getChildAdapterPosition(cell);
                                    if (position >= 0) {
                                        if (MediaController.getInstance().isPlayingMessage(messageObject1)) {
                                            boolean keyboardIsVisible = contentView.getKeyboardHeight() >= AndroidUtilities.dp(20);
                                            float topPadding = chatListViewPaddingTop - (contentPanTranslation + bottomPanelTranslationY);
                                            int offset = (int) ((chatListView.getMeasuredHeight() - topPadding - blurredViewBottomOffset) / 2 - (keyboardIsVisible ? AndroidUtilities.roundMessageSize : AndroidUtilities.roundPlayingMessageSize) / 2 - (cell.reactionsLayoutInBubble == null ? 0 : cell.reactionsLayoutInBubble.totalHeight));
                                            chatLayoutManager.scrollToPositionWithOffset(position, offset, false);
                                        }
                                        chatAdapter.notifyItemChanged(position);
                                    }
                                }
                            } else if (messageObject1.isVoice() || messageObject1.isMusic() || messageObject1.isRoundVideo()) {
                                cell.updateButtonState(false, true, false);
                            }
                        }
                    }
                }
                if (mentionContainer != null && mentionContainer.getListView() != null) {
                    count = mentionContainer.getListView().getChildCount();
                    for (int a = 0; a < count; a++) {
                        View view = mentionContainer.getListView().getChildAt(a);
                        if (view instanceof ContextLinkCell) {
                            ContextLinkCell cell = (ContextLinkCell) view;
                            MessageObject messageObject1 = cell.getMessageObject();
                            if (messageObject1 != null && (messageObject1.isVoice() || messageObject1.isMusic() || messageObject1.isRoundVideo())) {
                                cell.updateButtonState(false, true);
                            }
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.messagePlayingGoingToStop) {
            boolean injecting = (Boolean) args[1];
            if (injecting) {
                contentView.removeView(videoPlayerContainer);
                videoPlayerContainer = null;
                videoTextureView = null;
                aspectRatioFrameLayout = null;
            } else {
                if (chatListView != null && videoPlayerContainer != null && videoPlayerContainer.getTag() != null) {
                    MessageObject messageObject = (MessageObject) args[0];
                    int count = chatListView.getChildCount();
                    for (int a = 0; a < count; a++) {
                        View view = chatListView.getChildAt(a);
                        if (view instanceof ChatMessageCell) {
                            ChatMessageCell cell = (ChatMessageCell) view;
                            MessageObject messageObject1 = cell.getMessageObject();
                            if (messageObject == messageObject1) {
                                AnimatedFileDrawable animation = cell.getPhotoImage().getAnimation();
                                if (animation != null) {
                                    Bitmap bitmap = animation.getAnimatedBitmap();
                                    if (bitmap != null) {
                                        try {
                                            Bitmap src = videoTextureView.getBitmap(bitmap.getWidth(), bitmap.getHeight());
                                            Canvas canvas = new Canvas(bitmap);
                                            canvas.drawBitmap(src, 0, 0, null);
                                            src.recycle();
                                        } catch (Throwable e) {
                                            FileLog.e(e);
                                        }
                                    }
                                    animation.seekTo(messageObject.audioProgressMs, !getFileLoader().isLoadingVideo(messageObject.getDocument(), true));
                                }
                                break;
                            }
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.messagePlayingDidReset || id == NotificationCenter.messagePlayingPlayStateChanged) {
            if (id == NotificationCenter.messagePlayingDidReset) {
                AndroidUtilities.runOnUIThread(destroyTextureViewRunnable);
            }
            int messageId = (int) args[0];
            if (chatListView != null) {
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View view = chatListView.getChildAt(a);
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject != null) {
                            if (messageObject.isRoundVideo()) {
                                if (!MediaController.getInstance().isPlayingMessage(messageObject)) {
                                    Bitmap bitmap = null;
                                    if (id == NotificationCenter.messagePlayingDidReset && cell.getMessageObject().getId() == messageId && videoTextureView != null) {
                                        bitmap = videoTextureView.getBitmap();
                                        if (bitmap != null && bitmap.getPixel(0, 0) == Color.TRANSPARENT) {
                                            bitmap = null;
                                        }
                                    }
                                    cell.checkVideoPlayback(true, bitmap);
                                }
                                int position = chatListView.getChildAdapterPosition(cell);
                                messageObject.forceUpdate = true;
                                if (position >= 0) {
                                    chatAdapter.notifyItemChanged(position);
                                }
                            } else if (messageObject.isVoice() || messageObject.isMusic()) {
                                cell.updateButtonState(false, true, false);
                            } else if (messageObject.isVideo()) {
                                cell.updateButtonState(false, true, false);
                                if (!MediaController.getInstance().isPlayingMessage(messageObject) && !MediaController.getInstance().isGoingToShowMessageObject(messageObject)) {
                                    AnimatedFileDrawable animation = cell.getPhotoImage().getAnimation();
                                    if (animation != null) {
                                        animation.start();
                                    }
                                }
                            }
                        }
                    }
                }
                if (mentionContainer != null && mentionContainer.getListView() != null) {
                    count = mentionContainer.getListView().getChildCount();
                    for (int a = 0; a < count; a++) {
                        View view = mentionContainer.getListView().getChildAt(a);
                        if (view instanceof ContextLinkCell) {
                            ContextLinkCell cell = (ContextLinkCell) view;
                            MessageObject messageObject = cell.getMessageObject();
                            if (messageObject != null && (messageObject.isVoice() || messageObject.isRoundVideo() || messageObject.isMusic())) {
                                cell.updateButtonState(false, true);
                            }
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.messagePlayingProgressDidChanged) {
            Integer mid = (Integer) args[0];
            if (chatListView != null) {
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View view = chatListView.getChildAt(a);
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;
                        MessageObject playing = cell.getMessageObject();
                        if (playing != null && playing.getId() == mid) {
                            MessageObject player = MediaController.getInstance().getPlayingMessageObject();
                            if (player != null && !cell.getSeekBar().isDragging()) {
                                playing.audioProgress = player.audioProgress;
                                playing.audioProgressSec = player.audioProgressSec;
                                playing.audioPlayerDuration = player.audioPlayerDuration;
                                cell.updatePlayingMessageProgress();
                                if (drawLaterRoundProgressCell == cell) {
                                    fragmentView.invalidate();
                                }
                            }
                            break;
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.didUpdatePollResults) {
            long pollId = (Long) args[0];
            ArrayList<MessageObject> arrayList = polls.get(pollId);
            if (arrayList != null) {
                TLRPC.TL_poll poll = (TLRPC.TL_poll) args[1];
                TLRPC.PollResults results = (TLRPC.PollResults) args[2];
                View pollView = null;
                boolean isVotedChanged = false;
                boolean isQuiz = false;
                for (int a = 0, N = arrayList.size(); a < N; a++) {
                    MessageObject object = arrayList.get(a);
                    boolean isVoted = object.isVoted();
                    TLRPC.TL_messageMediaPoll media = (TLRPC.TL_messageMediaPoll) object.messageOwner.media;
                    if (poll != null) {
                        media.poll = poll;
                        isQuiz = poll.quiz;
                    } else if (media.poll != null) {
                        isQuiz = media.poll.quiz;
                    }
                    MessageObject.updatePollResults(media, results);
                    if (chatAdapter != null) {
                        pollView = chatAdapter.updateRowWithMessageObject(object, true);
                    }
                    if (isVoted != object.isVoted()) {
                        isVotedChanged = true;
                    }
                }
                if (isVotedChanged && isQuiz && undoView != null && pollView instanceof ChatMessageCell) {
                    ChatMessageCell cell = (ChatMessageCell) pollView;
                    if (cell.isAnimatingPollAnswer()) {
                        for (int a = 0, N = results.results.size(); a < N; a++) {
                            TLRPC.TL_pollAnswerVoters voters = results.results.get(a);
                            if (voters.chosen) {
                                if (voters.correct) {
                                    fireworksOverlay.start();
                                    pollView.performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
                                } else {
                                    ((ChatMessageCell) pollView).shakeView();
                                    pollView.performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
                                    showPollSolution(cell.getMessageObject(), results);
                                    cell.showHintButton(false, true, 0);
                                }
                                break;
                            }
                        }
                    }
                }
            }
        } else if (id == NotificationCenter.didUpdateExtendedMedia) {
            long did = (Long) args[0];
            doOnIdle(() -> {
                int msgId = (Integer) args[1];
                MessageObject messageObject = messagesDict[did == dialog_id ? 0 : 1].get(msgId);
                if (messageObject != null) {
                    messageObject.messageOwner.media.extended_media = (TLRPC.MessageExtendedMedia) args[2];
                    messageObject.forceUpdate = true;
                    messageObject.setType();
                    updateMessageAnimated(messageObject, false);
                }
            });
        } else if (id == NotificationCenter.didUpdateReactions) {
            if (isInScheduleMode()) {
                return;
            }
            long did = (Long) args[0];
            doOnIdle(() -> {
                int msgId = (Integer) args[1];
                MessageObject messageObject = messagesDict[did == dialog_id ? 0 : 1].get(msgId);
                if (messageObject != null) {
                    MessageObject.updateReactions(messageObject.messageOwner, (TLRPC.TL_messageReactions) args[2]);
                    messageObject.forceUpdate = true;
                    messageObject.reactionsChanged = true;
                    updateMessageAnimated(messageObject, true);
                }
            });
        } else if (id == NotificationCenter.didVerifyMessagesStickers) {
            ArrayList<TLRPC.Message> messages = (ArrayList<TLRPC.Message>) args[0];
            for (int a = 0, N = messages.size(); a < N; a++) {
                TLRPC.Message message = messages.get(a);
                MessageObject existMessageObject = messagesDict[0].get(message.id);
                if (existMessageObject != null) {
                    existMessageObject.messageOwner.stickerVerified = message.stickerVerified;
                    existMessageObject.setType();
                    if (chatAdapter != null) {
                        chatAdapter.updateRowWithMessageObject(existMessageObject, false);
                    }
                }
            }
        } else if (id == NotificationCenter.updateMessageMedia) {
            TLRPC.Message message = (TLRPC.Message) args[0];
            MessageObject existMessageObject = messagesDict[0].get(message.id);
            if (existMessageObject != null) {
                existMessageObject.messageOwner.media = message.media;
                existMessageObject.messageOwner.attachPath = message.attachPath;
                existMessageObject.generateThumbs(false);
                if (existMessageObject.getGroupId() != 0 && (existMessageObject.photoThumbs == null || existMessageObject.photoThumbs.isEmpty())) {
                    MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(existMessageObject.getGroupId());
                    if (groupedMessages != null) {
                        int idx = groupedMessages.messages.indexOf(existMessageObject);
                        if (idx >= 0) {
                            int updateCount = groupedMessages.messages.size();
                            MessageObject messageObject = null;
                            if (idx > 0 && idx < groupedMessages.messages.size() - 1) {
                                MessageObject.GroupedMessages slicedGroup = new MessageObject.GroupedMessages();
                                slicedGroup.groupId = Utilities.random.nextLong();
                                slicedGroup.messages.addAll(groupedMessages.messages.subList(idx + 1, groupedMessages.messages.size()));
                                for (int b = 0; b < slicedGroup.messages.size(); b++) {
                                    slicedGroup.messages.get(b).localGroupId = slicedGroup.groupId;
                                    groupedMessages.messages.remove(idx + 1);
                                }
                                groupedMessagesMap.put(slicedGroup.groupId, slicedGroup);
                                messageObject = slicedGroup.messages.get(slicedGroup.messages.size() - 1);
                                slicedGroup.calculate();
                            }
                            groupedMessages.messages.remove(idx);
                            if (groupedMessages.messages.isEmpty()) {
                                groupedMessagesMap.remove(groupedMessages.groupId);
                            } else {
                                if (messageObject == null) {
                                    messageObject = groupedMessages.messages.get(groupedMessages.messages.size() - 1);
                                }
                                groupedMessages.calculate();
                                int index = messages.indexOf(messageObject);
                                if (index >= 0) {
                                    if (chatAdapter != null) {
                                        chatAdapter.notifyItemRangeChanged(index + chatAdapter.messagesStartRow, updateCount);
                                    }
                                }
                            }
                        }
                    }
                }
                if (message.media.ttl_seconds != 0 && (message.media.photo instanceof TLRPC.TL_photoEmpty || message.media.document instanceof TLRPC.TL_documentEmpty)) {
                    existMessageObject.setType();
                    if (chatAdapter != null) {
                        chatAdapter.updateRowWithMessageObject(existMessageObject, false);
                    }
                } else {
                    updateVisibleRows();
                }
            }
        } else if (id == NotificationCenter.voiceTranscriptionUpdate) {
            if (chatAdapter != null) {
                MessageObject messageObject = (MessageObject) args[0];
                long transcriptionId = 0;
                String transcriptionText = null;
                if (args.length > 1 && args[1] != null) {
                    transcriptionId = (Long) args[1];
                    transcriptionText = (String) args[2];
                }
                ArrayList<MessageObject> messages = chatAdapter.isFrozen ? chatAdapter.frozenMessages : ChatActivity.this.messages;
                if (messages != null && !messages.contains(messageObject) && args.length > 1 && args[1] != null) {
                    for (int a = 0; a < messages.size(); ++a) {
                        if (messages.get(a) != null && messages.get(a).messageOwner != null && (messages.get(a).messageOwner.voiceTranscriptionId == transcriptionId || messageObject != null && messageObject.getId() == messages.get(a).getId() && messageObject.getDialogId() == messages.get(a).getDialogId())) {
                            messageObject = messages.get(a);
                            break;
                        }
                    }
                }
                if (messageObject != null) {
                    if (transcriptionText != null && messageObject.messageOwner != null) {
                        messageObject.messageOwner.voiceTranscription = transcriptionText;
                    }
                    if (args.length > 3 && args[3] != null) {
                        messageObject.messageOwner.voiceTranscriptionOpen = (Boolean) args[3];
                    }
                    if (args.length > 4 && args[4] != null) {
                        messageObject.messageOwner.voiceTranscriptionFinal = (Boolean) args[4];
                    }

                    int index = messages.indexOf(messageObject);
                    if (index >= 0 && index < messages.size()) {
                        int position = index + chatAdapter.messagesStartRow;
                        chatAdapter.updateRowAtPosition(position);
                        if (args.length > 3 && args[3] != null) {
                            for (int i = 0; i < chatListView.getChildCount(); ++i) {
                                View child = chatListView.getChildAt(i);
                                if (child instanceof ChatMessageCell && ((ChatMessageCell) child).getMessageObject() == messageObject) {
                                    int top = child.getTop() - (int) chatListViewPaddingTop;
                                    int halfHeight = (int) ((chatListView.getMeasuredHeight() - chatListViewPaddingTop) / 2);
                                    if (messageObject.measureVoiceTranscriptionHeight() > halfHeight * .4f) {
                                        chatLayoutManager.scrollToPositionWithOffset(position, (top > halfHeight * .6f && messageObject.isVoiceTranscriptionOpen() ? (int) (halfHeight * .6f) : top), false);
                                    }
                                    break;
                                }
                            }
                        }
                    }

                    AndroidUtilities.runOnUIThread(() -> {
                        updateMessagesVisiblePart(false);
                    });
                }
            }
        } else if (id == NotificationCenter.animatedEmojiDocumentLoaded) {
            if (chatAdapter != null) {
                MessageObject messageObject = (MessageObject) args[0];
                if (messageObject != null) {
                    ArrayList<MessageObject> messages = chatAdapter.isFrozen ? chatAdapter.frozenMessages : ChatActivity.this.messages;
                    int index = messages.indexOf(messageObject);
                    if (index >= 0 && index < messages.size()) {
                        int position = index + chatAdapter.messagesStartRow;
                        chatAdapter.updateRowAtPosition(position);
                    }
                }
            }
        } else if (id == NotificationCenter.updateMessagesObjects) {
            long did = (long) args[0];
            if (did != dialog_id || args[1] == null) {
                return;
            }

            ArrayList<TLRPC.Message> messageObjects = (ArrayList<TLRPC.Message>) args[1];
            updateMessageObjects(messageObjects);
        } else if (id == NotificationCenter.updateModel) {

            if (messages != null && messages.size() > 0
                    && (messages.get(0).type != 10)) {

                int lastModel = (int) args[0];

            }

        } else if (id == NotificationCenter.replaceMessagesObjects) {
            long did = (long) args[0];
            if (did != dialog_id && did != mergeDialogId) {
                return;
            }
            int loadIndex = did == dialog_id ? 0 : 1;
            //延迟更新，在执行动画比如滑动，就不更新文本
            doOnIdle(() -> {
                ArrayList<MessageObject> messageObjects = (ArrayList<MessageObject>) args[1];
                replaceMessageObjects(messageObjects, loadIndex, false);

                if (avatarContainer != null) {
                    avatarContainer.updateSubtitle(true);
                }
            });
        } else if (id == NotificationCenter.notificationsSettingsUpdated) {
            updateTitleIcons();
            if (ChatObject.isChannel(currentChat) || UserObject.isReplyUser(currentUser)) {
                updateBottomOverlay();
            }
        } else if (id == NotificationCenter.replyMessagesDidLoad) {
            long did = (Long) args[0];
            if (did == dialog_id) {
                ArrayList<MessageObject> loadedMessages = (ArrayList<MessageObject>) args[1];
                LongSparseArray<SparseArray<ArrayList<MessageObject>>> replyMessageOwners = (LongSparseArray<SparseArray<ArrayList<MessageObject>>>) args[2];
                for (int a = 0, N = loadedMessages.size(); a < N; a++) {
                    MessageObject obj = loadedMessages.get(a);
                    repliesMessagesDict.put(obj.getId(), obj);
                }
                if (replyMessageOwners != null) {
                    for (int a = 0, N = replyMessageOwners.size(); a < N; a++) {
                        SparseArray<ArrayList<MessageObject>> sparseArray = replyMessageOwners.valueAt(a);
                        for (int c = 0, N3 = sparseArray.size(); c < N3; c++) {
                            ArrayList<MessageObject> arrayList = sparseArray.valueAt(c);
                            for (int b = 0, N2 = arrayList.size(); b < N2; b++) {
                                addReplyMessageOwner(arrayList.get(b), 0);
                            }
                        }
                    }
                }
                updateVisibleRows();
            } else if (waitingForReplies.size() != 0 && ChatObject.isChannel(currentChat) && !currentChat.megagroup && chatInfo != null && did == -chatInfo.linked_chat_id) {
                checkWaitingForReplies();
            }
            updateReplyMessageHeader(true);
        } else if (id == NotificationCenter.didLoadPinnedMessages) {
            //更新置顶消息
            long did = (Long) args[0];
            if (did == dialog_id) {
                ArrayList<Integer> ids = (ArrayList<Integer>) args[1];
                boolean pin = (Boolean) args[2];
                ArrayList<MessageObject> arrayList = (ArrayList<MessageObject>) args[3];
                HashMap<Integer, MessageObject> dict = null;
                if (ids != null) {
                    HashMap<Integer, MessageObject> replaceObjects = (HashMap<Integer, MessageObject>) args[4];
                    int maxId = (Integer) args[5];
                    int totalPinnedCount = (Integer) args[6];
                    boolean endReached = (Boolean) args[7];
                    HashMap<Integer, MessageObject> oldPinned = new HashMap<>(pinnedMessageObjects);
                    if (replaceObjects != null) {
                        loadingPinnedMessagesList = false;
                        if (maxId == 0) {
                            pinnedMessageIds.clear();
                            pinnedMessageObjects.clear();
                        }
                        totalPinnedMessagesCount = totalPinnedCount;
                        pinnedEndReached = endReached;
                    }
                    boolean updated = false;
                    if (arrayList != null) {
                        getMediaDataController().loadReplyMessagesForMessages(arrayList, dialog_id, false, 0, null);
                    }
                    for (int a = 0, N = ids.size(); a < N; a++) {
                        Integer mid = ids.get(a);
                        if (pin) {
                            if (pinnedMessageObjects.containsKey(mid)) {
                                continue;
                            }

                            MessageObject object = oldPinned.get(mid);
                            if (object == null) {
                                object = messagesDict[0].get(mid);
                            }
                            if (object == null && arrayList != null) {
                                if (dict == null) {
                                    dict = new HashMap<>();
                                    for (int b = 0, N2 = arrayList.size(); b < N2; b++) {
                                        MessageObject obj = arrayList.get(b);
                                        if (obj != null) {
                                            dict.put(obj.getId(), obj);
                                        }
                                    }
                                }
                                object = dict.get(mid);
                            }
                            if (object == null && replaceObjects != null) {
                                object = replaceObjects.get(mid);
                            }
                            if (object != null && (!isTopic || getTopicId() == MessageObject.getTopicId(object.messageOwner, ChatObject.isForum(currentChat)))) {
                                pinnedMessageIds.add(mid);
                                pinnedMessageObjects.put(mid, object);
                                if (replaceObjects == null) {
                                    totalPinnedMessagesCount++;
                                }
                            }
                        } else {
                            if (!pinnedMessageObjects.containsKey(mid)) {
                                continue;
                            }
                            pinnedMessageObjects.remove(mid);
                            pinnedMessageIds.remove(mid);
                            if (replaceObjects == null) {
                                totalPinnedMessagesCount--;
                            }
                        }
                        loadedPinnedMessagesCount = pinnedMessageIds.size();
                        if (chatAdapter != null) {
                            MessageObject obj = messagesDict[0].get(mid);
                            if (obj != null) {
                                if (obj.hasValidGroupId()) {
                                    MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(obj.getGroupId());
                                    if (groupedMessages != null) {
                                        int index = messages.indexOf(groupedMessages.messages.get(groupedMessages.messages.size() - 1));
                                        if (index >= 0) {
                                            chatAdapter.notifyItemRangeChanged(index, groupedMessages.messages.size());
                                        }
                                    }
                                } else {
                                    chatAdapter.updateRowWithMessageObject(obj, false);
                                }
                            }
                        }
                        updated = true;
                    }
                    if (updated) {
                        if (chatMode == MODE_PINNED && avatarContainer != null) {
                            avatarContainer.setTitle(LocaleController.formatPluralString("PinnedMessagesCount", getPinnedMessagesCount()));
                        }
                        Collections.sort(pinnedMessageIds, (o1, o2) -> o2.compareTo(o1));
                        if (pinnedMessageIds.isEmpty()) {
                            hidePinnedMessageView(true);
                        } else {
                            updateMessagesVisiblePart(false);
                        }
                    }
                    if (chatMode == MODE_PINNED) {
                        if (pin) {
                            if (arrayList != null) {
                                processNewMessages(arrayList);
                            }
                        } else {
                            processDeletedMessages(ids, ChatObject.isChannel(currentChat) ? dialog_id : 0);
                        }
                    }
                } else {
                    if (pin) {
                        for (int a = 0, N = arrayList.size(); a < N; a++) {
                            MessageObject message = arrayList.get(a);
                            if (pinnedMessageObjects.containsKey(message.getId())) {
                                pinnedMessageObjects.put(message.getId(), message);
                            }
                            loadingPinnedMessages.remove(message.getId());
                        }
                        getMediaDataController().loadReplyMessagesForMessages(arrayList, dialog_id, false, 0, null);
                        updateMessagesVisiblePart(false);
                    } else {
                        pinnedMessageIds.clear();
                        pinnedMessageObjects.clear();
                        currentPinnedMessageId = 0;
                        loadedPinnedMessagesCount = 0;
                        totalPinnedMessagesCount = 0;
                        hidePinnedMessageView(true);
                    }
                }
            }
            updatePinnedTopicStarterMessage();
        } else if (id == NotificationCenter.didReceivedWebpages) {
            ArrayList<TLRPC.Message> arrayList = (ArrayList<TLRPC.Message>) args[0];
            boolean updated = false;
            for (int a = 0; a < arrayList.size(); a++) {
                TLRPC.Message message = arrayList.get(a);
                long did = MessageObject.getDialogId(message);
                if (did != dialog_id && did != mergeDialogId) {
                    continue;
                }
                MessageObject currentMessage = messagesDict[did == dialog_id ? 0 : 1].get(message.id);
                if (currentMessage != null) {
                    currentMessage.messageOwner.media = new TLRPC.TL_messageMediaWebPage();
                    currentMessage.messageOwner.media.webpage = message.media.webpage;
                    currentMessage.generateThumbs(true);
                    updated = true;
                }
            }
            if (updated) {
                updateVisibleRows();
            }
        } else if (id == NotificationCenter.didReceivedWebpagesInUpdates) {
            if (foundWebPage != null) {
                LongSparseArray<TLRPC.WebPage> hashMap = (LongSparseArray<TLRPC.WebPage>) args[0];
                for (int a = 0; a < hashMap.size(); a++) {
                    TLRPC.WebPage webPage = hashMap.valueAt(a);
                    if (webPage.id == foundWebPage.id) {
                        showFieldPanelForWebPage(!(webPage instanceof TLRPC.TL_webPageEmpty), webPage, false);
                        break;
                    }
                }
            }
        } else if (id == NotificationCenter.messagesReadContent) {
            long did = (Long) args[0];
            if (did != dialog_id && (ChatObject.isChannel(currentChat) || did != 0)) {
                return;
            }
            ArrayList<Integer> arrayList = (ArrayList<Integer>) args[1];
            for (int a = 0, N = arrayList.size(); a < N; a++) {
                int mid = arrayList.get(a);
                MessageObject currentMessage = messagesDict[0].get(mid);
                if (currentMessage != null) {
                    currentMessage.setContentIsRead();
                    if (currentMessage.messageOwner.mentioned) {
                        newMentionsCount--;
                        if (newMentionsCount <= 0) {
                            newMentionsCount = 0;
                            hasAllMentionsLocal = true;
                            showMentionDownButton(false, true);
                        } else {
                            if (mentiondownButtonCounter != null) {
                                mentiondownButtonCounter.setText(String.format("%d", newMentionsCount));
                            }
                        }
                    }
                    if (chatAdapter != null) {
                        chatAdapter.invalidateRowWithMessageObject(currentMessage);
                    }
                }
            }
        } else if (id == NotificationCenter.botInfoDidLoad) {
            //更新机器人信息
            int guid = (Integer) args[1];
            if (classGuid == guid || guid == 0) {
                TLRPC.BotInfo info = (TLRPC.BotInfo) args[0];
                if (currentEncryptedChat == null) {
                    if (!info.commands.isEmpty() && !ChatObject.isChannel(currentChat) && !isThreadChat()) {
                        hasBotsCommands = true;
                    }
                    if (info.user_id == 0 && currentUser != null) {
                        info.user_id = currentUser.id;
                    }
                    botInfo.put(info.user_id, info);
                    if (chatAdapter != null) {
                        int prevRow = chatAdapter.botInfoRow;
                        chatAdapter.updateRowsInternal();
                        if (prevRow < 0 && chatAdapter.botInfoRow >= 0) {
                            chatAdapter.notifyItemInserted(chatAdapter.botInfoRow);
                        } else if (prevRow >= 0 && chatAdapter.botInfoRow < 0) {
                            chatAdapter.notifyItemRemoved(prevRow);
                        } else if (prevRow >= 0 && chatAdapter.botInfoRow >= 0) {
                            chatAdapter.notifyItemChanged(chatAdapter.botInfoRow);
                        }
                    }
                    if (!ChatObject.isChannel(currentChat) || currentChat != null && currentChat.megagroup) {
                        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                            mentionContainer.getAdapter().setBotInfo(botInfo);
                        }

                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.setBotInfo(botInfo);
                        }
                    }
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.setBotsCount(botsCount, hasBotsCommands, true);
                        hasBotWebView = getMessagesController().getUser(info.user_id).bot_menu_webview;
                        chatActivityEnterView.updateBotWebView(true);
                    }
                }
                updateBotButtons();
            }
        } else if (id == NotificationCenter.botKeyboardDidLoad) {
            //更新机器人键盘按钮
            if (dialog_id == (Long) args[1]) {
                TLRPC.Message message = (TLRPC.Message) args[0];
                if (message != null && !userBlocked) {
                    botButtons = new MessageObject(currentAccount, message, false, false);
                    checkBotKeyboard();
                } else {
                    botButtons = null;
                    if (chatActivityEnterView != null) {
                        if (replyingMessageObject != null && botReplyButtons == replyingMessageObject) {
                            botReplyButtons = null;
                            hideFieldPanel(true);
                        }
                        chatActivityEnterView.setButtons(botButtons);
                    }
                }
            }
        } else if (id == NotificationCenter.chatSearchResultsAvailable) {
            //更新有效的搜索结果
            if (classGuid == (Integer) args[0]) {
                boolean jumpToMessage = (Boolean) args[6];
                if (jumpToMessage) {
                    int messageId = (Integer) args[1];
                    long did = (Long) args[3];
                    if (messageId != 0) {
                        scrollToMessageId(messageId, 0, true, did == dialog_id ? 0 : 1, true, 0);
                    } else {
                        updateVisibleRows();
                    }
                    updateSearchButtons((Integer) args[2], (Integer) args[4], (Integer) args[5]);
                    if (searchItem != null) {
                        searchItem.setShowSearchProgress(false);
                    }
                }
                if (messagesSearchAdapter != null) {
                    messagesSearchAdapter.notifyDataSetChanged();
                }
            }
        } else if (id == NotificationCenter.chatSearchResultsLoading) {
            //更新搜索结果载入
            if (classGuid == (Integer) args[0]) {
                if (searchItem != null) {
                    searchItem.setShowSearchProgress(true);
                }
                if (messagesSearchAdapter != null) {
                    messagesSearchAdapter.notifyDataSetChanged();
                }
            }
        } else if (id == NotificationCenter.didUpdateMessagesViews) {
            //消息被更新调用
            LongSparseArray<SparseIntArray> channelViews = (LongSparseArray<SparseIntArray>) args[0];
            LongSparseArray<SparseIntArray> channelForwards = (LongSparseArray<SparseIntArray>) args[1];
            LongSparseArray<SparseArray<TLRPC.MessageReplies>> channelReplies = (LongSparseArray<SparseArray<TLRPC.MessageReplies>>) args[2];
            boolean addingReplies = (Boolean) args[3];
            boolean updated = false;
            LongSparseArray<MessageObject.GroupedMessages> newGroups = null;
            ArrayList<Integer> updatedRows = null;

            for (int b = 0; b < 2; b++) {
                LongSparseArray<SparseIntArray> sparseArray = b == 0 ? channelViews : channelForwards;
                if (sparseArray == null) {
                    continue;
                }
                SparseIntArray array = sparseArray.get(dialog_id);
                if (array != null) {
                    for (int a = 0; a < array.size(); a++) {
                        int messageId = array.keyAt(a);
                        MessageObject messageObject = messagesDict[0].get(messageId);
                        if (messageObject != null) {
                            int newValue = array.get(messageId);
                            if (b == 0) {
                                if (newValue <= messageObject.messageOwner.views) {
                                    continue;
                                }
                                messageObject.messageOwner.views = newValue;
                            } else {
                                if (newValue <= messageObject.messageOwner.forwards) {
                                    continue;
                                }
                                messageObject.messageOwner.forwards = newValue;
                            }
                            if (messageObject.hasValidGroupId()) {
                                MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(messageObject.getGroupId());
                                if (groupedMessages != null) {
                                    if (newGroups == null) {
                                        newGroups = new LongSparseArray<>();
                                    }
                                    newGroups.put(groupedMessages.groupId, groupedMessages);
                                }
                            }
                            if (chatAdapter != null) {
                                chatAdapter.updateRowWithMessageObject(messageObject, false);
                            }
                        }
                    }
                }
            }
            if (channelReplies != null) {
                SparseArray<TLRPC.MessageReplies> array = channelReplies.get(dialog_id);
                boolean hasChatInBack = false;

                if (threadMessageObject != null && !isTopic && parentLayout != null) {
                    for (int a = 0, N = parentLayout.getFragmentStack().size() - 1; a < N; a++) {
                        BaseFragment fragment = parentLayout.getFragmentStack().get(a);
                        if (fragment != this && fragment instanceof ChatActivity) {
                            ChatActivity chatActivity = (ChatActivity) fragment;
                            if (chatActivity.needRemovePreviousSameChatActivity && chatActivity.dialog_id == dialog_id && chatActivity.getTopicId() == getTopicId() && chatActivity.getChatMode() == getChatMode()) {
                                hasChatInBack = true;
                                break;
                            }
                        }
                    }
                }

                if (array != null) {
                    for (int a = 0; a < array.size(); a++) {
                        int messageId = array.keyAt(a);
                        MessageObject messageObject = messagesDict[0].get(messageId);
                        if (messageObject != null && messageObject != threadMessageObject) {
                            TLRPC.MessageReplies newValue = array.get(messageId);
                            if (newValue == null || !addingReplies && messageObject.messageOwner.replies != null && newValue.replies_pts <= messageObject.messageOwner.replies.replies_pts && newValue.read_max_id <= messageObject.messageOwner.replies.read_max_id && newValue.max_id <= messageObject.messageOwner.replies.max_id) {
                                continue;
                            }
                            if (addingReplies) {
                                if (!hasChatInBack) {
                                    if (messageObject.messageOwner.replies == null) {
                                        messageObject.messageOwner.replies = new TLRPC.TL_messageReplies();
                                    }
                                    messageObject.messageOwner.replies.replies += newValue.replies;
                                    for (int c = 0, N = newValue.recent_repliers.size(); c < N; c++) {
                                        messageObject.messageOwner.replies.recent_repliers.remove(newValue.recent_repliers.get(c));
                                    }
                                    messageObject.messageOwner.replies.recent_repliers.addAll(0, newValue.recent_repliers);
                                    while (messageObject.messageOwner.replies.recent_repliers.size() > 3) {
                                        messageObject.messageOwner.replies.recent_repliers.remove(0);
                                    }
                                }
                            } else {
                                if (messageObject.messageOwner.replies != null && messageObject.messageOwner.replies.read_max_id > newValue.read_max_id) {
                                    newValue.read_max_id = messageObject.messageOwner.replies.read_max_id;
                                }
                                messageObject.messageOwner.replies = newValue;
                            }
                            if (messageObject.hasValidGroupId()) {
                                MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(messageObject.getGroupId());
                                if (groupedMessages != null) {
                                    if (newGroups == null) {
                                        newGroups = new LongSparseArray<>();
                                    }
                                    newGroups.put(groupedMessages.groupId, groupedMessages);
                                    for (int b = 0, N2 = groupedMessages.messages.size(); b < N2; b++) {
                                        groupedMessages.messages.get(b).animateComments = true;
                                    }
                                }
                            } else if (chatAdapter != null) {
                                int row = messages.indexOf(messageObject);
                                if (row >= 0) {
                                    if (updatedRows == null) {
                                        updatedRows = new ArrayList<>();
                                    }
                                    updatedRows.add(row + chatAdapter.messagesStartRow);
                                }
                                messageObject.animateComments = true;
                            }
                            updated = true;
                        }
                    }
                }
            }
            if (updated) {
                if (chatAdapter != null) {
                    if (newGroups != null) {
                        for (int b = 0, N = newGroups.size(); b < N; b++) {
                            MessageObject.GroupedMessages groupedMessages = newGroups.valueAt(b);
                            MessageObject messageObject = groupedMessages.messages.get(groupedMessages.messages.size() - 1);
                            int index = messages.indexOf(messageObject);
                            if (index >= 0) {
                                chatAdapter.notifyItemRangeChanged(index + chatAdapter.messagesStartRow, groupedMessages.messages.size());
                            }
                        }
                    }
                    if (updatedRows != null) {
                        for (int b = 0, N = updatedRows.size(); b < N; b++) {
                            chatAdapter.notifyItemChanged(updatedRows.get(b));
                        }
                    }
                }
                updateVisibleRows();
                updateReplyMessageHeader(true);
            }
        } else if (id == NotificationCenter.peerSettingsDidLoad) {
            long did = (Long) args[0];
            if (did == dialog_id || currentUser != null && currentUser.id == did) {
                updateTopPanel(!paused);
                updateInfoTopView(true);
            }
        } else if (id == NotificationCenter.newDraftReceived) {
            long did = (Long) args[0];
            if (did == dialog_id) {
                applyDraftMaybe(true);
            }
        } else if (id == NotificationCenter.pinnedInfoDidLoad) {
            long did = (Long) args[0];
            if (did == dialog_id) {
                ArrayList<Integer> pinnedMessages = (ArrayList<Integer>) args[1];
                if (chatMode == MODE_PINNED) {
                    pinnedMessageIds = new ArrayList<>(pinnedMessages);
                    pinnedMessageObjects = new HashMap<>((HashMap<Integer, MessageObject>) args[2]);
                } else {
                    pinnedMessageIds = pinnedMessages;
                    pinnedMessageObjects = (HashMap<Integer, MessageObject>) args[2];
                }
                int fallbackId = pinnedMessageIds.isEmpty() ? 0 : pinnedMessageIds.get(0);
                if (isTopic) {
                    for (int i = 0; i < pinnedMessageIds.size(); i++) {
                        int messageId = pinnedMessages.get(i);
                        if (pinnedMessageObjects.get(messageId) == null) {
                            pinnedMessageIds.remove(i);
                            i--;
                            continue;
                        }
                        int messageTopicId = MessageObject.getTopicId(pinnedMessageObjects.get(messageId).messageOwner, true);
                        if (getTopicId() != messageTopicId) {
                            pinnedMessageObjects.remove(messageId);
                            pinnedMessageIds.remove(i);
                            i--;
                        }
                    }
                }

                loadedPinnedMessagesCount = pinnedMessageIds.size();
                totalPinnedMessagesCount = (Integer) args[3];
                pinnedEndReached = (Boolean) args[4];

                getMediaDataController().loadReplyMessagesForMessages(new ArrayList<>(pinnedMessageObjects.values()), dialog_id, false, 0, null);

                if (!inMenuMode && !loadingPinnedMessagesList && totalPinnedMessagesCount == 0 && !pinnedEndReached) {
                    getMediaDataController().loadPinnedMessages(dialog_id, 0, fallbackId);
                    loadingPinnedMessagesList = true;
                }
            }
        } else if (id == NotificationCenter.userInfoDidLoad) {
            Long uid = (Long) args[0];
            if (currentUser != null && currentUser.id == uid) {
                userInfo = (TLRPC.UserFull) args[1];
                checkThemeEmoticon();
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.checkChannelRights();
                    chatActivityEnterView.updateGiftButton(true);
                }
                if (headerItem != null) {
                    showAudioCallAsIcon = userInfo.phone_calls_available && !inPreviewMode;
                    if (avatarContainer != null) {
                        avatarContainer.setTitleExpand(showAudioCallAsIcon);
                    }
                    if (userInfo.phone_calls_available) {
                        if (showAudioCallAsIcon) {
                            if (audioCallIconItem != null) {
                                View item = audioCallIconItem.createView();
                                if (openAnimationStartTime != 0 && item.getVisibility() != View.VISIBLE) {
                                    item.setAlpha(0f);
                                    item.animate().alpha(1f).setDuration(160).setInterpolator(CubicBezierInterpolator.EASE_IN).setStartDelay(50).start();
                                }
                                audioCallIconItem.setVisibility(View.VISIBLE);
                            }
                        } else {
                            headerItem.showSubItem(call, true);
                        }
                        if (userInfo.video_calls_available) {
                            headerItem.showSubItem(video_call, true);
                        } else {
                            headerItem.hideSubItem(video_call);
                        }
                    } else {
                        headerItem.hideSubItem(call);
                        headerItem.hideSubItem(video_call);
                        if (audioCallIconItem != null) {
                            audioCallIconItem.setVisibility(View.GONE);
                        }
                    }
                }
                checkActionBarMenu(fragmentOpened);
                if (!inMenuMode && !loadingPinnedMessagesList && !pinnedMessageIds.isEmpty() && userInfo.pinned_msg_id > pinnedMessageIds.get(0)) {
                    getMediaDataController().loadPinnedMessages(dialog_id, 0, userInfo.pinned_msg_id);
                    loadingPinnedMessagesList = true;
                }
            }
        } else if (id == NotificationCenter.didSetNewWallpapper) {

            if (BuildVars.IS_CHAT_AIR && UserConfig.getInstance(currentAccount).renderMarkdown) {
                boolean isDark = Theme.getActiveTheme().isDark();
                updateMarkdownDark(isDark);
            }

            if (fragmentView != null) {
                contentView.setBackgroundImage(Theme.getCachedWallpaper(), Theme.isWallpaperMotion());
                progressView2.invalidate();
                if (emptyView != null) {
                    emptyView.invalidate();
                }
                if (bigEmptyView != null) {
                    bigEmptyView.invalidate();
                }
                if (floatingDateView != null) {
                    floatingDateView.invalidate();
                }
                chatListView.invalidateViews();
            }
        } else if (id == NotificationCenter.didApplyNewTheme) {
            if (undoView == null || paused) {
                return;
            }
            Theme.ThemeInfo themeInfo = (Theme.ThemeInfo) args[0];
            Theme.ThemeAccent themeAccent = (Theme.ThemeAccent) args[1];
            if (!themeInfo.firstAccentIsDefault || themeAccent == null || themeAccent.id != Theme.DEFALT_THEME_ACCENT_ID) {
                return;
            }
            SharedPreferences preferences = MessagesController.getGlobalMainSettings();
            if (preferences.getBoolean("themehint", false)) {
                return;
            }
            preferences.edit().putBoolean("themehint", true).commit();
            boolean deleteTheme = (Boolean) args[2];
            createUndoView();
            if (undoView == null) {
                return;
            }
            undoView.showWithAction(0, UndoView.ACTION_THEME_CHANGED, null, () -> {
                if (themeAccent != null) {
                    Theme.ThemeAccent prevAccent = themeInfo.getAccent(false);
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.needSetDayNightTheme, themeInfo, false, null, themeAccent.id);
                    if (deleteTheme) {
                        Theme.deleteThemeAccent(themeInfo, prevAccent, true);
                    }
                } else {
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.needSetDayNightTheme, themeInfo, false, null, -1);
                }
            });
        } else if (id == NotificationCenter.goingToPreviewTheme) {
            isPauseOnThemePreview = true;
            if (chatLayoutManager != null) {
                scrollToPositionOnRecreate = chatLayoutManager.findFirstVisibleItemPosition();
                RecyclerListView.Holder holder = (RecyclerListView.Holder) chatListView.findViewHolderForAdapterPosition(scrollToPositionOnRecreate);
                if (holder != null) {
                    scrollToOffsetOnRecreate = chatListView.getMeasuredHeight() - holder.itemView.getBottom() - chatListView.getPaddingBottom();
                } else {
                    scrollToPositionOnRecreate = -1;
                }
            }
        } else if (id == NotificationCenter.channelRightsUpdated) {
            TLRPC.Chat chat = (TLRPC.Chat) args[0];
            if (currentChat != null && chat.id == currentChat.id && chatActivityEnterView != null) {
                currentChat = chat;
                chatActivityEnterView.checkChannelRights();
                checkRaiseSensors();
                updateSecretStatus();
                if (currentChat.gigagroup) {
                    updateBottomOverlay();
                }
            }
        } else if (id == NotificationCenter.updateMentionsCount) {
            long dialogId = (Long) args[0];
            int topicId = (Integer) args[1];
            if (dialog_id == dialogId && this.getTopicId() == topicId) {
                int count = (int) args[2];
                if (newMentionsCount > count) {
                    newMentionsCount = count;
                    if (newMentionsCount <= 0) {
                        newMentionsCount = 0;
                        hasAllMentionsLocal = true;
                        showMentionDownButton(false, true);
                    } else {
                        mentiondownButtonCounter.setText(String.format("%d", newMentionsCount));
                    }
                }
            }
        } else if (id == NotificationCenter.audioRecordTooShort) {
            int guid = (Integer) args[0];
            if (guid != classGuid) {
                return;
            }
            int time = (Integer) args[2];
            if (time < 100) {
                showVoiceHint(false, (Boolean) args[1]);
            }
        } else if (id == NotificationCenter.videoLoadingStateChanged) {
            if (chatListView != null) {
                String fileName = (String) args[0];
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View child = chatListView.getChildAt(a);
                    if (!(child instanceof ChatMessageCell)) {
                        continue;
                    }
                    ChatMessageCell cell = (ChatMessageCell) child;
                    TLRPC.Document document = cell.getStreamingMedia();
                    if (document == null) {
                        continue;
                    }
                    if (FileLoader.getAttachFileName(document).equals(fileName)) {
                        cell.updateButtonState(false, true, false);
                    }
                }
            }
        } else if (id == NotificationCenter.scheduledMessagesUpdated) {
            long did = (Long) args[0];
            if (dialog_id == did) {
                scheduledMessagesCount = (Integer) args[1];
                updateScheduledInterface(openAnimationEnded);
            }
        } else if (id == NotificationCenter.diceStickersDidLoad) {
            if (chatListView == null) {
                return;
            }
            int count = chatListView.getChildCount();
            for (int a = 0; a < count; a++) {
                View child = chatListView.getChildAt(a);
                if (!(child instanceof ChatMessageCell)) {
                    continue;
                }
                ChatMessageCell cell = (ChatMessageCell) child;
                if (cell.getMessageObject().isDice()) {
                    cell.setCurrentDiceValue(true);
                }
            }
        } else if (id == NotificationCenter.dialogDeleted) {
            long did = (Long) args[0];
            if (did == dialog_id) {
                if (parentLayout != null && parentLayout.getLastFragment() == this) {
                    finishFragment();
                } else {
                    removeSelfFromStack();
                }
            }
        } else if (id == NotificationCenter.needSetDayNightTheme) {
            Theme.ThemeInfo theme = (Theme.ThemeInfo) args[0];
            if (theme != null) {
                if (chatThemeBottomSheet != null) {
                    chatThemeBottomSheet.setupLightDarkTheme(theme.isDark());
                } else {
                    themeDelegate.setCurrentTheme(themeDelegate.chatTheme, true, theme.isDark());
                }
            }
        } else if (id == NotificationCenter.chatAvailableReactionsUpdated) {
            long chatId = (long) args[0];
            int topicId = (int) args[1];
            if (chatId == -dialog_id && (!isTopic || getTopicId() == topicId)) {
                chatInfo = getMessagesController().getChatFull(chatId);
            }
        } else if (id == NotificationCenter.dialogsUnreadReactionsCounterChanged) {
            long dialogId = (long) args[0];
            int topicId = (int) args[1];
            if (dialogId == dialog_id && (!isTopic || topicId == getTopicId())) {
                reactionsMentionCount = (int) args[2];
                ArrayList<Integer> messages = null;
                if (args[2] != null) {
                    messages = (ArrayList<Integer>) args[3];
                }
                if (messages != null) {
                    for (int i = 0; i < messages.size(); i++) {
                        int messageId = messages.get(i);
                        ChatMessageCell cell = findMessageCell(messageId, true);
                        if (cell != null && reactionsMentionCount > 0) {
                            reactionsMentionCount--;
                            getMessagesStorage().markMessageReactionsAsRead(getDialogId(), getTopicId(), cell.getMessageObject().getId(), true);
                            AndroidUtilities.runOnUIThread(() -> {
                                playReactionAnimation(messageId);
                            }, 200);
                        }
                    }
                }
                if (reactionsMentionCount <= 0) {
                    reactionsMentionCount = 0;
                    getMessagesController().markReactionsAsRead(dialogId, getTopicId());
                }
                updateReactionsMentionButton(true);
            }
        } else if (id == NotificationCenter.topicsDidLoaded) {
            if (isTopic) {
                if (getParentActivity() == null) {
                    return;
                }
                updateTopicTitleIcon();
                updateTopicHeader();
                updateBottomOverlay();
                updateTopPanel(true);
                if (avatarContainer != null) {
                    avatarContainer.updateSubtitle();
                }
            }
        } else if (id == NotificationCenter.dialogTranslate) {
            final long dialogId = (long) args[0];
            if (getDialogId() != dialogId) {
                return;
            }

            updateTopPanel(true);
            if (chatListView != null && chatAdapter != null) {
                boolean updatedPinned = false;
                ArrayList<Long> groupChecked = new ArrayList<>();
                for (int i = 0; i < chatListView.getChildCount(); ++i) {
                    View child = chatListView.getChildAt(i);
                    if (child instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) child;
                        MessageObject messageObject = cell.getMessageObject();
                        boolean update = false;
                        if (messageObject != null && messageObject.updateTranslation(false)) {
                            update = true;

                            MessageObject pinnedMessageObject = pinnedMessageObjects.get(messageObject.getId());
                            if (pinnedMessageObject != null) {
                                pinnedMessageObject.messageOwner.translatedText = messageObject.messageOwner.translatedText;
                                pinnedMessageObject.messageOwner.translatedToLanguage = messageObject.messageOwner.translatedToLanguage;
                                if (pinnedMessageObject.updateTranslation(currentPinnedMessageId == messageObject.getId())) {
                                    updatedPinned = true;
                                }
                            }
                        }
                        MessageObject.GroupedMessages group = groupedMessagesMap.get(messageObject.getGroupId());
                        if (group != null && !groupChecked.contains(group.groupId)) {
                            for (int j = 0; j < group.messages.size(); ++j) {
                                MessageObject groupMessageObject = group.messages.get(j);
                                if (groupMessageObject != null && groupMessageObject.updateTranslation(false)) {
                                    update = true;
                                }
                            }
                            groupChecked.add(group.groupId);
                        }
                        if (messageObject != null && messageObject.replyMessageObject != null) {
                            MessageObject translatedReplyMessageObject = getMessagesController().getTranslateController().findReplyMessageObject(dialogId, messageObject.replyMessageObject.getId());
                            if (translatedReplyMessageObject != null) {
                                messageObject.replyMessageObject.messageOwner.translatedText = translatedReplyMessageObject.messageOwner.translatedText;
                                messageObject.replyMessageObject.messageOwner.translatedToLanguage = translatedReplyMessageObject.messageOwner.translatedToLanguage;
                                if (messageObject.replyMessageObject.updateTranslation(true)) {
                                    update = true;
                                }
                            }
                        }

                        if (update) {
                            messageObject.forceUpdate = true;
                            cell.setMessageObject(messageObject, cell.getCurrentMessagesGroup(), cell.isPinnedBottom(), cell.isPinnedTop());
                            if (group != null) {
                                if (chatListItemAnimator != null) {
                                    chatListItemAnimator.groupWillChanged(group);
                                }
                                for (int j = 0; j < group.messages.size(); j++) {
                                    group.messages.get(j).forceUpdate = true;
                                }
                                chatAdapter.notifyDataSetChanged(true);
                            } else {
                                chatAdapter.updateRowAtPosition(chatListView.getChildAdapterPosition(child));
                            }
                        } else {
                            cell.invalidate();
                        }
                    }
                }
                if (!updatedPinned) {
                    for (MessageObject pinnedMessageObject : pinnedMessageObjects.values()) {
                        if (pinnedMessageObject != null && pinnedMessageObject.updateTranslation(currentPinnedMessageId == pinnedMessageObject.getId())) {
                            updatedPinned = true;
                        }
                    }
                }
                if (updatedPinned) {
                    updatePinnedMessageView(true, 1);
                }
            }
            checkTranslation(true);
            updateTranslateItemVisibility();
        } else if (id == NotificationCenter.messageTranslated) {
            MessageObject messageObject = (MessageObject) args[0];
            if (getDialogId() != messageObject.getDialogId()) {
                return;
            }
            updateMessageTranslation(messageObject);
            if (args.length > 1 && (boolean) args[1]) {
                checkTranslation(true);
            }
        } else if (id == NotificationCenter.messageTranslating) {
            MessageObject messageObject = (MessageObject) args[0];
            if (getDialogId() != messageObject.getDialogId()) {
                return;
            }
            if (chatListView == null || chatAdapter == null) {
                return;
            }
            for (int i = 0; i < chatListView.getChildCount(); ++i) {
                View child = chatListView.getChildAt(i);
                if (child instanceof ChatMessageCell) {
                    child.invalidate();
                }
            }
        } else if (id == NotificationCenter.dialogIsTranslatable) {
            final long dialogId = (long) args[0];
            if (getDialogId() != dialogId) {
                return;
            }

            updateTopPanel(true);
            updateTranslateItemVisibility();
        } else if (id == NotificationCenter.showAlert) {
            int type = (int) args[0];
            switch (type) {
                case AlertsCreator.TYPE_ALERT_ERROR:
                    AlertsCreator.processError((String) args[1], this);
                    break;
            }
        }
    }

    private boolean updateMessageTranslation(MessageObject messageObject) {
        if (messageObject == null || messageObject.messageOwner == null) {
            return false;
        }
        boolean updated = false;
        for (MessageObject pinnedMessageObject : pinnedMessageObjects.values()) {
            if (pinnedMessageObject != null && pinnedMessageObject.getId() == messageObject.getId()) {
                pinnedMessageObject.messageOwner.translatedText = messageObject.messageOwner.translatedText;
                pinnedMessageObject.messageOwner.translatedToLanguage = messageObject.messageOwner.translatedToLanguage;
                if (pinnedMessageObject.updateTranslation(true)) {
                    updatePinnedMessageView(true, 1);
                    updated = true;
                }
            }
        }
        if (chatListView == null) {
            return updated;
        }
        ArrayList<Long> groupChecked = new ArrayList<>();
        for (int i = 0; i < chatListView.getChildCount(); ++i) {
            View child = chatListView.getChildAt(i);
            if (child instanceof ChatMessageCell) {
                ChatMessageCell cell = (ChatMessageCell) child;
                MessageObject cellMessageObject = cell.getMessageObject();
                if (cellMessageObject == null) {
                    continue;
                }
                boolean update = false;
                if (cellMessageObject.getId() == messageObject.getId()) {
                    cellMessageObject.messageOwner.translatedText = messageObject.messageOwner.translatedText;
                    cellMessageObject.messageOwner.translatedToLanguage = messageObject.messageOwner.translatedToLanguage;
                    if (cellMessageObject.updateTranslation(false)) {
                        update = true;
                        ArrayList<Integer> dependentMessages = replyMessageOwners.get(cellMessageObject.getId());
                        if (dependentMessages != null) {
                            updateMessagesReplyTranslation(dependentMessages, messageObject);
                        }
                    }
                }
                MessageObject.GroupedMessages group = groupedMessagesMap.get(messageObject.getGroupId());
                if (group != null && !groupChecked.contains(group.groupId)) {
                    for (int j = 0; j < group.messages.size(); ++j) {
                        MessageObject groupMessageObject = group.messages.get(j);
                        if (groupMessageObject != null && groupMessageObject.updateTranslation(false)) {
                            update = true;
                        }
                    }
                    groupChecked.add(group.groupId);
                }
                if (cellMessageObject.replyMessageObject != null && cellMessageObject.replyMessageObject.getId() == messageObject.getId() && cellMessageObject.replyMessageObject.getDialogId() == messageObject.getDialogId()) {
                    cellMessageObject.replyMessageObject.messageOwner.translatedText = messageObject.messageOwner.translatedText;
                    cellMessageObject.replyMessageObject.messageOwner.translatedToLanguage = messageObject.messageOwner.translatedToLanguage;
                    if (cellMessageObject.replyMessageObject.updateTranslation(false)) {
                        update = true;
                    }
                }
                if (update) {
                    cellMessageObject.forceUpdate = true;
                    cell.setMessageObject(cellMessageObject, cell.getCurrentMessagesGroup(), cell.isPinnedBottom(), cell.isPinnedTop());
                    if (group != null) {
                        if (chatListItemAnimator != null) {
                            chatListItemAnimator.groupWillChanged(group);
                        }
                        for (int j = 0; j < group.messages.size(); j++) {
                            group.messages.get(j).forceUpdate = true;
                        }
                        chatAdapter.notifyDataSetChanged(true);
                    } else {
                        chatAdapter.updateRowAtPosition(chatListView.getChildAdapterPosition(child));
                    }
                    updated = true;
                }
            }
        }
        return updated;
    }


    private boolean updateMessagesReplyTranslation(ArrayList<Integer> messageIds, MessageObject translatedReplyMessageObject) {
        boolean updated = false;
        for (int i = 0; i < chatListView.getChildCount(); ++i) {
            View child = chatListView.getChildAt(i);
            if (child instanceof ChatMessageCell) {
                ChatMessageCell cell = (ChatMessageCell) child;
                MessageObject cellMessageObject = cell.getMessageObject();
                boolean update = false;
                if (cellMessageObject != null && messageIds.contains(cellMessageObject.getId()) && cellMessageObject.replyMessageObject != null && cellMessageObject.replyMessageObject.getId() == translatedReplyMessageObject.getId()) {
                    cellMessageObject.replyMessageObject.messageOwner.translatedText = translatedReplyMessageObject.messageOwner.translatedText;
                    cellMessageObject.replyMessageObject.messageOwner.translatedToLanguage = translatedReplyMessageObject.messageOwner.translatedToLanguage;
                    if (cellMessageObject.replyMessageObject.updateTranslation(false)) {
                        update = true;
                    }
                }
                if (update) {
                    cellMessageObject.forceUpdate = true;
                    cell.setMessageObject(cellMessageObject, cell.getCurr