# Rust web framework comparison

A comparison of some web frameworks written in [Rust](https://www.rust-lang.org).

This overview only contains frameworks that work on stable Rust.

## Table of Contents

- [Frontend frameworks (WASM)](#frontend-frameworks-wasm)
  - [Outdated frontend frameworks](#outdated-frontend-frameworks)
- [Server frameworks](#server-frameworks)
  - [High-Level Server Frameworks](#high-level-server-frameworks)
  - [Low-Level Frameworks](#low-level-frameworks)
  - [Outdated server frameworks](#outdated-server-frameworks)
- [Client frameworks](#client-frameworks)
  - [Outdated client frameworks](#outdated-client-frameworks)
- [Templating](#templating)
- [Websocket Libraries](#websocket-libraries)

## Frontend frameworks (WASM)

Since [WASM](http://webassembly.org/) support is available in most browsers we can use Rust to build web applications :)

| Name                                                     | Stars                                                                                      | Contributors                                                                                             | Activity                                                                                                  | Downloads | Virtual DOM | SSR | Rendering | Architecture                                                                           | Repo                                                                                                       | Docs                                                                                                                | License                                                                       | Version                                                                       |
|----------------------------------------------------------|--------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|-----------|-------------|-----|-----------|----------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------|-------------------------------------------------------------------------------|
| **[Dioxus](https://dioxuslabs.com/)**                    | ![Dioxus stars](https://img.shields.io/github/stars/dioxuslabs/dioxus.svg?label=%20)       | ![Dioxus contributors](https://img.shields.io/github/contributors/dioxuslabs/dioxus.svg?label=%20)       | ![Dioxus activity](https://img.shields.io/github/commit-activity/y/dioxuslabs/dioxus.svg?label=%20)       | 307.0k    | yes         | yes | HTML      | [React/Redux](https://medium.com/mofed/react-redux-architecture-overview-7b3e52004b6e) | [![Dioxus repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/dioxuslabs/dioxus)       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=dioxus&color=green)](https://docs.rs/dioxus/)       | ![Dioxus license](https://img.shields.io/crates/l/dioxus.svg?label=%20)       | ![Dioxus version](https://img.shields.io/crates/v/dioxus.svg?label=%20)       |
| **[dominator](https://github.com/Pauan/rust-dominator)** | ![dominator stars](https://img.shields.io/github/stars/Pauan/rust-dominator.svg?label=%20) | ![dominator contributors](https://img.shields.io/github/contributors/Pauan/rust-dominator.svg?label=%20) | ![dominator activity](https://img.shields.io/github/commit-activity/y/Pauan/rust-dominator.svg?label=%20) | 157.1k    | no          | no  | HTML      | [FRP](https://en.wikipedia.org/wiki/Functional_reactive_programming)                   | [![dominator repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/Pauan/rust-dominator) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=dominator&color=green)](https://docs.rs/dominator/) | ![dominator license](https://img.shields.io/crates/l/dominator.svg?label=%20) | ![dominator version](https://img.shields.io/crates/v/dominator.svg?label=%20) |
| **[egui](https://www.egui.rs/)**                         | ![egui stars](https://img.shields.io/github/stars/emilk/egui.svg?label=%20)                | ![egui contributors](https://img.shields.io/github/contributors/emilk/egui.svg?label=%20)                | ![egui activity](https://img.shields.io/github/commit-activity/y/emilk/egui.svg?label=%20)                | 3614.9k   | no          | no  | Canvas    | [ImGUI](https://en.wikipedia.org/wiki/Immediate_mode_GUI)                              | [![egui repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/emilk/egui)                | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=egui&color=green)](https://docs.rs/egui/)           | ![egui license](https://img.shields.io/crates/l/egui.svg?label=%20)           | ![egui version](https://img.shields.io/crates/v/egui.svg?label=%20)           |
| **[Leptos](https://github.com/gbj/leptos)**              | ![Leptos stars](https://img.shields.io/github/stars/gbj/leptos.svg?label=%20)              | ![Leptos contributors](https://img.shields.io/github/contributors/gbj/leptos.svg?label=%20)              | ![Leptos activity](https://img.shields.io/github/commit-activity/y/gbj/leptos.svg?label=%20)              | 735.1k    | no          | yes | HTML      | [FRP](https://en.wikipedia.org/wiki/Functional_reactive_programming)                   | [![Leptos repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/gbj/leptos)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=leptos&color=green)](https://docs.rs/leptos/)       | ![Leptos license](https://img.shields.io/crates/l/leptos.svg?label=%20)       | ![Leptos version](https://img.shields.io/crates/v/leptos.svg?label=%20)       |
| **[sauron](https://github.com/ivanceras/sauron)**        | ![sauron stars](https://img.shields.io/github/stars/ivanceras/sauron.svg?label=%20)        | ![sauron contributors](https://img.shields.io/github/contributors/ivanceras/sauron.svg?label=%20)        | ![sauron activity](https://img.shields.io/github/commit-activity/y/ivanceras/sauron.svg?label=%20)        | 291.6k    | yes         | yes | HTML      | [TEA](https://guide.elm-lang.org/architecture/)                                        | [![sauron repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/ivanceras/sauron)        | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=sauron&color=green)](https://docs.rs/sauron/)       | ![sauron license](https://img.shields.io/crates/l/sauron.svg?label=%20)       | ![sauron version](https://img.shields.io/crates/v/sauron.svg?label=%20)       |
| **[Silkenweb](https://github.com/silkenweb/silkenweb)**  | ![Silkenweb stars](https://img.shields.io/github/stars/silkenweb/silkenweb.svg?label=%20)  | ![Silkenweb contributors](https://img.shields.io/github/contributors/silkenweb/silkenweb.svg?label=%20)  | ![Silkenweb activity](https://img.shields.io/github/commit-activity/y/silkenweb/silkenweb.svg?label=%20)  | 8.7k      | no          | yes | HTML      | [FRP](https://en.wikipedia.org/wiki/Functional_reactive_programming)                   | [![Silkenweb repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/silkenweb/silkenweb)  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=silkenweb&color=green)](https://docs.rs/silkenweb/) | ![Silkenweb license](https://img.shields.io/crates/l/silkenweb.svg?label=%20) | ![Silkenweb version](https://img.shields.io/crates/v/silkenweb.svg?label=%20) |
| **[Sycamore](https://sycamore-rs.netlify.app/)**         | ![Sycamore stars](https://img.shields.io/github/stars/sycamore-rs/sycamore.svg?label=%20)  | ![Sycamore contributors](https://img.shields.io/github/contributors/sycamore-rs/sycamore.svg?label=%20)  | ![Sycamore activity](https://img.shields.io/github/commit-activity/y/sycamore-rs/sycamore.svg?label=%20)  | 155.1k    | no          | yes | HTML      | [FRP](https://en.wikipedia.org/wiki/Functional_reactive_programming)                   | [![Sycamore repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/sycamore-rs/sycamore)  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=sycamore&color=green)](https://docs.rs/sycamore/)   | ![Sycamore license](https://img.shields.io/crates/l/sycamore.svg?label=%20)   | ![Sycamore version](https://img.shields.io/crates/v/sycamore.svg?label=%20)   |
| **[Vizia](https://github.com/vizia/vizia)**              | ![Vizia stars](https://img.shields.io/github/stars/vizia/vizia.svg?label=%20)              | ![Vizia contributors](https://img.shields.io/github/contributors/vizia/vizia.svg?label=%20)              | ![Vizia activity](https://img.shields.io/github/commit-activity/y/vizia/vizia.svg?label=%20)              | 1.6k      | no          | no  | Canvas    |                                                                                        | [![Vizia repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/vizia/vizia)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=vizia&color=green)](https://docs.rs/vizia/)         | ![Vizia license](https://img.shields.io/crates/l/vizia.svg?label=%20)         | ![Vizia version](https://img.shields.io/crates/v/vizia.svg?label=%20)         |

### Outdated frontend frameworks

| Name                                                 | Stars                                                                                  | Contributors                                                                                         | Activity                                                                                              | Downloads | Virtual DOM | SSR | Rendering | Architecture                                                                           | Repo                                                                                                   | Docs                                                                                                            | License                                                                   | Version                                                                   |
|------------------------------------------------------|----------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------|-----------|-------------|-----|-----------|----------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------|---------------------------------------------------------------------------|
| **[dodrio](https://github.com/fitzgen/dodrio)**      | ![dodrio stars](https://img.shields.io/github/stars/fitzgen/dodrio.svg?label=%20)      | ![dodrio contributors](https://img.shields.io/github/contributors/fitzgen/dodrio.svg?label=%20)      | ![dodrio activity](https://img.shields.io/github/commit-activity/y/fitzgen/dodrio.svg?label=%20)      | 145.8k    |             |     |           |                                                                                        | [![dodrio repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/fitzgen/dodrio)      | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=dodrio&color=green)](https://docs.rs/dodrio/)   | ![dodrio license](https://img.shields.io/crates/l/dodrio.svg?label=%20)   | ![dodrio version](https://img.shields.io/crates/v/dodrio.svg?label=%20)   |
| **[draco](https://github.com/utkarshkukreti/draco)** | ![draco stars](https://img.shields.io/github/stars/utkarshkukreti/draco.svg?label=%20) | ![draco contributors](https://img.shields.io/github/contributors/utkarshkukreti/draco.svg?label=%20) | ![draco activity](https://img.shields.io/github/commit-activity/y/utkarshkukreti/draco.svg?label=%20) |  -        |             |     |           |                                                                                        | [![draco repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/utkarshkukreti/draco) |                                                                                                                 |                                                                           |                                                                           |
| **[dumle](https://github.com/axelf4/dumle)**         | ![dumle stars](https://img.shields.io/github/stars/axelf4/dumle.svg?label=%20)         | ![dumle contributors](https://img.shields.io/github/contributors/axelf4/dumle.svg?label=%20)         | ![dumle activity](https://img.shields.io/github/commit-activity/y/axelf4/dumle.svg?label=%20)         |  -        |             |     |           |                                                                                        | [![dumle repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/axelf4/dumle)         |                                                                                                                 |                                                                           |                                                                           |
| **[frender](https://frender-rs.github.io/frender/)** | ![frender stars](https://img.shields.io/github/stars/frender-rs/frender.svg?label=%20) | ![frender contributors](https://img.shields.io/github/contributors/frender-rs/frender.svg?label=%20) | ![frender activity](https://img.shields.io/github/commit-activity/y/frender-rs/frender.svg?label=%20) | 3.6k      | yes         | no  |           |                                                                                        | [![frender repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/frender-rs/frender) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=frender&color=green)](https://docs.rs/frender/) | ![frender license](https://img.shields.io/crates/l/frender.svg?label=%20) | ![frender version](https://img.shields.io/crates/v/frender.svg?label=%20) |
| **[Iced](https://iced.rs/)**                         | ![Iced stars](https://img.shields.io/github/stars/iced-rs/iced.svg?label=%20)          | ![Iced contributors](https://img.shields.io/github/contributors/iced-rs/iced.svg?label=%20)          | ![Iced activity](https://img.shields.io/github/commit-activity/y/iced-rs/iced.svg?label=%20)          | 636.0k    | no          | no  | Canvas    | [TEA](https://guide.elm-lang.org/architecture/)                                        | [![Iced repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/iced-rs/iced)          | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=iced&color=green)](https://docs.rs/iced/)       | ![Iced license](https://img.shields.io/crates/l/iced.svg?label=%20)       | ![Iced version](https://img.shields.io/crates/v/iced.svg?label=%20)       |
| **[Kobold](https://github.com/maciejhirsz/kobold)**  | ![Kobold stars](https://img.shields.io/github/stars/maciejhirsz/kobold.svg?label=%20)  | ![Kobold contributors](https://img.shields.io/github/contributors/maciejhirsz/kobold.svg?label=%20)  | ![Kobold activity](https://img.shields.io/github/commit-activity/y/maciejhirsz/kobold.svg?label=%20)  | 9.8k      | no          |     | HTML      | [React/Redux](https://medium.com/mofed/react-redux-architecture-overview-7b3e52004b6e) | [![Kobold repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/maciejhirsz/kobold)  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=kobold&color=green)](https://docs.rs/kobold/)   | ![Kobold license](https://img.shields.io/crates/l/kobold.svg?label=%20)   | ![Kobold version](https://img.shields.io/crates/v/kobold.svg?label=%20)   |
| **[mika](https://gitlab.com/limira-rs/mika)**        |                                                                                        |                                                                                                      |                                                                                                       | 1.2k      |             |     |           |                                                                                        | [![Repo](https://img.shields.io/badge/GitLab-git-blue)](https://gitlab.com/limira-rs/mika)             | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=mika&color=green)](https://docs.rs/mika/)       | ![mika license](https://img.shields.io/crates/l/mika.svg?label=%20)       | ![mika version](https://img.shields.io/crates/v/mika.svg?label=%20)       |
| **[mogwai](https://github.com/schell/mogwai)**       | ![mogwai stars](https://img.shields.io/github/stars/schell/mogwai.svg?label=%20)       | ![mogwai contributors](https://img.shields.io/github/contributors/schell/mogwai.svg?label=%20)       | ![mogwai activity](https://img.shields.io/github/commit-activity/y/schell/mogwai.svg?label=%20)       | 31.6k     | no          | yes | HTML      |                                                                                        | [![mogwai repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/schell/mogwai)       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=mogwai&color=green)](https://docs.rs/mogwai/)   | ![mogwai license](https://img.shields.io/crates/l/mogwai.svg?label=%20)   | ![mogwai version](https://img.shields.io/crates/v/mogwai.svg?label=%20)   |
| **[MoonZoon](http://moonzoon.rs/)**                  | ![MoonZoon stars](https://img.shields.io/github/stars/MoonZoon/MoonZoon.svg?label=%20) | ![MoonZoon contributors](https://img.shields.io/github/contributors/MoonZoon/MoonZoon.svg?label=%20) | ![MoonZoon activity](https://img.shields.io/github/commit-activity/y/MoonZoon/MoonZoon.svg?label=%20) |  -        | no          | no  | HTML      | [FRP](https://en.wikipedia.org/wiki/Functional_reactive_programming)                   | [![MoonZoon repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/MoonZoon/MoonZoon) |                                                                                                                 |                                                                           |                                                                           |
| **[percy](https://chinedufn.github.io/percy/)**      | ![percy stars](https://img.shields.io/github/stars/chinedufn/percy.svg?label=%20)      | ![percy contributors](https://img.shields.io/github/contributors/chinedufn/percy.svg?label=%20)      | ![percy activity](https://img.shields.io/github/commit-activity/y/chinedufn/percy.svg?label=%20)      |  -        | yes         | yes | HTML      |                                                                                        | [![percy repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/chinedufn/percy)      |                                                                                                                 |                                                                           |                                                                           |
| **[ruukh](https://github.com/csharad/ruukh)**        | ![ruukh stars](https://img.shields.io/github/stars/csharad/ruukh.svg?label=%20)        | ![ruukh contributors](https://img.shields.io/github/contributors/csharad/ruukh.svg?label=%20)        | ![ruukh activity](https://img.shields.io/github/commit-activity/y/csharad/ruukh.svg?label=%20)        |  -        |             |     |           |                                                                                        | [![ruukh repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/csharad/ruukh)        |                                                                                                                 |                                                                           |                                                                           |
| **[Seed](http://seed-rs.org/)**                      | ![Seed stars](https://img.shields.io/github/stars/seed-rs/seed.svg?label=%20)          | ![Seed contributors](https://img.shields.io/github/contributors/seed-rs/seed.svg?label=%20)          | ![Seed activity](https://img.shields.io/github/commit-activity/y/seed-rs/seed.svg?label=%20)          | 315.4k    | yes         | no  | HTML      | [TEA](https://guide.elm-lang.org/architecture/)                                        | [![Seed repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/seed-rs/seed)          | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=seed&color=green)](https://docs.rs/seed/)       | ![Seed license](https://img.shields.io/crates/l/seed.svg?label=%20)       | ![Seed version](https://img.shields.io/crates/v/seed.svg?label=%20)       |
| **[smithy](https://www.smithy.rs/)**                 | ![smithy stars](https://img.shields.io/github/stars/rbalicki2/smithy.svg?label=%20)    | ![smithy contributors](https://img.shields.io/github/contributors/rbalicki2/smithy.svg?label=%20)    | ![smithy activity](https://img.shields.io/github/commit-activity/y/rbalicki2/smithy.svg?label=%20)    | 9.2k      |             |     |           |                                                                                        | [![smithy repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/rbalicki2/smithy)    | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=smithy&color=green)](https://docs.rs/smithy/)   | ![smithy license](https://img.shields.io/crates/l/smithy.svg?label=%20)   | ![smithy version](https://img.shields.io/crates/v/smithy.svg?label=%20)   |
| **[spair](https://github.com/aclueless/spair)**      | ![spair stars](https://img.shields.io/github/stars/aclueless/spair.svg?label=%20)      | ![spair contributors](https://img.shields.io/github/contributors/aclueless/spair.svg?label=%20)      | ![spair activity](https://img.shields.io/github/commit-activity/y/aclueless/spair.svg?label=%20)      | 6.5k      | no          | no  | HTML      |                                                                                        | [![spair repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/aclueless/spair)      | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=spair&color=green)](https://docs.rs/spair/)     | ![spair license](https://img.shields.io/crates/l/spair.svg?label=%20)     | ![spair version](https://img.shields.io/crates/v/spair.svg?label=%20)     |
| **[squark](https://github.com/rail44/squark)**       | ![squark stars](https://img.shields.io/github/stars/rail44/squark.svg?label=%20)       | ![squark contributors](https://img.shields.io/github/contributors/rail44/squark.svg?label=%20)       | ![squark activity](https://img.shields.io/github/commit-activity/y/rail44/squark.svg?label=%20)       |  -        |             |     |           |                                                                                        | [![squark repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/rail44/squark)       |                                                                                                                 |                                                                           |                                                                           |
| **[stdweb](https://github.com/koute/stdweb)**        | ![stdweb stars](https://img.shields.io/github/stars/koute/stdweb.svg?label=%20)        | ![stdweb contributors](https://img.shields.io/github/contributors/koute/stdweb.svg?label=%20)        | ![stdweb activity](https://img.shields.io/github/commit-activity/y/koute/stdweb.svg?label=%20)        | 11256.8k  |             |     |           |                                                                                        | [![stdweb repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/koute/stdweb)        | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=stdweb&color=green)](https://docs.rs/stdweb/)   | ![stdweb license](https://img.shields.io/crates/l/stdweb.svg?label=%20)   | ![stdweb version](https://img.shields.io/crates/v/stdweb.svg?label=%20)   |
| **[willow](https://github.com/sindreij/willow)**     | ![willow stars](https://img.shields.io/github/stars/sindreij/willow.svg?label=%20)     | ![willow contributors](https://img.shields.io/github/contributors/sindreij/willow.svg?label=%20)     | ![willow activity](https://img.shields.io/github/commit-activity/y/sindreij/willow.svg?label=%20)     |  -        |             |     |           |                                                                                        | [![willow repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/sindreij/willow)     |                                                                                                                 |                                                                           |                                                                           |
| **[yew](https://yew.rs/)**                           | ![yew stars](https://img.shields.io/github/stars/yewstack/yew.svg?label=%20)           | ![yew contributors](https://img.shields.io/github/contributors/yewstack/yew.svg?label=%20)           | ![yew activity](https://img.shields.io/github/commit-activity/y/yewstack/yew.svg?label=%20)           | 1412.3k   | yes         | yes | HTML      | [React/Redux](https://medium.com/mofed/react-redux-architecture-overview-7b3e52004b6e) | [![yew repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/yewstack/yew)           | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=Yew&color=green)](https://docs.rs/Yew/)         | ![yew license](https://img.shields.io/crates/l/Yew.svg?label=%20)         | ![yew version](https://img.shields.io/crates/v/Yew.svg?label=%20)         |

## Server frameworks

### High-Level Server Frameworks

| Name                                           | Stars                                                                                     | Contributors                                                                                            | Activity                                                                                                 | Repo                                                                                                      | Docs                                                                                                                | License                                                                       | Version                                                                       | Async | HTTPS | HTTP/2 | Base  | Client |
|------------------------------------------------|-------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------|-------------------------------------------------------------------------------|-------|-------|--------|-------|--------|
| **[actix-web](https://actix.rs/)**             | ![actix-web stars](https://img.shields.io/github/stars/actix/actix-web.svg?label=%20)     | ![actix-web contributors](https://img.shields.io/github/contributors/actix/actix-web.svg?label=%20)     | ![actix-web activity](https://img.shields.io/github/commit-activity/y/actix/actix-web.svg?label=%20)     | [![actix-web repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/actix/actix-web)     | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=actix-web&color=green)](https://docs.rs/actix-web/) | ![actix-web license](https://img.shields.io/crates/l/actix-web.svg?label=%20) | ![actix-web version](https://img.shields.io/crates/v/actix-web.svg?label=%20) | yes   | yes   | yes    | tokio | no     |
| **[axum](https://github.com/tokio-rs/axum)**   | ![axum stars](https://img.shields.io/github/stars/tokio-rs/axum.svg?label=%20)            | ![axum contributors](https://img.shields.io/github/contributors/tokio-rs/axum.svg?label=%20)            | ![axum activity](https://img.shields.io/github/commit-activity/y/tokio-rs/axum.svg?label=%20)            | [![axum repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/tokio-rs/axum)            | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=axum&color=green)](https://docs.rs/axum/)           | ![axum license](https://img.shields.io/crates/l/axum.svg?label=%20)           | ![axum version](https://img.shields.io/crates/v/axum.svg?label=%20)           | yes   | yes   | yes    | hyper | no     |
| **[Poem](https://github.com/poem-web/poem)**   | ![Poem stars](https://img.shields.io/github/stars/poem-web/poem.svg?label=%20)            | ![Poem contributors](https://img.shields.io/github/contributors/poem-web/poem.svg?label=%20)            | ![Poem activity](https://img.shields.io/github/commit-activity/y/poem-web/poem.svg?label=%20)            | [![Poem repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/poem-web/poem)            | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=poem&color=green)](https://docs.rs/poem/)           | ![Poem license](https://img.shields.io/crates/l/poem.svg?label=%20)           | ![Poem version](https://img.shields.io/crates/v/poem.svg?label=%20)           | yes   | yes   | yes    | hyper | no     |
| **[rocket](https://rocket.rs/)**               | ![rocket stars](https://img.shields.io/github/stars/SergioBenitez/rocket.svg?label=%20)   | ![rocket contributors](https://img.shields.io/github/contributors/SergioBenitez/rocket.svg?label=%20)   | ![rocket activity](https://img.shields.io/github/commit-activity/y/SergioBenitez/rocket.svg?label=%20)   | [![rocket repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/SergioBenitez/rocket)   | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=rocket&color=green)](https://docs.rs/rocket/)       | ![rocket license](https://img.shields.io/crates/l/rocket.svg?label=%20)       | ![rocket version](https://img.shields.io/crates/v/rocket.svg?label=%20)       | yes   | yes   | yes    | hyper | no     |
| **[salvo](https://github.com/salvo-rs/salvo)** | ![salvo stars](https://img.shields.io/github/stars/salvo-rs/salvo.svg?label=%20)          | ![salvo contributors](https://img.shields.io/github/contributors/salvo-rs/salvo.svg?label=%20)          | ![salvo activity](https://img.shields.io/github/commit-activity/y/salvo-rs/salvo.svg?label=%20)          | [![salvo repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/salvo-rs/salvo)          | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=salvo&color=green)](https://docs.rs/salvo/)         | ![salvo license](https://img.shields.io/crates/l/salvo.svg?label=%20)         | ![salvo version](https://img.shields.io/crates/v/salvo.svg?label=%20)         | yes   | yes   | yes    | hyper | no     |
| **[trillium](https://trillium.rs/)**           | ![trillium stars](https://img.shields.io/github/stars/trillium-rs/trillium.svg?label=%20) | ![trillium contributors](https://img.shields.io/github/contributors/trillium-rs/trillium.svg?label=%20) | ![trillium activity](https://img.shields.io/github/commit-activity/y/trillium-rs/trillium.svg?label=%20) | [![trillium repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/trillium-rs/trillium) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=trillium&color=green)](https://docs.rs/trillium/)   | ![trillium license](https://img.shields.io/crates/l/trillium.svg?label=%20)   | ![trillium version](https://img.shields.io/crates/v/trillium.svg?label=%20)   | yes   | yes   | no     | tokio | no     |
| **[Viz](https://viz.rs/)**                     | ![Viz stars](https://img.shields.io/github/stars/viz-rs/viz.svg?label=%20)                | ![Viz contributors](https://img.shields.io/github/contributors/viz-rs/viz.svg?label=%20)                | ![Viz activity](https://img.shields.io/github/commit-activity/y/viz-rs/viz.svg?label=%20)                | [![Viz repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/viz-rs/viz)                | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=viz&color=green)](https://docs.rs/viz/)             | ![Viz license](https://img.shields.io/crates/l/viz.svg?label=%20)             | ![Viz version](https://img.shields.io/crates/v/viz.svg?label=%20)             | yes   | yes   | yes    | hyper | no     |
| **[wtx](https://c410-f3r.github.io/wtx/)**     | ![wtx stars](https://img.shields.io/github/stars/c410-f3r/wtx.svg?label=%20)              | ![wtx contributors](https://img.shields.io/github/contributors/c410-f3r/wtx.svg?label=%20)              | ![wtx activity](https://img.shields.io/github/commit-activity/y/c410-f3r/wtx.svg?label=%20)              | [![wtx repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/c410-f3r/wtx)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=wtx&color=green)](https://docs.rs/wtx/)             | ![wtx license](https://img.shields.io/crates/l/wtx.svg?label=%20)             | ![wtx version](https://img.shields.io/crates/v/wtx.svg?label=%20)             | yes   | yes   | yes    | wtx   | yes    |
| **[zino](https://github.com/photino/zino)**    | ![zino stars](https://img.shields.io/github/stars/photino/zino.svg?label=%20)             | ![zino contributors](https://img.shields.io/github/contributors/photino/zino.svg?label=%20)             | ![zino activity](https://img.shields.io/github/commit-activity/y/photino/zino.svg?label=%20)             | [![zino repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/photino/zino)             | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=zino&color=green)](https://docs.rs/zino/)           | ![zino license](https://img.shields.io/crates/l/zino.svg?label=%20)           | ![zino version](https://img.shields.io/crates/v/zino.svg?label=%20)           | yes   |       |        |       |        |

### Low-Level Frameworks

| Name                                                                        | Stars                                                                                  | Contributors                                                                                         | Activity                                                                                              | Repo                                                                                                   | Docs                                                                                                                  | License                                                                         | Version                                                                         | Async | HTTPS | HTTP/2 | Base | Client |
|-----------------------------------------------------------------------------|----------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------|---------------------------------------------------------------------------------|-------|-------|--------|------|--------|
| **[actix-http](https://github.com/actix/actix-web/tree/master/actix-http)** | ![actix-http stars](https://img.shields.io/github/stars/actix/actix-web.svg?label=%20) | ![actix-http contributors](https://img.shields.io/github/contributors/actix/actix-web.svg?label=%20) | ![actix-http activity](https://img.shields.io/github/commit-activity/y/actix/actix-web.svg?label=%20) | [![actix-http repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/actix/actix-web) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=actix-http&color=green)](https://docs.rs/actix-http/) | ![actix-http license](https://img.shields.io/crates/l/actix-http.svg?label=%20) | ![actix-http version](https://img.shields.io/crates/v/actix-http.svg?label=%20) | yes   | yes   | yes    |      | yes    |
| **[hyper](http://hyper.rs/)**                                               | ![hyper stars](https://img.shields.io/github/stars/hyperium/hyper.svg?label=%20)       | ![hyper contributors](https://img.shields.io/github/contributors/hyperium/hyper.svg?label=%20)       | ![hyper activity](https://img.shields.io/github/commit-activity/y/hyperium/hyper.svg?label=%20)       | [![hyper repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/hyperium/hyper)       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=hyper&color=green)](https://docs.rs/hyper/)           | ![hyper license](https://img.shields.io/crates/l/hyper.svg?label=%20)           | ![hyper version](https://img.shields.io/crates/v/hyper.svg?label=%20)           | yes   | yes   | yes    |      | yes    |
| **[xita-web](https://github.com/HFQR/xitca-web)**                           | ![xita-web stars](https://img.shields.io/github/stars/HFQR/xitca-web.svg?label=%20)    | ![xita-web contributors](https://img.shields.io/github/contributors/HFQR/xitca-web.svg?label=%20)    | ![xita-web activity](https://img.shields.io/github/commit-activity/y/HFQR/xitca-web.svg?label=%20)    | [![xita-web repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/HFQR/xitca-web)    |                                                                                                                       |                                                                                 |                                                                                 | yes   |       |        |      |        |

### Outdated server frameworks

| Name                                                           | Stars                                                                                            | Contributors                                                                                                   | Activity                                                                                                        | Repo                                                                                                             | Docs                                                                                                                    | License                                                                           | Version                                                                           | Async | HTTPS | HTTP/2 | Base             | Client |
|----------------------------------------------------------------|--------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------|-----------------------------------------------------------------------------------|-------|-------|--------|------------------|--------|
| **[cargonaouts](https://github.com/cargonauts-rs/cargonauts)** | ![cargonaouts stars](https://img.shields.io/github/stars/cargonauts-rs/cargonauts.svg?label=%20) | ![cargonaouts contributors](https://img.shields.io/github/contributors/cargonauts-rs/cargonauts.svg?label=%20) | ![cargonaouts activity](https://img.shields.io/github/commit-activity/y/cargonauts-rs/cargonauts.svg?label=%20) | [![cargonaouts repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/cargonauts-rs/cargonauts) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=cargonaouts&color=green)](https://docs.rs/cargonaouts/) | ![cargonaouts license](https://img.shields.io/crates/l/cargonaouts.svg?label=%20) | ![cargonaouts version](https://img.shields.io/crates/v/cargonaouts.svg?label=%20) |       |       |        |                  |        |
| **[civet](https://github.com/wycats/rust-civet)**              | ![civet stars](https://img.shields.io/github/stars/wycats/rust-civet.svg?label=%20)              | ![civet contributors](https://img.shields.io/github/contributors/wycats/rust-civet.svg?label=%20)              | ![civet activity](https://img.shields.io/github/commit-activity/y/wycats/rust-civet.svg?label=%20)              | [![civet repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/wycats/rust-civet)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=civet&color=green)](https://docs.rs/civet/)             | ![civet license](https://img.shields.io/crates/l/civet.svg?label=%20)             | ![civet version](https://img.shields.io/crates/v/civet.svg?label=%20)             |       |       |        |                  |        |
| **[conduit](https://github.com/conduit-rust/conduit)**         | ![conduit stars](https://img.shields.io/github/stars/conduit-rust/conduit.svg?label=%20)         | ![conduit contributors](https://img.shields.io/github/contributors/conduit-rust/conduit.svg?label=%20)         | ![conduit activity](https://img.shields.io/github/commit-activity/y/conduit-rust/conduit.svg?label=%20)         | [![conduit repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/conduit-rust/conduit)         | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=conduit&color=green)](https://docs.rs/conduit/)         | ![conduit license](https://img.shields.io/crates/l/conduit.svg?label=%20)         | ![conduit version](https://img.shields.io/crates/v/conduit.svg?label=%20)         |       |       |        |                  |        |
| **[gotham](http://gotham.rs/)**                                | ![gotham stars](https://img.shields.io/github/stars/gotham-rs/gotham.svg?label=%20)              | ![gotham contributors](https://img.shields.io/github/contributors/gotham-rs/gotham.svg?label=%20)              | ![gotham activity](https://img.shields.io/github/commit-activity/y/gotham-rs/gotham.svg?label=%20)              | [![gotham repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/gotham-rs/gotham)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=gotham&color=green)](https://docs.rs/gotham/)           | ![gotham license](https://img.shields.io/crates/l/gotham.svg?label=%20)           | ![gotham version](https://img.shields.io/crates/v/gotham.svg?label=%20)           | yes   | yes   | no     | hyper            | no     |
| **[graphul](https://graphul-rs.github.io/)**                   | ![graphul stars](https://img.shields.io/github/stars/graphul-rs/graphul.svg?label=%20)           | ![graphul contributors](https://img.shields.io/github/contributors/graphul-rs/graphul.svg?label=%20)           | ![graphul activity](https://img.shields.io/github/commit-activity/y/graphul-rs/graphul.svg?label=%20)           | [![graphul repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/graphul-rs/graphul)           | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=graphul&color=green)](https://docs.rs/graphul/)         | ![graphul license](https://img.shields.io/crates/l/graphul.svg?label=%20)         | ![graphul version](https://img.shields.io/crates/v/graphul.svg?label=%20)         | yes   | yes   | yes    | hyper            | no     |
| **[hydrogen](https://github.com/nathansizemore/hydrogen)**     | ![hydrogen stars](https://img.shields.io/github/stars/nathansizemore/hydrogen.svg?label=%20)     | ![hydrogen contributors](https://img.shields.io/github/contributors/nathansizemore/hydrogen.svg?label=%20)     | ![hydrogen activity](https://img.shields.io/github/commit-activity/y/nathansizemore/hydrogen.svg?label=%20)     | [![hydrogen repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/nathansizemore/hydrogen)     | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=hydrogen&color=green)](https://docs.rs/hydrogen/)       | ![hydrogen license](https://img.shields.io/crates/l/hydrogen.svg?label=%20)       | ![hydrogen version](https://img.shields.io/crates/v/hydrogen.svg?label=%20)       |       |       |        |                  |        |
| **[iron](https://github.com/iron/iron)**                       | ![iron stars](https://img.shields.io/github/stars/iron/iron.svg?label=%20)                       | ![iron contributors](https://img.shields.io/github/contributors/iron/iron.svg?label=%20)                       | ![iron activity](https://img.shields.io/github/commit-activity/y/iron/iron.svg?label=%20)                       | [![iron repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/iron/iron)                       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=iron&color=green)](https://docs.rs/iron/)               | ![iron license](https://img.shields.io/crates/l/iron.svg?label=%20)               | ![iron version](https://img.shields.io/crates/v/iron.svg?label=%20)               |       |       |        |                  |        |
| **[kinglet](https://github.com/pyfisch/kinglet)**              | ![kinglet stars](https://img.shields.io/github/stars/pyfisch/kinglet.svg?label=%20)              | ![kinglet contributors](https://img.shields.io/github/contributors/pyfisch/kinglet.svg?label=%20)              | ![kinglet activity](https://img.shields.io/github/commit-activity/y/pyfisch/kinglet.svg?label=%20)              | [![kinglet repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/pyfisch/kinglet)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=kinglet&color=green)](https://docs.rs/kinglet/)         | ![kinglet license](https://img.shields.io/crates/l/kinglet.svg?label=%20)         | ![kinglet version](https://img.shields.io/crates/v/kinglet.svg?label=%20)         |       |       |        |                  |        |
| **[nickel](https://github.com/nickel-org/nickel.rs)**          | ![nickel stars](https://img.shields.io/github/stars/nickel-org/nickel.rs.svg?label=%20)          | ![nickel contributors](https://img.shields.io/github/contributors/nickel-org/nickel.rs.svg?label=%20)          | ![nickel activity](https://img.shields.io/github/commit-activity/y/nickel-org/nickel.rs.svg?label=%20)          | [![nickel repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/nickel-org/nickel.rs)          | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=nickel&color=green)](https://docs.rs/nickel/)           | ![nickel license](https://img.shields.io/crates/l/nickel.svg?label=%20)           | ![nickel version](https://img.shields.io/crates/v/nickel.svg?label=%20)           |       |       |        |                  |        |
| **[rouille](https://github.com/tomaka/rouille)**               | ![rouille stars](https://img.shields.io/github/stars/tomaka/rouille.svg?label=%20)               | ![rouille contributors](https://img.shields.io/github/contributors/tomaka/rouille.svg?label=%20)               | ![rouille activity](https://img.shields.io/github/commit-activity/y/tomaka/rouille.svg?label=%20)               | [![rouille repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/tomaka/rouille)               | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=rouille&color=green)](https://docs.rs/rouille/)         | ![rouille license](https://img.shields.io/crates/l/rouille.svg?label=%20)         | ![rouille version](https://img.shields.io/crates/v/rouille.svg?label=%20)         | no    | yes   |        |                  | no     |
| **[rustful](https://github.com/Ogeon/rustful)**                | ![rustful stars](https://img.shields.io/github/stars/Ogeon/rustful.svg?label=%20)                | ![rustful contributors](https://img.shields.io/github/contributors/Ogeon/rustful.svg?label=%20)                | ![rustful activity](https://img.shields.io/github/commit-activity/y/Ogeon/rustful.svg?label=%20)                | [![rustful repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/Ogeon/rustful)                | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=rustful&color=green)](https://docs.rs/rustful/)         | ![rustful license](https://img.shields.io/crates/l/rustful.svg?label=%20)         | ![rustful version](https://img.shields.io/crates/v/rustful.svg?label=%20)         |       |       |        |                  |        |
| **[rustless](https://github.com/rustless/rustless)**           | ![rustless stars](https://img.shields.io/github/stars/rustless/rustless.svg?label=%20)           | ![rustless contributors](https://img.shields.io/github/contributors/rustless/rustless.svg?label=%20)           | ![rustless activity](https://img.shields.io/github/commit-activity/y/rustless/rustless.svg?label=%20)           | [![rustless repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/rustless/rustless)           | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=rustless&color=green)](https://docs.rs/rustless/)       | ![rustless license](https://img.shields.io/crates/l/rustless.svg?label=%20)       | ![rustless version](https://img.shields.io/crates/v/rustless.svg?label=%20)       |       |       |        |                  |        |
| **[sappers](https://github.com/sappworks/sapper)**             | ![sappers stars](https://img.shields.io/github/stars/sappworks/sapper.svg?label=%20)             | ![sappers contributors](https://img.shields.io/github/contributors/sappworks/sapper.svg?label=%20)             | ![sappers activity](https://img.shields.io/github/commit-activity/y/sappworks/sapper.svg?label=%20)             | [![sappers repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/sappworks/sapper)             | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=sappers&color=green)](https://docs.rs/sappers/)         | ![sappers license](https://img.shields.io/crates/l/sappers.svg?label=%20)         | ![sappers version](https://img.shields.io/crates/v/sappers.svg?label=%20)         |       |       |        |                  |        |
| **[shio](https://github.com/mehcode/shio-rs)**                 | ![shio stars](https://img.shields.io/github/stars/mehcode/shio-rs.svg?label=%20)                 | ![shio contributors](https://img.shields.io/github/contributors/mehcode/shio-rs.svg?label=%20)                 | ![shio activity](https://img.shields.io/github/commit-activity/y/mehcode/shio-rs.svg?label=%20)                 | [![shio repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/mehcode/shio-rs)                 | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=shio&color=green)](https://docs.rs/shio/)               | ![shio license](https://img.shields.io/crates/l/shio.svg?label=%20)               | ![shio version](https://img.shields.io/crates/v/shio.svg?label=%20)               |       |       |        |                  |        |
| **[solicit](https://github.com/mlalic/solicit)**               | ![solicit stars](https://img.shields.io/github/stars/mlalic/solicit.svg?label=%20)               | ![solicit contributors](https://img.shields.io/github/contributors/mlalic/solicit.svg?label=%20)               | ![solicit activity](https://img.shields.io/github/commit-activity/y/mlalic/solicit.svg?label=%20)               | [![solicit repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/mlalic/solicit)               | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=solicit&color=green)](https://docs.rs/solicit/)         | ![solicit license](https://img.shields.io/crates/l/solicit.svg?label=%20)         | ![solicit version](https://img.shields.io/crates/v/solicit.svg?label=%20)         |       |       |        |                  |        |
| **[Thruster](https://github.com/trezm/Thruster)**              | ![Thruster stars](https://img.shields.io/github/stars/trezm/Thruster.svg?label=%20)              | ![Thruster contributors](https://img.shields.io/github/contributors/trezm/Thruster.svg?label=%20)              | ![Thruster activity](https://img.shields.io/github/commit-activity/y/trezm/Thruster.svg?label=%20)              | [![Thruster repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/trezm/Thruster)              | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=thruster&color=green)](https://docs.rs/thruster/)       | ![Thruster license](https://img.shields.io/crates/l/thruster.svg?label=%20)       | ![Thruster version](https://img.shields.io/crates/v/thruster.svg?label=%20)       | yes   | yes   | yes    | tokio (or hyper) | no     |
| **[Tide](https://github.com/rustasync/tide)**                  | ![Tide stars](https://img.shields.io/github/stars/rustasync/tide.svg?label=%20)                  | ![Tide contributors](https://img.shields.io/github/contributors/rustasync/tide.svg?label=%20)                  | ![Tide activity](https://img.shields.io/github/commit-activity/y/rustasync/tide.svg?label=%20)                  | [![Tide repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/rustasync/tide)                  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tide&color=green)](https://docs.rs/tide/)               | ![Tide license](https://img.shields.io/crates/l/tide.svg?label=%20)               | ![Tide version](https://img.shields.io/crates/v/tide.svg?label=%20)               | yes   | yes   | no     | async-std        | no     |
| **[tiny-http](https://github.com/tiny-http/tiny-http)**        | ![tiny-http stars](https://img.shields.io/github/stars/tiny-http/tiny-http.svg?label=%20)        | ![tiny-http contributors](https://img.shields.io/github/contributors/tiny-http/tiny-http.svg?label=%20)        | ![tiny-http activity](https://img.shields.io/github/commit-activity/y/tiny-http/tiny-http.svg?label=%20)        | [![tiny-http repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/tiny-http/tiny-http)        | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tiny_http&color=green)](https://docs.rs/tiny_http/)     | ![tiny-http license](https://img.shields.io/crates/l/tiny_http.svg?label=%20)     | ![tiny-http version](https://img.shields.io/crates/v/tiny_http.svg?label=%20)     | no    | yes   | no     |                  | no     |
| **[tk-http](https://github.com/swindon-rs/tk-http)**           | ![tk-http stars](https://img.shields.io/github/stars/swindon-rs/tk-http.svg?label=%20)           | ![tk-http contributors](https://img.shields.io/github/contributors/swindon-rs/tk-http.svg?label=%20)           | ![tk-http activity](https://img.shields.io/github/commit-activity/y/swindon-rs/tk-http.svg?label=%20)           | [![tk-http repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/swindon-rs/tk-http)           | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tk-http&color=green)](https://docs.rs/tk-http/)         | ![tk-http license](https://img.shields.io/crates/l/tk-http.svg?label=%20)         | ![tk-http version](https://img.shields.io/crates/v/tk-http.svg?label=%20)         |       |       |        |                  |        |
| **[tower-web](https://github.com/carllerche/tower-web)**       | ![tower-web stars](https://img.shields.io/github/stars/carllerche/tower-web.svg?label=%20)       | ![tower-web contributors](https://img.shields.io/github/contributors/carllerche/tower-web.svg?label=%20)       | ![tower-web activity](https://img.shields.io/github/commit-activity/y/carllerche/tower-web.svg?label=%20)       | [![tower-web repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/carllerche/tower-web)       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tower-web&color=green)](https://docs.rs/tower-web/)     | ![tower-web license](https://img.shields.io/crates/l/tower-web.svg?label=%20)     | ![tower-web version](https://img.shields.io/crates/v/tower-web.svg?label=%20)     |       |       |        |                  |        |
| **[warp](https://github.com/seanmonstar/warp)**                | ![warp stars](https://img.shields.io/github/stars/seanmonstar/warp.svg?label=%20)                | ![warp contributors](https://img.shields.io/github/contributors/seanmonstar/warp.svg?label=%20)                | ![warp activity](https://img.shields.io/github/commit-activity/y/seanmonstar/warp.svg?label=%20)                | [![warp repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/seanmonstar/warp)                | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=warp&color=green)](https://docs.rs/warp/)               | ![warp license](https://img.shields.io/crates/l/warp.svg?label=%20)               | ![warp version](https://img.shields.io/crates/v/warp.svg?label=%20)               | yes   | yes   | yes    | hyper            | no     |

## Client frameworks

To build web clients with Rust, you can choose between these libraries:

- **reqwest**    (-                                           / [repository](https://github.com/seanmonstar/reqwest)             / [documentation](https://docs.rs/reqwest))
- **awc**        (-                                           / [repository](https://github.com/actix/actix-web/tree/master/awc) / [api docs](https://docs.rs/awc))
- **hyper**      ([homepage](http://hyper.rs/)                / [repository](https://github.com/hyperium/hyper)                  / [documentation](http://hyper.rs/hyper/hyper/))
- **jsonrpc**    (-                                           / [repository](https://github.com/apoelstra/rust-jsonrpc/)         / [documentation](https://www.wpsoftware.net/rustdoc/jsonrpc/))
- **wtx**        ([homepage](https://c410-f3r.github.io/wtx/) / [repository](https://github.com/c410-f3r/wtx)                     / [documentation](https://docs.rs/wtx))

### Outdated client frameworks

- [ease](https://github.com/SimonPersson/ease)


## Templating

| Name                                                         | Repo                                                                                                           | Docs                                                                                                                  | License                                                                         | Version                                                                         | Stars                                                                                          | Contributors                                                                                                 | Activity                                                                                                      |
|--------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------|---------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------|
| **[askama](https://github.com/djc/askama)**                  | [![askama repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/djc/askama)                  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=askama&color=green)](https://docs.rs/askama/)         | ![askama license](https://img.shields.io/crates/l/askama.svg?label=%20)         | ![askama version](https://img.shields.io/crates/v/askama.svg?label=%20)         | ![askama stars](https://img.shields.io/github/stars/djc/askama.svg?label=%20)                  | ![askama contributors](https://img.shields.io/github/contributors/djc/askama.svg?label=%20)                  | ![askama activity](https://img.shields.io/github/commit-activity/y/djc/askama.svg?label=%20)                  |
| **[handlebars](https://github.com/sunng87/handlebars-rust)** | [![handlebars repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/sunng87/handlebars-rust) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=handlebars&color=green)](https://docs.rs/handlebars/) | ![handlebars license](https://img.shields.io/crates/l/handlebars.svg?label=%20) | ![handlebars version](https://img.shields.io/crates/v/handlebars.svg?label=%20) | ![handlebars stars](https://img.shields.io/github/stars/sunng87/handlebars-rust.svg?label=%20) | ![handlebars contributors](https://img.shields.io/github/contributors/sunng87/handlebars-rust.svg?label=%20) | ![handlebars activity](https://img.shields.io/github/commit-activity/y/sunng87/handlebars-rust.svg?label=%20) |
| **[liquid](https://github.com/cobalt-org/liquid-rust)**      | [![liquid repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/cobalt-org/liquid-rust)      |                                                                                                                       |                                                                                 |                                                                                 | ![liquid stars](https://img.shields.io/github/stars/cobalt-org/liquid-rust.svg?label=%20)      | ![liquid contributors](https://img.shields.io/github/contributors/cobalt-org/liquid-rust.svg?label=%20)      | ![liquid activity](https://img.shields.io/github/commit-activity/y/cobalt-org/liquid-rust.svg?label=%20)      |
| **[maud](https://lfairy.gitbooks.io/maud/content)**          | [![maud repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/lfairy/maud)                   | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=maud&color=green)](https://docs.rs/maud/)             | ![maud license](https://img.shields.io/crates/l/maud.svg?label=%20)             | ![maud version](https://img.shields.io/crates/v/maud.svg?label=%20)             | ![maud stars](https://img.shields.io/github/stars/lfairy/maud.svg?label=%20)                   | ![maud contributors](https://img.shields.io/github/contributors/lfairy/maud.svg?label=%20)                   | ![maud activity](https://img.shields.io/github/commit-activity/y/lfairy/maud.svg?label=%20)                   |
| **[minijinja](https://github.com/mitsuhiko/minijinja)**      | [![minijinja repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/mitsuhiko/minijinja)      | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=minijinja&color=green)](https://docs.rs/minijinja/)   | ![minijinja license](https://img.shields.io/crates/l/minijinja.svg?label=%20)   | ![minijinja version](https://img.shields.io/crates/v/minijinja.svg?label=%20)   | ![minijinja stars](https://img.shields.io/github/stars/mitsuhiko/minijinja.svg?label=%20)      | ![minijinja contributors](https://img.shields.io/github/contributors/mitsuhiko/minijinja.svg?label=%20)      | ![minijinja activity](https://img.shields.io/github/commit-activity/y/mitsuhiko/minijinja.svg?label=%20)      |
| **[rinja](https://github.com/rinja-rs/rinja)**               | [![rinja repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/rinja-rs/rinja)               | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=rinja&color=green)](https://docs.rs/rinja/)           | ![rinja license](https://img.shields.io/crates/l/rinja.svg?label=%20)           | ![rinja version](https://img.shields.io/crates/v/rinja.svg?label=%20)           | ![rinja stars](https://img.shields.io/github/stars/rinja-rs/rinja.svg?label=%20)               | ![rinja contributors](https://img.shields.io/github/contributors/rinja-rs/rinja.svg?label=%20)               | ![rinja activity](https://img.shields.io/github/commit-activity/y/rinja-rs/rinja.svg?label=%20)               |
| **[ructe](https://github.com/kaj/ructe)**                    | [![ructe repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/kaj/ructe)                    | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=ructe&color=green)](https://docs.rs/ructe/)           | ![ructe license](https://img.shields.io/crates/l/ructe.svg?label=%20)           | ![ructe version](https://img.shields.io/crates/v/ructe.svg?label=%20)           | ![ructe stars](https://img.shields.io/github/stars/kaj/ructe.svg?label=%20)                    | ![ructe contributors](https://img.shields.io/github/contributors/kaj/ructe.svg?label=%20)                    | ![ructe activity](https://img.shields.io/github/commit-activity/y/kaj/ructe.svg?label=%20)                    |
| **[sailfish](https://sailfish.netlify.app/)**                | [![sailfish repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/Kogia-sima/sailfish)       | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=sailfish&color=green)](https://docs.rs/sailfish/)     | ![sailfish license](https://img.shields.io/crates/l/sailfish.svg?label=%20)     | ![sailfish version](https://img.shields.io/crates/v/sailfish.svg?label=%20)     | ![sailfish stars](https://img.shields.io/github/stars/Kogia-sima/sailfish.svg?label=%20)       | ![sailfish contributors](https://img.shields.io/github/contributors/Kogia-sima/sailfish.svg?label=%20)       | ![sailfish activity](https://img.shields.io/github/commit-activity/y/Kogia-sima/sailfish.svg?label=%20)       |
| **[tera](https://keats.github.io/tera/)**                    | [![tera repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/Keats/tera)                    | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tera&color=green)](https://docs.rs/tera/)             | ![tera license](https://img.shields.io/crates/l/tera.svg?label=%20)             | ![tera version](https://img.shields.io/crates/v/tera.svg?label=%20)             | ![tera stars](https://img.shields.io/github/stars/Keats/tera.svg?label=%20)                    | ![tera contributors](https://img.shields.io/github/contributors/Keats/tera.svg?label=%20)                    | ![tera activity](https://img.shields.io/github/commit-activity/y/Keats/tera.svg?label=%20)                    |

### Outdated templating libraries

| Name                                                         | Repo                                                                                                           | Docs                                                                                                                      | License                                                                             | Version                                                                             | Stars                                                                                          | Contributors                                                                                                 | Activity                                                                                                      |
|--------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------|
| **[horrorshow](https://github.com/Stebalien/horrorshow-rs)** | [![horrorshow repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/Stebalien/horrorshow-rs) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=horrorshow&color=green)](https://docs.rs/horrorshow/)     | ![horrorshow license](https://img.shields.io/crates/l/horrorshow.svg?label=%20)     | ![horrorshow version](https://img.shields.io/crates/v/horrorshow.svg?label=%20)     | ![horrorshow stars](https://img.shields.io/github/stars/Stebalien/horrorshow-rs.svg?label=%20) | ![horrorshow contributors](https://img.shields.io/github/contributors/Stebalien/horrorshow-rs.svg?label=%20) | ![horrorshow activity](https://img.shields.io/github/commit-activity/y/Stebalien/horrorshow-rs.svg?label=%20) |
| **[markup](https://github.com/utkarshkukreti/markup.rs)**    | [![markup repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/utkarshkukreti/markup.rs)    | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=markup&color=green)](https://docs.rs/markup/)             | ![markup license](https://img.shields.io/crates/l/markup.svg?label=%20)             | ![markup version](https://img.shields.io/crates/v/markup.svg?label=%20)             | ![markup stars](https://img.shields.io/github/stars/utkarshkukreti/markup.rs.svg?label=%20)    | ![markup contributors](https://img.shields.io/github/contributors/utkarshkukreti/markup.rs.svg?label=%20)    | ![markup activity](https://img.shields.io/github/commit-activity/y/utkarshkukreti/markup.rs.svg?label=%20)    |
| **[mustache](https://github.com/nickel-org/rust-mustache)**  | [![mustache repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/nickel-org/rust-mustache)  | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=mustache&color=green)](https://docs.rs/mustache/)         | ![mustache license](https://img.shields.io/crates/l/mustache.svg?label=%20)         | ![mustache version](https://img.shields.io/crates/v/mustache.svg?label=%20)         | ![mustache stars](https://img.shields.io/github/stars/nickel-org/rust-mustache.svg?label=%20)  | ![mustache contributors](https://img.shields.io/github/contributors/nickel-org/rust-mustache.svg?label=%20)  | ![mustache activity](https://img.shields.io/github/commit-activity/y/nickel-org/rust-mustache.svg?label=%20)  |
| **[stpl](https://github.com/dpc/stpl)**                      | [![stpl repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/dpc/stpl)                      |                                                                                                                           |                                                                                     |                                                                                     | ![stpl stars](https://img.shields.io/github/stars/dpc/stpl.svg?label=%20)                      | ![stpl contributors](https://img.shields.io/github/contributors/dpc/stpl.svg?label=%20)                      | ![stpl activity](https://img.shields.io/github/commit-activity/y/dpc/stpl.svg?label=%20)                      |
| **[tinytemplate](https://github.com/bheisler/TinyTemplate)** | [![tinytemplate repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/bheisler/TinyTemplate) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tinytemplate&color=green)](https://docs.rs/tinytemplate/) | ![tinytemplate license](https://img.shields.io/crates/l/tinytemplate.svg?label=%20) | ![tinytemplate version](https://img.shields.io/crates/v/tinytemplate.svg?label=%20) | ![tinytemplate stars](https://img.shields.io/github/stars/bheisler/TinyTemplate.svg?label=%20) | ![tinytemplate contributors](https://img.shields.io/github/contributors/bheisler/TinyTemplate.svg?label=%20) | ![tinytemplate activity](https://img.shields.io/github/commit-activity/y/bheisler/TinyTemplate.svg?label=%20) |
| **[typed-html](https://github.com/bodil/typed-html)**        | [![typed-html repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/bodil/typed-html)        | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=typed-html&color=green)](https://docs.rs/typed-html/)     | ![typed-html license](https://img.shields.io/crates/l/typed-html.svg?label=%20)     | ![typed-html version](https://img.shields.io/crates/v/typed-html.svg?label=%20)     | ![typed-html stars](https://img.shields.io/github/stars/bodil/typed-html.svg?label=%20)        | ![typed-html contributors](https://img.shields.io/github/contributors/bodil/typed-html.svg?label=%20)        | ![typed-html activity](https://img.shields.io/github/commit-activity/y/bodil/typed-html.svg?label=%20)        |

## Websocket Libraries

| Name                                                                   | Repo                                                                                                                     | Docs                                                                                                                                | License                                                                                       | Version                                                                                       | Stars                                                                                                    | Contributors                                                                                                           | Activity                                                                                                                | Client | Server | Async |
|------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------|--------|--------|-------|
| **[actix-web](https://actix.rs/docs/websockets/)**                     | [![actix-web repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/actix/actix-web)                    | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=actix-web-actors&color=green)](https://docs.rs/actix-web-actors/)   | ![actix-web license](https://img.shields.io/crates/l/actix-web-actors.svg?label=%20)          | ![actix-web version](https://img.shields.io/crates/v/actix-web-actors.svg?label=%20)          | ![actix-web stars](https://img.shields.io/github/stars/actix/actix-web.svg?label=%20)                    | ![actix-web contributors](https://img.shields.io/github/contributors/actix/actix-web.svg?label=%20)                    | ![actix-web activity](https://img.shields.io/github/commit-activity/y/actix/actix-web.svg?label=%20)                    | yes    | yes    | yes   |
| **[tokio-tungstenite](https://github.com/snapview/tokio-tungstenite)** | [![tokio-tungstenite repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/snapview/tokio-tungstenite) | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tokio-tungstenite&color=green)](https://docs.rs/tokio-tungstenite/) | ![tokio-tungstenite license](https://img.shields.io/crates/l/tokio-tungstenite.svg?label=%20) | ![tokio-tungstenite version](https://img.shields.io/crates/v/tokio-tungstenite.svg?label=%20) | ![tokio-tungstenite stars](https://img.shields.io/github/stars/snapview/tokio-tungstenite.svg?label=%20) | ![tokio-tungstenite contributors](https://img.shields.io/github/contributors/snapview/tokio-tungstenite.svg?label=%20) | ![tokio-tungstenite activity](https://img.shields.io/github/commit-activity/y/snapview/tokio-tungstenite.svg?label=%20) | yes    | yes    | yes   |
| **[tungstenite](https://github.com/snapview/tungstenite-rs)**          | [![tungstenite repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/snapview/tungstenite-rs)          | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=tungstenite&color=green)](https://docs.rs/tungstenite/)             | ![tungstenite license](https://img.shields.io/crates/l/tungstenite.svg?label=%20)             | ![tungstenite version](https://img.shields.io/crates/v/tungstenite.svg?label=%20)             | ![tungstenite stars](https://img.shields.io/github/stars/snapview/tungstenite-rs.svg?label=%20)          | ![tungstenite contributors](https://img.shields.io/github/contributors/snapview/tungstenite-rs.svg?label=%20)          | ![tungstenite activity](https://img.shields.io/github/commit-activity/y/snapview/tungstenite-rs.svg?label=%20)          | yes    | yes    | yes   |
| **[ws-rs](https://github.com/housleyjk/ws-rs)**                        | [![ws-rs repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/housleyjk/ws-rs)                        | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=ws&color=green)](https://docs.rs/ws/)                               | ![ws-rs license](https://img.shields.io/crates/l/ws.svg?label=%20)                            | ![ws-rs version](https://img.shields.io/crates/v/ws.svg?label=%20)                            | ![ws-rs stars](https://img.shields.io/github/stars/housleyjk/ws-rs.svg?label=%20)                        | ![ws-rs contributors](https://img.shields.io/github/contributors/housleyjk/ws-rs.svg?label=%20)                        | ![ws-rs activity](https://img.shields.io/github/commit-activity/y/housleyjk/ws-rs.svg?label=%20)                        | yes    | yes    | yes   |
| **[wtx](https://c410-f3r.github.io/wtx/)**                             | [![wtx repo](https://img.shields.io/badge/GitHub-git-blue)](https://github.com/c410-f3r/wtx)                             | [![Docs](https://img.shields.io/static/v1?label=docs.rs&message=wtx&color=green)](https://docs.rs/wtx/)                             | ![wtx license](https://img.shields.io/crates/l/wtx.svg?label=%20)                             | ![wtx version](https://img.shields.io/crates/v/wtx.svg?label=%20)                             | ![wtx stars](https://img.shields.io/github/stars/c410-f3r/wtx.svg?label=%20)                             | ![wtx contributors](https://img.shields.io/github/contributors/c410-f3r/wtx.svg?label=%20)                             | ![wtx activity](https://img.shields.io/github/commit-activity/y/c410-f3r/wtx.svg?label=%20)                             | yes    | yes    | yes   |
