Simple SVG World Map
====================

<p align="center">
  <img src="https://cdn.rawgit.com/flekschas/simple-world-map/a36dece5/world-map.svg"
       alt="A simple SVG world map" />
</p>

A simple and lightweight SVG world map, annotated with two-letter country code standard **[ISO 3166-1 alpha 2][iso]**.

Size:
  * 73.6 KB Uncompressed
  * 55.9 KB Minified using [svgo][svgo]
  * 24.3 KB Minified and gzipped


Annotation
-----------
`Paths` are annotated by `id` using the **[ISO 3166-1 alpha 2][iso]** two-letter country code. In cases where no country code is available, the country name is prefixed with an underscore (e.g. *_somaliland*). Furthermore, if a country is comprised of multiple `paths` the mainland is annotated with the class `mainland`.


Countries
---------

| Name                             | Code / ID   |
| -------------------------------- | ----------- |
| Afghanistan                      | af          |
| Albania                          | al          |
| Algeria                          | dz          |
| Angola                           | ao          |
| Argentina                        | ar          |
| Armenia                          | am          |
| Australia                        | au          |
| Austria                          | at          |
| Azerbaijan                       | az          |
| Bahamas                          | bs          |
| Bangladesh                       | bd          |
| Belarus                          | by          |
| Belgium                          | be          |
| Belize                           | bz          |
| Benin                            | bj          |
| Bhutan                           | bt          |
| Bolivia                          | bo          |
| Bosnia and Herzegowina           | ba          |
| Botswana                         | bw          |
| Brazil                           | br          |
| Brunei                           | bn          |
| Bulgaria                         | bg          |
| Burkina Faso                     | bf          |
| Burundi                          | bi          |
| Cambodia                         | kh          |
| Cameroon                         | cm          |
| Canada                           | ca          |
| Central African Republic         | cf          |
| Chad                             | td          |
| Chile                            | cl          |
| China                            | cn          |
| Colombia                         | co          |
| Congo                            | cg          |
| Costa Rica                       | cr          |
| Cote d'Ivoire                    | ci          |
| Croatia                          | hr          |
| Cuba                             | cu          |
| Cyprus                           | cy          |
| Czech                            | cz          |
| Democratic Republic of the Congo | cd          |
| Denmark                          | dk          |
| Djibouti                         | dj          |
| Dominican Republic               | do          |
| Ecuador                          | ec          |
| Egypt                            | eg          |
| El Salvador                      | sv          |
| Equatorial Guinea                | gq          |
| Eritrea                          | er          |
| Estonia                          | ee          |
| Ethiopia                         | et          |
| Falkland Islands                 | fk          |
| Fiji                             | fj          |
| Finland                          | fi          |
| Fr. S. Antarctic Lands           | tf          |
| France                           | fr          |
| Gabon                            | ga          |
| Gambia                           | gm          |
| Georgia                          | ge          |
| Germany                          | de          |
| Ghana                            | gh          |
| Greece                           | gr          |
| Greenland                        | gl          |
| Guatemala                        | gt          |
| Guinea                           | gn          |
| Guinea-Bissau                    | gw          |
| Guyana                           | gy          |
| Haiti                            | ht          |
| Honduras                         | hn          |
| Hungary                          | hu          |
| Iceland                          | is          |
| India                            | in          |
| Indonesia                        | id          |
| Iran                             | ir          |
| Iraq                             | iq          |
| Ireland                          | ie          |
| Israel                           | il          |
| Italy                            | it          |
| Jamaica                          | jm          |
| Japan                            | jp          |
| Jordan                           | jo          |
| Kazakhstan                       | kz          |
| Kenya                            | ke          |
| Kuwait                           | kw          |
| Kyrgyzstan                       | kg          |
| Laos                             | la          |
| Latvia                           | lv          |
| Lebanon                          | lb          |
| Lesotho                          | ls          |
| Liberia                          | lr          |
| Libya                            | ly          |
| Lithuania                        | lt          |
| Luxembourg                       | lu          |
| Macedonia                        | mk          |
| Madagascar                       | mg          |
| Malawi                           | mw          |
| Malaysia                         | my          |
| Mali                             | ml          |
| Malta                            | mt          |
| Mauritania                       | mr          |
| Mexico                           | mx          |
| Moldova                          | md          |
| Mongolia                         | mn          |
| Montenegro                       | me          |
| Morocco                          | ma          |
| Mozambique                       | mz          |
| Myanmar                          | mm          |
| Namibia                          | na          |
| Nepal                            | np          |
| Netherlands                      | nl          |
| New Caledonia                    | nc          |
| New Zealand                      | nz          |
| Nicaragua                        | ni          |
| Niger                            | ne          |
| Nigeria                          | ng          |
| North Korea                      | kp          |
| Norway                           | no          |
| Oman                             | om          |
| Pakistan                         | pk          |
| Palestine                        | ps          |
| Panama                           | pa          |
| Papua New Guinea                 | pg          |
| Paraguay                         | py          |
| Peru                             | pe          |
| Philippines                      | ph          |
| Poland                           | pl          |
| Portugal                         | pt          |
| Puerto Rico                      | pr          |
| Qatar                            | qa          |
| Romania                          | ro          |
| Russia                           | ru          |
| Rwanda                           | rw          |
| Saudi Arabia                     | sa          |
| Senegal                          | sn          |
| Serbia                           | rs          |
| Sierra Leone                     | sl          |
| Singapore                        | sg          |
| Slovakia                         | sk          |
| Slovenia                         | si          |
| Solomon Islands                  | sb          |
| Somalia                          | so          |
| Somaliland                       | _somaliland |
| South Africa                     | za          |
| South Korea                      | kr          |
| South Sudan                      | ss          |
| Spain                            | es          |
| Sri Lanka                        | lk          |
| Sudan                            | sd          |
| Suriname                         | sr          |
| Swaziland                        | sz          |
| Sweden                           | se          |
| Switzerland                      | ch          |
| Syria                            | sy          |
| Taiwan                           | tw          |
| Tajikistan                       | tj          |
| Tanzania                         | tz          |
| Thailand                         | th          |
| Timor-Leste                      | tl          |
| Togo                             | tg          |
| Trinidad and Tobago              | tt          |
| Tunisia                          | tn          |
| Turkey                           | tr          |
| Turkmenistan                     | tm          |
| Uganda                           | ug          |
| Ukraine                          | ua          |
| United Arab Emirates             | ae          |
| United Kingdom                   | gb          |
| United States                    | us          |
| Uruguay                          | uy          |
| Uzbekistan                       | uz          |
| Vanuatu                          | vu          |
| Venezuela                        | ve          |
| Vietnam                          | vn          |
| West Sahara                      | eh          |
| Yemen                            | ye          |
| Zambia                           | zm          |
| Zimbabwe                         | zw          |

For your convenience find the [mapping file][mf].


Attribution
-----------
**Author:** Al MacDonald ([Original artwork][original])
**Editor:** Fritz Lekschas


License
-------
[Creative Commons Attribution-ShareAlike 3.0 Unported][cc]


[original]: https://commons.wikimedia.org/wiki/File:World_map_-_low_resolution.svg
[cc]: LICENSE
[iso]: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
[mf]: mapping.csv
[svgo]: https://github.com/svg/svgo
