from pathlib import Path
import os
import json


def update_current_app(app_name):
    global CURRENT_APP
    CURRENT_APP = app_name


def base_dir(name=None):
    return os.path.join(BASE_DIR, name or "")


def get_project_name():
    with open(base_dir("settings.json")) as settings:
        dict_json = json.load(settings)
        return dict_json.get("project_name", None)


def get_project_dir(string=''):
    base_oath = Path(__file__).resolve().parent.parent.parent.parent.parent.parent
    return os.path.join(base_oath, PROJECT_NAME, string)


BASE_DIR = Path(__file__).resolve().parent.parent

PROJECT_NAME = get_project_name()

get_project_dir()
