from time import sleep

from django.core.management import BaseCommand, call_command


class Command(BaseCommand):
    help = "Rode o full_crud em uma model, em uma app ou no projeto todo"

    def add_arguments(self, parser):
        parser.add_argument(
            "app",
            dest="app",
            type=str,
            help="Escolha uma app para rodar o full_crud.",
            default=None,
        )
        parser.add_argument(
            "model",
            dest="model",
            type=str,
            help="Escolha uma model para rodar o full_crud.",
            default=None,
        )

    def handle(self, *args, **options):
        app = options["app"]
        model = options["model"]
        self._call_command_or_return_true("full_crud", app, model)

    def _call_command_or_return_true(self, command, app=None, model=None):
        try:
            call_command(command, app, model)
        except KeyboardInterrupt:
            return True
