from django.core.management import BaseCommand
from django_full_crud.main import full_crud


class Command(BaseCommand):
    help = "Rode o full_crud em uma model, em uma app ou no projeto todo"

    def add_arguments(self, parser):
        parser.add_argument(
            "--app",
            dest="app",
            type=str,
            help="Escolha uma app para rodar o full_crud.",
            default=None,
        )
        parser.add_argument(
            "--model",
            dest="model",
            type=str,
            help="Escolha uma model para rodar o full_crud.",
            default=None,
        )

    def handle(self, *args, **options):
        app = options["app"]
        model = options["model"]
        full_crud(app, model)
