


const language_codes_lookup_table = [
  {
    "n": "Abkhazian",
    "2": "ab",
    "3": "abk",
    "3b": "abk"
  },
  {
    "n": "Afar",
    "2": "aa",
    "3": "aar",
    "3b": "aar"
  },
  {
    "n": "Afrikaans",
    "2": "af",
    "3": "afr",
    "3b": "afr"
  },
  {
    "n": "Akan",
    "2": "ak",
    "3": "aka",
    "3b": "aka"
  },
  {
    "n": "Albanian",
    "2": "sq",
    "3": "sqi",
    "3b": "alb"
  },
  {
    "n": "Amharic",
    "2": "am",
    "3": "amh",
    "3b": "amh"
  },
  {
    "n": "Arabic",
    "2": "ar",
    "3": "ara",
    "3b": "ara"
  },
  {
    "n": "Aragonese",
    "2": "an",
    "3": "arg",
    "3b": "arg"
  },
  {
    "n": "Armenian",
    "2": "hy",
    "3": "hye",
    "3b": "arm"
  },
  {
    "n": "Assamese",
    "2": "as",
    "3": "asm",
    "3b": "asm"
  },
  {
    "n": "Avaric",
    "2": "av",
    "3": "ava",
    "3b": "ava"
  },
  {
    "n": "Avestan",
    "2": "ae",
    "3": "ave",
    "3b": "ave"
  },
  {
    "n": "Aymara",
    "2": "ay",
    "3": "aym",
    "3b": "aym"
  },
  {
    "n": "Azerbaijani",
    "2": "az",
    "3": "aze",
    "3b": "aze"
  },
  {
    "n": "Bambara",
    "2": "bm",
    "3": "bam",
    "3b": "bam"
  },
  {
    "n": "Bashkir",
    "2": "ba",
    "3": "bak",
    "3b": "bak"
  },
  {
    "n": "Basque",
    "2": "eu",
    "3": "eus",
    "3b": "baq"
  },
  {
    "n": "Belarusian",
    "2": "be",
    "3": "bel",
    "3b": "bel"
  },
  {
    "n": "Bengali",
    "2": "bn",
    "3": "ben",
    "3b": "ben"
  },
  {
    "n": "Bislama",
    "2": "bi",
    "3": "bis",
    "3b": "bis"
  },
  {
    "n": "Bosnian",
    "2": "bs",
    "3": "bos",
    "3b": "bos"
  },
  {
    "n": "Breton",
    "2": "br",
    "3": "bre",
    "3b": "bre"
  },
  {
    "n": "Bulgarian",
    "2": "bg",
    "3": "bul",
    "3b": "bul"
  },
  {
    "n": "Burmese",
    "2": "my",
    "3": "mya",
    "3b": "bur"
  },
  {
    "n": "Catalan, Valencian",
    "2": "ca",
    "3": "cat",
    "3b": "cat"
  },
  {
    "n": "Central Khmer",
    "2": "km",
    "3": "khm",
    "3b": "khm"
  },
  {
    "n": "Chamorro",
    "2": "ch",
    "3": "cha",
    "3b": "cha"
  },
  {
    "n": "Chechen",
    "2": "ce",
    "3": "che",
    "3b": "che"
  },
  {
    "n": "Chichewa, Chewa, Nyanja",
    "2": "ny",
    "3": "nya",
    "3b": "nya"
  },
  {
    "n": "Chinese",
    "2": "zh",
    "3": "zho",
    "3b": "chi"
  },
  {
    "n": "Church Slavonic, Old Slavonic, Old Church Slavonic",
    "2": "cu",
    "3": "chu",
    "3b": "chu"
  },
  {
    "n": "Chuvash",
    "2": "cv",
    "3": "chv",
    "3b": "chv"
  },
  {
    "n": "Cornish",
    "2": "kw",
    "3": "cor",
    "3b": "cor"
  },
  {
    "n": "Corsican",
    "2": "co",
    "3": "cos",
    "3b": "cos"
  },
  {
    "n": "Cree",
    "2": "cr",
    "3": "cre",
    "3b": "cre"
  },
  {
    "n": "Croatian",
    "2": "hr",
    "3": "hrv",
    "3b": "hrv"
  },
  {
    "n": "Czech",
    "2": "cs",
    "3": "ces",
    "3b": "cze"
  },
  {
    "n": "Danish",
    "2": "da",
    "3": "dan",
    "3b": "dan"
  },
  {
    "n": "Divehi, Dhivehi, Maldivian",
    "2": "dv",
    "3": "div",
    "3b": "div"
  },
  {
    "n": "Dutch, Flemish",
    "2": "nl",
    "3": "nld",
    "3b": "dut"
  },
  {
    "n": "Dzongkha",
    "2": "dz",
    "3": "dzo",
    "3b": "dzo"
  },
  {
    "n": "English",
    "2": "en",
    "3": "eng",
    "3b": "eng"
  },
  {
    "n": "Esperanto",
    "2": "eo",
    "3": "epo",
    "3b": "epo"
  },
  {
    "n": "Estonian",
    "2": "et",
    "3": "est",
    "3b": "est"
  },
  {
    "n": "Ewe",
    "2": "ee",
    "3": "ewe",
    "3b": "ewe"
  },
  {
    "n": "Faroese",
    "2": "fo",
    "3": "fao",
    "3b": "fao"
  },
  {
    "n": "Fijian",
    "2": "fj",
    "3": "fij",
    "3b": "fij"
  },
  {
    "n": "Finnish",
    "2": "fi",
    "3": "fin",
    "3b": "fin"
  },
  {
    "n": "French",
    "2": "fr",
    "3": "fra",
    "3b": "fre"
  },
  {
    "n": "Fulah",
    "2": "ff",
    "3": "ful",
    "3b": "ful"
  },
  {
    "n": "Gaelic, Scottish Gaelic",
    "2": "gd",
    "3": "gla",
    "3b": "gla"
  },
  {
    "n": "Galician",
    "2": "gl",
    "3": "glg",
    "3b": "glg"
  },
  {
    "n": "Ganda",
    "2": "lg",
    "3": "lug",
    "3b": "lug"
  },
  {
    "n": "Georgian",
    "2": "ka",
    "3": "kat",
    "3b": "geo"
  },
  {
    "n": "German",
    "2": "de",
    "3": "deu",
    "3b": "ger"
  },
  {
    "n": "Greek, Modern (1453–)",
    "2": "el",
    "3": "ell",
    "3b": "gre"
  },
  {
    "n": "Guarani",
    "2": "gn",
    "3": "grn",
    "3b": "grn"
  },
  {
    "n": "Gujarati",
    "2": "gu",
    "3": "guj",
    "3b": "guj"
  },
  {
    "n": "Haitian, Haitian Creole",
    "2": "ht",
    "3": "hat",
    "3b": "hat"
  },
  {
    "n": "Hausa",
    "2": "ha",
    "3": "hau",
    "3b": "hau"
  },
  {
    "n": "Hebrew",
    "2": "he",
    "3": "heb",
    "3b": "heb"
  },
  {
    "n": "Herero",
    "2": "hz",
    "3": "her",
    "3b": "her"
  },
  {
    "n": "Hindi",
    "2": "hi",
    "3": "hin",
    "3b": "hin"
  },
  {
    "n": "Hiri Motu",
    "2": "ho",
    "3": "hmo",
    "3b": "hmo"
  },
  {
    "n": "Hungarian",
    "2": "hu",
    "3": "hun",
    "3b": "hun"
  },
  {
    "n": "Icelandic",
    "2": "is",
    "3": "isl",
    "3b": "ice"
  },
  {
    "n": "Ido",
    "2": "io",
    "3": "ido",
    "3b": "ido"
  },
  {
    "n": "Igbo",
    "2": "ig",
    "3": "ibo",
    "3b": "ibo"
  },
  {
    "n": "Indonesian",
    "2": "id",
    "3": "ind",
    "3b": "ind"
  },
  {
    "n": "Interlingua (International Auxiliary Language Association)",
    "2": "ia",
    "3": "ina",
    "3b": "ina"
  },
  {
    "n": "Interlingue, Occidental",
    "2": "ie",
    "3": "ile",
    "3b": "ile"
  },
  {
    "n": "Inuktitut",
    "2": "iu",
    "3": "iku",
    "3b": "iku"
  },
  {
    "n": "Inupiaq",
    "2": "ik",
    "3": "ipk",
    "3b": "ipk"
  },
  {
    "n": "Irish",
    "2": "ga",
    "3": "gle",
    "3b": "gle"
  },
  {
    "n": "Italian",
    "2": "it",
    "3": "ita",
    "3b": "ita"
  },
  {
    "n": "Japanese",
    "2": "ja",
    "3": "jpn",
    "3b": "jpn"
  },
  {
    "n": "Javanese",
    "2": "jv",
    "3": "jav",
    "3b": "jav"
  },
  {
    "n": "Kalaallisut, Greenlandic",
    "2": "kl",
    "3": "kal",
    "3b": "kal"
  },
  {
    "n": "Kannada",
    "2": "kn",
    "3": "kan",
    "3b": "kan"
  },
  {
    "n": "Kanuri",
    "2": "kr",
    "3": "kau",
    "3b": "kau"
  },
  {
    "n": "Kashmiri",
    "2": "ks",
    "3": "kas",
    "3b": "kas"
  },
  {
    "n": "Kazakh",
    "2": "kk",
    "3": "kaz",
    "3b": "kaz"
  },
  {
    "n": "Kikuyu, Gikuyu",
    "2": "ki",
    "3": "kik",
    "3b": "kik"
  },
  {
    "n": "Kinyarwanda",
    "2": "rw",
    "3": "kin",
    "3b": "kin"
  },
  {
    "n": "Kirghiz, Kyrgyz",
    "2": "ky",
    "3": "kir",
    "3b": "kir"
  },
  {
    "n": "Komi",
    "2": "kv",
    "3": "kom",
    "3b": "kom"
  },
  {
    "n": "Kongo",
    "2": "kg",
    "3": "kon",
    "3b": "kon"
  },
  {
    "n": "Korean",
    "2": "ko",
    "3": "kor",
    "3b": "kor"
  },
  {
    "n": "Kuanyama, Kwanyama",
    "2": "kj",
    "3": "kua",
    "3b": "kua"
  },
  {
    "n": "Kurdish",
    "2": "ku",
    "3": "kur",
    "3b": "kur"
  },
  {
    "n": "Lao",
    "2": "lo",
    "3": "lao",
    "3b": "lao"
  },
  {
    "n": "Latin",
    "2": "la",
    "3": "lat",
    "3b": "lat"
  },
  {
    "n": "Latvian",
    "2": "lv",
    "3": "lav",
    "3b": "lav"
  },
  {
    "n": "Limburgan, Limburger, Limburgish",
    "2": "li",
    "3": "lim",
    "3b": "lim"
  },
  {
    "n": "Lingala",
    "2": "ln",
    "3": "lin",
    "3b": "lin"
  },
  {
    "n": "Lithuanian",
    "2": "lt",
    "3": "lit",
    "3b": "lit"
  },
  {
    "n": "Luba-Katanga",
    "2": "lu",
    "3": "lub",
    "3b": "lub"
  },
  {
    "n": "Luxembourgish, Letzeburgesch",
    "2": "lb",
    "3": "ltz",
    "3b": "ltz"
  },
  {
    "n": "Macedonian",
    "2": "mk",
    "3": "mkd",
    "3b": "mac"
  },
  {
    "n": "Malagasy",
    "2": "mg",
    "3": "mlg",
    "3b": "mlg"
  }
]


function get_language_code(old_code,desired_type=null){
	if(typeof old_code != "string"){
		console.error("get_language_code: provided language code was not a string: ", old_code);
		return null
	}
	if(typeof desired_type != "string" && typeof desired_type != "number"){
		console.error("get_language_code: desired_type was invalid.  old_code, desired_type: ", old_code, desired_type);
		return null;
	}
	if(typeof desired_type == "number"){
		desired_type = "" + desired_type;
	}
	if(desired_type == "3B"){desired_type = "3b"}
	
	for(let l = 0; l < language_codes_lookup_table.length; l++){
		if(old_code.length == 2 && language_codes_lookup_table[l]["2"] == old_code){
			if(typeof desired_type == "string" && typeof language_codes_lookup_table[l][desired_type] == "string"){
				return language_codes_lookup_table[l][desired_type];
			}
			else{
				return language_codes_lookup_table[l]["3"];
			}
		}
		else if(old_code.length == 3 && (language_codes_lookup_table[l]["3"] == old_code || language_codes_lookup_table[l]["3b"] == old_code)){
			if(typeof desired_type == "string" && typeof language_codes_lookup_table[l][desired_type] == "string"){
				return language_codes_lookup_table[l][desired_type];
			}
			else{
				return language_codes_lookup_table[l]["2"];
			}
		}
	}
	console.error("get_language_code: language code fell through: ", old_code);
	return old_code;
}
window.get_language_code = get_language_code;