# Computer Science algorithms and data structures implemented in C++


## Algorithms:

✔ Binary Search Algorithm
✔ Breadth First Search (BFS) Algorithm
✔ Depth First Search (DFS) Algorithm
✖ Inorder, Preorder, Postorder Tree Traversals
✖ Insertion Sort, Selection Sort, Merge Sort, Quicksort, Counting Sort, Heap Sort
✖ Kruskal’s Algorithm
✖ Dijkstra’s Algorithm
✖ Bellman Ford Algorithm
✔ Kadane’s Algorithm
✖ Lee Algorithm
✖ Flood Fill Algorithm
✔ Floyd’s Cycle Detection Algorithm
✖ Topological Sorting in a DAG
✖ Union Find Algorithm


## Data Structures:

✔ Linked List
✖ BST
	✖ Insertion
	✖ Searching
	✖ Deletion
✔ Stack implementation using an array
	✔ Class
	✔ std::list
	✔ std::stack
	✔ Class Template
✔ Stack Implementation using a Linked List
	✔ Class
	✔ Class Template
✔ Queue implementation using an array
	✔ Class
	✔ std::list
	✔ std::queue
	✔ Class Template
✔ Queue Implementation using a Linked List
	✔ Class
	✔ Class Template
✖ Min Heap and Max Heap
✖ Graph
✖ Trie


## Concepts


## Bit Manipulation

✔ Check if an integer is even or odd
✔ Detect if two integers have opposite signs or not
✔ Add 1 to an integer
✔ Swap two numbers without using any third variable.
✔ Turn off kth bit in a number.
✔ Turn on kth bit in a number.
✔ Check if kth bit is set for a number.
✔ Toggle the kth bit.
✔ Check if a positive integer is a power of 2 without using any branching or loop
✔ Find position of the rightmost set bit
✔ Find position of the only set bit in a number
✔ Computing parity of a number
✔ Brian Kernighan’s Algorithm to count set bits in an integer
✔ Find the total number of bits needed to be flipped
✔ Check if a number is a power of 2 or not
✔ Check if a number is a power of 4 or not
✔ Check if a number is a power of 8 or not
✔ Round up to the next highest power of 2
✔ Round up to the previous power of 2
✔ Compute the parity of a number using a lookup table
✔ Count set bits using a lookup table
✔ Reverse bits of an integer using a lookup table



## References
- https://medium.com/techie-delight/top-algorithms-data-structures-concepts-every-computer-science-student-should-know-e0549c67b4ac