import { SELECT_SEPARATOR } from '@/components/Select'

export const THEME_NAMES = [
	'ambiance',
	'chaos',
	'chrome',
	'cloud9_day',
	'cloud9_night',
	'cloud9_night_low_color',
	'cloud_editor',
	'cloud_editor_dark',
	'clouds',
	'clouds_midnight',
	'cobalt',
	'crimson_editor',
	'dawn',
	'dracula',
	'dreamweaver',
	'eclipse',
	'github',
	'github_dark',
	'github_light_default',
	'gob',
	'gruvbox',
	'gruvbox_dark_hard',
	'gruvbox_light_hard',
	'idle_fingers',
	'iplastic',
	'katzenmilch',
	'kr_theme',
	'kuroir',
	'merbivore',
	'merbivore_soft',
	'mono_industrial',
	'monokai',
	'nord_dark',
	'one_dark',
	'pastel_on_dark',
	'solarized_dark',
	'solarized_light',
	'sqlserver',
	'terminal',
	'textmate',
	'tomorrow',
	'tomorrow_night',
	'tomorrow_night_blue',
	'tomorrow_night_bright',
	'tomorrow_night_eighties',
	'twilight',
	'vibrant_ink',
	'xcode',
]

export type ThemeName = (typeof THEME_NAMES)[number]

export const DEFAULT_DARK_THEME = 'ace/theme/dracula'
export const DEFAULT_LIGHT_THEME = 'ace/theme/xcode'

export const themesOptions: { label: string; value: string }[] = [
	{ label: 'Chrome', value: 'ace/theme/chrome' },
	{ label: 'CloudEditor', value: 'ace/theme/cloud_editor' },
	{ label: 'Clouds', value: 'ace/theme/clouds' },
	{ label: 'Crimson Editor', value: 'ace/theme/crimson_editor' },
	{ label: 'Dawn', value: 'ace/theme/dawn' },
	{ label: 'Dreamweaver', value: 'ace/theme/dreamweaver' },
	{ label: 'Eclipse', value: 'ace/theme/eclipse' },
	{ label: 'GitHub (Legacy)', value: 'ace/theme/github' },
	{ label: 'GitHub Light Default', value: 'ace/theme/github_light_default' },
	{ label: 'IPlastic', value: 'ace/theme/iplastic' },
	{ label: 'KatzenMilch', value: 'ace/theme/katzenmilch' },
	{ label: 'Kuroir', value: 'ace/theme/kuroir' },
	{ label: 'SQL Server', value: 'ace/theme/sqlserver' },
	{ label: 'Solarized Light', value: 'ace/theme/solarized_light' },
	{ label: 'TextMate', value: 'ace/theme/textmate' },
	{ label: 'Tomorrow', value: 'ace/theme/tomorrow' },
	{ label: 'XCode', value: 'ace/theme/xcode' },
	{ label: 'Ambiance', value: 'ace/theme/ambiance' },
	{ label: 'Chaos', value: 'ace/theme/chaos' },
	{ label: 'CloudEditor Dark', value: 'ace/theme/cloud_editor_dark' },
	{ label: 'Clouds Midnight', value: 'ace/theme/clouds_midnight' },
	{ label: 'Cobalt', value: 'ace/theme/cobalt' },
	{ label: 'Dracula', value: 'ace/theme/dracula' },
	{ label: 'GitHub Dark', value: 'ace/theme/github_dark' },
	{ label: 'Green on Black', value: 'ace/theme/gob' },
	{ label: 'Gruvbox', value: 'ace/theme/gruvbox' },
	{ label: 'Merbivore Soft', value: 'ace/theme/merbivore_soft' },
	{ label: 'Merbivore', value: 'ace/theme/merbivore' },
	{ label: 'Mono Industrial', value: 'ace/theme/mono_industrial' },
	{ label: 'Monokai', value: 'ace/theme/monokai' },
	{ label: 'Nord Dark', value: 'ace/theme/nord_dark' },
	{ label: 'One Dark', value: 'ace/theme/one_dark' },
	{ label: 'Pastel on dark', value: 'ace/theme/pastel_on_dark' },
	{ label: 'Solarized Dark', value: 'ace/theme/solarized_dark' },
	{ label: 'Terminal', value: 'ace/theme/terminal' },
	{ label: 'Tomorrow Night 80s', value: 'ace/theme/tomorrow_night_eighties' },
	{ label: 'Tomorrow Night Blue', value: 'ace/theme/tomorrow_night_blue' },
	{ label: 'Tomorrow Night Bright', value: 'ace/theme/tomorrow_night_bright' },
	{ label: 'Tomorrow Night', value: 'ace/theme/tomorrow_night' },
	{ label: 'Twilight', value: 'ace/theme/twilight' },
	{ label: 'Vibrant Ink', value: 'ace/theme/vibrant_ink' },
	{ label: 'idle Fingers', value: 'ace/theme/idle_fingers' },
	{ label: 'krTheme', value: 'ace/theme/kr_theme' },
]

export const languageOption = [
	{ label: 'ABAP', value: 'ace/mode/abap' },
	{ label: 'ABC', value: 'ace/mode/abc' },
	{ label: 'ActionScript', value: 'ace/mode/actionscript' },
	{ label: 'ADA', value: 'ace/mode/ada' },
	{ label: 'Alda', value: 'ace/mode/alda' },
	{ label: 'Apache Conf', value: 'ace/mode/apache_conf' },
	{ label: 'Apex', value: 'ace/mode/apex' },
	{ label: 'AQL', value: 'ace/mode/aql' },
	{ label: 'AsciiDoc', value: 'ace/mode/asciidoc' },
	{ label: 'ASL', value: 'ace/mode/asl' },
	{ label: 'Assembly ARM32', value: 'ace/mode/assembly_arm32' },
	{ label: 'Assembly x86', value: 'ace/mode/assembly_x86' },
	{ label: 'Astro', value: 'ace/mode/astro' },
	{ label: 'AutoHotkey / AutoIt', value: 'ace/mode/autohotkey' },
	{ label: 'BatchFile', value: 'ace/mode/batchfile' },
	{ label: 'BibTeX', value: 'ace/mode/bibtex' },
	{ label: 'C and C++', value: 'ace/mode/c_cpp' },
	{ label: 'C9Search', value: 'ace/mode/c9search' },
	{ label: 'Cirru', value: 'ace/mode/cirru' },
	{ label: 'Clojure', value: 'ace/mode/clojure' },
	{ label: 'Cobol', value: 'ace/mode/cobol' },
	{ label: 'CoffeeScript', value: 'ace/mode/coffee' },
	{ label: 'ColdFusion', value: 'ace/mode/coldfusion' },
	{ label: 'Crystal', value: 'ace/mode/crystal' },
	{ label: 'C#', value: 'ace/mode/csharp' },
	{ label: 'Csound Document', value: 'ace/mode/csound_document' },
	{ label: 'Csound', value: 'ace/mode/csound_orchestra' },
	{ label: 'Csound Score', value: 'ace/mode/csound_score' },
	{ label: 'CSS', value: 'ace/mode/css' },
	{ label: 'Curly', value: 'ace/mode/curly' },
	{ label: 'Cuttlefish', value: 'ace/mode/cuttlefish' },
	{ label: 'D', value: 'ace/mode/d' },
	{ label: 'Dart', value: 'ace/mode/dart' },
	{ label: 'Diff', value: 'ace/mode/diff' },
	{ label: 'Django', value: 'ace/mode/django' },
	{ label: 'Dockerfile', value: 'ace/mode/dockerfile' },
	{ label: 'Dot', value: 'ace/mode/dot' },
	{ label: 'Drools', value: 'ace/mode/drools' },
	{ label: 'Edifact', value: 'ace/mode/edifact' },
	{ label: 'Eiffel', value: 'ace/mode/eiffel' },
	{ label: 'EJS', value: 'ace/mode/ejs' },
	{ label: 'Elixir', value: 'ace/mode/elixir' },
	{ label: 'Elm', value: 'ace/mode/elm' },
	{ label: 'Erlang', value: 'ace/mode/erlang' },
	{ label: 'Flix', value: 'ace/mode/flix' },
	{ label: 'Forth', value: 'ace/mode/forth' },
	{ label: 'Fortran', value: 'ace/mode/fortran' },
	{ label: 'FSharp', value: 'ace/mode/fsharp' },
	{ label: 'FSL', value: 'ace/mode/fsl' },
	{ label: 'FreeMarker', value: 'ace/mode/ftl' },
	{ label: 'Gcode', value: 'ace/mode/gcode' },
	{ label: 'Gherkin', value: 'ace/mode/gherkin' },
	{ label: 'Gitignore', value: 'ace/mode/gitignore' },
	{ label: 'Glsl', value: 'ace/mode/glsl' },
	{ label: 'Gobstones', value: 'ace/mode/gobstones' },
	{ label: 'Go', value: 'ace/mode/golang' },
	{ label: 'GraphQLSchema', value: 'ace/mode/graphqlschema' },
	{ label: 'Groovy', value: 'ace/mode/groovy' },
	{ label: 'HAML', value: 'ace/mode/haml' },
	{ label: 'Handlebars', value: 'ace/mode/handlebars' },
	{ label: 'Haskell', value: 'ace/mode/haskell' },
	{ label: 'Haskell Cabal', value: 'ace/mode/haskell_cabal' },
	{ label: 'haXe', value: 'ace/mode/haxe' },
	{ label: 'Hjson', value: 'ace/mode/hjson' },
	{ label: 'HTML', value: 'ace/mode/html' },
	{ label: 'HTML (Elixir)', value: 'ace/mode/html_elixir' },
	{ label: 'HTML (Ruby)', value: 'ace/mode/html_ruby' },
	{ label: 'INI', value: 'ace/mode/ini' },
	{ label: 'Io', value: 'ace/mode/io' },
	{ label: 'Ion', value: 'ace/mode/ion' },
	{ label: 'Jack', value: 'ace/mode/jack' },
	{ label: 'Jade', value: 'ace/mode/jade' },
	{ label: 'Java', value: 'ace/mode/java' },
	{ label: 'JavaScript', value: 'ace/mode/javascript' },
	{ label: 'JEXL', value: 'ace/mode/jexl' },
	{ label: 'JSON', value: 'ace/mode/json' },
	{ label: 'JSON5', value: 'ace/mode/json5' },
	{ label: 'JSONiq', value: 'ace/mode/jsoniq' },
	{ label: 'JSP', value: 'ace/mode/jsp' },
	{ label: 'JSSM', value: 'ace/mode/jssm' },
	{ label: 'JSX', value: 'ace/mode/jsx' },
	{ label: 'Julia', value: 'ace/mode/julia' },
	{ label: 'Kotlin', value: 'ace/mode/kotlin' },
	{ label: 'LaTeX', value: 'ace/mode/latex' },
	{ label: 'Latte', value: 'ace/mode/latte' },
	{ label: 'LESS', value: 'ace/mode/less' },
	{ label: 'Liquid', value: 'ace/mode/liquid' },
	{ label: 'Lisp', value: 'ace/mode/lisp' },
	{ label: 'LiveScript', value: 'ace/mode/livescript' },
	{ label: 'Log', value: 'ace/mode/log' },
	{ label: 'LogiQL', value: 'ace/mode/logiql' },
	{ label: 'Logtalk', value: 'ace/mode/logtalk' },
	{ label: 'LSL', value: 'ace/mode/lsl' },
	{ label: 'Lua', value: 'ace/mode/lua' },
	{ label: 'LuaPage', value: 'ace/mode/luapage' },
	{ label: 'Lucene', value: 'ace/mode/lucene' },
	{ label: 'Makefile', value: 'ace/mode/makefile' },
	{ label: 'Markdown', value: 'ace/mode/markdown' },
	{ label: 'Mask', value: 'ace/mode/mask' },
	{ label: 'MATLAB', value: 'ace/mode/matlab' },
	{ label: 'Maze', value: 'ace/mode/maze' },
	{ label: 'MediaWiki', value: 'ace/mode/mediawiki' },
	{ label: 'MEL', value: 'ace/mode/mel' },
	{ label: 'MIPS', value: 'ace/mode/mips' },
	{ label: 'MIXAL', value: 'ace/mode/mixal' },
	{ label: 'MUSHCode', value: 'ace/mode/mushcode' },
	{ label: 'MySQL', value: 'ace/mode/mysql' },
	{ label: 'Nasal', value: 'ace/mode/nasal' },
	{ label: 'Nginx', value: 'ace/mode/nginx' },
	{ label: 'Nim', value: 'ace/mode/nim' },
	{ label: 'Nix', value: 'ace/mode/nix' },
	{ label: 'NSIS', value: 'ace/mode/nsis' },
	{ label: 'Nunjucks', value: 'ace/mode/nunjucks' },
	{ label: 'Objective-C', value: 'ace/mode/objectivec' },
	{ label: 'OCaml', value: 'ace/mode/ocaml' },
	{ label: 'Odin', value: 'ace/mode/odin' },
	{ label: 'PartiQL', value: 'ace/mode/partiql' },
	{ label: 'Pascal', value: 'ace/mode/pascal' },
	{ label: 'Perl', value: 'ace/mode/perl' },
	{ label: 'pgSQL', value: 'ace/mode/pgsql' },
	{ label: 'PHP', value: 'ace/mode/php' },
	{ label: 'PHP (Blade Template)', value: 'ace/mode/php_laravel_blade' },
	{ label: 'Pig', value: 'ace/mode/pig' },
	{ label: 'PLSQL', value: 'ace/mode/plsql' },
	{ label: 'Powershell', value: 'ace/mode/powershell' },
	{ label: 'Praat', value: 'ace/mode/praat' },
	{ label: 'Prisma', value: 'ace/mode/prisma' },
	{ label: 'Prolog', value: 'ace/mode/prolog' },
	{ label: 'Properties', value: 'ace/mode/properties' },
	{ label: 'Protobuf', value: 'ace/mode/protobuf' },
	{ label: 'PRQL', value: 'ace/mode/prql' },
	{ label: 'Puppet', value: 'ace/mode/puppet' },
	{ label: 'Python', value: 'ace/mode/python' },
	{ label: 'QML', value: 'ace/mode/qml' },
	{ label: 'R', value: 'ace/mode/r' },
	{ label: 'Raku', value: 'ace/mode/raku' },
	{ label: 'Razor', value: 'ace/mode/razor' },
	{ label: 'RDoc', value: 'ace/mode/rdoc' },
	{ label: 'Red', value: 'ace/mode/red' },
	{ label: 'RHTML', value: 'ace/mode/rhtml' },
	{ label: 'Robot', value: 'ace/mode/robot' },
	{ label: 'RST', value: 'ace/mode/rst' },
	{ label: 'Ruby', value: 'ace/mode/ruby' },
	{ label: 'Rust', value: 'ace/mode/rust' },
	{ label: 'SaC', value: 'ace/mode/sac' },
	{ label: 'SASS', value: 'ace/mode/sass' },
	{ label: 'SCAD', value: 'ace/mode/scad' },
	{ label: 'Scala', value: 'ace/mode/scala' },
	{ label: 'Scheme', value: 'ace/mode/scheme' },
	{ label: 'Scrypt', value: 'ace/mode/scrypt' },
	{ label: 'SCSS', value: 'ace/mode/scss' },
	{ label: 'SH', value: 'ace/mode/sh' },
	{ label: 'SJS', value: 'ace/mode/sjs' },
	{ label: 'Slim', value: 'ace/mode/slim' },
	{ label: 'Smarty', value: 'ace/mode/smarty' },
	{ label: 'Smithy', value: 'ace/mode/smithy' },
	{ label: 'snippets', value: 'ace/mode/snippets' },
	{ label: 'Soy Template', value: 'ace/mode/soy_template' },
	{ label: 'Space', value: 'ace/mode/space' },
	{ label: 'SPARQL', value: 'ace/mode/sparql' },
	{ label: 'SQL', value: 'ace/mode/sql' },
	{ label: 'SQLServer', value: 'ace/mode/sqlserver' },
	{ label: 'Stylus', value: 'ace/mode/stylus' },
	{ label: 'SVG', value: 'ace/mode/svg' },
	{ label: 'Swift', value: 'ace/mode/swift' },
	{ label: 'Tcl', value: 'ace/mode/tcl' },
	{ label: 'Terraform', value: 'ace/mode/terraform' },
	{ label: 'Tex', value: 'ace/mode/tex' },
	{ label: 'Text', value: 'ace/mode/text' },
	{ label: 'Textile', value: 'ace/mode/textile' },
	{ label: 'Toml', value: 'ace/mode/toml' },
	{ label: 'TSX', value: 'ace/mode/tsx' },
	{ label: 'Turtle', value: 'ace/mode/turtle' },
	{ label: 'Twig', value: 'ace/mode/twig' },
	{ label: 'Typescript', value: 'ace/mode/typescript' },
	{ label: 'Vala', value: 'ace/mode/vala' },
	{ label: 'VBScript', value: 'ace/mode/vbscript' },
	{ label: 'Velocity', value: 'ace/mode/velocity' },
	{ label: 'Verilog', value: 'ace/mode/verilog' },
	{ label: 'VHDL', value: 'ace/mode/vhdl' },
	{ label: 'Visualforce', value: 'ace/mode/visualforce' },
	{ label: 'Vue', value: 'ace/mode/vue' },
	{ label: 'Wollok', value: 'ace/mode/wollok' },
	{ label: 'XML', value: 'ace/mode/xml' },
	{ label: 'XQuery', value: 'ace/mode/xquery' },
	{ label: 'YAML', value: 'ace/mode/yaml' },
	{ label: 'Zeek', value: 'ace/mode/zeek' },
	{ label: 'Zig', value: 'ace/mode/zig' },
]

export const FILE_EXT_LANG_MAP = {
	c: 'c',
	cpp: 'cpp',
	cs: 'csharp',
	css: 'css',
	dart: 'dart',
	erl: 'erlang',
	go: 'go',
	htm: 'html',
	html: 'html',
	java: 'java',
	jl: 'julia',
	js: 'javascript',
	jsx: 'jsx',
	json: 'json',
	kt: 'kotlin',
	less: 'less',
	lua: 'lua',
	md: 'markdown',
	php: 'php',
	pl: 'perl',
	pm: 'perl',
	ps: 'powershell',
	py: 'python',
	r: 'r',
	rb: 'ruby',
	rs: 'rust',
	sass: 'sass',
	scala: 'scala',
	scss: 'sass',
	sh: 'shell',
	sql: 'sql',
	swift: 'swift',
	toml: 'toml',
	ts: 'typescript',
	tsx: 'tsx',
	vb: 'vb',
	vue: 'vue',
	wast: 'wast',
	xml: 'xml',
	yaml: 'yaml',
	zig: 'zig',
}

export type FILE_EXT_LANG_MAP_KEY = keyof typeof FILE_EXT_LANG_MAP
