# プルリクエスト確認ガイドライン

以下の内容は、Contibutions.json に情報が追加された場合のみ適応されます。

## 確認内容

- GitHub の URL が正しく設定されているか
- カラーコードが正しく設定されているか
- 絵文字が 1 つか
- 字下げができているか
- 適切に `,`、`{}` 、`""` が書かれているか
- ローカル環境で変更を確認して、Webページに反映されているか

## 修正が必要な場合

基本的に細かい、もしくはささいな内容であっても、ユーザーに修正をお願いする方針です。

ですが、コントリビューション練習リポジトリということをふまえ、ユーザーに修正してもらえるか、対応可能かを確認をしてください。
その後、以下のように対応をお願いいたします。

- ユーザーが修正する: 修正内容を明示し作業をしてもらう。必要であればサポート。
- ユーザーが修正しない: メンテナーがコミットを積んで修正、もしくはコンフリクト解消時に修正。

---

## 修正事例

共有すべき修正事例があればこちらに追加してください。

### 絵文字が2文字

- 関連 Issue、プルリク
  - [#231](https://github.com/first-contributions-ja/first-contributions-ja.github.io/pull/231)
- 原因・仮説
  - おそらくWindows特有の絵文字が指定されたことにより、2文字になっている
- 対応
  - ユーザーにWindows絵文字がGoogle FontsのNoto Emojiに対応していないことを伝えた
- メンテナー最終対応
  - コンフリクトしていたので、解消ついでに絵文字を修正