# Welcome to Promptolution!

Promptolution is a modular library for optimizing prompts for large language models.

Promptolution makes advanced prompt tuning techniques available to everybody In an intuitive design, it facilitates the application of prompt optimization techniques both for real-world problems and research projects. The library's modular design ensures extensibility, allowing for seamless integration of new prompt optimizers, LLMs, and tasks. By providing a common framework, it helps standardize prompt tuning approaches, facilitating comparison of different methods and results across studies, and enhancing reproducibility in prompt optimization research.

## Features

- Various LLM implementations
- Optimization algorithms for prompt tuning
- Task-specific modules
- Flexible configuration options

## Getting Started

Install via pip:

```
pip install promptolution
```

Or clone our GitHub repository:

[https://github.com/finitearth/promptolution](https://github.com/finitearth/promptolution)

## API Reference

- [LLMs](api/llms.md)
- [Optimizers](api/optimizers.md)
- [Predictors](api/predictors.md)
- [Tasks](api/tasks.md)
- [Callbacks](api/callbacks.md)
- [Config](api/config.md)
