#!/opentty.py sh
# -*- coding: utf-8 -*-
#
#  Copyright (C) 2023 "Mr. Lima" [psh-tester.sh]
#
#  This code is part of OpenTTY Package Repository
#  
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#  
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#  
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.

# OpenTTY "PSH Deploy"
#
# Adding and removing files from whitelist
chmod test.file
chmod test.file

# Testing NETMAN Plugin
gaddr www.google.com 
fw 142.251.129.36

curl https://github.com/fetuber4095/OpenTTY

genip
gping

netstat

ifconfig

# Testing Plugin "The boy of Files"
mkdir testdir
rmdir testdir

touch testfile
rm testfile

ls

touch testfile2

cp testfile2 testfile3
mv testfile3 anyfile

rm testfile2

# Testing "The BOX Plugin"
gzip archive.zip anyfile
zipinfo archive.zip

gt archive.d archive.zip 
tar archive.d


fstab

df

# Testing PSH Plugin and Miscellania
uname
uname -a

export value 10
env

rem
rem - Runned DEPLOYER [&time]

tty 

clear
cls

pull file.json
dd file.json file.json

catbin file.json

rm file.json
rm archive.zip
rm archive.d
rm anyfile


ps 

echo &green&bold * Deploy Finished!