# Shortest Tutorial Ever

![Shortest Tutorial Ever](https://github.com/felipextrindade/shortest-tutorial-ever/blob/master/ste.PNG?raw=true)

A collection of single page syntax tutorials for every language and technology in the development scene. 

## Shortest? But... Why?

When learning new languages or technologies, we know that there is many differences between the new and previous knowledge.

However, if a C programmer wants to learn Golang, he doesn't need to start with a 40hrs+ course or see a video with 15 minutes about the history of Go. **Sometimes, we just need a cheatsheet with the language syntax to start learning**.

This is what we are aiming with this project: simple, kickstart knowledge to learn new things.

### Shortest Tutorials EVER - The list
* [C [COMING SOON]]()
* [Golang](https://github.com/fesiqp/shortest-golang-tutorial-ever)
* **Javascript**
  * [ES6](https://github.com/felipextrindade/shortest-es6-tutorial-ever)
  * [Angular [COMING SOON]]()
  * [React [COMING SOON]]()
* [Java [COMING SOON]]()
  * [Java 8 [COMING SOON]]()
* [Kotlin [COMING SOON]]()
* [Python [COMING SOON]]()
  * [Python 2 [COMING SOON]]()
  * [Python 3 [COMING SOON]]()
* [SQL [COMING SOON]]()
  * [MySQL [COMING SOON]]()
  * [Oracle [COMING SOON]]()
  * [PostgreSQL [COMING SOON]]()

## Contributing

To contribute, please take note on the following:
* Every repo must contain **minimum files possible + README (optional)**
* Every repo must be named **shortest-[TECH_NAME]-tutorial-ever**. But don't worry, you can omit something if the name's too long.
* Every file (except the README) must be in the language/technology own extension. (.go for Golang, .java for Java, .js for Javascript and so on)
* Every comment must be made in the language/technology own comment syntax.
* Make sure that your code runs. The examples must work. If something special is needed to run the code (frameworks, config, etc), add it to the file in the form of a comment or the repo's README.
* After you created a tutorial, raise a PR to this README adding your Shortest Tutorial Ever to the list - pointing to the repo.
* Feel free to add your name to the contributors list below.

### Beware: if your repo doesn't follow the above, we won't accept it as part of Shortest Tutorials Ever.

## Contributors
* [Felipe Trindade](https://github.com/felipextrindade) - Original Idea; ES6
* [Felipe Siqueira](https://github.com/fesiqp) - Golang
