## Welcome to the transfer-nlp library!

This library is intended to be a growing playground for NLP research and development. Built up from scratch on top of PyTorch,
the goal ios to create easily reusable modules to define, train and deploy NLP models from the latest state of the art
research community.

Here are a few ways to contribute to this project:

- Code reviewing: we are never tough enough on ourselves so proof-reading is very much appreciated to get the code 
more elegant / pythonic!
- Bugs requests: something is not working on your end
- Design Pattern requests: you feel like there might be a better design, I want to hear about it :)

Here are a few ways you can contribute to this project in terms of ML content:

- Implement a state of the art model and upload your custom classes on the project
- Have a way to easily visualize learned embeddings. This might be using open tools such as the [Embedding Projector](https://projector.tensorflow.org/) project
- Have a good design to incorporate multi-task training
- Design pipelines to use / fine-tune pre-trained state of the art architecture
- Enable large-scale training

When contributing, please have a production mindset:

- write unit tests
- Type hints everything
- Write clear documentation on all your objects definitions

When submitting a new experiment, it is very helpful to release a [Colab notebook](https://colab.research.google.com/drive/1DtC31eUejz1T0DsaEfHq_DOxEfanmrG1#scrollTo=Xzu3HPdGrnza) with a very simple use case.
