# Autogenerated Variants

When creating a resource, variants can be explicitly defined in the `variant` field of Sources, Transformations, 
Features, Labels, and Training Sets. If no variant is defined, a randomly generated variant is created and used.

The same randomly generated variant is added to each resource until `import featureform` is called again or 
`featureform.set_run()` is called. 

## Setting A Run
Variants can be explicitly defined by calling `featureform.set_run("my_variant")` with a string argument. 
This string will be used as the variant from that point forward. Calling `featureform.set_run()` with no arguments
will create a new auto-generated variant.

::: featureform.register.Registrar.set_run
    handler: python
    options:
        show_root_heading: false
        show_source: false
        show_root_toc_entry: false

## Getting A Run
The currently set run can be gotten by calling `featureform.get_run()`. This will return a string of the current run.

This is useful when using serving functions from the notebook that resources are being applied in. 

::: featureform.register.Registrar.get_run
    handler: python
    options:
        show_root_heading: false
        show_source: false
        show_root_toc_entry: false