# Contributing to featureform

We love to receive contributions from the community and hear your opinions! We want to make contributing to featureform as easily as it can be.

# How can you help us?

* Report a bug
* Improve documentation
* Discuss the code implementation
* Submit a bug fix
* Propose new features
* Test featureform

# Code contributions
In general, we follow the "fork-and-pull" Git workflow.

1. Fork the Featureform repository in the Github UI
2. Clone the repository to your local computer
3. Make changes and commit them
4. Push your local branch to your fork
5. Submit a pull request from your form to Featureform's main branch so that we can review your changes
6. Fill out the information in the description and make sure the title is accurate.
7. Wait for tests to run and make sure that the CI tests are green. If not, please resolve or ask for help.

>NOTE: Be sure to merge the latest from "upstream" before making a pull request to handle any merge conflicts!

# Feature and Bug reports
We use GitHub issues to track bugs and features. Report them by opening a [new issue](https://github.com/featureform/embeddings/issues/new/choose) and fill out all of the required inputs.

# Code review process
The Pull Request reviews are done on a regular basis. 
Please, make sure you respond to our feedback/questions.

# Community
If you have additional questions or you want to chat with featureform core team, you can join our community [![Discourse posts](https://img.shields.io/badge/Community-discourse-blue)](https://join.slack.com/t/featureform-community/shared_invite/zt-xhqp2m4i-JOCaN1vRN2NDXSVif10aQg)
