//* NESTJS
import { Injectable, OnModuleDestroy, OnModuleInit } from '@nestjs/common';

//* PRISMA
import { PrismaClient } from '@prisma/client';

@Injectable()
export class PrismaService
  extends PrismaClient
  implements OnModuleInit, OnModuleDestroy
{
  async onModuleInit() {
    await this.$connect();
  }

  async onModuleDestroy() {
    await this.$disconnect();
  }
}
