<?php
/**
 * TaxProfileTest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.2
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use PHPUnit\Util\Test;

/**
 * TaxProfileTest Class Doc Comment
 *
 * @category    Class
 * @description TaxProfile
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class TaxProfileTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "company_type": "individual",
            "company_subtype": "artigiani",
            "profession": "test",
            "regime": "forfettario_5",
            "rivalsa_name": "",
            "default_rivalsa": 0,
            "cassa_name": "",
            "default_cassa": 0,
            "default_cassa_taxable": 100,
            "cassa2_name": "",
            "default_cassa2": 0,
            "default_cassa2_taxable": 0,
            "default_withholding_tax": 0,
            "default_withholding_tax_taxable": 100,
            "default_other_withholding_tax": 0,
            "enasarco": false,
            "enasarco_type": "null",
            "contributions_percentage": 0,
            "profit_coefficient": 0,
            "med": false,
            "default_vat": {
                "id": 66,
                "value": 0,
                "description": "Contribuenti forfettari",
                "notes": "Operazione non soggetta a IVA ai sensi dell\'art. 1, commi 54-89, Legge n. 190\/2014 e succ. modifiche\/integrazioni",
                "e_invoice": true,
                "ei_type": "2.2",
                "ei_description": "Non soggetta art. 1\/54-89 L. 190\/2014 e succ. modifiche\/integrazioni",
                "editable": false,
                "is_disabled": false,
                "default": true
            }
        }';


        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\TaxProfile');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "TaxProfile"
     */
    public function testTaxProfile()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "company_type"
     */
    public function testPropertyCompanyType()
    {
        TestCase::assertEquals($this->object['company_type'], $this->array['company_type']);
    }

    /**
     * Test attribute "company_subtype"
     */
    public function testPropertyCompanySubtype()
    {
        TestCase::assertEquals($this->object['company_subtype'], $this->array['company_subtype']);
    }

    /**
     * Test attribute "profession"
     */
    public function testPropertyProfession()
    {
        TestCase::assertEquals($this->object['profession'], $this->array['profession']);
    }

    /**
     * Test attribute "regime"
     */
    public function testPropertyRegime()
    {
        TestCase::assertEquals($this->object['regime'], $this->array['regime']);
    }

    /**
     * Test attribute "rivalsa_name"
     */
    public function testPropertyRivalsaName()
    {
        TestCase::assertEquals($this->object['rivalsa_name'], $this->array['rivalsa_name']);
    }

    /**
     * Test attribute "default_rivalsa"
     */
    public function testPropertyDefaultRivalsa()
    {
        TestCase::assertEquals($this->object['default_rivalsa'], $this->array['default_rivalsa']);
    }

    /**
     * Test attribute "cassa_name"
     */
    public function testPropertyCassaName()
    {
        TestCase::assertEquals($this->object['cassa_name'], $this->array['cassa_name']);
    }

    /**
     * Test attribute "default_cassa"
     */
    public function testPropertyDefaultCassa()
    {
        TestCase::assertEquals($this->object['default_cassa'], $this->array['default_cassa']);
    }

    /**
     * Test attribute "default_cassa_taxable"
     */
    public function testPropertyDefaultCassaTaxable()
    {
        TestCase::assertEquals($this->object['default_cassa_taxable'], $this->array['default_cassa_taxable']);
    }

    /**
     * Test attribute "cassa2_name"
     */
    public function testPropertyCassa2Name()
    {
        TestCase::assertEquals($this->object['cassa2_name'], $this->array['cassa2_name']);
    }

    /**
     * Test attribute "default_cassa2"
     */
    public function testPropertyDefaultCassa2()
    {
        TestCase::assertEquals($this->object['default_cassa2'], $this->array['default_cassa2']);
    }

    /**
     * Test attribute "default_cassa2_taxable"
     */
    public function testPropertyDefaultCassa2Taxable()
    {
        TestCase::assertEquals($this->object['default_cassa2_taxable'], $this->array['default_cassa2_taxable']);
    }

    /**
     * Test attribute "default_withholding_tax"
     */
    public function testPropertyDefaultWithholdingTax()
    {
        TestCase::assertEquals($this->object['default_withholding_tax'], $this->array['default_withholding_tax']);
    }

    /**
     * Test attribute "default_withholding_tax_taxable"
     */
    public function testPropertyDefaultWithholdingTaxTaxable()
    {
        TestCase::assertEquals($this->object['default_withholding_tax_taxable'], $this->array['default_withholding_tax_taxable']);
    }

    /**
     * Test attribute "default_other_withholding_tax"
     */
    public function testPropertyDefaultOtherWithholdingTax()
    {
        TestCase::assertEquals($this->object['default_other_withholding_tax'], $this->array['default_other_withholding_tax']);
    }

    /**
     * Test attribute "enasarco"
     */
    public function testPropertyEnasarco()
    {
        TestCase::assertEquals($this->object['enasarco'], $this->array['enasarco']);
    }

    /**
     * Test attribute "enasarco_type"
     */
    public function testPropertyEnasarcoType()
    {
        TestCase::assertEquals($this->object['enasarco_type'], $this->array['enasarco_type']);
    }

    /**
     * Test attribute "contributions_percentage"
     */
    public function testPropertyContributionsPercentage()
    {
        TestCase::assertEquals($this->object['contributions_percentage'], $this->array['contributions_percentage']);
    }

    /**
     * Test attribute "profit_coefficient"
     */
    public function testPropertyProfitCoefficient()
    {
        TestCase::assertEquals($this->object['profit_coefficient'], $this->array['profit_coefficient']);
    }

    /**
     * Test attribute "med"
     */
    public function testPropertyMed()
    {
        TestCase::assertEquals($this->object['med'], $this->array['med']);
    }

    /**
     * Test attribute "default_vat"
     */
    public function testPropertyDefaultVat()
    {
        foreach ($this->array['default_vat'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['default_vat']);
        }
    }
}
