<?php
/**
 * ReceivedDocumentItemsListItemTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.0.10
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * ReceivedDocumentItemsListItemTest Class Doc Comment
 *
 * @category    Class
 * @description ReceivedDocumentItemsListItem
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ReceivedDocumentItemsListItemTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "id": 12345,
            "product_id": 54321,
            "code": "pdr01",
            "measure": "very big",
            "name": "prod uan",
            "net_price": 100,
            "category": "other",
            "qty": 1,
            "stock": 99,
            "vat": {
                "id": 1020,
                "value": 0,
                "description": "PA Non imp art. 2",
                "is_disabled": false
            }
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\ReceivedDocumentItemsListItem');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "ReceivedDocumentItemsList"
     */
    public function testReceivedDocumentItemsList()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        TestCase::assertEquals($this->object['id'], $this->array['id']);
    }

    /**
     * Test attribute "product_id"
     */
    public function testPropertyProductId()
    {
        TestCase::assertEquals($this->object['product_id'], $this->array['product_id']);
    }

    /**
     * Test attribute "code"
     */
    public function testPropertyCode()
    {
        TestCase::assertEquals($this->object['code'], $this->array['code']);
    }

    /**
     * Test attribute "name"
     */
    public function testPropertyName()
    {
        TestCase::assertEquals($this->object['name'], $this->array['name']);
    }

    /**
     * Test attribute "measure"
     */
    public function testPropertyMeasure()
    {
        TestCase::assertEquals($this->object['measure'], $this->array['measure']);
    }

    /**
     * Test attribute "net_price"
     */
    public function testPropertyNetPrice()
    {
        TestCase::assertEquals($this->object['net_price'], $this->array['net_price']);
    }

    /**
     * Test attribute "category"
     */
    public function testPropertyCategory()
    {
        TestCase::assertEquals($this->object['category'], $this->array['category']);
    }

    /**
     * Test attribute "qty"
     */
    public function testPropertyQty()
    {
        TestCase::assertEquals($this->object['qty'], $this->array['qty']);
    }

    /**
     * Test attribute "vat"
     */
    public function testPropertyVat()
    {
        foreach ($this->array['vat'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['vat']);
        }
    }

    /**
     * Test attribute "stock"
     */
    public function testPropertyStock()
    {
        TestCase::assertEquals($this->object['stock'], $this->array['stock']);
    }
}
