<?php
/**
 * ReceivedDocumentInfoTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * ReceivedDocumentInfoTest Class Doc Comment
 *
 * @category    Class
 * @description
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ReceivedDocumentInfoTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "default_values": {
                "detailed": false
            },
            "items_default_values": {
                "vat": 21
            },
            "countries_list": [
                "Italia",
                "Afghanistan",
                "Albania"
            ],
            "currencies_list": [
                {
                  "id": "AED",
                  "symbol": "AED",
                  "html_symbol": "AED",
                  "exchange_rate": "4.09500"
                },
                {
                  "id": "ALL",
                  "symbol": "ALL",
                  "html_symbol": "ALL",
                  "exchange_rate": "121.50000"
                }
            ],
            "categories_list": [
                "Auto",
                "Telefono e internet"
            ],
            "payment_accounts_list": [
                {
                  "id": 111,
                  "name": "Indesa - carta conto"
                }
            ],
            "vat_types_list": [
                {
                  "id": 1334,
                  "value": 0,
                  "description": "Non imp. art. 17 c. 6 DPR 633/72 e s.m.i.",
                  "is_disabled": false
                },
                {
                  "id": 1333,
                  "value": 0,
                  "description": "Non sogg. art. 74 c. 7 e 8 DPR 633/72",
                  "is_disabled": false
                }
            ]
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\ReceivedDocumentInfo');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "ReceivedDocumentInfo"
     */
    public function testReceivedDocumentInfo()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "default_values"
     */
    public function testPropertyDefaultValues()
    {
        foreach ($this->array['default_values'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['default_values']);
        }
    }

    /**
     * Test attribute "items_default_values"
     */
    public function testPropertyItemsDefaultValues()
    {
        foreach ($this->array['items_default_values'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['items_default_values']);
        }
    }

    /**
     * Test attribute "countries_list"
     */
    public function testPropertyCountriesList()
    {
        foreach ($this->array['countries_list'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['countries_list']);
        }
    }

    /**
     * Test attribute "currencies_list"
     */
    public function testPropertyCurrenciesList()
    {
        foreach ($this->array['currencies_list'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['currencies_list']);
        }
    }

    /**
     * Test attribute "categories_list"
     */
    public function testPropertyCategoriesList()
    {
        foreach ($this->array['categories_list'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['categories_list']);
        }
    }

    /**
     * Test attribute "payment_accounts_list"
     */
    public function testPropertyPaymentAccountsList()
    {
        foreach ($this->array['payment_accounts_list'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['payment_accounts_list']);
        }
    }

    /**
     * Test attribute "vat_types_list"
     */
    public function testPropertyVatTypesList()
    {
        foreach ($this->array['vat_types_list'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['vat_types_list']);
        }
    }
}
