<?php
/**
 * ListEmailsResponseTest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.0.22
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.2.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * ListEmailsResponseTest Class Doc Comment
 *
 * @category    Class
 * @description ListEmailsResponse
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ListEmailsResponseTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "current_page": 1,
            "data": [
              {
                "id": 1,
                "status": "sent",
                "sent_date": "2022-07-17 13:53:12",
                "errors_count": 0,
                "error_log": "",
                "from_email": "test@mail.it",
                "from_name": "Test mail",
                "to_email": "mail@test.it",
                "to_name": "Mario",
                "subject": "Test",
                "content": "Test send email",
                "copy_to": "",
                "recipient_status": "unknown",
                "recipient_date": null,
                "kind": "Fatture",
                "attachments": []
              },
              {
                "id": 2,
                "status": "sent",
                "sent_date": "2022-07-18 13:53:12",
                "errors_count": 0,
                "error_log": "",
                "from_email": "test@mail.it",
                "from_name": "Test mail",
                "to_email": "mail@test.it",
                "to_name": "Maria",
                "subject": "Test",
                "content": "Test send email",
                "copy_to": "",
                "recipient_status": "unknown",
                "recipient_date": null,
                "kind": "Fatture",
                "attachments": []
              }
            ],
            "first_page_url": "emails?page=1",
            "next_page_url": "emails?page=1",
            "from": 1,
            "last_page": 1,
            "last_page_url": "emails?page=1",
            "path": "emails",
            "per_page": 50,
            "prev_page_url": "emails?page=1",
            "to": 2,
            "total": 2
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\ListEmailsResponse');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "ListEmailsResponse"
     */
    public function testListEmailsResponse()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "current_page"
     */
    public function testPropertyCurrentPage()
    {
        TestCase::assertEquals($this->object['current_page'], $this->array['current_page']);
    }

    /**
     * Test attribute "first_page_url"
     */
    public function testPropertyFirstPageUrl()
    {
        TestCase::assertEquals($this->object['first_page_url'], $this->array['first_page_url']);
    }

    /**
     * Test attribute "from"
     */
    public function testPropertyFrom()
    {
        TestCase::assertEquals($this->object['from'], $this->array['from']);
    }

    /**
     * Test attribute "last_page"
     */
    public function testPropertyLastPage()
    {
        TestCase::assertEquals($this->object['last_page'], $this->array['last_page']);
    }

    /**
     * Test attribute "last_page_url"
     */
    public function testPropertyLastPageUrl()
    {
        TestCase::assertEquals($this->object['last_page_url'], $this->array['last_page_url']);
    }

    /**
     * Test attribute "next_page_url"
     */
    public function testPropertyNextPageUrl()
    {
        TestCase::assertEquals($this->object['next_page_url'], $this->array['next_page_url']);
    }

    /**
     * Test attribute "path"
     */
    public function testPropertyPath()
    {
        TestCase::assertEquals($this->object['path'], $this->array['path']);
    }

    /**
     * Test attribute "per_page"
     */
    public function testPropertyPerPage()
    {
        TestCase::assertEquals($this->object['per_page'], $this->array['per_page']);
    }

    /**
     * Test attribute "prev_page_url"
     */
    public function testPropertyPrevPageUrl()
    {
        TestCase::assertEquals($this->object['prev_page_url'], $this->array['prev_page_url']);
    }

    /**
     * Test attribute "to"
     */
    public function testPropertyTo()
    {
        TestCase::assertEquals($this->object['to'], $this->array['to']);
    }

    /**
     * Test attribute "total"
     */
    public function testPropertyTotal()
    {
        TestCase::assertEquals($this->object['total'], $this->array['total']);
    }

    /**
     * Test attribute "data"
     */
    public function testPropertyData()
    {
        foreach ($this->array['data'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['data']);
        }
    }
}
