<?php
/**
 * IssuedDocumentPaymentsListItemTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.0.10
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * IssuedDocumentPaymentsListItemTest Class Doc Comment
 *
 * @category    Class
 * @description IssuedDocumentPaymentsListItem
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class IssuedDocumentPaymentsListItemTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "id": 1,
            "due_date": "2021/12/10",
            "amount": 333,
            "status": "paid",
            "paid_date": "2021/12/11",
            "payment_account": {
                "id": 21,
                "name": "Indesa - Carta conto",
                "type": "standard",
                "virtual": false
            },
            "ei_raw": {
                "prop": true
            }
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\IssuedDocumentPaymentsListItem');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "IssuedDocumentPaymentsListItem"
     */
    public function testIssuedDocumentPaymentsListItem()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        TestCase::assertEquals($this->object['id'], $this->array['id']);
    }

    /**
     * Test attribute "due_date"
     */
    public function testPropertyDueDate()
    {
        $date = new \DateTime($this->array['due_date']);
        TestCase::assertEquals($this->object['due_date'], $date);
    }

    /**
     * Test attribute "amount"
     */
    public function testPropertyAmount()
    {
        TestCase::assertEquals($this->object['amount'], $this->array['amount']);
    }

    /**
     * Test attribute "status"
     */
    public function testPropertyStatus()
    {
        TestCase::assertEquals($this->object['status'], $this->array['status']);
    }

    /**
     * Test attribute "payment_account"
     */
    public function testPropertyPaymentAccount()
    {
        foreach ($this->array['payment_account'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['payment_account']);
        }
    }

    /**
     * Test attribute "paid_date"
     */
    public function testPropertyPaidDate()
    {
        $date = new \DateTime($this->array['paid_date']);
        TestCase::assertEquals($this->object['paid_date'], $date);
    }

    /**
     * Test attribute "ei_raw"
     */
    public function testPropertyEiRaw()
    {
        foreach ($this->array['ei_raw'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['ei_raw']);
        }
    }
}
