<?php
/**
 * EmailTest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.0.22
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.2.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * EmailTest Class Doc Comment
 *
 * @category    Class
 * @description 
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class EmailTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "id": 1,
            "status": "sent",
            "sent_date": "2022-07-17 13:53:12",
            "errors_count": 0,
            "error_log": "",
            "from_email": "test@mail.it",
            "from_name": "Test mail",
            "to_email": "mail@test.it",
            "to_name": "Mario",
            "subject": "Test",
            "content": "Test send email",
            "copy_to": "",
            "recipient_status": "unknown",
            "recipient_date": "2022-07-17 13:53:12",
            "kind": "Fatture",
            "attachments": [ ]
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\Email');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "Email"
     */
    public function testEmail()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        TestCase::assertEquals($this->object['id'], $this->array['id']);
    }

    /**
     * Test attribute "status"
     */
    public function testPropertyStatus()
    {
        TestCase::assertEquals($this->object['status'], $this->array['status']);
    }

    /**
     * Test attribute "sent_date"
     */
    public function testPropertySentDate()
    {
        TestCase::assertEquals($this->object['sent_date'], $this->array['sent_date']);
    }

    /**
     * Test attribute "errors_count"
     */
    public function testPropertyErrorsCount()
    {
        TestCase::assertEquals($this->object['errors_count'], $this->array['errors_count']);
    }

    /**
     * Test attribute "error_log"
     */
    public function testPropertyErrorLog()
    {
        TestCase::assertEquals($this->object['error_log'], $this->array['error_log']);
    }

    /**
     * Test attribute "from_email"
     */
    public function testPropertyFromEmail()
    {
        TestCase::assertEquals($this->object['from_email'], $this->array['from_email']);
    }

    /**
     * Test attribute "from_name"
     */
    public function testPropertyFromName()
    {
        TestCase::assertEquals($this->object['from_name'], $this->array['from_name']);
    }

    /**
     * Test attribute "to_email"
     */
    public function testPropertyToEmail()
    {
        TestCase::assertEquals($this->object['to_email'], $this->array['to_email']);
    }

    /**
     * Test attribute "to_name"
     */
    public function testPropertyToName()
    {
        TestCase::assertEquals($this->object['to_name'], $this->array['to_name']);
    }

    /**
     * Test attribute "subject"
     */
    public function testPropertySubject()
    {
        TestCase::assertEquals($this->object['subject'], $this->array['subject']);
    }

    /**
     * Test attribute "content"
     */
    public function testPropertyContent()
    {
        TestCase::assertEquals($this->object['content'], $this->array['content']);
    }

    /**
     * Test attribute "copy_to"
     */
    public function testPropertyCopyTo()
    {
        TestCase::assertEquals($this->object['copy_to'], $this->array['copy_to']);
    }

    /**
     * Test attribute "recipient_status"
     */
    public function testPropertyRecipientStatus()
    {
        TestCase::assertEquals($this->object['recipient_status'], $this->array['recipient_status']);
    }

    /**
     * Test attribute "recipient_date"
     */
    public function testPropertyRecipientDate()
    {
        $date = new \DateTime($this->array['recipient_date']);
        TestCase::assertEquals($this->object['recipient_date'], $date);
    }

    /**
     * Test attribute "kind"
     */
    public function testPropertyKind()
    {
        TestCase::assertEquals($this->object['kind'], $this->array['kind']);
    }

    /**
     * Test attribute "attachments"
     */
    public function testPropertyAttachments()
    {
        TestCase::assertEquals($this->object['attachments'], $this->array['attachments']);
    }
}
