<?php
/**
 * CompanyInfoTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * CompanyInfoTest Class Doc Comment
 *
 * @category    Class
 * @description Detailed information for the company.
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class CompanyInfoTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "id": 12345,
            "name": "Studio Commercialista",
            "email": "mario.rossi@example.com",
            "type": "accountant",
            "is_accountant": true,
            "accountant_id": 12345,
            "access_info": {
                "role": "master",
                "through_accountant": false
              },
            "plan_info": {
                "limits": {
                  "clients": 5000,
                  "suppliers": 5000,
                  "products": 5000,
                  "documents": 3000
                },
            "functions": {
                  "document_attachments": true,
                  "archive": true,
                  "payment_notifications": true,
                  "paypal": true,
                  "receipts": true,
                  "e_invoice": true,
                  "genius": true,
                  "stock": true,
                  "smtp": true,
                  "mail_tracking": true,
                  "subaccounts": true,
                  "tessera_sanitaria": true,
                  "recurring": true,
                  "sofort": false,
                  "cerved": true,
                  "ts_digital": true,
                  "ts_pay": true,
                  "ts_invoice_trading": true
                },
                "functions_status": {
                  "ts_digital": {
                    "active": true
                  },
                  "ts_pay": {
                    "active": true
                  }
                }
            }
        }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\CompanyInfo');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "CompanyInfo"
     */
    public function testCompanyInfo()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        TestCase::assertEquals($this->object['id'], $this->array['id']);
    }

    /**
     * Test attribute "name"
     */
    public function testPropertyName()
    {
        TestCase::assertEquals($this->object['name'], $this->array['name']);
    }

    /**
     * Test attribute "email"
     */
    public function testPropertyEmail()
    {
        TestCase::assertEquals($this->object['email'], $this->array['email']);
    }

    /**
     * Test attribute "type"
     */
    public function testPropertyType()
    {
        TestCase::assertEquals($this->object['type'], $this->array['type']);
    }

    /**
     * Test attribute "access_info"
     */
    public function testPropertyAccessInfo()
    {
        foreach ($this->array['access_info'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['access_info']);
        }
    }

    /**
     * Test attribute "plan_info"
     */
    public function testPropertyPlanInfo()
    {
        foreach ($this->array['plan_info'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['plan_info']);
        }
    }

    /**
     * Test attribute "accountant_id"
     */
    public function testPropertyAccountantId()
    {
        TestCase::assertEquals($this->object['accountant_id'], $this->array['accountant_id']);
    }
}
