<?php
/**
 * CompanyInfoPlanInfoFunctionsTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * CompanyInfoPlanInfoFunctionsTest Class Doc Comment
 *
 * @category    Class
 * @description Access to functions for this company.
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class CompanyInfoPlanInfoFunctionsTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '{
            "document_attachments": true,
            "archive": true,
            "payment_notifications": true,
            "paypal": true,
            "receipts": true,
            "e_invoice": true,
            "genius": true,
            "stock": true,
            "smtp": true,
            "mail_tracking": true,
            "subaccounts": true,
            "tessera_sanitaria": true,
            "recurring": true,
            "sofort": false,
            "cerved": true,
            "ts_digital": true,
            "ts_pay": true,
            "ts_invoice_trading": true
          }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\CompanyInfoPlanInfoFunctions');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "CompanyInfoPlanInfoFunctions"
     */
    public function testCompanyInfoPlanInfoFunctions()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "archive"
     */
    public function testPropertyArchive()
    {
        TestCase::assertEquals($this->object['archive'], $this->array['archive']);
    }

    /**
     * Test attribute "cerved"
     */
    public function testPropertyCerved()
    {
        TestCase::assertEquals($this->object['cerved'], $this->array['cerved']);
    }

    /**
     * Test attribute "document_attachments"
     */
    public function testPropertyDocumentAttachments()
    {
        TestCase::assertEquals($this->object['document_attachments'], $this->array['document_attachments']);
    }

    /**
     * Test attribute "e_invoice"
     */
    public function testPropertyEInvoice()
    {
        TestCase::assertEquals($this->object['e_invoice'], $this->array['e_invoice']);
    }

    /**
     * Test attribute "genius"
     */
    public function testPropertyGenius()
    {
        TestCase::assertEquals($this->object['genius'], $this->array['genius']);
    }

    /**
     * Test attribute "mail_tracking"
     */
    public function testPropertyMailTracking()
    {
        TestCase::assertEquals($this->object['mail_tracking'], $this->array['mail_tracking']);
    }

    /**
     * Test attribute "payment_notifications"
     */
    public function testPropertyPaymentNotifications()
    {
        TestCase::assertEquals($this->object['payment_notifications'], $this->array['payment_notifications']);
    }

    /**
     * Test attribute "paypal"
     */
    public function testPropertyPaypal()
    {
        TestCase::assertEquals($this->object['paypal'], $this->array['paypal']);
    }

    /**
     * Test attribute "receipts"
     */
    public function testPropertyReceipts()
    {
        TestCase::assertEquals($this->object['receipts'], $this->array['receipts']);
    }

    /**
     * Test attribute "recurring"
     */
    public function testPropertyRecurring()
    {
        TestCase::assertEquals($this->object['recurring'], $this->array['recurring']);
    }

    /**
     * Test attribute "smtp"
     */
    public function testPropertySmtp()
    {
        TestCase::assertEquals($this->object['smtp'], $this->array['smtp']);
    }

    /**
     * Test attribute "sofort"
     */
    public function testPropertySofort()
    {
        TestCase::assertEquals($this->object['sofort'], $this->array['sofort']);
    }

    /**
     * Test attribute "stock"
     */
    public function testPropertyStock()
    {
        TestCase::assertEquals($this->object['stock'], $this->array['stock']);
    }

    /**
     * Test attribute "subaccounts"
     */
    public function testPropertySubaccounts()
    {
        TestCase::assertEquals($this->object['subaccounts'], $this->array['subaccounts']);
    }

    /**
     * Test attribute "tessera_sanitaria"
     */
    public function testPropertyTesseraSanitaria()
    {
        TestCase::assertEquals($this->object['tessera_sanitaria'], $this->array['tessera_sanitaria']);
    }

    /**
     * Test attribute "ts_digital"
     */
    public function testPropertyTsDigital()
    {
        TestCase::assertEquals($this->object['ts_digital'], $this->array['ts_digital']);
    }

    /**
     * Test attribute "ts_invoice_trading"
     */
    public function testPropertyTsInvoiceTrading()
    {
        TestCase::assertEquals($this->object['ts_invoice_trading'], $this->array['ts_invoice_trading']);
    }

    /**
     * Test attribute "ts_pay"
     */
    public function testPropertyTsPay()
    {
        TestCase::assertEquals($this->object['ts_pay'], $this->array['ts_pay']);
    }
}
