<?php
/**
 * CashbookEntryTest
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  For more information, please visit https://www.fattureincloud.it.
 *
 * The version of the OpenAPI document: 2.0.1
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace FattureInCloud\Test\Model;

use PHPUnit\Framework\TestCase;
use \FattureInCloud\ObjectSerializer;

/**
 * CashbookEntryTest Class Doc Comment
 *
 * @category    Class
 * @description CashbookEntry
 * @package     FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class CashbookEntryTest extends TestCase
{
    public $array = [];
    public $object;

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        $json = '
        {
            "id": "string",
            "date": "2019-08-24",
            "description": "string",
            "kind": "cashbook",
            "type": "in",
            "entity_name": "string",
            "document": {
              "id": 0,
              "type": "string",
              "path": "string"
            },
            "amount_out": 0,
            "payment_account_out": {
              "id": 0,
              "name": "Conto Banca Intesa",
              "type": "standard",
              "iban": "string",
              "sia": "string",
              "cuc": "string",
              "virtual": true
            },
            "amount_in": 0,
            "payment_account_in": {
              "id": 0,
              "name": "Conto Banca Intesa",
              "type": "standard",
              "iban": "string",
              "sia": "string",
              "cuc": "string",
              "virtual": true
            }
          }';

        $this->array = json_decode($json, true);

        $this->object = ObjectSerializer::deserialize($json, '\FattureInCloud\Model\CashbookEntry');
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "CashbookEntry"
     */
    public function testCashbookEntry()
    {
        foreach ($this->array as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object);
        }
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        TestCase::assertEquals($this->object['id'], $this->array['id']);
    }

    /**
     * Test attribute "date"
     */
    public function testPropertyDate()
    {
        $date = new \DateTime($this->array['date']);
        TestCase::assertEquals($this->object['date'], $date);
    }

    /**
     * Test attribute "description"
     */
    public function testPropertyDescription()
    {
        TestCase::assertEquals($this->object['description'], $this->array['description']);
    }

    /**
     * Test attribute "kind"
     */
    public function testPropertyKind()
    {
        TestCase::assertEquals($this->object['kind'], $this->array['kind']);
    }

    /**
     * Test attribute "type"
     */
    public function testPropertyType()
    {
        TestCase::assertEquals($this->object['type'], $this->array['type']);
    }

    /**
     * Test attribute "entity_name"
     */
    public function testPropertyEntityName()
    {
        TestCase::assertEquals($this->object['entity_name'], $this->array['entity_name']);
    }

    /**
     * Test attribute "document"
     */
    public function testPropertyDocument()
    {
        foreach ($this->array['document'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['document']);
        }
    }

    /**
     * Test attribute "amount_out"
     */
    public function testPropertyAmountOut()
    {
        TestCase::assertEquals($this->object['amount_out'], $this->array['amount_out']);
    }

    /**
     * Test attribute "payment_account_out"
     */
    public function testPropertyPaymentAccountOut()
    {
        foreach ($this->array['payment_account_out'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['payment_account_out']);
        }
    }

    /**
     * Test attribute "amount_in"
     */
    public function testPropertyAmountIn()
    {
        TestCase::assertEquals($this->object['amount_in'], $this->array['amount_in']);
    }

    /**
     * Test attribute "payment_account_in"
     */
    public function testPropertyPaymentAccountIn()
    {
        foreach ($this->array['payment_account_in'] as $key => $value) {
            Testcase::assertArrayHasKey($key, $this->object['payment_account_in']);
        }
    }
}
