<?php
/**
 * WebhooksApiTest
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.0.27
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * WebhooksApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class WebhooksApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for createWebhooksSubscription
     *
     * Create a Webhook Subscription.
     *
     */
    public function testCreateWebhooksSubscription()
    {
        $stream = '{"data":{"id":"SUB123","sink":"https://endpoint.test","verified":true,"types":["it.fattureincloud.webhooks.cashbook.create"]},"warnings":["error"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\WebhooksApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $create_webhooks_subscription_request = 'json';
        $result = $apiInstance->createWebhooksSubscription($company_id, $create_webhooks_subscription_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\CreateWebhooksSubscriptionResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for deleteWebhooksSubscription
     *
     * Delete Webhooks Subscription.
     *
     */
    public function testDeleteWebhooksSubscription()
    {
        TestCase::assertEquals(1, 1);
    }

    /**
     * Test case for getWebhooksSubscription
     *
     * Get Webhooks Subscription.
     *
     */
    public function testGetWebhooksSubscription()
    {
        $stream = '{"data":{"id":"SUB123","sink":"https://endpoint.test","verified":true,"types":["it.fattureincloud.webhooks.cashbook.create"]}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\WebhooksApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->getWebhooksSubscription($company_id, "SUB123");
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\GetWebhooksSubscriptionResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listWebhooksSubscriptions
     *
     * List Webhooks Subscriptions.
     *
     */
    public function testListWebhooksSubscriptions()
    {
        $stream = '{"data":[{"id":"SUB123","sink":"https://endpoint.test","verified":true,"types":["it.fattureincloud.webhooks.cashbook.create"]}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\WebhooksApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listWebhooksSubscriptions($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListWebhooksSubscriptionsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for modifyWebhooksSubscription
     *
     * Modify Webhooks Subscription.
     *
     */
    public function testModifyWebhooksSubscription()
    {
        $stream = '{"data":{"id":"SUB123","sink":"https://endpoint.test","verified":true,"types":["it.fattureincloud.webhooks.cashbook.create"]},"warnings":["error"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\WebhooksApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $modify_webhooks_subscription_request = 'json';
        $result = $apiInstance->modifyWebhooksSubscription($company_id, "SUB123", $modify_webhooks_subscription_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ModifyWebhooksSubscriptionResponse');

        TestCase::assertEquals($obj, $result);
    }
}
