<?php
/**
 * IssuedEInvoicesApiTest
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * IssuedEInvoicesApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class IssuedEInvoicesApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for sendEInvoice
     *
     * Send the e-invoice.
     *
     */
    public function testSendEInvoice()
    {
        $stream = '{"data":{"name":"CARICATO","date":"2021-08-23 10:38:03"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\IssuedEInvoicesApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $send_einvoice_request = 'json';
        $document_id = 12345;
        $result = $apiInstance->sendEInvoice($company_id, $send_einvoice_request, $document_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\SendEInvoiceResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for verifyEInvoiceXml
     *
     * Verify e-invoice xml.
     *
     */
    public function testVerifyEInvoiceXml()
    {
        $stream = '{"data":{"success":true}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\IssuedEInvoicesApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $document_id = 12345;
        $result = $apiInstance->verifyEInvoiceXml($company_id, $document_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\VerifyEInvoiceXmlResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for getEInvoiceXml
     *
     * Get e-invoice xml.
     *
     */
    public function testGetEInvoiceXml()
    {
        $stream = '<?xml version="1.0"?><p:FatturaElettronica xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:p="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v1.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" versione="FPA12" xsi:schemaLocation="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v1.2 http://www.fatturapa.gov.it/export/fatturazione/sdi/fatturapa/v1.2/Schema_del_file_xml_FatturaPA_versione_1.2.xsd"><FatturaElettronicaHeader><DatiTrasmissione><IdTrasmittente><IdPaese>IT</IdPaese><IdCodice>01234567890</IdCodice></IdTrasmittente><ProgressivoInvio>00001</ProgressivoInvio><FormatoTrasmissione>FPA12</FormatoTrasmissione><CodiceDestinatario>AAAAAA</CodiceDestinatario></DatiTrasmissione><CedentePrestatore><DatiAnagrafici><IdFiscaleIVA><IdPaese>IT</IdPaese><IdCodice>01234567890</IdCodice></IdFiscaleIVA><Anagrafica><Denominazione>ALPHA SRL</Denominazione></Anagrafica><RegimeFiscale>RF19</RegimeFiscale></DatiAnagrafici><Sede><Indirizzo>VIALE ROMA 543</Indirizzo><CAP>07100</CAP><Comune>SASSARI</Comune><Provincia>SS</Provincia><Nazione>IT</Nazione></Sede></CedentePrestatore><CessionarioCommittente><DatiAnagrafici><CodiceFiscale>09876543210</CodiceFiscale><Anagrafica><Denominazione>AMMINISTRAZIONE BETA</Denominazione></Anagrafica></DatiAnagrafici><Sede><Indirizzo>VIA TORINO 38-B</Indirizzo><CAP>00145</CAP><Comune>ROMA</Comune><Provincia>RM</Provincia><Nazione>IT</Nazione></Sede></CessionarioCommittente></FatturaElettronicaHeader><FatturaElettronicaBody><DatiGenerali><DatiGeneraliDocumento><TipoDocumento>TD01</TipoDocumento><Divisa>EUR</Divisa><Data>2017-01-18</Data><Numero>123</Numero><Causale>LA FATTURA FA RIFERIMENTO AD UNA OPERAZIONE AAAA BBBBBBBBBBBBBBBBBB CCC DDDDDDDDDDDDDDD E FFFFFFFFFFFFFFFFFFFF GGGGGGGGGG HHHHHHH II LLLLLLLLLLLLLLLLL MMM NNNNN OO PPPPPPPPPPP QQQQ RRRR SSSSSSSSSSSSSS</Causale><Causale>SEGUE DESCRIZIONE CAUSALE NEL CASO IN CUI NON SIANO STATI SUFFICIENTI 200 CARATTERI AAAAAAAAAAA BBBBBBBBBBBBBBBBB</Causale></DatiGeneraliDocumento><DatiOrdineAcquisto><RiferimentoNumeroLinea>1</RiferimentoNumeroLinea><IdDocumento>66685</IdDocumento><NumItem>1</NumItem><CodiceCUP>123abc</CodiceCUP><CodiceCIG>456def</CodiceCIG></DatiOrdineAcquisto><DatiContratto><RiferimentoNumeroLinea>1</RiferimentoNumeroLinea><IdDocumento>123</IdDocumento><Data>2016-09-01</Data><NumItem>5</NumItem><CodiceCUP>123abc</CodiceCUP><CodiceCIG>456def</CodiceCIG></DatiContratto><DatiConvenzione><RiferimentoNumeroLinea>1</RiferimentoNumeroLinea><IdDocumento>456</IdDocumento><NumItem>5</NumItem><CodiceCUP>123abc</CodiceCUP><CodiceCIG>456def</CodiceCIG></DatiConvenzione><DatiRicezione><RiferimentoNumeroLinea>1</RiferimentoNumeroLinea><IdDocumento>789</IdDocumento><NumItem>5</NumItem><CodiceCUP>123abc</CodiceCUP><CodiceCIG>456def</CodiceCIG></DatiRicezione><DatiTrasporto><DatiAnagraficiVettore><IdFiscaleIVA><IdPaese>IT</IdPaese><IdCodice>24681012141</IdCodice></IdFiscaleIVA><Anagrafica><Denominazione>Trasporto spa</Denominazione></Anagrafica></DatiAnagraficiVettore><DataOraConsegna>2017-01-10T16:46:12.000+02:00</DataOraConsegna></DatiTrasporto></DatiGenerali><DatiBeniServizi><DettaglioLinee><NumeroLinea>1</NumeroLinea><Descrizione>DESCRIZIONE DELLA FORNITURA</Descrizione><Quantita>5.00</Quantita><PrezzoUnitario>1.00</PrezzoUnitario><PrezzoTotale>5.00</PrezzoTotale><AliquotaIVA>22.00</AliquotaIVA></DettaglioLinee><DatiRiepilogo><AliquotaIVA>22.00</AliquotaIVA><ImponibileImporto>5.00</ImponibileImporto><Imposta>1.10</Imposta><EsigibilitaIVA>I</EsigibilitaIVA></DatiRiepilogo></DatiBeniServizi><DatiPagamento><CondizioniPagamento>TP01</CondizioniPagamento><DettaglioPagamento><ModalitaPagamento>MP01</ModalitaPagamento><DataScadenzaPagamento>2017-02-18</DataScadenzaPagamento><ImportoPagamento>6.10</ImportoPagamento></DettaglioPagamento></DatiPagamento></FatturaElettronicaBody></p:FatturaElettronica>';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'text/xml'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\IssuedEInvoicesApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $document_id = 12345;
        $result = $apiInstance->getEInvoiceXml($company_id, $document_id);

        TestCase::assertEquals($stream, $result);
    }
}
