<?php
/**
 * InfoApiTest
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * InfoApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class InfoApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for listArchiveCategories
     *
     * List Archive Categories.
     *
     */
    public function testListArchiveCategories()
    {
        $stream = '{"data":["Altri documenti","Conferme d\'ordine","Contratti","Dichiarazioni dei redditi","Documenti per detrazioni","Estratti conto bancari","Estratti conto carte di credito"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listArchiveCategories($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListArchiveCategoriesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listCities
     *
     * List Cities.
     *
     */
    public function testListCities()
    {
        $stream = '{"data":[{"postal_code":"89867","city":"Zungri","province":"VV"},{"postal_code":"83020","city":"Aiello del Sabato","province":"AV"},{"postal_code":"83011","city":"Altavilla Irpina","province":"AV"}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listCities();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListCitiesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listCostCenters
     *
     * List Cost Centers.
     *
     */
    public function testListCostCenters()
    {
        $stream = '{"data":["Negozio Bergamo","Negozio Milano"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listCostCenters($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListCostCentersResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listCountries
     *
     * List Countries.
     *
     */
    public function testListCountries()
    {
        $stream = '{"data":["Italia","Afghanistan","Albania","Algeria","Andorra","Angola","Anguilla","..."]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listCountries();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListCountriesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listDetailedCountries
     *
     * List Countries.
     *
     */
    public function testListDetailedCountries()
    {
        $stream = '{"data": [{"name": "Italia", "settings_name": "Italia", "iso": "IT", "fiscal_iso": "IT", "uic": "086"}, {"name": "Albania", "settings_name": "Albania", "iso": "AL", "fiscal_iso": "AL", "uic": "087"}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listDetailedCountries();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListDetailedCountriesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listCurrencies
     *
     * List Currencies.
     *
     */
    public function testListCurrencies()
    {
        $stream = '{"data":[{"id":"AED","symbol":"AED","html_symbol":"AED","exchange_rate":"4.09500"},{"id":"EUR","symbol":"\u20ac","html_symbol":"€","exchange_rate":"1.00000"}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listCurrencies();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListCurrenciesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listDeliveryNotesDefaultCausals
     *
     * List Delivery Notes Default Causals.
     *
     */
    public function testListDeliveryNotesDefaultCausals()
    {
        $stream = '{"data":["Vendita","Conto visione","Conto deposito","Conto vendita","Tentata vendita","Prestito d\'uso","Conto lavorazione","Omaggio","Riparazione","Reso per accredito","Reso per sostituzione"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listDeliveryNotesDefaultCausals();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListDeliveryNotesDefaultCausalsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listLanguages
     *
     * List Languages.
     *
     */
    public function testListLanguages()
    {
        $stream = '{"data":[{"code":"it","name":"Italiano"},{"code":"en","name":"Inglese"}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listLanguages();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListLanguagesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listPaymentAccounts
     *
     * List Payment Accounts.
     *
     */
    public function testListPaymentAccounts()
    {
        $stream = '{"data":[{"id":21,"name":"Indesa - Carta conto","type":"standard","iban":null,"sia":null,"virtual":false},{"id":109,"name":"Indesa","type":"bank","iban":"IT17A1234563200000003498936","sia":"IN234","virtual":false}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listPaymentAccounts($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListPaymentAccountsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listPaymentMethods
     *
     * List Payment Methods.
     *
     */
    public function testListPaymentMethods()
    {
        $stream = '{"data":[{"id":12345,"name":"Carta di credito","is_default":false,"default_payment_account":null},{"id":12346,"name":"Bonifico bancario","is_default":true,"default_payment_account":null}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listPaymentMethods($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListPaymentMethodsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listProductCategories
     *
     * List Product Categories.
     *
     */
    public function testListProductCategories()
    {
        $stream = '{"data":["Alimentari","Arredamento"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $context = 'products';
        $result = $apiInstance->listProductCategories($company_id, $context);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListProductCategoriesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listReceivedDocumentCategories
     *
     * List Received Document Categories.
     *
     */
    public function testListReceivedDocumentCategories()
    {
        $stream = '{"data":["Telefono e internet","Assicurazioni e quote","Auto ed altri veicoli","Computer e accessori","Server e hosting"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listReceivedDocumentCategories($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListReceivedDocumentCategoriesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listRevenueCenters
     *
     * List Revenue Centers.
     *
     */
    public function testListRevenueCenters()
    {
        $stream = '{"data":["Negozio Bergamo","Negozio Milano"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listRevenueCenters($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListRevenueCentersResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listTemplates
     *
     * List Templates.
     *
     */
    public function testListTemplates()
    {
        $stream = '{"data":[{"id":10,"name":"New Standard S1"},{"id":106,"name":"Minimalist"}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listTemplates();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListTemplatesResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listUnitsOfMeasure
     *
     * List Units of Measure.
     *
     */
    public function testListUnitsOfMeasure()
    {
        $stream = '{"data":["pezzi","kg","litri","ore","giorni","km","mesi"]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $result = $apiInstance->listUnitsOfMeasure();
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListUnitsOfMeasureResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listVatTypes
     *
     * List Vat Types.
     *
     */
    public function testListVatTypes()
    {
        $stream = '{"data":[{"id":0,"value":22,"description":"Non imponibile art. 123","notes":"IVA non imponibile ai sensi dell\'articolo 123, comma 2","e_invoice":"string","ei_type":2,"ei_description":"string","editable":true},{"id":1010,"value":0,"description":"NON IMPONIBILE IVA EX ART. 8 COMMA 1 LETT.A","notes":"","e_invoice":false,"ei_type":0,"ei_description":null,"is_disabled":false,"editable":true}]}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\InfoApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listVatTypes($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListVatTypesResponse');

        TestCase::assertEquals($obj, $result);
    }
}
