<?php
/**
 * CompaniesApiTest
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * CompaniesApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class CompaniesApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for getCompanyInfo
     *
     * Get Company Info.
     *
     */
    public function testGetCompanyInfo()
    {
        $stream = '{"data":{"id":12345,"name":"Studio Commercialista","email":"mario.rossi@example.com","type":"accountant","fic":true,"fic_plan_name":"premium_plus","fic_signup_date":"2013-11-01","fic_license_expire":"2030-12-31","use_fic":true,"fic_need_setup":false,"fic_license_type":"coupon_b","dic":true,"dic_plan_name":"trial","dic_signup_date":"2018-03-26","dic_license_expire":"2022-12-31","use_dic":true,"dic_license_type":null,"registration_service":"fic","can_use_coupon":false,"access_info":{"role":"master","through_accountant":false,"permissions":{"fic_situation":"read","fic_clients":"write","fic_suppliers":"write","fic_products":"write","fic_issued_documents":"detailed","fic_issued_documents_detailed":{"quotes":"write","proformas":"write","invoices":"write","receipts":"write","delivery_notes":"write","credit_notes":"write","orders":"write","work_reports":"write","supplier_orders":"write","self_invoices":"write"},"fic_received_documents":"write","fic_receipts":"write","fic_calendar":"write","fic_archive":"write","fic_taxes":"write","fic_stock":"write","fic_cashbook":"write","fic_settings":"write","fic_emails":"read","dic_employees":"none","dic_timesheet":"none","dic_settings":"none","fic_invoice_trading":"none","fic_export":"write","fic_import_clients_suppliers":"write","fic_import_products":"write","fic_import_issued_documents":"none","fic_import_bankstatements":"none","fic_recurring":"write","fic_riba":"write"}},"plan_info":{"limits":{"clients":5000,"suppliers":5000,"products":5000,"documents":3000},"functions":{"document_attachments":true,"archive":true,"payment_notifications":true,"paypal":true,"receipts":true,"e_invoice":true,"genius":true,"stock":true,"smtp":true,"mail_tracking":true,"subaccounts":true,"tessera_sanitaria":true,"recurring":true,"sofort":false,"cerved":true,"ts_digital":true,"ts_pay":true,"ts_invoice_trading":true},"functions_status":{"ts_digital":{"active":true},"ts_pay":{"active":true}}},"is_accountant":true,"accountant_id":12345,"fic_payment_subject":"client","dic_payment_subject":"client"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\CompaniesApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->getCompanyInfo($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\GetCompanyInfoResponse');

        TestCase::assertEquals($obj, $result);
    }
}
