<?php
/**
 * ClientsApiTest
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * ClientsApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ClientsApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for createClient
     *
     * Create Client.
     *
     */
    public function testCreateClient()
    {
        $stream = '{"data":{"id":16451,"code":"AE86","name":"Avv. Maria Rossi","type":"person","first_name":"Maria","last_name":"Rossi","contact_person":"","vat_number":"IT12345640962","tax_code":"BLTGNI5ABCDA794E","address_street":"Via Roma, 1","address_postal_code":"20900","address_city":"Milano","address_province":"MI","address_extra":"","country":"Italia","email":"maria.rossi@example.com","certified_email":"maria.rossi@pec.example.com","phone":"1234567890","fax":"","notes":"","created_at":"2021-04-29 08:53:07","updated_at":"2021-04-29 08:53:07","default_payment_terms":1,"default_payment_terms_type":"standard","bank_name":"Indesa","bank_iban":"IT40P123456781000000123456","bank_swift_code":"AK86PCT","shipping_address":"Corso Magellano 4","e_invoice":true,"ei_code":"111111","default_vat":{"id":54321,"value":45,"description":"","is_disabled":false},"default_payment_method":{"id":386092,"name":"Credit card"}}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ClientsApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $create_client_request = 'json';
        $result = $apiInstance->createClient($company_id, $create_client_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\CreateClientResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for deleteClient
     *
     * Delete Client.
     *
     */
    public function testDeleteClient()
    {
        TestCase::assertEquals(1, 1);
    }

    /**
     * Test case for getClient
     *
     * Get Client.
     *
     */
    public function testGetClient()
    {
        $stream = '{"data":{"id":16451,"code":"GB01","name":"Avv. Gino Belotti","type":"person","first_name":"","last_name":"","contact_person":"","vat_number":"IT05548040962","tax_code":"BLTGNI54R25A794E","address_street":"Via del froschio, 3","address_postal_code":"20900","address_city":"Monza","address_province":"MB","address_extra":"","country":"Italia","email":"","certified_email":"gigino54@pec.example.com","phone":"","fax":"","notes":"","created_at":null,"updated_at":"2021-04-29 08:53:07","default_payment_terms":1,"default_payment_terms_type":"standard","bank_name":"","bank_iban":"IT40S0542811101000000123456","bank_swift_code":"","shipping_address":"Via le mani dal Naso 2","e_invoice":true,"ei_code":"","default_vat":null,"default_payment_method":{"id":386692,"name":"Teeest 2"}}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ClientsApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $client_id = 16451;
        $result = $apiInstance->getClient($company_id, $client_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\GetClientResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listClients
     *
     * List Clients.
     *
     */
    public function testListClients()
    {
        $stream = '{"current_page":1,"data":[{"id":16451,"code":"AE86","name":"Avv. Maria Rossi","type":"person","first_name":"Maria","last_name":"Rossi","contact_person":"","vat_number":"IT12345640962","tax_code":"BLTGNI5ABCDA794E","address_street":"Via Roma, 1","address_postal_code":"20900","address_city":"Milano","address_province":"MI","address_extra":"","country":"Italia","email":"maria.rossi@example.com","certified_email":"maria.rossi@pec.example.com","phone":"1234567890","fax":"","notes":"","created_at":"2021-04-29 08:53:07","updated_at":"2021-04-29 08:53:07","default_payment_terms":1,"default_payment_terms_type":"standard","bank_name":"Indesa","bank_iban":"IT40P123456781000000123456","bank_swift_code":"AK86PCT","shipping_address":"Corso Magellano 4","e_invoice":true,"ei_code":"111111","default_vat":{"id":54321,"value":45,"description":"","is_disabled":false},"default_payment_method":{"id":386092,"name":"Credit card"}},{"id":25330696,"code":"PD00","name":"Mario Rossi","type":"person","first_name":"Mario","last_name":"Rossi","contact_person":"","vat_number":"IT1234567890","tax_code":"ABCDEF12G34H567I","address_street":"Via largo augusto 123","address_postal_code":"21012","address_city":"Bergamo","address_province":"BG","address_extra":"","country":"Italia","email":"info@mariorossi.it","certified_email":"info@pec.mariorossi.it","phone":"012345678","fax":"012345678","notes":"","created_at":"2021-04-29 08:53:07","default_payment_terms":0,"default_payment_terms_type":"standard","bank_name":"Monte dei Pascoli","bank_iban":"IT00P123456781000000123456","bank_swift_code":"APL86PCT","shipping_address":"Via Miilano 4","e_invoice":false,"ei_code":"7654321","default_vat":{"id":66,"value":22,"description":"","is_disabled":false},"default_payment_method":null}],"first_page_url":"page=1","from":1,"last_page":2,"last_page_url":"page=2","next_page_url":"page=2","path":"entities\/clients","per_page":5,"prev_page_url":null,"to":50,"total":8}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ClientsApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listClients($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListClientsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for modifyClient
     *
     * Modify Client.
     *
     */
    public function testModifyClient()
    {
        $stream = '{"data":{"id":16451,"code":"GB01","name":"Avv. Gino Belotti","type":"person","first_name":"","last_name":"","contact_person":"","vat_number":"IT05548040962","tax_code":"BLTGNI54R25A794E","address_street":"Via del froschio, 3","address_postal_code":"20900","address_city":"Monza","address_province":"MB","address_extra":"","country":"Italia","email":"","certified_email":"gigino54@pec.example.com","phone":"","fax":"","notes":"","created_at":null,"updated_at":"2021-04-29 08:53:07","default_payment_terms":1,"default_payment_terms_type":"standard","bank_name":"","bank_iban":"IT40S0542811101000000123456","bank_swift_code":"","shipping_address":"Via le mani dal Naso 2","e_invoice":true,"ei_code":"","default_vat":null,"default_payment_method":{"id":386692,"name":"Teeest 2"}}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ClientsApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $client_id = 16451;
        $modify_client_request = 'json';
        $result = $apiInstance->modifyClient($company_id, $client_id, $modify_client_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ModifyClientResponse');

        TestCase::assertEquals($obj, $result);
    }
}
