<?php
/**
 * ArchiveApiTest
 * PHP version 7.3
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * ## Request informations In every request description you will be able to find some additional informations about context, permissions and supported functionality:  | Parameter | Description | |-----------|-------------| | 👥 Context | Indicate the subject of the request. Can be `company`, `user` or `accountant`.  | | 🔒 Required scope | If present, indicates the required scope to fulfill the request. | | 🔍 Filtering | If present, indicates which fields support the filtering feature. | | ↕️ Sorting | If present, indicates which fields support the sorting feature. | | 📄 Paginated results | If present, indicate that the results are paginated. | | 🎩 Customized responses supported | If present, indicate that you can use `field` or `fieldset` to customize the response body. |  For example the request `GET /entities/{entityRole}` have tis informations: \\ 👥 Company context \\ 🔒 Required scope: `entity.clients:r` or `entity.suppliers:r` (depending on `entityRole`) \\ 🔍 Filtering: `id`, `name` \\ ↕️ Sorting: `id`, `name` \\ 📄 Paginated results \\ 🎩 Customized responses supported  Keep in mind that if you are making **company realted requests**, you will need to specify the company id in the requests: ``` GET /c/{company_id}/issued_documents ```
 *
 * The version of the OpenAPI document: 2.0.6
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace FattureInCloud\Test\Api;

use \FattureInCloud\Configuration;
use \FattureInCloud\ApiException;
use \FattureInCloud\ObjectSerializer;
use PHPUnit\Framework\TestCase;
use \GuzzleHttp\Client;
use \GuzzleHttp\Handler\MockHandler;
use \GuzzleHttp\HandlerStack;
use \GuzzleHttp\Psr7\Response;
use \GuzzleHttp\Psr7\Request;
use \GuzzleHttp\Exception\RequestException;

/**
 * ArchiveApiTest Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */
class ArchiveApiTest extends TestCase
{
    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for createArchiveDocument
     *
     * Create Archive Document.
     *
     */
    public function testCreateArchiveDocument()
    {
        $stream = '{"data":{"date":"2021-08-20","category":"Altri documenti","description":"spesa 1","attachment_token":"ibfjdbf94ey9w94g3w894qbasrga"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ArchiveApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $create_archive_document_request = 'json';
        $result = $apiInstance->createArchiveDocument($company_id, $create_archive_document_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\CreateArchiveDocumentResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for deleteArchiveDocument
     *
     * Delete Archive Document.
     *
     */
    public function testDeleteArchiveDocument()
    {
        TestCase::assertEquals(1, 1);
    }

    /**
     * Test case for getArchiveDocument
     *
     * Get Archive Document.
     *
     */
    public function testGetArchiveDocument()
    {
        $stream = '{"data":{"id":12345,"date":"2021-08-20","category":"Altri documenti","description":"spesa 2","attachment_url":"spesa2.pdf"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ArchiveApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $archive_document_id = 12345;
        $result = $apiInstance->getArchiveDocument($company_id, $archive_document_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\GetArchiveDocumentResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for listArchiveDocuments
     *
     * List Archive Documents.
     *
     */
    public function testListArchiveDocuments()
    {
        $stream = '{"current_page":1,"data":[{"id":12345,"date":"2021-08-20","category":"Altri documenti","description":"spesa 2","attachment_url":"spesa2.pdf"},{"id":12346,"date":"2021-08-19","category":"Altri documenti","description":"spesa 1","attachment_url":"spesa1.pdf"}],"first_page_url":"page=1","from":1,"last_page":1,"last_page_url":"page=1","next_page_url":null,"path":"\/archive","per_page":50,"prev_page_url":null,"to":2,"total":2}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ArchiveApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $result = $apiInstance->listArchiveDocuments($company_id);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ListArchiveDocumentsResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for modifyArchiveDocument
     *
     * Modify Archive Document.
     *
     */
    public function testModifyArchiveDocument()
    {
        $stream = '{"data":{"id":12345,"date":"2021-08-20","category":"Altri documenti","description":"spesa 2","attachment_url":"spesa2.pdf"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ArchiveApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $archive_document_id = 12345;
        $modify_archive_document_request = 'json';
        $result = $apiInstance->modifyArchiveDocument($company_id, $archive_document_id, $modify_archive_document_request);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\ModifyArchiveDocumentResponse');

        TestCase::assertEquals($obj, $result);
    }

    /**
     * Test case for uploadArchiveDocumentAttachment
     *
     * Upload Archive Document Attachment.
     *
     */
    public function testUploadArchiveDocumentAttachment()
    {
        $stream = '{"data":{"attachment_token":"YmMyNWYxYzIwMTU3N2Y4ZGE3ZjZiMzg5OWY0ODNkZDQveXl5LmRvYw"}}';
        $mock = new MockHandler([new Response(
            200,
            ['Content-Type' => 'application/json'],
            $stream
        )]);

        $handler = HandlerStack::create($mock);
        $apiInstance = new \FattureInCloud\Api\ArchiveApi(
            new \GuzzleHttp\Client(['handler' => $handler])
        );
        $company_id = 2;
        $upload_archive_document_attachment = 'json';
        $result = $apiInstance->uploadArchiveDocumentAttachment($company_id, $upload_archive_document_attachment);
        $obj = ObjectSerializer::deserialize($stream, '\FattureInCloud\Model\UploadArchiveAttachmentResponse');

        TestCase::assertEquals($obj, $result);
    }
}
