<?php
/**
 * ReceivedDocument
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace FattureInCloud\Model;

use \ArrayAccess;
use \FattureInCloud\ObjectSerializer;

/**
 * ReceivedDocument Class Doc Comment
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 * @implements \ArrayAccess<string, mixed>
 */
class ReceivedDocument implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReceivedDocument';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'type' => '\FattureInCloud\Model\ReceivedDocumentType',
        'entity' => '\FattureInCloud\Model\Entity',
        'date' => '\DateTime',
        'category' => 'string',
        'description' => 'string',
        'amount_net' => 'float',
        'amount_vat' => 'float',
        'amount_withholding_tax' => 'float',
        'amount_other_withholding_tax' => 'float',
        'amount_gross' => 'float',
        'amortization' => 'float',
        'rc_center' => 'string',
        'invoice_number' => 'string',
        'is_marked' => 'bool',
        'is_detailed' => 'bool',
        'e_invoice' => 'bool',
        'next_due_date' => '\DateTime',
        'currency' => '\FattureInCloud\Model\Currency',
        'tax_deductibility' => 'float',
        'vat_deductibility' => 'float',
        'items_list' => '\FattureInCloud\Model\ReceivedDocumentItemsListItem[]',
        'payments_list' => '\FattureInCloud\Model\ReceivedDocumentPaymentsListItem[]',
        'attachment_url' => 'string',
        'attachment_preview_url' => 'string',
        'auto_calculate' => 'bool',
        'attachment_token' => 'string',
        'locked' => 'bool',
        'created_at' => 'string',
        'updated_at' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'type' => null,
        'entity' => null,
        'date' => 'date',
        'category' => null,
        'description' => null,
        'amount_net' => null,
        'amount_vat' => null,
        'amount_withholding_tax' => null,
        'amount_other_withholding_tax' => null,
        'amount_gross' => null,
        'amortization' => null,
        'rc_center' => null,
        'invoice_number' => null,
        'is_marked' => null,
        'is_detailed' => null,
        'e_invoice' => null,
        'next_due_date' => 'date',
        'currency' => null,
        'tax_deductibility' => null,
        'vat_deductibility' => null,
        'items_list' => null,
        'payments_list' => null,
        'attachment_url' => null,
        'attachment_preview_url' => null,
        'auto_calculate' => null,
        'attachment_token' => null,
        'locked' => null,
        'created_at' => null,
        'updated_at' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'id' => true,
        'type' => false,
        'entity' => false,
        'date' => true,
        'category' => true,
        'description' => true,
        'amount_net' => true,
        'amount_vat' => true,
        'amount_withholding_tax' => true,
        'amount_other_withholding_tax' => true,
        'amount_gross' => true,
        'amortization' => true,
        'rc_center' => true,
        'invoice_number' => true,
        'is_marked' => true,
        'is_detailed' => true,
        'e_invoice' => true,
        'next_due_date' => true,
        'currency' => false,
        'tax_deductibility' => true,
        'vat_deductibility' => true,
        'items_list' => true,
        'payments_list' => true,
        'attachment_url' => true,
        'attachment_preview_url' => true,
        'auto_calculate' => true,
        'attachment_token' => true,
        'locked' => true,
        'created_at' => true,
        'updated_at' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull($openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'type' => 'type',
        'entity' => 'entity',
        'date' => 'date',
        'category' => 'category',
        'description' => 'description',
        'amount_net' => 'amount_net',
        'amount_vat' => 'amount_vat',
        'amount_withholding_tax' => 'amount_withholding_tax',
        'amount_other_withholding_tax' => 'amount_other_withholding_tax',
        'amount_gross' => 'amount_gross',
        'amortization' => 'amortization',
        'rc_center' => 'rc_center',
        'invoice_number' => 'invoice_number',
        'is_marked' => 'is_marked',
        'is_detailed' => 'is_detailed',
        'e_invoice' => 'e_invoice',
        'next_due_date' => 'next_due_date',
        'currency' => 'currency',
        'tax_deductibility' => 'tax_deductibility',
        'vat_deductibility' => 'vat_deductibility',
        'items_list' => 'items_list',
        'payments_list' => 'payments_list',
        'attachment_url' => 'attachment_url',
        'attachment_preview_url' => 'attachment_preview_url',
        'auto_calculate' => 'auto_calculate',
        'attachment_token' => 'attachment_token',
        'locked' => 'locked',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'type' => 'setType',
        'entity' => 'setEntity',
        'date' => 'setDate',
        'category' => 'setCategory',
        'description' => 'setDescription',
        'amount_net' => 'setAmountNet',
        'amount_vat' => 'setAmountVat',
        'amount_withholding_tax' => 'setAmountWithholdingTax',
        'amount_other_withholding_tax' => 'setAmountOtherWithholdingTax',
        'amount_gross' => 'setAmountGross',
        'amortization' => 'setAmortization',
        'rc_center' => 'setRcCenter',
        'invoice_number' => 'setInvoiceNumber',
        'is_marked' => 'setIsMarked',
        'is_detailed' => 'setIsDetailed',
        'e_invoice' => 'setEInvoice',
        'next_due_date' => 'setNextDueDate',
        'currency' => 'setCurrency',
        'tax_deductibility' => 'setTaxDeductibility',
        'vat_deductibility' => 'setVatDeductibility',
        'items_list' => 'setItemsList',
        'payments_list' => 'setPaymentsList',
        'attachment_url' => 'setAttachmentUrl',
        'attachment_preview_url' => 'setAttachmentPreviewUrl',
        'auto_calculate' => 'setAutoCalculate',
        'attachment_token' => 'setAttachmentToken',
        'locked' => 'setLocked',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'type' => 'getType',
        'entity' => 'getEntity',
        'date' => 'getDate',
        'category' => 'getCategory',
        'description' => 'getDescription',
        'amount_net' => 'getAmountNet',
        'amount_vat' => 'getAmountVat',
        'amount_withholding_tax' => 'getAmountWithholdingTax',
        'amount_other_withholding_tax' => 'getAmountOtherWithholdingTax',
        'amount_gross' => 'getAmountGross',
        'amortization' => 'getAmortization',
        'rc_center' => 'getRcCenter',
        'invoice_number' => 'getInvoiceNumber',
        'is_marked' => 'getIsMarked',
        'is_detailed' => 'getIsDetailed',
        'e_invoice' => 'getEInvoice',
        'next_due_date' => 'getNextDueDate',
        'currency' => 'getCurrency',
        'tax_deductibility' => 'getTaxDeductibility',
        'vat_deductibility' => 'getVatDeductibility',
        'items_list' => 'getItemsList',
        'payments_list' => 'getPaymentsList',
        'attachment_url' => 'getAttachmentUrl',
        'attachment_preview_url' => 'getAttachmentPreviewUrl',
        'auto_calculate' => 'getAutoCalculate',
        'attachment_token' => 'getAttachmentToken',
        'locked' => 'getLocked',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct($data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('amount_net', $data ?? [], null);
        $this->setIfExists('amount_vat', $data ?? [], null);
        $this->setIfExists('amount_withholding_tax', $data ?? [], null);
        $this->setIfExists('amount_other_withholding_tax', $data ?? [], null);
        $this->setIfExists('amount_gross', $data ?? [], null);
        $this->setIfExists('amortization', $data ?? [], null);
        $this->setIfExists('rc_center', $data ?? [], null);
        $this->setIfExists('invoice_number', $data ?? [], null);
        $this->setIfExists('is_marked', $data ?? [], null);
        $this->setIfExists('is_detailed', $data ?? [], null);
        $this->setIfExists('e_invoice', $data ?? [], null);
        $this->setIfExists('next_due_date', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('tax_deductibility', $data ?? [], null);
        $this->setIfExists('vat_deductibility', $data ?? [], null);
        $this->setIfExists('items_list', $data ?? [], null);
        $this->setIfExists('payments_list', $data ?? [], null);
        $this->setIfExists('attachment_url', $data ?? [], null);
        $this->setIfExists('attachment_preview_url', $data ?? [], null);
        $this->setIfExists('auto_calculate', $data ?? [], null);
        $this->setIfExists('attachment_token', $data ?? [], null);
        $this->setIfExists('locked', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Received document id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            array_push($this->openAPINullablesSetToNull, 'id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('id', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type, the accepted values are available in \FattureInCloud\Model\ReceivedDocumentType
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return \FattureInCloud\Model\Entity|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param \FattureInCloud\Model\Entity|null $entity entity
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date Received document date [defaults to today's date]
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            array_push($this->openAPINullablesSetToNull, 'date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category Received document category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            array_push($this->openAPINullablesSetToNull, 'category');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('category', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Received document description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets amount_net
     *
     * @return float|null
     */
    public function getAmountNet()
    {
        return $this->container['amount_net'];
    }

    /**
     * Sets amount_net
     *
     * @param float|null $amount_net Received document total net amount
     *
     * @return self
     */
    public function setAmountNet($amount_net)
    {
        if (is_null($amount_net)) {
            array_push($this->openAPINullablesSetToNull, 'amount_net');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_net', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_net'] = $amount_net;

        return $this;
    }

    /**
     * Gets amount_vat
     *
     * @return float|null
     */
    public function getAmountVat()
    {
        return $this->container['amount_vat'];
    }

    /**
     * Sets amount_vat
     *
     * @param float|null $amount_vat Received document total vat amount
     *
     * @return self
     */
    public function setAmountVat($amount_vat)
    {
        if (is_null($amount_vat)) {
            array_push($this->openAPINullablesSetToNull, 'amount_vat');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_vat', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_vat'] = $amount_vat;

        return $this;
    }

    /**
     * Gets amount_withholding_tax
     *
     * @return float|null
     */
    public function getAmountWithholdingTax()
    {
        return $this->container['amount_withholding_tax'];
    }

    /**
     * Sets amount_withholding_tax
     *
     * @param float|null $amount_withholding_tax Received document withholding tax amount
     *
     * @return self
     */
    public function setAmountWithholdingTax($amount_withholding_tax)
    {
        if (is_null($amount_withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'amount_withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_withholding_tax'] = $amount_withholding_tax;

        return $this;
    }

    /**
     * Gets amount_other_withholding_tax
     *
     * @return float|null
     */
    public function getAmountOtherWithholdingTax()
    {
        return $this->container['amount_other_withholding_tax'];
    }

    /**
     * Sets amount_other_withholding_tax
     *
     * @param float|null $amount_other_withholding_tax Received document other withholding tax amount
     *
     * @return self
     */
    public function setAmountOtherWithholdingTax($amount_other_withholding_tax)
    {
        if (is_null($amount_other_withholding_tax)) {
            array_push($this->openAPINullablesSetToNull, 'amount_other_withholding_tax');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_other_withholding_tax', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_other_withholding_tax'] = $amount_other_withholding_tax;

        return $this;
    }

    /**
     * Gets amount_gross
     *
     * @return float|null
     */
    public function getAmountGross()
    {
        return $this->container['amount_gross'];
    }

    /**
     * Sets amount_gross
     *
     * @param float|null $amount_gross [Read Only] Received document total gross amount
     *
     * @return self
     */
    public function setAmountGross($amount_gross)
    {
        if (is_null($amount_gross)) {
            array_push($this->openAPINullablesSetToNull, 'amount_gross');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amount_gross', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amount_gross'] = $amount_gross;

        return $this;
    }

    /**
     * Gets amortization
     *
     * @return float|null
     */
    public function getAmortization()
    {
        return $this->container['amortization'];
    }

    /**
     * Sets amortization
     *
     * @param float|null $amortization Received document amortization value
     *
     * @return self
     */
    public function setAmortization($amortization)
    {
        if (is_null($amortization)) {
            array_push($this->openAPINullablesSetToNull, 'amortization');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('amortization', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['amortization'] = $amortization;

        return $this;
    }

    /**
     * Gets rc_center
     *
     * @return string|null
     */
    public function getRcCenter()
    {
        return $this->container['rc_center'];
    }

    /**
     * Sets rc_center
     *
     * @param string|null $rc_center Received document revenue center
     *
     * @return self
     */
    public function setRcCenter($rc_center)
    {
        if (is_null($rc_center)) {
            array_push($this->openAPINullablesSetToNull, 'rc_center');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('rc_center', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['rc_center'] = $rc_center;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number Received document invoice number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (is_null($invoice_number)) {
            array_push($this->openAPINullablesSetToNull, 'invoice_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('invoice_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets is_marked
     *
     * @return bool|null
     */
    public function getIsMarked()
    {
        return $this->container['is_marked'];
    }

    /**
     * Sets is_marked
     *
     * @param bool|null $is_marked Received document is marked
     *
     * @return self
     */
    public function setIsMarked($is_marked)
    {
        if (is_null($is_marked)) {
            array_push($this->openAPINullablesSetToNull, 'is_marked');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('is_marked', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['is_marked'] = $is_marked;

        return $this;
    }

    /**
     * Gets is_detailed
     *
     * @return bool|null
     */
    public function getIsDetailed()
    {
        return $this->container['is_detailed'];
    }

    /**
     * Sets is_detailed
     *
     * @param bool|null $is_detailed Received document has items
     *
     * @return self
     */
    public function setIsDetailed($is_detailed)
    {
        if (is_null($is_detailed)) {
            array_push($this->openAPINullablesSetToNull, 'is_detailed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('is_detailed', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['is_detailed'] = $is_detailed;

        return $this;
    }

    /**
     * Gets e_invoice
     *
     * @return bool|null
     */
    public function getEInvoice()
    {
        return $this->container['e_invoice'];
    }

    /**
     * Sets e_invoice
     *
     * @param bool|null $e_invoice [Read Only] Received document is an e-invoice
     *
     * @return self
     */
    public function setEInvoice($e_invoice)
    {
        if (is_null($e_invoice)) {
            array_push($this->openAPINullablesSetToNull, 'e_invoice');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('e_invoice', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['e_invoice'] = $e_invoice;

        return $this;
    }

    /**
     * Gets next_due_date
     *
     * @return \DateTime|null
     */
    public function getNextDueDate()
    {
        return $this->container['next_due_date'];
    }

    /**
     * Sets next_due_date
     *
     * @param \DateTime|null $next_due_date [Read Only] Received document date of the next not paid payment
     *
     * @return self
     */
    public function setNextDueDate($next_due_date)
    {
        if (is_null($next_due_date)) {
            array_push($this->openAPINullablesSetToNull, 'next_due_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('next_due_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['next_due_date'] = $next_due_date;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \FattureInCloud\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \FattureInCloud\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets tax_deductibility
     *
     * @return float|null
     */
    public function getTaxDeductibility()
    {
        return $this->container['tax_deductibility'];
    }

    /**
     * Sets tax_deductibility
     *
     * @param float|null $tax_deductibility Received document tax deducibility percentage
     *
     * @return self
     */
    public function setTaxDeductibility($tax_deductibility)
    {
        if (is_null($tax_deductibility)) {
            array_push($this->openAPINullablesSetToNull, 'tax_deductibility');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_deductibility', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_deductibility'] = $tax_deductibility;

        return $this;
    }

    /**
     * Gets vat_deductibility
     *
     * @return float|null
     */
    public function getVatDeductibility()
    {
        return $this->container['vat_deductibility'];
    }

    /**
     * Sets vat_deductibility
     *
     * @param float|null $vat_deductibility Received document vat deducibility percentage
     *
     * @return self
     */
    public function setVatDeductibility($vat_deductibility)
    {
        if (is_null($vat_deductibility)) {
            array_push($this->openAPINullablesSetToNull, 'vat_deductibility');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('vat_deductibility', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['vat_deductibility'] = $vat_deductibility;

        return $this;
    }

    /**
     * Gets items_list
     *
     * @return \FattureInCloud\Model\ReceivedDocumentItemsListItem[]|null
     */
    public function getItemsList()
    {
        return $this->container['items_list'];
    }

    /**
     * Sets items_list
     *
     * @param \FattureInCloud\Model\ReceivedDocumentItemsListItem[]|null $items_list items_list
     *
     * @return self
     */
    public function setItemsList($items_list)
    {
        if (is_null($items_list)) {
            array_push($this->openAPINullablesSetToNull, 'items_list');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('items_list', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['items_list'] = $items_list;

        return $this;
    }

    /**
     * Gets payments_list
     *
     * @return \FattureInCloud\Model\ReceivedDocumentPaymentsListItem[]|null
     */
    public function getPaymentsList()
    {
        return $this->container['payments_list'];
    }

    /**
     * Sets payments_list
     *
     * @param \FattureInCloud\Model\ReceivedDocumentPaymentsListItem[]|null $payments_list payments_list
     *
     * @return self
     */
    public function setPaymentsList($payments_list)
    {
        if (is_null($payments_list)) {
            array_push($this->openAPINullablesSetToNull, 'payments_list');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('payments_list', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['payments_list'] = $payments_list;

        return $this;
    }

    /**
     * Gets attachment_url
     *
     * @return string|null
     */
    public function getAttachmentUrl()
    {
        return $this->container['attachment_url'];
    }

    /**
     * Sets attachment_url
     *
     * @param string|null $attachment_url [Temporary] [Read Only] Received document url of the attached file
     *
     * @return self
     */
    public function setAttachmentUrl($attachment_url)
    {
        if (is_null($attachment_url)) {
            array_push($this->openAPINullablesSetToNull, 'attachment_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attachment_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attachment_url'] = $attachment_url;

        return $this;
    }

    /**
     * Gets attachment_preview_url
     *
     * @return string|null
     */
    public function getAttachmentPreviewUrl()
    {
        return $this->container['attachment_preview_url'];
    }

    /**
     * Sets attachment_preview_url
     *
     * @param string|null $attachment_preview_url [Temporary] [Read Only] Received document url of the attachment preview
     *
     * @return self
     */
    public function setAttachmentPreviewUrl($attachment_preview_url)
    {
        if (is_null($attachment_preview_url)) {
            array_push($this->openAPINullablesSetToNull, 'attachment_preview_url');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attachment_preview_url', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attachment_preview_url'] = $attachment_preview_url;

        return $this;
    }

    /**
     * Gets auto_calculate
     *
     * @return bool|null
     */
    public function getAutoCalculate()
    {
        return $this->container['auto_calculate'];
    }

    /**
     * Sets auto_calculate
     *
     * @param bool|null $auto_calculate Received document total items amount and total payments amount can differ if this field is set to false
     *
     * @return self
     */
    public function setAutoCalculate($auto_calculate)
    {
        if (is_null($auto_calculate)) {
            array_push($this->openAPINullablesSetToNull, 'auto_calculate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('auto_calculate', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['auto_calculate'] = $auto_calculate;

        return $this;
    }

    /**
     * Gets attachment_token
     *
     * @return string|null
     */
    public function getAttachmentToken()
    {
        return $this->container['attachment_token'];
    }

    /**
     * Sets attachment_token
     *
     * @param string|null $attachment_token [Write Only] Received document attachment token returned by POST /received_documents/attachment
     *
     * @return self
     */
    public function setAttachmentToken($attachment_token)
    {
        if (is_null($attachment_token)) {
            array_push($this->openAPINullablesSetToNull, 'attachment_token');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('attachment_token', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['attachment_token'] = $attachment_token;

        return $this;
    }

    /**
     * Gets locked
     *
     * @return bool|null
     */
    public function getLocked()
    {
        return $this->container['locked'];
    }

    /**
     * Sets locked
     *
     * @param bool|null $locked Received Document can't be edited
     *
     * @return self
     */
    public function setLocked($locked)
    {
        if (is_null($locked)) {
            array_push($this->openAPINullablesSetToNull, 'locked');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('locked', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['locked'] = $locked;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Received document creation date
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            array_push($this->openAPINullablesSetToNull, 'created_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('created_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Received document last update date
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            array_push($this->openAPINullablesSetToNull, 'updated_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('updated_at', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link     https://fattureincloud.it
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


