<?php
/**
 * IssuedDocumentEiData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 */

/**
 * Fatture in Cloud API v2 - API Reference
 *
 * Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.
 *
 * The version of the OpenAPI document: 2.1.3
 * Contact: info@fattureincloud.it
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.9.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace FattureInCloud\Model;

use \ArrayAccess;
use \FattureInCloud\ObjectSerializer;

/**
 * IssuedDocumentEiData Class Doc Comment
 *
 * @category Class
 * @description Issued document e-invoice data [Only if e_invoice&#x3D;true]
 * @package  FattureInCloud
 * @author   Fatture In Cloud API team
 * @link     https://fattureincloud.it
 * @implements \ArrayAccess<string, mixed>
 */
class IssuedDocumentEiData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'IssuedDocument_ei_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'vat_kind' => '\FattureInCloud\Model\VatKind',
        'original_document_type' => '\FattureInCloud\Model\OriginalDocumentType',
        'od_number' => 'string',
        'od_date' => '\DateTime',
        'cig' => 'string',
        'cup' => 'string',
        'payment_method' => 'string',
        'bank_name' => 'string',
        'bank_iban' => 'string',
        'bank_beneficiary' => 'string',
        'invoice_number' => 'string',
        'invoice_date' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'vat_kind' => null,
        'original_document_type' => null,
        'od_number' => null,
        'od_date' => 'date',
        'cig' => null,
        'cup' => null,
        'payment_method' => null,
        'bank_name' => null,
        'bank_iban' => null,
        'bank_beneficiary' => null,
        'invoice_number' => null,
        'invoice_date' => 'date'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'vat_kind' => true,
        'original_document_type' => true,
        'od_number' => true,
        'od_date' => true,
        'cig' => true,
        'cup' => true,
        'payment_method' => true,
        'bank_name' => true,
        'bank_iban' => true,
        'bank_beneficiary' => true,
        'invoice_number' => true,
        'invoice_date' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull($openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'vat_kind' => 'vat_kind',
        'original_document_type' => 'original_document_type',
        'od_number' => 'od_number',
        'od_date' => 'od_date',
        'cig' => 'cig',
        'cup' => 'cup',
        'payment_method' => 'payment_method',
        'bank_name' => 'bank_name',
        'bank_iban' => 'bank_iban',
        'bank_beneficiary' => 'bank_beneficiary',
        'invoice_number' => 'invoice_number',
        'invoice_date' => 'invoice_date'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'vat_kind' => 'setVatKind',
        'original_document_type' => 'setOriginalDocumentType',
        'od_number' => 'setOdNumber',
        'od_date' => 'setOdDate',
        'cig' => 'setCig',
        'cup' => 'setCup',
        'payment_method' => 'setPaymentMethod',
        'bank_name' => 'setBankName',
        'bank_iban' => 'setBankIban',
        'bank_beneficiary' => 'setBankBeneficiary',
        'invoice_number' => 'setInvoiceNumber',
        'invoice_date' => 'setInvoiceDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'vat_kind' => 'getVatKind',
        'original_document_type' => 'getOriginalDocumentType',
        'od_number' => 'getOdNumber',
        'od_date' => 'getOdDate',
        'cig' => 'getCig',
        'cup' => 'getCup',
        'payment_method' => 'getPaymentMethod',
        'bank_name' => 'getBankName',
        'bank_iban' => 'getBankIban',
        'bank_beneficiary' => 'getBankBeneficiary',
        'invoice_number' => 'getInvoiceNumber',
        'invoice_date' => 'getInvoiceDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct($data = null)
    {
        $this->setIfExists('vat_kind', $data ?? [], null);
        $this->setIfExists('original_document_type', $data ?? [], null);
        $this->setIfExists('od_number', $data ?? [], null);
        $this->setIfExists('od_date', $data ?? [], null);
        $this->setIfExists('cig', $data ?? [], null);
        $this->setIfExists('cup', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('bank_name', $data ?? [], null);
        $this->setIfExists('bank_iban', $data ?? [], null);
        $this->setIfExists('bank_beneficiary', $data ?? [], null);
        $this->setIfExists('invoice_number', $data ?? [], null);
        $this->setIfExists('invoice_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets vat_kind
     *
     * @return string|null
     */
    public function getVatKind()
    {
        return $this->container['vat_kind'];
    }

    /**
     * Sets vat_kind, the accepted values are available in \FattureInCloud\Model\VatKind
     *
     * @param string|null $vat_kind vat_kind
     *
     * @return self
     */
    public function setVatKind($vat_kind)
    {
        if (is_null($vat_kind)) {
            array_push($this->openAPINullablesSetToNull, 'vat_kind');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('vat_kind', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['vat_kind'] = $vat_kind;

        return $this;
    }

    /**
     * Gets original_document_type
     *
     * @return string|null
     */
    public function getOriginalDocumentType()
    {
        return $this->container['original_document_type'];
    }

    /**
     * Sets original_document_type, the accepted values are available in \FattureInCloud\Model\OriginalDocumentType
     *
     * @param string|null $original_document_type original_document_type
     *
     * @return self
     */
    public function setOriginalDocumentType($original_document_type)
    {
        if (is_null($original_document_type)) {
            array_push($this->openAPINullablesSetToNull, 'original_document_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('original_document_type', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['original_document_type'] = $original_document_type;

        return $this;
    }

    /**
     * Gets od_number
     *
     * @return string|null
     */
    public function getOdNumber()
    {
        return $this->container['od_number'];
    }

    /**
     * Sets od_number
     *
     * @param string|null $od_number E-invoice original document number
     *
     * @return self
     */
    public function setOdNumber($od_number)
    {
        if (is_null($od_number)) {
            array_push($this->openAPINullablesSetToNull, 'od_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('od_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['od_number'] = $od_number;

        return $this;
    }

    /**
     * Gets od_date
     *
     * @return \DateTime|null
     */
    public function getOdDate()
    {
        return $this->container['od_date'];
    }

    /**
     * Sets od_date
     *
     * @param \DateTime|null $od_date E-invoice original document date
     *
     * @return self
     */
    public function setOdDate($od_date)
    {
        if (is_null($od_date)) {
            array_push($this->openAPINullablesSetToNull, 'od_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('od_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['od_date'] = $od_date;

        return $this;
    }

    /**
     * Gets cig
     *
     * @return string|null
     */
    public function getCig()
    {
        return $this->container['cig'];
    }

    /**
     * Sets cig
     *
     * @param string|null $cig E-invoice CIG
     *
     * @return self
     */
    public function setCig($cig)
    {
        if (is_null($cig)) {
            array_push($this->openAPINullablesSetToNull, 'cig');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cig', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cig'] = $cig;

        return $this;
    }

    /**
     * Gets cup
     *
     * @return string|null
     */
    public function getCup()
    {
        return $this->container['cup'];
    }

    /**
     * Sets cup
     *
     * @param string|null $cup E-invoice CUP
     *
     * @return self
     */
    public function setCup($cup)
    {
        if (is_null($cup)) {
            array_push($this->openAPINullablesSetToNull, 'cup');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cup', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cup'] = $cup;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method E-invoice payment method [required for e-invoices] (see [here](https://www.fatturapa.gov.it/export/documenti/fatturapa/v1.2.2/Rappresentazione_Tabellare_FattOrdinaria_V1.2.2.pdf) for the accepted values of ModalitaPagamento)
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            array_push($this->openAPINullablesSetToNull, 'payment_method');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('payment_method', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets bank_name
     *
     * @return string|null
     */
    public function getBankName()
    {
        return $this->container['bank_name'];
    }

    /**
     * Sets bank_name
     *
     * @param string|null $bank_name E-invoice bank name
     *
     * @return self
     */
    public function setBankName($bank_name)
    {
        if (is_null($bank_name)) {
            array_push($this->openAPINullablesSetToNull, 'bank_name');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_name', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_name'] = $bank_name;

        return $this;
    }

    /**
     * Gets bank_iban
     *
     * @return string|null
     */
    public function getBankIban()
    {
        return $this->container['bank_iban'];
    }

    /**
     * Sets bank_iban
     *
     * @param string|null $bank_iban E-invoice bank IBAN
     *
     * @return self
     */
    public function setBankIban($bank_iban)
    {
        if (is_null($bank_iban)) {
            array_push($this->openAPINullablesSetToNull, 'bank_iban');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_iban', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_iban'] = $bank_iban;

        return $this;
    }

    /**
     * Gets bank_beneficiary
     *
     * @return string|null
     */
    public function getBankBeneficiary()
    {
        return $this->container['bank_beneficiary'];
    }

    /**
     * Sets bank_beneficiary
     *
     * @param string|null $bank_beneficiary E-invoice bank beneficiary
     *
     * @return self
     */
    public function setBankBeneficiary($bank_beneficiary)
    {
        if (is_null($bank_beneficiary)) {
            array_push($this->openAPINullablesSetToNull, 'bank_beneficiary');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bank_beneficiary', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bank_beneficiary'] = $bank_beneficiary;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number E-invoice invoice number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (is_null($invoice_number)) {
            array_push($this->openAPINullablesSetToNull, 'invoice_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('invoice_number', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets invoice_date
     *
     * @return \DateTime|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoice_date'];
    }

    /**
     * Sets invoice_date
     *
     * @param \DateTime|null $invoice_date E-invoice invoice date
     *
     * @return self
     */
    public function setInvoiceDate($invoice_date)
    {
        if (is_null($invoice_date)) {
            array_push($this->openAPINullablesSetToNull, 'invoice_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('invoice_date', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['invoice_date'] = $invoice_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link     https://fattureincloud.it
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


